/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip.engine;

import com.sas.scheduler.api.servers.ip.engine.ClientLogger;
import com.sas.scheduler.api.servers.ip.engine.ExecutionItem;
import com.sas.scheduler.model.IRecurrenceInfo;
import com.sas.scheduler.model.RecurrenceBaseClass;
import com.sas.scheduler.model.SchedulerException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PredefinedCalendar {
    private String mName = "";
    private String mDescription = "";
    private String mOwnerID = "";
    private String mID = "";
    private IRecurrenceInfo mRecurrence = null;
    private short mAccessFlags = 1;
    static final String XML_ScheduleFile_Tag = "ScheduleFile";
    static final String XML_PredefinedSchedule_Tag = "PredefinedSchedule";
    protected static final String XML_Owner_Tag = "Owner";
    protected static final String XML_Access_Tag = "AccessSpecifiers";
    protected static final String XML_ID_Tag = "ID";
    protected static final String XML_Name_Tag = "Name";
    protected static final String XML_Description_Tag = "Description";
    private static final short ACCESS_PRIVATE = 0;
    private static final short ACCESS_PUBLIC_USE = 1;
    protected ClientLogger mLogger;

    public PredefinedCalendar(ClientLogger logger) {
        this.mLogger = logger;
    }

    public String getOwnerID() {
        return this.mOwnerID;
    }

    public void setOwnerID(String ownerID) {
        if (ownerID != null) {
            this.mOwnerID = ownerID;
        }
    }

    public static PredefinedCalendar createFromXML(BufferedReader xmlReader, ClientLogger logger) throws SchedulerException {
        InputSource source = new InputSource(xmlReader);
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(source);
            NodeList nl = doc.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node node = nl.item(i);
                if (!node.getNodeName().equals(XML_ScheduleFile_Tag)) continue;
                PredefinedCalendar schedule = PredefinedCalendar.processScheduleFileTag(node, logger);
                return schedule;
            }
        }
        catch (SAXException doc) {
        }
        catch (IOException e) {
            SchedulerException se = new SchedulerException();
            se.initCause((Throwable)e);
            throw se;
        }
        catch (ParserConfigurationException e) {
            SchedulerException se = new SchedulerException();
            se.initCause((Throwable)e);
            throw se;
        }
        catch (FactoryConfigurationError e) {
            SchedulerException se = new SchedulerException();
            se.initCause((Throwable)e);
            throw se;
        }
        return null;
    }

    private static PredefinedCalendar processScheduleFileTag(Node topNode, ClientLogger logger) throws SchedulerException {
        NodeList children = topNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!child.getNodeName().equals(XML_PredefinedSchedule_Tag)) continue;
            PredefinedCalendar schedule = PredefinedCalendar.processScheduleTag(child, logger);
            return schedule;
        }
        return null;
    }

    private static PredefinedCalendar processScheduleTag(Node node, ClientLogger logger) throws SchedulerException {
        Node accessNode;
        PredefinedCalendar schedule = new PredefinedCalendar(logger);
        NamedNodeMap attributes = node.getAttributes();
        Node idNode = attributes.getNamedItem(XML_ID_Tag);
        if (idNode != null) {
            schedule.setID(idNode.getNodeValue());
        }
        if ((accessNode = attributes.getNamedItem(XML_Access_Tag)) != null) {
            try {
                schedule.mAccessFlags = Short.valueOf(accessNode.getNodeValue());
            }
            catch (NumberFormatException e) {
                logger.logMessage(Level.WARNING, e);
                schedule.mAccessFlags = 0;
            }
        }
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            String tagValue;
            Node child = children.item(i);
            String tagName = child.getNodeName();
            if (tagName.equals(XML_Name_Tag)) {
                tagValue = ExecutionItem.getCData(child);
                schedule.setName(tagValue);
                continue;
            }
            if (tagName.equals(XML_Description_Tag)) {
                tagValue = ExecutionItem.getCData(child);
                schedule.setDescription(tagValue);
                continue;
            }
            if (tagName.equals(XML_Owner_Tag)) {
                tagValue = ExecutionItem.getCData(child);
                schedule.setOwnerID(tagValue);
                continue;
            }
            if (!tagName.equals("schedule")) continue;
            IRecurrenceInfo recurrence = RecurrenceBaseClass.processScheduleTag((Node)child);
            schedule.setRecurrence(recurrence);
        }
        return schedule;
    }

    public static void serialize(PredefinedCalendar schedule, BufferedWriter writer) throws IOException {
        writer.write("<ScheduleFile>");
        writer.newLine();
        schedule.serialize(writer);
        writer.write("</ScheduleFile>");
        writer.newLine();
    }

    public String getID() {
        return this.mID;
    }

    void setID(String id) {
        if (id != null && id.length() > 0) {
            this.mID = id;
        }
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        if (name != null) {
            this.mName = name;
        }
    }

    public boolean isPubliclyUsable() {
        return (this.mAccessFlags & 1) > 0;
    }

    public void setPubliclyUsable(boolean publiclyUsable) {
        this.mAccessFlags = publiclyUsable ? (short)(this.mAccessFlags | 1) : (short)(this.mAccessFlags & 0xFFFFFFFE);
    }

    public IRecurrenceInfo getRecurrence() {
        return this.mRecurrence;
    }

    public void setRecurrence(IRecurrenceInfo recurrence) {
        this.mRecurrence = recurrence;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public void setDescription(String description) {
        if (description != null) {
            this.mDescription = description;
        }
    }

    public void serialize(BufferedWriter writer) throws IOException {
        writer.write("<PredefinedSchedule ");
        writer.write("ID=\"");
        writer.write(this.mID);
        writer.write("\" ");
        writer.write("AccessSpecifiers=\"" + Short.toString(this.mAccessFlags) + "\" ");
        writer.write(">");
        writer.newLine();
        writer.write("<Name>");
        writer.write("<![CDATA[");
        writer.write(this.mName);
        writer.write("]]>");
        writer.write("</Name>");
        writer.newLine();
        writer.write("<Description>");
        writer.write("<![CDATA[");
        writer.write(this.mDescription);
        writer.write("]]>");
        writer.write("</Description>");
        writer.newLine();
        writer.write(this.mRecurrence.toXML());
        writer.newLine();
        writer.write("<Owner>");
        writer.write("<![CDATA[");
        writer.write(this.mOwnerID);
        writer.write("]]>");
        writer.write("</Owner>");
        writer.newLine();
        writer.write("</PredefinedSchedule>");
        writer.newLine();
    }

    public PredefinedCalendar copy() {
        PredefinedCalendar sched = new PredefinedCalendar(this.mLogger);
        sched.mDescription = this.mDescription;
        sched.mID = this.mID;
        sched.mName = this.mName;
        sched.mOwnerID = this.mOwnerID;
        sched.mAccessFlags = this.mAccessFlags;
        if (this.mRecurrence != null) {
            sched.mRecurrence = this.mRecurrence.copy();
        }
        return sched;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toSerializedForm() {
        StringWriter sw = new StringWriter();
        BufferedWriter writer = new BufferedWriter(sw);
        try {
            PredefinedCalendar.serialize(this, writer);
        }
        catch (IOException e) {
            this.mLogger.logMessage(Level.WARNING, e);
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException e1) {
                this.mLogger.logMessage(Level.WARNING, e1);
            }
        }
        return sw.getBuffer().toString();
    }
}

