/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip.engine;

import com.sas.entities.GUID;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.api.servers.ip.engine.AssociatedAction;
import com.sas.scheduler.api.servers.ip.engine.ClientLogger;
import com.sas.scheduler.api.servers.ip.engine.FlowInstance;
import com.sas.scheduler.api.servers.ip.engine.RunCondition;
import com.sas.scheduler.api.servers.ip.engine.RunConditions;
import com.sas.scheduler.api.servers.ip.engine.RunningItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class ExecutionItem {
    private String mUniqueID = GUID.newGUID();
    private String mUserName = "";
    private RunCondition mRunConditions;
    private String mName;
    private String mDescription;
    private int mMaximumRunTime;
    private List<AssociatedAction> mAssociatedTasks;
    private static Map<String, XMLExecutionItemMapVector> mXMLParseVector = new HashMap<String, XMLExecutionItemMapVector>();
    private int mPriority;
    public static final int Priority_VeryLow = 0;
    public static final int Priority_Low = 25;
    public static final int Priority_Medium = 50;
    public static final int Priority_High = 75;
    public static final int Priority_VeryHigh = 100;
    public static final int Priority_MaxAdjusted = 74;
    protected ClientLogger mLogger;
    public static final String XML_AssociatedActions_Tag = "AssociatedActions";
    public static final String XML_Description_Tag = "Description";
    public static final String XML_MaxRuntime_Tag = "MaxRuntime";
    public static final String XML_User_Tag = "User";
    public static final String XML_Name_Tag = "Name";
    public static final String XML_UniqueID_Tag = "UniqueID";
    public static final String XML_Dependencies_Tag = "Dependencies";
    public static final String XML_Priority_Tag = "Priority";

    public ExecutionItem(ClientLogger logger) {
        this.mLogger = logger;
        this.mRunConditions = new RunConditions(this.mLogger);
        this.mName = "";
        this.mDescription = "";
        this.mMaximumRunTime = 360;
        this.mAssociatedTasks = new ArrayList<AssociatedAction>();
        this.mPriority = 50;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public void setDescription(String description) {
        if (description != null) {
            this.mDescription = description;
        }
    }

    public String getUniqueID() {
        return this.mUniqueID;
    }

    public void setUniqueID(String uniqueID) {
        if (uniqueID != null) {
            this.mUniqueID = uniqueID;
        }
    }

    public int getPriority() {
        return this.mPriority;
    }

    public void setPriority(int priority) {
        if (priority < 0) {
            priority = 0;
        }
        if (priority > 100) {
            priority = 100;
        }
        this.mPriority = priority;
    }

    public void incrementPriority(int extra) {
        this.setPriority(RunningItem.adjustPriority(this.getPriority(), extra));
    }

    public int getMaximumRunTime() {
        return this.mMaximumRunTime;
    }

    public void setMaximumRunTime(int maximumRunTime) {
        if (maximumRunTime >= 0) {
            this.mMaximumRunTime = maximumRunTime;
        }
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        if (name != null) {
            this.mName = name;
        }
    }

    public RunCondition getRunConditions() {
        return this.mRunConditions;
    }

    public void setRunConditions(RunCondition runConditions) {
        if (runConditions != null) {
            this.mRunConditions = runConditions;
        }
    }

    public String getUserName() {
        return this.mUserName;
    }

    public void setUserName(String userName) {
        if (userName != null) {
            this.mUserName = userName;
        }
    }

    public void copyFrom(ExecutionItem source) {
        this.mUserName = source.mUserName;
        this.mName = source.mName;
        this.mUniqueID = source.mUniqueID;
        this.mMaximumRunTime = source.mMaximumRunTime;
        this.mRunConditions = source.mRunConditions.copy();
        this.mAssociatedTasks = new ArrayList<AssociatedAction>();
        this.mDescription = source.mDescription;
        this.mPriority = source.mPriority;
        for (AssociatedAction action : source.getAssociatedTasks()) {
            this.mAssociatedTasks.add(action.copy());
        }
    }

    public List<AssociatedAction> getAssociatedTasks() {
        return this.mAssociatedTasks;
    }

    public void setAssociatedTasks(List<AssociatedAction> associatedTasks) {
        if (associatedTasks != null) {
            this.mAssociatedTasks = associatedTasks;
        }
    }

    protected void injectXML(Document doc, Element element) {
        CDATASection cData;
        Element tag;
        element.setAttribute(XML_MaxRuntime_Tag, Integer.toString(this.getMaximumRunTime()));
        element.setAttribute(XML_UniqueID_Tag, this.getUniqueID());
        element.setAttribute(XML_Priority_Tag, Integer.toString(this.mPriority));
        if (this.getName().length() > 0) {
            tag = doc.createElement(XML_Name_Tag);
            cData = doc.createCDATASection(this.getName());
            tag.appendChild(cData);
            element.appendChild(tag);
        }
        if (this.getDescription().length() > 0) {
            tag = doc.createElement(XML_Description_Tag);
            String description = this.getDescription();
            if (description.contains("\n")) {
                description = MetaUtilities.replaceString(description, "\n", " ");
            }
            CDATASection cData2 = doc.createCDATASection(description);
            tag.appendChild(cData2);
            element.appendChild(tag);
        }
        if (this.getUserName().length() > 0) {
            tag = doc.createElement(XML_User_Tag);
            cData = doc.createCDATASection(this.getUserName());
            tag.appendChild(cData);
            element.appendChild(tag);
        }
        Element depsTag = doc.createElement(XML_Dependencies_Tag);
        element.appendChild(depsTag);
        this.getRunConditions().serialize(doc, depsTag);
        if (this.getAssociatedTasks().size() > 0) {
            Element actionsTag = doc.createElement(XML_AssociatedActions_Tag);
            element.appendChild(actionsTag);
            for (AssociatedAction action : this.getAssociatedTasks()) {
                action.serialize(doc, actionsTag);
            }
        }
    }

    public static int getIntFromNodeMap(NamedNodeMap nodeMap, String attr, int defaultValue, ClientLogger logger) {
        Node node = nodeMap.getNamedItem(attr);
        if (node != null) {
            try {
                return Integer.parseInt(node.getNodeValue());
            }
            catch (NumberFormatException e) {
                logger.logMessage(Level.WARNING, e);
            }
        }
        return defaultValue;
    }

    protected static void processExecutionItemTag(ExecutionItem item, Node node) {
        NamedNodeMap attributes = node.getAttributes();
        Node uniqueIDNode = attributes.getNamedItem(XML_UniqueID_Tag);
        if (uniqueIDNode != null) {
            item.setUniqueID(uniqueIDNode.getNodeValue());
        }
        item.setMaximumRunTime(ExecutionItem.getIntFromNodeMap(attributes, XML_MaxRuntime_Tag, 360, item.getLogger()));
        item.setPriority(ExecutionItem.getIntFromNodeMap(attributes, XML_Priority_Tag, 50, item.getLogger()));
        NodeList children = node.getChildNodes();
        int listLength = children.getLength();
        for (int i = 0; i < listLength; ++i) {
            Node child = children.item(i);
            String tagName = child.getNodeName();
            XMLExecutionItemMapVector vectorItem = mXMLParseVector.get(tagName);
            if (vectorItem == null) continue;
            vectorItem.doOperation(child, item);
        }
    }

    public static String getCData(Node node) {
        if (!node.hasChildNodes()) {
            return "";
        }
        NodeList children = node.getChildNodes();
        int listLength = children.getLength();
        StringBuffer data = new StringBuffer();
        for (int i = 0; i < listLength; ++i) {
            Node child = children.item(i);
            if (child == null) continue;
            data.append(child.getNodeValue());
        }
        return data.toString();
    }

    public ClientLogger getLogger() {
        return this.mLogger;
    }

    protected abstract void serialize(Document var1, Node var2);

    public String toSerializedForm() {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.newDocument();
            this.serialize(doc, doc);
            return FlowInstance.emitXML(doc, this.mLogger);
        }
        catch (ParserConfigurationException e) {
            this.mLogger.logMessage(Level.WARNING, e);
            return "";
        }
    }

    public final int hashCode() {
        return this.toSerializedForm().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ExecutionItem)) {
            return false;
        }
        ExecutionItem otherItem = (ExecutionItem)obj;
        if (!otherItem.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (!otherItem.getName().equals(this.getName())) {
            return false;
        }
        if (!otherItem.getName().equals(this.getName())) {
            return false;
        }
        if (!otherItem.getUniqueID().equals(this.getUniqueID())) {
            return false;
        }
        if (!otherItem.getUserName().equals(this.getUserName())) {
            return false;
        }
        if (otherItem.getMaximumRunTime() != this.getMaximumRunTime()) {
            return false;
        }
        if (otherItem.getPriority() != this.getPriority()) {
            return false;
        }
        if (!otherItem.getRunConditions().equals(this.mRunConditions)) {
            return false;
        }
        return otherItem.getAssociatedTasks().equals(this.mAssociatedTasks);
    }

    static {
        mXMLParseVector.put(XML_Name_Tag, new XMLExecutionItemMapVector(){

            @Override
            public void doOperation(Node node, ExecutionItem targetItem) {
                String tagValue = ExecutionItem.getCData(node);
                targetItem.setName(tagValue);
            }
        });
        mXMLParseVector.put(XML_User_Tag, new XMLExecutionItemMapVector(){

            @Override
            public void doOperation(Node node, ExecutionItem targetItem) {
                String tagValue = ExecutionItem.getCData(node);
                targetItem.setUserName(tagValue);
            }
        });
        mXMLParseVector.put(XML_Description_Tag, new XMLExecutionItemMapVector(){

            @Override
            public void doOperation(Node node, ExecutionItem targetItem) {
                String tagValue = ExecutionItem.getCData(node);
                targetItem.setDescription(tagValue);
            }
        });
        mXMLParseVector.put(XML_Dependencies_Tag, new XMLExecutionItemMapVector(){

            @Override
            public void doOperation(Node node, ExecutionItem targetItem) {
                RunCondition dependencies = RunCondition.processCondition(node, targetItem.getLogger());
                if (dependencies != null) {
                    targetItem.setRunConditions(dependencies);
                }
            }
        });
        mXMLParseVector.put(XML_AssociatedActions_Tag, new XMLExecutionItemMapVector(){

            @Override
            public void doOperation(Node node, ExecutionItem targetItem) {
                List<AssociatedAction> tasks = AssociatedAction.processActions(node);
                targetItem.setAssociatedTasks(tasks);
            }
        });
    }

    private static interface XMLExecutionItemMapVector {
        public void doOperation(Node var1, ExecutionItem var2);
    }
}

