/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip;

import com.sas.metadata.remote.MdObjectStore;
import com.sas.net.crypto.SealedString;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.api.servers.IConsole;
import com.sas.scheduler.api.servers.ip.IPFlowHistory;
import com.sas.scheduler.api.servers.ip.IPScheduler;
import com.sas.scheduler.api.servers.ip.SchedulerInitializationCallback;
import com.sas.scheduler.api.servers.ip.engine.AbstractUserSession;
import com.sas.scheduler.api.servers.ip.engine.ClientLogger;
import com.sas.scheduler.api.servers.ip.engine.ExecutionProvider;
import com.sas.scheduler.api.servers.ip.engine.FlowHistory;
import com.sas.scheduler.api.servers.ip.engine.FlowManager;
import com.sas.scheduler.api.servers.ip.engine.HistorySearchOptions;
import com.sas.scheduler.api.servers.ip.engine.JobHistory;
import com.sas.scheduler.api.servers.ip.engine.JobRendererInfo;
import com.sas.scheduler.api.servers.ip.engine.RunCondition;
import com.sas.scheduler.api.servers.ip.engine.RunHistory;
import com.sas.scheduler.api.servers.ip.engine.TopLevelFlow;
import com.sas.scheduler.api.servers.ip.engine.TopLevelFlowIDInfo;
import com.sas.scheduler.api.servers.ip.engine.mq.JMSClusterSupport;
import com.sas.scheduler.api.servers.ip.engine.mq.PIPNonMasterExecutionProvider;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.ScheduledFlowInfo;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.SchedulerServerInfo;
import com.sas.scheduler.model.TriggerEventInfo;
import java.net.PasswordAuthentication;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;

public class PIPScheduler
extends IPScheduler
implements IConsole {
    public static final String PropAddress = "PIP.JGroupsMulticastAddress";
    public static final String PropIPTTL = "PIP.JGroupsMulticastTTL";
    public static final String PropMainPort = "PIP.JGroupsPort_MainChannelPort";
    public static final String PropHashPort = "PIP.JGroupsPort_HashChannelPort";
    public static final String PropClusterName = "PIP.JGroupsClusterName";
    public static final String PropJMSNamingProviderURL = "java.naming.provider.url";
    public static final String PropJMSFactory = "java.naming.factory.initial";
    public static final String PropMaxRunFlows = "PIP.MaxFlowsRunningInSystem";
    public static final String PropMaxRunJobs = "PIP.MaxJobsRunningInSystem";
    public static final String PropMaxHistory = "PIP.MaxHistoriesPerFlow";
    public static final String PropPersistenceName = "PIP.PersistenceName";
    public static final String PropFileTrigger = "PIP.FileTriggerCheckFrequencyMS";
    public static final String PropOutputLimit = "PIP.OutputLimit";
    public static final String PropJobPollFrequency = "PIP.JobPollFrequency";
    public static final String PropMaxJobs = "MaxJobs";
    public static final String PropJobCountBeforeWait = "JobCountBeforeWait";
    public static final String PropMaxWait = "MaxWaitTimeMS";
    public static final String PropBaseWait = "BaseWaitTimeMS";
    private ClientLogger mLogger;
    public static final String User = "Anonymous";
    public static final String Password = "Anonymous";
    protected static Map<String, AbstractUserSession> mConnectionMap = new HashMap<String, AbstractUserSession>();
    protected Properties mConfiguration;

    public PIPScheduler(SchedulerServerInfo info, ClientLogger logger, Properties configInfo) {
        super(info);
        this.mLogger = logger;
        this.mConfiguration = configInfo;
        if (MetaUtilities.isDebug()) {
            FlowManager.setDefaultLogLevel(Level.FINEST);
        }
        if (PIPScheduler.getCachedSession(this.m_schedulingServer) == null) {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    ExecutionProvider newServiceProvider = PIPScheduler.this.createServiceProvider();
                    PIPScheduler.this.swapInServiceProvider(newServiceProvider);
                }
            });
            t.start();
        }
    }

    public Properties getServerProperties() {
        Properties props = PIPScheduler.getCachedSession(this.m_schedulingServer).getFlowManager().getServerConfig();
        Properties copy = new Properties();
        copy.putAll((Map<?, ?>)props);
        return copy;
    }

    @Override
    public void initializeScheduler(ExecutionProvider serviceProvider, ClientLogger logger, SchedulerInitializationCallback initCallback) throws SecurityException {
        ExecutionProvider newServiceProvider;
        if (PIPScheduler.getCachedSession(this.m_schedulingServer) != null) {
            return;
        }
        if (this.isDebug()) {
            FlowManager.setDefaultLogLevel(Level.FINEST);
        }
        if ((newServiceProvider = serviceProvider) == null) {
            newServiceProvider = this.createServiceProvider();
        }
        this.swapInServiceProvider(newServiceProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AbstractUserSession getCachedSession(SchedulerServerInfo ssi) {
        if (ssi == null) {
            return null;
        }
        Map<String, AbstractUserSession> map = mConnectionMap;
        synchronized (map) {
            return mConnectionMap.get(ssi.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutionProvider getServiceProvider() {
        PIPScheduler pIPScheduler = this;
        synchronized (pIPScheduler) {
            AbstractUserSession session = PIPScheduler.getCachedSession(this.m_schedulingServer);
            if (session != null) {
                return session.getFlowManager().getExecutionProvider();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void swapInServiceProvider(ExecutionProvider newServiceProvider) {
        PIPScheduler pIPScheduler = this;
        synchronized (pIPScheduler) {
            if (this.getServiceProvider() != null) {
                newServiceProvider.getClusteringServer().cleanup();
            } else {
                FlowManager manager = FlowManager.createFlowManager(newServiceProvider, this.mLogger);
                AbstractUserSession session = manager.createSession("Anonymous", "Anonymous" != null ? new SealedString("Anonymous") : null);
                mConnectionMap.put(this.m_schedulingServer.getId(), session);
            }
        }
    }

    protected ExecutionProvider createServiceProvider() {
        JMSClusterSupport cluster = null;
        String clusterName = this.mConfiguration.getProperty(PropClusterName, "D-IPScheduler");
        cluster = new JMSClusterSupport(this.mConfiguration, clusterName, false);
        PIPNonMasterExecutionProvider serviceProvider = new PIPNonMasterExecutionProvider(FlowManager.getDefaultLogger(), cluster);
        return serviceProvider;
    }

    @Override
    public AbstractUserSession getUserSession() {
        AbstractUserSession session = PIPScheduler.getCachedSession(this.m_schedulingServer);
        if (session != null) {
            return session;
        }
        this.maketheConnection(this.m_schedulingServer.getUsername(), this.getSchServerInfoPasswordSealedString());
        return PIPScheduler.getCachedSession(this.m_schedulingServer);
    }

    @Override
    @Deprecated
    protected boolean maketheConnection(String user, String pass) {
        return this.maketheConnection(user, pass != null ? new SealedString(pass) : null);
    }

    @Override
    protected boolean maketheConnection(String user, SealedString pass) {
        if (user == null) {
            return false;
        }
        if (pass == null) {
            pass = new SealedString("Anonymous");
        }
        this.m_schedulingServer.setUsername(user);
        if (MetaUtilities.isAllowPasswordCache()) {
            this.m_schedulingServer.setPassword(String.valueOf(pass.getCharacters()));
        }
        if (PIPScheduler.getCachedSession(this.m_schedulingServer) != null) {
            return true;
        }
        this.initializeScheduler(this.getServiceProvider(), this.mLogger, null);
        return PIPScheduler.getCachedSession(this.m_schedulingServer) != null;
    }

    public static FlowManager getFlowManager(SchedulerServerInfo ssi) {
        AbstractUserSession session = PIPScheduler.getCachedSession(ssi);
        if (session != null) {
            return session.getFlowManager();
        }
        return null;
    }

    @Override
    public int getMaxFlowHistoryCount() throws SchedulerException {
        AbstractUserSession session = PIPScheduler.getCachedSession(this.m_schedulingServer);
        if (session != null) {
            return session.getFlowManager().getMaxHistoryRecordsPerFlow();
        }
        return 10;
    }

    @Override
    public boolean isFlowScheduled(FlowInfo flow) {
        if (this.getUserSession() == null) {
            return flow.isFlowSubmitted();
        }
        return this.isFlowScheduled(flow.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean scheduleFlow(FlowInfo flow) throws SchedulerException, UnsupportedOperationException, InvalidParameterException {
        AbstractUserSession abstractUserSession = this.getUserSession();
        synchronized (abstractUserSession) {
            boolean rc = this.scheduleFlowInternal(flow, false, true, false);
            String flowId = this.getUserSession().getFlowID(flow.getName());
            flow.setFlowDefinitionIdDataBinding(flowId);
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean scheduleFlowNow(FlowInfo flow) throws SchedulerException, UnsupportedOperationException, InvalidParameterException {
        AbstractUserSession abstractUserSession = this.getUserSession();
        synchronized (abstractUserSession) {
            return this.scheduleFlowInternal(flow, true, true, false);
        }
    }

    @Override
    public int rescheduleFlow(FlowInfo flow, boolean errorOnDelete) throws SchedulerException, UnsupportedOperationException {
        boolean success = true;
        try {
            TopLevelFlow topFlow = (TopLevelFlow)this.processFlow(flow, true);
            TriggerEventInfo trigger = flow.getTriggerEvent();
            String triggerType = flow.getTriggerType();
            if (triggerType == null || triggerType.equals("RunNow") || triggerType.equals("Manual")) {
                trigger = null;
            }
            String flowID = this.getUserSession().getFlowID(flow.getName());
            flow.setScheduleDefinitionId(flowID);
            TopLevelFlow[] existingFlows = new TopLevelFlow[]{};
            existingFlows = this.getUserSession().getFlowDefinitions(new String[]{flowID});
            if (existingFlows.length <= 0) {
                return 1;
            }
            topFlow.setID(flowID);
            if (trigger != null && trigger.getEvent() != null) {
                RunCondition condition = this.getTriggeringEvent(trigger);
                if (condition != null) {
                    topFlow.setTriggerConditions(condition);
                } else {
                    success = false;
                }
            }
            if (success) {
                boolean pushedToScheduler = false;
                if (flowID.length() > 0 && existingFlows.length > 0) {
                    pushedToScheduler = this.getUserSession().updateFlow(topFlow);
                } else if (errorOnDelete) {
                    success = false;
                } else {
                    String[] ids = this.getUserSession().addFlows(new TopLevelFlow[]{topFlow});
                    boolean bl = pushedToScheduler = ids[0] != null;
                    if (pushedToScheduler) {
                        flowID = ids[0];
                        flow.setScheduleDefinitionId(flowID);
                    }
                }
                if (pushedToScheduler) {
                    flow.setFlowSubmitted(true, this.getCurrentUserID());
                } else {
                    success = false;
                }
            }
            return success ? 0 : 2;
        }
        catch (RuntimeException ioe) {
            SchedulerException ex = new SchedulerException(ioe.getLocalizedMessage());
            ex.initCause((Throwable)ioe);
            throw ex;
        }
    }

    @Override
    public void redeployAllFlows(SchedulerInitializationCallback initCallback) {
        if (initCallback == null) {
            return;
        }
        try {
            this.maketheConnection();
        }
        catch (SchedulerException e) {
            return;
        }
        if (PIPScheduler.getCachedSession(this.m_schedulingServer) != null) {
            super.redeployAllFlows(initCallback);
        }
    }

    public static void redeployAllFlowsFromMetadata(SchedulerServerInfo ssi, final ClientLogger logger, final MdObjectStore store) {
        final long startTime = System.currentTimeMillis();
        try {
            PIPScheduler scheduler = (PIPScheduler)MetaUtilities.getSchedulingServer(ssi, store);
            scheduler.redeployAllFlows(new SchedulerInitializationCallback(){

                @Override
                public void schedulerInitializationCompleted() {
                    long endTime = System.currentTimeMillis();
                    logger.logMessage(Level.INFO, "Flows redeployed from metadata server (seconds): " + (endTime - startTime) / 1000L);
                }

                @Override
                public String[] getSchedulerCredentials(FlowInfo flow) {
                    return new String[]{"Anonymous", "Anonymous"};
                }

                public PasswordAuthentication getSchedulerPasswordAuthentication(FlowInfo flow) {
                    return new PasswordAuthentication("Anonymous", "Anonymous".toCharArray());
                }

                @Override
                public MdObjectStore getJomaStore() {
                    return store;
                }
            });
        }
        catch (SchedulerException e) {
            logger.logMessage(Level.WARNING, e);
        }
    }

    @Override
    public String getCurrentUserID() {
        return this.m_schedulingServer.getUsername();
    }

    @Override
    public String getClassId() {
        return "c8b4baf0-5f9f-488e-ba76-1201e1e81aef";
    }

    @Override
    public List<com.sas.scheduler.model.JobRendererInfo> getJobRenderers(String schId) {
        ArrayList<com.sas.scheduler.model.JobRendererInfo> list = new ArrayList<com.sas.scheduler.model.JobRendererInfo>();
        Collection<JobRendererInfo> l = this.getUserSession().getFlowManager().getJobRendererSnapshots();
        for (JobRendererInfo jr : l) {
            com.sas.scheduler.model.JobRendererInfo info = new com.sas.scheduler.model.JobRendererInfo(jr.getRendererName(), jr.getApplicationIDs(), jr.getLastHeartBeatTime(), jr.getActiveJobCount(), jr.getCumulativeJobCount(), jr.getUptime());
            list.add(info);
        }
        this.mLogger.logMessage(Level.FINER, "JobRenderers list size is: " + list.size());
        return list;
    }

    @Override
    public List<ScheduledFlowInfo> getScheduledFlows(String id, String user) {
        ArrayList<ScheduledFlowInfo> list = new ArrayList<ScheduledFlowInfo>();
        TopLevelFlowIDInfo[] ids = this.getUserSession().getAllFlowIDs();
        for (int i = 0; i < ids.length; ++i) {
            TopLevelFlowIDInfo idInfo = ids[i];
            TopLevelFlow[] existing = this.getUserSession().getFlowDefinitions(new String[]{idInfo.getID()});
            if (existing == null || existing.length != 1) continue;
            TopLevelFlow flow = existing[0];
            String triggerId = flow.getTriggerConditions().getID();
            ScheduledFlowInfo info = new ScheduledFlowInfo(idInfo.getName(), idInfo.getID(), flow.getUserName(), triggerId);
            info.setDisplayOnly(idInfo.isHeld());
            if (list.contains(info)) continue;
            list.add(info);
        }
        return list;
    }

    @Override
    public List<com.sas.scheduler.model.RunHistory> getRunningJobs(String id, String user) {
        FlowHistory[] snapshots;
        ArrayList<com.sas.scheduler.model.RunHistory> list = new ArrayList<com.sas.scheduler.model.RunHistory>();
        HistorySearchOptions options = new HistorySearchOptions();
        options.setCompletionStatusMask(8);
        for (FlowHistory flowHistory : snapshots = this.getUserSession().getFlowHistory(options)) {
            ArrayList<JobHistory> jobs = new ArrayList<JobHistory>();
            this.addJobHistories(flowHistory, jobs);
            String flowName = flowHistory.getItemName();
            if (flowName.length() == 0) {
                flowName = flowHistory.getFlowID();
            }
            for (JobHistory job : jobs) {
                com.sas.scheduler.model.RunHistory hist;
                String userName = job.getUserName();
                if (userName == null || userName.isEmpty()) {
                    userName = user;
                }
                if (user != null && user.equals(userName)) {
                    hist = new com.sas.scheduler.model.RunHistory();
                    hist.setUserNameDataBinding(job.getUserName());
                    hist.setStartTimeDataBinding(job.getStartTime());
                    hist.setItemNameDataBinding(job.getItemName());
                    hist.setUniqueIdDataBinding(job.getUniqueID());
                    hist.setFinishTimeDataBinding(job.getFinishTime());
                    hist.setCompletionCodeDataBinding(job.getCompletionCode());
                    hist.setRetryAttemptsDataBinding(job.getRetryAttempts());
                    hist.setParentNameDataBinding(flowName);
                    hist.setRendererDataBinding(job.getJobType());
                    list.add(hist);
                    continue;
                }
                if (user != null) continue;
                hist = new com.sas.scheduler.model.RunHistory();
                hist.setUserNameDataBinding(job.getUserName());
                hist.setStartTimeDataBinding(job.getStartTime());
                hist.setItemNameDataBinding(job.getItemName());
                hist.setUniqueIdDataBinding(job.getUniqueID());
                hist.setFinishTimeDataBinding(job.getFinishTime());
                hist.setCompletionCodeDataBinding(job.getCompletionCode());
                hist.setRetryAttemptsDataBinding(job.getRetryAttempts());
                hist.setParentNameDataBinding(flowName);
                hist.setRendererDataBinding(job.getJobType());
                list.add(hist);
            }
        }
        return list;
    }

    private void addJobHistories(FlowHistory flowHistory, List<JobHistory> outputJobs) {
        List<RunHistory> children = flowHistory.getSubHistories();
        for (RunHistory runHistory : children) {
            if (runHistory instanceof JobHistory) {
                if (((JobHistory)runHistory).getCompletionCode() != 8) continue;
                outputJobs.add((JobHistory)runHistory);
                continue;
            }
            this.addJobHistories((FlowHistory)runHistory, outputJobs);
        }
    }

    @Override
    public boolean triggerFlow(String id) {
        try {
            TopLevelFlow[] existingFlows = new TopLevelFlow[]{};
            existingFlows = this.getUserSession().getFlowDefinitions(new String[]{id});
            if (id.length() > 0 && existingFlows.length > 0) {
                ArrayList<String> targets = new ArrayList<String>();
                targets.add(id);
                String[] results = this.getUserSession().runFlows(targets.toArray(new String[0]));
                return results.length > 0;
            }
        }
        catch (InvalidParameterException e) {
            this.mLogger.logMessage(Level.WARNING, e);
        }
        catch (UnsupportedOperationException e) {
            this.mLogger.logMessage(Level.WARNING, e);
        }
        return false;
    }

    @Override
    public boolean deleteFlow(String id) {
        String[] flowIDs = new String[]{id};
        String[] ids = this.getUserSession().deleteFlows(flowIDs);
        return ids.length == 0;
    }

    @Override
    public boolean holdFlow(String flowDefinition) {
        String[] flowIDs = new String[]{flowDefinition};
        String[] ids = this.getUserSession().holdFlows(flowIDs);
        return ids.length == 0;
    }

    @Override
    public boolean releaseFlow(String flowDefinition) {
        String[] flowIDs = new String[]{flowDefinition};
        String[] ids = this.getUserSession().releaseFlows(flowIDs);
        return ids.length == 0;
    }

    @Override
    public boolean killItemInstance(String flowInstance, String itemInstance) throws SchedulerException {
        return false;
    }

    @Override
    public boolean killFlowInstance(String flowInstance) {
        String[] flowIDs = new String[]{flowInstance};
        String[] ids = this.getUserSession().killFlowInstances(flowIDs, true);
        return ids.length == 0;
    }

    @Override
    public boolean pauseFlowInstance(String flowInstance) {
        String[] flowIDs = new String[]{flowInstance};
        String[] ids = this.getUserSession().holdFlows(flowIDs);
        return ids.length == 0;
    }

    @Override
    public boolean resumeFlowInstance(String flowInstance) {
        String[] flowIDs = new String[]{flowInstance};
        String[] ids = this.getUserSession().releaseFlows(flowIDs);
        return ids.length == 0;
    }

    @Override
    public StringBuffer getStandardOut(String flowInstance, String jobInstance) {
        String sessionID = this.getUserSession().getSessionID();
        String flowID = this.getUserSession().getFlowID(flowInstance);
        String instance = flowInstance;
        String uniqueSubitemID = jobInstance;
        long startPos = 0L;
        int maxCharacters = 1024;
        StringBuffer buffer = new StringBuffer();
        this.getUserSession().getFlowManager().getOutputStreamData(sessionID, flowID, instance, uniqueSubitemID, startPos, maxCharacters, buffer);
        return buffer;
    }

    @Override
    public StringBuffer getStandardError(String flowInstance, String jobInstance) {
        String sessionID = this.getUserSession().getSessionID();
        String flowID = this.getUserSession().getFlowID(flowInstance);
        String instance = flowInstance;
        String uniqueSubitemID = jobInstance;
        long startPos = 0L;
        int maxCharacters = 1024;
        StringBuffer buffer = new StringBuffer();
        this.getUserSession().getFlowManager().getErrorStreamData(sessionID, flowID, instance, uniqueSubitemID, startPos, maxCharacters, buffer);
        return buffer;
    }

    @Override
    public String getFlowDefinition(String flowDefId) throws SchedulerException {
        TopLevelFlow def;
        TopLevelFlow[] flowDefs = this.getUserSession().getFlowDefinitions(new String[]{flowDefId});
        TopLevelFlow topLevelFlow = def = flowDefs.length > 0 ? flowDefs[0] : null;
        if (def != null) {
            return def.toSerializedForm();
        }
        return "";
    }

    @Override
    public List<com.sas.scheduler.api.servers.FlowHistory> getFlowHistoryList(String flowname, String userid, int count) throws SchedulerException {
        ArrayList<com.sas.scheduler.api.servers.FlowHistory> flowHistories = new ArrayList<com.sas.scheduler.api.servers.FlowHistory>();
        if (this.getUserSession() == null) {
            return flowHistories;
        }
        if (count < 0) {
            return flowHistories;
        }
        HistorySearchOptions searchOptions = new HistorySearchOptions();
        searchOptions.setCountPerFlow(count);
        searchOptions.setOwner(userid);
        FlowHistory[] histories = this.getUserSession().getFlowHistory(searchOptions);
        for (int i = 0; i < histories.length; ++i) {
            if (!histories[i].getItemName().equals(flowname)) continue;
            IPFlowHistory history = new IPFlowHistory(histories[i].getItemName(), histories[i]);
            flowHistories.add(history);
        }
        return flowHistories;
    }
}

