/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.oma;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Event;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SyncStep;
import com.sas.scheduler.api.oma.DeployedFlow;
import com.sas.scheduler.api.oma.EventListItem;
import com.sas.scheduler.api.oma.FileEvent;
import com.sas.scheduler.api.oma.GroupingEvent;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.api.oma.TimeEvent;
import com.sas.scheduler.api.servers.Calendar;
import com.sas.scheduler.api.servers.Scheduler;
import com.sas.scheduler.model.AbstractEventInfo;
import com.sas.scheduler.model.AbstractEventInterface;
import com.sas.scheduler.model.DisplayInfo;
import com.sas.scheduler.model.FileEventInfo;
import com.sas.scheduler.model.GroupingEventInfo;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.TimeEventInfo;
import com.sas.scheduler.model.TriggerEventInfo;
import java.rmi.RemoteException;
import java.util.ResourceBundle;

public class TriggerEvent
implements AbstractEventInterface {
    private static final ResourceBundle m_bundle = MetaUtilities.getMyResourceBundle(TriggerEvent.class);
    private Event m_objEvent;
    private SyncStep m_event;
    private String m_strType;
    private Scheduler m_scheduler;
    private String m_definition;
    private String m_name;
    private String m_description;

    public TriggerEvent(DeployedFlow flow, String name, String strType) throws SchedulerException {
        this(flow.getSchedulingServer(), name, strType);
    }

    public TriggerEvent(DeployedFlow flow, Event event) throws SchedulerException, RemoteException {
        this(flow.getSchedulingServer(), event);
    }

    public TriggerEvent(Scheduler scheduler, String name, String strType) {
        this.m_scheduler = scheduler;
        this.m_name = name;
        this.m_objEvent = null;
        this.m_strType = strType;
    }

    public TriggerEvent(Scheduler scheduler, Event event) throws RemoteException {
        this(TriggerEvent.makeValidTriggerName(event.getCondition(), scheduler != null ? scheduler.getClassId() : null), scheduler, event);
    }

    public TriggerEvent(String name, Scheduler scheduler, Event event) throws RemoteException {
        this.m_scheduler = scheduler;
        this.m_objEvent = event;
        this.m_event = null;
        this.m_name = name;
        this.m_strType = "Event";
        try {
            this.m_definition = MetaUtilities.getProperty((Root)event, "Definition");
        }
        catch (MdException e) {
            this.m_definition = event.getCondition();
        }
    }

    public TriggerEvent(String name, Scheduler scheduler, SyncStep event) throws RemoteException {
        this.m_scheduler = scheduler;
        this.m_objEvent = null;
        this.m_event = event;
        this.m_name = name;
        this.m_strType = "Event";
    }

    public TriggerEvent(TriggerEventInfo info) throws RemoteException, SchedulerException {
        this.m_scheduler = MetaUtilities.getSchedulingServer(info.getScheduler());
        this.m_objEvent = null;
        this.m_event = null;
        this.m_name = info.getName();
        this.m_strType = null;
    }

    public TriggerEvent(TriggerEventInfo info, MdObjectStore store, String repos) throws RemoteException, SchedulerException {
        this(info, MetaUtilities.getSchedulingServer(info.getScheduler(), store), store, repos);
    }

    public TriggerEvent(TriggerEventInfo info, Scheduler scheduler, MdObjectStore store, String repos) throws RemoteException, SchedulerException {
        block48: {
            this.m_scheduler = scheduler;
            this.m_name = info.getName();
            this.setDescription(info.getDescription());
            String reposID = repos.length() > 8 ? repos : "A0000001." + repos;
            AbstractEventInfo obj = info.getEvent();
            if (obj == null) {
                this.m_objEvent = null;
                this.m_event = null;
                this.m_strType = info.getType();
            } else if (obj instanceof GroupingEventInfo) {
                GroupingEventInfo gei = (GroupingEventInfo)obj;
                try {
                    this.m_event = MetaUtilities.getTrigger(info, this.m_scheduler, store, repos);
                    if (this.m_event != null) {
                        this.m_event.getTriggeringEvents().clear();
                    }
                    this.m_objEvent = null;
                    this.m_strType = "Event";
                    for (DisplayInfo di : gei.getDependencies2()) {
                        Event e = null;
                        if (di instanceof TimeEventInfo) {
                            TimeEventInfo tei = (TimeEventInfo)di;
                            TimeEvent te = new TimeEvent(tei, this.m_scheduler);
                            Calendar cal = te.getCalendar();
                            if (cal == null && this.m_scheduler != null) {
                                cal = this.m_scheduler.createCalendar(tei.getRecurrence());
                            }
                            if (cal != null) {
                                e = MetaUtilities.getTriggerEvent(di, this.m_scheduler, store, reposID);
                            }
                        } else if (di instanceof FileEventInfo) {
                            e = MetaUtilities.getTriggerEvent(di, this.m_scheduler, store, reposID);
                        }
                        if (e == null || this.m_event == null) continue;
                        this.m_event.getTriggeringEvents().add((Object)e);
                    }
                    if (this.m_event != null) {
                        info.setId(this.m_event.getFQID());
                        switch (gei.getEventType()) {
                            case 0: {
                                this.m_event.setTransformRole("AND");
                                break;
                            }
                            default: {
                                this.m_event.setTransformRole("OR");
                                break;
                            }
                        }
                        break block48;
                    }
                    info.setId(null);
                }
                catch (MdException ex) {
                    this.m_event = null;
                }
                catch (RuntimeException ex) {
                    this.m_event = null;
                }
            } else if (obj instanceof TimeEventInfo) {
                TimeEventInfo tei = (TimeEventInfo)obj;
                TimeEvent te = new TimeEvent(tei, this.m_scheduler);
                Calendar cal = te.getCalendar();
                if (cal == null && this.m_scheduler != null) {
                    cal = this.m_scheduler.createCalendar(tei.getRecurrence());
                }
                if (cal != null) {
                    try {
                        this.m_objEvent = MetaUtilities.getTriggerEvent(info, this.m_scheduler, store, reposID);
                        if (this.m_objEvent == null) {
                            this.m_objEvent = (Event)store.getObject(info.getId());
                        }
                    }
                    catch (MdException ex) {
                        this.m_objEvent = null;
                    }
                    catch (RuntimeException ex) {
                        this.m_objEvent = null;
                    }
                } else {
                    this.m_objEvent = null;
                }
                if (this.m_objEvent != null) {
                    try {
                        this.m_definition = MetaUtilities.getProperty((Root)this.m_objEvent, "Definition");
                    }
                    catch (MdException e) {
                        this.m_definition = this.m_objEvent.getCondition();
                    }
                } else {
                    try {
                        String reposId = repos;
                        if (repos.length() > 8) {
                            reposId = repos.substring(9);
                        }
                        this.m_objEvent = MetaUtilities.createTriggerEventObject((DisplayInfo)((TimeEventInfo)obj), this.m_scheduler, store, reposId);
                    }
                    catch (MdException ex) {
                        this.m_objEvent = null;
                    }
                    catch (RuntimeException ex) {
                        this.m_objEvent = null;
                    }
                }
                this.m_strType = "Event";
            } else if (obj instanceof FileEventInfo) {
                try {
                    this.m_objEvent = MetaUtilities.getTriggerEvent(info, store, reposID);
                    if (this.m_objEvent == null) {
                        this.m_objEvent = (Event)store.getObject(info.getId());
                    }
                }
                catch (MdException ex) {
                    this.m_objEvent = null;
                }
                catch (RuntimeException ex) {
                    this.m_objEvent = null;
                }
                if (this.m_objEvent != null) {
                    try {
                        this.m_definition = MetaUtilities.getProperty((Root)this.m_objEvent, "Definition");
                    }
                    catch (MdException e) {
                        this.m_definition = this.m_objEvent.getCondition();
                    }
                } else {
                    try {
                        this.m_objEvent = MetaUtilities.createTriggerEventObject((DisplayInfo)((FileEventInfo)obj), this.m_scheduler, store, repos);
                    }
                    catch (MdException ex) {
                        this.m_objEvent = null;
                    }
                    catch (RuntimeException ex) {
                        this.m_objEvent = null;
                    }
                }
                this.m_strType = "Event";
            } else {
                this.m_event = null;
                this.m_objEvent = null;
                this.m_name = null;
                this.m_strType = null;
            }
        }
    }

    public static String makeValidTriggerName(String condition, String classid) throws RemoteException {
        return TriggerEventInfo.makeValidTriggerName((String)condition, (String)classid);
    }

    public String toString() {
        return this.m_name;
    }

    public String getId() throws RemoteException {
        if (this.m_objEvent != null) {
            return this.m_objEvent.getId();
        }
        if (this.m_event != null) {
            return this.m_event.getId();
        }
        return this.m_name;
    }

    public Event getEvent() {
        return this.m_objEvent;
    }

    public void setEvent(Event event) {
        this.m_objEvent = event;
    }

    public Root getObject() {
        if (this.m_objEvent != null) {
            return this.m_objEvent;
        }
        if (this.m_event != null) {
            return this.m_event;
        }
        return null;
    }

    public String getType() {
        return this.m_strType;
    }

    public TimeEvent getTimeEvent() throws SchedulerException {
        AbstractEventInterface aevent = this.getAbstractEvent();
        if (aevent instanceof TimeEvent) {
            return (TimeEvent)aevent;
        }
        return null;
    }

    public FileEvent getFileEvent() throws SchedulerException {
        AbstractEventInterface aevent = this.getAbstractEvent();
        if (aevent instanceof FileEvent) {
            return (FileEvent)aevent;
        }
        return null;
    }

    public AbstractEventInterface getAbstractEvent() throws SchedulerException {
        Object aevent = null;
        try {
            if (this.m_event != null) {
                GroupingEvent ge = new GroupingEvent(this.m_event.getTransformRole());
                EventListItem list = MetaUtilities.processWaitEvent(this.m_event);
                if (list == null) {
                    return null;
                }
                this.m_objEvent = list.getEvent();
                for (CMetadata obj : list.getMetadataObjects()) {
                    if (!(obj instanceof Event)) continue;
                    Event object = (Event)obj;
                    if (object.getEventRole().equalsIgnoreCase("TimeEvent")) {
                        TimeEvent te = new TimeEvent();
                        if (this.m_definition == null || this.m_definition.length() == 0) {
                            this.m_definition = MetaUtilities.getProperty((Root)this.m_objEvent, "Definition");
                        }
                        if (this.m_definition == null || !te.initFromDefinition(this.m_scheduler, this.m_definition)) {
                            this.m_definition = null;
                            if (!te.initFromCondition(this.m_scheduler, this.m_objEvent.getCondition())) {
                                te = null;
                            }
                        }
                        ge.addDependency(te);
                        continue;
                    }
                    if (!object.getEventRole().equalsIgnoreCase("FileEvent")) continue;
                    FileEvent fe = new FileEvent();
                    String strDefinition = this.m_objEvent.getCondition();
                    if (!(strDefinition != null && fe.initFromDefinition(this.m_scheduler, strDefinition) || fe.initFromCondition(this.m_scheduler, this.m_objEvent.getCondition()))) {
                        fe = null;
                    }
                    ge.addDependency(fe);
                }
                ge.setDescription(this.m_event.getDesc());
                aevent = ge;
            } else if (this.m_objEvent != null && this.m_objEvent.getEventRole().equalsIgnoreCase("TimeEvent")) {
                TimeEvent te = new TimeEvent();
                if (this.m_definition == null || this.m_definition.length() == 0) {
                    this.m_definition = MetaUtilities.getProperty((Root)this.m_objEvent, "Definition");
                }
                if (this.m_definition == null || !te.initFromDefinition(this.m_scheduler, this.m_definition)) {
                    this.m_definition = null;
                    if (!te.initFromCondition(this.m_scheduler, this.m_objEvent.getCondition())) {
                        te = null;
                    }
                }
                if (te != null) {
                    te.setDescription(this.m_objEvent.getDesc());
                }
                aevent = te;
            } else if (this.m_objEvent != null && this.m_objEvent.getEventRole().equalsIgnoreCase("FileEvent")) {
                FileEvent fe = new FileEvent();
                String strDefinition = this.m_objEvent.getCondition();
                if (!(strDefinition != null && fe.initFromDefinition(this.m_scheduler, strDefinition) || fe.initFromCondition(this.m_scheduler, this.m_objEvent.getCondition()))) {
                    fe = null;
                }
                if (fe != null) {
                    fe.setDescription(this.m_objEvent.getDesc());
                }
                aevent = fe;
            }
        }
        catch (RemoteException e) {
            SchedulerException ex = new SchedulerException(e.getLocalizedMessage());
            throw ex;
        }
        catch (MdException e) {
            SchedulerException ex = new SchedulerException(e.getLocalizedMessage());
            throw ex;
        }
        return aevent;
    }

    public TriggerEventInfo getInfo() throws SchedulerException {
        AbstractEventInterface ae = this.getAbstractEvent();
        if (ae instanceof TimeEvent) {
            return new TriggerEventInfo(((TimeEvent)ae).getInfo(), this.m_scheduler.getServerComponent());
        }
        if (ae instanceof FileEvent) {
            return new TriggerEventInfo(((FileEvent)ae).getInfo(), this.m_scheduler.getServerComponent());
        }
        if (ae instanceof GroupingEvent) {
            return new TriggerEventInfo(((GroupingEvent)ae).getInfo(null), this.m_scheduler.getServerComponent());
        }
        return null;
    }

    public AbstractEventInfo getEventInfo() throws SchedulerException {
        AbstractEventInterface ae = this.getAbstractEvent();
        if (ae instanceof TimeEvent) {
            return ((TimeEvent)ae).getInfo();
        }
        if (ae instanceof FileEvent) {
            return ((FileEvent)ae).getInfo();
        }
        if (ae instanceof GroupingEvent) {
            return ((GroupingEvent)ae).getInfo(null);
        }
        return null;
    }

    public boolean equals(TriggerEvent tre) {
        if (tre == null) {
            return false;
        }
        if (this.m_strType.equalsIgnoreCase("Manual") || this.m_strType.equalsIgnoreCase("RunNow")) {
            return tre.getType().equalsIgnoreCase(this.m_strType);
        }
        if (tre.m_objEvent == null || this.m_objEvent == null) {
            return false;
        }
        try {
            String a = this.m_objEvent.getFQID();
            String b = tre.m_objEvent.getFQID();
            return b.equalsIgnoreCase(a);
        }
        catch (RemoteException re) {
            return false;
        }
    }

    public String generateXML() {
        StringBuffer xmlbuffer = new StringBuffer();
        int condition = 31;
        try {
            if (this.m_event != null && this.m_event.getTransformRole().compareTo("OR") == 0) {
                condition = 32;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (condition == 32) {
            xmlbuffer.append("<TriggerEvents CombinationType=\"Or\">\n");
        } else {
            xmlbuffer.append("<TriggerEvents CombinationType=\"And\">\n");
        }
        try {
            AbstractEventInterface ae = this.getAbstractEvent();
            if (ae != null) {
                String xml = ae.generateXML();
                if (xml != null) {
                    xmlbuffer.append(xml);
                } else {
                    xml = "<!-- " + MetaUtilities.messageString(m_bundle.getString("TriggerEvent.UnknownEvent.fmt"), this.toString()) + " -->\n";
                    xmlbuffer.append(xml);
                }
            } else {
                String xml = "<!-- " + MetaUtilities.messageString(m_bundle.getString("TriggerEvent.UnsupportedEvent.fmt"), this.toString(), this.m_scheduler.getName()) + " -->\n";
                xmlbuffer.append(xml);
            }
        }
        catch (SchedulerException se) {
            String xml = "<!-- " + MetaUtilities.messageString(m_bundle.getString("TriggerEvent.UnknownEvent.fmt"), this.toString()) + " -->\n";
            xmlbuffer.append(xml);
        }
        xmlbuffer.append("</TriggerEvents>\n");
        return xmlbuffer.toString();
    }

    public String generateXML(boolean exportFormat) {
        return this.generateXML();
    }

    public boolean setDescription(String sDescription) {
        this.m_description = sDescription;
        return true;
    }

    public String getDescription() {
        return this.m_description;
    }
}

