/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.oma;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Event;
import com.sas.metadata.remote.JFJob;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.SyncStep;
import com.sas.metadata.remote.TransformationActivity;
import com.sas.metadata.remote.TransformationStep;
import com.sas.scheduler.api.oma.DeployedFlow;
import com.sas.scheduler.api.oma.FileEvent;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.api.servers.Scheduler;
import com.sas.scheduler.model.FileEventInfo;
import com.sas.scheduler.model.SchedulerException;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.FolderUtil;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.util.UpgradeInterface;
import com.sas.storage.editableproperties.LocalizableProperties;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.SubstitutionProperties;
import com.sas.storage.editableproperties.UnexpectedSubstitutionException;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;

public class DeployedFlowSmartObject
extends Metadata
implements LocalizableProperties,
UpgradeInterface,
SubstitutionProperties {
    private static final ResourceBundle m_bundle = MetaUtilities.getMyResourceBundle(DeployedFlowSmartObject.class);
    private static final long serialVersionUID = 1L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(1, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(2, 0);
    private JFJob m_jfjob;

    public DeployedFlowSmartObject() throws RemoteException {
        super(DeployedFlowSmartObject.class);
    }

    public DeployedFlowSmartObject(Object o) throws RemoteException {
        super(o, DeployedFlowSmartObject.class);
        if (!(o instanceof JFJob)) {
            throw new IllegalArgumentException(MetaUtilities.messageString(m_bundle.getString("DeployedFlowSmartObject.badctorobject.msg.fmt"), o.getClass().getName()));
        }
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
        this.m_jfjob = (JFJob)o;
    }

    public String getType() throws RemoteException {
        return "DeployedFlow";
    }

    public Date getCreateDate() throws ServiceException, RemoteException {
        Date d = DeployedFlow.getDateCreated(this.m_jfjob);
        if (d == null) {
            d = super.getCreateDate();
        }
        return d;
    }

    public Date getModifyDate() throws ServiceException, RemoteException {
        Date d = DeployedFlow.getDateModified(this.m_jfjob, null);
        if (d == null) {
            d = super.getModifyDate();
        }
        return d;
    }

    public String getName() throws RemoteException {
        return DeployedFlow.getName(this.m_jfjob);
    }

    public PropertyList getLocalizableProperties() {
        return this.getDefaultLocalizableProperties();
    }

    public void setLocalizableProperties(PropertyMap map) {
        this.setDefaultLocalizableProperties(map);
    }

    public void upgradeFromPreviousVersion() throws ServiceException, RemoteException {
        FolderInterface targetFolder = this.getParent();
        if (targetFolder == null || FolderUtil.isDIStudioUngroupedFolder((FolderInterface)targetFolder)) {
            targetFolder = FolderUtil.makeSharedDataFolder((MetadataInterface)this);
        }
        this.validateNameAndFolder(targetFolder);
        this.m_jfjob.setUsageVersion("2000000.0");
    }

    public PropertyList getSubstitutionProperties() throws UnexpectedSubstitutionException {
        PropertyList list = new PropertyList();
        try {
            List<FileEventInfo> fileevents = DeployedFlow.getFileEvents(this.m_jfjob, true);
            if (fileevents != null && fileevents.size() > 0) {
                for (int i = 0; i < fileevents.size(); ++i) {
                    FileEventInfo fevent = fileevents.get(i);
                    String filename = fevent.getFileName();
                    if (i == 0 && fileevents.size() == 1) {
                        list.addProperty("FilePath", filename);
                        continue;
                    }
                    list.addProperty("FilePath", i + 1, filename);
                }
            }
        }
        catch (MdException e) {
            throw new UnexpectedSubstitutionException((Throwable)e);
        }
        catch (RemoteException e) {
            throw new UnexpectedSubstitutionException((Throwable)e);
        }
        return list;
    }

    public void setSubstitutionProperties(PropertyMap map) throws UnexpectedSubstitutionException {
        block18: {
            boolean update = false;
            try {
                List<FileEventInfo> fileevents = DeployedFlow.getFileEvents(this.m_jfjob, true);
                if (fileevents == null || fileevents.size() <= 0) break block18;
                String filePath = map.getProperty("FilePath");
                int[] indexes = map.getPropertyIndexes("FilePath");
                if (filePath != null) {
                    for (int i = 0; i < fileevents.size(); ++i) {
                        FileEventInfo fevent = fileevents.get(i);
                        String filename = fevent.getFileName();
                        if (filePath == filename) continue;
                        fevent.setFileName(filePath);
                        DeployedFlow.updateFileEvent(this.m_jfjob, fevent);
                        update = true;
                    }
                } else if (indexes != null) {
                    List<List<FileEventInfo>> check = this.checkFileEvents(this.m_jfjob, false);
                    if (this.getCount(check) != fileevents.size()) {
                        check = this.checkFileEvents(this.m_jfjob, true);
                        for (int i = 0; i < check.size(); ++i) {
                            List<FileEventInfo> list = check.get(i);
                            filePath = map.getProperty("FilePath", i + 1);
                            for (int x = 0; x < list.size(); ++x) {
                                FileEventInfo fevent = list.get(x);
                                String filename = fevent.getFileName();
                                if (filePath == filename) continue;
                                fevent.setFileName(filePath);
                                DeployedFlow.updateFileEvent(this.m_jfjob, fevent);
                                update = true;
                            }
                        }
                    } else if (check.size() != fileevents.size()) {
                        List<String> filepaths = this.checkFileEvents(map, fileevents.size());
                        for (int i = 0; i < check.size(); ++i) {
                            List<FileEventInfo> list = check.get(i);
                            filePath = filepaths.get(i);
                            for (int x = 0; x < list.size(); ++x) {
                                FileEventInfo fevent = list.get(x);
                                String filename = fevent.getFileName();
                                if (filePath.equals(filename)) continue;
                                fevent.setFileName(filePath);
                                DeployedFlow.updateFileEvent(this.m_jfjob, fevent);
                                update = true;
                            }
                        }
                    } else {
                        for (int i = 0; i < fileevents.size(); ++i) {
                            FileEventInfo fevent;
                            String filename;
                            filePath = map.getProperty("FilePath", i + 1);
                            if (filePath == (filename = (fevent = fileevents.get(i)).getFileName())) continue;
                            fevent.setFileName(filePath);
                            DeployedFlow.updateFileEvent(this.m_jfjob, fevent);
                            update = true;
                        }
                    }
                }
                if (update) {
                    this.m_jfjob.updateMetadataAll();
                }
            }
            catch (SchedulerException e) {
                throw new UnexpectedSubstitutionException((Throwable)e);
            }
            catch (MdException e) {
                throw new UnexpectedSubstitutionException((Throwable)e);
            }
            catch (RemoteException e) {
                throw new UnexpectedSubstitutionException((Throwable)e);
            }
        }
    }

    private int getCount(List<List<FileEventInfo>> check) {
        int count = 0;
        for (int i = 0; i < check.size(); ++i) {
            List<FileEventInfo> list = check.get(i);
            count += list.size();
        }
        return count;
    }

    private List<List<FileEventInfo>> checkFileEvents(JFJob flow, boolean compat) throws RemoteException, MdException {
        ArrayList<List<FileEventInfo>> orderedList = new ArrayList<List<FileEventInfo>>();
        HashMap<String, ArrayList<FileEventInfo>> hash = new HashMap<String, ArrayList<FileEventInfo>>();
        TransformationActivity ta = (TransformationActivity)flow.getJobActivities().get(0);
        for (TransformationStep step : ta.getSteps()) {
            Event event;
            if (!step.getTransformRole().equalsIgnoreCase("EVENTWAIT") || (event = (Event)step.getTriggeringEvents().get(0)) == null || !event.getEventRole().equalsIgnoreCase("FileEvent")) continue;
            FileEventInfo fei = new FileEventInfo();
            String strDefinition = MetaUtilities.getProperty((Root)event, "Definition");
            if (strDefinition == null || !fei.initFromDefinition(strDefinition)) {
                FileEvent fileEvent = new FileEvent();
                ServerComponent schedulerServer = (ServerComponent)flow.getComputeLocations();
                Scheduler scheduler = MetaUtilities.getSchedulingServer(schedulerServer);
                if (!fileEvent.initFromCondition(scheduler, event.getCondition())) continue;
                fei = fileEvent.getInfo();
                fei.setId(event.getId());
                ArrayList<FileEventInfo> temp = (ArrayList<FileEventInfo>)hash.get(fei.getFileName());
                if (temp == null) {
                    temp = new ArrayList<FileEventInfo>();
                    orderedList.add(temp);
                }
                temp.add(fei);
                hash.put(fei.getFileName(), temp);
                continue;
            }
            fei.setId(event.getId());
            ArrayList<FileEventInfo> temp = (ArrayList<FileEventInfo>)hash.get(fei.getFileName());
            if (temp == null) {
                temp = new ArrayList<FileEventInfo>();
                orderedList.add(temp);
            }
            temp.add(fei);
            hash.put(fei.getFileName(), temp);
        }
        AssociationList steps = flow.getSteps();
        boolean triggerFound = false;
        int numSteps = steps.size();
        for (int i = 0; i < numSteps; ++i) {
            TransformationStep ts = (TransformationStep)steps.get(i);
            if (!(ts instanceof SyncStep)) continue;
            triggerFound = true;
            SyncStep step = (SyncStep)ts;
            AssociationList lstTriggeringEvents = step.getTriggeringEvents();
            if (null != lstTriggeringEvents && 0 != lstTriggeringEvents.size()) {
                for (Event event : lstTriggeringEvents) {
                    if (event == null || !event.getEventRole().equalsIgnoreCase("FileEvent")) continue;
                    FileEventInfo fei = new FileEventInfo();
                    String strDefinition = MetaUtilities.getProperty((Root)event, "Definition");
                    if (strDefinition == null || !fei.initFromDefinition(strDefinition)) {
                        FileEvent fileEvent = new FileEvent();
                        ServerComponent schedulerServer = (ServerComponent)flow.getComputeLocations().get(0);
                        Scheduler scheduler = MetaUtilities.getSchedulingServer(schedulerServer);
                        if (!fileEvent.initFromCondition(scheduler, event.getCondition())) continue;
                        fei = fileEvent.getInfo();
                        fei.setId(event.getId());
                        ArrayList<FileEventInfo> temp = (ArrayList<FileEventInfo>)hash.get(fei.getFileName());
                        if (temp == null) {
                            temp = new ArrayList<FileEventInfo>();
                            orderedList.add(temp);
                        }
                        temp.add(fei);
                        hash.put(fei.getFileName(), temp);
                        continue;
                    }
                    fei.setId(event.getId());
                    ArrayList<FileEventInfo> temp = (ArrayList<FileEventInfo>)hash.get(fei.getFileName());
                    if (temp == null) {
                        temp = new ArrayList<FileEventInfo>();
                        orderedList.add(temp);
                    }
                    temp.add(fei);
                    hash.put(fei.getFileName(), temp);
                }
            }
            if (triggerFound) break;
        }
        if (compat) {
            return new ArrayList<List<FileEventInfo>>(hash.values());
        }
        return orderedList;
    }

    private List<String> checkFileEvents(PropertyMap map, int size) throws RemoteException, MdException {
        ArrayList<String> orderedList = new ArrayList<String>();
        HashMap<String, String> hash = new HashMap<String, String>();
        for (int i = 1; i <= size; ++i) {
            String filePath = map.getProperty("FilePath", i);
            String temp = (String)hash.get(filePath);
            if (temp == null) {
                orderedList.add(filePath);
            }
            hash.put(filePath, String.valueOf(i));
        }
        return orderedList;
    }
}

