/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.oma;

import com.sas.iom.SAS.IFileService;
import com.sas.iom.SAS.IFileref;
import com.sas.iom.SAS.IHostSystem;
import com.sas.iom.SAS.ITextStream;
import com.sas.iom.SAS.IUtilities;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SAS.StreamOpenMode;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.LongSeqHolder;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.JFJob;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.Machine;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.TransformationActivity;
import com.sas.metadata.remote.TransformationStep;
import com.sas.scheduler.api.oma.DeployedJob;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.api.servers.IWorkspaceServer;
import com.sas.scheduler.api.servers.Scheduler;
import com.sas.scheduler.api.servers.oozie.job.OozieDeployJob;
import com.sas.scheduler.api.servers.oozie.job.OozieException;
import com.sas.scheduler.api.servers.sasprocs.submitSAS;
import com.sas.scheduler.model.BatchServerInfo;
import com.sas.scheduler.model.DirectoryInfo;
import com.sas.scheduler.model.JobInfo;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.SchedulerServerInfo;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.omg.CORBA.StringHolder;

public class CommandUtilities {
    private static final ResourceBundle m_bundle = MetaUtilities.getMyResourceBundle(MetaUtilities.class);
    public static final String HDFSPrefix = "hdfs://";
    public static final String MAPRPrefix = "maprfs://";
    private static final String m_datastepserverID = "e20e54b3-e5f4-47ed-b21d-03109bf9a4b8";
    private static final String m_javaserverID = "0069e914-b58c-4094-a686-a87df433ec4b";
    private static final String m_dmpexeserverID = "d6644527-7a09-4fe2-8bac-1caca2f6a46c";
    private static final String m_genericserverID = "a1ff485f-9e44-4c82-90b5-062916cfa9b9";
    public static boolean m_allowFlowPrefix = true;
    public static boolean m_outputfile = false;

    private CommandUtilities() {
    }

    public static void setAllowFlowPrefixForLogfile(boolean value) {
        m_allowFlowPrefix = value;
    }

    public static void setOutputfile(boolean value) {
        m_outputfile = value;
    }

    public static String getCommandLine(DeployedJob djob) throws MdException, RemoteException {
        return CommandUtilities.getCommandLine(djob.getDeployedJobObject(), null);
    }

    public static String getCommandLine(JFJob job) throws MdException, RemoteException {
        return CommandUtilities.getCommandLine(job, null);
    }

    public static String getCommandLine(JFJob job, String flowname) throws MdException, RemoteException {
        return CommandUtilities.getCommandLine(job, flowname, " ");
    }

    public static String getActualCommandLine(JFJob job) throws MdException, RemoteException {
        return CommandUtilities.getActualCommandLine(job, null);
    }

    public static String getActualCommandLine(JFJob job, String flowname) throws MdException, RemoteException {
        return CommandUtilities._getCommandLine(job, flowname, " ", false);
    }

    public static String getCommandLine(JFJob job, String flowname, String spacer) throws MdException, RemoteException {
        return CommandUtilities._getCommandLine(job, flowname, spacer, true);
    }

    private static String _getCommandLine(JFJob job, String flowname, String spacer, boolean JCL) throws MdException, RemoteException {
        String filepath;
        File file;
        ServerComponent serverComponent;
        String subtype = null;
        String commandline = null;
        String command = null;
        String logOption = null;
        String outputOption = null;
        String commonArgs = "";
        String VMScommonArgs = "";
        String jcommonArgs = null;
        String jobArgs = "";
        String fileOption = null;
        int targetOS = -1;
        AssociationList properties = null;
        boolean Logging = true;
        boolean Infile = true;
        String lsFQID = null;
        if (job.getComputeLocations().size() == 0 && job.getTargetSpecifications().size() == 0) {
            return null;
        }
        String logopt = "";
        String logdir = "";
        String logext = "";
        String logparms = null;
        String outputopt = null;
        String outputdir = "";
        String outputext = "";
        String fileopt = "";
        String filename = null;
        properties = job.getProperties();
        int propsize = properties.size();
        for (int j = 0; j < propsize; ++j) {
            Property property = (Property)properties.get(j);
            if (property == null) continue;
            if (property.getPropertyName().equalsIgnoreCase("CmdArgs")) {
                jobArgs = property.getDefaultValue();
                continue;
            }
            if (property.getPropertyName().equalsIgnoreCase("CommonArgs")) {
                jcommonArgs = property.getDefaultValue();
                continue;
            }
            if (property.getPropertyName().equalsIgnoreCase("LogFlag")) {
                if (property.getDefaultValue().equalsIgnoreCase("true")) {
                    Logging = true;
                    continue;
                }
                Logging = false;
                continue;
            }
            if (!property.getPropertyName().equalsIgnoreCase("LSfqid")) continue;
            lsFQID = property.getDefaultValue();
        }
        if (lsFQID == null || lsFQID.length() == 0) {
            lsFQID = m_datastepserverID;
        }
        if ((serverComponent = CommandUtilities.getServerComponentForJob(job, lsFQID)) == null) {
            return "";
        }
        properties = serverComponent.getProperties();
        propsize = properties.size();
        for (int j = 0; j < propsize; ++j) {
            Property property = (Property)properties.get(j);
            if (property.getPropertyName().equalsIgnoreCase("CmdLine")) {
                command = property.getDefaultValue();
                if (!CommandUtilities.needsQuoting(command)) continue;
                command = CommandUtilities.quoteCommand(command);
                continue;
            }
            if (property.getPropertyName().equalsIgnoreCase("LogOpt")) {
                logopt = property.getDefaultValue();
                continue;
            }
            if (property.getPropertyName().equalsIgnoreCase("LogDir")) {
                logdir = CommandUtilities.escapePercents(property.getDefaultValue());
                continue;
            }
            if (property.getPropertyName().equalsIgnoreCase("LogExt")) {
                logext = property.getDefaultValue();
                continue;
            }
            if (property.getPropertyName().equalsIgnoreCase("OutputOpt")) {
                outputopt = property.getDefaultValue();
                continue;
            }
            if (property.getPropertyName().equalsIgnoreCase("OutputDir")) {
                outputdir = CommandUtilities.escapePercents(property.getDefaultValue());
                continue;
            }
            if (property.getPropertyName().equalsIgnoreCase("OutputExt")) {
                outputext = property.getDefaultValue();
                continue;
            }
            if (property.getPropertyName().equalsIgnoreCase("CommonArgs")) {
                commonArgs = property.getDefaultValue();
                continue;
            }
            if (property.getPropertyName().equalsIgnoreCase("VMSCommonArgs")) {
                VMScommonArgs = property.getDefaultValue();
                continue;
            }
            if (property.getPropertyName().equalsIgnoreCase("FileOpt")) {
                fileopt = property.getDefaultValue();
                continue;
            }
            if (property.getPropertyName().equalsIgnoreCase("LogParams")) {
                logparms = CommandUtilities.escapePercents(property.getDefaultValue());
                continue;
            }
            if (property.getPropertyName().equalsIgnoreCase("SubType")) {
                subtype = property.getDefaultValue();
                continue;
            }
            if (!property.getPropertyName().equalsIgnoreCase("HostType")) continue;
            String value = property.getDefaultValue();
            targetOS = value.compareToIgnoreCase("win") == 0 ? 0 : (value.compareToIgnoreCase("unx") == 0 ? 1 : (value.compareToIgnoreCase("mvs") == 0 ? 2 : (value.compareToIgnoreCase("vms") == 0 ? 3 : -1)));
        }
        if (null == command || command.equalsIgnoreCase("")) {
            return "";
        }
        if (subtype == null) {
            return CommandUtilities.getCommandLineFromOldBatchServer(job, command, logdir, logparms, flowname);
        }
        if (targetOS == -1 && command.toLowerCase().endsWith(".jcl")) {
            targetOS = 2;
        }
        if (JCL && targetOS == 2) {
            AssociationList jcls = job.getSourceSpecifications();
            if (jcls.size() > 0) {
                file = (File)jcls.get(0);
                String fname = null;
                filepath = null;
                filename = file.getFileName();
                String fileExt = file.getFileExtension();
                if (fileExt.length() > 0) {
                    if (fileExt.startsWith(".")) {
                        file.setFileExtension(fileExt.substring(1));
                        fname = filename + fileExt;
                    } else {
                        fname = filename + "." + fileExt;
                    }
                } else {
                    fname = filename;
                }
                filepath = file.getDirectories().size() != 0 ? ((Directory)file.getDirectories().get(0)).getDirectoryName() : "";
                command = CommandUtilities.createFullPath(filepath, fname, targetOS);
                Logging = false;
                Infile = false;
            } else {
                command = null;
            }
        } else if (targetOS == 3) {
            String commandPath = command;
            if (command.startsWith("\"") || command.startsWith("'")) {
                commandPath = command.substring(1, command.length() - 1);
            }
            if (commandPath.startsWith("/")) {
                String commandName = null;
                int index = commandPath.lastIndexOf(47);
                if (index > 0) {
                    commandName = commandPath.substring(index + 1);
                    command = CommandUtilities.createFullPath(commandPath = commandPath.substring(0, index), commandName, targetOS);
                    if (command.startsWith("\"") || command.startsWith("'")) {
                        command = command.substring(1, command.length() - 1);
                    }
                }
            }
        }
        if (jcommonArgs != null) {
            commonArgs = jcommonArgs;
            VMScommonArgs = jcommonArgs;
        }
        if (Infile) {
            AssociationList files = job.getSourceCodes();
            if (files.size() > 0) {
                file = (File)files.get(0);
                String fname = null;
                filepath = null;
                filename = file.getFileName();
                fname = file.getFileExtension().length() != 0 ? filename + "." + file.getFileExtension() : filename;
                AssociationList dirs = file.getDirectories();
                if (dirs.size() != 0) {
                    Directory dir = (Directory)dirs.get(0);
                    filepath = dir.getDirectoryName();
                } else {
                    filepath = "";
                }
                switch (targetOS) {
                    case 3: {
                        fileOption = MetaUtilities.replaceString(fileopt, "-", "/") + "=" + CommandUtilities.createFullPath(filepath, fname, targetOS);
                        break;
                    }
                    default: {
                        fileOption = fileopt + " " + CommandUtilities.createFullPath(filepath, fname, targetOS);
                        break;
                    }
                }
            } else {
                fileOption = "";
            }
        }
        if (Logging) {
            String logname = null;
            logname = m_allowFlowPrefix && flowname != null ? (filename != null ? flowname + "_" + filename : flowname + "_" + job.getName()) : (filename != null ? filename : job.getName());
            int endpos = logname.indexOf(".sas");
            if (endpos > 0) {
                logname = logname.substring(0, endpos);
            }
            switch (targetOS) {
                case 3: {
                    logext = MetaUtilities.replaceString(logext, "#", "%");
                    logext = MetaUtilities.replaceString(logext, ".", "_");
                    logext = MetaUtilities.replaceString(logext, "_log", ".log");
                    logOption = MetaUtilities.replaceString(logopt, "-", "/") + "=" + CommandUtilities.createFullPath(logdir, logname + logext, targetOS);
                    break;
                }
                default: {
                    logOption = logopt + " " + CommandUtilities.createFullPath(logdir, logname + logext, targetOS);
                    break;
                }
            }
        } else {
            logOption = "";
        }
        if (m_outputfile && outputopt != null && outputdir != null && outputdir.trim().length() > 0) {
            String outputname = null;
            outputname = m_allowFlowPrefix && flowname != null ? (filename != null ? flowname + "_" + filename : flowname + "_" + job.getName()) : (filename != null ? filename : job.getName());
            int endpos = outputname.indexOf(".sas");
            if (endpos > 0) {
                outputname = outputname.substring(0, endpos);
            }
            switch (targetOS) {
                case 3: {
                    outputext = MetaUtilities.replaceString(outputext, "#", "%");
                    outputext = MetaUtilities.replaceString(outputext, ".", "_");
                    outputext = MetaUtilities.replaceString(outputext, "_lst", ".lst");
                    outputOption = MetaUtilities.replaceString(outputopt, "-", "/") + "=" + CommandUtilities.createFullPath(outputdir, outputname + outputext, targetOS);
                    break;
                }
                default: {
                    outputOption = outputopt + " " + CommandUtilities.createFullPath(outputdir, outputname + outputext, targetOS);
                    break;
                }
            }
        } else {
            outputOption = "";
        }
        switch (targetOS) {
            case 2: {
                if (JCL) {
                    commandline = command;
                    break;
                }
                commandline = command + spacer + logOption + spacer + outputOption + spacer + commonArgs + spacer + jobArgs + spacer + fileOption;
                break;
            }
            case 3: {
                commandline = command + logOption + outputOption + VMScommonArgs + jobArgs + fileOption;
                break;
            }
            default: {
                commandline = command + spacer + logOption + spacer + outputOption + spacer + commonArgs + spacer + jobArgs + spacer + fileOption;
            }
        }
        return commandline;
    }

    public static String getCommandLineFromBatchServer(ServerComponent batchserver) throws MdException, RemoteException {
        String command = null;
        AssociationList properties = batchserver.getProperties();
        int propsize = properties.size();
        for (int j = 0; j < propsize; ++j) {
            Property property = (Property)properties.get(j);
            if (!property.getPropertyName().equalsIgnoreCase("CmdLine")) continue;
            command = property.getDefaultValue();
            if (CommandUtilities.needsQuoting(command)) {
                command = CommandUtilities.quoteCommand(command);
            }
            return command;
        }
        return command;
    }

    public static void updateBatchServer(String fqid, String name, String command, String commandArgs, MdStore store, String repos) throws RemoteException, MdException {
        CommandUtilities.updateBatchServer(fqid, name, command, commandArgs, null, null, null, (MdObjectStore)store, repos);
    }

    public static void updateBatchServer(String fqid, String name, String command, String commandArgs, String subtype, String hosttype, String jcldir, MdObjectStore store, String repos) throws RemoteException, MdException {
        Property property;
        String reposId;
        boolean update = false;
        ServerComponent batchserver = MetaUtilities.getBatchServerComponent(fqid, (MdStore)store, repos);
        if (batchserver == null) {
            throw new RuntimeException("CommandUtilities.updateBatchServer()");
        }
        if (name != null && name.trim().length() > 0) {
            batchserver.setName(name);
            update = true;
        }
        String cmdline = null;
        cmdline = CommandUtilities.needsQuoting(command) ? CommandUtilities.quoteCommand(command) : command;
        boolean subtypeNotFound = true;
        boolean hosttypeNotFound = true;
        boolean jcldirNotFound = true;
        boolean cmdlineNotFound = true;
        boolean cmdargsNotFound = true;
        AssociationList properties = batchserver.getProperties();
        int propsize = properties.size();
        for (int j = propsize - 1; j >= 0; --j) {
            Property property2 = (Property)properties.get(j);
            if (subtype != null && subtype.trim().length() > 0 && property2.getPropertyName().equalsIgnoreCase("SubType")) {
                if (subtypeNotFound) {
                    property2.setDefaultValue(subtype);
                    property2.setName("BatchServer.Java.Property.SubType.xmlKey.txt");
                    subtypeNotFound = false;
                    update = true;
                } else {
                    property2.delete();
                }
            }
            if (hosttype != null && hosttype.trim().length() > 0 && property2.getPropertyName().equalsIgnoreCase("HostType")) {
                if (hosttypeNotFound) {
                    property2.setDefaultValue(hosttype);
                    property2.setName("BatchServer.Java.Property.HostType.xmlKey.txt");
                    update = true;
                    hosttypeNotFound = false;
                } else {
                    property2.delete();
                }
            }
            if (jcldir != null && jcldir.trim().length() > 0 && property2.getPropertyName().equalsIgnoreCase("JCLDir")) {
                if (jcldirNotFound) {
                    property2.setDefaultValue(jcldir);
                    property2.setName("BatchServer.Java.Property.JCLDir.xmlKey.txt");
                    update = true;
                    jcldirNotFound = false;
                } else {
                    property2.delete();
                }
            }
            if (command != null && command.length() > 0 && property2.getPropertyName().equalsIgnoreCase("CmdLine")) {
                if (cmdlineNotFound) {
                    property2.setDefaultValue(cmdline);
                    property2.setName("BatchServer.Java.Property.CmdLine.xmlKey.txt");
                    cmdlineNotFound = false;
                    update = true;
                } else {
                    property2.delete();
                }
            }
            if (commandArgs == null || commandArgs.length() <= 0 || !property2.getPropertyName().equalsIgnoreCase("CommonArgs")) continue;
            if (cmdargsNotFound) {
                property2.setDefaultValue(commandArgs);
                property2.setName("BatchServer.Java.Property.CommonArgs.xmlKey.txt");
                cmdargsNotFound = false;
                update = true;
                continue;
            }
            property2.delete();
        }
        if (subtype != null && subtype.trim().length() > 0 && subtypeNotFound) {
            MdFactory factory = store.getFactory();
            reposId = repos.length() > 8 ? repos.substring(9) : repos;
            property = (Property)factory.createComplexMetadataObject(store, null, "SubType", "Property", reposId, null);
            property.setName("BatchServer.Java.Property.SubType.xmlKey.txt");
            property.setPropertyName("SubType");
            property.setDefaultValue(subtype);
            property.setSQLType(12);
            batchserver.getProperties().add((Object)property);
            update = true;
        }
        if (hosttype != null && hosttype.trim().length() > 0 && hosttypeNotFound) {
            MdFactory factory = store.getFactory();
            reposId = repos.length() > 8 ? repos.substring(9) : repos;
            property = (Property)factory.createComplexMetadataObject(store, null, "HostType", "Property", reposId, null);
            property.setName("BatchServer.Java.Property.HostType.xmlKey.txt");
            property.setPropertyName("HostType");
            property.setDefaultValue(hosttype);
            property.setSQLType(12);
            batchserver.getProperties().add((Object)property);
            update = true;
        }
        if (jcldir != null && jcldir.trim().length() > 0 && jcldirNotFound) {
            MdFactory factory = store.getFactory();
            reposId = repos.length() > 8 ? repos.substring(9) : repos;
            property = (Property)factory.createComplexMetadataObject(store, null, "JCLDir", "Property", reposId, null);
            property.setName("BatchServer.Java.Property.JCLDir.xmlKey.txt");
            property.setPropertyName("JCLDir");
            property.setDefaultValue(jcldir);
            property.setSQLType(12);
            batchserver.getProperties().add((Object)property);
            update = true;
        }
        if (command != null && command.length() > 0 && cmdlineNotFound) {
            MdFactory factory = store.getFactory();
            reposId = repos.length() > 8 ? repos.substring(9) : repos;
            property = (Property)factory.createComplexMetadataObject(store, null, "CmdLine", "Property", reposId, null);
            property.setName("BatchServer.Java.Property.CmdLine.xmlKey.txt");
            property.setPropertyName("CmdLine");
            property.setDefaultValue(cmdline);
            property.setSQLType(12);
            batchserver.getProperties().add((Object)property);
            update = true;
        }
        if (commandArgs != null && commandArgs.length() > 0 && cmdargsNotFound) {
            MdFactory factory = store.getFactory();
            reposId = repos.length() > 8 ? repos.substring(9) : repos;
            property = (Property)factory.createComplexMetadataObject(store, null, "CommonArgs", "Property", reposId, null);
            property.setName("BatchServer.Java.Property.CommonArgs.xmlKey.txt");
            property.setPropertyName("CommonArgs");
            property.setDefaultValue(commandArgs);
            property.setSQLType(12);
            batchserver.getProperties().add((Object)property);
            update = true;
        }
        if (update) {
            batchserver.updateMetadataAll();
        }
    }

    public static BatchServerInfo findBatchServerFromCommand(String command, String host, MdStore store, String repos) {
        try {
            if (repos.length() <= 8) {
                repos = "A0000001." + repos;
            }
            List<ServerComponent> bservers = MetaUtilities.getBatchServers(-1, store, repos);
            for (ServerComponent bServer : bservers) {
                String cmdLine = CommandUtilities.getCommandLineFromBatchServer(bServer);
                if (!cmdLine.startsWith(command)) continue;
                Machine machine = bServer.getAssociatedMachine();
                if (host != null && (machine == null || machine.getName().compareTo(host) != 0)) continue;
                BatchServerInfo binfo = new BatchServerInfo(bServer.getName(), bServer.getClassIdentifier());
                MetaUtilities.setBatchServerProperties(binfo, bServer);
                return binfo;
            }
        }
        catch (RemoteException re) {
            return null;
        }
        catch (MdException re) {
            return null;
        }
        return null;
    }

    public static String findSourceFileFromCommand(String command, BatchServerInfo binfo, String host, MdStore store, String repos) {
        if (binfo.getType() == 1) {
            if (repos.length() <= 8) {
                repos = "A0000001." + repos;
            }
            try {
                ServerComponent serverComponent = MetaUtilities.getBatchServerComponent(binfo, store, repos);
                AssociationList properties = serverComponent.getProperties();
                String fileopt = null;
                int targetOS = -1;
                int propsize = properties.size();
                for (int j = 0; j < propsize; ++j) {
                    Property property = (Property)properties.get(j);
                    if (property.getPropertyName().equalsIgnoreCase("FileOpt")) {
                        fileopt = property.getDefaultValue();
                        continue;
                    }
                    if (!property.getPropertyName().equalsIgnoreCase("HostType")) continue;
                    String value = property.getDefaultValue();
                    targetOS = value.compareToIgnoreCase("win") == 0 ? 0 : (value.compareToIgnoreCase("unx") == 0 ? 1 : (value.compareToIgnoreCase("mvs") == 0 ? 2 : (value.compareToIgnoreCase("vms") == 0 ? 3 : -1)));
                }
                String fname = null;
                int start = 0;
                int end = 0;
                switch (targetOS) {
                    case 3: {
                        fileopt = MetaUtilities.replaceString(fileopt, "-", "/");
                        start = command.indexOf(fileopt);
                        if (start <= 0) break;
                        String tname = command.substring(start);
                        if ((start = tname.indexOf("=")) > 0) {
                            tname = tname.substring(start + 1);
                        }
                        if ((end = tname.indexOf("/")) > 0) {
                            tname = tname.substring(0, end);
                        }
                        fname = CommandUtilities.getFilenameForBatchServer(tname, serverComponent).trim();
                        break;
                    }
                    default: {
                        start = command.indexOf(fileopt);
                        if (start <= 0) break;
                        String tname = command.substring(start);
                        if ((start = tname.indexOf(" ")) > 0) {
                            tname = tname.substring(start + 1);
                        }
                        if ((end = tname.indexOf(" ")) > 0) {
                            tname = tname.substring(0, end);
                        }
                        fname = CommandUtilities.getFilenameForBatchServer(tname, serverComponent).trim();
                    }
                }
                return fname;
            }
            catch (RemoteException re) {
                return null;
            }
            catch (MdException mde) {
                return null;
            }
        }
        return null;
    }

    public static DirectoryInfo findSourceDirectoryFromCommand(String command, BatchServerInfo binfo, String host, MdStore store, String repos) {
        if (binfo.getType() == 1) {
            if (repos.length() <= 8) {
                repos = "A0000001." + repos;
            }
            try {
                ServerComponent serverComponent = MetaUtilities.getBatchServerComponent(binfo, store, repos);
                AssociationList properties = serverComponent.getProperties();
                String fileopt = null;
                int targetOS = -1;
                int propsize = properties.size();
                for (int j = 0; j < propsize; ++j) {
                    Property property = (Property)properties.get(j);
                    if (property.getPropertyName().equalsIgnoreCase("FileOpt")) {
                        fileopt = property.getDefaultValue();
                        continue;
                    }
                    if (!property.getPropertyName().equalsIgnoreCase("HostType")) continue;
                    String value = property.getDefaultValue();
                    targetOS = value.compareToIgnoreCase("win") == 0 ? 0 : (value.compareToIgnoreCase("unx") == 0 ? 1 : (value.compareToIgnoreCase("mvs") == 0 ? 2 : (value.compareToIgnoreCase("vms") == 0 ? 3 : -1)));
                }
                String dname = null;
                int start = 0;
                int end = 0;
                switch (targetOS) {
                    case 3: {
                        fileopt = MetaUtilities.replaceString(fileopt, "-", "/");
                        start = command.indexOf(fileopt);
                        if (start <= 0) break;
                        String tname = command.substring(start);
                        if ((start = tname.indexOf("=")) > 0) {
                            tname = tname.substring(start + 1);
                        }
                        if ((end = tname.indexOf("/")) > 0) {
                            tname = tname.substring(0, end);
                        }
                        dname = CommandUtilities.getDirnameForBatchServer(tname, serverComponent).trim();
                        break;
                    }
                    default: {
                        start = command.indexOf(fileopt);
                        if (start <= 0) break;
                        String tname = command.substring(start);
                        if ((start = tname.indexOf(" ")) > 0) {
                            tname = tname.substring(start + 1);
                        }
                        if ((end = tname.lastIndexOf(" ")) > 0) {
                            tname = tname.substring(0, end);
                        }
                        dname = CommandUtilities.getDirnameForBatchServer(tname, serverComponent).trim();
                    }
                }
                Directory dir = MetaUtilities.getDirectory(binfo, dname, store, repos);
                return new DirectoryInfo(dir.getName(), dir.getDirectoryName());
            }
            catch (RemoteException re) {
                return null;
            }
            catch (MdException mde) {
                return null;
            }
        }
        return null;
    }

    public static String getBasenameForBatchServer(String name, ServerComponent batchserver) {
        String basename = null;
        String filename = null;
        int index = 0;
        try {
            switch (CommandUtilities.getTargetOSForBatchServer(batchserver)) {
                case 3: {
                    filename = name.substring(name.lastIndexOf("]") + 1);
                    index = filename.lastIndexOf(".");
                    if (index > 0) {
                        basename = filename.substring(0, index);
                        break;
                    }
                    basename = filename;
                    break;
                }
                case 1: 
                case 2: {
                    filename = name.substring(name.lastIndexOf("/") + 1);
                    index = filename.lastIndexOf(".");
                    if (index > 0) {
                        basename = filename.substring(0, index);
                        break;
                    }
                    basename = filename;
                    break;
                }
                default: {
                    index = name.lastIndexOf("/");
                    if (index < 0) {
                        index = name.lastIndexOf("\\");
                    }
                    if ((index = (filename = name.substring(index + 1)).lastIndexOf(".")) > 0) {
                        basename = filename.substring(0, index);
                        break;
                    }
                    basename = filename;
                    break;
                }
            }
        }
        catch (MdException ex) {
            return null;
        }
        catch (RemoteException ex) {
            return null;
        }
        return basename;
    }

    public static String getBaseLogNameNoFlowPrefix(TransformationStep jobTS) throws MdException, RemoteException {
        return CommandUtilities.getLogParm(jobTS, true, false);
    }

    public static String getBaseLogName(TransformationStep jobTS) throws MdException, RemoteException {
        return CommandUtilities.getLogParm(jobTS, true, true);
    }

    public static String getLogParm(TransformationStep jobTS) throws MdException, RemoteException {
        return CommandUtilities.getLogParm(jobTS, false, true);
    }

    private static String getLogParm(TransformationStep jobTS, boolean justBaseName, boolean flowprefix) throws MdException, RemoteException {
        File file;
        int endpos;
        String[] tokens;
        String logparm;
        ServerComponent serverComponent;
        String subtype = null;
        int targetOS = -1;
        AssociationList properties = null;
        String lsFQID = null;
        JFJob job = null;
        try {
            job = (JFJob)jobTS.getTransformations().get(0);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return null;
        }
        if (job.getComputeLocations().size() == 0) {
            return null;
        }
        String logopt = null;
        String logdir = "";
        String logext = "";
        String logparms = null;
        String filename = null;
        properties = job.getProperties();
        int propsize = properties.size();
        for (int j = 0; j < propsize; ++j) {
            Property property = (Property)properties.get(j);
            if (property.getPropertyName().equalsIgnoreCase("LogFlag")) {
                if (property.getDefaultValue().equalsIgnoreCase("true")) break;
                return "";
            }
            if (!property.getPropertyName().equalsIgnoreCase("LSfqid")) continue;
            lsFQID = property.getDefaultValue();
        }
        if ((serverComponent = CommandUtilities.getServerComponentForJob(job, lsFQID)) == null) {
            return "";
        }
        properties = serverComponent.getProperties();
        propsize = properties.size();
        for (int j = 0; j < propsize; ++j) {
            Property property = (Property)properties.get(j);
            if (property.getPropertyName().equalsIgnoreCase("LogOpt")) {
                logopt = property.getDefaultValue();
                continue;
            }
            if (property.getPropertyName().equalsIgnoreCase("LogDir")) {
                logdir = CommandUtilities.escapePercents(property.getDefaultValue());
                continue;
            }
            if (property.getPropertyName().equalsIgnoreCase("LogExt")) {
                logext = property.getDefaultValue();
                continue;
            }
            if (property.getPropertyName().equalsIgnoreCase("LogParams")) {
                logparms = CommandUtilities.escapePercents(property.getDefaultValue());
                continue;
            }
            if (property.getPropertyName().equalsIgnoreCase("SubType")) {
                subtype = property.getDefaultValue();
                continue;
            }
            if (!property.getPropertyName().equalsIgnoreCase("HostType")) continue;
            String value = property.getDefaultValue();
            targetOS = value.compareToIgnoreCase("win") == 0 ? 0 : (value.compareToIgnoreCase("unx") == 0 ? 1 : (value.compareToIgnoreCase("mvs") == 0 ? 2 : (value.compareToIgnoreCase("vms") == 0 ? 3 : -1)));
        }
        String cmdline = DeployedJob.getCmdLineProperty((Root)jobTS);
        if (cmdline != null) {
            int index;
            logparm = "";
            if (logopt != null) {
                tokens = cmdline.split(" ");
                for (int i = 0; i < tokens.length; ++i) {
                    String token = tokens[i];
                    if (token.compareTo(logopt) != 0) continue;
                    logparm = tokens[i + 1];
                    break;
                }
            } else {
                logparm = "";
            }
            if (justBaseName && (index = logparm.lastIndexOf(47)) >= 0) {
                logparm = logparm.substring(index + 1);
            }
            return logparm;
        }
        cmdline = DeployedJob.getCmdLineProperty((Root)job);
        if (cmdline != null) {
            int index;
            logparm = "";
            if (logopt != null) {
                tokens = cmdline.split(" ");
                for (int i = 0; i < tokens.length; ++i) {
                    String token = tokens[i];
                    if (token.compareTo(logopt) != 0) continue;
                    logparm = tokens[i + 1];
                    break;
                }
            } else {
                logparm = "";
            }
            if (justBaseName && (index = logparm.lastIndexOf(47)) >= 0) {
                logparm = logparm.substring(index + 1);
            }
            return logparm;
        }
        AssociationList files = job.getSourceCodes();
        if (files.size() > 0 && (endpos = (filename = (file = (File)files.get(0)).getFileName()).indexOf(".sas")) > 0) {
            filename = filename.substring(0, endpos);
        }
        String flowname = null;
        if (flowprefix) {
            try {
                TransformationActivity activity = (TransformationActivity)jobTS.getActivities().get(0);
                flowname = activity != null ? ((JFJob)activity.getJobs().get(0)).getName() : null;
            }
            catch (RemoteException activity) {
            }
            catch (MdException activity) {
            }
            catch (RuntimeException rte) {
                flowname = null;
            }
        }
        if (subtype == null) {
            if (justBaseName) {
                if (flowname != null) {
                    return flowname + "_" + filename;
                }
                return filename;
            }
            String strLoggingOptions = "";
            String rollinglog = "_#Y.#m.#d_#H.#M.#s";
            if (logparms != null && !logparms.equalsIgnoreCase("")) {
                rollinglog = logparms;
            }
            if (!logdir.equalsIgnoreCase("")) {
                String logname = filename + rollinglog + ".log";
                if (flowname != null) {
                    logname = flowname + "_" + logname;
                }
                strLoggingOptions = CommandUtilities.createFullPath(logdir, logname, targetOS);
            }
            return strLoggingOptions;
        }
        String logname = null;
        logname = filename != null ? filename : job.getName();
        if (flowname != null) {
            logname = flowname + "_" + logname;
        }
        if (justBaseName) {
            return logname;
        }
        String logOption = null;
        switch (targetOS) {
            case 3: {
                logext = MetaUtilities.replaceString(logext, "#", "%");
                logext = MetaUtilities.replaceString(logext, ".", "_");
                logext = MetaUtilities.replaceString(logext, "_log", ".log");
            }
        }
        logOption = CommandUtilities.createFullPath(logdir, logname + logext, targetOS);
        return logOption;
    }

    public static String getFilenameForBatchServer(String fullname, ServerComponent batchserver) {
        String filename = null;
        try {
            switch (CommandUtilities.getTargetOSForBatchServer(batchserver)) {
                case 3: {
                    filename = fullname.substring(fullname.lastIndexOf("]") + 1);
                    break;
                }
                case 1: 
                case 2: {
                    filename = fullname.substring(fullname.lastIndexOf("/") + 1);
                    break;
                }
                default: {
                    int index = fullname.lastIndexOf("/");
                    if (index < 0) {
                        index = fullname.lastIndexOf("\\");
                    }
                    filename = fullname.substring(index + 1);
                    break;
                }
            }
        }
        catch (MdException mdException) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return filename;
    }

    public static String getDirnameForBatchServer(String fullname, ServerComponent batchserver) {
        String dirname = null;
        int index = -1;
        try {
            switch (CommandUtilities.getTargetOSForBatchServer(batchserver)) {
                case 3: {
                    index = fullname.lastIndexOf(93);
                    break;
                }
                case 1: 
                case 2: {
                    index = fullname.lastIndexOf(47);
                    break;
                }
                default: {
                    index = fullname.lastIndexOf(47);
                    if (index >= 0) break;
                    index = fullname.lastIndexOf(92);
                }
            }
            if (index > 0) {
                dirname = fullname.substring(0, index);
            } else if (index == 0) {
                dirname = fullname.substring(0, 1);
            }
        }
        catch (MdException mdException) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return dirname;
    }

    public static int getTargetOSForBatchServer(ServerComponent batchserver) throws MdException, RemoteException {
        String command;
        int targetOS = -1;
        if (batchserver == null) {
            return targetOS;
        }
        AssociationList properties = batchserver.getProperties();
        int propsize = properties.size();
        for (int j = 0; j < propsize; ++j) {
            Property property = (Property)properties.get(j);
            if (!property.getPropertyName().equalsIgnoreCase("HostType")) continue;
            String value = property.getDefaultValue();
            if (value.compareToIgnoreCase("win") == 0) {
                targetOS = 0;
                break;
            }
            if (value.compareToIgnoreCase("unx") == 0) {
                targetOS = 1;
                break;
            }
            if (value.compareToIgnoreCase("mvs") == 0) {
                targetOS = 2;
                break;
            }
            if (value.compareToIgnoreCase("vms") == 0) {
                targetOS = 3;
                break;
            }
            targetOS = -1;
            break;
        }
        if (targetOS == -1 && null != (command = CommandUtilities.getCommandLineFromBatchServer(batchserver)) && !command.equalsIgnoreCase("") && (command.toUpperCase(Locale.getDefault()).endsWith(".JCL") || command.toUpperCase(Locale.getDefault()).endsWith(".JCL\""))) {
            targetOS = 2;
        }
        return targetOS;
    }

    public static void setServerComponentForJob(JFJob job, ServerComponent batchserver) throws RemoteException, MdException {
        try {
            job.getTargetSpecifications().clear();
            job.getTargetSpecifications().add((Object)batchserver);
            LogicalServer lc = (LogicalServer)batchserver.getUsedByComponents().get(0);
            ServerContext sc = (ServerContext)lc.getUsedByComponents().get(0);
            job.getComputeLocations().removeAllElements();
            job.getComputeLocations().add((Object)sc);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return;
        }
    }

    public static String getAppServerName(JobInfo info) throws SchedulerException {
        try {
            JFJob job = MetaUtilities.getJFJob(info.getId());
            return CommandUtilities.getAppServerName(job);
        }
        catch (MdException ex) {
            SchedulerException se = new SchedulerException(ex.toString());
            se.initCause((Throwable)ex);
            throw se;
        }
        catch (RemoteException ex) {
            SchedulerException se = new SchedulerException(ex.toString());
            se.initCause((Throwable)ex);
            throw se;
        }
    }

    public static String getAppServerName(JFJob job) throws RemoteException, MdException {
        AssociationList cl = job.getComputeLocations();
        if (cl.size() == 0) {
            return null;
        }
        ServerComponent sc = (ServerComponent)cl.get(0);
        if (sc instanceof ServerContext) {
            return sc.getName();
        }
        return null;
    }

    public static ServerComponent findServerComponentForJob(JFJob job, String classid, int subtype) throws RemoteException, MdException {
        if (classid == null) {
            return null;
        }
        AssociationList cl = job.getComputeLocations();
        if (cl.size() == 0) {
            return null;
        }
        ServerComponent scontext = (ServerComponent)cl.get(0);
        if (scontext instanceof ServerContext) {
            AssociationList usingComponents = scontext.getUsingComponents();
            for (LogicalServer logicalServer : usingComponents) {
                String classID = logicalServer.getClassIdentifier();
                if (classid.compareTo(classID) != 0) continue;
                AssociationList components = logicalServer.getUsingComponents();
                for (ServerComponent sc : components) {
                    if (classID.equalsIgnoreCase(m_datastepserverID) || classID.equalsIgnoreCase(m_dmpexeserverID) || classID.equalsIgnoreCase(m_genericserverID)) {
                        return sc;
                    }
                    if (!classID.equalsIgnoreCase(m_javaserverID)) continue;
                    if (subtype != 0) {
                        if (sc == null || MetaUtilities.getBatchServerSubType(sc) != subtype) continue;
                        return sc;
                    }
                    return sc;
                }
            }
        } else {
            return scontext;
        }
        return null;
    }

    public static Property getServerComponentPropertyForJob(JFJob job) throws RemoteException, MdException {
        AssociationList properties = job.getProperties();
        int propsize = properties.size();
        for (int j = 0; j < propsize; ++j) {
            Property property = (Property)properties.get(j);
            if (!property.getPropertyName().equalsIgnoreCase("LSfqid")) continue;
            return property;
        }
        return null;
    }

    public static void setServerComponentPropertyForJob(JFJob job, String value) throws RemoteException, MdException {
        AssociationList properties = job.getProperties();
        int propsize = properties.size();
        for (int j = 0; j < propsize; ++j) {
            Property p = (Property)properties.get(j);
            if (!p.getPropertyName().equalsIgnoreCase("LSfqid")) continue;
            p.setDefaultValue(value);
            return;
        }
        String repos = job.getRepositoryID();
        MdObjectStore store = (MdObjectStore)job.getObjectStore();
        MdFactory factory = store.getFactory();
        Property property = (Property)factory.createComplexMetadataObject(store, null, "LSfqid", "Property", repos, null);
        property.setPropertyName("LSfqid");
        property.setDefaultValue(value);
        property.setSQLType(12);
        properties.add((Object)property);
    }

    public static ServerComponent getServerComponentForJob(JFJob job) throws RemoteException, MdException {
        if (job == null) {
            return null;
        }
        for (Object obj : job.getTargetSpecifications()) {
            if (!(obj instanceof ServerComponent)) continue;
            return (ServerComponent)obj;
        }
        String lsFQID = null;
        Property property = CommandUtilities.getServerComponentPropertyForJob(job);
        lsFQID = property != null ? property.getDefaultValue() : m_datastepserverID;
        return CommandUtilities.getServerComponentForJob(job, lsFQID);
    }

    public static ServerComponent getWorkspaceServerComponentForJob(JFJob jfjob) throws RemoteException, MdException {
        AssociationList cl = jfjob.getComputeLocations();
        ServerContext sc = null;
        if (cl.size() > 0) {
            sc = (ServerContext)cl.get(0);
        }
        if (sc != null) {
            return IWorkspaceServer.getWorkspace(sc, "440196D4-90F0-11D0-9F41-00A024BB830C");
        }
        return null;
    }

    public static ServerComponent getWorkspaceServerComponentFromBatchServer(ServerComponent batchserver) throws RemoteException, MdException {
        try {
            LogicalServer lc = (LogicalServer)batchserver.getUsedByComponents().get(0);
            ServerContext sc = (ServerContext)lc.getUsedByComponents().get(0);
            if (sc != null) {
                return IWorkspaceServer.getWorkspace(sc, "440196D4-90F0-11D0-9F41-00A024BB830C");
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return null;
        }
        return null;
    }

    public static boolean saveToRemoteFile(IFileService rio, String strFullName, Machine machine, int operatingSystem, String strTextToStore) throws GenericError {
        String temp = strFullName.toLowerCase();
        if (temp.startsWith(HDFSPrefix)) {
            String stripped = strFullName.substring(HDFSPrefix.length() - 1);
            return CommandUtilities.saveToHDFSFile(rio, stripped, machine, strTextToStore);
        }
        if (temp.startsWith(MAPRPrefix)) {
            String stripped = strFullName.substring(MAPRPrefix.length() - 1);
            return CommandUtilities.saveToHDFSFile(rio, stripped, machine, strTextToStore);
        }
        return CommandUtilities.saveToRemoteFile(rio, strFullName, operatingSystem, strTextToStore);
    }

    public static boolean saveToRemoteFile(IWorkspace iworkspace, String strFullName, Machine machine, int operatingSystem, String strTextToStore) throws GenericError, SchedulerException {
        String temp = strFullName.toLowerCase();
        if (temp.startsWith(HDFSPrefix)) {
            String stripped = strFullName.substring(HDFSPrefix.length() - 1);
            return CommandUtilities.saveToHDFSFile3(iworkspace, stripped, machine, strTextToStore);
        }
        if (temp.startsWith(MAPRPrefix)) {
            String stripped = strFullName.substring(MAPRPrefix.length() - 1);
            return CommandUtilities.saveToHDFSFile3(iworkspace, stripped, machine, strTextToStore);
        }
        return CommandUtilities.saveToRemoteFile(iworkspace, strFullName, operatingSystem, strTextToStore);
    }

    public static boolean saveToRemoteFile(IFileService rio, String strFullName, String strTextToStore) throws GenericError {
        return CommandUtilities.saveToRemoteFile(rio, strFullName, "", strTextToStore, Short.MAX_VALUE);
    }

    public static boolean saveToRemoteFile(IFileService rio, String strFullName, int host, String strTextToStore) throws GenericError {
        String hostopts = "";
        int blocksize = Short.MAX_VALUE;
        if (host == 2 && strFullName.indexOf("/") < 0) {
            blocksize = 0;
        }
        return CommandUtilities.saveToRemoteFile(rio, strFullName, hostopts, strTextToStore, blocksize);
    }

    public static boolean saveToRemoteFile(IWorkspace iworkspace, String strFullName, int host, String strTextToStore) throws GenericError, SchedulerException {
        String hostopts = "";
        int blocksize = Short.MAX_VALUE;
        if (host == 2 && strFullName.indexOf("/") < 0) {
            blocksize = 0;
        }
        return CommandUtilities.saveToRemoteFile(iworkspace, strFullName, hostopts, strTextToStore, blocksize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveToRemoteFile(IFileService rio, String strFullName, String hostopts, String strTextToStore, int blocksize) throws GenericError {
        String tempFileName = "TempSave";
        IFileref fileRef = null;
        ITextStream textStream = null;
        try {
            fileRef = rio.AssignFileref(tempFileName, "DISK", strFullName, hostopts, new StringHolder("test"));
            textStream = fileRef.OpenTextStream(StreamOpenMode.StreamOpenModeForWriting, blocksize);
            textStream.Write(strTextToStore);
            boolean bl = true;
            return bl;
        }
        finally {
            if (textStream != null) {
                textStream.Close();
            }
            if (fileRef != null) {
                rio.DeassignFileref(tempFileName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveToHDFSFile(IFileService rio, String strFullName, Machine machine, String strTextToStore) throws GenericError {
        String cfg;
        int blocksize = Short.MAX_VALUE;
        String hadoopopts = "recfm=v lrecl=" + blocksize + " bufferlen=" + blocksize;
        String tempFileName = "TempSave";
        IFileref fileRef = null;
        ITextStream textStream = null;
        if (MetaUtilities.isDebug()) {
            hadoopopts = hadoopopts + " DEBUG";
        }
        if ((cfg = CommandUtilities.buildHadoopConfig(rio, machine)) == null) {
            return false;
        }
        hadoopopts = hadoopopts + " cfg=" + cfg;
        try {
            StringHolder nameHolder = new StringHolder();
            fileRef = rio.AssignFileref("", "HADOOP", strFullName, hadoopopts, nameHolder);
            textStream = fileRef.OpenTextStream(StreamOpenMode.StreamOpenModeForWriting, blocksize);
            textStream.Write(strTextToStore);
            boolean bl = true;
            return bl;
        }
        catch (GenericError e) {
            String hadoopJars = System.getenv("SAS_HADOOP_JAR_PATH");
            if (hadoopJars == null) {
                RuntimeException re = new RuntimeException(m_bundle.getString("CommandUtilities.ErrorMsg.MissingHadoopConfiguration.txt"));
                re.initCause(e);
                throw re;
            }
            if (MetaUtilities.isDebug()) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            if (MetaUtilities.isDebug()) {
                e.printStackTrace();
            }
        }
        finally {
            if (textStream != null) {
                textStream.Close();
            }
            if (fileRef != null) {
                rio.DeassignFileref(fileRef.FilerefName());
            }
            rio.DeassignFileref(cfg);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveToHDFSFile2(IWorkspace iworkspace, String strFullName, Machine machine, String strTextToStore) throws GenericError {
        String cfg;
        IFileService rio = iworkspace.FileService();
        int blocksize = Short.MAX_VALUE;
        String hadoopopts = "recfm=v lrecl=" + blocksize + " bufferlen=" + blocksize;
        String tempFileName = "TempSave";
        IFileref fileRef = null;
        ITextStream textStream = null;
        submitSAS sas = null;
        if (MetaUtilities.isDebug()) {
            hadoopopts = hadoopopts + " DEBUG";
        }
        if ((cfg = CommandUtilities.buildHadoopConfig(rio, machine)) == null) {
            return false;
        }
        hadoopopts = hadoopopts + " cfg=" + cfg + " user=johenr";
        try {
            StringBuffer optionsstmt = new StringBuffer();
            optionsstmt.append("options set=SAS_HADOOP_RESTFUL='1';\n");
            StringBuffer filenamestmt = new StringBuffer();
            filenamestmt.append("filename ");
            filenamestmt.append(tempFileName);
            filenamestmt.append(" HADOOP '" + strFullName + "' ");
            filenamestmt.append(hadoopopts);
            filenamestmt.append(";");
            sas = new submitSAS(iworkspace);
            sas.submitStatements(optionsstmt.append(filenamestmt));
            if (MetaUtilities.isDebug()) {
                StringBuffer log = sas.getLog();
                System.out.println(log.toString());
            }
            fileRef = rio.UseFileref(tempFileName);
            textStream = fileRef.OpenTextStream(StreamOpenMode.StreamOpenModeForWriting, blocksize);
            textStream.Write(strTextToStore);
            boolean log = true;
            return log;
        }
        catch (GenericError e) {
            String hadoopJars = System.getenv("SAS_HADOOP_JAR_PATH");
            if (hadoopJars == null) {
                RuntimeException re = new RuntimeException(m_bundle.getString("CommandUtilities.ErrorMsg.MissingHadoopConfiguration.txt"));
                re.initCause(e);
                throw re;
            }
            if (MetaUtilities.isDebug()) {
                if (sas != null) {
                    StringBuffer log = sas.getLog();
                    System.out.println(log.toString());
                }
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            if (MetaUtilities.isDebug()) {
                if (sas != null) {
                    StringBuffer log = sas.getLog();
                    System.out.println(log.toString());
                }
                e.printStackTrace();
            }
        }
        finally {
            if (textStream != null) {
                textStream.Close();
            }
            if (fileRef != null) {
                rio.DeassignFileref(tempFileName);
            }
            rio.DeassignFileref(cfg);
        }
        return false;
    }

    public static boolean saveToHDFSFile3(IWorkspace iworkspace, String strFullName, Machine machine, String strTextToStore) throws GenericError {
        try {
            Scheduler sch = MetaUtilities.getSchedulerServerOnMachine("ff3aab60-8926-4e88-8af3-4287787d7d7", machine);
            if (sch != null) {
                SchedulerServerInfo ssi = sch.getServerComponent();
                OozieDeployJob job = new OozieDeployJob(null, ssi);
                job.deploy(strFullName, strTextToStore);
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
        catch (MdException e) {
            e.printStackTrace();
            return false;
        }
        catch (OozieException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveToHDFSFile(IWorkspace iworkspace, String strFullName, Machine machine, String strTextToStore) throws GenericError {
        String cfg;
        IFileService rio = iworkspace.FileService();
        int blocksize = Short.MAX_VALUE;
        String hadoopopts = "recfm=v lrecl=" + blocksize + " bufferlen=" + blocksize;
        String tempFileName = "TempSave";
        IFileref fileRef = null;
        ITextStream textStream = null;
        submitSAS sas = null;
        if (MetaUtilities.isDebug()) {
            hadoopopts = hadoopopts + " DEBUG";
        }
        if ((cfg = CommandUtilities.buildHadoopConfig(rio, machine)) == null) {
            return false;
        }
        hadoopopts = hadoopopts + " cfg=" + cfg;
        try {
            StringBuffer filenamestmt = new StringBuffer();
            filenamestmt.append("filename ");
            filenamestmt.append(tempFileName);
            filenamestmt.append(" HADOOP '" + strFullName + "' ");
            filenamestmt.append(hadoopopts);
            filenamestmt.append(";");
            sas = new submitSAS(iworkspace);
            sas.submitStatements(filenamestmt);
            if (MetaUtilities.isDebug()) {
                StringBuffer log = sas.getLog();
                System.out.println(log.toString());
            }
            fileRef = rio.UseFileref(tempFileName);
            textStream = fileRef.OpenTextStream(StreamOpenMode.StreamOpenModeForWriting, blocksize);
            textStream.Write(strTextToStore);
            boolean log = true;
            return log;
        }
        catch (GenericError e) {
            StringHolder valueHolder;
            IUtilities iUtil;
            IHostSystem iHost;
            boolean valueExists;
            String hadoopJars = System.getenv("SAS_HADOOP_JAR_PATH");
            if (hadoopJars == null && !(valueExists = (iHost = (iUtil = iworkspace.Utilities()).HostSystem()).GetEnv("SAS_HADOOP_JAR_PATH", valueHolder = new StringHolder()))) {
                RuntimeException re = new RuntimeException(m_bundle.getString("CommandUtilities.ErrorMsg.MissingHadoopConfiguration.txt"));
                re.initCause(e);
                throw re;
            }
            if (MetaUtilities.isDebug()) {
                if (sas != null) {
                    StringBuffer log = sas.getLog();
                    System.out.println(log.toString());
                }
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            if (MetaUtilities.isDebug()) {
                if (sas != null) {
                    StringBuffer log = sas.getLog();
                    System.out.println(log.toString());
                }
                e.printStackTrace();
            }
        }
        finally {
            if (textStream != null) {
                textStream.Close();
            }
            if (fileRef != null) {
                rio.DeassignFileref(tempFileName);
            }
            rio.DeassignFileref(cfg);
        }
        return false;
    }

    private static String buildHadoopConfig(IFileService rio, Machine machine) {
        ITextStream file;
        StringHolder assignedName;
        block14: {
            String nameNode = null;
            String jobTracker = null;
            String restpath = null;
            try {
                Scheduler sch = MetaUtilities.getSchedulerServerOnMachine("ff3aab60-8926-4e88-8af3-4287787d7d7", machine);
                if (sch != null) {
                    SchedulerServerInfo ssi = sch.getServerComponent();
                    nameNode = ssi.getNameNode();
                    jobTracker = ssi.getJobTracker();
                    restpath = ssi.getWebNameNode().substring(7);
                }
            }
            catch (RemoteException e) {
                if (MetaUtilities.isDebug()) {
                    e.printStackTrace();
                }
                return null;
            }
            catch (MdException e) {
                if (MetaUtilities.isDebug()) {
                    e.printStackTrace();
                }
                return null;
            }
            String filerefName = "SCHCFG";
            String physicalName = "";
            String accessMethodOrDevice = "TEMP";
            String hostOptions = "lrecl=1024";
            assignedName = new StringHolder(filerefName);
            IFileref fileref = null;
            file = null;
            try {
                fileref = rio.AssignFileref(filerefName, accessMethodOrDevice, physicalName, hostOptions, assignedName);
                file = fileref.OpenTextStream(StreamOpenMode.StreamOpenModeForWriting, Short.MAX_VALUE);
                StringBuffer content = new StringBuffer();
                content.append("<configuration>");
                content.append("<property>");
                content.append("  <name>fs.default.name</name>");
                content.append("  <value>" + nameNode + "</value>");
                content.append("</property>");
                content.append("<property>");
                content.append("  <name>dfs.http.address</name>");
                content.append("  <value>" + restpath + "</value>");
                content.append("</property>");
                content.append("<property>");
                content.append("  <name>mapred.job.tracker</name>");
                content.append("  <value>" + jobTracker + "</value>");
                content.append("</property>");
                content.append("<property>");
                content.append("  <name>hadoop.security.authentication</name>");
                content.append("  <value>kerberos</value>");
                content.append("</property>");
                content.append("</configuration>");
                content.append("");
                file.Write(content.toString());
            }
            catch (GenericError ge) {
                if (MetaUtilities.isDebug()) {
                    ge.printStackTrace();
                }
                if (fileref == null) break block14;
                try {
                    rio.DeassignFileref(filerefName);
                }
                catch (GenericError genericError) {
                    // empty catch block
                }
            }
        }
        if (file != null) {
            try {
                file.Close();
            }
            catch (GenericError genericError) {
                // empty catch block
            }
            file = null;
            return assignedName.value;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveToRemoteFile(IWorkspace iworkspace, String strFullName, String hostopts, String strTextToStore, int blocksize) throws GenericError, SchedulerException {
        IFileService rio = iworkspace.FileService();
        String tempFileName = "TempSave";
        ITextStream textStream = null;
        try {
            StringBuffer filenamestmt = new StringBuffer();
            filenamestmt.append("filename ");
            filenamestmt.append(tempFileName);
            filenamestmt.append(" '" + strFullName + "' ");
            filenamestmt.append(hostopts);
            filenamestmt.append(";");
            submitSAS sas = new submitSAS(iworkspace);
            sas.submitStatements(filenamestmt);
            IFileref fileRef = rio.UseFileref(tempFileName);
            textStream = fileRef.OpenTextStream(StreamOpenMode.StreamOpenModeForWriting, blocksize);
            textStream.Write(strTextToStore);
            boolean bl = true;
            return bl;
        }
        finally {
            if (textStream != null) {
                textStream.Close();
            }
            rio.DeassignFileref(tempFileName);
        }
    }

    public static StringBuffer readFromRemoteFile(IFileService rio, String strFullName) throws GenericError {
        return CommandUtilities.readFromRemoteFile(rio, strFullName, "", null, -1);
    }

    public static StringBuffer readFromRemoteFile(IFileService rio, String strFullName, String options) throws GenericError {
        return CommandUtilities.readFromRemoteFile(rio, strFullName, options, null);
    }

    public static StringBuffer readFromRemoteFile(IFileService rio, String strFullName, int host) throws GenericError {
        return CommandUtilities.readFromRemoteFile(rio, strFullName, "", null, host);
    }

    public static StringBuffer readFromRemoteFile(IFileService rio, String strFullName, String options, int host) throws GenericError {
        return CommandUtilities.readFromRemoteFile(rio, strFullName, options, null, host);
    }

    public static StringBuffer readFromRemoteFile(IFileService rio, String strFullName, String options, String encoding) throws GenericError {
        return CommandUtilities.readFromRemoteFile(rio, strFullName, options, encoding, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuffer readFromRemoteFile(IFileService rio, String strFullName, String options, String encoding, int host) throws GenericError {
        String tempFileName = "TempRead";
        StringBuffer buffer = new StringBuffer();
        ITextStream textStream = null;
        int blocksize = Short.MAX_VALUE;
        if (host == 2 && strFullName.indexOf("/") < 0) {
            blocksize = 0;
        }
        if (encoding != null) {
            StringBuffer filerefopt = new StringBuffer();
            filerefopt.append("encoding='" + encoding + "' ");
            if (options != null) {
                filerefopt.append(options);
            }
            options = filerefopt.toString();
        }
        try {
            IFileref fileRef = rio.AssignFileref(tempFileName, "DISK", strFullName, options, new StringHolder());
            textStream = fileRef.OpenTextStream(StreamOpenMode.StreamOpenModeForReading, blocksize);
            LongSeqHolder mark = new LongSeqHolder();
            StringSeqHolder lines = new StringSeqHolder();
            boolean done = false;
            int readLines = 1000;
            while (!done) {
                textStream.ReadLines(readLines, mark, lines);
                if (lines.value.length < readLines) {
                    done = true;
                }
                for (int i = 0; i < lines.value.length; ++i) {
                    buffer.append(lines.value[i]);
                    buffer.append("\n");
                }
            }
            StringBuffer stringBuffer = buffer;
            return stringBuffer;
        }
        finally {
            if (textStream != null) {
                textStream.Close();
            }
            rio.DeassignFileref(tempFileName);
        }
    }

    public static char getPathSeparator(int targetOS) {
        char separator = '\u0000';
        switch (targetOS) {
            default: 
        }
        separator = '/';
        return separator;
    }

    public static String normalizePath(String name, int targetOS) {
        String norm = null;
        switch (targetOS) {
            case 3: {
                if (!name.startsWith("\"") && !name.startsWith("'")) break;
                norm = name.substring(1, name.length() - 2);
                break;
            }
            case 0: {
                if (name.startsWith("\\\\")) {
                    norm = "\\\\" + MetaUtilities.normalize(MetaUtilities.replaceString(name.substring(2), "\\", "/"));
                    break;
                }
                if (name.startsWith("\"\\\\")) {
                    norm = "\"\\\\" + MetaUtilities.normalize(MetaUtilities.replaceString(name.substring(3), "\\", "/"));
                    break;
                }
                norm = MetaUtilities.normalize(MetaUtilities.replaceString(name, "\\", "/"));
                break;
            }
            case 2: {
                norm = name;
                break;
            }
            case 1: {
                if (-1 != name.indexOf(" ") && !name.startsWith("\"")) {
                    norm = "\"" + name + "/\"";
                    break;
                }
                norm = name;
                break;
            }
            default: {
                norm = MetaUtilities.replaceString(name, "\\", "/");
            }
        }
        return norm;
    }

    public static String normalizeFullPath(String name, int targetOS) {
        String norm = null;
        switch (targetOS) {
            case 3: {
                if (!name.startsWith("\"") && !name.startsWith("'")) break;
                norm = name.substring(1, name.length() - 2);
                break;
            }
            case 0: {
                if (name.startsWith("\\\\")) {
                    norm = "\\\\" + MetaUtilities.normalize(MetaUtilities.replaceString(name.substring(2), "\\", "/"));
                    break;
                }
                if (name.startsWith("\"\\\\")) {
                    norm = "\"\\\\" + MetaUtilities.normalize(MetaUtilities.replaceString(name.substring(3), "\\", "/"));
                    break;
                }
                norm = MetaUtilities.normalize(MetaUtilities.replaceString(name, "\\", "/"));
                break;
            }
            case 2: {
                norm = name;
                break;
            }
            case 1: {
                if (-1 != name.indexOf(" ") && !name.startsWith("\"")) {
                    norm = "\"" + name + "\"";
                    break;
                }
                norm = name;
                break;
            }
            default: {
                norm = MetaUtilities.replaceString(name, "\\", "/");
            }
        }
        return norm;
    }

    public static String createFullPath(String strDirectory, String strFilename, int host) {
        String strFullPath = "";
        if (strDirectory == null || strFilename == null) {
            return strFullPath;
        }
        switch (host) {
            case 3: {
                String dir = strDirectory;
                if (strDirectory.startsWith("\"") || strDirectory.startsWith("'")) {
                    dir = strDirectory.substring(1, strDirectory.length() - 2);
                }
                if (dir.startsWith("/")) {
                    String device = dir.substring(1, dir.indexOf(47, 1));
                    String sdir = dir.substring(device.length() + 2);
                    if (sdir.endsWith("/")) {
                        sdir = sdir.substring(0, sdir.length() - 1);
                    }
                    sdir = MetaUtilities.replaceString(sdir, "/", ".");
                    strFullPath = "\"" + device + ":[" + sdir + "]" + strFilename + "\"";
                    break;
                }
                strFullPath = "\"" + dir + strFilename + "\"";
                break;
            }
            case 0: {
                if (-1 != strDirectory.indexOf(" ") && !strDirectory.startsWith("\"")) {
                    strFullPath = "\"" + strDirectory + "\\" + strFilename + "\"";
                    break;
                }
                if (strDirectory.endsWith("\"")) {
                    String strippedDir = strDirectory.substring(0, strDirectory.length() - 1);
                    String separator = "";
                    if (!strippedDir.endsWith("\\") && !strippedDir.endsWith("/")) {
                        separator = "\\";
                    }
                    strFullPath = strippedDir + separator + strFilename + "\"";
                    break;
                }
                String separator = "";
                if (!strDirectory.endsWith("\\") && !strDirectory.endsWith("/")) {
                    separator = "\\";
                }
                strFullPath = strDirectory + separator + strFilename;
                break;
            }
            case 2: {
                strFullPath = CommandUtilities.createFullPDSPath(strDirectory, strFilename);
                break;
            }
            case 1: {
                if (-1 != strDirectory.indexOf(" ") && !strDirectory.startsWith("\"")) {
                    strFullPath = "\"" + strDirectory + "/" + strFilename + "\"";
                    break;
                }
                if (strDirectory.endsWith("\"")) {
                    String strippedDir = strDirectory.substring(0, strDirectory.length() - 1);
                    String separator = "";
                    if (!strippedDir.endsWith("/")) {
                        separator = "/";
                    }
                    strFullPath = strippedDir + separator + strFilename + "\"";
                    break;
                }
                String separator = "";
                if (!strDirectory.endsWith("/")) {
                    separator = "/";
                }
                strFullPath = strDirectory + separator + strFilename;
                break;
            }
            default: {
                if (-1 != strDirectory.indexOf(" ") && !strDirectory.startsWith("\"")) {
                    strFullPath = "\"" + strDirectory + "/" + strFilename + "\"";
                    break;
                }
                if (strDirectory.endsWith("\"")) {
                    String strippedDir = strDirectory.substring(0, strDirectory.length() - 1);
                    String separator = "";
                    if (!strippedDir.endsWith("\\") && !strippedDir.endsWith("/")) {
                        separator = "/";
                    }
                    strFullPath = strippedDir + separator + strFilename + "\"";
                    break;
                }
                String separator = "";
                if (!strDirectory.endsWith("\\") && !strDirectory.endsWith("/")) {
                    separator = "/";
                }
                strFullPath = strDirectory + separator + strFilename;
            }
        }
        return strFullPath;
    }

    public static String createFullPDSPath(String strDirectory, String strFilename) {
        String strFullPath = "";
        if (strDirectory == null || strFilename == null) {
            return strFullPath;
        }
        String dir = strDirectory;
        if (strDirectory.startsWith("\"") || strDirectory.startsWith("'")) {
            dir = strDirectory.substring(1, strDirectory.length() - 2);
        }
        if (dir.indexOf("/") >= 0) {
            if (-1 != strDirectory.indexOf(" ") && !strDirectory.startsWith("\"")) {
                strFullPath = "\"" + strDirectory + "/" + strFilename + "\"";
            } else if (strDirectory.endsWith("\"")) {
                String strippedDir = strDirectory.substring(0, strDirectory.length() - 1);
                String separator = "";
                if (!strippedDir.endsWith("/")) {
                    separator = "/";
                }
                strFullPath = strippedDir + separator + strFilename + "\"";
            } else {
                String separator = "";
                if (!strDirectory.endsWith("/")) {
                    separator = "/";
                }
                strFullPath = strDirectory + separator + strFilename;
            }
        } else {
            String membername = strFilename;
            int index = strFilename.indexOf(".");
            if (index > 0) {
                membername = strFilename.substring(0, strFilename.indexOf("."));
            }
            strFullPath = dir + "(" + membername.toUpperCase() + ")";
        }
        return strFullPath;
    }

    public static String getOutfile(ServerComponent sc, String infile) {
        String outfile = null;
        outfile = infile.endsWith("\"") ? infile.substring(0, infile.length() - 1) + ".out\"" : infile + ".out";
        return outfile;
    }

    private static ServerComponent getServerComponentForJob(JFJob job, String lsFQID) throws RemoteException, MdException {
        for (Object obj : job.getTargetSpecifications()) {
            if (!(obj instanceof ServerComponent)) continue;
            return (ServerComponent)obj;
        }
        if (lsFQID == null) {
            return null;
        }
        if (lsFQID.equalsIgnoreCase(m_datastepserverID) || lsFQID.equalsIgnoreCase(m_javaserverID) || lsFQID.equalsIgnoreCase(m_dmpexeserverID) || lsFQID.equalsIgnoreCase(m_genericserverID)) {
            ServerComponent batchComponent = CommandUtilities.findServerComponentForJob(job, lsFQID, 0);
            if (batchComponent != null) {
                job.getTargetSpecifications().clear();
                job.getTargetSpecifications().add((Object)batchComponent);
            }
            return batchComponent;
        }
        AssociationList cl = job.getComputeLocations();
        if (cl.size() == 0) {
            return null;
        }
        ServerComponent batchComponent = null;
        ServerComponent sc2 = (ServerComponent)cl.get(0);
        if (sc2 instanceof ServerContext) {
            AssociationList usingComponents = sc2.getUsingComponents();
            block1: for (LogicalServer logicalServer : usingComponents) {
                String classID = logicalServer.getClassIdentifier();
                if (!classID.equalsIgnoreCase(m_datastepserverID) && !classID.equalsIgnoreCase(m_javaserverID) && !classID.equalsIgnoreCase(m_dmpexeserverID) && !classID.equalsIgnoreCase(m_genericserverID)) continue;
                if (lsFQID != null && logicalServer.getFQID().equalsIgnoreCase(lsFQID)) {
                    batchComponent = (ServerComponent)logicalServer.getUsingComponents().get(0);
                    break;
                }
                if (lsFQID != null) {
                    for (ServerComponent sc2 : logicalServer.getUsingComponents()) {
                        if (!sc2.getFQID().equalsIgnoreCase(lsFQID)) continue;
                        batchComponent = sc2;
                        continue block1;
                    }
                    continue;
                }
                if (!classID.equalsIgnoreCase(m_datastepserverID)) continue;
                batchComponent = (ServerComponent)logicalServer.getUsingComponents().get(0);
                break;
            }
        } else {
            batchComponent = sc2;
        }
        if (batchComponent != null) {
            job.getTargetSpecifications().clear();
            job.getTargetSpecifications().add((Object)batchComponent);
        }
        return batchComponent;
    }

    private static String getCommandLineFromOldBatchServer(JFJob job, String sascommand, String logdir, String rollingparm, String flowname) throws MdException, RemoteException {
        String commandLineOptions = " -batch -noterminal -sysin ";
        String log = " -log ";
        String logparms = " -logparm \"rollover=session\" ";
        String rollinglog = "_#Y.#m.#d_#H.#M.#s";
        String sasfilename = "";
        String sasfullname = "";
        AssociationList files = job.getSourceCodes();
        if (files.size() != 0) {
            sasfilename = ((File)files.get(0)).getFileName();
            if (((File)files.get(0)).getFileExtension().length() != 0) {
                sasfilename = sasfilename + "." + ((File)files.get(0)).getFileExtension();
            }
            if (((File)files.get(0)).getDirectories().size() != 0) {
                String dirName = ((Directory)((File)files.get(0)).getDirectories().get(0)).getDirectoryName();
                sasfullname = CommandUtilities.createFullPath(dirName, sasfilename, -1);
            } else {
                sasfullname = sasfilename;
            }
        }
        if (rollingparm != null && !rollingparm.equalsIgnoreCase("")) {
            rollinglog = rollingparm;
        }
        String strLoggingOptions = "";
        if (!logdir.equalsIgnoreCase("")) {
            String logname = null;
            int endpos = sasfilename.indexOf(".sas");
            logname = endpos > 0 ? sasfilename.substring(0, endpos) + rollinglog + ".log" : sasfilename + rollinglog + ".log";
            if (m_allowFlowPrefix && flowname != null) {
                logname = flowname + "_" + logname;
            }
            logname = CommandUtilities.createFullPath(logdir, logname, -1);
            strLoggingOptions = logparms + log + logname;
        }
        sascommand = sascommand + commandLineOptions + sasfullname + strLoggingOptions;
        return sascommand;
    }

    private static String escapePercents(String input) {
        int j = input.length();
        StringBuffer output = new StringBuffer(j);
        for (int i = 0; i < j; ++i) {
            if (input.charAt(i) == '%') {
                output.append("%%");
                if (input.charAt(i + 1) != '%') continue;
                ++i;
                continue;
            }
            output.append(input.charAt(i));
        }
        return output.toString();
    }

    public static boolean needsQuoting(String command) {
        if (-1 != command.indexOf(" ") && !command.startsWith("\"") && !command.startsWith("'")) {
            String firstspace = command.substring(command.indexOf(" "));
            boolean foundNonDashOrSlash = false;
            for (int i = 0; i < firstspace.length(); ++i) {
                char c = firstspace.charAt(i);
                if (c == ' ') continue;
                if (c == '-') {
                    return false;
                }
                if (foundNonDashOrSlash && (c == '\\' || c == '/')) {
                    return true;
                }
                if (c == '\\' || c == '/') {
                    return false;
                }
                if (c == ' ') continue;
                foundNonDashOrSlash = true;
            }
            return true;
        }
        return false;
    }

    public static String quoteCommand(String command) {
        return "\"" + command + "\"";
    }
}

