/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.build;

import com.sas.iom.SAS.IFileService;
import com.sas.iom.SAS.IFileref;
import com.sas.iom.SAS.ITextStream;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SAS.StreamOpenMode;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.scheduler.api.build.ImportFlowFromFile;
import com.sas.scheduler.api.build.ImportFlowInterface;
import com.sas.scheduler.api.servers.sasprocs.submitSAS;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.SchedulerException;
import java.rmi.RemoteException;
import java.security.InvalidParameterException;
import java.util.Vector;
import org.omg.CORBA.StringHolder;

public class ImportFlowFromCSV
extends submitSAS
implements ImportFlowInterface {
    private String m_infile = null;
    private FlowInfo m_flow = null;
    private MdObjectStore m_store = null;
    private String m_repos = null;
    private String m_name = null;

    public ImportFlowFromCSV(String infile, IWorkspace workspace, MdObjectStore store, String repos) {
        super(workspace);
        this.m_infile = infile;
        this.m_store = store;
        this.m_repos = repos;
    }

    @Override
    public FlowInfo getFlowInfo() {
        return this.m_flow;
    }

    @Override
    public boolean setName(String name) {
        this.m_name = name;
        return true;
    }

    @Override
    public String getName() {
        return this.m_flow != null ? this.m_flow.getName() : this.m_name;
    }

    @Override
    public boolean parse(int maxPredecessors) throws InvalidParameterException, SchedulerException, RemoteException {
        if (this.m_workspace != null) {
            IFileService rio_file = this.m_workspace.FileService();
            String fileref = "tempCSV";
            String accessMethodOrDevice = "DISK";
            String physicalName = this.m_infile;
            String hostOptions = "encoding='UTF8'";
            StringHolder assignedName = new StringHolder(fileref);
            ITextStream file = null;
            IFileref fileRef = null;
            try {
                fileRef = rio_file.AssignFileref(fileref, accessMethodOrDevice, physicalName, hostOptions, assignedName);
                file = fileRef.OpenTextStream(StreamOpenMode.StreamOpenModeForReading, 1024);
                Vector vars = FlowInfo.getColumns((boolean)false);
                this.m_flow = ImportFlowFromFile.processFlow(this.m_name, file, vars, maxPredecessors, this.m_store, this.m_repos);
                file.Close();
            }
            catch (GenericError ge) {
                if (file != null) {
                    try {
                        file.Close();
                    }
                    catch (GenericError genericError) {
                        // empty catch block
                    }
                    file = null;
                }
                SchedulerException se = new SchedulerException();
                se.initCause((Throwable)ge);
                throw se;
            }
            try {
                rio_file.DeassignFileref(fileref);
            }
            catch (GenericError ge) {
                this.m_store.getFactory().getUtil().printOutputln(ge.getMessage());
            }
            catch (RuntimeException rte) {
                this.m_store.getFactory().getUtil().printOutputln(rte.toString());
            }
        }
        return true;
    }
}

