/*
 * Decompiled with CFR 0.152.
 */
package MITI.converter.etl;

import MITI.bridges.bridgelib.MIRBridgeLib;
import MITI.converter.etl.ETLContext;
import MITI.converter.etl.TableBlock;
import MITI.messages.MIRModelBridge.BLIB;
import MITI.messages.MIRModelConverter.MBCONV;
import MITI.sdk.MIRClassifier;
import MITI.sdk.MIRClassifierMap;
import MITI.sdk.MIRFeature;
import MITI.sdk.MIRFeatureMap;
import MITI.sdk.MIRQueryTable;
import MITI.sdk.MIRSqlQuery;
import MITI.sdk.MIRTransformationDataSet;

public class QueryBlock {
    private MIRSqlQuery from;
    private TableBlock outputTableBlock;

    private QueryBlock(MIRSqlQuery mIRSqlQuery) {
        this.from = mIRSqlQuery;
    }

    public static QueryBlock fromSubQuery(MIRSqlQuery mIRSqlQuery) {
        return QueryBlock.fromQuery(mIRSqlQuery);
    }

    public static QueryBlock fromQuery(MIRSqlQuery mIRSqlQuery) {
        BLIB.DBG_DEBUG.log("Processing Sql Query '" + mIRSqlQuery.getName() + "'");
        QueryBlock queryBlock = new QueryBlock(mIRSqlQuery);
        if (mIRSqlQuery.getOutputTransformationDataSets().size() > 0) {
            TableBlock tableBlock;
            MIRTransformationDataSet mIRTransformationDataSet = mIRSqlQuery.getOutputTransformationDataSets().first();
            MIRQueryTable mIRQueryTable = (MIRQueryTable)mIRTransformationDataSet;
            queryBlock.outputTableBlock = tableBlock = TableBlock.fromTable(mIRQueryTable);
            MIRClassifierMap mIRClassifierMap = mIRQueryTable.getDestinationOfClassifierMap();
            if (mIRClassifierMap != null) {
                for (MIRClassifier mIRClassifier : mIRClassifierMap.getSourceClassifiers()) {
                    Object object;
                    if (mIRClassifier == mIRQueryTable) continue;
                    MIRQueryTable mIRQueryTable2 = (MIRQueryTable)mIRClassifier;
                    MIRTransformationDataSet mIRTransformationDataSet2 = null;
                    MIRTransformationDataSet mIRTransformationDataSet3 = null;
                    TableBlock tableBlock2 = null;
                    if (mIRQueryTable2.getParent() != mIRSqlQuery) {
                        object = QueryBlock.fromQuery((MIRSqlQuery)mIRQueryTable2.getParent());
                        tableBlock2 = ((QueryBlock)object).getOutputTableBlock();
                    } else {
                        tableBlock2 = QueryBlock.fromTable(mIRQueryTable2);
                    }
                    if (tableBlock2 != null) {
                        mIRTransformationDataSet3 = tableBlock2.getOutput();
                    }
                    if (mIRTransformationDataSet3 != null) {
                        mIRTransformationDataSet2 = tableBlock.getInput(mIRQueryTable2);
                    }
                    if (mIRTransformationDataSet3 == null || mIRTransformationDataSet2 == null) continue;
                    object = mIRTransformationDataSet2.getDestinationOfClassifierMap();
                    if (object == null) {
                        object = new MIRClassifierMap();
                        ETLContext.model.addClassifierMap((MIRClassifierMap)object);
                        ((MIRClassifierMap)object).addDestinationClassifier(mIRTransformationDataSet2);
                    }
                    ((MIRClassifierMap)object).addSourceClassifier(mIRTransformationDataSet3);
                    for (MIRFeature mIRFeature : mIRTransformationDataSet2.getFeatures()) {
                        MIRFeatureMap mIRFeatureMap;
                        if (mIRFeature.getDestinationOfFeatureMap() != null) continue;
                        MIRFeature mIRFeature2 = null;
                        MIRFeature mIRFeature3 = tableBlock.getOriginalFeature(mIRFeature);
                        if (mIRQueryTable.containsFeature(mIRFeature3)) {
                            mIRFeatureMap = mIRFeature3.getDestinationOfFeatureMap();
                            if (mIRFeatureMap != null) {
                                for (MIRFeature mIRFeature4 : mIRFeatureMap.getSourceFeatures()) {
                                    if (mIRFeature4.getParent() != mIRQueryTable2) continue;
                                    mIRFeature2 = tableBlock2.getCopyofOriginalFeature(mIRTransformationDataSet3, mIRFeature4);
                                }
                            }
                        } else {
                            mIRFeature2 = mIRTransformationDataSet3.getFeature(MIRBridgeLib.getPhysicalName(mIRFeature));
                        }
                        if (mIRFeature2 != null) {
                            mIRFeatureMap = new MIRFeatureMap();
                            ((MIRClassifierMap)object).addFeatureMap(mIRFeatureMap);
                            mIRFeatureMap.addDestinationFeature(mIRFeature);
                            mIRFeatureMap.addSourceFeature(mIRFeature2);
                            continue;
                        }
                        MBCONV.CAN_NOT_FIND_SOURCE_FEATURE.log(mIRFeature.getName(), mIRTransformationDataSet2.getParent().getName(), mIRTransformationDataSet2.getName(), mIRTransformationDataSet3.getParent().getName(), mIRTransformationDataSet3.getName());
                    }
                }
            }
        }
        return queryBlock;
    }

    private static TableBlock fromTable(MIRQueryTable mIRQueryTable) {
        TableBlock tableBlock = TableBlock.fromTable(mIRQueryTable);
        MIRClassifierMap mIRClassifierMap = mIRQueryTable.getDestinationOfClassifierMap();
        if (mIRClassifierMap != null) {
            for (MIRClassifier mIRClassifier : mIRClassifierMap.getSourceClassifiers()) {
                Object object;
                MIRQueryTable mIRQueryTable2 = (MIRQueryTable)mIRClassifier;
                if (mIRQueryTable2 == mIRQueryTable) continue;
                MIRTransformationDataSet mIRTransformationDataSet = null;
                TableBlock tableBlock2 = null;
                if (mIRQueryTable2.getParent() != mIRQueryTable.getParent()) {
                    object = QueryBlock.fromQuery((MIRSqlQuery)mIRQueryTable2.getParent());
                    tableBlock2 = ((QueryBlock)object).getOutputTableBlock();
                } else {
                    tableBlock2 = QueryBlock.fromTable(mIRQueryTable2);
                }
                if (tableBlock2 != null) {
                    mIRTransformationDataSet = tableBlock2.getOutput();
                }
                if ((object = tableBlock.getInput(mIRQueryTable2)) != null) {
                    MIRClassifierMap mIRClassifierMap2 = new MIRClassifierMap();
                    ETLContext.model.addClassifierMap(mIRClassifierMap2);
                    mIRClassifierMap2.addSourceClassifier(mIRTransformationDataSet);
                    mIRClassifierMap2.addDestinationClassifier((MIRClassifier)object);
                    continue;
                }
                MBCONV.CAN_NOT_CONNECT_DATASETS.log(mIRTransformationDataSet != null ? mIRTransformationDataSet.getName() : "");
            }
        }
        return tableBlock;
    }

    public TableBlock getOutputTableBlock() {
        if (this.outputTableBlock != null) {
            TableBlock tableBlock = this.outputTableBlock;
            if (tableBlock == null) {
                MBCONV.TABLEBLOCK_NO_OUTPUT.log(this.outputTableBlock.getName());
            }
            return tableBlock;
        }
        MBCONV.NO_OUTPUT_TABLEBLOCK.log(this.getName());
        return null;
    }

    private String getName() {
        return this.from.getName();
    }
}

