/*
 * Decompiled with CFR 0.152.
 */
package MITI.converter;

import MITI.MIRException;
import MITI.bridges.bridgelib.MIRRelationalLib;
import MITI.bridges.bridgelib.MIRRolapLib;
import MITI.converter.MIRModelConverter;
import MITI.sdk.MIRModel;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRStoreModel;
import MITI.sdk.mix.MIRMixManager;
import java.io.File;

public class MIRErModelConverter
extends MIRModelConverter {
    private static final String NAME = "E/R";

    public MIRErModelConverter() {
        this.acceptsElement((short)2);
        this.acceptsStore((byte)2);
        this.acceptsStore((byte)3);
        this.acceptsStore((byte)1);
        this.acceptsStore((byte)0);
        this.acceptsStore((byte)4);
    }

    @Override
    protected String getName() {
        return NAME;
    }

    @Override
    protected boolean convert(File file) throws MIRException {
        MIRMixManager mIRMixManager = new MIRMixManager(file);
        MIRModel mIRModel = mIRMixManager.readFile(file);
        boolean bl = this.supports(mIRModel);
        if (bl && ((MIRObject)mIRModel).getElementType() == 2) {
            MIRStoreModel mIRStoreModel = (MIRStoreModel)mIRModel;
            if (mIRStoreModel.getStoreType() == 1 || mIRStoreModel.getStoreType() == 4) {
                this.convertModelStoreType(mIRStoreModel, (byte)0);
                MIRRolapLib mIRRolapLib = new MIRRolapLib();
                mIRRolapLib.reverseEngineerROLAPModel(mIRStoreModel);
            } else if (mIRStoreModel.getStoreType() == 2) {
                MIRRelationalLib.processUMLClassTypes(mIRStoreModel, false);
            }
            this.convertErModel(mIRStoreModel);
            mIRMixManager.writeFile(file, mIRStoreModel);
        }
        mIRModel.delete();
        return bl;
    }
}

