/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.connection;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.iom.orb.SASURI;
import com.sas.services.connection.BridgeServer;
import com.sas.services.connection.Credential;
import java.util.HashMap;
import java.util.Map;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class ZeroConfigWorkspaceServer
extends BridgeServer {
    private static final long serialVersionUID = 4945660785628290340L;
    private String _sasCommand;

    public ZeroConfigWorkspaceServer() {
        super("440196d4-90f0-11d0-9f41-00a024bb830c", "localhost", 0);
        this.setSecurityPackage("NTLM");
        this.setSecurityPackageList(null);
    }

    public ZeroConfigWorkspaceServer(String sasCommand) {
        this();
        this._sasCommand = sasCommand;
    }

    @Override
    public synchronized SASURI toURI(Credential credential, String cxID) {
        SASURI origURI = super.toURI(credential, cxID);
        Map origAttrMap = origURI.getSecureAttributes();
        HashMap<String, Object> zeroAttrMap = new HashMap<String, Object>(origAttrMap);
        zeroAttrMap.remove("port");
        zeroAttrMap.remove("domain");
        zeroAttrMap.put("zeroconfig", Boolean.TRUE);
        if (this._sasCommand != null) {
            zeroAttrMap.put("sascommand", this._sasCommand);
        }
        SASURI zeroURI = new SASURI("BRIDGE", zeroAttrMap);
        return zeroURI;
    }

    public void setSasCommand(String sasCommand) {
        this._sasCommand = sasCommand;
    }

    public String getSasCommand() {
        return this._sasCommand;
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        String thatSasCommand = ((ZeroConfigWorkspaceServer)that).getSasCommand();
        return !(this._sasCommand == null ? thatSasCommand != null : !this._sasCommand.equals(thatSasCommand));
    }

    @Override
    public int hashCode() {
        int hc = super.hashCode();
        if (this._sasCommand != null) {
            hc ^= this._sasCommand.hashCode();
        }
        return hc;
    }
}

