/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.connection;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.connection.Cluster;
import com.sas.services.connection.ConnectionFactoryUtil;
import com.sas.services.connection.Credential;
import com.sas.services.connection.FailoverCluster;
import com.sas.services.connection.Server;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class Puddle
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -9062810559912378857L;
    private Cluster[] _clusterArr;
    private Credential _serverCredential;
    private int _minSize;
    private int _minAvail;
    private Set _userCredentialSet;
    private Set _userSet;
    private String _puddleID;
    private String _puddleName;
    private String _classID;

    public Puddle(Server server, Credential serverCredential) {
        this(new FailoverCluster(server), serverCredential);
    }

    public Puddle(Cluster cluster, Credential serverCredential) {
        this(new Cluster[]{cluster}, serverCredential);
    }

    public Puddle(Cluster[] clusters, Credential serverCredential) {
        int i;
        if (clusters == null || clusters.length == 0) {
            throw new IllegalArgumentException("\"clusters\" cannot be null or empty.");
        }
        int len = clusters.length;
        for (i = 0; i < len; ++i) {
            if (clusters[i] != null) continue;
            throw new IllegalArgumentException("Element " + i + " of \"clusters\" cannot be null.");
        }
        this._classID = clusters[0].getClassID();
        for (i = 1; i < len; ++i) {
            if (this._classID.equals(clusters[i].getClassID())) continue;
            StringBuffer msgBuffer = new StringBuffer("All clusters in a puddle must have the same class ID. ");
            msgBuffer.append("Cluster 0 has class ID \"").append(this._classID).append("\", but cluster ");
            msgBuffer.append(i).append(" has classID \"").append(clusters[i].getClassID()).append("\".");
            throw new IllegalArgumentException(msgBuffer.toString());
        }
        if (serverCredential != null) {
            String credentialDomain = serverCredential.getDomain();
            for (int i2 = 0; i2 < len; ++i2) {
                String serverDomain = clusters[i2].getDomain();
                if (credentialDomain.equals(serverDomain)) continue;
                throw new IllegalArgumentException("The domain for element " + i2 + " of \"clusters\": \"" + serverDomain + "\" does not match the domain \"" + credentialDomain + "\" of the server credential.");
            }
        }
        this._clusterArr = clusters;
        this._serverCredential = serverCredential;
    }

    public void setClusterArray(Cluster[] clusterArray) {
        this._clusterArr = clusterArray;
    }

    public Cluster[] getClusterArray() {
        return this._clusterArr;
    }

    public void setServerCredential(Credential serverCredential) {
        this._serverCredential = serverCredential;
    }

    public Credential getServerCredential() {
        return this._serverCredential;
    }

    public void setMinSize(int minSize) {
        this._minSize = minSize;
    }

    public int getMinSize() {
        return this._minSize;
    }

    public void setMinAvail(int minAvail) {
        this._minAvail = minAvail;
    }

    public int getMinAvail() {
        return this._minAvail;
    }

    public void setUserCredentials(Set userCredentials) {
        for (Object o : userCredentials) {
            if (o instanceof Credential) continue;
            throw new IllegalArgumentException("All elements of \"userCredentials\" must be instances of com.sas.services.connection.Credential.");
        }
        this._userCredentialSet = userCredentials;
    }

    public Set getUserCredentials() {
        return this._userCredentialSet;
    }

    public void setUsers(Set users) {
        this._userSet = users;
    }

    public Set getUsers() {
        return this._userSet;
    }

    @SASScope
    public void setPuddleID(String puddleID) {
        this._puddleID = puddleID;
    }

    @SASScope
    public String getPuddleID() {
        return this._puddleID;
    }

    public void setPuddleName(String puddleName) {
        this._puddleName = puddleName;
    }

    public String getPuddleName() {
        return this._puddleName;
    }

    public String getClassID() {
        return this._classID;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || !this.getClass().getName().equals(that.getClass().getName())) {
            return false;
        }
        Puddle thatPuddle = (Puddle)that;
        if (this._minSize != thatPuddle.getMinSize() || this._minAvail != thatPuddle.getMinAvail()) {
            return false;
        }
        Cluster[] thoseClusters = thatPuddle.getClusterArray();
        if (this._clusterArr != thoseClusters) {
            if (this._clusterArr.length != thoseClusters.length) {
                return false;
            }
            for (int i = 0; i < this._clusterArr.length; ++i) {
                if (this._clusterArr[i].equals(thoseClusters[i])) continue;
                return false;
            }
        }
        Credential thatServerCredential = thatPuddle.getServerCredential();
        if (this._serverCredential == null ? thatServerCredential != null : !this._serverCredential.equals(thatServerCredential)) {
            return false;
        }
        Set thoseUserCredentials = thatPuddle.getUserCredentials();
        if (this._userCredentialSet == null ? thoseUserCredentials != null : !this._userCredentialSet.equals(thoseUserCredentials)) {
            return false;
        }
        Set thoseUsers = thatPuddle.getUsers();
        if (this._userSet == null ? thoseUsers != null : !this._userSet.equals(thoseUsers)) {
            return false;
        }
        String thatPuddleID = thatPuddle.getPuddleID();
        return !(this._puddleID == null ? thatPuddleID != null : !this._puddleID.equals(thatPuddleID));
    }

    public int hashCode() {
        int hashCode = this.getClass().getName().hashCode();
        for (int i = 0; i < this._clusterArr.length; ++i) {
            hashCode ^= this._clusterArr[i].hashCode();
        }
        if (this._serverCredential != null) {
            hashCode ^= this._serverCredential.hashCode();
        }
        hashCode ^= this._minSize;
        hashCode ^= this._minAvail;
        if (this._userCredentialSet != null) {
            hashCode ^= this._userCredentialSet.hashCode();
        }
        if (this._userSet != null) {
            hashCode ^= this._userSet.hashCode();
        }
        if (this._puddleID != null) {
            hashCode ^= this._puddleID.hashCode();
        }
        return hashCode;
    }

    public Object clone() {
        HashSet<Object> newSet;
        int size;
        Puddle puddle = null;
        try {
            puddle = (Puddle)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError("A Cloneable object threw CloneNotSupportedException.");
        }
        Cluster[] clusterArray = puddle.getClusterArray();
        clusterArray = ConnectionFactoryUtil.copyClusterArray(clusterArray);
        puddle.setClusterArray(clusterArray);
        Credential credential = puddle.getServerCredential();
        credential = (Credential)credential.clone();
        puddle.setServerCredential(credential);
        if (this._userCredentialSet != null) {
            size = this._userCredentialSet.size();
            newSet = new HashSet<Object>(size);
            for (Credential cred : this._userCredentialSet) {
                Object newCred = cred.clone();
                newSet.add(newCred);
            }
            puddle.setUserCredentials(newSet);
        }
        if (this._userSet != null) {
            size = this._userSet.size();
            newSet = new HashSet(size);
            newSet.addAll(this._userSet);
            puddle.setUsers(newSet);
        }
        return puddle;
    }

    public String toString() {
        HashSet<String[]> nvPairSet = new HashSet<String[]>(8);
        if (this._clusterArr != null) {
            String clusterArrStr = ConnectionFactoryUtil.clusterArrayToString(this._clusterArr);
            String[] nvPairClusterArr = new String[]{"clusters", clusterArrStr};
            nvPairSet.add(nvPairClusterArr);
        }
        if (this._serverCredential != null) {
            String serverCredentialStr = this._serverCredential.toString();
            String[] nvPairServerCredential = new String[]{"serverCredential", serverCredentialStr};
            nvPairSet.add(nvPairServerCredential);
        }
        if (this._minSize != 0) {
            String minSizeStr = Integer.toString(this._minSize);
            String[] nvPairMinSize = new String[]{"minSize", minSizeStr};
            nvPairSet.add(nvPairMinSize);
        }
        if (this._minAvail != 0) {
            String minAvailStr = Integer.toString(this._minAvail);
            String[] nvPairMinAvail = new String[]{"minAvail", minAvailStr};
            nvPairSet.add(nvPairMinAvail);
        }
        if (this._puddleName != null) {
            String[] nvPairPuddleName = new String[]{"puddleName", this._puddleName};
            nvPairSet.add(nvPairPuddleName);
        }
        if (this._puddleID != null) {
            String[] nvPairPuddleID = new String[]{"puddleID", this._puddleID};
            nvPairSet.add(nvPairPuddleID);
        }
        int nvPairSetL = nvPairSet.size();
        String[][] nvPairArr = new String[nvPairSetL][];
        nvPairArr = (String[][])nvPairSet.toArray((T[])nvPairArr);
        String str = ConnectionFactoryUtil.nvPairsToString(nvPairArr);
        return str;
    }
}

