/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rio;

import java.util.Arrays;

class MVARow {
    private byte[] _bookmark = null;
    private final Object[] _rowData;
    private final String[] _dualFormattedData;
    private final boolean _isDual;
    private final boolean[] _missingData;

    public MVARow(int columnCount, boolean isDual) {
        this._isDual = isDual;
        this._rowData = new Object[columnCount];
        this._missingData = new boolean[columnCount];
        this._dualFormattedData = isDual ? new String[columnCount] : null;
    }

    public MVARow(MVARow row) {
        this._isDual = row._isDual;
        this._rowData = Arrays.copyOf(row._rowData, row._rowData.length);
        this._missingData = Arrays.copyOf(row._missingData, row._missingData.length);
        this._dualFormattedData = row._isDual ? new String[row._rowData.length] : null;
    }

    public MVARow(byte[] bookmark, Object[] rowData, boolean[] missingData, String[] dualFormattedData) {
        if (dualFormattedData != null) {
            this._isDual = true;
            this._dualFormattedData = (String[])dualFormattedData.clone();
        } else {
            this._isDual = false;
            this._dualFormattedData = null;
        }
        this._rowData = (Object[])rowData.clone();
        this._bookmark = (byte[])bookmark.clone();
        this._missingData = (boolean[])missingData.clone();
    }

    public MVARow(Object[] row) {
        this._rowData = row;
        this._isDual = false;
        this._missingData = new boolean[row.length];
        this._dualFormattedData = null;
    }

    public void setBookmark(byte[] bookmark) {
        this._bookmark = bookmark;
    }

    public byte[] getBookmark() {
        return this._bookmark;
    }

    public int getBookmarkLength() {
        return this._bookmark.length;
    }

    public int size() {
        return this._rowData.length;
    }

    public void setData(int column, Object data) {
        this._rowData[column] = data;
        this._missingData[column] = data == null;
    }

    public void add(int column, Object data) {
        this._rowData[column] = data;
    }

    public Object[] getRowData() {
        return this._rowData;
    }

    public Object getData(int column) {
        return this._rowData[column];
    }

    public void setMissing(int column, boolean missing) throws IndexOutOfBoundsException {
        this._missingData[column] = missing;
    }

    public boolean getMissing(int column) throws IndexOutOfBoundsException {
        return this._missingData[column];
    }

    public void addFormatted(int columnIndex, String data) {
        this._dualFormattedData[columnIndex] = data;
    }

    public String getFormatted(int columnIndex) {
        return this._dualFormattedData[columnIndex];
    }
}

