/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iom.orb.brg;

import com.sas.codepolicy.SASScope;
import com.sas.iom.SASIOMDefs.CP_ID;
import com.sas.iom.SASIOMDefs.CP_IDHelper;
import com.sas.iom.SASIOMDefs.ConnectionPointContainerHelper;
import com.sas.iom.SASIOMDefs.ConnectionPointContainerOperations;
import com.sas.iom.SASIOMDefs.ConnectionPointContainer_1_1Operations;
import com.sas.iom.SASIOMDefs.ConnectionPointHolder;
import com.sas.iom.SASIOMDefs.ConnectionPointOperations;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.GenericErrorHelper;
import com.sas.iom.orb.AnyImpl;
import com.sas.iom.orb.AuthenticationTicketFactory;
import com.sas.iom.orb.AuthenticationTicketFactoryHolder;
import com.sas.iom.orb.CP_IDConverter;
import com.sas.iom.orb.DelegateBase;
import com.sas.iom.orb.DelegateLocal;
import com.sas.iom.orb.DelegateRemote;
import com.sas.iom.orb.GenericObject;
import com.sas.iom.orb.LoggerFactory;
import com.sas.iom.orb.ORBPermission;
import com.sas.iom.orb.SASURI;
import com.sas.iom.orb.SSLSocketChannel;
import com.sas.iom.orb.SelectionHub;
import com.sas.iom.orb.SelectionHubActivation;
import com.sas.iom.orb.SelectionHubKey;
import com.sas.iom.orb.WorkException;
import com.sas.iom.orb.WorkInterface;
import com.sas.iom.orb.brg.BufferManager;
import com.sas.iom.orb.brg.ConnectionPointDelegateImpl;
import com.sas.iom.orb.brg.ConnectionPointRequestImpl;
import com.sas.iom.orb.brg.Conversation;
import com.sas.iom.orb.brg.Daemon;
import com.sas.iom.orb.brg.DelegateImpl;
import com.sas.iom.orb.brg.Engine0100;
import com.sas.iom.orb.brg.Engine0200;
import com.sas.iom.orb.brg.InboundPacket;
import com.sas.iom.orb.brg.ListenerDelegateImpl;
import com.sas.iom.orb.brg.Marshaller;
import com.sas.iom.orb.brg.ORBImpl;
import com.sas.iom.orb.brg.OutboundPacket;
import com.sas.iom.orb.brg.Packet;
import com.sas.iom.orb.brg.ProtocolVersion;
import com.sas.iom.orb.brg.RB;
import com.sas.iom.orb.brg.RequestImpl;
import com.sas.iom.orb.brg.SecurityPackageBase;
import com.sas.iom.orb.brg.ServerRequestImpl;
import com.sas.iom.orb.brg.UnexpectedUserException;
import com.sas.net.crypto.CipherInterface;
import com.sas.net.crypto.Crypto;
import com.sas.net.crypto.CryptoException;
import com.sas.net.crypto.SealedString;
import com.sas.text.Message;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import com.sas.util.Strings;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.SocketChannel;
import java.nio.channels.UnresolvedAddressException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.DomainCombiner;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.PropertyPermission;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.Bounds;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.Environment;
import org.omg.CORBA.ExceptionList;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.NO_MEMORY;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.NVList;
import org.omg.CORBA.NamedValue;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ServerRequest;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.UnknownUserException;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.ServantObject;
import org.omg.PortableServer.DynamicImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

@SASScope
public abstract class Engine {
    protected static final int FLOW_PROCESS_URI = 10;
    protected static final int FLOW_PROCESS_DAEMON = 15;
    protected static final int FLOW_INIT_CLIENT = 20;
    protected static final int FLOW_INIT_SERVER = 30;
    protected static final int FLOW_LAUNCH_SERVER = 35;
    protected static final int FLOW_CONNECT = 40;
    protected static final int FLOW_CONNECT_TUNNEL = 45;
    protected static final int FLOW_CONNECT_SSL = 47;
    protected static final int FLOW_SEND_REQS = 50;
    protected static final int FLOW_READ_REQS = 60;
    protected static final int FLOW_REGISTER = 70;
    protected static final int FLOW_SEND_USERPASS = 80;
    protected static final int FLOW_READ_USERPASS = 90;
    protected static final int FLOW_SEND_XCODE = 100;
    protected static final int FLOW_SEND_AUTH = 110;
    protected static final int FLOW_READ_AUTH = 120;
    protected static final int FLOW_SEND_TRUST = 130;
    protected static final int FLOW_READ_TRUST = 140;
    protected static final byte PE_VERSION = 105;
    protected static final byte PE_REQS_OK = 0;
    protected static final byte PE_REQS_FAILED = 1;
    protected static final byte PE_REQS_LEVEL = 2;
    protected static final byte PE_REQS_REQS = 3;
    protected static final byte PE_REQS_REDIRECT = 4;
    protected static final byte PE_REQS_VERSION = 5;
    protected static final byte PE_REQS_REDIRECT_2 = 6;
    protected static final byte PE_REQS_LBFAILURE = 7;
    protected static final byte PE_REQS_TIMEOUT = 8;
    protected static final byte PE_REQS_VERSION_2 = 9;
    protected static final byte PE_REQS_REQS_2 = 10;
    protected static final byte PE_REQS_ERROR_PKT = 11;
    protected static final byte PE_ENCR_NONE = 0;
    protected static final byte PE_ENCR_AUTH = 1;
    protected static final byte PE_ENCR_ALL = 2;
    protected static final byte PE_USER = 0;
    protected static final byte PE_SERVER = 1;
    protected static final int PE_ERROR = 0;
    protected static final int PE_USERPASS = 1;
    protected static final int PE_NEWOBJECT = 2;
    protected static final int PE_FREEOBJECT = 3;
    protected static final int PE_CLOSE = 4;
    protected static final int PE_UUIDFROMOBJECTID = 5;
    protected static final int PE_ADVISE = 6;
    protected static final int PE_UNADVISE = 7;
    protected static final int PE_OBJECTDESTRUCTOR = 8;
    protected static final int PE_INTERFACEINOBJECT = 9;
    protected static final int PE_EVENTSFROMOBJECTID = 10;
    protected static final int PE_DEFAULTINTERFACE = 11;
    protected static final int PE_SERVERTRANSCODE = 12;
    protected static final int PE_GENPASSWORD = 13;
    protected static final int PE_USERSASPEER = 14;
    protected static final int PE_DOWNLEVEL = 15;
    protected static final int PE_NEWOBJECTBYNAME = 16;
    protected static final int PE_AUTHENTICATE = 17;
    protected static final int PE_REDIRECTED = 18;
    protected static final int PE_RECONOBJECT = 19;
    protected static final int PE_USERPASS2 = 20;
    protected static final int PE_AUTHENTICATE2 = 21;
    protected static final byte PE_TokenKerbNTLM = 0;
    protected static final byte PE_TokenKerberos = 1;
    protected static final byte PE_TokenNTLM = 2;
    protected static final byte PE_TokenCAS = 3;
    protected static final LogRecord severeRecord = new LogRecord(Level.SEVERE, null);
    protected static final LogRecord warningRecord = new LogRecord(Level.WARNING, null);
    protected static final LogRecord infoRecord = new LogRecord(Level.INFO, null);
    protected static final LogRecord fineRecord = new LogRecord(Level.FINE, null);
    protected static final LogRecord finerRecord = new LogRecord(Level.FINER, null);
    protected static final LogRecord finestRecord = new LogRecord(Level.FINEST, null);
    protected static final String lt_snd = "sending data to peer";
    protected static final String lt_rcv = "received data from peer";
    protected static final String lt_rqs = "sending requirements to peer";
    protected static final String lt_rqr = "received requirements from peer";
    protected static final String lt_sts = "sending requirements status to peer: ";
    protected static final String lt_str = "received requirements status from peer: ";
    private static final String lt_ttl = "requirements in effect for this peer:";
    private static final String lt_bor = "\tbyte order:           ";
    private static final String lt_crl = "\tencryption level:     ";
    private static final String lt_cra = "\tencryption algorithm: ";
    private static final String lt_lcl = "\tlocale:               ";
    private static final String lt_dtm = "\tdatetime format:      ";
    private static final String lt_rqt = "\trequest style:        ";
    private static final String lt_enc = "\tcharacter encoding:   ";
    private static final String lt_arr = "\tarray ordering:       ";
    private static final String lt_mis = "\tmissing value format: ";
    private static final String lt_mrb = "\tmax read buf:         ";
    private static final String xmlTag = "<?xml version=\"1.0\" ?>";
    private static final String exceptionsOpenTag = "<Exceptions>";
    private static final String exceptionsCloseTag = "</Exceptions>";
    private static final String exceptionOpenTag = "<Exception>";
    private static final String exceptionCloseTag = "</Exception>";
    private static final String messageOpenTag = "<SASMessage severity=\"Error\">";
    private static final String messageCloseTag = "</SASMessage>";
    private static final String severityAttrName = "severity";
    private static final String severityValueError = "Error";
    private static final String severityValueWarning = "Warning";
    private static final String severityValueNote = "Note";
    private static final String severityValueNone = "None";
    private static final String defaultHost = "localhost";
    private static final int defaultPort = 8591;
    protected static final String defaultClassID = "00000000-0000-0000-0000-000000000000";
    protected static final String defaultAlgorithm = "SASPROPRIETARY";
    private static final String cpcOperation = "FindConnectionPoint";
    private static final String cpAdvise = "Advise";
    private static final String cpUnadvise = "Unadvise";
    private static final String currentCorrelatorKey = "ARM.InternalCorrelator";
    protected static final String[] omitAttrArr = new String[]{"username", "password", "sealedpassword", "domain", "protocol", "ticketauthentication", "authservice"};
    private static Engine0100 engine0100;
    private static Engine0200 engine0200;
    private static DocumentBuilderFactory docBuilderFactory;
    private static int conversationIDCounter;
    private static int _maxReadBuf;
    private static final ORBPermission _trustedPeerPermission;
    private static final Permission[] _trustedPeerPermissionArr;
    private static final PermissionCombiner _trustedPeerPermissionCombiner;
    private static final Logger _logger;
    private static final Logger _writeLogger;
    private static final Pattern _commaDelim;
    private static final Pattern _semiDelim;
    private static final String _sslAlgName = "SSL";
    private Marshaller _marshaller = this.createMarshaller();
    private static final int _spclStateMask = 15;
    private static final int _spclStateInWhite = 0;
    private static final int _spclStateInText = 1;
    private static final int _spclStateInQS = 2;
    private static final int _spclStateInESText = 3;
    private static final int _spclStateInESQS = 4;
    private static final int _spclActAddCC = 16;
    private static final int _spclActAdvance = 32;
    private static final int _spclActNewArg = 64;
    private static final int _spclActArgDone = 128;
    private static final int _spclActDone = 256;
    private static final int _spclActAddPC = 512;
    private static final int _spclWarnMask = 61440;
    private static final int _spclWarnUBQS = 4096;
    private static final int _spclChrClEoln = 0;
    private static final int _spclChrClWhite = 1;
    private static final int _spclChrClDQ = 2;
    private static final int _spclChrClBS = 3;
    private static final int _spclChrClText = 4;
    private static final int[][] _spclTable;

    protected Engine() {
    }

    private static Object invokeReflectedMethod(Method mth, Object targ, Object[] argv) {
        Object result = null;
        try {
            result = mth.invoke(targ, argv);
        }
        catch (IllegalAccessException iae) {
            Engine.throwSomething(iae);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getCause();
            Engine.throwSomething(t);
        }
        return result;
    }

    private static void throwSomething(Throwable t) {
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        INTERNAL internal = new INTERNAL();
        internal.initCause(t);
        throw internal;
    }

    protected abstract Marshaller createMarshaller();

    protected Marshaller getMarshaller() {
        return this._marshaller;
    }

    protected static ObjectImpl initClient(Conversation conversation) {
        Engine.init(conversation);
        BufferManager bufferManager = new BufferManager(ByteOrder.BIG_ENDIAN);
        conversation.setBufferManager(bufferManager);
        conversation.setFlowState(10);
        Engine.flow(conversation);
        Engine engine = conversation.getEngine();
        ObjectImpl obj = engine.newObject(conversation);
        return obj;
    }

    protected static void initServer(Conversation conversation) {
        Engine.init(conversation);
        conversation.setFlowState(15);
        Engine.flow(conversation);
    }

    private static void init(Conversation conversation) {
        conversation.setProtocolVersion(ProtocolVersion.VERSION_CURRENT);
    }

    private static void flow(Conversation conversation) {
        try {
            Engine engine = null;
            boolean done = false;
            do {
                ProtocolVersion pv = conversation.getProtocolVersion();
                engine = Engine.getEngine(pv);
                int state = conversation.getFlowState();
                switch (state) {
                    case 10: {
                        done = engine.flowProcessURI(conversation);
                        break;
                    }
                    case 20: {
                        done = engine.flowInitClient(conversation);
                        break;
                    }
                    case 35: {
                        done = engine.flowLaunchServer(conversation);
                        break;
                    }
                    case 40: {
                        done = engine.flowConnect(conversation);
                        break;
                    }
                    case 45: {
                        done = engine.flowConnectTunnel(conversation);
                        break;
                    }
                    case 47: {
                        done = engine.flowConnectSSL(conversation);
                        break;
                    }
                    case 50: {
                        done = engine.flowSendReqs(conversation);
                        break;
                    }
                    case 80: {
                        done = engine.flowSendUserPass(conversation);
                        break;
                    }
                    case 110: {
                        done = engine.flowSendAuth(conversation);
                        break;
                    }
                    case 130: {
                        done = engine.flowSendTrust(conversation);
                        break;
                    }
                    case 100: {
                        done = engine.flowSendXcode(conversation);
                        break;
                    }
                    case 15: {
                        done = engine.flowProcessDaemon(conversation);
                        break;
                    }
                    case 30: {
                        done = engine.flowInitServer(conversation);
                        break;
                    }
                    case 60: {
                        done = engine.flowReadReqs(conversation);
                        break;
                    }
                    case 90: {
                        done = engine.flowReadUserPass(conversation);
                        break;
                    }
                    case 120: {
                        done = engine.flowReadAuth(conversation);
                        break;
                    }
                    case 140: {
                        done = engine.flowReadTrust(conversation);
                        break;
                    }
                    case 70: {
                        done = engine.flowRegister(conversation);
                        break;
                    }
                    default: {
                        throw new INTERNAL();
                    }
                }
            } while (!done);
        }
        catch (SystemException se) {
            Engine engine = conversation.getEngine();
            if (engine != null) {
                engine.abortConversation(conversation);
            }
            throw se;
        }
    }

    private static synchronized Engine getEngine(ProtocolVersion version) {
        byte _pvMajor = version.getMajor();
        switch (_pvMajor) {
            case 2: {
                if (engine0200 == null) {
                    engine0200 = new Engine0200();
                }
                return engine0200;
            }
            case 1: {
                if (engine0100 == null) {
                    engine0100 = new Engine0100();
                }
                return engine0100;
            }
        }
        throw new INTERNAL();
    }

    protected static synchronized DocumentBuilder createDocBuilder(Conversation conversation) {
        if (docBuilderFactory == null) {
            docBuilderFactory = DocumentBuilderFactory.newInstance();
        }
        DocumentBuilder docBuilder = null;
        try {
            docBuilder = docBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            Locale locale = conversation.getLocale();
            String messageIndex = "Engine.001.ex.txt";
            String message = RB.getStringResource(messageIndex, locale);
            INITIALIZE initialize = new INITIALIZE(message);
            initialize.initCause((Throwable)pce);
            throw initialize;
        }
        return docBuilder;
    }

    protected static synchronized int assignConversationID() {
        return conversationIDCounter++;
    }

    protected void setOutboundCorrelator(Conversation conversation, OutboundPacket packet) {
        String correlator = ThreadContext.get((String)currentCorrelatorKey);
        if (correlator != null && correlator.length() > 0) {
            Packet.CorrelatorModifier modifier = new Packet.CorrelatorModifier(correlator);
            ArrayList<Packet.CorrelatorModifier> modifierLst = packet.getModifierLst();
            if (modifierLst == null) {
                modifierLst = new ArrayList<Packet.CorrelatorModifier>(1);
                packet.setModifierLst(modifierLst);
            }
            modifierLst.add(modifier);
        }
    }

    protected void sendRequest(Conversation conversation, RequestImpl orbRequest) {
        String iid;
        DelegateRemote delegate;
        String operation = orbRequest.operation();
        if (operation.equals(cpcOperation)) {
            this.findConnectionPointRequest(conversation, orbRequest);
            return;
        }
        if (operation.equals("_generate_password")) {
            this.generatePasswordRequest(conversation, orbRequest);
            return;
        }
        if (operation.startsWith("_get_") || operation.startsWith("_set_")) {
            operation = operation.substring(5);
        }
        ObjectImpl obj = (ObjectImpl)orbRequest.target();
        DelegateBase del = (DelegateBase)obj._get_delegate();
        OutboundPacket brgRequest = new OutboundPacket();
        boolean event = false;
        if (del instanceof DelegateImpl) {
            delegate = (DelegateImpl)obj._get_delegate();
            int objectID = ((DelegateImpl)delegate).getObjectID();
            brgRequest.setObjectId(objectID);
            String reposID = obj._ids()[0];
            iid = Engine.reposIDtoIID(reposID);
            brgRequest.setUuid(iid);
            brgRequest.setType(4);
        } else {
            event = true;
            delegate = (ListenerDelegateImpl)del;
            int sourceID = ((ListenerDelegateImpl)delegate).getSourceID();
            brgRequest.setObjectId(sourceID);
            CP_ID cpid = ((ListenerDelegateImpl)delegate).getCP_ID();
            iid = CP_IDConverter.cp_idToString(cpid);
            brgRequest.setUuid(iid);
            brgRequest.setType(5);
        }
        NVList arguments = orbRequest.arguments();
        AnyImpl[] parmArray = this.prepareRequestArgs(conversation, operation, arguments, del);
        brgRequest.setParameterArray(parmArray);
        this.setOutboundCorrelator(conversation, brgRequest);
        this.sendPacket(conversation, brgRequest);
        if (event) {
            return;
        }
        try {
            InboundPacket brgReply = this.waitForReply(conversation, brgRequest);
            TypeCode returnType = orbRequest.getReturnType();
            AnyImpl retVal = null;
            if (returnType != null) {
                retVal = (AnyImpl)orbRequest.return_value();
            }
            this.insertRequestArgs(conversation, arguments, retVal, brgReply, del);
        }
        catch (UnexpectedUserException uue) {
            Throwable cause;
            UNKNOWN r = null;
            String uuid = uue.getUUID();
            if (uuid == null || uuid.equals("") || uuid.equals(defaultClassID)) {
                uuid = GenericErrorHelper.id();
            }
            uuid = uuid.toLowerCase(Locale.US);
            ExceptionList exceptionList = orbRequest.exceptions();
            int exceptionCount = exceptionList.count();
            for (int i = 0; i < exceptionCount; ++i) {
                TypeCode etc = null;
                String id = null;
                try {
                    etc = exceptionList.item(i);
                    id = etc.id();
                }
                catch (Bounds bd) {
                    String cl = exceptionList.getClass().getName();
                    throw new INTERNAL(cl + ".count() returned an incorrect value");
                }
                catch (BadKind bk) {
                    String cl = etc.getClass().getName();
                    throw new INTERNAL(cl + ".id() threw an exception when it shouldn't have");
                }
                String lcid = id.toLowerCase(Locale.US);
                if (!uuid.equals(Engine.reposIDtoIID(lcid)) && !uuid.equals(lcid)) continue;
                ORBImpl orb = conversation.getORB();
                Any any = orb.create_any();
                org.omg.CORBA.portable.OutputStream os = any.create_output_stream();
                os.write_string(id);
                os.write_string(uue.getMessage());
                InputStream is = os.create_input_stream();
                any.read_value(is, etc);
                r = new UnknownUserException(any);
                break;
            }
            if (r == null) {
                String msg = uue.getMessage();
                r = new UNKNOWN(msg);
            }
            if ((cause = uue.getCause()) != null) {
                r.initCause(cause);
            }
            Environment environment = orbRequest.env();
            environment.exception((Exception)r);
        }
    }

    protected AnyImpl[] prepareRequestArgs(Conversation conversation, String operation, NVList args, DelegateBase parent) {
        LinkedList<AnyImpl> parmList = new LinkedList<AnyImpl>();
        ORBImpl orb = conversation.getORB();
        AnyImpl _operation = (AnyImpl)orb.create_any();
        _operation.insert_string(operation);
        parmList.add(_operation);
        this.prepareArgs(conversation, args, 2, parent, parmList);
        int argCount = parmList.size();
        AnyImpl[] parmArray = new AnyImpl[argCount];
        parmArray = parmList.toArray(parmArray);
        return parmArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendConnectionPointRequest(Conversation conversation, ConnectionPointRequestImpl orbRequest) {
        String operation = orbRequest.operation();
        ObjectImpl obj = (ObjectImpl)orbRequest.target();
        ConnectionPointDelegateImpl delegate = (ConnectionPointDelegateImpl)obj._get_delegate();
        NVList arguments = orbRequest.arguments();
        String eventID = delegate.getEventID();
        DelegateImpl source = delegate.getParent();
        if (operation.equals(cpAdvise)) {
            Any any0 = null;
            Any any1 = null;
            try {
                any0 = arguments.item(0).value();
                any1 = arguments.item(1).value();
            }
            catch (Bounds e) {
                BAD_OPERATION bad_operation = new BAD_OPERATION();
                bad_operation.initCause((Throwable)e);
                throw bad_operation;
            }
            org.omg.CORBA.Object listener = any0.extract_Object();
            int handle = 0;
            DelegateImpl delegateImpl = source;
            synchronized (delegateImpl) {
                HashSet<org.omg.CORBA.Object> listenerSet;
                HashMap listenerTable = source.getListenerTable();
                if (listenerTable == null) {
                    listenerTable = new HashMap();
                    source.setListenerTable(listenerTable);
                }
                if ((listenerSet = (HashSet<org.omg.CORBA.Object>)listenerTable.get(eventID)) == null) {
                    listenerSet = new HashSet<org.omg.CORBA.Object>();
                    listenerTable.put(eventID, listenerSet);
                }
                if (listenerSet.isEmpty()) {
                    int sourceID = source.getObjectID();
                    this.advise(conversation, sourceID, eventID);
                }
                listenerSet.add(listener);
                handle = source.getNextHandle();
                Integer H = new Integer(handle);
                HashMap<Integer, org.omg.CORBA.Object> handleTable = source.getHandleTable();
                if (handleTable == null) {
                    handleTable = new HashMap<Integer, org.omg.CORBA.Object>();
                    source.setHandleTable(handleTable);
                }
                handleTable.put(H, listener);
            }
            any1.insert_ulong(handle);
        } else {
            if (operation.equals(cpUnadvise)) {
                Any any = null;
                try {
                    any = arguments.item(0).value();
                }
                catch (Bounds e) {
                    BAD_OPERATION bad_operation = new BAD_OPERATION();
                    bad_operation.initCause((Throwable)e);
                    throw bad_operation;
                }
                int handle = any.extract_ulong();
                Integer H = new Integer(handle);
                DelegateImpl delegateImpl = source;
                synchronized (delegateImpl) {
                    Map handleTable = source.getHandleTable();
                    if (handleTable == null) {
                        return;
                    }
                    Object listener = handleTable.remove(H);
                    if (listener == null) {
                        return;
                    }
                    Map listenerTable = source.getListenerTable();
                    if (listenerTable == null) {
                        return;
                    }
                    Set listenerSet = (Set)listenerTable.get(eventID);
                    listenerSet.remove(listener);
                    if (listenerSet.isEmpty()) {
                        listenerTable.remove(eventID);
                        int sourceID = source.getObjectID();
                        this.unadvise(conversation, sourceID, eventID);
                    }
                }
            }
            throw new BAD_OPERATION();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void findConnectionPointRequest(Conversation conversation, RequestImpl orbRequest) {
        ObjectImpl obj = (ObjectImpl)orbRequest.target();
        DelegateImpl delegate = (DelegateImpl)obj._get_delegate();
        NVList arguments = orbRequest.arguments();
        Any any0 = null;
        Any any1 = null;
        try {
            any0 = arguments.item(0).value();
            any1 = arguments.item(1).value();
        }
        catch (Bounds e) {
            BAD_OPERATION bad_operation = new BAD_OPERATION();
            bad_operation.initCause((Throwable)e);
            throw bad_operation;
        }
        CP_ID cpid = CP_IDHelper.extract(any0);
        String eventID = CP_IDConverter.cp_idToString(cpid);
        eventID = eventID.toLowerCase(Locale.US);
        DelegateImpl delegateImpl = delegate;
        synchronized (delegateImpl) {
            Set eventSet = delegate.getEventSet();
            if (eventSet == null) {
                throw new BAD_INV_ORDER();
            }
            if (!eventSet.contains(eventID)) {
                return;
            }
        }
        ConnectionPointDelegateImpl cpDelegate = new ConnectionPointDelegateImpl(conversation, delegate, eventID);
        GenericObject cp = new GenericObject();
        cp._set_delegate(cpDelegate);
        TypeCode tc1 = any1.type();
        any1.insert_Object((org.omg.CORBA.Object)cp, tc1);
    }

    protected void advise(Conversation conversation, int sourceID, String eventID) {
        OutboundPacket request = new OutboundPacket();
        request.setType(0);
        request.setMethodId(6);
        request.setObjectId(sourceID);
        request.setUuid(eventID);
        this.setOutboundCorrelator(conversation, request);
        this.sendPacket(conversation, request);
        try {
            this.waitForReply(conversation, request);
        }
        catch (UnexpectedUserException e) {
            OBJECT_NOT_EXIST object_not_exist = new OBJECT_NOT_EXIST(e.getMessage());
            object_not_exist.initCause((Throwable)((Object)e));
            throw object_not_exist;
        }
    }

    protected void unadvise(Conversation conversation, int sourceID, String eventID) {
        OutboundPacket request = new OutboundPacket();
        request.setType(0);
        request.setMethodId(7);
        request.setObjectId(sourceID);
        request.setUuid(eventID);
        this.setOutboundCorrelator(conversation, request);
        this.sendPacket(conversation, request);
        try {
            this.waitForReply(conversation, request);
        }
        catch (UnexpectedUserException e) {
            OBJECT_NOT_EXIST object_not_exist = new OBJECT_NOT_EXIST(e.getMessage());
            object_not_exist.initCause((Throwable)((Object)e));
            throw object_not_exist;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean interfaceInObject(Conversation conversation, org.omg.CORBA.Object obj, String reposID) {
        if (reposID == null) {
            return false;
        }
        DelegateImpl delegate = (DelegateImpl)((ObjectImpl)obj)._get_delegate();
        String cpcID = ConnectionPointContainerHelper.id();
        if (reposID.equalsIgnoreCase(cpcID)) {
            Set eventSet = null;
            DelegateImpl delegateImpl = delegate;
            synchronized (delegateImpl) {
                eventSet = delegate.getEventSet();
                if (eventSet == null) {
                    eventSet = this.eventsFromObject(conversation, obj);
                    eventSet = Collections.unmodifiableSet(eventSet);
                    delegate.setEventSet(eventSet);
                }
            }
            int eventSetSize = eventSet.size();
            return eventSetSize > 0;
        }
        String iid = Engine.reposIDtoIID(reposID);
        int objectID = delegate.getObjectID();
        OutboundPacket request = new OutboundPacket();
        request.setType(0);
        request.setMethodId(9);
        request.setObjectId(objectID);
        request.setUuid(iid);
        this.setOutboundCorrelator(conversation, request);
        this.sendPacket(conversation, request);
        InboundPacket reply = this.waitForReply(conversation, request);
        int rc = this._marshaller.unmarshalRC(conversation, reply);
        return rc == 0;
    }

    protected Set eventsFromObject(Conversation conversation, org.omg.CORBA.Object obj) {
        DelegateImpl delegate = (DelegateImpl)((ObjectImpl)obj)._get_delegate();
        int objectID = delegate.getObjectID();
        OutboundPacket request = new OutboundPacket();
        request.setType(0);
        request.setMethodId(10);
        request.setObjectId(objectID);
        this.setOutboundCorrelator(conversation, request);
        this.sendPacket(conversation, request);
        InboundPacket reply = this.waitForReply(conversation, request);
        this._marshaller.unmarshalRC(conversation, reply);
        int count = reply.getMapCount() - 1;
        HashSet<String> eventSet = new HashSet<String>(count);
        ByteBuffer mapBuf = reply.getMapBuf();
        ByteBuffer dataBuf = reply.getDataBuf();
        for (int i = 0; i < count; ++i) {
            String eventID = (String)this._marshaller.unmarshalParameter(conversation, 18, mapBuf, dataBuf);
            eventID = eventID.toLowerCase(Locale.US);
            eventSet.add(eventID);
        }
        return eventSet;
    }

    protected void generatePasswordRequest(Conversation conversation, RequestImpl orbRequest) {
        ObjectImpl obj = (ObjectImpl)orbRequest.target();
        DelegateImpl delegate = (DelegateImpl)obj._get_delegate();
        NVList arguments = orbRequest.arguments();
        LinkedList parmList = new LinkedList();
        this.prepareArgs(conversation, arguments, 2, delegate, parmList);
        int argCount = parmList.size();
        AnyImpl[] parmArray = new AnyImpl[argCount];
        parmArray = parmList.toArray(parmArray);
        OutboundPacket request = new OutboundPacket();
        request.setType(0);
        request.setMethodId(13);
        request.setParameterArray(parmArray);
        this.setOutboundCorrelator(conversation, request);
        this.sendPacket(conversation, request);
        InboundPacket reply = null;
        try {
            reply = this.waitForReply(conversation, request);
        }
        catch (UnexpectedUserException e) {
            UNKNOWN unknown = new UNKNOWN();
            unknown.initCause((Throwable)((Object)e));
            throw unknown;
        }
        this.insertRequestArgs(conversation, arguments, null, reply, delegate);
    }

    protected void insertDispatchArgs(Conversation conversation, NVList args, ByteBuffer mapBuf, ByteBuffer dataBuf, DelegateBase target) {
        this.insertArgs(conversation, args, mapBuf, dataBuf, 2, target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invokeDispatch(Conversation conversation, ServerRequestImpl serverRequest) {
        ObjectImpl target = serverRequest.getTarget();
        String operation = serverRequest.operation();
        Class<DynamicImplementation> clazz = DynamicImplementation.class;
        ServantObject servantObject = null;
        Throwable systemEx = null;
        try {
            servantObject = target._servant_preinvoke(operation, clazz);
            DynamicImplementation dynamic = (DynamicImplementation)servantObject.servant;
            InboundPacket request = serverRequest.getRequest();
            List modifierLst = request.getModifierLst();
            if (modifierLst != null) {
                Packet.Modifier modifier;
                int modifierTyp;
                Iterator modifierItr = modifierLst.iterator();
                while (modifierItr.hasNext() && (modifierTyp = (modifier = (Packet.Modifier)modifierItr.next()).getType()) != Integer.MIN_VALUE) {
                }
            }
            try {
                dynamic.invoke((ServerRequest)serverRequest);
            }
            catch (BAD_OPERATION bo) {
                int argCount = request.getMapCount();
                String newOp = (argCount == 1 ? "_get_" : "_set_") + operation;
                serverRequest.setOperation(newOp);
                try {
                    dynamic.invoke((ServerRequest)serverRequest);
                }
                finally {
                    serverRequest.setOperation(operation);
                }
            }
        }
        catch (Throwable t) {
            systemEx = t;
        }
        finally {
            if (servantObject != null) {
                target._servant_postinvoke(servantObject);
            }
        }
        if (!serverRequest.isOneWay()) {
            InboundPacket request = serverRequest.getRequest();
            if (systemEx != null) {
                this.sendSystemError(conversation, request, systemEx);
                return;
            }
            AnyImpl userEx = (AnyImpl)serverRequest.getException();
            if (userEx != null) {
                this.sendUserError(conversation, request, userEx);
                return;
            }
            NVList args = serverRequest.getArguments();
            AnyImpl result = (AnyImpl)serverRequest.getResult();
            DelegateBase parent = (DelegateBase)target._get_delegate();
            AnyImpl[] parameterArray = this.prepareReplyArgs(conversation, 0, args, result, parent);
            int conversationID = request.getClientId();
            int objectID = request.getObjectId() & Integer.MAX_VALUE;
            int replyID = request.getReplyId();
            String iid = request.getUuid();
            OutboundPacket reply = new OutboundPacket();
            reply.setType(2);
            reply.setClientId(conversationID);
            reply.setObjectId(objectID);
            reply.setReplyId(replyID);
            reply.setUuid(iid);
            reply.setRC(OutboundPacket.zero);
            reply.setParameterArray(parameterArray);
            this.sendPacket(conversation, reply);
        } else if (systemEx != null) {
            String msg = "An event listener threw an exception while processing an event.";
            Engine.log(conversation, warningRecord, msg, systemEx);
        }
    }

    protected AnyImpl[] prepareReplyArgs(Conversation conversation, int rc, NVList args, AnyImpl result, DelegateBase parent) {
        int count = args.count();
        ArrayList<AnyImpl> parmList = new ArrayList<AnyImpl>(count + 1);
        this.prepareArgs(conversation, args, 1, parent, parmList);
        if (result != null) {
            parmList.add(result);
        }
        int argCount = parmList.size();
        AnyImpl[] parmArray = new AnyImpl[argCount];
        parmArray = parmList.toArray(parmArray);
        return parmArray;
    }

    protected void prepareArgs(Conversation conversation, NVList args, int ignoreDir, DelegateBase parent, List argList) {
        int argCount = args.count();
        for (int i = 0; i < argCount; ++i) {
            NamedValue nv = null;
            try {
                nv = args.item(i);
            }
            catch (Bounds b) {
                INTERNAL internal = new INTERNAL();
                internal.initCause((Throwable)b);
                throw internal;
            }
            int direction = nv.flags();
            if (direction == ignoreDir) continue;
            AnyImpl orbValue = (AnyImpl)nv.value();
            this.mangleReference(parent, orbValue);
            argList.add(orbValue);
        }
    }

    protected void insertRequestArgs(Conversation conversation, NVList args, AnyImpl retVal, InboundPacket reply, DelegateBase parent) {
        this._marshaller.unmarshalRC(conversation, reply);
        ByteBuffer mapBuf = reply.getMapBuf();
        ByteBuffer dataBuf = reply.getDataBuf();
        this.insertArgs(conversation, args, mapBuf, dataBuf, 1, parent);
        if (retVal != null) {
            TypeCode tc = retVal.type();
            int iomType = retVal.iomType();
            Object iomValue = this._marshaller.unmarshalParameter(conversation, iomType, mapBuf, dataBuf);
            retVal.insertIOM(iomType, iomValue, tc);
            this.mangleReference(parent, retVal);
        }
    }

    protected void insertArgs(Conversation conversation, NVList args, ByteBuffer mapBuf, ByteBuffer dataBuf, int ignoreDir, DelegateBase parent) {
        int argCount = args.count();
        for (int i = 0; i < argCount; ++i) {
            NamedValue nv = null;
            try {
                nv = args.item(i);
            }
            catch (Bounds b) {
                INTERNAL internal = new INTERNAL();
                internal.initCause((Throwable)b);
                throw internal;
            }
            int direction = nv.flags();
            if (direction == ignoreDir) continue;
            AnyImpl orbValue = (AnyImpl)nv.value();
            TypeCode tc = orbValue.type();
            int iomType = orbValue.iomType();
            Object iomValue = this._marshaller.unmarshalParameter(conversation, iomType, mapBuf, dataBuf);
            orbValue.insertIOM(iomType, iomValue, tc);
            this.mangleReference(parent, orbValue);
        }
    }

    protected void mangleReference(DelegateBase parent, AnyImpl val) {
        ObjectImpl obj;
        Delegate child;
        int iomType = val.iomType();
        if (iomType == 24 && (child = (obj = (ObjectImpl)val.extractIOM())._get_delegate()) instanceof DelegateRemote) {
            ((DelegateRemote)child).addReference((Object)parent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendPacket(Conversation conversation, OutboundPacket packet) {
        ArrayList<OutboundPacket> packetLst = new ArrayList<OutboundPacket>(2);
        packetLst.add(packet);
        HashSet bufferSet = new HashSet(4);
        try {
            this.outboundPacketsModify(conversation, packetLst);
            this.outboundPacketsMarshall(conversation, packetLst, bufferSet);
            this.outboundPacketsEncrypt(conversation, packetLst, bufferSet);
            this.outboundPacketsLog(conversation, packetLst);
            this.outboundPacketsWrite(conversation, packetLst);
        }
        finally {
            BufferManager bufferManager = conversation.getBufferManager();
            for (ByteBuffer buffer : bufferSet) {
                bufferManager.checkin(buffer);
            }
        }
    }

    protected void sendEOF(Conversation conversation) {
        OutboundPacket packet = new OutboundPacket();
        ArrayList<OutboundPacket> packetLst = new ArrayList<OutboundPacket>(1);
        packetLst.add(packet);
        try {
            this.outboundPacketsWrite(conversation, packetLst);
        }
        catch (COMM_FAILURE cOMM_FAILURE) {
            // empty catch block
        }
    }

    protected void outboundPacketsModify(Conversation conversation, List packetLst) {
        ListIterator<OutboundPacket> packetItr = packetLst.listIterator();
        while (packetItr.hasNext()) {
            OutboundPacket packet = (OutboundPacket)packetItr.next();
            List modifierLst = packet.getModifierLst();
            if (modifierLst == null || modifierLst.isEmpty()) continue;
            OutboundPacket modifierPacket = this.createModifierPacket(conversation, modifierLst);
            packetItr.set(modifierPacket);
            packetItr.add(packet);
        }
    }

    protected void outboundPacketsMarshall(Conversation conversation, List packetLst, Set bufferSet) {
        int clientID = conversation.getConversationID();
        int packetLstL = packetLst.size();
        for (int i = 0; i < packetLstL; ++i) {
            OutboundPacket packet = (OutboundPacket)packetLst.get(i);
            packet.setClientId(clientID);
            int replyID = packet.getReplyId();
            if (replyID < 0) {
                replyID = conversation.getReplyID();
                packet.setReplyId(replyID);
            }
            this._marshaller.calculatePacketSize(conversation, packet);
            BufferManager bufferManager = conversation.getBufferManager();
            int packetSize = packet.getSize();
            ByteBuffer buf = bufferManager.checkout(packetSize);
            this._marshaller.marshalPacket(conversation, packet, buf);
            ByteBuffer roBuf = BufferManager.asReadOnlyBuffer(buf);
            packet.setMarshalledPacket(roBuf);
            bufferSet.add(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void outboundPacketsEncrypt(Conversation conversation, List packetLst, Set bufferSet) {
        Conversation conversation2 = conversation;
        synchronized (conversation2) {
            if (conversation.getCipher() != null) {
                byte cryptoLev = conversation.getEncryptionLevel();
                int packetLstL = packetLst.size();
                for (int i = 0; i < packetLstL; ++i) {
                    OutboundPacket packet = (OutboundPacket)packetLst.get(i);
                    if (cryptoLev != 2 && (cryptoLev != 1 || !this.isSendUserPass(conversation, packet))) continue;
                    ByteBuffer cryptBuf = this.encryptPacket(conversation, packet);
                    ByteBuffer roCryptBuf = BufferManager.asReadOnlyBuffer(cryptBuf);
                    packet.setEncryptedPacket(roCryptBuf);
                    bufferSet.add(cryptBuf);
                }
            }
        }
    }

    protected void outboundPacketsLog(Conversation conversation, List packetLst) {
        int packetLstL = packetLst.size();
        for (int i = 0; i < packetLstL; ++i) {
            OutboundPacket packet = (OutboundPacket)packetLst.get(i);
            this.logOutboundPacket(conversation, packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void outboundPacketsWrite(Conversation conversation, List packetLst) {
        IOException ioe;
        List masterPacketLst;
        Conversation conversation2 = conversation;
        synchronized (conversation2) {
            if (conversation.isPeerClosed()) {
                Locale locale = conversation.getLocale();
                String messageIndex = "Engine.036.ex.txt";
                String message = RB.getStringResource(messageIndex, locale);
                COMM_FAILURE comm_failure = new COMM_FAILURE(message);
                IOException cause = conversation.getFatalException();
                if (cause == null) {
                    cause = new IOException(message);
                }
                comm_failure.initCause((Throwable)cause);
                throw comm_failure;
            }
        }
        List locale = masterPacketLst = conversation.getPacketList();
        synchronized (locale) {
            masterPacketLst.addAll(packetLst);
        }
        boolean done = this.speak(conversation);
        if (!done) {
            SelectionHubActivation act = conversation.getHubActivation();
            act.updateInterestOps(5);
        }
        int packetLstL = packetLst.size();
        int lastIndex = packetLstL - 1;
        OutboundPacket packet = (OutboundPacket)packetLst.get(lastIndex);
        boolean forceListen = false;
        OutboundPacket outboundPacket = packet;
        synchronized (outboundPacket) {
            block17: {
                try {
                    while (!packet.isSent() && packet.getFatalException() == null) {
                        packet.wait();
                    }
                }
                catch (InterruptedException ie) {
                    if (packet.isSent() || packet.getFatalException() != null) break block17;
                    ClosedByInterruptException cbie = new ClosedByInterruptException();
                    cbie.initCause(ie);
                    packet.setFatalException(cbie);
                    conversation.setFatalException(cbie);
                    SocketChannel channel = conversation.getChannel();
                    if (channel == null || this.closeConnection(conversation, channel, true)) break block17;
                    forceListen = true;
                }
            }
        }
        if (forceListen) {
            this.listen(conversation);
        }
        if ((ioe = packet.getFatalException()) != null) {
            Locale locale2 = conversation.getLocale();
            String messageIndex = "Engine.035.ex.txt";
            String message = RB.getStringResource(messageIndex, locale2);
            COMM_FAILURE comm_failure = new COMM_FAILURE(message);
            comm_failure.initCause((Throwable)ioe);
            throw comm_failure;
        }
    }

    protected ByteBuffer encryptPacket(Conversation conversation, OutboundPacket packet) {
        ByteBuffer marshalledPacket = packet.getMarshalledPacket();
        int plainPacketL = marshalledPacket.remaining();
        byte[] inlinePacket = new byte[plainPacketL];
        marshalledPacket.get(inlinePacket, 0, plainPacketL);
        byte[] cryptHeader = this.encryptBuf(conversation, inlinePacket, 0, 64);
        int cryptHeaderL = cryptHeader.length;
        byte[] cryptPayload = null;
        int cryptPayloadL = 0;
        int cryptBufL = cryptHeaderL + 4;
        if (plainPacketL > 64) {
            int plainPayloadL = plainPacketL - 64;
            cryptPayload = this.encryptBuf(conversation, inlinePacket, 64, plainPayloadL);
            cryptPayloadL = cryptPayload.length;
            cryptBufL += cryptPayloadL + 4;
        }
        BufferManager bufferManager = conversation.getBufferManager();
        ByteBuffer cryptBuf = bufferManager.checkout(cryptBufL);
        cryptBuf.order(ByteOrder.BIG_ENDIAN);
        cryptBuf.putInt(cryptHeaderL);
        cryptBuf.put(cryptHeader);
        if (cryptPayload != null) {
            cryptBuf.putInt(cryptPayloadL);
            cryptBuf.put(cryptPayload);
        }
        cryptBuf.rewind();
        return cryptBuf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] encryptBuf(Conversation conversation, byte[] buf, int off, int len) {
        Conversation conversation2 = conversation;
        synchronized (conversation2) {
            CipherInterface cipher = conversation.getCipher();
            int cLen = cipher.getCipherTextLength(len);
            ByteArrayOutputStream cStream = new ByteArrayOutputStream(cLen);
            try {
                cipher.encrypt(buf, off, len, (OutputStream)cStream);
            }
            catch (IOException ioe) {
                Locale locale = conversation.getLocale();
                String messageIndex = "Engine.004.ex.txt";
                String message = RB.getStringResource(messageIndex, locale);
                COMM_FAILURE comm_failure = new COMM_FAILURE(message);
                comm_failure.initCause((Throwable)ioe);
                throw comm_failure;
            }
            catch (CryptoException ce) {
                Locale locale = conversation.getLocale();
                String messageIndex = "Engine.004.ex.txt";
                String message = RB.getStringResource(messageIndex, locale);
                MARSHAL marshal = new MARSHAL(message);
                marshal.initCause((Throwable)ce);
                throw marshal;
            }
            return cStream.toByteArray();
        }
    }

    protected OutboundPacket createModifierPacket(Conversation conversation, List modifierLst) {
        if (modifierLst == null || modifierLst.isEmpty()) {
            return null;
        }
        int modifierBts = 0;
        int modifierLstL = modifierLst.size();
        ArrayList<AnyImpl> parmLst = new ArrayList<AnyImpl>(modifierLstL);
        for (Packet.Modifier modifier : modifierLst) {
            int modifierTyp = modifier.getType();
            modifierBts |= modifierTyp;
            switch (modifierTyp) {
                case -2147483648: {
                    String correlator = ((Packet.CorrelatorModifier)modifier).getCorrelator();
                    ORBImpl orb = conversation.getORB();
                    AnyImpl any = (AnyImpl)orb.create_any();
                    any.insert_string(correlator);
                    parmLst.add(any);
                    break;
                }
            }
        }
        OutboundPacket packet = new OutboundPacket();
        packet.setType(6);
        packet.setMethodId(modifierBts);
        int parmLstL = parmLst.size();
        if (parmLstL > 0) {
            AnyImpl[] parmArr = new AnyImpl[parmLstL];
            parmArr = parmLst.toArray(parmArr);
            packet.setParameterArray(parmArr);
        }
        return packet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected InboundPacket waitForReply(Conversation conversation, OutboundPacket request) {
        IOException fatalException;
        InboundPacket reply = null;
        List replyList = conversation.getReplyList();
        int replyID = request.getReplyId();
        Object object = replyList;
        synchronized (object) {
            reply = (InboundPacket)Engine.matchReply(replyList, replyID);
            if (reply == null) {
                fatalException = conversation.getFatalException();
                if (fatalException != null) {
                    Locale locale = conversation.getLocale();
                    String messageIndex = "Engine.008.ex.txt";
                    String message = RB.getStringResource(messageIndex, locale);
                    COMM_FAILURE comm_failure = new COMM_FAILURE(message);
                    comm_failure.initCause((Throwable)fatalException);
                    throw comm_failure;
                }
                List requestList = conversation.getRequestList();
                requestList.add(request);
            }
        }
        while (true) {
            if (reply != null) {
                this.checkForErrorPacket(conversation, reply);
                return reply;
            }
            object = request;
            synchronized (object) {
                while (true) {
                    if (request.getReadCount() > 0) {
                        request.removeRead();
                        break;
                    }
                    reply = request.getReply();
                    if (reply != null) break;
                    fatalException = conversation.getFatalException();
                    if (fatalException != null) {
                        Locale locale = conversation.getLocale();
                        String messageIndex = "Engine.008.ex.txt";
                        String message = RB.getStringResource(messageIndex, locale);
                        COMM_FAILURE comm_failure = new COMM_FAILURE(message);
                        comm_failure.initCause((Throwable)fatalException);
                        throw comm_failure;
                    }
                    try {
                        request.wait();
                    }
                    catch (InterruptedException ie) {
                        request.setInterrupted(true);
                        ClosedByInterruptException cbie = new ClosedByInterruptException();
                        cbie.initCause(ie);
                        conversation.setFatalException(cbie);
                        SocketChannel channel = conversation.getChannel();
                        if (channel == null || this.closeConnection(conversation, channel, true)) continue;
                        request.addRead();
                    }
                }
                if (reply != null) continue;
            }
            this.listen(conversation);
        }
    }

    protected static Packet matchReply(List packetList, int replyID) {
        Iterator packetItr = packetList.iterator();
        while (packetItr.hasNext()) {
            Packet packet = (Packet)packetItr.next();
            int rid = packet.getReplyId();
            if (rid != replyID) continue;
            packetItr.remove();
            return packet;
        }
        return null;
    }

    protected void checkForErrorPacket(Conversation conversation, InboundPacket packet) {
        if (packet.getType() == 0 && packet.getMethodId() == 0) {
            int errorStatus = this._marshaller.unmarshalRC(conversation, packet);
            ByteBuffer mapBuf = packet.getMapBuf();
            ByteBuffer dataBuf = packet.getDataBuf();
            String errorXML = (String)this._marshaller.unmarshalParameter(conversation, 18, mapBuf, dataBuf);
            this._marshaller.unmarshalParameter(conversation, 9, mapBuf, dataBuf);
            String errorUUID = (String)this._marshaller.unmarshalParameter(conversation, 18, mapBuf, dataBuf);
            this._marshaller.unmarshalParameter(conversation, 18, mapBuf, dataBuf);
            SystemException error = Engine.parseErrorXML(conversation, errorStatus, errorXML, errorUUID);
            throw error;
        }
    }

    protected List checkForModifierPacket(Conversation conversation, InboundPacket packet) {
        List modifierLst = null;
        if (packet.getType() == 6) {
            modifierLst = this.handleModifier(conversation, packet);
        }
        return modifierLst;
    }

    protected static SystemException parseErrorXML(Conversation conversation, int errorStatus, String errorXML, String errorUUID) {
        DocumentBuilder errorDocBuilder = Engine.createDocBuilder(conversation);
        Document errorDoc = null;
        String errorMessage = null;
        GenericError cause = null;
        if (errorXML != null && errorXML.trim().length() > 0) {
            try {
                StringReader errorReader = new StringReader(errorXML);
                InputSource errorSource = new InputSource(errorReader);
                errorDoc = errorDocBuilder.parse(errorSource);
            }
            catch (SAXParseException spe) {
                errorMessage = errorXML;
            }
            catch (Exception e) {
                Locale locale = conversation.getLocale();
                String messageIndex = "Engine.009.ex.txt";
                String message = RB.getStringResource(messageIndex, locale);
                INTERNAL internal = new INTERNAL(message);
                internal.initCause((Throwable)e);
                throw internal;
            }
            if (errorDoc != null) {
                Element errorRoot = errorDoc.getDocumentElement();
                NodeList exceptionElementList = errorRoot.getChildNodes();
                int exceptionElementCount = exceptionElementList.getLength();
                for (int i = exceptionElementCount - 1; i > 0; --i) {
                    Node exceptionElement = exceptionElementList.item(i);
                    errorMessage = Engine.extractMessage(exceptionElement);
                    String severity = Engine.extractSeverity(exceptionElement);
                    LogRecord level = Engine.severityToLogRecord(severity);
                    if (level == null) {
                        StringBuffer messageBuf = new StringBuffer();
                        messageBuf.append("The peer sent a message with unrecognized severity ");
                        messageBuf.append(severity);
                        messageBuf.append(": ");
                        messageBuf.append(errorMessage);
                        messageBuf.append(". It will be treated as an error.");
                        String message = messageBuf.toString();
                        Engine.log(conversation, warningRecord, message, null);
                        level = severeRecord;
                    }
                    if (level.equals(severeRecord)) {
                        GenericError tempError = new GenericError(errorMessage);
                        if (cause != null) {
                            ((Throwable)((Object)tempError)).initCause((Throwable)((Object)cause));
                        }
                        cause = tempError;
                        continue;
                    }
                    String message = "The peer sent a message with severity " + severity + ": " + errorMessage;
                    Engine.log(conversation, level, message, null);
                }
                Node exceptionElement = null;
                if (exceptionElementCount > 0) {
                    exceptionElement = exceptionElementList.item(0);
                }
                errorMessage = Engine.extractMessage(exceptionElement);
            }
        }
        Object error = null;
        if (errorStatus < 0) {
            error = new UnexpectedUserException(errorMessage, errorStatus, errorUUID);
        } else {
            switch (errorStatus) {
                default: {
                    error = new UNKNOWN(errorMessage);
                    break;
                }
                case 2: {
                    if (errorMessage == null) {
                        String messageIndex = "Engine.049.ex.txt";
                        errorMessage = RB.getStringResource(messageIndex);
                    }
                    error = new NO_MEMORY(errorMessage);
                    break;
                }
                case 3: {
                    error = new NO_IMPLEMENT(errorMessage);
                    break;
                }
                case 4: {
                    error = new BAD_OPERATION(errorMessage);
                    break;
                }
                case 5: {
                    error = new BAD_PARAM(errorMessage);
                    break;
                }
                case 6: {
                    error = new NO_PERMISSION(errorMessage);
                    break;
                }
                case 8: {
                    error = new OBJECT_NOT_EXIST(errorMessage);
                    break;
                }
                case 9: {
                    error = new NO_PERMISSION(errorMessage, 3, CompletionStatus.COMPLETED_NO);
                    break;
                }
                case 10: {
                    error = new NO_PERMISSION(errorMessage, 4, CompletionStatus.COMPLETED_NO);
                    break;
                }
                case 12: {
                    error = new DATA_CONVERSION(errorMessage);
                    break;
                }
                case 14: {
                    error = new BAD_PARAM(errorMessage, 2, CompletionStatus.COMPLETED_NO);
                    break;
                }
                case 15: {
                    error = new COMM_FAILURE(errorMessage, 7, CompletionStatus.COMPLETED_NO);
                    break;
                }
                case 17: {
                    error = new UNKNOWN(errorMessage, 2, CompletionStatus.COMPLETED_NO);
                }
            }
        }
        if (cause != null) {
            error.initCause((Throwable)((Object)cause));
        }
        return error;
    }

    protected static String extractMessage(Node exceptionElement) {
        String blank = "";
        if (exceptionElement == null) {
            return blank;
        }
        Node messageElement = exceptionElement.getFirstChild();
        if (messageElement == null) {
            return blank;
        }
        Node textElement = messageElement.getFirstChild();
        if (textElement == null) {
            return blank;
        }
        return textElement.getNodeValue();
    }

    protected static String extractSeverity(Node exceptionElement) {
        String defaultSeverity = severityValueNone;
        if (exceptionElement == null) {
            return defaultSeverity;
        }
        Node messageElement = exceptionElement.getFirstChild();
        if (messageElement == null) {
            return defaultSeverity;
        }
        NamedNodeMap attrMap = messageElement.getAttributes();
        if (attrMap == null) {
            return defaultSeverity;
        }
        Node severityAttr = attrMap.getNamedItem(severityAttrName);
        if (severityAttr == null) {
            return defaultSeverity;
        }
        String severity = severityAttr.getNodeValue();
        if (severity == null || severity.trim().length() == 0) {
            return defaultSeverity;
        }
        return severity;
    }

    protected static LogRecord severityToLogRecord(String severity) {
        if (severity == null) {
            throw new IllegalStateException("severity cannot be null");
        }
        if (severityValueError.equals(severity)) {
            return severeRecord;
        }
        if (severityValueWarning.equals(severity)) {
            return warningRecord;
        }
        if (severityValueNote.equals(severity)) {
            return infoRecord;
        }
        if (severityValueNone.equals(severity)) {
            return fineRecord;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleSelection(Conversation conversation, SelectionHubKey hubKey) {
        if (_writeLogger.isTraceEnabled()) {
            Engine.traceWrites(conversation, "selection handler notified, read=" + hubKey.isReadable() + ",write=" + hubKey.isWritable());
        }
        if (hubKey.isWritable()) {
            boolean done = this.speak(conversation);
            if (done) {
                if (_writeLogger.isTraceEnabled()) {
                    Engine.traceWrites(conversation, "previously unfinished write is now finished");
                }
                int interest = hubKey.interestOps();
                hubKey.interestOps(interest &= 0xFFFFFFFB);
            }
        } else if (hubKey.isReadable()) {
            hubKey.cancel();
            List replyList = conversation.getReplyList();
            List requestList = conversation.getRequestList();
            List list = replyList;
            synchronized (list) {
                boolean dispatched = false;
                if (!requestList.isEmpty()) {
                    Iterator requestItr = requestList.iterator();
                    while (requestItr.hasNext()) {
                        OutboundPacket request;
                        OutboundPacket outboundPacket = request = (OutboundPacket)requestItr.next();
                        synchronized (outboundPacket) {
                            if (!request.isInterrupted()) {
                                request.addRead();
                                request.notifyAll();
                                dispatched = true;
                                break;
                            }
                        }
                    }
                }
                if (!dispatched) {
                    try {
                        hubKey.executeDaemon(conversation);
                    }
                    catch (WorkException we) {
                        conversation.run();
                    }
                }
            }
        }
    }

    protected void handleException(Conversation conversation, SelectionHubKey hubKey, IOException ioe) {
        conversation.setFatalException(ioe);
        this.cough(conversation, ioe);
        this.abortConversation(conversation, false);
    }

    protected void term(Conversation conversation, boolean waitForCompletion) {
        OutboundPacket packet = new OutboundPacket();
        packet.setType(0);
        packet.setMethodId(4);
        this.setOutboundCorrelator(conversation, packet);
        try {
            this.sendPacket(conversation, packet);
            this.sendEOF(conversation);
        }
        catch (COMM_FAILURE cOMM_FAILURE) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean speak(Conversation conversation) {
        List packetList;
        List list = packetList = conversation.getPacketList();
        synchronized (list) {
            Iterator packetItr = packetList.iterator();
            while (packetItr.hasNext()) {
                OutboundPacket packet;
                OutboundPacket outboundPacket = packet = (OutboundPacket)packetItr.next();
                synchronized (outboundPacket) {
                    ByteBuffer outputBuffer = packet.getOutputBuffer();
                    try {
                        if (outputBuffer != null) {
                            int rem1 = outputBuffer.remaining();
                            if (!Engine.writeBuffer(conversation, outputBuffer)) {
                                int rem2 = outputBuffer.remaining();
                                if (_writeLogger.isTraceEnabled()) {
                                    Engine.traceWrites(conversation, "write did not complete, wrote (" + (rem1 - rem2) + " of " + rem1 + " bytes");
                                }
                                return false;
                            }
                        } else {
                            SocketChannel channel = conversation.getChannel();
                            Socket socket = channel.socket();
                            socket.shutdownOutput();
                        }
                        packet.setSent(true);
                    }
                    catch (IOException ioe) {
                        packet.setFatalException(ioe);
                    }
                    packetItr.remove();
                    packet.notifyAll();
                }
            }
        }
        return true;
    }

    protected void listen(Conversation conversation) {
        try {
            IOException fatalException = conversation.getFatalException();
            if (fatalException != null) {
                throw fatalException;
            }
            SocketChannel channel = conversation.getChannel();
            channel.configureBlocking(true);
            do {
                InboundPacket packet;
                List modifierLst = null;
                do {
                    packet = this.recvPacket(conversation, modifierLst);
                    this.logInboundPacket(conversation, packet);
                } while ((modifierLst = this.dispatch(conversation, packet)) != null);
            } while (channel instanceof SSLSocketChannel && ((SSLSocketChannel)channel).hasRemaining());
            channel.configureBlocking(false);
            SelectionHubActivation act = conversation.getHubActivation();
            act.register();
        }
        catch (IOException ioe) {
            this.cough(conversation, ioe);
            this.abortConversation(conversation, false);
            SelectionHubActivation act = conversation.getHubActivation();
            act.deactivate();
        }
        catch (RuntimeException re) {
            if (this.isLoggable(conversation, severeRecord)) {
                String msg = "IOM Bridge for Java encountered an internal error";
                Engine.log(conversation, severeRecord, "IOM Bridge for Java encountered an internal error", re);
            }
            Locale locale = conversation.getLocale();
            String messageIndex = "Engine.047.ex.txt";
            String message = RB.getStringResource(messageIndex, locale);
            IOException art = new IOException(message);
            art.initCause(re);
            this.cough(conversation, art);
            this.abortConversation(conversation, false);
            SelectionHubActivation act = conversation.getHubActivation();
            act.deactivate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cough(Conversation conversation, IOException ioe) {
        List packetList;
        List list = packetList = conversation.getPacketList();
        synchronized (list) {
            Iterator packetItr = packetList.iterator();
            while (packetItr.hasNext()) {
                OutboundPacket packet;
                OutboundPacket outboundPacket = packet = (OutboundPacket)packetItr.next();
                synchronized (outboundPacket) {
                    packet.setFatalException(ioe);
                    packet.notifyAll();
                }
            }
            packetList.clear();
        }
        List replyList = conversation.getReplyList();
        List requestList = conversation.getRequestList();
        List list2 = replyList;
        synchronized (list2) {
            conversation.setFatalException(ioe);
            Iterator requestItr = requestList.iterator();
            while (requestItr.hasNext()) {
                OutboundPacket request;
                OutboundPacket outboundPacket = request = (OutboundPacket)requestItr.next();
                synchronized (outboundPacket) {
                    request.setFatalException(ioe);
                    request.notifyAll();
                }
            }
            requestList.clear();
        }
    }

    protected void setEncoding(Conversation conversation, String encoding) {
        String oldEncoding = conversation.getEncoding();
        if (!encoding.equals(oldEncoding)) {
            final String fEncoding = encoding;
            PrivilegedAction action = new PrivilegedAction(){

                public Object run() {
                    Charset charset = Charset.forName(fEncoding);
                    return charset;
                }
            };
            Charset charset = (Charset)AccessController.doPrivileged(action);
            conversation.setEncoding(encoding);
            CharsetEncoder encoder = charset.newEncoder();
            encoder.onMalformedInput(CodingErrorAction.REPLACE);
            encoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
            conversation.setEncoder(encoder);
            CharsetDecoder decoder = charset.newDecoder();
            decoder.onMalformedInput(CodingErrorAction.REPLACE);
            decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
            conversation.setDecoder(decoder);
        }
    }

    protected void processCommon(Conversation conversation) {
        Locale locale;
        byte pvMinor;
        Byte _pvMajor = (Byte)conversation.getOption("major");
        byte pvMajor = _pvMajor != null ? (byte)_pvMajor : (byte)-1;
        Byte _pvMinor = (Byte)conversation.getOption("minor");
        byte by = pvMinor = _pvMinor != null ? (byte)_pvMinor : (byte)-1;
        if (pvMajor < 0) {
            if (pvMinor >= 0) {
                throw new IllegalArgumentException("protocolVersionMajor: null");
            }
        } else {
            ProtocolVersion protocolVersion = pvMinor < 0 ? ProtocolVersion.fromInt(pvMajor) : ProtocolVersion.fromInt(pvMajor, pvMinor);
            conversation.setProtocolVersion(protocolVersion);
        }
        if ((locale = (Locale)conversation.getOption("locale")) == null) {
            locale = Locale.getDefault();
        }
        this.setLocale(conversation, locale);
        conversation.setEncryptionPolicy("required");
        String cryptoContent = (String)conversation.getOption("encryptioncontent");
        if ("all".equals(cryptoContent)) {
            conversation.setEncryptionLevel((byte)2);
        } else if (cryptoContent == null || "authentication".equals(cryptoContent)) {
            conversation.setEncryptionLevel((byte)1);
        } else {
            String messageIndex = "Engine.010.ex.fmt";
            String messagePattern = RB.getStringResource(messageIndex, locale);
            String message = Message.format((String)messagePattern, (Object)cryptoContent);
            BAD_PARAM bad_param = new BAD_PARAM(message);
            throw bad_param;
        }
    }

    protected void setLocale(Conversation conversation, Locale locale) {
        String localeKey = "com.sas.iom.orb.brg.locale";
        String debugLocaleS = this.getSystemProperty(conversation, localeKey, null);
        Locale myLocale = debugLocaleS != null ? SASURI.parseLocaleName(debugLocaleS) : locale;
        conversation.setLocale(myLocale);
    }

    protected String getDefaultSVID() {
        SASVersionID sasVersionID = SASVersionID.create();
        String svid = sasVersionID.toString();
        return svid;
    }

    protected void initEncoding(Conversation conversation) {
        this.setEncoding(conversation, "UTF8");
    }

    protected void configureChannel(Conversation conversation) {
        try {
            SocketChannel channel = conversation.getChannel();
            Socket socket = channel.socket();
            socket.setTcpNoDelay(true);
        }
        catch (IOException ioe) {
            COMM_FAILURE comm_failure = new COMM_FAILURE();
            comm_failure.initCause((Throwable)ioe);
            throw comm_failure;
        }
    }

    protected void initCommon(Conversation conversation) {
        this.initEncoding(conversation);
        conversation.setAlgArrayIndex(0);
        conversation.setProxyArrayIndex(0);
        conversation.setEngine(this);
    }

    protected boolean flowProcessURI(Conversation conversation) {
        String scheme;
        String proxyList;
        String fileName;
        int dl;
        String svid;
        String[] algArray;
        String cryptoAlgorithms;
        Integer portNumber;
        this.processCommon(conversation);
        SASURI uri = conversation.getURI();
        String host = uri.getHost();
        if (host == null) {
            conversation.setHost(defaultHost);
        }
        if ((portNumber = uri.getPortNumber()) == null) {
            conversation.setPort(8591);
        }
        if ((cryptoAlgorithms = uri.getEncryptionAlgorithms()) != null) {
            cryptoAlgorithms = cryptoAlgorithms.trim().toUpperCase(Locale.US);
            algArray = _commaDelim.split(cryptoAlgorithms);
            conversation.setAlgArray(algArray);
        } else {
            algArray = new String[]{defaultAlgorithm};
            conversation.setAlgArray(algArray);
            conversation.setArtificialAlg(true);
        }
        conversation.setAlgArrayIndex(0);
        if (uri.getSecurityPackage() == null && !uri.isTrustedSAS() && !uri.isTicketAuthentication()) {
            if (uri.getUserName() == null) {
                conversation.setUserName("");
            }
            if (uri.getSealedPassword() == null) {
                conversation.setPasswordChars("".toCharArray());
            }
        }
        if (uri.isTicketAuthentication() && uri.isTrustedSAS()) {
            throw new BAD_PARAM("Ticket authentication and trusted peer authentication cannot be used together.");
        }
        if (uri.isTicketAuthentication()) {
            AuthenticationTicketFactory authTicketFactory = AuthenticationTicketFactoryHolder.get();
            if (authTicketFactory == null) {
                throw new BAD_PARAM("Ticket authentication requires an authentication ticket factory.");
            }
            AuthenticationTicketFactoryHolder.clear();
            conversation.setAuthenticationTicketFactory(authTicketFactory);
        }
        if (uri.getClassFactory() == null) {
            conversation.setClassID(defaultClassID);
        }
        if (uri.getSVID() == null && (svid = this.getDefaultSVID()) != null && svid.length() > 0) {
            conversation.setSVID(svid);
        }
        if (uri.getConnectionID() == null) {
            conversation.setExternalID("");
        }
        if ((dl = uri.getDebugLevel()) > 0) {
            String msg = "The value for debuglevel will be ignored. Use log4j to configure logging.";
            Engine.log(conversation, warningRecord, msg, null);
        }
        if ((fileName = uri.getLogFileName()) != null) {
            String msg = "The value for logfile will be ignored. Use log4j to configure logging.";
            Engine.log(conversation, warningRecord, msg, null);
        }
        if ((proxyList = uri.getProxyList()) != null) {
            String[] proxyUrlStrArr = _semiDelim.split(proxyList);
            URL[] proxyUrlArr = new URL[proxyUrlStrArr.length];
            for (int i = 0; i < proxyUrlStrArr.length; ++i) {
                String proxyUrlStr = proxyUrlStrArr[i];
                if (this.isLoggable(conversation, fineRecord)) {
                    Engine.log(conversation, fineRecord, "Proxy URL: " + proxyUrlStr, null);
                }
                try {
                    URL proxyUrl;
                    proxyUrlArr[i] = proxyUrl = new URL(proxyUrlStr);
                    continue;
                }
                catch (MalformedURLException mue) {
                    Locale locale = conversation.getLocale();
                    String h = conversation.getHost();
                    int p = conversation.getPort();
                    String tunnelEnd = h + ":" + p;
                    String messageIndex = "Engine.060.ex.fmt";
                    String messagePattern = RB.getStringResource(messageIndex, locale);
                    String message = Message.format((String)messagePattern, (Object)tunnelEnd, (Object)proxyUrlStr);
                    BAD_PARAM bad_param = new BAD_PARAM(message);
                    bad_param.initCause((Throwable)mue);
                    throw bad_param;
                }
            }
            conversation.setProxyUrlArray(proxyUrlArr);
            conversation.setProxyArrayIndex(0);
        }
        boolean connectWithSSL = "BRIDGES".equals(scheme = uri.getScheme()) || "IOMS".equals(scheme);
        conversation.setConnectWithSSL(connectWithSSL);
        conversation.setFlowState(20);
        return false;
    }

    protected boolean flowInitClient(Conversation conversation) {
        this.initCommon(conversation);
        if (conversation.isZeroConfig()) {
            conversation.setFlowState(35);
        } else {
            conversation.setFlowState(40);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected boolean flowLaunchServer(Conversation conversation) {
        Object[] locale;
        Object sasProcess;
        String logConfigLocKey;
        String logConfigLoc;
        String basicOptions = null;
        String registryBasicOptions = null;
        String allowxcmdKey = "com.sas.iom.orb.brg.zeroConfigWorkspaceServer.allowxcmd";
        String allowxcmd = this.getSystemProperty(conversation, allowxcmdKey, Boolean.FALSE.toString());
        if (Boolean.valueOf(allowxcmd).booleanValue()) {
            basicOptions = " -nologo -noterminal -objectserver";
            registryBasicOptions = " -xcmd";
        } else {
            basicOptions = " -nologo -noterminal -noxcmd -objectserver";
            registryBasicOptions = "";
        }
        String sasCommandBase = this.getLaunchCommandFromConversation(conversation);
        if (sasCommandBase == null) {
            sasCommandBase = this.getLaunchCommandFromSystemProperties(conversation);
        }
        if (sasCommandBase != null) {
            sasCommandBase = sasCommandBase + basicOptions;
        } else {
            sasCommandBase = this.getLaunchCommandFromRegistry(conversation);
            if (sasCommandBase == null) {
                Locale locale2 = conversation.getLocale();
                String messageIndex = "Engine.052.ex.txt";
                String message = RB.getStringResource(messageIndex, locale2);
                throw new NO_IMPLEMENT(message);
            }
            sasCommandBase = sasCommandBase + registryBasicOptions;
        }
        ServerSocket callbackListenerSocket = null;
        int callbackListenerPort = 0;
        try {
            callbackListenerSocket = new ServerSocket();
            callbackListenerSocket.bind(null);
            callbackListenerPort = callbackListenerSocket.getLocalPort();
        }
        catch (IOException ioe) {
            Locale locale3 = conversation.getLocale();
            String messageIndex = "Engine.057.ex.txt";
            String message = RB.getStringResource(messageIndex, locale3);
            COMM_FAILURE comm_failure = new COMM_FAILURE(message);
            comm_failure.initCause((Throwable)ioe);
        }
        Object[] portHolder = new Object[1];
        Thread portListenerThread = this.listenForServerPort(conversation, portHolder, callbackListenerSocket);
        String loopbackAddress = this.getPreferredLoopbackAddress(conversation);
        StringBuffer sasCommandOptionsBuf = new StringBuffer(1024);
        sasCommandOptionsBuf.append(" -objectserverparms \"protocol=bridge dnsname=");
        sasCommandOptionsBuf.append(loopbackAddress);
        sasCommandOptionsBuf.append(" jcbp=");
        sasCommandOptionsBuf.append(callbackListenerPort);
        sasCommandOptionsBuf.append("\"");
        String secPackageName = conversation.getSecurityPackageName();
        if (secPackageName != null) {
            sasCommandOptionsBuf.append(" -sspi -secpackage ");
            sasCommandOptionsBuf.append(secPackageName);
            String secPackageList = conversation.getSecurityPackageList();
            if (secPackageList != null) {
                sasCommandOptionsBuf.append(" -secpackagelist ");
                sasCommandOptionsBuf.append(secPackageList);
            }
        }
        if ((logConfigLoc = this.getSystemProperty(conversation, logConfigLocKey = "com.sas.iom.orb.brg.zeroConfigWorkspaceServer.logconfigloc", null)) != null && logConfigLoc.trim().length() > 0) {
            sasCommandOptionsBuf.append(" -logconfigloc ").append(logConfigLoc.trim());
        }
        String sasCommandOptions = sasCommandOptionsBuf.toString();
        String sasCommand = sasCommandBase + sasCommandOptions;
        try {
            if (this.isLoggable(conversation, fineRecord)) {
                String msg = "Zero-config workspace server command: " + sasCommand;
                Engine.log(conversation, fineRecord, msg, null);
            }
            String[] argv = this.splitCommandLine(conversation, sasCommand);
            sasProcess = Runtime.getRuntime().exec(argv);
            conversation.setSasProcess((Process)sasProcess);
            conversation.setDestroySasProcess(true);
            if (sasCommand.startsWith("sdssas")) {
                this.readServerProcessOutput(conversation, sasCommandOptions);
            }
        }
        catch (IOException ioe) {
            sasProcess = portHolder;
            // MONITORENTER : portHolder
            if (portHolder[0] == null) {
                locale = conversation.getLocale();
                String messageIndex = "Engine.056.ex.txt";
                String message = RB.getStringResource(messageIndex, (Locale)locale);
                COMM_FAILURE comm_failure = new COMM_FAILURE(message);
                comm_failure.initCause((Throwable)ioe);
                portHolder[0] = comm_failure;
            }
            // MONITOREXIT : sasProcess
        }
        Thread sasProcessMonitorThread = this.monitorServerProcess(conversation, portHolder);
        try {
            sasProcess = portHolder;
            // MONITORENTER : portHolder
            while (portHolder[0] == null) {
                portHolder.wait();
            }
            // MONITOREXIT : sasProcess
        }
        catch (InterruptedException ie) {
            locale = portHolder;
            // MONITORENTER : portHolder
            if (portHolder[0] == null) {
                Locale locale4 = conversation.getLocale();
                String messageIndex = "Engine.055.ex.txt";
                String message = RB.getStringResource(messageIndex, locale4);
                UNKNOWN unknown = new UNKNOWN(message);
                unknown.initCause((Throwable)ie);
                portHolder[0] = unknown;
            }
            // MONITOREXIT : locale
        }
        finally {
            if (portListenerThread != null) {
                portListenerThread.interrupt();
            }
            if (sasProcessMonitorThread != null) {
                sasProcessMonitorThread.interrupt();
            }
        }
        Integer portI = null;
        locale = portHolder;
        // MONITORENTER : portHolder
        if (portHolder[0] instanceof RuntimeException) {
            throw (RuntimeException)portHolder[0];
        }
        portI = (Integer)portHolder[0];
        // MONITOREXIT : locale
        int port = portI;
        conversation.setPort(port);
        conversation.setHost(loopbackAddress);
        conversation.setFlowState(40);
        return false;
    }

    protected String getLaunchCommandFromConversation(Conversation conversation) {
        String sascmd = conversation.getSasCommand();
        return sascmd;
    }

    protected String getLaunchCommandFromSystemProperties(Conversation conversation) {
        String useSdssasKey = "com.sas.iom.orb.brg.zeroConfigWorkspaceServer.usesdssas";
        String useSdssas = this.getSystemProperty(conversation, useSdssasKey, Boolean.FALSE.toString());
        StringBuffer sasCommandBuf = new StringBuffer();
        if (Boolean.valueOf(useSdssas).booleanValue()) {
            String sdssasArgsKey = "com.sas.iom.orb.brg.zeroConfigWorkspaceServer.sdssasargs";
            String sdssasArgs = this.getSystemProperty(conversation, sdssasArgsKey, null);
            sasCommandBuf.append("sdssas ");
            if (sdssasArgs != null) {
                sasCommandBuf.append(sdssasArgs);
                if (this.isLoggable(conversation, fineRecord)) {
                    String msg = "Using sdssas for sas command";
                    Engine.log(conversation, fineRecord, msg, null);
                }
            }
        } else {
            String sascmdKey = "com.sas.iom.orb.brg.zeroConfigWorkspaceServer.sascmd";
            String sascmd = this.getSystemProperty(conversation, sascmdKey, null);
            if (sascmd != null) {
                String msg;
                if (this.isLoggable(conversation, fineRecord)) {
                    msg = "Got SAS command from system properties: " + sascmd;
                    Engine.log(conversation, fineRecord, msg, null);
                }
                if (sascmd.indexOf(34) >= 0) {
                    sasCommandBuf.append(sascmd);
                } else {
                    sasCommandBuf.append('\"');
                    sasCommandBuf.append(sascmd.trim());
                    sasCommandBuf.append('\"');
                    if (this.isLoggable(conversation, fineRecord)) {
                        msg = "Quoted SAS command: " + sasCommandBuf.toString();
                        Engine.log(conversation, fineRecord, msg, null);
                    }
                }
            }
        }
        String sasCommand = sasCommandBuf.length() > 0 ? sasCommandBuf.toString() : null;
        return sasCommand;
    }

    protected String getLaunchCommandFromRegistry(Conversation conversation) {
        String sasCommand;
        block9: {
            sasCommand = null;
            try {
                char[] sasCommandArr;
                int l;
                String regCommand = "reg query \"HKEY_CLASSES_ROOT\\CLSID\\{440196D4-90F0-11D0-9F41-00A024BB830C}\\LocalServer32\" /ve";
                Process regProcess = Runtime.getRuntime().exec(regCommand);
                java.io.InputStream stream = regProcess.getInputStream();
                InputStreamReader reader = new InputStreamReader(stream);
                BufferedReader buffer = new BufferedReader(reader);
                StringBuffer sasCommandBuf = new StringBuffer(1024);
                while ((l = buffer.read(sasCommandArr = new char[1024])) >= 0) {
                    sasCommandBuf.append(sasCommandArr, 0, l);
                }
                regProcess.waitFor();
                String token = "REG_SZ";
                int ndx = sasCommandBuf.indexOf(token);
                if (ndx < 0) {
                    if (this.isLoggable(conversation, warningRecord)) {
                        String msg = "The SAS command from the registry is invalid: " + sasCommandBuf.toString();
                        Engine.log(conversation, warningRecord, msg, null);
                    }
                } else {
                    int prefixL = ndx + token.length();
                    sasCommandBuf.delete(0, prefixL);
                    sasCommand = sasCommandBuf.toString().trim();
                    if (this.isLoggable(conversation, fineRecord)) {
                        String msg = "Got SAS command from registry: " + sasCommand;
                        Engine.log(conversation, fineRecord, msg, null);
                    }
                }
            }
            catch (IOException ioe) {
                if (this.isLoggable(conversation, warningRecord)) {
                    String msg = "The attempt to read the SAS command from the registry failed.";
                    Engine.log(conversation, warningRecord, msg, ioe);
                }
            }
            catch (InterruptedException ie) {
                if (!this.isLoggable(conversation, warningRecord)) break block9;
                String msg = "The attempt to read the SAS command from the registry was interrupted.";
                Engine.log(conversation, warningRecord, msg, ie);
            }
        }
        return sasCommand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Thread listenForServerPort(final Conversation conversation, final Object[] portHolder, final ServerSocket callbackListenerSocket) {
        Object[] objectArray = portHolder;
        synchronized (portHolder) {
            if (portHolder[0] != null) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return null;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            Runnable r = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    Object locale;
                    try {
                        Socket callbackSocket = callbackListenerSocket.accept();
                        try {
                            int callbackProtocolVersion;
                            java.io.InputStream callbackStream = callbackSocket.getInputStream();
                            DataInputStream dataStream = new DataInputStream(callbackStream);
                            int b = dataStream.readByte();
                            int n = callbackProtocolVersion = b >= 0 ? b : b + 256;
                            if (callbackProtocolVersion != 129) {
                                Object[] objectArray = portHolder;
                                synchronized (portHolder) {
                                    if (portHolder[0] != null) return;
                                    Locale locale2 = conversation.getLocale();
                                    String messageIndex = "Engine.058.ex.fmt";
                                    String messagePattern = RB.getStringResource(messageIndex, locale2);
                                    String message = Message.format((String)messagePattern, (Object)new Integer(callbackProtocolVersion));
                                    portHolder[0] = new BAD_PARAM(message);
                                    // ** MonitorExit[var6_16] (shouldn't be in output)
                                    return;
                                }
                            }
                            int s = dataStream.readShort();
                            int port = s >= 0 ? s : s + 65536;
                            Object[] objectArray = portHolder;
                            synchronized (portHolder) {
                                portHolder[0] = new Integer(port);
                                // ** MonitorExit[var8_22] (shouldn't be in output)
                                return;
                            }
                        }
                        finally {
                            this.closeSocket(callbackSocket);
                        }
                    }
                    catch (IOException ioe) {
                        locale = portHolder;
                        synchronized (portHolder) {
                            if (portHolder[0] != null) return;
                            Locale locale3 = conversation.getLocale();
                            String messageIndex = "Engine.057.ex.txt";
                            String message = RB.getStringResource(messageIndex, locale3);
                            COMM_FAILURE comm_failure = new COMM_FAILURE(message);
                            comm_failure.initCause((Throwable)ioe);
                            portHolder[0] = comm_failure;
                            // ** MonitorExit[locale /* !! */ ] (shouldn't be in output)
                            return;
                        }
                    }
                    finally {
                        block36: {
                            try {
                                callbackListenerSocket.close();
                            }
                            catch (IOException ioe) {
                                if (!Engine.this.isLoggable(conversation, finestRecord)) break block36;
                                String msg = "ignoring exception closing port listener";
                                Engine.log(conversation, finestRecord, msg, ioe);
                            }
                        }
                        Object[] objectArray = portHolder;
                        synchronized (portHolder) {
                            if (portHolder[0] == null) {
                                locale = conversation.getLocale();
                                String messageIndex = "Engine.057.ex.txt";
                                String message = RB.getStringResource(messageIndex, (Locale)locale);
                                UNKNOWN unknown = new UNKNOWN(message);
                                portHolder[0] = unknown;
                            }
                            portHolder.notifyAll();
                            // ** MonitorExit[var1_5] (shouldn't be in output)
                        }
                    }
                }

                private void closeSocket(Socket callbackSocket) {
                    block6: {
                        block5: {
                            try {
                                int b;
                                callbackSocket.shutdownOutput();
                                java.io.InputStream callbackSocketInput = callbackSocket.getInputStream();
                                while ((b = callbackSocketInput.read()) >= 0) {
                                }
                            }
                            catch (IOException ioe) {
                                if (!Engine.this.isLoggable(conversation, finestRecord)) break block5;
                                String msg = "ignoring exception draining callback socket";
                                Engine.log(conversation, finestRecord, msg, ioe);
                            }
                        }
                        try {
                            callbackSocket.close();
                        }
                        catch (IOException ioe) {
                            if (!Engine.this.isLoggable(conversation, finestRecord)) break block6;
                            String msg = "ignoring exception closing callback socket";
                            Engine.log(conversation, finestRecord, msg, ioe);
                        }
                    }
                }
            };
            Thread callbackPortThread = new Thread(r, this.getClass().getName() + " port callback listener");
            callbackPortThread.setDaemon(true);
            callbackPortThread.start();
            return callbackPortThread;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Thread monitorServerProcess(final Conversation conversation, final Object[] portHolder) {
        Object[] objectArray = portHolder;
        synchronized (portHolder) {
            if (portHolder[0] != null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return null;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            Runnable r = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    Process sasProcess = conversation.getSasProcess();
                    try {
                        int sasrc = sasProcess.waitFor();
                        Object[] objectArray = portHolder;
                        synchronized (portHolder) {
                            if (portHolder[0] != null) return;
                            Locale locale = conversation.getLocale();
                            String messageIndex = "Engine.053.ex.fmt";
                            String messagePattern = RB.getStringResource(messageIndex, locale);
                            String message = Message.format((String)messagePattern, (Object)new Integer(sasrc));
                            BAD_PARAM bad_param = new BAD_PARAM(message);
                            portHolder[0] = bad_param;
                            portHolder.notifyAll();
                            // ** MonitorExit[var3_4] (shouldn't be in output)
                            return;
                        }
                    }
                    catch (InterruptedException ie) {
                        Object[] objectArray = portHolder;
                        synchronized (portHolder) {
                            if (portHolder[0] != null) return;
                            Locale locale = conversation.getLocale();
                            String messageIndex = "Engine.054.ex.txt";
                            String message = RB.getStringResource(messageIndex, locale);
                            UNKNOWN unknown = new UNKNOWN(message);
                            unknown.initCause((Throwable)ie);
                            portHolder[0] = unknown;
                            portHolder.notifyAll();
                            // ** MonitorExit[var3_5] (shouldn't be in output)
                            return;
                        }
                    }
                }
            };
            Thread serverMonitorThread = new Thread(r, this.getClass().getName() + " server termination monitor");
            serverMonitorThread.setDaemon(true);
            serverMonitorThread.start();
            return serverMonitorThread;
        }
    }

    protected void readServerProcessOutput(Conversation conversation, String target) throws IOException {
        int r;
        if (this.isLoggable(conversation, fineRecord)) {
            String msg = "searching server process output for " + target;
            Engine.log(conversation, fineRecord, msg, null);
        }
        Process sasProcess = conversation.getSasProcess();
        java.io.InputStream sasInputStream = sasProcess.getInputStream();
        byte[] sasOutputArr = new byte[1024];
        StringBuffer sasOutputBuf = new StringBuffer(1024);
        while ((r = sasInputStream.read(sasOutputArr)) >= 0) {
            String sasOutputChunk = new String(sasOutputArr, 0, r);
            if (this.isLoggable(conversation, fineRecord)) {
                String msg = "server process output: " + sasOutputChunk;
                Engine.log(conversation, fineRecord, msg, null);
            }
            sasOutputBuf.append(sasOutputChunk);
            String sasOutput = sasOutputBuf.toString();
            if (!sasOutput.contains(target)) continue;
            break;
        }
    }

    protected String getPreferredLoopbackAddress(Conversation conversation) {
        String loopbackAddress = null;
        try {
            InetAddress inetLoopbackAddress = InetAddress.getByName(null);
            loopbackAddress = inetLoopbackAddress.getHostAddress();
            if (this.isLoggable(conversation, fineRecord)) {
                Engine.log(conversation, fineRecord, "Preferred loopback address is " + loopbackAddress, null);
            }
        }
        catch (UnknownHostException uhe) {
            if (this.isLoggable(conversation, warningRecord)) {
                Engine.log(conversation, warningRecord, "Unable to resolve localhost. Binding to 127.0.0.1.", uhe);
            }
            loopbackAddress = "127.0.0.1";
        }
        return loopbackAddress;
    }

    protected String[] splitCommandLine(Conversation conversation, String commandLine) {
        int spclCommand;
        ArrayList<String> argLst = new ArrayList<String>();
        int state = 0;
        int warnings = 0;
        int commandLineL = commandLine.length();
        StringBuffer argBuf = null;
        int i = 0;
        do {
            int cc = 0;
            char c = '\u0000';
            if (i < commandLineL) {
                c = commandLine.charAt(i);
                cc = Character.isWhitespace(c) ? 1 : (c == '\"' ? 2 : (c == '\\' ? 3 : 4));
            }
            spclCommand = _spclTable[state][cc];
            state = spclCommand & 0xF;
            warnings |= spclCommand & 0xF000;
            if ((spclCommand & 0x80) != 0) {
                argLst.add(argBuf.toString());
                argBuf = null;
            }
            if ((spclCommand & 0x40) != 0) {
                argBuf = new StringBuffer(commandLineL);
            }
            if ((spclCommand & 0x200) != 0) {
                argBuf.append(commandLine.charAt(i - 1));
            }
            if ((spclCommand & 0x10) != 0) {
                argBuf.append(c);
            }
            if ((spclCommand & 0x20) == 0) continue;
            ++i;
        } while ((spclCommand & 0x100) == 0);
        if ((warnings & 0x1000) != 0) {
            String msg = "The SAS command has unbalanced quotation marks: " + commandLine;
            Engine.log(conversation, warningRecord, msg, null);
        }
        if (this.isLoggable(conversation, fineRecord)) {
            String msg = "The SAS command contains these tokens: " + argLst;
            Engine.log(conversation, fineRecord, msg, null);
        }
        int argLstL = argLst.size();
        String[] argv = new String[argLstL];
        return argLst.toArray(argv);
    }

    protected boolean flowConnect(final Conversation conversation) {
        final URL[] proxyArray = conversation.getProxyUrlArray();
        PrivilegedAction action = new PrivilegedAction(){

            public Object run() {
                int port;
                String host;
                Locale locale = conversation.getLocale();
                SocketChannel channel = null;
                try {
                    channel = SocketChannel.open();
                }
                catch (IOException ioe) {
                    String messageIndex = "Engine.015.ex.txt";
                    String message = RB.getStringResource(messageIndex, locale);
                    COMM_FAILURE comm_failure = new COMM_FAILURE(message);
                    comm_failure.initCause((Throwable)ioe);
                    throw comm_failure;
                }
                conversation.setChannel(channel);
                Engine.this.configureChannel(conversation);
                InetSocketAddress socketAddr = null;
                boolean secure = false;
                if (proxyArray == null) {
                    host = conversation.getHost();
                    port = conversation.getPort();
                    socketAddr = Engine.createSocketAddress(conversation, host, port);
                } else {
                    URL proxyUrl = proxyArray[0];
                    socketAddr = Engine.this.urlToSocketAddress(conversation, proxyUrl);
                    secure = Engine.isSecureUrl(proxyUrl);
                    conversation.setProxyArrayIndex(1);
                }
                try {
                    channel.connect(socketAddr);
                    conversation.setDestroySasProcess(false);
                    if (secure) {
                        host = socketAddr.getHostName();
                        port = socketAddr.getPort();
                        channel = SSLSocketChannel.createSocketChannel(channel, host, port, true);
                        conversation.setChannel(channel);
                    }
                }
                catch (ConnectException ce) {
                    String serverEntryPoint = Engine.socketAddressToString(socketAddr);
                    String messageIndex = "Engine.016.ex.fmt";
                    String messagePattern = RB.getStringResource(messageIndex, locale);
                    String message = Message.format((String)messagePattern, (Object)serverEntryPoint);
                    COMM_FAILURE comm_failure = new COMM_FAILURE(message, 1, CompletionStatus.COMPLETED_NO);
                    comm_failure.initCause((Throwable)ce);
                    throw comm_failure;
                }
                catch (UnknownHostException uhe) {
                    String serverEntryPoint = Engine.socketAddressToString(socketAddr);
                    String messageIndex = "Engine.017.ex.fmt";
                    String messagePattern = RB.getStringResource(messageIndex, locale);
                    String message = Message.format((String)messagePattern, (Object)serverEntryPoint);
                    COMM_FAILURE comm_failure = new COMM_FAILURE(message, 1, CompletionStatus.COMPLETED_NO);
                    comm_failure.initCause((Throwable)uhe);
                    throw comm_failure;
                }
                catch (IOException ioe) {
                    String serverEntryPoint = Engine.socketAddressToString(socketAddr);
                    String messageIndex = "Engine.018.ex.fmt";
                    String messagePattern = RB.getStringResource(messageIndex, locale);
                    String message = Message.format((String)messagePattern, (Object)serverEntryPoint);
                    COMM_FAILURE comm_failure = new COMM_FAILURE(message, 1, CompletionStatus.COMPLETED_NO);
                    comm_failure.initCause((Throwable)ioe);
                    throw comm_failure;
                }
                catch (UnresolvedAddressException uae) {
                    String serverEntryPoint = Engine.socketAddressToString(socketAddr);
                    String messageIndex = "Engine.017.ex.fmt";
                    String messagePattern = RB.getStringResource(messageIndex, locale);
                    String message = Message.format((String)messagePattern, (Object)serverEntryPoint);
                    COMM_FAILURE comm_failure = new COMM_FAILURE(message, 1, CompletionStatus.COMPLETED_NO);
                    comm_failure.initCause((Throwable)uae);
                    throw comm_failure;
                }
                return null;
            }
        };
        AccessController.doPrivileged(action);
        if (proxyArray == null) {
            int nextState = conversation.isConnectWithSSL() ? 47 : 50;
            conversation.setFlowState(nextState);
        } else {
            conversation.setFlowState(45);
        }
        return false;
    }

    protected boolean flowConnectTunnel(Conversation conversation) {
        String[] stringArray;
        URL[] proxyArray = conversation.getProxyUrlArray();
        int proxyArrayIndex = conversation.getProxyArrayIndex();
        String host = null;
        int port = 0;
        boolean secure = false;
        if (proxyArrayIndex >= proxyArray.length) {
            host = conversation.getHost();
            port = conversation.getPort();
            int nextState = conversation.isConnectWithSSL() ? 47 : 50;
            conversation.setFlowState(nextState);
        } else {
            URL proxyUrl = proxyArray[proxyArrayIndex];
            InetSocketAddress proxyAddr = this.urlToSocketAddress(conversation, proxyUrl);
            host = proxyAddr.getHostName();
            port = proxyAddr.getPort();
            conversation.setProxyArrayIndex(proxyArrayIndex + 1);
            secure = Engine.isSecureUrl(proxyUrl);
        }
        String tunnelEnd = host + ":" + port;
        StringBuffer methodBuf = new StringBuffer();
        methodBuf.append("CONNECT ").append(tunnelEnd).append(" HTTP/1.0");
        String method = methodBuf.toString();
        String paramConnection = "Connection: keep-alive";
        List<String> requestLst = Arrays.asList(method, paramConnection);
        this.sendHttpRequest(conversation, requestLst);
        List<String> responseLst = this.readHttpResponse(conversation);
        String status = null;
        for (String responseLine : responseLst) {
            if (!responseLine.trim().startsWith("HTTP")) continue;
            status = responseLine;
            break;
        }
        if (status == null) {
            Locale locale = conversation.getLocale();
            String messageIndex = "Engine.061.ex.fmt";
            String messagePattern = RB.getStringResource(messageIndex, locale);
            String message = Message.format((String)messagePattern, (Object)tunnelEnd);
            throw new COMM_FAILURE(message);
        }
        Pattern spaceDelim = Pattern.compile("\\s");
        if (status != null) {
            stringArray = spaceDelim.split(status);
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "";
        }
        String[] statusTokenArr = stringArray;
        int statusCode = 0;
        if (statusTokenArr.length > 1) {
            try {
                statusCode = Integer.parseInt(statusTokenArr[1].trim());
            }
            catch (IllegalArgumentException message) {
                // empty catch block
            }
        }
        if (statusCode < 200 || statusCode >= 300) {
            String msg = status != null ? status : "Unknown HTTP error";
            Locale locale = conversation.getLocale();
            String messageIndex = "Engine.059.ex.fmt";
            String messagePattern = RB.getStringResource(messageIndex, locale);
            String message = Message.format((String)messagePattern, (Object)tunnelEnd);
            COMM_FAILURE comm_failure = new COMM_FAILURE(message);
            comm_failure.initCause((Throwable)new IOException(msg));
            throw comm_failure;
        }
        if (secure) {
            try {
                SocketChannel channel = conversation.getChannel();
                channel = SSLSocketChannel.createSocketChannel(channel, host, port, true);
                conversation.setChannel(channel);
            }
            catch (IOException ioe) {
                Locale locale = conversation.getLocale();
                String messageIndex = "Engine.059.ex.fmt";
                String messagePattern = RB.getStringResource(messageIndex, locale);
                String message = Message.format((String)messagePattern, (Object)tunnelEnd);
                COMM_FAILURE comm_failure = new COMM_FAILURE(message);
                comm_failure.initCause((Throwable)ioe);
                throw comm_failure;
            }
        }
        return false;
    }

    protected void sendHttpRequest(Conversation conversation, List<String> requestLst) {
        if (this.isLoggable(conversation, fineRecord)) {
            StringBuffer msgBuf = new StringBuffer("HTTP request: ");
            for (String string : requestLst) {
                msgBuf.append("\n").append(string);
            }
            String msg = msgBuf.toString();
            Engine.log(conversation, fineRecord, msg, null);
        }
        String eoln = "\r\n";
        StringBuffer requestBuf = new StringBuffer();
        for (String requestLine : requestLst) {
            requestBuf.append(requestLine).append(eoln);
        }
        requestBuf.append(eoln);
        String string = requestBuf.toString();
        Charset utf8 = Charset.forName("utf8");
        ByteBuffer requestBytes = utf8.encode(string);
        SocketChannel channel = conversation.getChannel();
        try {
            channel.write(requestBytes);
        }
        catch (IOException ioe) {
            COMM_FAILURE comm_failure = new COMM_FAILURE();
            comm_failure.initCause((Throwable)ioe);
            throw comm_failure;
        }
    }

    protected List<String> readHttpResponse(Conversation conversation) {
        ArrayList<String> responseLst = new ArrayList<String>();
        boolean statusFound = false;
        ByteBuffer responseBytes = ByteBuffer.allocate(1024);
        responseBytes.limit(0);
        boolean skipNL = false;
        boolean eoln = false;
        Charset utf8 = Charset.forName("utf8");
        CharsetDecoder utf8Decoder = utf8.newDecoder();
        utf8Decoder.onMalformedInput(CodingErrorAction.REPORT);
        float maxCharsPerByte = utf8Decoder.maxCharsPerByte();
        int responseCharsL = (int)Math.ceil(maxCharsPerByte * (float)responseBytes.capacity());
        CharBuffer responseChars = CharBuffer.allocate(responseCharsL);
        responseChars.limit(0);
        StringBuffer lineBuf = new StringBuffer(responseCharsL);
        while (true) {
            if (!responseChars.hasRemaining()) {
                Object result;
                responseChars.clear();
                responseBytes.compact();
                SocketChannel channel = conversation.getChannel();
                try {
                    int r;
                    if (this.isLoggable(conversation, finerRecord)) {
                        Engine.log(conversation, finerRecord, "responseBytes state before read: pos=" + responseBytes.position() + " limit=" + responseBytes.limit(), null);
                    }
                    if ((r = channel.read(responseBytes)) < 0) {
                        String msg = "End of stream reached before HTTP message terminator found.";
                        Engine.log(conversation, warningRecord, msg, null);
                        return responseLst;
                    }
                }
                catch (IOException ioe) {
                    COMM_FAILURE comm_failure = new COMM_FAILURE();
                    comm_failure.initCause((Throwable)ioe);
                    throw comm_failure;
                }
                responseBytes.flip();
                if (this.isLoggable(conversation, finerRecord)) {
                    Engine.log(conversation, finerRecord, "responseBytes state after read: pos=" + responseBytes.position() + " limit=" + responseBytes.limit(), null);
                    this.logData(conversation, responseBytes, "responseBytes after read");
                    Engine.log(conversation, finerRecord, "responseChars state before decode: pos=" + responseChars.position() + " limit=" + responseChars.limit(), null);
                }
                if (((CoderResult)(result = utf8Decoder.decode(responseBytes, responseChars, false))).isMalformed()) {
                    String msg = "Could not transcode HTTP response from proxy server.";
                    throw new MARSHAL(msg);
                }
                responseChars.flip();
                if (this.isLoggable(conversation, finerRecord)) {
                    Engine.log(conversation, finerRecord, "responseBytes state after decode: pos=" + responseBytes.position() + " limit=" + responseBytes.limit(), null);
                    this.logData(conversation, responseBytes, "responseBytes after decode");
                    Engine.log(conversation, finerRecord, "responseChars state after decode: pos=" + responseChars.position() + " limit=" + responseChars.limit(), null);
                    Engine.log(conversation, finerRecord, "responseChars after decode: " + responseChars, null);
                }
            }
            if (this.isLoggable(conversation, finerRecord)) {
                Engine.log(conversation, finerRecord, "before scan: skipNL=" + skipNL + " eoln=" + eoln, null);
            }
            while (responseChars.hasRemaining()) {
                char c = responseChars.get();
                if (c == '\n') {
                    if (skipNL) {
                        skipNL = false;
                        continue;
                    }
                    eoln = true;
                    break;
                }
                if (c == '\r') {
                    skipNL = true;
                    eoln = true;
                    break;
                }
                skipNL = false;
                lineBuf.append(c);
            }
            if (this.isLoggable(conversation, finerRecord)) {
                Engine.log(conversation, finerRecord, "responseChars state after scan: pos=" + responseChars.position() + " limit=" + responseChars.limit(), null);
                Engine.log(conversation, finerRecord, "responseChars after scan: " + responseChars, null);
                Engine.log(conversation, finerRecord, "after scan: skipNL=" + skipNL + " eoln=" + eoln + " statusFound=" + statusFound, null);
            }
            if (!eoln) continue;
            eoln = false;
            if (lineBuf.length() == 0) {
                if (!statusFound) continue;
                break;
            }
            String line = lineBuf.toString();
            lineBuf.setLength(0);
            if (line.trim().length() == 0) {
                if (!statusFound) continue;
                break;
            }
            responseLst.add(line);
            statusFound = true;
        }
        if (this.isLoggable(conversation, fineRecord)) {
            StringBuffer msgBuffer = new StringBuffer("HTTP response: \n");
            for (String responseLine : responseLst) {
                msgBuffer.append(responseLine).append("\n");
            }
            String msg = msgBuffer.toString();
            Engine.log(conversation, fineRecord, msg, null);
        }
        return responseLst;
    }

    protected boolean flowConnectSSL(Conversation conversation) {
        try {
            SocketChannel channel = conversation.getChannel();
            String host = conversation.getHost();
            int port = conversation.getPort();
            SSLSocketChannel sslChannel = SSLSocketChannel.createSocketChannel(channel, host, port, true);
            conversation.setChannel(sslChannel);
        }
        catch (IOException ioe) {
            Locale locale = conversation.getLocale();
            String serverEntryPoint = conversation.getHost() + ":" + conversation.getPort();
            String messageIndex = "Engine.063.ex.fmt";
            String messagePattern = RB.getStringResource(messageIndex, locale);
            String message = Message.format((String)messagePattern, (Object)serverEntryPoint);
            COMM_FAILURE comm_failure = new COMM_FAILURE(message);
            comm_failure.initCause((Throwable)ioe);
            throw comm_failure;
        }
        conversation.setFlowState(50);
        return false;
    }

    protected boolean flowSendUserPass(Conversation conversation) {
        String userName = conversation.getUserName();
        SealedString sealedPassword = conversation.getSealedPassword();
        ORBImpl orb = conversation.getORB();
        AnyImpl _userName = (AnyImpl)orb.create_any();
        _userName.insertIOM(18, userName);
        AnyImpl _password = (AnyImpl)orb.create_any();
        _password.insertIOM(18, sealedPassword);
        AnyImpl[] parmArray = new AnyImpl[]{_userName, _password};
        OutboundPacket packet = new OutboundPacket();
        packet.setParameterArray(parmArray);
        packet.setType(0);
        packet.setMethodId(20);
        this.sendPacket(conversation, packet);
        InboundPacket reply = this.readPacket(conversation);
        int replyType = reply.getType();
        int methodID = reply.getMethodId();
        if (replyType == 0 && methodID != 20) {
            this.handleInternal(conversation, reply);
            return false;
        }
        this.abortRedirectingConnection(conversation);
        ByteBuffer mapBuf = reply.getMapBuf();
        ByteBuffer dataBuf = reply.getDataBuf();
        this._marshaller.unmarshalWZXUnsignedInt(conversation, mapBuf, dataBuf);
        int conversationID = reply.getClientId();
        conversation.setConversationID(conversationID);
        String encoding = null;
        String normDomain = null;
        String normUserName = null;
        byte[] encodingBytes = this._marshaller.unmarshalOctet1dArray(conversation, mapBuf, dataBuf);
        int encodingBytesL = encodingBytes.length - 1;
        encoding = this._marshaller.bytesToString(conversation, encodingBytes, 0, encodingBytesL);
        normDomain = this._marshaller.unmarshalStringNT(conversation, mapBuf, dataBuf);
        conversation.setNormDomain(normDomain);
        normUserName = this._marshaller.unmarshalStringNT(conversation, mapBuf, dataBuf);
        conversation.setNormUserName(normUserName);
        if (this.isLoggable(conversation, fineRecord)) {
            Engine.log(conversation, fineRecord, "received encoding: " + encoding, null);
            Engine.log(conversation, fineRecord, "received domain: " + normDomain, null);
            Engine.log(conversation, fineRecord, "received user name: " + normUserName, null);
        }
        this.setEncoding(conversation, encoding);
        conversation.setFlowState(70);
        return false;
    }

    protected boolean flowSendAuth(Conversation conversation) {
        AnyImpl[] anyImplArray;
        AuthenticationTicketFactory authTicketFactory = conversation.getAuthenticationTicketFactory();
        SecurityPackageBase securityPackage = null;
        byte continuationFlag = 0;
        byte[] curContext = null;
        byte tokenType = 0;
        int methodId = 0;
        if (authTicketFactory == null) {
            securityPackage = conversation.getSecurityPackage();
            if (securityPackage == null) {
                securityPackage = this.createSecurityPackage(conversation);
                conversation.setSecurityPackage(securityPackage);
            }
            continuationFlag = securityPackage.getContinuationFlag();
            curContext = securityPackage.getContext();
            tokenType = 0;
            methodId = 17;
        } else {
            SASURI serviceUrl = conversation.getNegotiatedURI("IOM", omitAttrArr);
            String url = serviceUrl.toString();
            String serviceTicket = authTicketFactory.acquireServiceTicket(url);
            curContext = this._marshaller.stringToBytes(conversation, serviceTicket);
            tokenType = 3;
            methodId = 21;
        }
        OutboundPacket packet = new OutboundPacket();
        packet.setType(0);
        packet.setMethodId(methodId);
        ORBImpl orb = conversation.getORB();
        AnyImpl curContextAny = (AnyImpl)orb.create_any();
        curContextAny.insertIOM(4, curContext);
        AnyImpl continuationFlagAny = (AnyImpl)orb.create_any();
        continuationFlagAny.insert_octet(continuationFlag);
        AnyImpl typeAny = (AnyImpl)orb.create_any();
        typeAny.insert_octet(tokenType);
        if (methodId == 21) {
            AnyImpl[] anyImplArray2 = new AnyImpl[3];
            anyImplArray2[0] = curContextAny;
            anyImplArray2[1] = continuationFlagAny;
            anyImplArray = anyImplArray2;
            anyImplArray2[2] = typeAny;
        } else {
            AnyImpl[] anyImplArray3 = new AnyImpl[2];
            anyImplArray3[0] = curContextAny;
            anyImplArray = anyImplArray3;
            anyImplArray3[1] = continuationFlagAny;
        }
        AnyImpl[] parmArray = anyImplArray;
        packet.setParameterArray(parmArray);
        this.sendPacket(conversation, packet);
        InboundPacket reply = null;
        try {
            reply = this.readPacket(conversation);
        }
        catch (NO_PERMISSION np) {
            if ((np.minor & 0xFFF) == 4) {
                np.minor = 5;
            }
            throw np;
        }
        int replyType = reply.getType();
        int methodID = reply.getMethodId();
        if (replyType == 0 && methodID != methodId) {
            this.handleInternal(conversation, reply);
            return false;
        }
        ByteBuffer mapBuf = reply.getMapBuf();
        ByteBuffer dataBuf = reply.getDataBuf();
        this._marshaller.unmarshalWZXUnsignedInt(conversation, mapBuf, dataBuf);
        byte[] newContext = this._marshaller.unmarshalOctet1dArray(conversation, mapBuf, dataBuf);
        continuationFlag = this._marshaller.unmarshalOctet(conversation, mapBuf, dataBuf);
        if (securityPackage != null) {
            securityPackage.updateContext(newContext);
            securityPackage.setContinuationFlag(continuationFlag);
        }
        if (continuationFlag == 0) {
            if (securityPackage != null) {
                securityPackage.term();
                conversation.setSecurityPackage(null);
            }
            int conversationID = reply.getClientId();
            conversation.setConversationID(conversationID);
            byte[] encodingArr = this._marshaller.unmarshalOctet1dArray(conversation, mapBuf, dataBuf);
            String normDomain = this._marshaller.unmarshalStringNT(conversation, mapBuf, dataBuf);
            conversation.setNormDomain(normDomain);
            String normUserName = this._marshaller.unmarshalStringNT(conversation, mapBuf, dataBuf);
            conversation.setNormUserName(normUserName);
            int encodingArrL = encodingArr.length - 1;
            String encoding = this._marshaller.bytesToString(conversation, encodingArr, 0, encodingArrL);
            this.setEncoding(conversation, encoding);
            if (this.isLoggable(conversation, fineRecord)) {
                Engine.log(conversation, fineRecord, "received encoding: " + encoding, null);
                Engine.log(conversation, fineRecord, "received domain: " + normDomain, null);
                Engine.log(conversation, fineRecord, "received user name: " + normUserName, null);
            }
            conversation.setFlowState(70);
        }
        return false;
    }

    protected boolean flowSendTrust(Conversation conversation) {
        String userName;
        byte cryptoLev = conversation.getEncryptionLevel();
        if (cryptoLev == 0) {
            Locale locale = conversation.getLocale();
            String messageIndex = "Engine.048.ex.txt";
            String message = RB.getStringResource(messageIndex, locale);
            throw new BAD_PARAM(message);
        }
        PrivilegedAction lkpAction = new PrivilegedAction(){

            public Object run() {
                String name = System.getProperty("user.name");
                String domain = System.getenv("USERDOMAIN");
                String[] nameArr = new String[]{name, domain};
                return nameArr;
            }
        };
        PrivilegedAction accAction = new PrivilegedAction(){

            public Object run() {
                SecurityManager sm = System.getSecurityManager();
                if (sm != null) {
                    sm.checkPermission(_trustedPeerPermission);
                }
                AccessControlContext oldAcc = AccessController.getContext();
                AccessControlContext newAcc = new AccessControlContext(oldAcc, _trustedPeerPermissionCombiner);
                return newAcc;
            }
        };
        AccessControlContext modAcc = (AccessControlContext)AccessController.doPrivileged(accAction);
        String[] nameArr = (String[])AccessController.doPrivileged(lkpAction, modAcc);
        String string = userName = nameArr[1] != null ? nameArr[0] + "@" + nameArr[1] : nameArr[0];
        if (this.isLoggable(conversation, fineRecord)) {
            Engine.log(conversation, fineRecord, "sending trusted peer name " + userName, null);
        }
        String tag = "base64";
        String taggedUserName = null;
        try {
            taggedUserName = SasPasswordString.encode((String)tag, (String)userName);
        }
        catch (SasPasswordEncodingException spee) {
            DATA_CONVERSION data_conversion = new DATA_CONVERSION();
            data_conversion.initCause((Throwable)spee);
            throw data_conversion;
        }
        int tagL = tag.length() + 2;
        String encodedUserName = taggedUserName.substring(tagL);
        ORBImpl orb = conversation.getORB();
        AnyImpl _userName = (AnyImpl)orb.create_any();
        _userName.insertIOM(18, encodedUserName);
        AnyImpl[] parmArray = new AnyImpl[]{_userName};
        OutboundPacket packet = new OutboundPacket();
        packet.setParameterArray(parmArray);
        packet.setType(0);
        packet.setMethodId(14);
        this.sendPacket(conversation, packet);
        InboundPacket reply = this.readPacket(conversation);
        int replyType = reply.getType();
        int methodID = reply.getMethodId();
        if (replyType == 0 && methodID != 14) {
            this.handleInternal(conversation, reply);
            return false;
        }
        this.abortRedirectingConnection(conversation);
        ByteBuffer mapBuf = reply.getMapBuf();
        ByteBuffer dataBuf = reply.getDataBuf();
        this._marshaller.unmarshalWZXUnsignedInt(conversation, mapBuf, dataBuf);
        int conversationID = reply.getClientId();
        conversation.setConversationID(conversationID);
        String encoding = null;
        encoding = this._marshaller.unmarshalWZXOctet1dArrayNTToString(conversation, mapBuf, dataBuf);
        if (this.isLoggable(conversation, fineRecord)) {
            Engine.log(conversation, fineRecord, "received encoding: " + encoding, null);
        }
        this.setEncoding(conversation, encoding);
        conversation.setNormUserName(nameArr[0]);
        String normDomain = nameArr[1] != null ? nameArr[1] : "";
        conversation.setNormDomain(normDomain);
        conversation.setFlowState(70);
        return false;
    }

    protected boolean flowSendXcode(Conversation conversation) {
        throw new INTERNAL();
    }

    protected boolean flowProcessDaemon(Conversation conversation) {
        this.processCommon(conversation);
        Daemon daemon = conversation.getDaemon();
        long daemonID = daemon.getDaemonID();
        long connectionID = daemon.assignConnectionID();
        String externalID = LoggerFactory.formatOrderedPair('d', daemonID, 'c', connectionID);
        conversation.setExternalID(externalID);
        this.configureChannel(conversation);
        String[] algArray = new String[]{defaultAlgorithm};
        conversation.setAlgArray(algArray);
        conversation.setAlgArrayIndex(0);
        conversation.setFlowState(30);
        return false;
    }

    protected boolean flowInitServer(Conversation conversation) {
        this.initCommon(conversation);
        conversation.setFlowState(60);
        return false;
    }

    protected boolean flowReadReqs(Conversation conversation) {
        throw new NO_IMPLEMENT();
    }

    protected boolean flowReadUserPass(Conversation conversation) {
        InboundPacket request = this.readPacket(conversation);
        int replyID = request.getReplyId();
        int conversationID = Engine.assignConversationID();
        ByteBuffer mapBuf = request.getMapBuf();
        ByteBuffer dataBuf = request.getDataBuf();
        String userName = this._marshaller.unmarshalStringNT(conversation, mapBuf, dataBuf);
        conversation.setUserName(userName);
        char[] passwordChars = this._marshaller.unmarshalStringNTToCharArray(conversation, mapBuf, dataBuf);
        conversation.setPasswordChars(passwordChars);
        Arrays.fill(passwordChars, '\u0000');
        conversation.setConversationID(conversationID);
        try {
            LoginContext loginContext = this.createLoginContext(conversation);
            conversation.setLoginContext(loginContext);
            this.login(conversation, request);
        }
        catch (LoginException e) {
            NO_PERMISSION no_permission = new NO_PERMISSION(e.getLocalizedMessage());
            this.sendSystemError(conversation, request, no_permission);
            return false;
        }
        OutboundPacket reply = new OutboundPacket();
        reply.setType(0);
        reply.setMethodId(20);
        reply.setReplyId(replyID);
        reply.setRC(OutboundPacket.zero);
        AnyImpl[] parmArr = new AnyImpl[3];
        String encodingName = conversation.isColumnMajor() ? "65001" : conversation.getEncoding();
        ByteBuffer encodingBuf = this._marshaller.stringToBuffer(conversation, encodingName);
        int encodingBufL = encodingBuf.remaining();
        int encodingArrL = encodingBufL + 1;
        byte[] encodingArr = new byte[encodingArrL];
        encodingBuf.get(encodingArr, 0, encodingBufL);
        ORBImpl orb = conversation.getORB();
        parmArr[0] = (AnyImpl)orb.create_any();
        parmArr[0].insertIOM(4, encodingArr);
        parmArr[1] = (AnyImpl)orb.create_any();
        parmArr[1].insert_string("");
        parmArr[2] = (AnyImpl)orb.create_any();
        parmArr[2].insert_string(userName);
        reply.setParameterArray(parmArr);
        this.sendPacket(conversation, reply);
        conversation.setFlowState(70);
        return false;
    }

    protected LoginContext createLoginContext(final Conversation conversation) throws LoginException {
        LoginContext loginContext = null;
        if (!conversation.getDaemon().isSecurityDisabled()) {
            CallbackHandler handler = new CallbackHandler(){

                @Override
                public void handle(Callback[] callbacks) throws UnsupportedCallbackException, IOException {
                    for (int i = 0; i < callbacks.length; ++i) {
                        Callback callback = callbacks[i];
                        if (callback instanceof NameCallback) {
                            ((NameCallback)callback).setName(conversation.getUserName());
                            continue;
                        }
                        if (callback instanceof PasswordCallback) {
                            SealedString sealedPassword = conversation.getSealedPassword();
                            char[] passwordChars = sealedPassword.getCharacters();
                            ((PasswordCallback)callback).setPassword(passwordChars);
                            Arrays.fill(passwordChars, '\u0000');
                            continue;
                        }
                        throw new UnsupportedCallbackException(callback);
                    }
                }
            };
            String loginConfigAppName = conversation.getDaemon().getLoginConfigAppName();
            loginContext = new LoginContext(loginConfigAppName, handler);
        }
        return loginContext;
    }

    protected void login(Conversation conversation, InboundPacket request) throws LoginException {
        LoginContext loginContext = conversation.getLoginContext();
        if (loginContext != null) {
            loginContext.login();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WorkInterface wrapSecureWork(Conversation conversation, final WorkInterface task) {
        Conversation conversation2 = conversation;
        synchronized (conversation2) {
            LoginContext loginContext = conversation.getLoginContext();
            WorkInterface newTask = task;
            if (loginContext != null) {
                final Subject subject = loginContext.getSubject();
                newTask = new WorkInterface(){

                    @Override
                    public void release() {
                        task.release();
                    }

                    @Override
                    public void run() {
                        PrivilegedAction pa = new PrivilegedAction(){

                            public Object run() {
                                task.run();
                                return null;
                            }
                        };
                        Subject.doAs(subject, pa);
                    }
                };
            }
            return newTask;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logout(Conversation conversation) {
        Conversation conversation2 = conversation;
        synchronized (conversation2) {
            block6: {
                LoginContext loginContext = conversation.getLoginContext();
                if (loginContext != null) {
                    try {
                        loginContext.logout();
                    }
                    catch (LoginException e) {
                        if (!this.isLoggable(conversation, finestRecord)) break block6;
                        String msg = "ignoring exception thrown while logging out";
                        Engine.log(conversation, finestRecord, msg, e);
                    }
                }
            }
        }
    }

    protected boolean flowReadAuth(Conversation conversation) {
        throw new NO_IMPLEMENT();
    }

    protected boolean flowReadTrust(Conversation conversation) {
        throw new NO_IMPLEMENT();
    }

    protected boolean flowRegister(Conversation conversation) {
        if (this.isLoggable(conversation, fineRecord)) {
            BufferManager bufferManager = conversation.getBufferManager();
            ByteOrder byteOrder = bufferManager.getByteOrder();
            String _byteOrder = byteOrder.toString();
            Locale locale = conversation.getLocale();
            String _locale = locale.toString();
            byte encrLevel = conversation.getEncryptionLevel();
            String _encrLevel = Engine.encrLevelToString(encrLevel);
            String _rqType = Packet.typeToString(4);
            String _enc = conversation.getEncoding();
            String _datetime = conversation.isSASDateTime() ? "SAS" : "CORBA";
            String _arrayOrder = conversation.isColumnMajor() ? "COLUMN MAJOR" : "ROW MAJOR";
            String _miss = conversation.isPCMiss() ? "PC" : "SAS";
            String _mrb = Integer.toString(_maxReadBuf);
            int l = lt_ttl.length() + 2 + lt_bor.length() + _byteOrder.length() + 2 + lt_dtm.length() + _datetime.length() + 2 + lt_lcl.length() + _locale.length() + 2 + lt_crl.length() + _encrLevel.length() + 2 + lt_rqt.length() + _rqType.length() + 2 + lt_enc.length() + _enc.length() + 2 + lt_arr.length() + _arrayOrder.length() + 2 + lt_mis.length() + _miss.length() + 2 + lt_mrb.length() + _mrb.length() + 2;
            Crypto crypto = conversation.getCrypto();
            String alg = null;
            if (crypto != null) {
                alg = crypto.getName();
                l += lt_cra.length() + alg.length() + 2;
            }
            StringWriter sw = new StringWriter(l);
            PrintWriter pw = new PrintWriter(sw);
            pw.println(lt_ttl);
            pw.print(lt_mrb);
            pw.println(_mrb);
            pw.print(lt_bor);
            pw.println(_byteOrder);
            pw.print(lt_dtm);
            pw.println(_datetime);
            pw.print(lt_mis);
            pw.println(_miss);
            pw.print(lt_arr);
            pw.println(_arrayOrder);
            pw.print(lt_lcl);
            pw.println(_locale);
            pw.print(lt_rqt);
            pw.println(_rqType);
            pw.print(lt_enc);
            pw.println(_enc);
            pw.print(lt_crl);
            pw.println(_encrLevel);
            if (crypto != null) {
                pw.print(lt_cra);
                pw.println(alg);
            }
            pw.flush();
            StringBuffer sb = sw.getBuffer();
            String msg = sb.toString();
            Engine.log(conversation, fineRecord, msg, null);
        }
        SelectionHub hub = conversation.getHub();
        SocketChannel channel = conversation.getChannel();
        int ops = 1;
        SelectionHubActivation act = null;
        try {
            SocketChannel ch;
            channel.configureBlocking(false);
            SocketChannel socketChannel = ch = channel instanceof SSLSocketChannel ? ((SSLSocketChannel)channel).getSelectableChannel() : channel;
            act = conversation.isServer() ? hub.activateServer(ch, ops, conversation) : hub.activateClient(ch, ops, conversation);
        }
        catch (IOException ioe) {
            COMM_FAILURE comm_failure = new COMM_FAILURE();
            comm_failure.initCause((Throwable)ioe);
            throw comm_failure;
        }
        catch (WorkException we) {
            INTERNAL internal = new INTERNAL();
            internal.initCause((Throwable)we);
            throw internal;
        }
        conversation.setHubActivation(act);
        act.register();
        return true;
    }

    protected Crypto getCrypto(Conversation conversation) {
        Crypto crypto = null;
        String[] algArray = conversation.getAlgArray();
        if (algArray != null) {
            Properties p = new Properties();
            int algArrayIndex = conversation.getAlgArrayIndex();
            String algName = null;
            while (algArrayIndex < algArray.length && (crypto = Crypto.getCrypto((String)(algName = algArray[algArrayIndex++]), (Properties)p)) == null) {
            }
            conversation.setAlgArrayIndex(algArrayIndex);
            if (crypto == null) {
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < algArray.length; ++i) {
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append(algArray[i]);
                }
                String algList = sb.toString();
                Locale locale = conversation.getLocale();
                String messageIndex = "Engine.024.ex.fmt";
                String messagePattern = RB.getStringResource(messageIndex, locale);
                String message = Message.format((String)messagePattern, (Object)algList);
                throw new BAD_PARAM(message);
            }
        }
        conversation.setCrypto(crypto);
        conversation.setEncryptionAlgorithms(crypto.getName());
        return crypto;
    }

    protected byte sendReqs(Conversation conversation, ByteBuffer reqs) {
        if (this.isLoggable(conversation, fineRecord)) {
            Engine.log(conversation, fineRecord, lt_rqs, null);
            if (this.isLoggable(conversation, finestRecord)) {
                this.logData(conversation, reqs, lt_snd);
            }
        }
        SocketChannel channel = conversation.getChannel();
        try {
            channel.write(reqs);
        }
        catch (IOException ioe) {
            Locale locale = conversation.getLocale();
            String messageIndex = "Engine.025.ex.txt";
            String message = RB.getStringResource(messageIndex, locale);
            COMM_FAILURE comm_failure = new COMM_FAILURE(message);
            comm_failure.initCause((Throwable)ioe);
            throw comm_failure;
        }
        BufferManager bufferManager = conversation.getBufferManager();
        ByteBuffer statusBuf = bufferManager.allocate(1);
        byte status = 0;
        try {
            Engine.readFully(conversation, statusBuf);
            status = statusBuf.get(0);
        }
        catch (IOException ioe) {
            ProtocolVersion pv = conversation.getProtocolVersion();
            byte pvMajor = pv.getMajor();
            if (pvMajor > 1) {
                Engine.log(conversation, fineRecord, "Server sent EOF instead of sending status; treat as PE_REQS_VERSION", null);
                conversation.setForce0100(true);
                return 5;
            }
            Locale locale = conversation.getLocale();
            String messageIndex = "Engine.026.ex.txt";
            String message = RB.getStringResource(messageIndex, locale);
            COMM_FAILURE comm_failure = new COMM_FAILURE(message);
            comm_failure.initCause((Throwable)ioe);
            throw comm_failure;
        }
        String st = Engine.reqsStatusToString(status);
        if (this.isLoggable(conversation, fineRecord)) {
            if (this.isLoggable(conversation, finestRecord)) {
                this.logData(conversation, statusBuf, lt_rcv);
            }
            Engine.log(conversation, fineRecord, lt_str + st, null);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handleStatus(Conversation conversation, byte status) {
        boolean isLoggableFine = this.isLoggable(conversation, fineRecord);
        boolean isLoggableFinest = this.isLoggable(conversation, finestRecord);
        switch (status) {
            case 0: {
                boolean trustedPeer;
                byte cryptoLevel = conversation.getEncryptionLevel();
                if (cryptoLevel != 0) {
                    try {
                        Crypto crypto = conversation.getCrypto();
                        SocketChannel channel = conversation.getChannel();
                        Socket socket = channel.socket();
                        java.io.InputStream iStream = socket.getInputStream();
                        OutputStream oStream = socket.getOutputStream();
                        CipherInterface cipher = crypto.openCipher();
                        conversation.setCipher(cipher);
                        cipher.keyExchange(iStream, oStream);
                    }
                    catch (IOException ioe) {
                        Locale locale = conversation.getLocale();
                        String messageIndex = "Engine.027.ex.txt";
                        String message = RB.getStringResource(messageIndex, locale);
                        COMM_FAILURE comm_failure = new COMM_FAILURE(message);
                        comm_failure.initCause((Throwable)ioe);
                        throw comm_failure;
                    }
                    catch (CryptoException ce) {
                        Locale locale = conversation.getLocale();
                        String messageIndex = "Engine.027.ex.txt";
                        String message = RB.getStringResource(messageIndex, locale);
                        MARSHAL marshal = new MARSHAL(message);
                        marshal.initCause((Throwable)ce);
                        throw marshal;
                    }
                }
                int flowState = 0;
                String userName = conversation.getUserName();
                SealedString sealedPassword = conversation.getSealedPassword();
                flowState = userName == null && sealedPassword == null ? ((trustedPeer = conversation.isTrustedPeer()) ? 130 : 110) : 80;
                conversation.setFlowState(flowState);
                return false;
            }
            case 2: {
                byte oldCryptoLevel = conversation.getEncryptionLevel();
                byte newCryptoLevel = 0;
                try {
                    BufferManager bufferManager = conversation.getBufferManager();
                    ByteBuffer buf = bufferManager.checkout(1);
                    try {
                        Engine.readFully(conversation, buf);
                        newCryptoLevel = buf.get(0);
                        if (isLoggableFinest) {
                            this.logData(conversation, buf, lt_rcv);
                        }
                    }
                    finally {
                        bufferManager.checkin(buf);
                    }
                }
                catch (IOException ioe) {
                    Locale locale = conversation.getLocale();
                    String messageIndex = "Engine.028.ex.txt";
                    String message = RB.getStringResource(messageIndex, locale);
                    COMM_FAILURE comm_failure = new COMM_FAILURE(message);
                    comm_failure.initCause((Throwable)ioe);
                    throw comm_failure;
                }
                String st = Engine.encrLevelToString(newCryptoLevel);
                if (isLoggableFine) {
                    Engine.log(conversation, fineRecord, "received new encryption level: " + st, null);
                }
                if (newCryptoLevel < oldCryptoLevel) {
                    throw new INTERNAL("Bridge protocol peer is not allowed to downgrade the encryption level");
                }
                conversation.setEncryptionLevel(newCryptoLevel);
                conversation.setAlgArrayIndex(0);
                if (conversation.getAlgArray() == null) {
                    String[] artificialArray = new String[]{defaultAlgorithm};
                    conversation.setAlgArray(artificialArray);
                    conversation.setArtificialAlg(true);
                    if (this.isLoggable(conversation, fineRecord)) {
                        Engine.log(conversation, fineRecord, "synthesizing SASPROPRIETARY for encryption algorithm", null);
                    }
                }
                return false;
            }
            case 1: {
                BufferManager bufferManager = conversation.getBufferManager();
                String[] serverAlgArray = null;
                try {
                    int algListLen = 0;
                    ByteBuffer buf = bufferManager.checkout(1);
                    try {
                        Engine.readFully(conversation, buf);
                        algListLen = buf.get(0);
                        if (isLoggableFine) {
                            if (isLoggableFinest) {
                                this.logData(conversation, buf, lt_rcv);
                            }
                            Engine.log(conversation, fineRecord, "received encryption algorithm list length: " + algListLen, null);
                        }
                        serverAlgArray = new String[algListLen];
                        for (int i = 0; i < algListLen; ++i) {
                            Engine.readFully(conversation, buf);
                            byte serverAlgLen = buf.get(0);
                            if (isLoggableFine) {
                                if (isLoggableFinest) {
                                    this.logData(conversation, buf, lt_rcv);
                                }
                                Engine.log(conversation, fineRecord, "received encryption algorithm name length: " + serverAlgLen, null);
                            }
                            ByteBuffer serverAlgBuf = bufferManager.checkout(serverAlgLen);
                            try {
                                String algName;
                                Engine.readFully(conversation, serverAlgBuf);
                                if (isLoggableFinest) {
                                    this.logData(conversation, serverAlgBuf, lt_rcv);
                                }
                                serverAlgArray[i] = algName = this._marshaller.decodeString(conversation, serverAlgBuf, serverAlgLen);
                                if (!isLoggableFine) continue;
                                Engine.log(conversation, fineRecord, "received encryption algorithm name: " + algName, null);
                                continue;
                            }
                            finally {
                                bufferManager.checkin(serverAlgBuf);
                            }
                        }
                    }
                    finally {
                        bufferManager.checkin(buf);
                    }
                }
                catch (IOException ioe) {
                    Locale locale = conversation.getLocale();
                    String messageIndex = "Engine.029.ex.txt";
                    String message = RB.getStringResource(messageIndex, locale);
                    COMM_FAILURE comm_failure = new COMM_FAILURE(message);
                    comm_failure.initCause((Throwable)ioe);
                    throw comm_failure;
                }
                if (serverAlgArray != null && serverAlgArray.length == 1 && _sslAlgName.equals(serverAlgArray[0])) {
                    this.abortConnection(conversation);
                    conversation.setConnectWithSSL(true);
                    conversation.setFlowState(20);
                    return false;
                }
                String[] clientAlgArray = conversation.getAlgArray();
                boolean artificial = conversation.isArtificialAlg();
                if (clientAlgArray == null || artificial) {
                    conversation.setAlgArray(serverAlgArray);
                    conversation.setAlgArrayIndex(0);
                    conversation.setArtificialAlg(false);
                }
                return false;
            }
            case 4: {
                BufferManager bufferManager = conversation.getBufferManager();
                ByteBuffer redirBuf = bufferManager.checkout(6);
                redirBuf.order(ByteOrder.BIG_ENDIAN);
                String host = null;
                int port = 0;
                try {
                    Engine.readFully(conversation, redirBuf);
                    if (isLoggableFinest) {
                        this.logData(conversation, redirBuf, lt_rcv);
                    }
                    StringBuffer hostBuffer = new StringBuffer(15);
                    for (int i = 0; i < 4; ++i) {
                        int addr;
                        if (i > 0) {
                            hostBuffer.append(".");
                        }
                        if ((addr = redirBuf.get(i)) < 0) {
                            addr += 256;
                        }
                        hostBuffer.append(addr);
                    }
                    host = hostBuffer.toString();
                    port = redirBuf.getShort(4);
                    if (port < 0) {
                        port += 65536;
                    }
                }
                catch (IOException ioe) {
                    Locale locale = conversation.getLocale();
                    String messageIndex = "Engine.030.ex.txt";
                    String message = RB.getStringResource(messageIndex, locale);
                    COMM_FAILURE comm_failure = new COMM_FAILURE(message);
                    comm_failure.initCause((Throwable)ioe);
                    throw comm_failure;
                }
                finally {
                    bufferManager.checkin(redirBuf);
                }
                if (isLoggableFine) {
                    Engine.log(conversation, fineRecord, "received redirect host: " + host, null);
                    Engine.log(conversation, fineRecord, "received redirect port: " + port, null);
                }
                this.abortConnection(conversation);
                conversation.setHost(host);
                conversation.setPort(port);
                conversation.setRedirected(true);
                conversation.setFlowState(20);
                return false;
            }
            case 6: {
                String host = null;
                int port = 0;
                try {
                    BufferManager bufferManager = conversation.getBufferManager();
                    ByteBuffer lenBuf = bufferManager.checkout(4);
                    lenBuf.order(ByteOrder.BIG_ENDIAN);
                    int hostL = 0;
                    try {
                        Engine.readFully(conversation, lenBuf);
                        hostL = lenBuf.getInt();
                        if (isLoggableFine) {
                            if (isLoggableFinest) {
                                this.logData(conversation, lenBuf, lt_rcv);
                            }
                            Engine.log(conversation, fineRecord, "received redirect host name length: " + hostL, null);
                        }
                    }
                    finally {
                        bufferManager.checkin(lenBuf);
                    }
                    int redirL = hostL + 4;
                    ByteBuffer redirBuf = bufferManager.checkout(redirL);
                    redirBuf.order(ByteOrder.BIG_ENDIAN);
                    try {
                        Engine.readFully(conversation, redirBuf);
                        if (isLoggableFinest) {
                            this.logData(conversation, redirBuf, lt_rcv);
                        }
                        if (hostL > 0) {
                            host = this._marshaller.decodeString(conversation, redirBuf, hostL);
                            if (isLoggableFine) {
                                Engine.log(conversation, fineRecord, "received redirect host name: " + host, null);
                            }
                        } else if (conversation.getProxyUrlArray() == null) {
                            host = this.getRemoteAddress(conversation);
                            if (isLoggableFine) {
                                Engine.log(conversation, fineRecord, "received command to redirect to same host: " + host, null);
                            }
                        } else {
                            host = conversation.getHost();
                            if (isLoggableFine) {
                                Engine.log(conversation, fineRecord, "received command to redirect to same host, but remote endpoint is a proxy server. Using host name : " + host, null);
                            }
                        }
                        port = redirBuf.getInt();
                        if (isLoggableFine) {
                            Engine.log(conversation, fineRecord, "received redirect port: " + port, null);
                        }
                    }
                    finally {
                        bufferManager.checkin(redirBuf);
                    }
                }
                catch (IOException ioe) {
                    Locale locale = conversation.getLocale();
                    String messageIndex = "Engine.030.ex.txt";
                    String message = RB.getStringResource(messageIndex, locale);
                    COMM_FAILURE comm_failure = new COMM_FAILURE(message);
                    comm_failure.initCause((Throwable)ioe);
                    throw comm_failure;
                }
                this.abortConnection(conversation);
                conversation.setHost(host);
                conversation.setPort(port);
                conversation.setRedirected(true);
                conversation.setFlowState(20);
                return false;
            }
            case 7: {
                Locale locale = conversation.getLocale();
                String messageIndex = "Engine.031.ex.txt";
                String message = RB.getStringResource(messageIndex, locale);
                throw new COMM_FAILURE(message);
            }
            case 8: {
                Locale locale = conversation.getLocale();
                String messageIndex = "Engine.032.ex.txt";
                String message = RB.getStringResource(messageIndex, locale);
                throw new COMM_FAILURE(message, 7, CompletionStatus.COMPLETED_NO);
            }
            case 5: {
                if (!conversation.isForce0100()) {
                    BufferManager bufferManager = conversation.getBufferManager();
                    ByteBuffer buf = bufferManager.checkout(1);
                    try {
                        Engine.readFully(conversation, buf);
                        byte version = buf.get(0);
                        if (version != 105) {
                            throw new INTERNAL();
                        }
                    }
                    catch (IOException ioe) {
                        if (isLoggableFine) {
                            Engine.log(conversation, fineRecord, "Ignoring exception reading supported protocol version", ioe);
                        }
                    }
                    finally {
                        bufferManager.checkin(buf);
                    }
                }
                conversation.setProtocolVersion(ProtocolVersion.VERSION_01_00);
                conversation.setFlowState(20);
                this.abortConnection(conversation);
                return false;
            }
            case 9: {
                BufferManager bufferManager = conversation.getBufferManager();
                ByteBuffer buf = bufferManager.allocate(2);
                byte pvMajor = 0;
                byte pvMinor = 0;
                try {
                    Engine.readFully(conversation, buf);
                    pvMajor = buf.get(0);
                    pvMinor = buf.get(1);
                    if (isLoggableFinest) {
                        this.logData(conversation, buf, lt_rcv);
                    }
                }
                catch (IOException e) {
                    Locale locale = conversation.getLocale();
                    String messageIndex = "Engine.037.ex.txt";
                    String message = RB.getStringResource(messageIndex, locale);
                    COMM_FAILURE comm_failure = new COMM_FAILURE(message);
                    comm_failure.initCause((Throwable)e);
                    throw comm_failure;
                }
                ProtocolVersion pv = ProtocolVersion.fromInt(pvMajor, pvMinor);
                if (isLoggableFine) {
                    Engine.log(conversation, fineRecord, "Received supported protocol version: " + pv.toString(), null);
                }
                conversation.setProtocolVersion(pv);
                conversation.setFlowState(20);
                this.abortConnection(conversation);
                return false;
            }
            case 11: {
                conversation.setForcingPlainTextRead(true);
                this.readPacket(conversation);
                throw new INTERNAL();
            }
        }
        Locale locale = conversation.getLocale();
        String messageIndex = "Engine.033.ex.fmt";
        String messagePattern = RB.getStringResource(messageIndex, locale);
        String message = Message.format((String)messagePattern, (Object)Integer.toString(status));
        throw new INTERNAL(message);
    }

    protected SecurityPackageBase createSecurityPackage(Conversation conversation) {
        SecurityPackageBase securityPackage = new SecurityPackageBase();
        Locale locale = conversation.getLocale();
        securityPackage.setLocale(locale);
        String securityPackageName = conversation.getSecurityPackageName();
        String securityPackageList = conversation.getSecurityPackageList();
        String spn = conversation.getSPN();
        String host = conversation.getHost();
        int port = conversation.getPort();
        securityPackage.initClient(securityPackageName, securityPackageList, spn, host, port);
        return securityPackage;
    }

    protected String getRemoteAddress(Conversation conversation) {
        SocketChannel channel = conversation.getChannel();
        Socket socket = channel.socket();
        InetAddress addr = socket.getInetAddress();
        String host = addr.getHostAddress();
        return host;
    }

    protected ObjectImpl newObject(Conversation conversation) {
        String classID = conversation.getClassID();
        OutboundPacket request = new OutboundPacket();
        request.setType(0);
        request.setUuid(classID);
        String className = conversation.getClassName();
        if (className == null) {
            request.setMethodId(2);
        } else {
            request.setMethodId(16);
            ORBImpl orb = conversation.getORB();
            AnyImpl parm = (AnyImpl)orb.create_any();
            parm.insertIOM(18, className);
            AnyImpl[] parmArray = new AnyImpl[]{parm};
            request.setParameterArray(parmArray);
        }
        this.setOutboundCorrelator(conversation, request);
        this.sendPacket(conversation, request);
        InboundPacket reply = this.waitForReply(conversation, request);
        int objectID = reply.getObjectId();
        ObjectImpl obj = this._marshaller.objectIDToObject(conversation, objectID);
        return obj;
    }

    protected org.omg.CORBA.Object newLocalObject(Conversation conversation, String className) {
        Locale locale = conversation.getLocale();
        String localeStr = locale.toString();
        String scheme = "IOM";
        int bufL = scheme.length();
        bufL += SASURI.cssL;
        String host = defaultHost;
        bufL += host.length();
        bufL += SASURI.semiL;
        String protocol = "INTERNAL";
        bufL += protocol.length();
        bufL += SASURI.semiL;
        String classNameKey = SASURI.urlEncode("classname");
        bufL += classNameKey.length();
        bufL += SASURI.eqlL;
        String classNameVal = SASURI.urlEncode(className);
        bufL += classNameVal.length();
        bufL += SASURI.commaL;
        String localeKey = SASURI.urlEncode("locale");
        bufL += localeKey.length();
        bufL += SASURI.eqlL;
        String localeVal = SASURI.urlEncode(localeStr);
        StringBuffer buf = new StringBuffer(bufL += localeVal.length());
        buf.append(scheme).append("://").append(host).append(";");
        buf.append(protocol).append(";");
        buf.append(classNameKey).append("=").append(classNameVal);
        buf.append(",");
        buf.append(localeKey).append("=").append(localeVal);
        String uriStr = buf.toString();
        ORBImpl orb = conversation.getORB();
        SASURI uri = SASURI.create(uriStr);
        org.omg.CORBA.Object obj = null;
        try {
            obj = orb.uri_to_object(uri);
        }
        catch (INV_OBJREF inv_objref) {
            Throwable cause = inv_objref.getCause();
            if (cause != null) {
                String messagePattern;
                String messageIndex;
                String message = null;
                if (cause instanceof ClassNotFoundException) {
                    messageIndex = "Engine.042.ex.fmt";
                    messagePattern = RB.getStringResource(messageIndex, locale);
                    message = Message.format((String)messagePattern, (Object)className);
                }
                if (cause instanceof ClassCastException) {
                    messageIndex = "Engine.043.ex.fmt";
                    messagePattern = RB.getStringResource(messageIndex, locale);
                    message = Message.format((String)messagePattern, (Object)className);
                }
                if (cause instanceof NoSuchMethodException) {
                    messageIndex = "Engine.044.ex.fmt";
                    messagePattern = RB.getStringResource(messageIndex, locale);
                    message = Message.format((String)messagePattern, (Object)className);
                }
                inv_objref = new INV_OBJREF(message);
            }
            throw inv_objref;
        }
        return obj;
    }

    protected void abortConnection(Conversation conversation) {
        this.abortConnection(conversation, true);
    }

    protected void abortConnection(Conversation conversation, boolean locallyInitiated) {
        this.abortConnectionPrep(conversation);
        this.abortRedirectingConnection(conversation);
        this.abortActiveConnection(conversation, locallyInitiated);
    }

    protected void abortConnectionPrep(Conversation conversation) {
        this.closeCipher(conversation);
        SecurityPackageBase securityPackage = conversation.getSecurityPackage();
        if (securityPackage != null) {
            securityPackage.term();
            conversation.setSecurityPackage(null);
        }
    }

    protected void abortRedirectingConnection(Conversation conversation) {
        SocketChannel channel = conversation.getRedirectingChannel();
        if (channel == null) {
            return;
        }
        if (this.isLoggable(conversation, fineRecord)) {
            Engine.log(conversation, fineRecord, "terminating redirecting connection", null);
        }
        conversation.setRedirectingChannel(null);
        this.closeConnection(conversation, channel);
    }

    protected void abortActiveConnection(Conversation conversation) {
        this.abortActiveConnection(conversation, true);
    }

    protected void abortActiveConnection(Conversation conversation, boolean locallyInitiated) {
        SocketChannel channel = conversation.getChannel();
        if (channel == null) {
            return;
        }
        if (this.isLoggable(conversation, fineRecord)) {
            Engine.log(conversation, fineRecord, "terminating connection", null);
        }
        this.closeConnection(conversation, channel, locallyInitiated);
        Process sasProcess = conversation.getSasProcess();
        if (sasProcess != null) {
            boolean destroy = conversation.isDestroySasProcess();
            if (destroy) {
                sasProcess.destroy();
            }
            conversation.setSasProcess(null);
            conversation.setDestroySasProcess(false);
        }
    }

    protected void closeConnection(Conversation conversation, SocketChannel channel) {
        this.closeConnection(conversation, channel, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean closeConnection(Conversation conversation, SocketChannel channel, boolean locallyInitiated) {
        String msg;
        boolean outputShutdown;
        block18: {
            Socket socket = channel.socket();
            outputShutdown = false;
            try {
                socket.shutdownOutput();
                outputShutdown = true;
            }
            catch (IOException ioe) {
                outputShutdown = socket.isOutputShutdown();
                if (outputShutdown || !this.isLoggable(conversation, warningRecord)) break block18;
                msg = "exception thrown while shutting down output channel";
                Engine.log(conversation, warningRecord, msg, ioe);
            }
        }
        if (outputShutdown && locallyInitiated && conversation.getFlowState() == 70) {
            return outputShutdown;
        }
        try {
            if (outputShutdown && channel.isBlocking() && channel.isConnected()) {
                ByteBuffer buf = ByteBuffer.allocate(1);
                while (channel.read(buf) >= 0) {
                    buf.clear();
                }
            }
        }
        catch (IOException ioe) {
            if (this.isLoggable(conversation, finestRecord)) {
                msg = "ignoring exception thrown while draining channel";
                Engine.log(conversation, finestRecord, msg, ioe);
            }
        }
        finally {
            block20: {
                try {
                    channel.close();
                }
                catch (IOException ioe) {
                    Process sasProcess = conversation.getSasProcess();
                    if (sasProcess != null) {
                        conversation.setDestroySasProcess(true);
                    }
                    if (!this.isLoggable(conversation, finestRecord)) break block20;
                    String msg2 = "ignoring exception thrown while closing channel";
                    Engine.log(conversation, finestRecord, msg2, ioe);
                }
            }
        }
        return outputShutdown;
    }

    protected void abortConversation(Conversation conversation) {
        this.abortConversation(conversation, true);
    }

    protected void abortConversation(Conversation conversation, boolean locallyInitiated) {
        this.logout(conversation);
        this.abortConnection(conversation, locallyInitiated);
        ORBImpl orb = conversation.getORB();
        orb.untrackResource(conversation);
        if (this.isLoggable(conversation, fineRecord)) {
            Engine.log(conversation, fineRecord, "terminating conversation", null);
        }
        if (conversation.isServer()) {
            Daemon daemon = conversation.getDaemon();
            daemon.abortConversation(conversation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeCipher(Conversation conversation) {
        Conversation conversation2 = conversation;
        synchronized (conversation2) {
            CipherInterface cipher = conversation.getCipher();
            if (cipher != null) {
                try {
                    cipher.close();
                }
                catch (CryptoException ce) {
                    String msg = "exception thrown while closing cipher";
                    Engine.log(conversation, warningRecord, msg, ce);
                }
                finally {
                    conversation.setCipher(null);
                }
            }
        }
    }

    protected InboundPacket readPacket(Conversation conversation) {
        InboundPacket packet = null;
        List modifierLst = null;
        do {
            try {
                packet = this.recvPacket(conversation, modifierLst);
            }
            catch (IOException ioe) {
                COMM_FAILURE comm_failure = new COMM_FAILURE();
                comm_failure.initCause((Throwable)ioe);
                throw comm_failure;
            }
            this.logInboundPacket(conversation, packet);
            this.checkForErrorPacket(conversation, packet);
        } while ((modifierLst = this.checkForModifierPacket(conversation, packet)) != null);
        return packet;
    }

    protected InboundPacket recvPacket(Conversation conversation, List modifierLst) throws IOException {
        byte cryptoLevel = conversation.getEncryptionLevel();
        InboundPacket packet = null;
        packet = !conversation.isForcingPlainTextRead() && (cryptoLevel == 2 || cryptoLevel == 1 && (this.isReadUserPass(conversation) || this.hasModifier(conversation, modifierLst, 0x40000000))) ? this.readEncryptedPacket(conversation) : this.readClearTextPacket(conversation);
        packet.setModifierLst(modifierLst);
        return packet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InboundPacket readEncryptedPacket(Conversation conversation) throws IOException {
        BufferManager bufferManager = conversation.getBufferManager();
        int cHeaderLen = 0;
        ByteBuffer lenBuf = bufferManager.checkout(4);
        lenBuf.order(ByteOrder.BIG_ENDIAN);
        try {
            Engine.readFully(conversation, lenBuf);
            cHeaderLen = lenBuf.getInt();
        }
        finally {
            bufferManager.checkin(lenBuf);
        }
        byte[] cHeader = new byte[cHeaderLen];
        ByteBuffer cHeaderBuf = bufferManager.checkout(cHeaderLen);
        try {
            Engine.readFully(conversation, cHeaderBuf);
            cHeaderBuf.get(cHeader, 0, cHeaderLen);
        }
        finally {
            bufferManager.checkin(cHeaderBuf);
        }
        ByteArrayInputStream cStream = new ByteArrayInputStream(cHeader, 0, cHeaderLen);
        byte[] pHeader = new byte[64];
        this.decryptBuf(conversation, cStream, cHeaderLen, pHeader);
        ByteBuffer pHeaderBuf = bufferManager.wrap(pHeader);
        InboundPacket packet = new InboundPacket(conversation);
        this._marshaller.unmarshalHeader(conversation, packet, pHeaderBuf);
        pHeaderBuf.rewind();
        ByteBuffer roHeaderBuf = BufferManager.asReadOnlyBuffer(pHeaderBuf);
        packet.setHeaderBuf(roHeaderBuf);
        int size = packet.getSize();
        if (size == 64) {
            return packet;
        }
        int cPayloadLen = 0;
        lenBuf = bufferManager.checkout(4);
        lenBuf.order(ByteOrder.BIG_ENDIAN);
        try {
            Engine.readFully(conversation, lenBuf);
            cPayloadLen = lenBuf.getInt();
        }
        finally {
            bufferManager.checkin(lenBuf);
        }
        byte[] cPayload = new byte[cPayloadLen];
        ByteBuffer cPayloadBuf = bufferManager.checkout(cPayloadLen);
        try {
            Engine.readFully(conversation, cPayloadBuf);
            cPayloadBuf.get(cPayload, 0, cPayloadLen);
        }
        finally {
            bufferManager.checkin(cPayloadBuf);
        }
        cStream = new ByteArrayInputStream(cPayload, 0, cPayloadLen);
        int pPayloadLen = size - 64;
        byte[] pPayload = new byte[pPayloadLen];
        this.decryptBuf(conversation, cStream, cPayloadLen, pPayload);
        int mapCount = packet.getMapCount();
        int mapSize = mapCount * 4;
        ByteBuffer mapBuf = bufferManager.wrap(pPayload, 0, mapSize);
        ByteBuffer roMapBuf = BufferManager.asReadOnlyBuffer(mapBuf);
        packet.setMapBuf(roMapBuf);
        int dataSize = size - 64 - mapSize;
        ByteBuffer dataBuf = bufferManager.wrap(pPayload, mapSize, dataSize);
        ByteBuffer roDataBuf = BufferManager.asReadOnlyBuffer(dataBuf);
        packet.setDataBuf(roDataBuf);
        return packet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decryptBuf(Conversation conversation, java.io.InputStream str, int len, byte[] buf) {
        Conversation conversation2 = conversation;
        synchronized (conversation2) {
            CipherInterface cipher = conversation.getCipher();
            try {
                cipher.decrypt(str, len, buf, 0);
            }
            catch (IOException ioe) {
                Locale locale = conversation.getLocale();
                String messageIndex = "Engine.020.ex.txt";
                String message = RB.getStringResource(messageIndex, locale);
                COMM_FAILURE comm_failure = new COMM_FAILURE(message);
                comm_failure.initCause((Throwable)ioe);
                throw comm_failure;
            }
            catch (CryptoException ce) {
                Locale locale = conversation.getLocale();
                String messageIndex = "Engine.020.ex.txt";
                String message = RB.getStringResource(messageIndex, locale);
                MARSHAL marshal = new MARSHAL(message);
                marshal.initCause((Throwable)ce);
                throw marshal;
            }
        }
    }

    protected InboundPacket readClearTextPacket(Conversation conversation) throws IOException {
        BufferManager bufferManager = conversation.getBufferManager();
        ByteBuffer headerBuf = bufferManager.allocate(64);
        Engine.readFully(conversation, headerBuf);
        InboundPacket packet = new InboundPacket(conversation);
        this._marshaller.unmarshalHeader(conversation, packet, headerBuf);
        headerBuf.rewind();
        ByteBuffer roHeaderBuf = BufferManager.asReadOnlyBuffer(headerBuf);
        packet.setHeaderBuf(roHeaderBuf);
        int packetSize = packet.getSize();
        if (packetSize == 64) {
            return packet;
        }
        int payloadSize = packetSize - 64;
        ByteBuffer payloadBuf = bufferManager.allocate(payloadSize);
        Engine.readFully(conversation, payloadBuf);
        int mapCount = packet.getMapCount();
        int mapSize = mapCount * 4;
        ByteBuffer mapBuf = payloadBuf;
        ByteBuffer dataBuf = BufferManager.duplicate(payloadBuf);
        mapBuf.limit(mapSize);
        dataBuf.position(mapSize);
        ByteBuffer roMapBuf = BufferManager.asReadOnlyBuffer(mapBuf);
        packet.setMapBuf(roMapBuf);
        ByteBuffer roDataBuf = BufferManager.asReadOnlyBuffer(dataBuf);
        packet.setDataBuf(roDataBuf);
        return packet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isRemoteObjectActive(Conversation conversation, Integer ID) {
        Map remoteMap = conversation.getRemoteMap();
        DelegateImpl delegate = null;
        Map map = remoteMap;
        synchronized (map) {
            WeakReference ref = (WeakReference)remoteMap.get(ID);
            delegate = ref == null ? null : (DelegateImpl)((Object)ref.get());
            return delegate != null;
        }
    }

    protected boolean isSendUserPass(Conversation conversation, Packet packet) {
        ProtocolVersion pv = conversation.getProtocolVersion();
        boolean sendUserPass = this.isInternalRequest(conversation, packet, 1) || this.isInternalReply(conversation, packet, 1) && !ProtocolVersion.VERSION_01_00.equals(pv) || this.isInternalRequest(conversation, packet, 20) || this.isInternalReply(conversation, packet, 20) || this.isInternalRequest(conversation, packet, 17) || this.isInternalReply(conversation, packet, 17) || this.isInternalRequest(conversation, packet, 21) || this.isInternalReply(conversation, packet, 21) || this.isInternalRequest(conversation, packet, 14) || this.isModified(conversation, packet, 0x40000000);
        return sendUserPass;
    }

    protected boolean isReadUserPass(Conversation conversation) {
        int flowState = conversation.getFlowState();
        ProtocolVersion pv = conversation.getProtocolVersion();
        boolean readUserPass = flowState == 90 || flowState == 110 || flowState == 120 || flowState == 80 && !ProtocolVersion.VERSION_01_00.equals(pv);
        return readUserPass;
    }

    protected boolean isInternalRequest(Conversation conversation, Packet packet, int commandID) {
        int typeID = packet.getType();
        int methID = packet.getMethodId();
        boolean result = typeID == 0 && methID == commandID && !this.isReply(conversation, packet);
        return result;
    }

    protected boolean isInternalReply(Conversation conversation, Packet packet, int commandID) {
        int typeID = packet.getType();
        int methID = packet.getMethodId();
        boolean result = typeID == 0 && methID == commandID && this.isReply(conversation, packet);
        return result;
    }

    protected boolean isModified(Conversation conversation, Packet packet, int modifierTyp) {
        List modifierLst = packet.getModifierLst();
        boolean modified = this.hasModifier(conversation, modifierLst, modifierTyp);
        return modified;
    }

    protected boolean hasModifier(Conversation conversation, List modifierLst, int modifierTyp) {
        if (modifierLst != null && !modifierLst.isEmpty()) {
            for (Packet.Modifier modifier : modifierLst) {
                if (modifier.getType() != modifierTyp) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isReply(Conversation conversation, Packet packet) {
        int type = packet.getType();
        if (type == 2) {
            return true;
        }
        if (type != 0) {
            return false;
        }
        int methodID = packet.getMethodId();
        if (methodID == 4 || methodID == 8) {
            return false;
        }
        if (packet.isInbound()) {
            ByteBuffer mapBuf = ((InboundPacket)packet).getMapBuf();
            if (mapBuf != null && mapBuf.limit() >= 4) {
                int map = mapBuf.getInt(0);
                boolean result = Marshaller.isWZXUnsignedInt(map);
                return result;
            }
            return false;
        }
        boolean result = ((OutboundPacket)packet).isReply();
        return result;
    }

    protected List dispatch(final Conversation conversation, final InboundPacket packet) {
        if (this.isReply(conversation, packet)) {
            this.handleReply(conversation, packet);
            return null;
        }
        final int type = packet.getType();
        if (type == 6) {
            List modifierLst = this.handleModifier(conversation, packet);
            return modifierLst;
        }
        if (type == 5) {
            this.handleEventByName(conversation, packet);
            return null;
        }
        WorkInterface task = new WorkInterface(){

            @Override
            public void release() {
            }

            @Override
            public void run() {
                switch (type) {
                    case 0: {
                        Engine.this.handleInternal(conversation, packet);
                        break;
                    }
                    case 4: {
                        Engine.this.handleRequestByName(conversation, packet);
                        break;
                    }
                    case 1: {
                        Engine.this.handleRequest(conversation, packet);
                        break;
                    }
                    default: {
                        throw new INTERNAL();
                    }
                }
            }
        };
        task = this.wrapSecureWork(conversation, task);
        ObjectImpl localObject = type == 1 || type == 4 ? this.getLocalObject(conversation, packet, false) : null;
        this.dispatchWorkForLocalObject(conversation, localObject, task);
        return null;
    }

    protected ObjectImpl getLocalObject(Conversation conversation, InboundPacket packet, boolean throwExceptionIfNotFound) {
        ObjectImpl target;
        block2: {
            target = null;
            try {
                int targetID = packet.getObjectId() & Integer.MAX_VALUE;
                int myID = targetID | Integer.MIN_VALUE;
                target = this._marshaller.objectIDToObject(conversation, myID);
            }
            catch (OBJECT_NOT_EXIST one) {
                if (!throwExceptionIfNotFound) break block2;
                throw one;
            }
        }
        return target;
    }

    protected void dispatchWorkForLocalObject(Conversation conversation, ObjectImpl target, WorkInterface work) {
        try {
            Delegate delegate;
            if (target != null && (delegate = target._get_delegate()) instanceof DelegateLocal) {
                ((DelegateLocal)delegate).executeWork(work);
                return;
            }
            SelectionHubActivation act = conversation.getHubActivation();
            act.executeWork(work);
        }
        catch (WorkException we) {
            Locale locale = conversation.getLocale();
            String messageIndex = "Engine.050.ex.txt";
            String message = RB.getStringResource(messageIndex, locale);
            INTERNAL internal = new INTERNAL(message);
            internal.initCause((Throwable)we);
            throw internal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleReply(Conversation conversation, InboundPacket reply) {
        List replyList = conversation.getReplyList();
        List requestList = conversation.getRequestList();
        int replyID = reply.getReplyId();
        List list = replyList;
        synchronized (list) {
            OutboundPacket request = (OutboundPacket)Engine.matchReply(requestList, replyID);
            if (request != null) {
                OutboundPacket outboundPacket = request;
                synchronized (outboundPacket) {
                    request.setReply(reply);
                    request.notifyAll();
                }
            } else {
                replyList.add(reply);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleInternal(Conversation conversation, InboundPacket packet) {
        int methodID = packet.getMethodId();
        switch (methodID) {
            case 4: {
                Conversation conversation2 = conversation;
                synchronized (conversation2) {
                    conversation.setPeerClosed(true);
                }
                return;
            }
            case 8: {
                Map remoteMap;
                int objectID = packet.getObjectId();
                Integer key = new Integer(objectID);
                Map map = remoteMap = conversation.getRemoteMap();
                synchronized (map) {
                    remoteMap.remove(key);
                }
                return;
            }
            case 15: {
                ByteBuffer mapBuf = packet.getMapBuf();
                ByteBuffer dataBuf = packet.getDataBuf();
                this._marshaller.unmarshalWZXUnsignedInt(conversation, mapBuf, dataBuf);
                byte pvMajor = this._marshaller.unmarshalOctet(conversation, mapBuf, dataBuf);
                byte pvMinor = this._marshaller.unmarshalOctet(conversation, mapBuf, dataBuf);
                ProtocolVersion pv = null;
                pv = pvMajor == 105 ? ProtocolVersion.VERSION_01_00 : ProtocolVersion.fromInt(pvMajor, pvMinor);
                this.abortConnection(conversation);
                conversation.setProtocolVersion(pv);
                conversation.setFlowState(20);
                return;
            }
            case 18: {
                SealedString sealedPassword;
                char[] passwordChars;
                ByteBuffer mapBuf = packet.getMapBuf();
                ByteBuffer dataBuf = packet.getDataBuf();
                this._marshaller.unmarshalWZXUnsignedInt(conversation, mapBuf, dataBuf);
                char[] uriChars = this._marshaller.unmarshalStringNTToCharArray(conversation, mapBuf, dataBuf);
                SASURI uri = SASURI.create(uriChars);
                Arrays.fill(uriChars, '\u0000');
                Map newOptions = uri.getSecureAttributesForScheme("BRIDGE");
                Set entrySet = newOptions.entrySet();
                Map oldOptions = conversation.getOptions();
                String oldHost = conversation.getHost();
                for (Map.Entry entry : entrySet) {
                    String name = (String)entry.getKey();
                    Object val = entry.getValue();
                    SASURI.updateAttribute(name, val, oldOptions);
                }
                conversation.setFlowState(20);
                conversation.setRedirected(true);
                String host = uri.getHost();
                if (host == null || host.length() == 0) {
                    host = conversation.getProxyUrlArray() == null ? this.getRemoteAddress(conversation) : oldHost;
                    conversation.setHost(host);
                }
                char[] cArray = passwordChars = (sealedPassword = uri.getSealedPass()) != null ? sealedPassword.getCharacters() : null;
                if (passwordChars != null && passwordChars.length > 0) {
                    this.abortRedirectingConnection(conversation);
                    this.abortConnectionPrep(conversation);
                    SocketChannel channel = conversation.getChannel();
                    conversation.setChannel(null);
                    conversation.setRedirectingChannel(channel);
                    Arrays.fill(passwordChars, '\u0000');
                } else {
                    this.abortConnection(conversation);
                }
                return;
            }
        }
        try {
            Locale locale = conversation.getLocale();
            OutboundPacket reply = null;
            switch (methodID) {
                case 2: {
                    String classID = packet.getUuid();
                    String normClassID = classID.toLowerCase(Locale.US);
                    Map classIDMap = (Map)conversation.getOption("clsidmap");
                    String className = null;
                    if (classIDMap != null) {
                        className = (String)classIDMap.get(normClassID);
                    }
                    if (className == null && (className = (String)conversation.getOption("defaultclassname")) == null) {
                        String messageIndex = "Engine.041.ex.fmt";
                        String messagePattern = RB.getStringResource(messageIndex, locale);
                        String message = Message.format((String)messagePattern, (Object)classID);
                        throw new INV_OBJREF(message);
                    }
                    org.omg.CORBA.Object obj = this.newLocalObject(conversation, className);
                    int objectID = this._marshaller.objectToObjectID(conversation, obj);
                    int replyID = packet.getReplyId();
                    reply = new OutboundPacket();
                    reply.setType(0);
                    reply.setObjectId(objectID);
                    reply.setMethodId(2);
                    reply.setUuid(classID);
                    reply.setReplyId(replyID);
                    reply.setRC(OutboundPacket.zero);
                    break;
                }
                case 16: {
                    String classID = packet.getUuid();
                    ByteBuffer mapBuf = packet.getMapBuf();
                    ByteBuffer dataBuf = packet.getDataBuf();
                    String className = this._marshaller.unmarshalStringNT(conversation, mapBuf, dataBuf);
                    org.omg.CORBA.Object obj = this.newLocalObject(conversation, className);
                    int objectID = this._marshaller.objectToObjectID(conversation, obj);
                    int replyID = packet.getReplyId();
                    reply = new OutboundPacket();
                    reply.setType(0);
                    reply.setObjectId(objectID);
                    reply.setMethodId(16);
                    reply.setUuid(classID);
                    reply.setReplyId(replyID);
                    reply.setRC(OutboundPacket.zero);
                    break;
                }
                case 9: {
                    int objectID = packet.getObjectId() & Integer.MAX_VALUE;
                    int myID = objectID | Integer.MIN_VALUE;
                    ObjectImpl obj = this._marshaller.objectIDToObject(conversation, myID);
                    String iid = packet.getUuid();
                    boolean isa = obj._is_a(iid);
                    int rc = isa ? 0 : 1;
                    Integer RC = new Integer(rc);
                    int replyID = packet.getReplyId();
                    reply = new OutboundPacket();
                    reply.setType(0);
                    reply.setObjectId(objectID);
                    reply.setMethodId(9);
                    reply.setUuid(iid);
                    reply.setReplyId(replyID);
                    reply.setRC(RC);
                    break;
                }
                case 11: {
                    int objectID = packet.getObjectId() & Integer.MAX_VALUE;
                    int myID = objectID | Integer.MIN_VALUE;
                    ObjectImpl obj = this._marshaller.objectIDToObject(conversation, myID);
                    String[] iids = obj._ids();
                    String iid = null;
                    for (int i = 0; i < iids.length; ++i) {
                        if (!iids[i].startsWith("DCE:")) continue;
                        iid = Engine.reposIDtoIID(iids[i]);
                        break;
                    }
                    if (iid == null) {
                        String messageIndex = "Engine.040.ex.txt";
                        String message = RB.getStringResource(messageIndex, locale);
                        throw new UNKNOWN(message);
                    }
                    int replyID = packet.getReplyId();
                    reply = new OutboundPacket();
                    reply.setType(0);
                    reply.setObjectId(objectID);
                    reply.setMethodId(11);
                    reply.setUuid(iid);
                    reply.setReplyId(replyID);
                    reply.setRC(OutboundPacket.zero);
                    break;
                }
                case 10: {
                    int objectID = packet.getObjectId() & Integer.MAX_VALUE;
                    int myID = objectID | Integer.MIN_VALUE;
                    ObjectImpl target = this._marshaller.objectIDToObject(conversation, myID);
                    String operation = "SupportedConnectionPoints";
                    Class<ConnectionPointContainer_1_1Operations> clazz = ConnectionPointContainer_1_1Operations.class;
                    ServantObject servantObject = null;
                    CP_ID[] eventArray = null;
                    try {
                        servantObject = target._servant_preinvoke(operation, clazz);
                        ConnectionPointContainer_1_1Operations cpc = (ConnectionPointContainer_1_1Operations)servantObject.servant;
                        eventArray = cpc.SupportedConnectionPoints();
                    }
                    finally {
                        if (servantObject != null) {
                            target._servant_postinvoke(servantObject);
                        }
                    }
                    String iid = packet.getUuid();
                    int replyID = packet.getReplyId();
                    reply = new OutboundPacket();
                    reply.setType(0);
                    reply.setObjectId(objectID);
                    reply.setMethodId(10);
                    reply.setReplyId(replyID);
                    reply.setUuid(iid);
                    reply.setRC(OutboundPacket.zero);
                    int count = eventArray != null ? eventArray.length : 0;
                    AnyImpl[] parmArr = new AnyImpl[count];
                    ORBImpl orb = conversation.getORB();
                    for (int i = 0; i < count; ++i) {
                        String eventID = CP_IDConverter.cp_idToString(eventArray[i]);
                        parmArr[i] = (AnyImpl)orb.create_any();
                        parmArr[i].insert_string(eventID);
                    }
                    reply.setParameterArray(parmArr);
                    break;
                }
                case 6: {
                    int objectID = packet.getObjectId() & Integer.MAX_VALUE;
                    int myID = objectID | Integer.MIN_VALUE;
                    ObjectImpl target = this._marshaller.objectIDToObject(conversation, myID);
                    String iid = packet.getUuid();
                    CP_ID cpid = CP_IDConverter.stringToCP_ID(iid);
                    Class clazz = ConnectionPointContainerOperations.class;
                    ServantObject servantObject = null;
                    ObjectImpl cp = null;
                    try {
                        servantObject = target._servant_preinvoke(cpcOperation, clazz);
                        ConnectionPointContainerOperations cpcServant = (ConnectionPointContainerOperations)servantObject.servant;
                        if (cpcServant != null) {
                            ConnectionPointHolder cpHolder = new ConnectionPointHolder();
                            cpcServant.FindConnectionPoint(cpid, cpHolder);
                            cp = (ObjectImpl)cpHolder.value;
                        }
                    }
                    finally {
                        if (servantObject != null) {
                            target._servant_postinvoke(servantObject);
                        }
                    }
                    if (cp != null) {
                        clazz = ConnectionPointOperations.class;
                        try {
                            servantObject = cp._servant_preinvoke(cpAdvise, clazz);
                            ConnectionPointOperations cpServant = (ConnectionPointOperations)servantObject.servant;
                            if (cpServant != null) {
                                ListenerDelegateImpl listenerDelegate = new ListenerDelegateImpl(conversation, cpid, objectID);
                                GenericObject listener = new GenericObject();
                                listener._set_delegate(listenerDelegate);
                                IntHolder handleHolder = new IntHolder();
                                cpServant.Advise((org.omg.CORBA.Object)listener, handleHolder);
                                listenerDelegate.setHandle(handleHolder.value);
                                DelegateLocal cpDelegate = (DelegateLocal)cp._get_delegate();
                                cpDelegate.pushListener((org.omg.CORBA.Object)listener);
                            }
                        }
                        finally {
                            if (servantObject != null) {
                                cp._servant_postinvoke(servantObject);
                            }
                        }
                    }
                    int replyID = packet.getReplyId();
                    reply = new OutboundPacket();
                    reply.setType(0);
                    reply.setObjectId(objectID);
                    reply.setMethodId(6);
                    reply.setReplyId(replyID);
                    reply.setUuid(iid);
                    reply.setRC(OutboundPacket.zero);
                    break;
                }
                case 7: {
                    int objectID = packet.getObjectId() & Integer.MAX_VALUE;
                    int myID = objectID | Integer.MIN_VALUE;
                    ObjectImpl target = this._marshaller.objectIDToObject(conversation, myID);
                    String iid = packet.getUuid();
                    CP_ID cpid = CP_IDConverter.stringToCP_ID(iid);
                    Class clazz = ConnectionPointContainerOperations.class;
                    ServantObject servantObject = null;
                    ObjectImpl cp = null;
                    try {
                        servantObject = target._servant_preinvoke(cpcOperation, clazz);
                        ConnectionPointContainerOperations cpcServant = (ConnectionPointContainerOperations)servantObject.servant;
                        if (cpcServant != null) {
                            ConnectionPointHolder cpHolder = new ConnectionPointHolder();
                            cpcServant.FindConnectionPoint(cpid, cpHolder);
                            cp = (ObjectImpl)cpHolder.value;
                        }
                    }
                    finally {
                        if (servantObject != null) {
                            target._servant_postinvoke(servantObject);
                        }
                    }
                    if (cp != null) {
                        clazz = ConnectionPointOperations.class;
                        try {
                            servantObject = cp._servant_preinvoke(cpUnadvise, clazz);
                            ConnectionPointOperations cpServant = (ConnectionPointOperations)servantObject.servant;
                            if (cpServant != null) {
                                DelegateLocal cpDelegate = (DelegateLocal)cp._get_delegate();
                                org.omg.CORBA.Object _listener = cpDelegate.popListener();
                                ObjectImpl listener = (ObjectImpl)_listener;
                                ListenerDelegateImpl listenerDelegate = (ListenerDelegateImpl)listener._get_delegate();
                                int handle = listenerDelegate.getHandle();
                                cpServant.Unadvise(handle);
                            }
                        }
                        finally {
                            if (servantObject != null) {
                                cp._servant_postinvoke(servantObject);
                            }
                        }
                    }
                    int replyID = packet.getReplyId();
                    reply = new OutboundPacket();
                    reply.setType(0);
                    reply.setObjectId(objectID);
                    reply.setMethodId(7);
                    reply.setReplyId(replyID);
                    reply.setUuid(iid);
                    reply.setRC(OutboundPacket.zero);
                    break;
                }
                default: {
                    throw new NO_IMPLEMENT();
                }
            }
            this.sendPacket(conversation, reply);
        }
        catch (Throwable ex) {
            this.sendSystemError(conversation, packet, ex);
        }
    }

    protected void handleRequestByName(Conversation conversation, InboundPacket packet) {
        try {
            ObjectImpl target = this.getLocalObject(conversation, packet, true);
            ByteBuffer mapBuf = packet.getMapBuf();
            ByteBuffer dataBuf = packet.getDataBuf();
            String signature = this._marshaller.unmarshalStringNT(conversation, mapBuf, dataBuf);
            ServerRequestImpl serverRequest = new ServerRequestImpl(conversation, target, signature, packet);
            ByteBuffer mapBufCopy = BufferManager.asReadOnlyBuffer(mapBuf);
            ByteBuffer payBufCopy = BufferManager.asReadOnlyBuffer(dataBuf);
            serverRequest.setMapBuf(mapBufCopy);
            serverRequest.setPayBuf(payBufCopy);
            serverRequest.setOneWay(false);
            serverRequest.run();
        }
        catch (Throwable t) {
            this.sendSystemError(conversation, packet, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleEventByName(Conversation conversation, InboundPacket packet) {
        DelegateImpl delegate;
        int sourceID = packet.getObjectId() & Integer.MAX_VALUE;
        String eventID = packet.getUuid();
        eventID = eventID.toLowerCase(Locale.US);
        ObjectImpl source = this._marshaller.objectIDToObject(conversation, sourceID);
        DelegateImpl delegateImpl = delegate = (DelegateImpl)source._get_delegate();
        synchronized (delegateImpl) {
            Map listenerTable = delegate.getListenerTable();
            if (listenerTable == null) {
                return;
            }
            Set listenerSet = (Set)listenerTable.get(eventID);
            if (listenerSet == null) {
                return;
            }
            ByteBuffer mapBuf = packet.getMapBuf();
            ByteBuffer dataBuf = packet.getDataBuf();
            String signature = this._marshaller.unmarshalStringNT(conversation, mapBuf, dataBuf);
            for (ObjectImpl listener : listenerSet) {
                ServerRequestImpl serverRequest = new ServerRequestImpl(conversation, listener, signature, packet);
                ByteBuffer mapBufCopy = BufferManager.asReadOnlyBuffer(mapBuf);
                ByteBuffer payBufCopy = BufferManager.asReadOnlyBuffer(dataBuf);
                serverRequest.setMapBuf(mapBufCopy);
                serverRequest.setPayBuf(payBufCopy);
                serverRequest.setOneWay(true);
                WorkInterface work = this.wrapSecureWork(conversation, serverRequest);
                this.dispatchWorkForLocalObject(conversation, listener, work);
            }
        }
    }

    protected void handleRequest(Conversation conversation, InboundPacket packet) {
        int objectID = packet.getObjectId() & Integer.MAX_VALUE;
        int methodID = packet.getMethodId();
        int replyID = packet.getReplyId();
        String iid = packet.getUuid();
        OutboundPacket reply = new OutboundPacket();
        reply.setType(2);
        reply.setObjectId(objectID);
        reply.setMethodId(methodID);
        reply.setUuid(iid);
        reply.setReplyId(replyID);
        try {
            ObjectImpl obj = this.getLocalObject(conversation, packet, true);
            if (methodID == 0) {
                boolean isa = obj._is_a(iid);
                int rc = isa ? 0 : 1;
                Integer RC = new Integer(rc);
                reply.setRC(RC);
            } else {
                reply.setRC(OutboundPacket.zero);
            }
        }
        catch (Throwable e) {
            this.sendSystemError(conversation, packet, e);
            return;
        }
        this.sendPacket(conversation, reply);
    }

    protected List handleModifier(Conversation conversation, InboundPacket packet) {
        int modifierBts = packet.getMethodId();
        if (modifierBts == 0) {
            return null;
        }
        ArrayList<Packet.Modifier> modifierLst = new ArrayList<Packet.Modifier>(2);
        if ((modifierBts & Integer.MIN_VALUE) != 0) {
            ByteBuffer mapBuf = packet.getMapBuf();
            ByteBuffer dataBuf = packet.getDataBuf();
            String correlator = this._marshaller.unmarshalStringNT(conversation, mapBuf, dataBuf);
            Packet.CorrelatorModifier modifier = new Packet.CorrelatorModifier(correlator);
            modifierLst.add(modifier);
        }
        if ((modifierBts & 0x40000000) != 0) {
            Packet.Modifier modifier = new Packet.Modifier(0x40000000);
            modifierLst.add(modifier);
        }
        List roModifierLst = Collections.unmodifiableList(modifierLst);
        return roModifierLst;
    }

    protected void sendSystemError(Conversation conversation, InboundPacket request, Throwable ex) {
        int minorCode;
        int errorRC = 0;
        errorRC = ex instanceof NO_MEMORY ? 2 : (ex instanceof NO_IMPLEMENT ? 3 : (ex instanceof BAD_OPERATION ? 4 : (ex instanceof BAD_PARAM ? 5 : (ex instanceof NO_PERMISSION ? ((minorCode = ((NO_PERMISSION)ex).minor) == 3 ? 9 : (minorCode == 4 ? 10 : 6)) : (ex instanceof OBJECT_NOT_EXIST ? 8 : 1)))));
        String errorXML = Engine.formatException(ex);
        String errorUUID = defaultClassID;
        this.sendError(conversation, request, errorRC, errorXML, errorUUID);
    }

    protected void sendUserError(Conversation conversation, InboundPacket request, AnyImpl ex) {
        InputStream is = ex.create_input_stream();
        String reposID = is.read_string();
        String errorUUID = Engine.reposIDtoIID(reposID);
        String msg = is.read_string();
        String errorXML = msg != null && msg.startsWith(xmlTag) ? msg : Engine.formatException(new Throwable(msg));
        int errorRC = -1;
        this.sendError(conversation, request, errorRC, errorXML, errorUUID);
    }

    protected void sendError(Conversation conversation, InboundPacket request, int errorRC, String errorXML, String errorUUID) {
        int errorID = 0;
        String errorModule = "";
        int objectID = request.getObjectId() & Integer.MAX_VALUE;
        int replyID = request.getReplyId();
        OutboundPacket reply = new OutboundPacket();
        reply.setType(0);
        reply.setMethodId(0);
        reply.setObjectId(objectID);
        reply.setReplyId(replyID);
        Integer RC = new Integer(errorRC);
        reply.setRC(RC);
        AnyImpl[] parmArr = new AnyImpl[4];
        ORBImpl orb = conversation.getORB();
        parmArr[0] = (AnyImpl)orb.create_any();
        parmArr[0].insert_string(errorXML);
        parmArr[1] = (AnyImpl)orb.create_any();
        parmArr[1].insert_long(errorID);
        parmArr[2] = (AnyImpl)orb.create_any();
        parmArr[2].insert_string(errorUUID);
        parmArr[3] = (AnyImpl)orb.create_any();
        parmArr[3].insert_string(errorModule);
        reply.setParameterArray(parmArr);
        this.sendPacket(conversation, reply);
    }

    protected String getSystemProperty(Conversation conversation, final String key, final String defaultValue) {
        PrivilegedAction action = new PrivilegedAction(){

            public Object run() {
                String value = defaultValue == null ? System.getProperty(key) : System.getProperty(key, defaultValue);
                return value;
            }
        };
        String value = (String)AccessController.doPrivileged(action);
        if (value != null && this.isLoggable(conversation, fineRecord)) {
            String msg = "Value for system property " + key + " is " + value;
            Engine.log(conversation, fineRecord, msg, null);
        }
        return value;
    }

    protected static String formatException(Throwable ex) {
        Throwable nextEx;
        int l = xmlTag.length() + exceptionsOpenTag.length() + exceptionsCloseTag.length();
        for (nextEx = ex; nextEx != null; nextEx = nextEx.getCause()) {
            l += exceptionOpenTag.length() + exceptionCloseTag.length();
            String exMessage = nextEx.getMessage();
            if (exMessage == null) continue;
            l += messageOpenTag.length() + exMessage.length() * 2 + messageCloseTag.length();
        }
        StringBuffer exBuf = new StringBuffer(l);
        exBuf.append(xmlTag).append(exceptionsOpenTag);
        for (nextEx = ex; nextEx != null; nextEx = nextEx.getCause()) {
            exBuf.append(exceptionOpenTag);
            String exMessage = nextEx.getMessage();
            if (exMessage != null) {
                String content = Strings.quoteForXMLComplete((String)exMessage);
                exBuf.append(messageOpenTag).append(content).append(messageCloseTag);
            }
            exBuf.append(exceptionCloseTag);
        }
        exBuf.append(exceptionsCloseTag);
        String errorXML = exBuf.toString();
        return errorXML;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logOutboundPacket(Conversation conversation, OutboundPacket packet) {
        Conversation conversation2 = conversation;
        synchronized (conversation2) {
            if (this.isLoggable(conversation, finerRecord)) {
                ORBImpl orb;
                AnyImpl[] parms;
                OutboundPacket tempPacket = null;
                if (this.isInternalRequest(conversation, packet, 1) || this.isInternalRequest(conversation, packet, 20)) {
                    tempPacket = (OutboundPacket)packet.clone();
                    parms = tempPacket.getParameterArray();
                    orb = conversation.getORB();
                    parms[1] = (AnyImpl)orb.create_any();
                    parms[1].insert_string("xxxxxxxx");
                    this._marshaller.calculatePacketSize(conversation, tempPacket);
                    int size = tempPacket.getSize();
                    BufferManager bufferManager = conversation.getBufferManager();
                    ByteBuffer buf = bufferManager.allocate(size);
                    this._marshaller.marshalPacket(conversation, tempPacket, buf);
                    ByteBuffer roBuf = BufferManager.asReadOnlyBuffer(buf);
                    tempPacket.setMarshalledPacket(roBuf);
                } else if (this.isInternalRequest(conversation, packet, 17)) {
                    tempPacket = (OutboundPacket)packet.clone();
                    parms = tempPacket.getParameterArray();
                    orb = conversation.getORB();
                    parms[0] = (AnyImpl)orb.create_any();
                    byte[] blot = this._marshaller.stringToBytes(conversation, "xxxxxxxx");
                    parms[1].insertIOM(4, blot);
                    this._marshaller.calculatePacketSize(conversation, tempPacket);
                    int size = tempPacket.getSize();
                    BufferManager bufferManager = conversation.getBufferManager();
                    ByteBuffer buf = bufferManager.allocate(size);
                    this._marshaller.marshalPacket(conversation, tempPacket, buf);
                    ByteBuffer roBuf = BufferManager.asReadOnlyBuffer(buf);
                    tempPacket.setMarshalledPacket(roBuf);
                } else {
                    tempPacket = packet;
                }
                String p = this.packetToString(conversation, tempPacket);
                int pL = p.length();
                int l = pL + 26;
                StringWriter sw = new StringWriter(l);
                PrintWriter pw = new PrintWriter(sw);
                pw.println("outbound packet");
                pw.println(p);
                pw.flush();
                StringBuffer sb = sw.getBuffer();
                String msg = sb.toString();
                Engine.log(conversation, finerRecord, msg, null);
                if (this.isLoggable(conversation, finestRecord)) {
                    String title = "outbound data";
                    ByteBuffer tempBuffer = tempPacket.getMarshalledPacket();
                    this.logData(conversation, tempBuffer, title);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logInboundPacket(Conversation conversation, InboundPacket packet) {
        Conversation conversation2 = conversation;
        synchronized (conversation2) {
            if (this.isLoggable(conversation, finerRecord)) {
                if (this.isLoggable(conversation, finestRecord)) {
                    ByteBuffer headerBuf = packet.getHeaderBuf();
                    ByteBuffer mapBuf = packet.getMapBuf();
                    ByteBuffer dataBuf = packet.getDataBuf();
                    String h = this.packetToBytes(conversation, headerBuf);
                    String m = null;
                    String d = null;
                    int l = h.length() + 20;
                    if (mapBuf != null) {
                        m = this.packetToBytes(conversation, mapBuf);
                        l += m.length() + 20;
                    }
                    if (dataBuf != null) {
                        d = this.packetToBytes(conversation, dataBuf);
                        l += d.length() + 20;
                    }
                    StringWriter sw = new StringWriter(l);
                    PrintWriter pw = new PrintWriter(sw);
                    pw.println("inbound header");
                    pw.println(h);
                    if (mapBuf != null) {
                        pw.println("inbound maps");
                        if (this.isInternalReply(conversation, packet, 13) || this.isInternalReply(conversation, packet, 17)) {
                            pw.println("security-related maps omitted");
                        } else {
                            pw.println(m);
                        }
                    }
                    if (dataBuf != null) {
                        pw.println("inbound data");
                        if (this.isInternalReply(conversation, packet, 13) || this.isInternalReply(conversation, packet, 17)) {
                            pw.println("security-related data omitted");
                        } else {
                            pw.println(d);
                        }
                    }
                    StringBuffer sb = sw.getBuffer();
                    String msg = sb.toString();
                    Engine.log(conversation, finestRecord, msg, null);
                }
                String p = this.packetToString(conversation, packet);
                int l = p.length() + 27;
                StringWriter sw = new StringWriter(l);
                PrintWriter pw = new PrintWriter(sw);
                pw.println("inbound packet");
                pw.println(p);
                StringBuffer sb = sw.getBuffer();
                String msg = sb.toString();
                Engine.log(conversation, finerRecord, msg, null);
            }
        }
    }

    protected String packetToString(Conversation conversation, Packet packet) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.print("Type:     ");
        int type = packet.getType();
        String typeString = Packet.typeToString(type);
        pw.println(typeString);
        pw.print("ClientId: ");
        int packetID = packet.getClientId();
        pw.println(packetID);
        pw.print("ObjectId: ");
        int objectID = packet.getObjectId();
        pw.println(objectID);
        pw.print("MethodId: ");
        int methodID = packet.getMethodId();
        if (type == 0) {
            String method = Engine.methodIDToString(methodID);
            pw.println(method);
        } else if (type == 6) {
            String modifierList = Packet.Modifier.modifierPatternToString(methodID);
            pw.println(modifierList);
        } else {
            pw.println(methodID);
        }
        pw.print("ReplyId:  ");
        int replyID = packet.getReplyId();
        pw.println(replyID);
        pw.print("UUID:     ");
        String uuid = packet.getUuid();
        pw.print(uuid);
        int mapCount = packet.getMapCount();
        if (mapCount > 0) {
            ByteBuffer mapBuf = null;
            ByteBuffer dataBuf = null;
            if (!packet.isInbound()) {
                OutboundPacket ob = (OutboundPacket)packet;
                ByteBuffer buf = ob.getMarshalledPacket();
                mapBuf = BufferManager.asReadOnlyBuffer(buf);
                mapBuf.position(64);
                int mapEnd = 64 + mapCount * 4;
                mapBuf.limit(mapEnd);
                dataBuf = BufferManager.asReadOnlyBuffer(buf);
                dataBuf.position(mapEnd);
            } else {
                InboundPacket ib = (InboundPacket)packet;
                mapBuf = BufferManager.asReadOnlyBuffer(ib.getMapBuf());
                dataBuf = BufferManager.asReadOnlyBuffer(ib.getDataBuf());
            }
            if (this.isInternalReply(conversation, packet, 13) || this.isInternalReply(conversation, packet, 17)) {
                pw.println();
                pw.print("security-related parameters omitted");
            } else {
                this._marshaller.printParameters(conversation, mapBuf, dataBuf, pw);
            }
        }
        pw.flush();
        StringBuffer sb = sw.getBuffer();
        String s = sb.toString();
        return s;
    }

    protected void logData(Conversation conversation, ByteBuffer data, String title) {
        if (!this.isLoggable(conversation, finestRecord)) {
            return;
        }
        String dump = this.packetToBytes(conversation, data);
        int dumpL = dump.length() + title.length() + 4;
        StringWriter dumpSW = new StringWriter(dumpL);
        PrintWriter dumpPW = new PrintWriter(dumpSW);
        dumpPW.println(title);
        dumpPW.println(dump);
        dumpPW.flush();
        StringBuffer dumpSB = dumpSW.getBuffer();
        String dumpMSG = dumpSB.toString();
        Engine.log(conversation, finestRecord, dumpMSG, null);
    }

    protected String packetToBytes(Conversation conversation, ByteBuffer packet) {
        int recSize;
        ByteBuffer buf = BufferManager.asReadOnlyBuffer(packet);
        int packetSize = buf.remaining();
        StringWriter sw = new StringWriter(packetSize * 4);
        PrintWriter pw = new PrintWriter(sw);
        LinkedList<byte[]> recList = new LinkedList<byte[]>();
        do {
            recSize = Math.min(packetSize, 16);
            byte[] rec = new byte[recSize];
            buf.get(rec);
            recList.add(rec);
        } while ((long)(packetSize -= recSize) > 0L);
        StringBuffer sb = sw.getBuffer();
        int i = 0;
        Iterator recItr = recList.iterator();
        while (recItr.hasNext()) {
            if (i > 0) {
                pw.println();
            }
            pw.flush();
            Engine.hexPrint(i * 16, 8, sb);
            pw.print(": ");
            byte[] rec = (byte[])recItr.next();
            String recString = Engine.printBuffer(rec);
            pw.print(recString);
            ++i;
        }
        pw.flush();
        String s = sb.toString();
        return s;
    }

    protected boolean isLoggable(Conversation conversation, LogRecord record) {
        org.apache.logging.log4j.Level level = Engine.logRecordToLevel(record);
        boolean result = _logger.isEnabled(level);
        return result;
    }

    protected static void log(Conversation conversation, LogRecord levelRec, String msg, Throwable thrown) {
        org.apache.logging.log4j.Level level = Engine.logRecordToLevel(levelRec);
        if (!_logger.isEnabled(level)) {
            return;
        }
        String externalID = conversation.getExternalID();
        String m = externalID + msg;
        if (thrown != null) {
            _logger.log(level, m, thrown);
        } else {
            _logger.log(level, m);
        }
    }

    private static String printBuffer(byte[] byteArray) {
        int i;
        int length = byteArray.length;
        StringBuffer buffer = new StringBuffer(length * 4);
        StringBuffer textLine = new StringBuffer(Math.max(length, 16));
        for (i = 0; i < length; ++i) {
            int b = byteArray[i];
            if (b < 0) {
                b += 256;
            }
            Engine.hexPrint(b, 2, buffer);
            char text = b < 32 || b > 127 ? (char)'.' : (char)b;
            textLine.append(text);
        }
        for (i = length; i < 16; ++i) {
            buffer.append("  ");
            textLine.append(" ");
        }
        buffer.append("[").append(textLine).append("]");
        String s = buffer.toString();
        return s;
    }

    private static void hexPrint(int value, int padding, StringBuffer buffer) {
        String hexString = "0123456789ABCDEF";
        for (int i = padding - 1; i >= 0; --i) {
            buffer.append(hexString.charAt(value >> i * 4 & 0xF));
        }
    }

    protected abstract boolean flowSendReqs(Conversation var1);

    protected static void readFully(Conversation conversation, ByteBuffer buf) throws IOException {
        SocketChannel channel = conversation.getChannel();
        int maxReadBuf = _maxReadBuf > 0 ? _maxReadBuf : Integer.MAX_VALUE;
        int bytesRequested = buf.remaining();
        int reads = bytesRequested / maxReadBuf + (bytesRequested % maxReadBuf > 0 ? 1 : 0);
        for (int i = 0; i < reads; ++i) {
            if (reads > 1) {
                int pos = buf.position();
                int bytesToRead = (bytesRequested - pos) / (reads - i);
                int limit = pos + bytesToRead;
                buf.limit(limit);
            }
            do {
                if (channel.read(buf) >= 0) continue;
                Locale locale = conversation.getLocale();
                String messageIndex = "Engine.021.ex.txt";
                String message = RB.getStringResource(messageIndex, locale);
                throw new IOException(message);
            } while (buf.remaining() > 0);
        }
        buf.rewind();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean writeBuffer(Conversation conversation, ByteBuffer buf) throws IOException {
        SocketChannel channel = conversation.getChannel();
        int maxWriteBuf = _maxReadBuf > 0 ? _maxReadBuf : Integer.MAX_VALUE;
        int originalLimit = buf.limit();
        int bytesRequested = buf.remaining();
        int writes = bytesRequested / maxWriteBuf + (bytesRequested % maxWriteBuf > 0 ? 1 : 0);
        for (int i = 0; i < writes; ++i) {
            int pos = buf.position();
            int bytesToWrite = (originalLimit - pos) / (writes - i);
            int limit = pos + bytesToWrite;
            buf.limit(limit);
            int bytesWritten = 0;
            try {
                bytesWritten = channel.write(buf);
            }
            finally {
                buf.limit(originalLimit);
            }
            if (bytesWritten >= bytesToWrite) continue;
            return false;
        }
        return true;
    }

    protected static String reposIDtoIID(String reposID) {
        if (reposID == null || reposID.length() < 40) {
            return reposID;
        }
        String iid = reposID.substring(4, 40);
        return iid;
    }

    private static String methodIDToString(int methodID) {
        switch (methodID) {
            case 0: {
                return "ERROR";
            }
            case 1: {
                return "USERPASS";
            }
            case 2: {
                return "NEWOBJECT";
            }
            case 3: {
                return "FREEOBJECT";
            }
            case 4: {
                return "CLOSE";
            }
            case 5: {
                return "UUIDFROMOBJECTID";
            }
            case 6: {
                return "ADVISE";
            }
            case 7: {
                return "UNADVISE";
            }
            case 8: {
                return "OBJECTDESTRUCTOR";
            }
            case 9: {
                return "INTERFACEINOBJECT";
            }
            case 10: {
                return "EVENTSFROMOBJECTID";
            }
            case 11: {
                return "DEFAULTINTERFACE";
            }
            case 12: {
                return "SERVERTRANSCODE";
            }
            case 13: {
                return "GENPASSWORD";
            }
            case 14: {
                return "USERSASPEER";
            }
            case 15: {
                return "DOWNLEVEL";
            }
            case 16: {
                return "NEWOBJECTBYNAME";
            }
            case 17: {
                return "AUTHENTICATE";
            }
            case 18: {
                return "REDIRECTED";
            }
            case 19: {
                return "RECONOBJECT";
            }
            case 20: {
                return "USERPASS2";
            }
        }
        return "WHO_KNOWS?";
    }

    protected static String encrLevelToString(byte encrLevel) {
        switch (encrLevel) {
            case 2: {
                return "PE_ENCR_ALL";
            }
            case 1: {
                return "PE_ENCR_AUTH";
            }
            case 0: {
                return "PE_ENCR_NONE";
            }
        }
        return "UNKNOWN";
    }

    protected static String redirStatusToString(Conversation conversation) {
        return conversation.isRedirected() ? "PE_BEEN_REDIRECTED" : "PE_REDIRECT_ME";
    }

    protected static String xcodePrefToString(Conversation conversation) {
        byte xcodePref = conversation.getTranscodingPreference();
        return xcodePref == 0 ? "PE_USER" : "PE_SERVER";
    }

    protected static String reqsStatusToString(byte reqsStatus) {
        String st = null;
        switch (reqsStatus) {
            case 0: {
                st = "PE_REQS_OK";
                break;
            }
            case 1: {
                st = "PE_REQS_FAILED";
                break;
            }
            case 7: {
                st = "PE_REQS_LBFAILURE";
                break;
            }
            case 2: {
                st = "PE_REQS_LEVEL";
                break;
            }
            case 4: {
                st = "PE_REQS_REDIRECT";
                break;
            }
            case 6: {
                st = "PE_REQS_REDIRECT_2";
                break;
            }
            case 3: {
                st = "PE_REQS_REQS";
                break;
            }
            case 10: {
                st = "PE_REQS_REQS_2";
                break;
            }
            case 8: {
                st = "PE_REQS_TIMEOUT";
                break;
            }
            case 5: {
                st = "PE_REQS_VERSION";
                break;
            }
            case 9: {
                st = "PE_REQS_VERSION_2";
                break;
            }
            case 11: {
                st = "PE_REQS_ERROR_PKT";
                break;
            }
            default: {
                st = "UNKNOWN";
            }
        }
        return st;
    }

    protected static org.apache.logging.log4j.Level logRecordToLevel(LogRecord levelRec) {
        org.apache.logging.log4j.Level level = null;
        if (finestRecord.equals(levelRec) || finerRecord.equals(levelRec)) {
            level = org.apache.logging.log4j.Level.TRACE;
        } else if (fineRecord.equals(levelRec)) {
            level = org.apache.logging.log4j.Level.DEBUG;
        } else if (warningRecord.equals(levelRec)) {
            level = org.apache.logging.log4j.Level.WARN;
        } else if (severeRecord.equals(levelRec)) {
            level = org.apache.logging.log4j.Level.FATAL;
        } else if (infoRecord.equals(levelRec)) {
            level = org.apache.logging.log4j.Level.INFO;
        } else {
            throw new INTERNAL("Unsupported log level.");
        }
        return level;
    }

    private static void traceWrites(Conversation conversation, String msg) {
        String id = conversation.getExternalID();
        _writeLogger.trace(id + msg);
    }

    protected static InetSocketAddress createSocketAddress(Conversation conversation, String host, int port) {
        try {
            if (port < 1) {
                throw new IllegalArgumentException("port out of range:" + port);
            }
            return new InetSocketAddress(host, port);
        }
        catch (IllegalArgumentException iae) {
            Locale locale;
            String message = null;
            if (host == null) {
                locale = conversation.getLocale();
                String messageIndex = "Engine.051.ex.txt";
                message = RB.getStringResource(messageIndex, locale);
            } else if (port < 1 || port > 65535) {
                locale = conversation.getLocale();
                String serverEntryPoint = host + ":" + port;
                String messageIndex = "Engine.019.ex.fmt";
                String messagePattern = RB.getStringResource(messageIndex, locale);
                message = Message.format((String)messagePattern, (Object)serverEntryPoint);
            } else {
                iae.getMessage();
            }
            COMM_FAILURE comm_failure = new COMM_FAILURE(message, 1, CompletionStatus.COMPLETED_NO);
            comm_failure.initCause((Throwable)iae);
            throw comm_failure;
        }
    }

    protected static String socketAddressToString(InetSocketAddress addr) {
        return addr.getHostName() + ":" + addr.getPort();
    }

    protected InetSocketAddress urlToSocketAddress(Conversation conversation, URL url) {
        int port;
        String host = url.getHost();
        if (host == null) {
            host = defaultHost;
            Engine.log(conversation, warningRecord, "Proxy URL does not contain host. Using default. " + url, null);
        }
        if ((port = url.getPort()) < 0 && (port = url.getDefaultPort()) < 0) {
            Locale locale = conversation.getLocale();
            String h = conversation.getHost();
            int p = conversation.getPort();
            String tunnelEnd = h + ":" + p;
            String protocol = url.getProtocol();
            String messageIndex = "Engine.062.ex.fmt";
            String messagePattern = RB.getStringResource(messageIndex, locale);
            String message = Message.format((String)messagePattern, (Object)tunnelEnd, (Object)protocol);
            throw new BAD_PARAM(message);
        }
        return new InetSocketAddress(host, port);
    }

    protected static boolean isSecureUrl(URL url) {
        String protocol = url.getProtocol();
        return protocol != null && "https".equals(protocol.toLowerCase(Locale.US));
    }

    static {
        _trustedPeerPermission = new ORBPermission("brg.trustedPeer");
        _trustedPeerPermissionArr = new Permission[]{new PropertyPermission("user.name", "read"), new RuntimePermission("getenv.USERDOMAIN")};
        _trustedPeerPermissionCombiner = new PermissionCombiner(_trustedPeerPermissionArr);
        _logger = LogManager.getLogger(Engine.class);
        _writeLogger = LogManager.getLogger((String)(Engine.class.getName() + ".writes"));
        _commaDelim = Pattern.compile("([\\s]*,[\\s]*)+");
        _semiDelim = Pattern.compile("([\\s]*;[\\s]*)+");
        PrivilegedAction action = new PrivilegedAction(){

            public Object run() {
                String s = System.getProperty("com.sas.iom.orb.brg.maxReadBuf");
                return s;
            }
        };
        try {
            String maxReadBufS = (String)AccessController.doPrivileged(action);
            if (maxReadBufS == null) {
                _maxReadBuf = 0x100000;
            } else {
                int mult = 1;
                String mrb = maxReadBufS.toLowerCase(Locale.US);
                if (mrb.endsWith("k")) {
                    mrb = mrb.substring(0, mrb.length() - 1);
                    mult = 1024;
                } else if (mrb.endsWith("m")) {
                    mrb = mrb.substring(0, mrb.length() - 1);
                    mult = 0x100000;
                } else if (mrb.endsWith("g")) {
                    mrb = mrb.substring(0, mrb.length() - 1);
                    mult = 0x40000000;
                }
                _maxReadBuf = Integer.parseInt(mrb) * mult;
            }
        }
        catch (Exception e) {
            _maxReadBuf = 0x100000;
        }
        _spclTable = new int[][]{{256, 32, 98, 99, 65}, {128, 128, 34, 35, 49}, {4224, 50, 33, 36, 50}, {513, 513, 49, 49, 513}, {514, 514, 50, 50, 514}};
    }

    @SASScope
    private static class SASVersionID {
        private static final String _defaultSVID = "";
        private static Method _getMth;
        private Object _delegate;

        private SASVersionID(Object delegate) {
            this._delegate = delegate;
        }

        public static SASVersionID create() {
            Object delegate = _getMth != null ? Engine.invokeReflectedMethod(SASVersionID._getMth, null, null) : null;
            SASVersionID sasVersionID = new SASVersionID(delegate);
            return sasVersionID;
        }

        public String toString() {
            String svid = this._delegate != null ? this._delegate.toString() : _defaultSVID;
            return svid;
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (that == null) {
                return false;
            }
            if (!this.getClass().equals(that.getClass())) {
                return false;
            }
            return this.toString().equals(that.toString());
        }

        public int hashCode() {
            int hc = this.getClass().hashCode();
            return hc ^= this.toString().hashCode();
        }

        static {
            try {
                Class<?> svidCls = Class.forName("com.sas.svid.SASVersionID");
                _getMth = svidCls.getMethod("create", null);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }

    @SASScope
    private static class PermissionCombiner
    implements DomainCombiner {
        private Permission[] _permissionArr;
        private int _permissionArrL;

        private PermissionCombiner(Permission[] permissionArr) {
            this._permissionArr = permissionArr;
            this._permissionArrL = permissionArr.length;
        }

        @Override
        public ProtectionDomain[] combine(ProtectionDomain[] currentDomainArr, ProtectionDomain[] assignedDomainArr) {
            int currentDomainArrL = currentDomainArr != null ? currentDomainArr.length : 0;
            int assignedDomainArrL = assignedDomainArr != null ? assignedDomainArr.length : 0;
            int combinedDomainArrL = currentDomainArrL + assignedDomainArrL;
            ProtectionDomain[] combinedDomainArr = new ProtectionDomain[combinedDomainArrL];
            ProtectionDomain[][] domainArrArr = new ProtectionDomain[][]{currentDomainArr, assignedDomainArr};
            int combinedDomainArrI = 0;
            for (int i = 0; i < domainArrArr.length; ++i) {
                ProtectionDomain[] domainArr = domainArrArr[i];
                if (domainArr == null) continue;
                for (int j = 0; j < domainArr.length; ++j) {
                    ProtectionDomain oldDomain = domainArr[j];
                    ProtectionDomain newDomain = this.hasPermissions(oldDomain) ? oldDomain : this.addPermissions(oldDomain);
                    combinedDomainArr[combinedDomainArrI++] = newDomain;
                }
            }
            return combinedDomainArr;
        }

        private boolean hasPermissions(ProtectionDomain domain) {
            for (int i = 0; i < this._permissionArrL; ++i) {
                Permission permission = this._permissionArr[i];
                if (domain.implies(permission)) continue;
                return false;
            }
            return true;
        }

        private ProtectionDomain addPermissions(ProtectionDomain oldDomain) {
            Permissions newPermissionCol = new Permissions();
            PermissionCollection oldPermissionCol = oldDomain.getPermissions();
            Enumeration<Permission> oldPermissionEnm = oldPermissionCol.elements();
            while (oldPermissionEnm.hasMoreElements()) {
                Permission oldPermission = oldPermissionEnm.nextElement();
                ((PermissionCollection)newPermissionCol).add(oldPermission);
            }
            for (int i = 0; i < this._permissionArrL; ++i) {
                Permission permission = this._permissionArr[i];
                if (((PermissionCollection)newPermissionCol).implies(permission)) continue;
                ((PermissionCollection)newPermissionCol).add(permission);
            }
            CodeSource oldCodeSource = oldDomain.getCodeSource();
            ProtectionDomain newDomain = new ProtectionDomain(oldCodeSource, newPermissionCol);
            return newDomain;
        }
    }
}

