/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iom.orb;

import com.sas.codepolicy.SASScope;
import com.sas.iom.orb.ResourceTracker;
import com.sas.iom.orb.ThreadPoolEvent;
import com.sas.iom.orb.ThreadPoolEventListenerInterface;
import com.sas.iom.orb.TrackedResourceInterface;
import com.sas.iom.orb.WorkException;
import com.sas.iom.orb.WorkInterface;
import com.sas.security.BaseSecuritySupport;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.WeakHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope
public class ThreadPool {
    private static final Logger _logger = LogManager.getLogger(ThreadPool.class);
    private static final String DEFAULT_THREAD_NAME_BASE = "ThreadPool ";
    private String _threadNameBase;
    private ThreadPoolImpl _impl;
    private TrackedResource _trackable;
    private Set<ThreadPoolEventListenerInterface> _listenerSet;

    public ThreadPool(String threadNameBase) {
        if (threadNameBase == null || threadNameBase.length() == 0) {
            threadNameBase = DEFAULT_THREAD_NAME_BASE;
        }
        this._threadNameBase = threadNameBase;
        this._trackable = new TrackedResource();
        ResourceTracker tracker = ResourceTracker.getInstance();
        tracker.trackResource(this._trackable);
        this._listenerSet = new HashSet<ThreadPoolEventListenerInterface>();
        _logger.debug("thread pool constructed, base name=" + this._threadNameBase + " id=" + this);
    }

    public ThreadPool() {
        this(DEFAULT_THREAD_NAME_BASE);
    }

    public void executeDaemon(WorkInterface work) throws WorkException {
        ThreadPoolImpl tp = this.getImpl();
        tp.executeAsynchronously(work);
    }

    public void executeStandard(WorkInterface work) throws WorkException {
        ThreadPoolImpl tp = this.getImpl();
        tp.executeStandard(work);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ThreadPoolEventListenerInterface listener) {
        if (_logger.isDebugEnabled()) {
            _logger.debug("adding listener=" + listener);
        }
        if (listener == null) {
            return;
        }
        Set<ThreadPoolEventListenerInterface> set = this._listenerSet;
        synchronized (set) {
            boolean result = this._listenerSet.add(listener);
            if (_logger.isDebugEnabled()) {
                _logger.debug("result of add=" + result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ThreadPoolEventListenerInterface listener) {
        if (_logger.isDebugEnabled()) {
            _logger.debug("removing listener=" + listener);
        }
        if (listener == null) {
            return;
        }
        Set<ThreadPoolEventListenerInterface> set = this._listenerSet;
        synchronized (set) {
            boolean result = this._listenerSet.remove(listener);
            if (_logger.isDebugEnabled()) {
                _logger.debug("result of remove=" + result);
            }
        }
    }

    public void term() {
        _logger.debug("term() called on " + this);
        this.doTerm();
        ResourceTracker tracker = ResourceTracker.getInstance();
        tracker.untrackResource(this._trackable);
    }

    private synchronized ThreadPoolImpl getImpl() {
        if (this._impl == null) {
            this._impl = new ThreadPoolImpl(this._threadNameBase);
        }
        return this._impl;
    }

    private void doTerm() {
        ThreadPoolImpl tp = this.getImpl();
        tp.term();
        ThreadPoolEvent event = new ThreadPoolEvent(this, ThreadPoolEvent.Type.TERMINATION);
        this.fireEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(ThreadPoolEvent event) {
        HashSet<ThreadPoolEventListenerInterface> copy = new HashSet<ThreadPoolEventListenerInterface>();
        Set<ThreadPoolEventListenerInterface> set = this._listenerSet;
        synchronized (set) {
            copy.addAll(this._listenerSet);
        }
        for (ThreadPoolEventListenerInterface listener : copy) {
            if (_logger.isDebugEnabled()) {
                _logger.debug("calling listener=" + listener + " with event=" + event);
            }
            try {
                listener.handleThreadPoolEvent(event);
            }
            catch (Throwable t) {
                _logger.warn("listener=" + listener + " threw exception", t);
            }
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this._impl != null) {
                this._impl.term();
            }
        }
        finally {
            super.finalize();
        }
    }

    @SASScope
    private static class WorkerThread
    implements Runnable {
        private Object _lock = new Object();
        private WorkInterface _currentWork;
        private boolean _dying;
        private ThreadPoolImpl _myPool;

        private WorkerThread(ThreadPoolImpl myPool, WorkInterface initialWork) {
            this._myPool = myPool;
            this._currentWork = initialWork;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeAsynchronously(WorkInterface work) {
            Object object = this._lock;
            synchronized (object) {
                this._currentWork = work;
                this._lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitForNewWork() {
            Object object = this._lock;
            synchronized (object) {
                try {
                    while (this._currentWork == null && !this._dying) {
                        this._lock.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    if (this._currentWork == null) {
                        this._dying = true;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doCurrentWorkNow() {
            if (this._currentWork != null) {
                try {
                    this._currentWork.run();
                }
                catch (Throwable t) {
                    StringBuffer msg = new StringBuffer(200);
                    msg.append("**\n** client of THREAD POOL threw unexpected exception\n** (work item.toString(): ");
                    try {
                        msg.append(this._currentWork.getClass()).append(" - ").append(this._currentWork).append(")");
                    }
                    catch (RuntimeException e) {
                        msg.append("--worker toString() threw exception too [").append(e).append("]");
                    }
                    System.err.println(msg);
                    t.printStackTrace();
                }
                Object object = this._lock;
                synchronized (object) {
                    this._myPool.removeWork(this._currentWork);
                    this._currentWork = null;
                    this._lock.notifyAll();
                }
                if (Thread.currentThread().isDaemon()) {
                    this._myPool.readyForNewAssignment(this);
                } else {
                    this.terminateWhenCurrentWorkCompletes();
                }
            }
        }

        @Override
        public void run() {
            while (true) {
                this.waitForNewWork();
                if (this._currentWork == null) break;
                this.doCurrentWorkNow();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void terminateWhenCurrentWorkCompletes() {
            Object object = this._lock;
            synchronized (object) {
                this._dying = true;
                this._lock.notifyAll();
            }
        }

        boolean isDying() {
            return this._dying;
        }

        Object getLock() {
            return this._lock;
        }
    }

    @SASScope
    private static class ThreadPoolImpl {
        private static int _nextThreadNumber = 1;
        private int _minSizeToShrinkTo = 30;
        private static final int MAX_IDLE = 100;
        private static final int MAX_SHRINK = 5;
        private static final long SHRINK_CHECK_INTERVAL_MSEC = 600000L;
        private static final float PERCENTAGE_SHRINK_FROM_MAX_BUSY = 0.1f;
        private String _threadNameBase;
        private Stack _idle;
        private int _numBusy;
        private long _nextShrinkCheckTime;
        private int _maxBusyThisPeriod;
        private boolean _terminated;
        private Map _workMap;

        private ThreadPoolImpl(String threadNameBase) {
            this._threadNameBase = threadNameBase;
            this._idle = new Stack();
            this._workMap = new WeakHashMap(8);
            this._nextShrinkCheckTime = ThreadPoolImpl.now() + 600000L;
        }

        private void executeAsynchronously(WorkInterface work) {
            this.addWork(work);
            this.assignWorkToWorker(work);
            this.maybeShrinkIdlePool();
        }

        private void executeStandard(WorkInterface work) {
            this.addWork(work);
            this.createNewWorker(work, false);
            this.maybeShrinkIdlePool();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void term() {
            Stack stack = this._idle;
            synchronized (stack) {
                this._terminated = true;
                while (!this._idle.isEmpty()) {
                    WorkerThread rval = (WorkerThread)this._idle.pop();
                    rval.terminateWhenCurrentWorkCompletes();
                }
            }
            this.releaseWork();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addWork(WorkInterface work) {
            Map map = this._workMap;
            synchronized (map) {
                this._workMap.put(work, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void releaseWork() {
            Map map = this._workMap;
            synchronized (map) {
                if (this._workMap.isEmpty()) {
                    return;
                }
                Set workSet = this._workMap.keySet();
                for (WorkInterface work : workSet) {
                    work.release();
                }
                this._workMap.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void assignWorkToWorker(WorkInterface work) {
            Stack stack = this._idle;
            synchronized (stack) {
                this._maxBusyThisPeriod = Math.max(this._maxBusyThisPeriod, ++this._numBusy);
                if (this._terminated) {
                    throw new IllegalStateException();
                }
                while (!this._idle.empty()) {
                    WorkerThread rval = (WorkerThread)this._idle.pop();
                    Object object = rval.getLock();
                    synchronized (object) {
                        if (!rval.isDying()) {
                            rval.executeAsynchronously(work);
                            return;
                        }
                    }
                }
            }
            this.createNewWorker(work, true);
        }

        public String toString() {
            StringBuffer rval = new StringBuffer(100);
            rval.append("ThreadPool: ").append(" num active workers (").append(this._numBusy).append("), max active workers this period(").append(this._maxBusyThisPeriod).append("), num idle workers (").append(this._idle.size()).append(")");
            return rval.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void readyForNewAssignment(WorkerThread worker) {
            Stack stack = this._idle;
            synchronized (stack) {
                if (this._idle.size() >= 100 || this._terminated) {
                    worker.terminateWhenCurrentWorkCompletes();
                } else {
                    this._idle.push(worker);
                }
                --this._numBusy;
            }
            this.maybeShrinkIdlePool();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeWork(WorkInterface work) {
            Map map = this._workMap;
            synchronized (map) {
                this._workMap.remove(work);
            }
        }

        private void createNewWorker(WorkInterface initialWork, final boolean isDaemon) {
            final String name = this._threadNameBase + _nextThreadNumber++;
            WorkerThread worker = new WorkerThread(this, initialWork);
            BaseSecuritySupport securitySupport = BaseSecuritySupport.securitySupport;
            final Thread t = securitySupport.createThread((Runnable)worker);
            PrivilegedAction action = new PrivilegedAction(){

                public Object run() {
                    t.setDaemon(isDaemon);
                    t.setName(name);
                    return null;
                }
            };
            securitySupport.doThreadPrivileged(action);
            t.start();
        }

        private static long now() {
            return System.currentTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void maybeShrinkIdlePool() {
            block10: {
                try {
                    if (ThreadPoolImpl.now() <= this._nextShrinkCheckTime) break block10;
                    ArrayList slackers = null;
                    Stack stack = this._idle;
                    synchronized (stack) {
                        this._nextShrinkCheckTime = ThreadPoolImpl.now() + 600000L;
                        int numIdle = this._idle.size();
                        this._minSizeToShrinkTo = Math.max(this._minSizeToShrinkTo, (int)((float)this._maxBusyThisPeriod * 0.5f));
                        if (numIdle > this._minSizeToShrinkTo) {
                            int desiredIdle = Math.max(this._minSizeToShrinkTo, (int)(1.0f * (float)this._maxBusyThisPeriod * 0.9f));
                            for (int numToRemove = Math.min(numIdle - desiredIdle, 5); numToRemove > 0; --numToRemove) {
                                if (slackers == null) {
                                    slackers = new ArrayList();
                                }
                                slackers.add(this._idle.pop());
                            }
                        }
                        this._maxBusyThisPeriod = this._numBusy;
                    }
                    if (slackers != null) {
                        for (WorkerThread slacker : slackers) {
                            slacker.terminateWhenCurrentWorkCompletes();
                        }
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        }
    }

    private final class TrackedResource
    implements TrackedResourceInterface {
        private TrackedResource() {
        }

        @Override
        public void shutdown(boolean waitForCompletion) {
            _logger.debug("terminate thread pool via tracked resource");
            ThreadPool.this.doTerm();
        }
    }
}

