/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk.profiles;

import MITI.sdk.MIRAttributeType;
import MITI.sdk.MIRMetaAttribute;
import MITI.sdk.profiles.MIRProfileEntity;
import MITI.server.services.common.mir.AttributeIdentifier;
import java.util.Comparator;

public class MIRProfileProperty {
    private static Comparator<MIRProfileProperty> propertyComparator = new Comparator<MIRProfileProperty>(){

        @Override
        public int compare(MIRProfileProperty mIRProfileProperty, MIRProfileProperty mIRProfileProperty2) {
            return mIRProfileProperty.position - mIRProfileProperty2.position;
        }
    };
    private MIRProfileEntity owner = null;
    private AttributeIdentifier id = null;
    private String name = null;
    private int position = 0;

    public static Comparator<MIRProfileProperty> getComparator() {
        return propertyComparator;
    }

    public AttributeIdentifier getAttributeIdentifier() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getPosition() {
        return this.position;
    }

    public byte getDataType() {
        MIRMetaAttribute mIRMetaAttribute = MIRMetaAttribute.getByAttributeType(this.id.getType());
        if (mIRMetaAttribute != null) {
            return mIRMetaAttribute.getType();
        }
        return 5;
    }

    public String getDefaultValue() {
        MIRMetaAttribute mIRMetaAttribute = MIRMetaAttribute.getByAttributeType(this.id.getType());
        if (mIRMetaAttribute != null) {
            return mIRMetaAttribute.getDefaultStringValue(false);
        }
        return "";
    }

    public String[] getPossibleValues() {
        MIRMetaAttribute mIRMetaAttribute = MIRMetaAttribute.getByAttributeType(this.id.getType());
        if (mIRMetaAttribute != null) {
            return mIRMetaAttribute.getPossibleStringValues(false);
        }
        return new String[0];
    }

    public String getPath() {
        return this.id.toMPath();
    }

    public MIRProfileProperty(AttributeIdentifier attributeIdentifier, MIRProfileEntity mIRProfileEntity) {
        this.id = attributeIdentifier;
        this.name = !attributeIdentifier._isUdp() ? MIRAttributeType.toString(attributeIdentifier.getType()) : attributeIdentifier.getName();
        this.owner = mIRProfileEntity;
        mIRProfileEntity.addAttribute(this);
    }

    MIRProfileEntity getOwner() {
        return this.owner;
    }

    public void setName(String string) {
        if (string != null && string.length() != 0) {
            this.name = string;
        }
    }

    public void setPosition(int n) {
        this.position = n;
    }
}

