/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk.profiles;

import MITI.MIRException;
import MITI.sdk.profiles.MIRProfileEntity;
import MITI.sdk.profiles.MIRProfileLink;
import MITI.sdk.profiles.MIRProfileLinkList;
import MITI.server.services.common.mir.LinkIdentifier;
import java.util.Comparator;

public class MIRProfileGroup {
    private static Comparator<MIRProfileGroup> comparator = new Comparator<MIRProfileGroup>(){

        @Override
        public int compare(MIRProfileGroup mIRProfileGroup, MIRProfileGroup mIRProfileGroup2) {
            return mIRProfileGroup.position - mIRProfileGroup2.position;
        }
    };
    private String name = null;
    private String icon = null;
    private int position = 0;
    private MIRProfileEntity owner;
    private MIRProfileLinkList childLinks = new MIRProfileLinkList();

    MIRProfileGroup(MIRProfileEntity mIRProfileEntity, String string, String string2, boolean bl) {
        this.owner = mIRProfileEntity;
        this.name = string;
        this.icon = string2;
    }

    public void addLink(MIRProfileLink mIRProfileLink) throws MIRException {
        this.childLinks.addLink(mIRProfileLink);
    }

    public static Comparator<MIRProfileGroup> getComparator() {
        return comparator;
    }

    public void setPosition(int n) {
        this.position = n;
    }

    public int getPosition() {
        return this.position;
    }

    public String getName() {
        return this.name;
    }

    public MIRProfileEntity getOwner() {
        return this.owner;
    }

    public String getIcon() {
        return this.icon;
    }

    public MIRProfileLink getProfileLink(LinkIdentifier linkIdentifier, MIRProfileEntity mIRProfileEntity) {
        return this.childLinks.getProfileLink(linkIdentifier, mIRProfileEntity);
    }

    public MIRProfileLink[] getProfileLinks() {
        return this.childLinks.getProfileLinks();
    }

    public LinkIdentifier[] getLinks() {
        return this.childLinks.getLinkIdentifiers();
    }

    public MIRProfileLinkList getLinkList() {
        return this.childLinks;
    }

    public boolean linkExists(MIRProfileLink mIRProfileLink) {
        return this.childLinks.exists(mIRProfileLink);
    }

    public String toString() {
        return this.owner.getName() + "/" + this.name;
    }
}

