/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.config;

import com.sas.report.config.OmiJaasEntry;
import com.sas.report.config.RB;
import com.sas.text.Message;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.security.auth.login.AppConfigurationEntry;

class OmiJaasFile {
    private static final String JAAS_FILE_HEADER_COMMENT = "/**        JAAS Login Configuration File        **/\n/**     (generated by sas.report.config.jar)    **/\n/** Changes made to this file will be lost      **/\n/** upon the next connection attempt            **/\n/** or template-based service deployment!       **/\n\n";
    private List _entries = new ArrayList();
    private StreamTokenizer st;
    private int lookahead;
    private int linenum;
    private HashMap configuration;
    private boolean testing = false;

    public void init(File loginConfig) throws IOException {
        if (loginConfig == null) {
            this.configuration = new HashMap(0);
            return;
        }
        HashMap newConfig = new HashMap();
        FileInputStream stream = new FileInputStream(loginConfig);
        InputStreamReader reader = new InputStreamReader((InputStream)stream, "UTF-8");
        this.readConfig(reader, newConfig);
        this.configuration = newConfig;
        reader.close();
    }

    public void clear() {
        this._entries.clear();
    }

    public void add(OmiJaasEntry entry) {
        if (!this._entries.contains(entry)) {
            this._entries.add(entry);
        }
    }

    public void remove(OmiJaasEntry entry) {
        if (this._entries.contains(entry)) {
            this._entries.remove(entry);
        }
    }

    public boolean contains(OmiJaasEntry entry) {
        return this._entries.contains(entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File f) throws IOException {
        StringBuffer buf = new StringBuffer();
        buf.append(JAAS_FILE_HEADER_COMMENT);
        this.appendContentsToBuffer(buf);
        String jaasFileContent = buf.toString();
        try (OutputStreamWriter osw = null;){
            FileOutputStream fos = new FileOutputStream(f);
            osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            osw.write(jaasFileContent);
            if (this.configuration != null) {
                for (Map.Entry entry : this.configuration.entrySet()) {
                    String context = (String)entry.getKey();
                    if (context.equals("PFS")) continue;
                    List configList = (List)entry.getValue();
                    for (AppConfigurationEntry config : configList) {
                        osw.write(context);
                        osw.write(" {\n");
                        String controlFlagString = "required";
                        AppConfigurationEntry.LoginModuleControlFlag controlFlag = config.getControlFlag();
                        if (controlFlag == AppConfigurationEntry.LoginModuleControlFlag.REQUIRED) {
                            controlFlagString = "required";
                        } else if (controlFlag == AppConfigurationEntry.LoginModuleControlFlag.REQUISITE) {
                            controlFlagString = "requisite";
                        } else if (controlFlag == AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT) {
                            controlFlagString = "sufficient";
                        } else if (controlFlag == AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL) {
                            controlFlagString = "optional";
                        }
                        osw.write("   " + config.getLoginModuleName() + "   " + controlFlagString);
                        Map<String, ?> optionMap = config.getOptions();
                        for (Map.Entry<String, ?> optionEntry : optionMap.entrySet()) {
                            String option = optionEntry.getKey();
                            String value = (String)optionEntry.getValue();
                            osw.write("\n         " + option + "=\"" + value + "\"");
                        }
                        osw.write(";\n};\n");
                    }
                }
            }
        }
    }

    private void appendContentsToBuffer(StringBuffer buf) {
        buf.append("PFS {\n");
        for (OmiJaasEntry entry : this._entries) {
            entry.appendToBuffer(buf);
        }
        buf.append("};\n");
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        this.appendContentsToBuffer(buf);
        return buf.toString();
    }

    private void readConfig(Reader reader, HashMap newConfig) throws IOException {
        if (!(reader instanceof BufferedReader)) {
            reader = new BufferedReader(reader);
        }
        this.st = new StreamTokenizer(reader);
        this.st.quoteChar(34);
        this.st.wordChars(36, 36);
        this.st.wordChars(95, 95);
        this.st.wordChars(45, 45);
        this.st.lowerCaseMode(false);
        this.st.slashSlashComments(true);
        this.st.slashStarComments(true);
        this.st.eolIsSignificant(true);
        this.lookahead = this.nextToken();
        while (this.lookahead != -1) {
            if (this.testing) {
                System.out.print("\tReading next config entry: ");
            }
            this.parseLoginEntry(newConfig);
        }
        reader.close();
    }

    private void parseLoginEntry(HashMap newConfig) throws IOException {
        LinkedList<AppConfigurationEntry> configEntries = new LinkedList<AppConfigurationEntry>();
        String appName = this.st.sval;
        this.lookahead = this.nextToken();
        if (this.testing) {
            System.out.println("appName = " + appName);
        }
        this.match("{");
        while (!this.peek("}")) {
            AppConfigurationEntry.LoginModuleControlFlag controlFlag;
            String moduleClass = this.match("module class name");
            String sflag = this.match("controlFlag");
            if (sflag.equalsIgnoreCase("REQUIRED")) {
                controlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
            } else if (sflag.equalsIgnoreCase("REQUISITE")) {
                controlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
            } else if (sflag.equalsIgnoreCase("SUFFICIENT")) {
                controlFlag = AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
            } else if (sflag.equalsIgnoreCase("OPTIONAL")) {
                controlFlag = AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
            } else {
                throw new IOException(Message.format((ResourceBundle)RB.getResources(), (String)"OmiJaasFile.invalidcontrolflag.ex.fmt.txt", (Object)sflag));
            }
            HashMap<String, String> options = new HashMap<String, String>();
            while (!this.peek(";")) {
                String key = this.match("option key");
                this.match("=");
                String value = this.match("option value");
                options.put(key, value);
            }
            this.lookahead = this.nextToken();
            if (this.testing) {
                System.out.print("\t\t" + moduleClass + ", " + sflag);
                Iterator i = options.entrySet().iterator();
                Map.Entry mapEntry = null;
                while (i.hasNext()) {
                    mapEntry = i.next();
                    System.out.print(", " + mapEntry.getKey() + "=" + mapEntry.getValue());
                }
                System.out.println("");
            }
            AppConfigurationEntry entry = new AppConfigurationEntry(moduleClass, controlFlag, options);
            configEntries.add(entry);
        }
        this.match("}");
        this.match(";");
        if (newConfig.containsKey(appName)) {
            throw new IOException(Message.format((ResourceBundle)RB.getResources(), (String)"OmiJaasFile.duplicateapps.ex.fmt.txt", (Object)appName));
        }
        newConfig.put(appName, configEntries);
    }

    private String match(String expect) throws IOException {
        String value = null;
        switch (this.lookahead) {
            case -1: {
                throw new IOException(Message.format((ResourceBundle)RB.getResources(), (String)"OmiJaasFile.cfgerreof.ex.fmt.txt", (Object)expect));
            }
            case -3: 
            case 34: {
                if (expect.equalsIgnoreCase("module class name") || expect.equalsIgnoreCase("controlFlag") || expect.equalsIgnoreCase("option key") || expect.equalsIgnoreCase("option value")) {
                    value = this.st.sval;
                    this.lookahead = this.nextToken();
                    break;
                }
                throw new IOException(Message.format((ResourceBundle)RB.getResources(), (String)"OmiJassFile.cfgerrline.ex.fmt.txt", (Object)new Integer(this.linenum), (Object)expect, (Object)this.st.sval));
            }
            case 123: {
                if (expect.equalsIgnoreCase("{")) {
                    this.lookahead = this.nextToken();
                    break;
                }
                throw new IOException(Message.format((ResourceBundle)RB.getResources(), (String)"OmiJassFile.cfgerrline.ex.fmt.txt", (Object)new Integer(this.linenum), (Object)expect, (Object)this.st.sval));
            }
            case 59: {
                if (expect.equalsIgnoreCase(";")) {
                    this.lookahead = this.nextToken();
                    break;
                }
                throw new IOException(Message.format((ResourceBundle)RB.getResources(), (String)"OmiJassFile.cfgerrline.ex.fmt.txt", (Object)new Integer(this.linenum), (Object)expect, (Object)this.st.sval));
            }
            case 125: {
                if (expect.equalsIgnoreCase("}")) {
                    this.lookahead = this.nextToken();
                    break;
                }
                throw new IOException(Message.format((ResourceBundle)RB.getResources(), (String)"OmiJassFile.cfgerrline.ex.fmt.txt", (Object)new Integer(this.linenum), (Object)expect, (Object)this.st.sval));
            }
            case 61: {
                if (expect.equalsIgnoreCase("=")) {
                    this.lookahead = this.nextToken();
                    break;
                }
                throw new IOException(Message.format((ResourceBundle)RB.getResources(), (String)"OmiJassFile.cfgerrline.ex.fmt.txt", (Object)new Integer(this.linenum), (Object)expect, (Object)this.st.sval));
            }
            default: {
                throw new IOException(Message.format((ResourceBundle)RB.getResources(), (String)"OmiJassFile.cfgerrline.ex.fmt.txt", (Object)new Integer(this.linenum), (Object)expect, (Object)this.st.sval));
            }
        }
        return value;
    }

    private boolean peek(String expect) {
        boolean found = false;
        switch (this.lookahead) {
            case 44: {
                if (!expect.equalsIgnoreCase(",")) break;
                found = true;
                break;
            }
            case 59: {
                if (!expect.equalsIgnoreCase(";")) break;
                found = true;
                break;
            }
            case 123: {
                if (!expect.equalsIgnoreCase("{")) break;
                found = true;
                break;
            }
            case 125: {
                if (!expect.equalsIgnoreCase("}")) break;
                found = true;
                break;
            }
        }
        return found;
    }

    private int nextToken() throws IOException {
        int tok;
        while ((tok = this.st.nextToken()) == 10) {
            ++this.linenum;
        }
        return tok;
    }
}

