/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.config;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

final class OmiJaasEntry {
    private static final int PRIME_NUMBER = 7;
    private String _host;
    private String _port;
    private String _repository;
    private String _domain;
    private Map _properties;

    public OmiJaasEntry(String host, String port, String repository, String domain) {
        this._host = host;
        this._port = port;
        this._repository = repository;
        this._domain = domain;
    }

    public OmiJaasEntry(String host, String port, String repository, String domain, Map properties) {
        this._host = host;
        this._port = port;
        this._repository = repository;
        this._domain = domain;
        this._properties = properties;
    }

    public void appendToBuffer(StringBuffer buf) {
        buf.append("com.sas.services.security.login.OMILoginModule  optional\n");
        buf.append("   host=\"").append(this._host).append("\"\n");
        buf.append("   port=\"").append(this._port).append("\"\n");
        Logger logger = Logger.getLogger(OmiJaasEntry.class.getName());
        if (logger.isLoggable(Level.FINE)) {
            buf.append("   debug=\"true\"");
        }
        if (this._properties != null) {
            for (Map.Entry me : this._properties.entrySet()) {
                buf.append("   " + me.getKey() + "=\"" + me.getValue() + "\"\n");
            }
        }
        buf.append("   domain=\"").append(this._domain).append("\";\n");
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        this.appendToBuffer(buf);
        return buf.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OmiJaasEntry)) {
            return false;
        }
        OmiJaasEntry other = (OmiJaasEntry)obj;
        return this.isEqual(this._host, other._host) && this.isEqual(this._port, other._port) && this.isEqual(this._domain, other._domain);
    }

    public int hashCode() {
        int hashCode = 5;
        int primeNumber = 7;
        hashCode = 7 * hashCode + (this._host == null ? 0 : this._host.hashCode());
        hashCode = 7 * hashCode + (this._port == null ? 0 : this._port.hashCode());
        hashCode = 7 * hashCode + (this._domain == null ? 0 : this._domain.hashCode());
        return hashCode;
    }

    private boolean isEqual(String a, String b) {
        if (a == null) {
            return b == null;
        }
        return a.equalsIgnoreCase(b);
    }
}

