/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.config;

import com.sas.report.config.RBUtil;
import com.sas.services.information.metadata.PathUrl;

public class MetadataSourceDef {
    public static final char ABSOLUTE_PATH_DELIMITER = '@';
    public static final String SBIP_PROTOCOL_PREFIX = "SBIP://";
    private String _omrHostMachine;
    private String _omrHostPort;
    private String _omrRepositoryName;
    private String _authDomain;
    private String _ipAddress;

    MetadataSourceDef(String omrHostMachine, String omrHostPort, String omrRepositoryName, String authDomain) throws IllegalArgumentException {
        this.validateParam(omrHostMachine, "HostMachine");
        this._omrHostMachine = omrHostMachine;
        this.validateParam(omrHostPort, "HostPort");
        this._omrHostPort = omrHostPort;
        if (omrRepositoryName != null) {
            this.validateParam(omrRepositoryName, "RepositoryName");
        }
        this._omrRepositoryName = omrRepositoryName;
        this.validateParam(authDomain, "Domain");
        this._authDomain = authDomain;
    }

    public String getAbsoluteUrl(String sbipUrl) throws IllegalArgumentException {
        String upCasedUrl = sbipUrl.toUpperCase();
        if (!upCasedUrl.startsWith(SBIP_PROTOCOL_PREFIX)) {
            throw new IllegalArgumentException(RBUtil.getStringResource("MetadataSourceDef.badprotocol.txt"));
        }
        int ndxOfFirstDelim = sbipUrl.indexOf(64);
        if (ndxOfFirstDelim > -1) {
            return sbipUrl;
        }
        PathUrl pathUrl = new PathUrl(sbipUrl);
        String urlReposName = pathUrl.getRepository();
        if (this._omrRepositoryName != null && !this._omrRepositoryName.equalsIgnoreCase(urlReposName)) {
            throw new IllegalArgumentException(RBUtil.getStringResource("MetadataSourceDef.reposNameMismatch.fmt.txt", urlReposName, this._omrRepositoryName));
        }
        pathUrl.setRepository(this.getRepositoryDefName());
        return pathUrl.toString();
    }

    public String getRepositoryDefName() {
        StringBuffer reposDefName = new StringBuffer();
        if (this._omrRepositoryName != null) {
            reposDefName.append(this._omrRepositoryName);
            reposDefName.append('@');
        }
        reposDefName.append(this._omrHostMachine);
        reposDefName.append('@');
        reposDefName.append(this._omrHostPort);
        reposDefName.append('@');
        reposDefName.append(this._authDomain.toUpperCase());
        return reposDefName.toString();
    }

    public String getOmrIPAddress() {
        return this._ipAddress;
    }

    public String getOmrHostMachine() {
        return this._omrHostMachine;
    }

    public String getOmrHostPort() {
        return this._omrHostPort;
    }

    public String getOmrRepositoryName() {
        return this._omrRepositoryName;
    }

    public String getAuthDomain() {
        return this._authDomain;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[host='").append(this._omrHostMachine);
        buf.append("', port='").append(this._omrHostPort);
        buf.append("', repository='").append(this._omrRepositoryName);
        buf.append("', authDomain='").append(this._authDomain);
        buf.append("']");
        return buf.toString();
    }

    private void validateParam(String param, String paramName) throws IllegalArgumentException {
        if (param == null) {
            throw new IllegalArgumentException(RBUtil.getStringResource("MetadataSourceDef.paramIsNull.fmt.txt", paramName));
        }
        if (param.length() == 0) {
            throw new IllegalArgumentException(RBUtil.getStringResource("MetadataSourceDef.paramIsBlank.fmt.txt", paramName));
        }
        if (param.indexOf(64) > -1) {
            throw new IllegalArgumentException(RBUtil.getStringResource("MetadataSourceDef.paramContainsAtChar.fmt.txt", paramName));
        }
        if (param.indexOf(47) > -1) {
            throw new IllegalArgumentException(RBUtil.getStringResource("MetadataSourceDef.paramContainsSlashChar.fmt.txt", paramName));
        }
        if (param.indexOf(92) > -1) {
            throw new IllegalArgumentException(RBUtil.getStringResource("MetadataSourceDef.paramContainsBackSlashChar.fmt.txt", paramName));
        }
    }
}

