/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.config;

import com.sas.report.config.JaasLoginConfig;
import com.sas.report.config.RB;
import com.sas.report.config.ServiceDeploymentConfig;
import java.io.IOException;

public final class ConfigBuilder {
    public static final String AUTOCONNECT_ENABLED = "true";
    public static final String OMI_PROTOCOL = "omi";
    public static final String DEPLOYMENT_FILE_ENV_VAR = "PFS_TEMPLATE";
    public static final String JAAS_FILE_ENV_VAR = "java.security.auth.login.config";
    public static final String DEFAULT_LOGGING_LEVEL = "ERROR";
    public static final String UTF8 = "UTF-8";

    public static void generateFiles(String deploymentFileTemplate, String deploymentFileDest, String jaasFileTemplate, String jaasFileDest, String repositoryName, String omrHost, String omrPort, String rootLoggingLevel, String authenticationDomain) throws IOException {
        String repositoryDefName = repositoryName;
        ConfigBuilder.generateDeploymentFile(deploymentFileTemplate, deploymentFileDest, repositoryName, repositoryDefName, omrHost, omrPort, rootLoggingLevel, authenticationDomain);
        JaasLoginConfig jlc = new JaasLoginConfig(jaasFileTemplate);
        jlc.write(omrHost, omrPort, repositoryName, authenticationDomain, jaasFileDest);
    }

    public static void generateDeploymentFile(String deploymentFileTemplate, String deploymentFileDest, String repositoryName, String repositoryDefName, String omrHost, String omrPort, String rootLoggingLevel, String authenticationDomain) throws IOException {
        String reposDefStr = ServiceDeploymentConfig.getReposDef(omrHost, omrPort, repositoryDefName, authenticationDomain, OMI_PROTOCOL, repositoryName, AUTOCONNECT_ENABLED);
        ServiceDeploymentConfig sdc = new ServiceDeploymentConfig(deploymentFileTemplate);
        String primaryDefStr = "omi://" + omrHost + ":" + omrPort;
        sdc.write(reposDefStr, rootLoggingLevel, deploymentFileDest, primaryDefStr);
    }

    public static void generateDeploymentFile(String deploymentFileDest, String repositoryName, String repositoryDefName, String omrHost, String omrPort, String authenticationDomain) throws IOException {
        String deploymentFileTemplate = System.getProperty(DEPLOYMENT_FILE_ENV_VAR);
        if (deploymentFileTemplate == null) {
            throw new IOException(RB.getStringResource("ConfigBuilderDeploymentVarMissing.txt"));
        }
        String loggingLevel = DEFAULT_LOGGING_LEVEL;
        ConfigBuilder.generateDeploymentFile(deploymentFileTemplate, deploymentFileDest, repositoryName, repositoryDefName, omrHost, omrPort, loggingLevel, authenticationDomain);
    }

    public static void generateFiles(String deploymentFileTemplate, String deploymentFileDest, String jaasFileTemplate, String jaasFileDest, String repositoryName, String omrHost, String omrPort, String rootLoggingLevel) throws IOException {
        String authDomain = repositoryName + "." + omrHost;
        ConfigBuilder.generateFiles(deploymentFileTemplate, deploymentFileDest, jaasFileTemplate, jaasFileDest, repositoryName, omrHost, omrPort, rootLoggingLevel, authDomain);
    }

    public static void generateFiles(String deploymentFileTemplate, String deploymentFileDest, String jaasFileTemplate, String jaasFileDest, String repositoryName, String omrHost, String omrPort) throws IOException {
        ConfigBuilder.generateFiles(deploymentFileTemplate, deploymentFileDest, jaasFileTemplate, jaasFileDest, repositoryName, omrHost, omrPort, DEFAULT_LOGGING_LEVEL);
    }

    public static void generateFiles(String deploymentFileTemplate, String deploymentFileDest, String jaasFileDest, String repositoryName, String omrHost, String omrPort) throws IOException {
        String jaasFileTemplate = null;
        ConfigBuilder.generateFiles(deploymentFileTemplate, deploymentFileDest, jaasFileTemplate, jaasFileDest, repositoryName, omrHost, omrPort);
    }

    public static void generateFiles(String deploymentFileDest, String repositoryName, String omrHost, String omrPort) throws IOException {
        String deploymentFileTemplate = System.getProperty(DEPLOYMENT_FILE_ENV_VAR);
        if (deploymentFileTemplate == null) {
            throw new IOException(RB.getStringResource("ConfigBuilderDeploymentVarMissing.txt"));
        }
        String jaasFileDest = System.getProperty(JAAS_FILE_ENV_VAR);
        if (jaasFileDest == null) {
            throw new IOException(RB.getStringResource("ConfigBuilderJaasVarMissing.txt"));
        }
        ConfigBuilder.generateFiles(deploymentFileTemplate, deploymentFileDest, jaasFileDest, repositoryName, omrHost, omrPort);
    }

    public static void generateFiles(String deploymentFileDest, String repositoryName, String omrHost, String omrPort, String authenticationDomain) throws IOException {
        String deploymentFileTemplate = System.getProperty(DEPLOYMENT_FILE_ENV_VAR);
        if (deploymentFileTemplate == null) {
            throw new IOException(RB.getStringResource("ConfigBuilderDeploymentVarMissing.txt"));
        }
        String jaasFileDest = System.getProperty(JAAS_FILE_ENV_VAR);
        if (jaasFileDest == null) {
            throw new IOException(RB.getStringResource("ConfigBuilderJaasVarMissing.txt"));
        }
        String jaasFileTemplate = repositoryName == null ? "-1" : null;
        String rootLoggingLevel = DEFAULT_LOGGING_LEVEL;
        ConfigBuilder.generateFiles(deploymentFileTemplate, deploymentFileDest, jaasFileTemplate, jaasFileDest, repositoryName, omrHost, omrPort, rootLoggingLevel, authenticationDomain);
    }

    private ConfigBuilder() {
    }
}

