/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.sasprocs;

import com.sas.iom.SAS.ILanguageService;
import com.sas.iom.SAS.ILanguageServicePackage.CarriageControlSeqHolder;
import com.sas.iom.SAS.ILanguageServicePackage.LineType;
import com.sas.iom.SAS.ILanguageServicePackage.LineTypeSeqHolder;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SASEvents.ILanguageEventsHelper;
import com.sas.iom.SASEvents._ILanguageEventsImplBase;
import com.sas.iom.SASIOMDefs.CP_ID;
import com.sas.iom.SASIOMDefs.ConnectionPoint;
import com.sas.iom.SASIOMDefs.ConnectionPointContainer;
import com.sas.iom.SASIOMDefs.ConnectionPointContainerHelper;
import com.sas.iom.SASIOMDefs.ConnectionPointHolder;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.model.SchedulerException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Object;

public class submitSAS {
    private static final ResourceBundle m_bundle = MetaUtilities.getMyResourceBundle(submitSAS.class);
    protected IWorkspace m_workspace = null;
    private boolean m_operationComplete;
    protected StringSeqHolder m_logLinesHolder;
    protected StringSeqHolder m_listLinesHolder;
    protected int m_status;
    protected String m_statusMsg;
    protected String m_2ndStatusMsg;
    protected static final int STATUS_OKAY = 0;
    protected static final int STATUS_Warning = 1;
    protected static final int STATUS_SubmitFailed = 2;
    protected static final int STATUS_NoLogFetch = 3;
    protected static final int STATUS_NoListFetch = 4;
    protected static final int STATUS_CodeError = 5;
    protected static final int STATUS_Abort = 6;

    public submitSAS(IWorkspace workspace) {
        this.m_workspace = workspace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitStatements(StringBuffer statements) throws SchedulerException {
        ILanguageService sasLanguage = this.m_workspace.LanguageService();
        ConnectionPoint cpC = submitSAS.getConnectionPoint(sasLanguage);
        int handle = submitSAS.registerLanguageListener(new ILanguageEventsListener(), cpC);
        this.setOperationComplete(false);
        try {
            sasLanguage.Submit(statements.toString());
            this.waitForCompletion();
        }
        catch (SchedulerException se) {
            this.setStatus(2, se.getLocalizedMessage());
        }
        catch (GenericError ge) {
            this.setStatus(2, ge.getLocalizedMessage());
        }
        catch (RuntimeException rte) {
            if (rte instanceof OBJECT_NOT_EXIST) {
                this.setStatus(6, rte.getLocalizedMessage());
            } else {
                this.setStatus(2, rte.toString());
            }
        }
        finally {
            submitSAS se = this;
            synchronized (se) {
                submitSAS.unregisterLanguageListener(cpC, handle);
                if (this.m_status != 5 && this.m_status != 0) {
                    this.postCompletion();
                }
            }
        }
        CarriageControlSeqHolder logCCHolder = new CarriageControlSeqHolder();
        LineTypeSeqHolder logTypeHolder = new LineTypeSeqHolder();
        this.m_logLinesHolder = new StringSeqHolder();
        StringBuffer warnmsg = new StringBuffer();
        try {
            sasLanguage.FlushLogLines(Integer.MAX_VALUE, logCCHolder, logTypeHolder, this.m_logLinesHolder);
            LineType[] linetypes = logTypeHolder.value;
            String[] lines = this.m_logLinesHolder.value;
            StringBuffer errormsg = new StringBuffer();
            String previous = null;
            for (int i = 0; i < linetypes.length; ++i) {
                switch (linetypes[i].value()) {
                    case 6: {
                        if (previous == null || lines[i].compareTo(previous) == 0) break;
                        if (errormsg.length() != 0) {
                            errormsg.append("\n");
                        }
                        errormsg.append(lines[i]);
                        break;
                    }
                    case 7: {
                        if (previous == null || lines[i].compareTo(previous) == 0) break;
                        if (lines[i].indexOf("VALIDVARNAME=ANY") == -1) {
                            if (warnmsg.length() != 0) {
                                warnmsg.append("\n");
                            }
                            warnmsg.append(lines[i]);
                            break;
                        }
                        ++i;
                    }
                }
                previous = lines[i];
            }
            if (errormsg.length() > 0) {
                if (warnmsg.length() > 0) {
                    errormsg.append("\n");
                    errormsg.append(warnmsg);
                    this.setStatus(2, errormsg.toString());
                } else {
                    this.setStatus(2, errormsg.toString());
                }
            }
        }
        catch (SchedulerException ex) {
            throw ex;
        }
        catch (GenericError ge) {
            this.setStatus(3, ge.getMessage());
        }
        catch (RuntimeException rte) {
            this.setStatus(3, rte.toString());
        }
        CarriageControlSeqHolder listCCHolder = new CarriageControlSeqHolder();
        LineTypeSeqHolder listTypeHolder = new LineTypeSeqHolder();
        this.m_listLinesHolder = new StringSeqHolder();
        try {
            sasLanguage.FlushListLines(Integer.MAX_VALUE, listCCHolder, listTypeHolder, this.m_listLinesHolder);
        }
        catch (GenericError ge) {
            this.setStatus(4, ge.getMessage());
        }
        catch (RuntimeException rte) {
            this.setStatus(4, rte.toString());
        }
        if (warnmsg.length() > 0) {
            this.setStatus(1, warnmsg.toString());
        }
    }

    public synchronized void postCompletion() {
        this.setOperationComplete(true);
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setOperationComplete(boolean value) {
        submitSAS submitSAS2 = this;
        synchronized (submitSAS2) {
            this.m_operationComplete = value;
        }
    }

    protected void setStatus(int newStatus, String str2ndMsg) throws SchedulerException {
        this.m_2ndStatusMsg = str2ndMsg;
        this.m_status = newStatus;
        this.setStatusMsg(null);
    }

    protected void setStatusMsg(java.lang.Object[] subStrs) throws SchedulerException {
        if (this.m_status == 0) {
            this.m_statusMsg = m_bundle.getString("submitSAS.Status.OK.txt");
        } else if (this.m_status == 1) {
            this.m_statusMsg = this.m_2ndStatusMsg;
        } else {
            String msgName = "submitSAS.Status.Msg" + String.valueOf(this.m_status) + ".txt";
            String format = m_bundle.getString(msgName);
            if (subStrs == null) {
                this.m_statusMsg = format;
            } else {
                MessageFormat msg = new MessageFormat(format);
                this.m_statusMsg = msg.format(subStrs);
            }
            String message = this.getFullStatusMsg();
            switch (this.m_status) {
                case 5: {
                    throw new SchedulerException(message);
                }
                case 2: {
                    throw new SchedulerException(message);
                }
                case 6: {
                    throw new SchedulerException(message);
                }
            }
            this.m_status = 0;
            this.m_statusMsg = null;
            this.m_2ndStatusMsg = null;
            throw new SchedulerException(message);
        }
    }

    protected String getFullStatusMsg() {
        StringBuffer strBuf = new StringBuffer(128);
        if (this.m_statusMsg != null) {
            strBuf.append(this.m_statusMsg);
        }
        if (this.m_2ndStatusMsg != null) {
            strBuf.append("  ");
            strBuf.append(this.m_2ndStatusMsg);
        }
        return strBuf.toString();
    }

    public StringBuffer getLog() {
        StringBuffer strLog = new StringBuffer();
        String[] lines = this.m_logLinesHolder.value;
        for (int i = 0; i < lines.length; ++i) {
            strLog.append(lines[i] + '\n');
        }
        return strLog;
    }

    private synchronized int waitForCompletion() throws SchedulerException {
        try {
            int count = 0;
            while (!this.m_operationComplete) {
                this.wait(200L);
                if (++count != 500) continue;
                throw new SchedulerException(m_bundle.getString("submitSAS.CodeSubmissionTimeOutError.txt"), submitSAS.class, "submitSAS.CodeSubmissionTimeOutError.txt", null);
            }
        }
        catch (InterruptedException e) {
            this.m_status = 1;
        }
        return this.m_status;
    }

    protected static ConnectionPoint getConnectionPoint(ILanguageService LS) {
        int i;
        String cpidString = ILanguageEventsHelper.id();
        int d1 = (int)Long.parseLong(cpidString.substring(4, 12), 16);
        short d2 = (short)Integer.parseInt(cpidString.substring(13, 17), 16);
        short d3 = (short)Integer.parseInt(cpidString.substring(18, 22), 16);
        byte[] d4 = new byte[8];
        for (i = 0; i < 2; ++i) {
            d4[i] = (byte)Short.parseShort(cpidString.substring(23 + i * 2, 25 + i * 2), 16);
        }
        for (i = 0; i < 6; ++i) {
            d4[i + 2] = (byte)Short.parseShort(cpidString.substring(28 + i * 2, 30 + i * 2), 16);
        }
        CP_ID cpid = new CP_ID(d1, d2, d3, d4);
        ConnectionPointContainer cpContainer = ConnectionPointContainerHelper.narrow((Object)LS);
        ConnectionPointHolder cpHolder = new ConnectionPointHolder();
        cpContainer.FindConnectionPoint(cpid, cpHolder);
        ConnectionPoint cpC = cpHolder.value;
        return cpC;
    }

    private static int registerLanguageListener(ILanguageEventsListener sasListenerC, ConnectionPoint cpC) {
        IntHolder handleHolder = new IntHolder();
        cpC.Advise((Object)sasListenerC, handleHolder);
        int handleC = handleHolder.value;
        return handleC;
    }

    private static void unregisterLanguageListener(ConnectionPoint cpC, int handle) {
        cpC.Unadvise(handle);
    }

    protected class ILanguageEventsListener
    extends _ILanguageEventsImplBase {
        private boolean errorDetected = false;

        public void ProcStart(String procname) {
        }

        public void SubmitComplete(int sasrc) {
            submitSAS.this.setOperationComplete(true);
            if (!this.errorDetected) {
                try {
                    submitSAS.this.setStatus(0, String.valueOf(sasrc));
                }
                catch (SchedulerException ex) {
                    String msgName = "submitSAS.Status.Msg" + String.valueOf(submitSAS.this.m_status) + ".txt";
                    submitSAS.this.m_statusMsg = m_bundle.getString(msgName);
                }
            }
        }

        public void ProcComplete(String procname) {
        }

        public void DatastepStart() {
        }

        public void DatastepComplete() {
        }

        public void StepError() {
            this.errorDetected = true;
            try {
                submitSAS.this.setStatus(2, "");
            }
            catch (SchedulerException ex) {
                String msgName = "submitSAS.Status.Msg" + String.valueOf(submitSAS.this.m_status) + ".txt";
                submitSAS.this.m_statusMsg = m_bundle.getString(msgName);
            }
        }
    }
}

