/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.sasprocs;

import com.sas.iom.SAS.IBinaryStream;
import com.sas.iom.SAS.IFileService;
import com.sas.iom.SAS.IFileref;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SAS.StreamOpenMode;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.OctetSeqHolder;
import com.sas.net.crypto.SealedString;
import com.sas.scheduler.api.oma.CommandUtilities;
import com.sas.scheduler.api.servers.os.OSFlowHistory;
import com.sas.scheduler.api.servers.os.OSScheduler;
import com.sas.scheduler.api.servers.sasprocs.submitSAS;
import com.sas.scheduler.model.AbstractEventInfo;
import com.sas.scheduler.model.AbstractEventInterface;
import com.sas.scheduler.model.DisplayInfo;
import com.sas.scheduler.model.FileEventInfo;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.GeneralUtilities;
import com.sas.scheduler.model.GroupingEventInfo;
import com.sas.scheduler.model.JobDefinitionInfo;
import com.sas.scheduler.model.JobInfo;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.TimeEventInfo;
import com.sas.scheduler.model.TriggerEventInfo;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import java.io.UnsupportedEncodingException;
import java.security.InvalidParameterException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.Vector;
import org.omg.CORBA.StringHolder;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProcScheduler
extends submitSAS {
    private static final ResourceBundle m_bundle;
    private OSScheduler m_scheduler;
    private FlowInfo m_flow;
    private String m_username;
    private String m_outdir;
    private IBinaryStream m_file;
    private IFileref m_fileref;
    private String m_filerefName;
    private String m_assignedref;
    private IFileService m_rio;
    private StringBuffer m_scode;
    private StringBuffer m_incode;
    private String m_sascode;
    private boolean m_footer;
    private static final String PROC_DEBUG = "debug=1023";

    public ProcScheduler(OSScheduler scheduler, FlowInfo flow, boolean now, String dirpath, IWorkspace workspace) throws SchedulerException, SasPasswordEncodingException {
        String debugStr;
        StringHolder assignedName;
        SealedString password;
        String keycomment;
        String flowname;
        block11: {
            super(workspace);
            this.m_scheduler = null;
            this.m_flow = null;
            this.m_username = null;
            this.m_outdir = null;
            this.m_file = null;
            this.m_fileref = null;
            this.m_filerefName = null;
            this.m_assignedref = null;
            this.m_rio = null;
            this.m_scode = new StringBuffer();
            this.m_incode = new StringBuffer();
            this.m_sascode = null;
            this.m_footer = false;
            this.m_scheduler = scheduler;
            this.m_flow = flow;
            this.m_outdir = dirpath;
            flowname = this.m_scheduler.genFlowName(flow);
            if (now) {
                flowname = scheduler.runNowName(flowname);
            }
            String control = "<!--These statements have been generated with SAS Scheduling API on \"{0}\". Modify at your own risk.  Changes may render the definition of \"{1}\" unusable.-->";
            GregorianCalendar date = new GregorianCalendar(Locale.US);
            ((Calendar)date).setTimeZone(TimeZone.getTimeZone("GMT"));
            SimpleDateFormat fmt = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy", Locale.US);
            Object[] args = new Object[]{fmt.format(date.getTime()), flowname};
            keycomment = MessageFormat.format(control, args);
            password = null;
            String encryption = System.getProperty("sas.sch.9.2compatibility");
            if (encryption != null) {
                password = new SealedString(SasPasswordString.encodeChars((String)"sas001", (char[])MessageFormat.format("{0}{1}", args).toCharArray()));
            } else {
                password = new SealedString(SasPasswordString.encodeChars((char[])MessageFormat.format("{0}{1}", args).toCharArray()));
                if ((password != null ? password.getCharacters().length : 0) > 260) {
                    password = new SealedString(SasPasswordString.encodeChars((String)"sas001", (char[])MessageFormat.format("{0}{1}", args).toCharArray()));
                }
            }
            this.m_rio = this.m_workspace.FileService();
            this.m_filerefName = "SCHTMPS";
            String physicalName = "";
            String accessMethodOrDevice = "TEMP";
            String hostOptions = "lrecl=1024";
            assignedName = new StringHolder(this.m_filerefName);
            debugStr = "";
            if (this.m_scheduler.isDebug()) {
                debugStr = PROC_DEBUG;
            }
            try {
                this.m_fileref = this.m_rio.AssignFileref(this.m_filerefName, accessMethodOrDevice, physicalName, hostOptions, assignedName);
                this.m_file = this.m_fileref.OpenBinaryStream(StreamOpenMode.StreamOpenModeForWriting);
            }
            catch (GenericError ge) {
                if (this.m_file == null) break block11;
                try {
                    this.m_file.Close();
                }
                catch (GenericError genericError) {
                    // empty catch block
                }
                this.m_file = null;
            }
        }
        this.m_scode.append("filename outdir \"" + this.m_outdir + "\";\n");
        if (this.m_file != null) {
            this.m_assignedref = assignedName.value;
            this.m_scode.append("Proc Scheduler PASSWORD=\"" + String.valueOf(password.getCharacters()) + "\" IN=" + this.m_assignedref + " OUT=outdir " + debugStr + ";\n");
        } else {
            this.m_scode.append("Proc Scheduler PASSWORD=\"" + String.valueOf(password.getCharacters()) + "\" OUT=outdir " + debugStr + ";\n");
        }
        this.quoteAndPrintXML("<xmlFlowDef Name=\"" + flowname + "\">\n", this.m_incode);
        this.quoteAndPrintXML(keycomment + "\n", this.m_incode);
    }

    public ProcScheduler(OSScheduler scheduler, IWorkspace workspace, String dirpath) {
        this(scheduler, null, workspace, dirpath);
    }

    public ProcScheduler(OSScheduler scheduler, FlowInfo flow, IWorkspace workspace, String dirpath) {
        String debugStr;
        StringHolder assignedName;
        block5: {
            super(workspace);
            this.m_scheduler = null;
            this.m_flow = null;
            this.m_username = null;
            this.m_outdir = null;
            this.m_file = null;
            this.m_fileref = null;
            this.m_filerefName = null;
            this.m_assignedref = null;
            this.m_rio = null;
            this.m_scode = new StringBuffer();
            this.m_incode = new StringBuffer();
            this.m_sascode = null;
            this.m_footer = false;
            this.m_scheduler = scheduler;
            this.m_flow = flow;
            this.m_outdir = dirpath;
            this.m_rio = this.m_workspace.FileService();
            this.m_filerefName = "SCHTMPH";
            String physicalName = "";
            String accessMethodOrDevice = "TEMP";
            String hostOptions = "";
            assignedName = new StringHolder(this.m_filerefName);
            debugStr = "";
            if (this.m_scheduler.isDebug()) {
                debugStr = PROC_DEBUG;
            }
            try {
                this.m_fileref = this.m_rio.AssignFileref(this.m_filerefName, accessMethodOrDevice, physicalName, hostOptions, assignedName);
            }
            catch (GenericError ge) {
                if (this.m_file == null) break block5;
                try {
                    this.m_file.Close();
                }
                catch (GenericError genericError) {
                    // empty catch block
                }
                this.m_file = null;
            }
        }
        this.m_scode.append("filename outdir \"" + this.m_outdir + "\";\n");
        this.m_scode.append("Proc Scheduler OUT=outdir " + debugStr + ";\n");
        this.m_assignedref = assignedName.value;
    }

    public ProcScheduler(String userName, OSScheduler scheduler, IWorkspace workspace, String dirpath) {
        super(workspace);
        this.m_scheduler = null;
        this.m_flow = null;
        this.m_username = null;
        this.m_outdir = null;
        this.m_file = null;
        this.m_fileref = null;
        this.m_filerefName = null;
        this.m_assignedref = null;
        this.m_rio = null;
        this.m_scode = new StringBuffer();
        this.m_incode = new StringBuffer();
        this.m_sascode = null;
        this.m_footer = false;
        this.m_scheduler = scheduler;
        this.m_username = userName;
        this.m_outdir = dirpath;
        String debugStr = "";
        if (this.m_scheduler.isDebug()) {
            debugStr = PROC_DEBUG;
        }
        this.m_scode.append("filename outdir \"" + this.m_outdir + "\";\n");
        this.m_scode.append("Proc Scheduler OUT=outdir " + debugStr + ";\n");
    }

    public boolean setOUTDir(String dir) {
        this.m_outdir = dir;
        return true;
    }

    public String getOUTDir() {
        return this.m_outdir;
    }

    public boolean processFlow() throws InvalidParameterException, SchedulerException {
        return this.processFlow(this.m_flow);
    }

    public String getSASCode() {
        return this.m_sascode;
    }

    public String getINFile() {
        if (this.m_file != null) {
            return this.m_incode.toString();
        }
        return null;
    }

    public String getSASLog() {
        return this.m_logLinesHolder.toString();
    }

    public String getSASListing() {
        return this.m_listLinesHolder.toString();
    }

    public long schedule(String flowname, String trigger) throws GenericError, UnsupportedEncodingException, SchedulerException {
        if (!this.m_footer) {
            this.quoteAndPrintXML("<!--Security control number: {" + this.m_flow.getId() + "} -->\n", this.m_incode);
            if (this.m_file == null) {
                this.quoteAndPrintXML("</xmlFlowDef>;\n", this.m_incode);
            } else {
                this.quoteAndPrintXML("</xmlFlowDef>\n", this.m_incode);
            }
            this.m_footer = true;
        }
        if (this.m_file == null) {
            this.m_scode.append("XMLSTREAM\n");
            this.m_scode.append(this.m_incode);
        } else {
            this.m_file.Write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n".getBytes());
            this.m_file.Write(this.m_incode.toString().getBytes("UTF8"));
            this.m_file.Close();
        }
        String priority = "";
        int p = this.m_flow.getJobDefaultPriority();
        switch (p) {
            case 0: {
                priority = "priority=top";
                break;
            }
            case 1: {
                priority = "priority=high";
                break;
            }
            case 2: {
                priority = "priority=normal";
                break;
            }
            case 3: {
                priority = "priority=medium";
                break;
            }
            case 4: {
                priority = "priority=low";
            }
        }
        SealedString passOption = new SealedString("");
        SealedString password = this.m_scheduler.getSchServerInfoPasswordSealedString();
        if (password != null && (password != null ? password.getCharacters() : "".toCharArray()).length > 0) {
            if (!SasPasswordString.isEncoded((String)String.valueOf(password.getCharacters()))) {
                try {
                    password = new SealedString(SasPasswordString.encode((String)String.valueOf(password.getCharacters())));
                }
                catch (SasPasswordEncodingException e) {
                    password = this.m_scheduler.getSchServerInfoPasswordSealedString();
                }
            }
            passOption = new SealedString(password != null ? String.valueOf(password.getCharacters()) : "");
        }
        if (trigger.equalsIgnoreCase("RunNow")) {
            this.m_scode.append("Schedule \"" + flowname + "\" / NOW password=\"" + String.valueOf(passOption.getCharacters()) + "\" " + priority + ";\n");
        } else if (!trigger.equalsIgnoreCase("Manual") && trigger.equalsIgnoreCase("Event")) {
            String options = "";
            if (passOption.getCharacters().length > 0 || priority.length() > 0) {
                options = "/ password=\"" + String.valueOf(passOption.getCharacters()) + "\" " + priority;
            }
            this.m_scode.append("Schedule \"" + flowname + "\"" + options + ";\n");
        }
        this.m_scode.append("run;\n");
        this.submitStatements(this.m_scode);
        this.m_sascode = this.m_scode.toString();
        int id = -2;
        return id;
    }

    public boolean remove(String flowname) throws SchedulerException {
        if (this.m_username != null) {
            this.m_scode.append("Remove \"" + flowname + "\" / user=\"" + this.m_username + "\";\n");
        } else {
            this.m_scode.append("Remove \"" + flowname + "\";\n");
        }
        this.m_scode.append("run;\n");
        this.submitStatements(this.m_scode);
        return this.m_status == 0 || this.m_status == 1;
    }

    public List<OSFlowHistory> getUserHistory(String username, int lastn) throws SchedulerException {
        if (lastn != 0) {
            this.m_scode.append("UserHistory \"" + username + "\" OUT=" + this.m_assignedref + "/ LASTN = " + lastn + ";\n");
        } else {
            this.m_scode.append("UserHistory \"" + username + "\" OUT=" + this.m_assignedref + ";\n");
        }
        this.m_scode.append("run;\n");
        this.submitStatements(this.m_scode);
        StringBuffer xml = new StringBuffer();
        try {
            byte[] buffer = new byte[1024];
            OctetSeqHolder holder = new OctetSeqHolder(buffer);
            this.m_file = this.m_fileref.OpenBinaryStream(StreamOpenMode.StreamOpenModeForReading);
            boolean eof = false;
            while (!eof) {
                this.m_file.Read(1024, holder);
                xml.append(new String(holder.value, "UTF8"));
                if (holder.value.length != 0) continue;
                eof = true;
            }
            this.m_file.Close();
        }
        catch (UnsupportedEncodingException uee) {
            if (this.m_file != null) {
                try {
                    this.m_file.Close();
                }
                catch (GenericError holder) {
                    // empty catch block
                }
                this.m_file = null;
            }
            SchedulerException se = new SchedulerException();
            se.initCause((Throwable)uee);
            throw se;
        }
        catch (GenericError ge) {
            if (this.m_file != null) {
                try {
                    this.m_file.Close();
                }
                catch (GenericError se) {
                    // empty catch block
                }
                this.m_file = null;
            }
            SchedulerException se = new SchedulerException();
            se.initCause((Throwable)ge);
            throw se;
        }
        return this.parseHistoryXML(xml.toString());
    }

    private List<OSFlowHistory> parseHistoryXML(String xml) throws SchedulerException {
        ArrayList<OSFlowHistory> list = new ArrayList<OSFlowHistory>();
        if (xml == null || xml.length() <= 0) {
            return list;
        }
        try {
            Document doc = GeneralUtilities.parseXML((String)xml);
            NodeList nodes = doc.getElementsByTagName("FlowHistory");
            int numNodes = nodes.getLength();
            for (int i = 0; i < numNodes; ++i) {
                long id = -2L;
                String flowName = null;
                String instanceName = null;
                int state = -1;
                int status = -1;
                Date startDate = null;
                Date finishDate = null;
                int errorCode = 0;
                Node node = nodes.item(i);
                NodeList cnodes = node.getChildNodes();
                int numCNodes = cnodes.getLength();
                for (int x = 0; x < numCNodes; ++x) {
                    GregorianCalendar calendar;
                    String timeString;
                    SchedulerException se;
                    String dayString;
                    String monthString;
                    String yearString;
                    Node dayNode;
                    NamedNodeMap attrs;
                    String stagname;
                    Node snode;
                    int seconds;
                    int minute;
                    int hour;
                    int day;
                    int month;
                    int year;
                    int numSNodes;
                    NodeList snodes;
                    Node cnode = cnodes.item(x);
                    String tagname = cnode.getNodeName();
                    if (tagname.compareTo("InstanceName") == 0) {
                        instanceName = cnode.getFirstChild().getNodeValue();
                        continue;
                    }
                    if (tagname.compareTo("FlowName") == 0) {
                        flowName = cnode.getFirstChild().getNodeValue();
                        continue;
                    }
                    if (tagname.compareTo("State") == 0) {
                        state = Integer.parseInt(cnode.getFirstChild().getNodeValue());
                        continue;
                    }
                    if (tagname.compareTo("Status") == 0) {
                        status = Integer.parseInt(cnode.getFirstChild().getNodeValue());
                        continue;
                    }
                    if (tagname.compareTo("StartTime") == 0) {
                        snodes = cnode.getChildNodes();
                        numSNodes = snodes.getLength();
                        year = 0;
                        month = 0;
                        day = 0;
                        hour = 0;
                        minute = 0;
                        seconds = 0;
                        for (int y = 0; y < numSNodes; ++y) {
                            int secondColon;
                            snode = snodes.item(y);
                            stagname = snode.getNodeName();
                            if (stagname.compareTo("date") == 0) {
                                attrs = snode.getAttributes();
                                Node yearNode = attrs.getNamedItem("year");
                                Node monthNode = attrs.getNamedItem("month");
                                dayNode = attrs.getNamedItem("day");
                                if (yearNode == null || monthNode == null || dayNode == null) continue;
                                try {
                                    yearString = yearNode.getNodeValue();
                                    monthString = monthNode.getNodeValue();
                                    dayString = dayNode.getNodeValue();
                                    year = Integer.parseInt(yearString);
                                    month = Integer.parseInt(monthString) - 1;
                                    day = Integer.parseInt(dayString);
                                    continue;
                                }
                                catch (NumberFormatException e) {
                                    se = new SchedulerException();
                                    se.initCause((Throwable)e);
                                    throw se;
                                }
                            }
                            if (stagname.compareTo("time") != 0) continue;
                            timeString = snode.getFirstChild().getNodeValue();
                            int firstColon = timeString.indexOf(58);
                            if (firstColon > 0) {
                                hour = Integer.parseInt(timeString.substring(0, firstColon));
                            }
                            if ((secondColon = timeString.indexOf(58, firstColon + 1)) <= 0) continue;
                            minute = Integer.parseInt(timeString.substring(firstColon + 1, secondColon));
                            seconds = Integer.parseInt(timeString.substring(secondColon + 1));
                        }
                        calendar = new GregorianCalendar();
                        calendar.set(year, month, day, hour, minute, seconds);
                        startDate = calendar.getTime();
                        continue;
                    }
                    if (tagname.compareTo("FinishTime") == 0) {
                        snodes = cnode.getChildNodes();
                        numSNodes = snodes.getLength();
                        year = 0;
                        month = 0;
                        day = 0;
                        hour = 0;
                        minute = 0;
                        seconds = 0;
                        for (int y = 0; y < numSNodes; ++y) {
                            int secondColon;
                            snode = snodes.item(y);
                            stagname = snode.getNodeName();
                            if (stagname.compareTo("date") == 0) {
                                attrs = snode.getAttributes();
                                Node yearNode = attrs.getNamedItem("year");
                                Node monthNode = attrs.getNamedItem("month");
                                dayNode = attrs.getNamedItem("day");
                                if (yearNode == null || monthNode == null || dayNode == null) continue;
                                try {
                                    yearString = yearNode.getNodeValue();
                                    monthString = monthNode.getNodeValue();
                                    dayString = dayNode.getNodeValue();
                                    year = Integer.parseInt(yearString);
                                    month = Integer.parseInt(monthString) - 1;
                                    day = Integer.parseInt(dayString);
                                    continue;
                                }
                                catch (NumberFormatException e) {
                                    se = new SchedulerException();
                                    se.initCause((Throwable)e);
                                    throw se;
                                }
                            }
                            if (stagname.compareTo("time") != 0) continue;
                            timeString = snode.getFirstChild().getNodeValue();
                            int firstColon = timeString.indexOf(58);
                            if (firstColon > 0) {
                                hour = Integer.parseInt(timeString.substring(0, firstColon));
                            }
                            if ((secondColon = timeString.indexOf(58, firstColon + 1)) <= 0) continue;
                            minute = Integer.parseInt(timeString.substring(firstColon + 1, secondColon));
                            seconds = Integer.parseInt(timeString.substring(secondColon + 1));
                        }
                        calendar = new GregorianCalendar();
                        calendar.set(year, month, day, hour, minute, seconds);
                        finishDate = calendar.getTime();
                        continue;
                    }
                    if (tagname.compareTo("ErrorCode") != 0) continue;
                    errorCode = Integer.parseInt(cnode.getFirstChild().getNodeValue());
                }
                OSFlowHistory hist = new OSFlowHistory(id, flowName, instanceName, state, status, startDate, finishDate, errorCode);
                list.add(hist);
            }
        }
        catch (NullPointerException npe) {
            SchedulerException se = new SchedulerException();
            se.initCause((Throwable)npe);
            throw se;
        }
        catch (RuntimeException rte) {
            SchedulerException se = new SchedulerException();
            se.initCause((Throwable)rte);
            throw se;
        }
        return list;
    }

    public List<OSFlowHistory> getHistory(String flowname, int lastn) throws SchedulerException {
        StringBuffer xml;
        block10: {
            if (lastn != 0) {
                this.m_scode.append("FlowHistory \"" + flowname + "\" OUT=" + this.m_assignedref + "/ LASTN = " + lastn + ";\n");
            } else {
                this.m_scode.append("FlowHistory \"" + flowname + "\" OUT=" + this.m_assignedref + ";\n");
            }
            this.m_scode.append("run;\n");
            this.submitStatements(this.m_scode);
            xml = new StringBuffer();
            try {
                byte[] buffer = new byte[1024];
                OctetSeqHolder holder = new OctetSeqHolder(buffer);
                this.m_file = this.m_fileref.OpenBinaryStream(StreamOpenMode.StreamOpenModeForReading);
                boolean eof = false;
                while (!eof) {
                    this.m_file.Read(1024, holder);
                    xml.append(new String(holder.value, "UTF8"));
                    if (holder.value.length != 0) continue;
                    eof = true;
                }
                this.m_file.Close();
            }
            catch (UnsupportedEncodingException uee) {
                if (this.m_file == null) break block10;
                try {
                    this.m_file.Close();
                }
                catch (GenericError genericError) {
                    // empty catch block
                }
                this.m_file = null;
            }
            catch (GenericError ge) {
                if (this.m_file == null) break block10;
                try {
                    this.m_file.Close();
                }
                catch (GenericError genericError) {
                    // empty catch block
                }
                this.m_file = null;
            }
        }
        return this.parseHistoryXML(xml.toString());
    }

    public void dispose() {
        if (this.m_rio != null) {
            if (this.m_filerefName != null) {
                try {
                    this.m_rio.DeassignFileref(this.m_filerefName);
                }
                catch (GenericError genericError) {
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                this.m_filerefName = null;
                this.m_fileref = null;
            }
            this.m_rio = null;
        }
    }

    private boolean processFlow(FlowInfo flow) throws InvalidParameterException, SchedulerException {
        Vector<JobDefinitionInfo> jobDefs = new Vector<JobDefinitionInfo>();
        List jobs = flow.getJobs();
        for (int i = 0; i < jobs.size(); ++i) {
            DisplayInfo job = (DisplayInfo)jobs.get(i);
            JobDefinitionInfo definition = this.processStep(job);
            jobDefs.add(definition);
        }
        this.quoteAndPrintXML("<FlowDef  Name=\"" + flow.getName() + "\" Description=\"" + flow.getDescription() + "\" >\n", this.m_incode);
        this.quoteAndPrintXML("<ExecutionType Value=\"" + this.m_scheduler.getSubtype() + "\"/>\n", this.m_incode);
        int jobDefsize = jobDefs.size();
        for (int i = 0; i < jobDefsize; ++i) {
            String xml = ((JobDefinitionInfo)jobDefs.get(i)).generateXML();
            if (xml == null) continue;
            this.quoteAndPrintXML(xml, this.m_incode);
        }
        TriggerEventInfo t = this.m_flow.getTriggerEvent();
        if (t != null) {
            ArrayList<AbstractEventInfo> triggers = null;
            AbstractEventInfo event = t.getEvent();
            if (event instanceof GroupingEventInfo) {
                GroupingEventInfo group = (GroupingEventInfo)event;
                triggers = group.getDependencies2();
                if (group.getEventType() == 0) {
                    this.quoteAndPrintXML("<TriggerEvents CombinationType=\"And\">\n", this.m_incode);
                } else {
                    this.quoteAndPrintXML("<TriggerEvents CombinationType=\"Or\">\n", this.m_incode);
                }
            } else if (event instanceof TimeEventInfo || event instanceof FileEventInfo) {
                this.quoteAndPrintXML("<TriggerEvents CombinationType=\"And\">\n", this.m_incode);
                triggers = new ArrayList<AbstractEventInfo>(1);
                triggers.add(t.getEvent());
            }
            int count = triggers != null ? triggers.size() : 0;
            for (int i = 0; i < count; ++i) {
                String xml;
                AbstractEventInfo info = (AbstractEventInfo)triggers.get(i);
                if (info != null) {
                    xml = null;
                    if (info instanceof TimeEventInfo) {
                        TimeEventInfo tei = (TimeEventInfo)info;
                        tei.setTimezone(null);
                        tei.setOccur(-1);
                        tei.setDescription("");
                        xml = tei.generateXML();
                    } else if (info instanceof FileEventInfo) {
                        xml = ((FileEventInfo)info).generateXML();
                    }
                    if (xml != null) {
                        this.quoteAndPrintXML(xml, this.m_incode);
                        continue;
                    }
                    xml = "<!-- " + MessageUtil.messageString((String)m_bundle.getString("ProcScheduler.UnknownEvent.fmt"), (Object)m_bundle.getString("ProcScheduler.XML.Warning.tag.txt"), (Object)t.toString()) + " -->\n";
                    this.quoteAndPrintXML(xml, this.m_incode);
                    continue;
                }
                xml = "<!-- " + MessageUtil.messageString((String)m_bundle.getString("ProcScheduler.UnsupportedEvent.fmt"), (Object)m_bundle.getString("ProcScheduler.XML.Warning.tag.txt"), (Object)t.toString()) + " -->\n";
                this.quoteAndPrintXML(xml, this.m_incode);
            }
            if (triggers != null) {
                this.quoteAndPrintXML("</TriggerEvents>\n", this.m_incode);
            }
        }
        for (int i = 0; i < jobDefsize; ++i) {
            String xml;
            JobDefinitionInfo jobdef = (JobDefinitionInfo)jobDefs.get(i);
            jobdef.setDescription("");
            AbstractEventInterface aei = jobdef.getDependency();
            if (aei instanceof TimeEventInfo) {
                ((TimeEventInfo)aei).setTimezone(null);
                ((TimeEventInfo)aei).setOccur(-1);
            }
            if ((xml = jobdef.generateDependenciesXML()) == null) continue;
            this.quoteAndPrintXML(xml, this.m_incode);
        }
        this.quoteAndPrintXML("</FlowDef>\n", this.m_incode);
        return true;
    }

    private void quoteAndPrintXML(String xml, StringBuffer buffer) {
        if (this.m_file == null) {
            boolean newlineAtEnd = false;
            int strlen = xml.length();
            buffer.append("'");
            for (int j = 0; j < strlen; ++j) {
                if (xml.charAt(j) == '\n') {
                    if (j == strlen - 1) continue;
                    newlineAtEnd = true;
                    buffer.append("'\n'");
                    continue;
                }
                buffer.append(xml.charAt(j));
            }
            if (newlineAtEnd) {
                buffer.append("'\n");
            } else {
                buffer.append("'");
            }
        } else {
            buffer.append(xml);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private JobDefinitionInfo processStep(DisplayInfo info) throws InvalidParameterException, SchedulerException {
        JobDefinitionInfo definition = null;
        if (info instanceof FlowInfo) {
            if (!this.processFlow((FlowInfo)info)) return null;
            String jobname = this.m_flow.getName() + ":" + info.getName() + "{" + info.getId() + "}";
            definition = new JobDefinitionInfo(jobname, 1, info.getName(), null);
        } else if (info instanceof JobInfo) {
            int os;
            JobInfo job = (JobInfo)info;
            String cmdline = job.getCommandLine();
            String userid = job.getUserId();
            int n = os = job.getBatchServer() != null ? job.getBatchServer().getOperatingSystem() : -1;
            if (cmdline != null && cmdline.length() != 0) {
                String jobname = this.m_flow.getName() + ":" + info.getName() + "{" + info.getId() + "}";
                definition = new JobDefinitionInfo(jobname, 0, cmdline, userid);
            } else {
                if (os != 2) throw new SchedulerException(MessageUtil.messageString((String)m_bundle.getString("ProcScheduler.SchedulingDetailsError.fmt"), (Object)job.getName()));
                String fname = job.getSourceFile();
                String filepath = job.getBatchServer().getJCLDirectory();
                String physicalName = CommandUtilities.createFullPath(filepath, fname, 2);
                this.m_scheduler.writeJCLFile(job, physicalName, this.m_workspace);
                String jobname = this.m_flow.getName() + ":" + info.getName() + "{" + info.getId() + "}";
                definition = new JobDefinitionInfo(jobname, 0, cmdline, userid);
            }
        }
        AbstractEventInfo event = this.m_flow.getEvent(info.getId());
        if (!(event instanceof AbstractEventInterface)) return definition;
        definition.addDependency((AbstractEventInterface)event);
        return definition;
    }

    @Override
    public void submitStatements(StringBuffer statements) throws SchedulerException {
        super.submitStatements(statements);
        String warningXML = null;
        String xml = this.m_incode.toString();
        int i = xml.indexOf(m_bundle.getString("ProcScheduler.XML.Warning.tag.txt"));
        if (i > 0) {
            warningXML = xml.substring(i);
            i = warningXML.indexOf("-->");
            warningXML = warningXML.substring(0, i);
        }
        if (this.m_status == 1 && warningXML != null) {
            this.setStatus(1, this.m_2ndStatusMsg + "\n" + warningXML + "\n" + m_bundle.getString("ProcScheduler.Status.Warning.txt"));
            UnsupportedOperationException ex = new UnsupportedOperationException(this.m_statusMsg);
            throw ex;
        }
        if (this.m_status == 1 && warningXML == null) {
            this.setStatus(1, this.m_2ndStatusMsg + "\n" + m_bundle.getString("ProcScheduler.Status.Warning.txt"));
            UnsupportedOperationException ex = new UnsupportedOperationException(this.m_statusMsg);
            throw ex;
        }
        if (this.m_status != 1 && warningXML != null) {
            this.setStatus(1, warningXML + "\n" + m_bundle.getString("ProcScheduler.Status.Warning.txt"));
            UnsupportedOperationException ex = new UnsupportedOperationException(this.m_statusMsg);
            throw ex;
        }
    }

    static {
        String strClassName = ProcScheduler.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
    }
}

