/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.sasjfs.floworchestration;

import com.sas.scheduler.api.servers.sasjfs.SASJFSFlowHistory;
import com.sas.scheduler.api.servers.sasjfs.engine.SASJFSProperties;
import com.sas.scheduler.api.servers.sasjfs.floworchestration.ExecutionItem;
import com.sas.scheduler.api.servers.sasjfs.floworchestration.FlowDepChecker;
import com.sas.scheduler.api.servers.sasjfs.floworchestration.FlowOrchestrator;
import com.sas.scheduler.api.servers.sasjfs.floworchestration.FlowRunner;
import com.sas.scheduler.api.servers.sasjfs.floworchestration.FlowRunnerFactory;
import com.sas.scheduler.api.servers.sasjfs.floworchestration.JFOrchClient;
import com.sas.scheduler.api.servers.sasjfs.floworchestration.JobDepChecker;
import com.sas.scheduler.api.servers.sasjfs.floworchestration.SASJFSJobInfo;
import com.sas.scheduler.api.servers.sasjfs.floworchestration.TimeDepExpressionChecker;
import com.sas.scheduler.api.servers.sasjfs.mq.JMSClientSupport;
import com.sas.scheduler.model.AbstractEventInfo;
import com.sas.scheduler.model.DisplayInfo;
import com.sas.scheduler.model.FileEventInfo;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.GroupingEventInfo;
import com.sas.scheduler.model.JobDependency;
import com.sas.scheduler.model.JobEventInfo;
import com.sas.scheduler.model.JobInfo;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.TimeEventInfo;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FlowManager
implements Runnable {
    private Object _syncLockObject;
    private static final Logger LOGGER = LogManager.getLogger(FlowOrchestrator.class);
    private String _flowId;
    private String _user;
    private String _flowInstanceId;
    private FlowInfo _flowInfo;
    private List<FlowInfo> _flowsList;
    private volatile HashMap<String, FlowInfo> _completedFlows;
    private volatile HashMap<String, FlowInfo> _suspendedFlows;
    private volatile HashMap<String, SASJFSFlowHistory> _completedFlowHistories;
    private volatile HashMap<String, SASJFSJobInfo> _completedJobs;
    private volatile HashMap<String, ExecutionItem> _completedItems;
    private volatile HashMap<String, SASJFSJobInfo> _runningJobs;
    private SASJFSProperties _props;
    private JFOrchClient _jFOrchClient;
    private HashMap<String, AbstractEventInfo> _flowsWithDeps;

    private void initialize() {
        this._syncLockObject = new Object();
        this._flowsList = new ArrayList<FlowInfo>();
        this._completedFlows = new HashMap();
        this._suspendedFlows = new HashMap();
        this._completedFlowHistories = new HashMap();
        this._completedJobs = new HashMap();
        this._completedItems = new HashMap();
        this._runningJobs = new HashMap();
        this._flowsWithDeps = new HashMap();
        this._flowInstanceId = Long.toString(System.currentTimeMillis());
        this._props = new SASJFSProperties();
    }

    public FlowManager(String flowId, JFOrchClient client, Boolean runNow) {
        this.initialize();
        this._flowId = flowId;
        this._jFOrchClient = client;
        if (this._flowId.isEmpty()) {
            throw new InvalidParameterException("flowId value cannot be null or empty in FlowManager.");
        }
        try {
            this._flowInfo = this.getFlowInfo(this._flowId, runNow);
        }
        catch (IOException e) {
            throw new InvalidParameterException("flowId value cannot retrieve flow.");
        }
        this._user = this.getUserName();
    }

    private FlowInfo getFlowInfo(String flowDefId, Boolean runNow) throws IOException {
        FlowInfo flowInfo = null;
        try {
            flowInfo = this._jFOrchClient.getFlowInfo(flowDefId, this._flowInstanceId, runNow);
            flowInfo.setFlowDefinitionIdDataBinding(flowDefId);
            this._props = this._jFOrchClient.getFlowProperties();
        }
        catch (Exception e) {
            LOGGER.error(e.toString());
            e.printStackTrace();
        }
        return flowInfo;
    }

    @Override
    public void run() {
        List flowItems = this._flowInfo.getJobs();
        if (flowItems.isEmpty()) {
            throw new InvalidParameterException("flowItems cannot be null or empty in FlowManager.");
        }
        this._flowsList.clear();
        this._flowsList.add(0, this._flowInfo);
        this.buildFlowsList(flowItems);
        this.buildFlowDependenciesMap();
        for (FlowInfo flowInfo : this._flowsList) {
            FlowRunnerFactory frFactory = new FlowRunnerFactory();
            FlowManagerCallback callback = new FlowManagerCallback();
            FlowRunner flowRunner = frFactory.getInstance(flowInfo, this._props, this._flowInstanceId, this._flowInfo.getScheduler(), JMSClientSupport.getAuthorizationToken(this._flowInfo, this._user, this._jFOrchClient), callback);
            if (this._flowsWithDeps.containsKey(flowInfo.getId())) {
                flowRunner._hasDependencies = true;
            }
            Thread flowRunnerThread = new Thread(flowRunner);
            LOGGER.debug("Starting Flow Runner on thread ID: " + flowRunnerThread.getId() + " for Flow named: " + flowInfo.getName());
            flowRunnerThread.start();
        }
        int numCompletedFlows = this._completedFlows.size();
        int numFlows = this._flowsList.size();
        while (numCompletedFlows != numFlows) {
            LOGGER.debug(String.format("FlowManager sleeping 10s     Waiting for flows to complete: total numFlows: %d     numCompletedFlows = %d", numFlows, numCompletedFlows));
            this.sleepThread(10000);
            numCompletedFlows = this._completedFlows.size() + this._suspendedFlows.size();
        }
    }

    private void buildFlowsList(List<DisplayInfo> rootFlowItems) {
        for (DisplayInfo item : rootFlowItems) {
            if (!(item instanceof FlowInfo)) continue;
            this.buildFlowsList(((FlowInfo)item).getJobs());
            this._flowsList.add((FlowInfo)item);
        }
    }

    private void buildFlowDependenciesMap() {
        List flowDeps = this._flowInfo.getJobDependenciesDataBinding();
        String eventName = "";
        for (JobDependency dep : flowDeps) {
            AbstractEventInfo aei = dep.getEvent();
            if (aei == null) continue;
            String depTarget = "";
            AbstractEventInfo info = dep.getEvent();
            if (info instanceof GroupingEventInfo) {
                GroupingEventInfo gei = (GroupingEventInfo)info;
                depTarget = gei.getTargetDataBinding().getIdDataBinding();
                eventName = gei.getTargetDataBinding().getNameDataBinding();
            } else if (info instanceof JobEventInfo) {
                JobEventInfo jei = (JobEventInfo)info;
                depTarget = dep.getNodeId();
                eventName = jei.getNameDataBinding();
            } else if (info instanceof TimeEventInfo) {
                TimeEventInfo tei = (TimeEventInfo)info;
                depTarget = dep.getNodeId();
                eventName = tei.getNameDataBinding();
            }
            FlowInfo flowInfoTarget = null;
            for (FlowInfo flowInfo : this._flowsList) {
                if (!depTarget.equals(flowInfo.getName())) continue;
                flowInfoTarget = flowInfo;
            }
            this._flowsWithDeps.put(depTarget, aei);
        }
    }

    private void sleepThread(int i) {
        try {
            Thread.sleep(i);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private String getUserName() {
        String userName = "";
        String osName = System.getProperty("os.name").toLowerCase();
        try {
            if (osName.contains("windows")) {
                Class<?> c = Class.forName("com.sun.security.auth.module.NTSystem");
                Method method = c.getDeclaredMethod("getName", new Class[0]);
                Object o = c.newInstance();
                userName = this.getDomainName() + "\\" + (String)method.invoke(o, new Object[0]);
            } else if (osName.contains("linux")) {
                Class<?> c = Class.forName("com.sun.security.auth.module.UnixSystem");
                Method method = c.getDeclaredMethod("getUsername", new Class[0]);
                Object o = c.newInstance();
                userName = (String)method.invoke(o, new Object[0]);
            } else if (osName.contains("solaris") || osName.contains("sunos")) {
                Class<?> c = Class.forName("com.sun.security.auth.module.SolarisSystem");
                Method method = c.getDeclaredMethod("getUsername", new Class[0]);
                Object o = c.newInstance();
                userName = (String)method.invoke(o, new Object[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LOGGER.debug(String.format("Running flow as user: %s", userName));
        return userName;
    }

    private String getDomainName() {
        String domainName = "";
        try {
            Class<?> c = Class.forName("com.sun.security.auth.module.NTSystem");
            Method method = c.getDeclaredMethod("getDomain", new Class[0]);
            Object o = c.newInstance();
            domainName = (String)method.invoke(o, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return domainName;
    }

    protected class FlowManagerCallback {
        protected FlowManagerCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void callbackFlowCompleted(FlowInfo flowInfo, SASJFSFlowHistory sasJFSFlowHistory, int exitCodeSum) {
            String flowName = flowInfo.getName();
            sasJFSFlowHistory.setFlowName(flowName);
            sasJFSFlowHistory.setFinishTime(new Date());
            sasJFSFlowHistory.setID(new Long(FlowManager.this._flowInstanceId));
            sasJFSFlowHistory.setErrorCode(exitCodeSum);
            Object object = FlowManager.this._syncLockObject;
            synchronized (object) {
                if (!sasJFSFlowHistory.isSuspended()) {
                    LOGGER.debug(String.format("Received callback for completed Flow named: %s", flowName));
                    FlowManager.this._completedFlows.put(flowName, flowInfo);
                    LOGGER.debug(String.format("numCompletedFlows = %d", FlowManager.this._completedFlows.size()));
                    FlowManager.this._completedFlowHistories.put(flowName, sasJFSFlowHistory);
                } else {
                    LOGGER.debug(String.format("Received callback for suspended Flow named: %s", flowName));
                    FlowManager.this._suspendedFlows.put(flowName, flowInfo);
                }
            }
            this.setFlowHistory(sasJFSFlowHistory);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public HashMap<String, SASJFSFlowHistory> getCompletedFlowHistories() {
            Object object = FlowManager.this._syncLockObject;
            synchronized (object) {
                return FlowManager.this._completedFlowHistories;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public HashMap<String, FlowInfo> getSuspendedFlows() {
            Object object = FlowManager.this._syncLockObject;
            synchronized (object) {
                return FlowManager.this._suspendedFlows;
            }
        }

        private boolean setFlowHistory(SASJFSFlowHistory sasJFSFlowHistory) {
            boolean isHistoryCommited = false;
            isHistoryCommited = FlowManager.this._jFOrchClient.setFlowHistory(FlowManager.this._flowId, sasJFSFlowHistory.toSerializedForm(), FlowManager.this._flowInstanceId);
            return isHistoryCommited;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isFlowCompleted(String flowName) {
            Object object = FlowManager.this._syncLockObject;
            synchronized (object) {
                FlowInfo flowInfo;
                boolean retval = false;
                if (flowName.indexOf(":") != -1) {
                    flowName = flowName.substring(flowName.lastIndexOf(":") + 1);
                }
                retval = (flowInfo = (FlowInfo)FlowManager.this._completedFlows.get(flowName)) != null;
                return retval;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void callbackJobCompleted(ExecutionItem executionItem, String jobName) {
            Object object = FlowManager.this._syncLockObject;
            synchronized (object) {
                LOGGER.debug(String.format("Received callback for completed Job named: %s", jobName));
                FlowManager.this._completedJobs.put(jobName, executionItem._sasJFSJobInfo);
                FlowManager.this._completedItems.put(jobName, executionItem);
                FlowManager.this._runningJobs.remove(jobName);
                FlowManager.this._jFOrchClient.removeRunningJobInstance(FlowManager.this._flowId, executionItem._jobId);
                FlowManager.this._jFOrchClient.setJobHistory(FlowManager.this._flowInstanceId, executionItem._sasJFSJobInfo);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void callbackJobRunning(ExecutionItem executionItem, String jobName) {
            Object object = FlowManager.this._syncLockObject;
            synchronized (object) {
                FlowManager.this._runningJobs.put(jobName, executionItem._sasJFSJobInfo);
                FlowManager.this._jFOrchClient.addRunningJobInstance(FlowManager.this._flowId, executionItem._jobId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isJobCompleted(String jobName) {
            Object object = FlowManager.this._syncLockObject;
            synchronized (object) {
                boolean retval = false;
                SASJFSJobInfo jobInfo = (SASJFSJobInfo)FlowManager.this._completedJobs.get(jobName);
                retval = jobInfo != null;
                return retval;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isDependenciesMet(FlowInfo subflow) {
            Object object = FlowManager.this._syncLockObject;
            synchronized (object) {
                AbstractEventInfo aei = (AbstractEventInfo)FlowManager.this._flowsWithDeps.get(subflow.getId());
                if (aei != null) {
                    return this.checkDependency(subflow, aei, new ArrayList<String>());
                }
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isDependenciesNeverMet(FlowInfo subflow) {
            Object object = FlowManager.this._syncLockObject;
            synchronized (object) {
                ArrayList<String> depCannotResolve;
                boolean isMet;
                AbstractEventInfo aei = (AbstractEventInfo)FlowManager.this._flowsWithDeps.get(subflow.getId());
                return aei != null && !(isMet = this.checkDependency(subflow, aei, depCannotResolve = new ArrayList<String>())) && depCannotResolve.contains(subflow.getName());
                {
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int checkDependencies(FlowInfo subflow) {
            Object object = FlowManager.this._syncLockObject;
            synchronized (object) {
                AbstractEventInfo aei = (AbstractEventInfo)FlowManager.this._flowsWithDeps.get(subflow.getId());
                if (aei != null) {
                    ArrayList<String> depCannotResolve = new ArrayList<String>();
                    boolean isMet = this.checkDependency(subflow, aei, depCannotResolve);
                    if (isMet) {
                        return 1;
                    }
                    if (depCannotResolve.contains(subflow.getName())) {
                        return -1;
                    }
                    return 0;
                }
                return 1;
            }
        }

        private boolean checkDependency(FlowInfo subflow, AbstractEventInfo aei, List<String> depCannotResolve) {
            ArrayList<ExecutionItem> runningItems = null;
            if (aei instanceof GroupingEventInfo) {
                boolean rc = false;
                GroupingEventInfo gei = (GroupingEventInfo)aei;
                List events = gei.getEvents();
                int condition = gei.getConditionDataBinding();
                Iterator it = events.iterator();
                switch (condition) {
                    case 0: {
                        while (it.hasNext()) {
                            rc = this.checkDependency(subflow, (AbstractEventInfo)it.next(), depCannotResolve);
                            if (rc) continue;
                            return false;
                        }
                        return true;
                    }
                }
                while (it.hasNext()) {
                    rc = this.checkDependency(subflow, (AbstractEventInfo)it.next(), depCannotResolve);
                    if (!rc) continue;
                    return true;
                }
                return false;
            }
            if (aei instanceof JobEventInfo) {
                JobEventInfo jei = (JobEventInfo)aei;
                JobInfo job = jei.getJobInfo();
                if (job.isSubflow()) {
                    String subflowName = job.getName();
                    FlowDepChecker subflowDepChecker = new FlowDepChecker(job.getName(), jei, this.getCompletedFlowHistories());
                    boolean hasRun = this.isFlowCompleted(subflowName);
                    boolean rc = subflowDepChecker.evalJobExpression();
                    if (hasRun && !rc && !depCannotResolve.contains(subflow.getName())) {
                        depCannotResolve.add(subflow.getName());
                    }
                    return rc;
                }
                ArrayList<ExecutionItem> completedItems = new ArrayList<ExecutionItem>(FlowManager.this._completedItems.values());
                String parentName = this.getParentName(job.getName(), subflow.getName());
                String fullName = FlowManager.this._flowInstanceId + ":" + parentName + ":" + job.getName();
                JobDepChecker jobDepChecker = new JobDepChecker(job.getName(), fullName, jei, runningItems, completedItems);
                String jeiJobName = jei.getJobInfo().getName();
                boolean hasRun = false;
                if (jobDepChecker._depHistory != null) {
                    hasRun = true;
                }
                parentName = this.getParentName(jeiJobName, subflow.getName());
                fullName = FlowManager.this._flowInstanceId + ":" + parentName + ":" + jeiJobName;
                boolean rc = jobDepChecker.evalJobExpression(fullName);
                if (hasRun && !rc && !depCannotResolve.contains(subflow.getName())) {
                    depCannotResolve.add(subflow.getName());
                }
                return rc;
            }
            if (aei instanceof TimeEventInfo) {
                TimeEventInfo tei = (TimeEventInfo)aei;
                TimeDepExpressionChecker timeDepChecker = new TimeDepExpressionChecker(subflow.getName(), tei, runningItems, null, (Calendar)null);
                try {
                    return timeDepChecker.evalTimeExpression();
                }
                catch (SchedulerException e) {
                    LOGGER.error(e.getMessage());
                    LOGGER.debug(e.getStackTrace()[0].toString());
                }
            } else if (aei instanceof FileEventInfo) {
                return true;
            }
            return false;
        }

        private String getParentName(String jobName, String subFlowName) {
            for (int i = 0; i < FlowManager.this._flowsList.size(); ++i) {
                FlowInfo flow = (FlowInfo)FlowManager.this._flowsList.get(i);
                List jobs = flow.getJobs();
                Iterator it = jobs.iterator();
                boolean notFound = true;
                boolean foundJob = false;
                boolean foundSubflow = false;
                while (notFound && it.hasNext()) {
                    DisplayInfo job = (DisplayInfo)it.next();
                    if (job instanceof JobInfo && !((JobInfo)job).isSubflow()) {
                        if (job.getName().equals(jobName)) {
                            foundJob = true;
                        }
                    } else if (job.getName().equals(subFlowName)) {
                        foundSubflow = true;
                    }
                    if (!foundJob || !foundSubflow) continue;
                    return flow.getName();
                }
            }
            return "";
        }
    }
}

