/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip.engine.mq.client;

import com.sas.scheduler.api.servers.ip.engine.mq.client.OutputWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class QueueOutputStream
extends ByteArrayOutputStream {
    private OutputWriter mWriter;
    private String mStreamType;
    private String mRendevousID;
    private String mOutputName;
    private int mQueueBufferSize;
    private long mOutputLimit;
    private long mOutputCaptured;
    private boolean mStreamClosing = false;

    public QueueOutputStream(OutputWriter queueWriter, String streamType, String rendevousID, String outputAreaName, int bufferSize, long outputLimit) {
        this.mWriter = queueWriter;
        this.mStreamType = streamType;
        this.mRendevousID = rendevousID;
        this.mOutputName = outputAreaName;
        this.mQueueBufferSize = bufferSize;
        this.mOutputLimit = outputLimit;
        this.mOutputCaptured = 0L;
    }

    @Override
    public synchronized void write(byte[] arg0, int arg1, int arg2) {
        super.write(arg0, arg1, arg2);
        this.flushIfNecessary(false);
    }

    @Override
    public synchronized void write(int arg0) {
        super.write(arg0);
        this.flushIfNecessary(false);
    }

    private void flushIfNecessary(boolean force) {
        byte[] bytes;
        boolean streamClosing = this.mStreamClosing;
        if (!(streamClosing || this.mOutputCaptured < this.mOutputLimit && this.mOutputLimit > 0L)) {
            this.reset();
            return;
        }
        if ((this.size() > this.mQueueBufferSize || force || streamClosing) && (bytes = this.toByteArray()).length > 0) {
            this.mOutputCaptured += (long)bytes.length;
            this.reset();
            this.mWriter.write(bytes, this.mStreamType, this.mRendevousID, this.mOutputName);
        }
    }

    @Override
    public void flush() throws IOException {
        super.flush();
        this.flushIfNecessary(true);
    }

    @Override
    public void close() throws IOException {
        this.flushIfNecessary(false);
        this.mStreamClosing = true;
        if (this.mOutputCaptured > 0L || this.size() > 0) {
            String endMessage = "<Job output end>";
            if (this.mOutputCaptured > this.mOutputLimit) {
                endMessage = "<Job output truncated by job renderer (exceeded renderer limit)>";
            }
            this.write(endMessage.getBytes());
        }
        this.flushIfNecessary(true);
        super.close();
    }

    public long getOutputLimit() {
        return this.mOutputLimit;
    }

    public void setOutputLimit(long outputLimit) {
        this.mOutputLimit = outputLimit;
    }
}

