/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip.engine.mq.client;

import com.sas.scheduler.api.servers.ip.engine.Job;
import com.sas.scheduler.api.servers.ip.engine.mq.client.ILoadBalancer;
import com.sas.scheduler.api.servers.ip.engine.mq.client.ILoadBalancerRunningJobsInfo;

public class DefaultLoadBalancer
implements ILoadBalancer {
    protected int mMaxJobs;
    protected long mBaseWait;
    protected long mMaxWait;
    protected int mJobsBeforeBackoff;
    protected ILoadBalancerRunningJobsInfo mClientSupport;

    public DefaultLoadBalancer(int maxJobs, long baseWaitMS, long maxWait, int jobsBeforeBackoff) {
        this.mMaxJobs = Math.max(1, maxJobs);
        this.mBaseWait = Math.max(500L, baseWaitMS);
        this.mMaxWait = Math.max(5000L, maxWait);
        this.mJobsBeforeBackoff = Math.max(1, jobsBeforeBackoff);
    }

    @Override
    public long getWaitTime(Job j) {
        int jobCount = this.mClientSupport.getCurrentJobCount();
        if (this.mMaxJobs > 0 && jobCount >= this.mMaxJobs) {
            return -1L;
        }
        if (jobCount <= this.mJobsBeforeBackoff) {
            return 0L;
        }
        return Math.min(this.mMaxWait, this.mBaseWait * (long)jobCount);
    }

    @Override
    public boolean canTakeOnWork() {
        if (this.mMaxJobs < 0) {
            return false;
        }
        int jobCount = this.mClientSupport.getCurrentJobCount();
        return this.mMaxJobs <= 0 || jobCount < this.mMaxJobs;
    }

    @Override
    public void setClientSupport(ILoadBalancerRunningJobsInfo clientSupport) {
        this.mClientSupport = clientSupport;
    }

    public int getMaxJobs() {
        return this.mMaxJobs;
    }

    public long getBaseWait() {
        return this.mBaseWait;
    }

    public long getMaxWait() {
        return this.mMaxWait;
    }

    public int getJobsBeforeBackoff() {
        return this.mJobsBeforeBackoff;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("MaxJobs=");
        buffer.append(this.mMaxJobs);
        buffer.append(" BaseWait=");
        buffer.append(this.mBaseWait);
        buffer.append(" MaxWait=");
        buffer.append(this.mMaxWait);
        buffer.append(" JobsBeforeBackoff=");
        buffer.append(this.mJobsBeforeBackoff);
        return buffer.toString();
    }
}

