/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip.engine.mq.client;

import com.sas.net.crypto.SealedString;
import com.sas.scheduler.api.servers.ip.engine.AbstractUserSession;
import com.sas.scheduler.api.servers.ip.engine.FlowManager;
import com.sas.scheduler.api.servers.ip.engine.mq.JMSClusterSupport;
import com.sas.scheduler.api.servers.ip.engine.mq.PIPNonMasterExecutionProvider;
import com.sas.scheduler.api.servers.ip.engine.mq.RendererRoutingRules;
import com.sas.scheduler.api.servers.ip.engine.mq.client.CommandLineJobServer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;

public class CommandLineConfigUpdater
extends CommandLineJobServer {
    public static final String Config_JobRoutingXMLFile = "sas.dip.JobRoutingXMLFile";

    public static void main(String[] args) throws Exception {
        System.out.println("DIP - Command-Line Config Updater");
        try {
            new CommandLineConfigUpdater().configure(args);
        }
        finally {
            System.exit(0);
        }
    }

    public void configure(String[] args) throws Exception {
        Properties clientProperties = this.getProperties(args);
        if (clientProperties == null) {
            return;
        }
        boolean someConfigSpecified = false;
        String routingXML = null;
        String xmlFilePath = clientProperties.getProperty(Config_JobRoutingXMLFile, null);
        if (xmlFilePath != null) {
            String line;
            File f = new File(xmlFilePath);
            if (!f.exists()) {
                System.err.println("Job routing XML file does not exist: " + f.getAbsolutePath());
                this.showHelp();
                return;
            }
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"));
            StringBuffer xmlData = new StringBuffer();
            while ((line = br.readLine()) != null) {
                xmlData.append(line);
                xmlData.append('\n');
            }
            try {
                RendererRoutingRules rules = RendererRoutingRules.fromXML(xmlData.toString());
                System.out.println("Job routing rules parsed: " + rules.toString());
            }
            catch (Exception e) {
                System.err.println("Error parsing Job Routing XML");
                e.printStackTrace();
                return;
            }
            routingXML = xmlData.toString();
            someConfigSpecified = true;
        }
        if (!someConfigSpecified) {
            System.err.println("No config actions specified");
            this.showHelp();
            return;
        }
        String clusterName = clientProperties.getProperty("PIP.JGroupsClusterName", "D-IPScheduler");
        JMSClusterSupport cluster = new JMSClusterSupport(clientProperties, clusterName, false);
        PIPNonMasterExecutionProvider provider = new PIPNonMasterExecutionProvider(this.getLogger(), cluster);
        FlowManager manager = FlowManager.createFlowManager(provider, this.getLogger());
        AbstractUserSession session = manager.createSession("Anonymous", new SealedString("Anonymous"));
        if (session == null) {
            System.err.println("Unable to connect to scheduling cluster.");
            this.showHelp();
            return;
        }
        session.setJobRoutingXML(routingXML);
        System.out.println("Config command sent");
    }

    @Override
    protected void showHelp() {
        System.out.println("Usage: ");
        System.out.println("\tjava [-Dsas.dip.commandLine.propertyFile=<file path>] CommandLineConfigUpdater [<property file path>]");
        System.out.println("Arguments in the properties file (supply required values and any that are non-default):");
        System.out.println("\t [Required] java.naming.factory.initial-JMS factory class. ex. org.apache.activemq.jndi.ActiveMQInitialContextFactory");
        System.out.println("\t [Required] java.naming.provider.url-JMS URL.  ex. tcp://myMachine.mydomain.com:61616");
        System.out.println("\t [Required*] JMSSecurityUserid-The JMS user id.  Don't include if no security");
        System.out.println("\t [Required*] JMSSecurityPasswd-The JMS password.  Don't include if no security");
        System.out.println("\t PIP.JGroupsClusterName-Name of the DIP cluster.  Defaults to: D-IPScheduler");
        System.out.println("\t sas.dip.JobRoutingXMLFile-Path to file containing job routing xml.");
    }
}

