/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip.engine.mq;

import com.sas.scheduler.api.servers.ip.engine.ClientLogger;
import com.sas.scheduler.api.servers.ip.engine.ClusterSupport;
import com.sas.scheduler.api.servers.ip.engine.DAVPersistence;
import com.sas.scheduler.api.servers.ip.engine.DeferredManagerAction;
import com.sas.scheduler.api.servers.ip.engine.ExecutionCallback;
import com.sas.scheduler.api.servers.ip.engine.FlowHistory;
import com.sas.scheduler.api.servers.ip.engine.FlowInstance;
import com.sas.scheduler.api.servers.ip.engine.FlowManager;
import com.sas.scheduler.api.servers.ip.engine.IPUtilities;
import com.sas.scheduler.api.servers.ip.engine.Job;
import com.sas.scheduler.api.servers.ip.engine.JobRendererInfo;
import com.sas.scheduler.api.servers.ip.engine.RunHistory;
import com.sas.scheduler.api.servers.ip.engine.RunningFlow;
import com.sas.scheduler.api.servers.ip.engine.RunningItem;
import com.sas.scheduler.api.servers.ip.engine.RunningJob;
import com.sas.scheduler.api.servers.ip.engine.ShutdownException;
import com.sas.scheduler.api.servers.ip.engine.SimpleProcessProvider;
import com.sas.scheduler.api.servers.ip.engine.SyncManager;
import com.sas.scheduler.api.servers.ip.engine.TopLevelFlow;
import com.sas.scheduler.api.servers.ip.engine.UserInfo;
import com.sas.scheduler.api.servers.ip.engine.mq.JMSClusterSupport;
import com.sas.scheduler.api.servers.ip.engine.mq.JobRoutingExpression;
import com.sas.scheduler.api.servers.ip.engine.mq.RendererRoutingRules;
import com.sas.scheduler.model.SchedulerException;
import com.sas.svcs.content.document.client.DocumentService;
import com.sas.svcs.content.folder.client.FolderService;
import com.sas.svcs.content.navigation.client.NavigationService;
import com.sas.svcs.dav.client.DAVContentServiceInterface;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.springframework.jms.JmsException;
import org.springframework.jms.connection.UserCredentialsConnectionFactoryAdapter;
import org.springframework.jms.core.BrowserCallback;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessagePostProcessor;
import org.springframework.jms.listener.DefaultMessageListenerContainer;

public class JMSExecutionProvider
extends SimpleProcessProvider {
    public static final String Queue_Factory = "jms/QueueConnectionFactory";
    public static final String Topic_Factory = "jms/TopicConnectionFactory";
    public static final String Queue_Job = "jms/scheduler.pip.jobQueue";
    public static final String Topic_Broadcast = "jms/scheduler.pip.broadcastTopic";
    public static final String Queue_Result = "jms/scheduler.pip.resultsQueue";
    public static final String Queue_Output = "jms/scheduler.pip.outputQueue";
    protected static final String SASPhysicalQueuePrefix = "sas.jms.";
    protected static final String SASPhysicalQueuePrefixProperty = "sas.dip.jms.queuePrefix";
    public static final String[] Queue_Factory_Simple = new String[]{"QueueConnectionFactory", "ConnectionFactory"};
    public static final String[] Topic_Factory_Simple = new String[]{"TopicConnectionFactory", "ConnectionFactory"};
    public static final String Config_JMSSecurity_Userid = "JMSSecurityUserid";
    public static final String Config_JMSSecurity_Passwd = "JMSSecurityPasswd";
    public static final String Config_JGroupsClusterName = "PIP.JGroupsClusterName";
    public static final String Config_JGroupsConfigString = "PIP.JGroupsConfigString";
    public static final String Config_JGroupsAddress = "PIP.JGroupsMulticastAddress";
    public static final String Config_JGroupsTTL = "PIP.JGroupsMulticastTTL";
    public static final String Config_HistoriesPerFlow = "PIP.MaxHistoriesPerFlow";
    public static final String Config_MaxSimultaneousFlowsRunning = "PIP.MaxFlowsRunningInSystem";
    public static final String Config_MaxSimultaneousJobsRunning = "PIP.MaxJobsRunningInSystem";
    public static final String Config_PersistenceRoot = "PIP.PersistenceAreaRoot";
    public static final String Config_SaveFlows = "PIP.SaveFlows";
    public static final String Config_SaveFlowInstances = "PIP.SaveFlowInstances";
    public static final String Config_FallbackToCommandLineServer = "PIP.UseCommandLineServer";
    public static final String Config_FileTriggerCheckFrequencyMS = "PIP.FileTriggerCheckFrequencyMS";
    public static final String Config_HashChannelPort = "PIP.JGroupsPort_HashChannelPort";
    public static final String Config_MainChannelPort = "PIP.JGroupsPort_MainChannelPort";
    public static final String Config_PIPPersistenceName = "PIP.PersistenceName";
    public static final String Config_MissingJobrunnerTimeoutMS = "PIP.MissingJobRunnerTimeoutMS";
    public static final String Config_RendererCleanupTimeoutMS = "PIP.RendererCleanupTimeoutMS";
    public static final String Config_ApplicationIDCleanupTimeoutMS = "PIP.ApplicationIDCleanupTimeoutMS";
    public static final String Job_OutputTruncated = "<Job output truncated by job renderer (exceeded renderer limit)>";
    public static final String Job_OutputComplete = "<Job output end>";
    public static final String Tag_jobXML = "jobXML";
    public static final String Tag_jobName = "jobName";
    public static final String Tag_jobResourceRequirementsString = "jobResourceRequirementsString";
    public static final String Tag_userID = "userID";
    public static final String Tag_CallbackServer = "CallbackServer";
    public static final String Tag_password = "password";
    public static final String Tag_applicationID = "applicationID";
    public static final String Tag_rendevousID = "rendevousID";
    public static final String Tag_outputSavePath = "outputSavePath";
    public static final String Tag_resultType = "resultType";
    public static final String Tag_exitCode = "exitCode";
    public static final String Tag_status = "status";
    public static final String Tag_rendererID = "rendererID";
    public static final String Tag_timeStamp = "timeStamp";
    public static final String Tag_forceKill = "forceKill";
    public static final String Tag_rendevousIDList = "rendevousIDList";
    public static final String Tag_applicationIDList = "ApplicationIDList";
    public static final String Tag_upTime = "upTime";
    public static final String Tag_totalJobs = "totalJobs";
    public static final String Tag_Priority = "priority";
    public static final String Tag_JobRoutingRules = "jobRoutingRules";
    protected static final String FlowDefinitionDir = "FlowDefinitions";
    protected static final String FlowInstanceDir = "FlowInstances";
    protected static final String FlowDefinitionsFile = "FlowDefinitions.dat";
    protected static final String ApplicationIDsFile = "ApplicationIDs.dat";
    protected static final String RoutingRulesFile = "RoutingRules.dat";
    public static final String MQItemSeparator = ",";
    public static final String Const_Start = "START";
    public static final String Const_Finish = "FINISH";
    public static final String Const_STDOUT = "STDOUT";
    public static final String Const_STDERR = "STDERR";
    public static final String Const_Heartbeat = "Heartbeat";
    public static final String Const_KillRequest = "KillRequest";
    public static final String Const_Shutdown = "Shutdown";
    private static final String mFileSeparator = "/";
    private static final String SyncKey_FlowDefsFile = "FlowDefsFile";
    private Properties mConfiguration;
    private JmsTemplate mJobQueue;
    private JmsTemplate mResultsQueue;
    private JmsTemplate mOutputQueue;
    protected JmsTemplate mBroadcastTopic;
    protected TopicConnection mTopicConnection;
    protected DefaultMessageListenerContainer mTopicListener;
    protected TopicSession mTopicSession;
    protected MessageProducer mTopicProducer;
    protected ConnectionFactory mTopicFactory;
    protected ConnectionFactory mQueueFactory;
    private Map<String, CallbackWrapper> mOutstandingJobs = new HashMap<String, CallbackWrapper>();
    private int mMaxSimultaneousFlows;
    private int mMaxHistoriesPerFlow;
    private int mMaxSimultaneousJobs;
    private long mTriggerCheckFrequency;
    private long mJobACKTimeout = 600000L;
    private boolean mSaveFlows;
    private boolean mSaveInstances;
    private boolean mShuttingDown = false;
    private String mServerCallbackID;
    protected Map<String, Long> mRecentApplicationIDs = new HashMap<String, Long>();
    protected Map<String, JobRendererInfo> mRenderers = new HashMap<String, JobRendererInfo>();
    protected RendererRoutingRules mJobRoutingRules = null;
    protected long mServerStartTime;
    protected long mMissingJobRunnerTimeout;
    protected long mRendererCleanupTimeout;
    protected long mApplicationIDCleanupTimeout;
    private Timer mTimeoutTimer;
    private Thread mOutputSpooler;
    private Thread mResultReader;
    private static final String jndiPrefix = "java:comp/env/";
    public static final String Tag_XMLLines = "XMLLines=";
    public static final String Tag_FlowID = "FlowID=";

    private static File getPersistenceFromProperties(Properties configuration) {
        String persistRoot = configuration.getProperty(Config_PersistenceRoot, "");
        if (persistRoot.length() > 0) {
            return new File(persistRoot);
        }
        return null;
    }

    public JMSExecutionProvider(ClientLogger logger, Properties configuration, ClusterSupport cluster, DAVContentServiceInterface davContentService, DocumentService documentContentService, FolderService folderContentService, NavigationService navigationContentService) {
        super(logger, JMSExecutionProvider.getPersistenceFromProperties(configuration), 1, cluster);
        this.mServerCallbackID = configuration.getProperty(Config_PIPPersistenceName, JMSExecutionProvider.getUniqueServerID(configuration));
        if (davContentService != null && this.mPersistenceProvider == null) {
            try {
                this.mPersistenceProvider = new DAVPersistence(davContentService, documentContentService, folderContentService, navigationContentService, logger, this.mServerCallbackID);
            }
            catch (Exception e) {
                logger.logMessage(Level.WARNING, e);
            }
        }
        if (this.mPersistenceProvider == null) {
            logger.logMessage(Level.SEVERE, "No persistence provided via DAV (PIP.PersistenceName) OR File (PIP.PersistenceAreaRoot)");
        }
        this.mConfiguration = configuration;
        this.mMaxHistoriesPerFlow = IPUtilities.getIntegerValue(configuration, Config_HistoriesPerFlow, 10, this.mLogger);
        this.mMaxHistoriesPerFlow = Math.max(this.mMaxHistoriesPerFlow, 0);
        this.mMaxSimultaneousFlows = IPUtilities.getIntegerValue(configuration, Config_MaxSimultaneousFlowsRunning, 0, this.mLogger);
        this.mMaxSimultaneousFlows = Math.max(this.mMaxSimultaneousFlows, 0);
        this.mMaxSimultaneousJobs = IPUtilities.getIntegerValue(configuration, Config_MaxSimultaneousJobsRunning, 1000, this.mLogger);
        this.mMaxSimultaneousJobs = Math.max(this.mMaxSimultaneousJobs, 0);
        this.mTriggerCheckFrequency = IPUtilities.getLongValue(configuration, Config_FileTriggerCheckFrequencyMS, 81000L, this.mLogger);
        this.mTriggerCheckFrequency = Math.max(this.mTriggerCheckFrequency, 30000L);
        this.mTriggerCheckFrequency = Math.min(this.mTriggerCheckFrequency, 1200000L);
        this.mMissingJobRunnerTimeout = IPUtilities.getLongValue(configuration, Config_MissingJobrunnerTimeoutMS, 900000L, this.mLogger);
        this.mMissingJobRunnerTimeout = Math.max(this.mMissingJobRunnerTimeout, 120000L);
        this.mRendererCleanupTimeout = IPUtilities.getLongValue(configuration, Config_RendererCleanupTimeoutMS, 14400000L, this.mLogger);
        this.mRendererCleanupTimeout = Math.max(this.mRendererCleanupTimeout, 300000L);
        this.mApplicationIDCleanupTimeout = IPUtilities.getLongValue(configuration, Config_ApplicationIDCleanupTimeoutMS, 21600000L, this.mLogger);
        this.mApplicationIDCleanupTimeout = Math.max(this.mApplicationIDCleanupTimeout, 300000L);
        this.mSaveFlows = IPUtilities.getBooleanValue(configuration, Config_SaveFlows, true, this.mLogger);
        this.mSaveInstances = IPUtilities.getBooleanValue(configuration, Config_SaveFlowInstances, false, this.mLogger);
        this.mLogger.logMessage(Level.INFO, "DIP Scheduler configuration settings:");
        this.mLogger.logMessage(Level.INFO, "Max history records per flow: " + this.mMaxHistoriesPerFlow);
        this.mLogger.logMessage(Level.INFO, "Max simultaneous flows: " + this.mMaxSimultaneousFlows);
        this.mLogger.logMessage(Level.INFO, "Max simultaneous jobs: " + this.mMaxSimultaneousJobs);
        this.mLogger.logMessage(Level.INFO, "Save flow definitions: " + this.mSaveFlows);
        this.mLogger.logMessage(Level.INFO, "Save flow instance records: " + this.mSaveInstances);
        if (this.mPersistenceProvider != null) {
            this.mLogger.logMessage(Level.INFO, "Persistence path: " + this.mPersistenceProvider.getPath());
        } else {
            this.mLogger.logMessage(Level.WARNING, "No persistence root specified.");
        }
        this.mLogger.logMessage(Level.INFO, "Cluster name: " + configuration.getProperty(Config_JGroupsClusterName, "Not configured"));
        this.mLogger.logMessage(Level.INFO, "JMS Factory: " + configuration.getProperty("java.naming.factory.initial", "Not configured"));
        this.mLogger.logMessage(Level.INFO, "JMS URL: " + configuration.getProperty("java.naming.provider.url", "Not configured"));
        this.mLogger.logMessage(Level.INFO, "JMS UserID: " + configuration.getProperty(Config_JMSSecurity_Userid, "No user"));
        this.mLogger.logMessage(Level.INFO, "JMS Password: " + configuration.getProperty(Config_JMSSecurity_Passwd, "No password"));
        this.mServerStartTime = System.currentTimeMillis();
        this.initialize();
    }

    private synchronized MapMessage safeCreateMapMessage() throws JMSException, NamingException {
        if (this.mTopicSession == null) {
            this.mLogger.logMessage(Level.FINE, this.getClass().getName() + ": TopicSession is null.  Reconnecting to JMS.");
            this.initJMSTopic(this.initJMSContext());
        }
        MapMessage message = null;
        try {
            message = this.mTopicSession.createMapMessage();
        }
        catch (javax.jms.IllegalStateException e) {
            this.mLogger.logMessage(Level.FINE, this.getClass().getName() + ": TopicSession is closed.  Reconnecting to JMS.");
            this.initJMSTopic(this.initJMSContext());
            message = this.mTopicSession.createMapMessage();
        }
        return message;
    }

    public static String getUniqueServerID(Properties configuration) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(configuration.getProperty(Config_JGroupsAddress, "NoAddress"));
        buffer.append("_");
        buffer.append(configuration.getProperty(Config_MainChannelPort, "NoMainPort"));
        buffer.append("_");
        buffer.append(configuration.getProperty(Config_JGroupsClusterName, "DIPCluster"));
        return buffer.toString();
    }

    @Override
    public long getFileConditionPeriod() {
        return this.mTriggerCheckFrequency;
    }

    @Override
    public long getFileTriggerPeriod() {
        return this.mTriggerCheckFrequency;
    }

    @Override
    public void killJob(String rendevousID) {
        this.killJob(rendevousID, false);
    }

    public static InitialContext initializeJMSContext(Properties schedProps) {
        try {
            Properties env = new Properties();
            env.setProperty("java.naming.provider.url", schedProps.getProperty("java.naming.provider.url"));
            env.setProperty("java.naming.factory.initial", schedProps.getProperty("java.naming.factory.initial"));
            InitialContext jndi = new InitialContext(env);
            return jndi;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize JMS initial context.", e);
        }
    }

    public static boolean areCredentialsProvided(Properties configuration) {
        String jmsSecurityUserid = configuration.getProperty(Config_JMSSecurity_Userid);
        String jmsSecurityPasswd = configuration.getProperty(Config_JMSSecurity_Passwd);
        return jmsSecurityUserid != null && jmsSecurityUserid.length() > 0 && jmsSecurityPasswd != null && jmsSecurityPasswd.length() > 0;
    }

    public static UserCredentialsConnectionFactoryAdapter configureSecurity(ConnectionFactory factory, Properties configuration) {
        String jmsSecurityUserid = configuration.getProperty(Config_JMSSecurity_Userid);
        String jmsSecurityPasswd = configuration.getProperty(Config_JMSSecurity_Passwd);
        if (jmsSecurityUserid != null && jmsSecurityUserid.length() > 0 && jmsSecurityPasswd != null && jmsSecurityPasswd.length() > 0) {
            if (SasPasswordString.isEncoded((String)jmsSecurityPasswd)) {
                try {
                    jmsSecurityPasswd = SasPasswordString.decode((String)jmsSecurityPasswd);
                }
                catch (SasPasswordEncodingException sasPasswordEncodingException) {
                    // empty catch block
                }
            }
            UserCredentialsConnectionFactoryAdapter secureQueueFactory = new UserCredentialsConnectionFactoryAdapter();
            secureQueueFactory.setTargetConnectionFactory(factory);
            secureQueueFactory.setUsername(jmsSecurityUserid);
            secureQueueFactory.setPassword(jmsSecurityPasswd);
            return secureQueueFactory;
        }
        return null;
    }

    private static String getLastSegment(String jmsName) {
        int lastSlash = jmsName.lastIndexOf(47);
        if (lastSlash >= 0) {
            return jmsName.substring(lastSlash + 1);
        }
        return jmsName;
    }

    public static void configureQueue(InitialContext jmsContext, JmsTemplate queueTemplate, String queueName, ClientLogger logger) {
        try {
            queueTemplate.setDefaultDestination((Destination)((Queue)jmsContext.lookup(queueName)));
        }
        catch (NamingException e) {
            logger.logMessage(Level.FINE, "Retrying JMS Queue lookup using TC Server style, called from: " + JMSExecutionProvider.findCallingMethod(e, "configureQueue"));
            try {
                queueTemplate.setDefaultDestination((Destination)((Queue)jmsContext.lookup(jndiPrefix + queueName)));
            }
            catch (NamingException e2) {
                logger.logMessage(Level.FINE, e2);
                logger.logMessage(Level.WARNING, "Unable to lookup JMS queue using either appserver jndi lookup name (okay if running outside an appserver): " + queueName + " OR " + jndiPrefix + queueName);
                String queuePrefix = System.getProperty(SASPhysicalQueuePrefixProperty, SASPhysicalQueuePrefix);
                logger.logMessage(Level.INFO, "Creating dynamic queue with name: " + queuePrefix + JMSExecutionProvider.getLastSegment(queueName));
                queueTemplate.setDefaultDestinationName(queuePrefix + JMSExecutionProvider.getLastSegment(queueName));
            }
        }
    }

    public static Topic configureTopic(InitialContext jmsContext, JmsTemplate topicTemplate, TopicSession session, String topicName, ClientLogger logger) throws JMSException {
        Topic broadcastTopic = null;
        try {
            broadcastTopic = (Topic)jmsContext.lookup(topicName);
        }
        catch (NamingException e) {
            logger.logMessage(Level.FINE, "Retrying JMS Topic lookup using TC Server style, called from: " + JMSExecutionProvider.findCallingMethod(e, "configureTopic"));
            try {
                broadcastTopic = (Topic)jmsContext.lookup(jndiPrefix + topicName);
            }
            catch (NamingException e2) {
                logger.logMessage(Level.FINE, e2);
                logger.logMessage(Level.WARNING, "Unable to lookup JMS topic using either appserver jndi lookup name (okay if running outside an appserver): " + topicName + " OR " + jndiPrefix + topicName);
                String queuePrefix = System.getProperty(SASPhysicalQueuePrefixProperty, SASPhysicalQueuePrefix);
                logger.logMessage(Level.INFO, "Creating dynamic topic with name: " + queuePrefix + JMSExecutionProvider.getLastSegment(topicName));
                broadcastTopic = session.createTopic(queuePrefix + JMSExecutionProvider.getLastSegment(topicName));
            }
        }
        topicTemplate.setDefaultDestination((Destination)broadcastTopic);
        return broadcastTopic;
    }

    private static String findCallingMethod(Exception e, String childMethodName) {
        try {
            StackTraceElement[] stack = e.getStackTrace();
            boolean foundItem = false;
            for (StackTraceElement stackTraceElement : stack) {
                if (foundItem) {
                    return stackTraceElement.getClassName() + ":" + stackTraceElement.getMethodName();
                }
                if (!stackTraceElement.getMethodName().equals(childMethodName)) continue;
                foundItem = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "Unknown caller";
    }

    public static ConnectionFactory getFactory(InitialContext jmsContext, String factoryName, String[] simpleFactoryNames) throws NamingException {
        try {
            return (ConnectionFactory)jmsContext.lookup(factoryName);
        }
        catch (NamingException e) {
            try {
                return (ConnectionFactory)jmsContext.lookup(jndiPrefix + factoryName);
            }
            catch (NamingException e2) {
                for (String simpleFactoryName : simpleFactoryNames) {
                    try {
                        return (ConnectionFactory)jmsContext.lookup(simpleFactoryName);
                    }
                    catch (NamingException namingException) {
                    }
                }
                throw e;
            }
        }
    }

    protected void initJMS(int attempts) {
        if (attempts <= 0) {
            attempts = 1;
        }
        int SLEEP_TIME = 30;
        int LOG_MESSAGE_PER_TRIES = 4;
        int retryCount = 0;
        while (true) {
            block10: {
                try {
                    this.cleanupJMSObjects();
                    InitialContext jmsContext = this.initJMSContext();
                    this.mJobQueue = new JmsTemplate(this.mQueueFactory);
                    JMSExecutionProvider.configureQueue(jmsContext, this.mJobQueue, Queue_Job, this.mLogger);
                    this.mJobQueue.setReceiveTimeout(2000L);
                    this.mJobQueue.setTimeToLive(86400000L);
                    this.mJobQueue.setDeliveryMode(2);
                    this.mJobQueue.setExplicitQosEnabled(true);
                    this.mResultsQueue = new JmsTemplate(this.mQueueFactory);
                    JMSExecutionProvider.configureQueue(jmsContext, this.mResultsQueue, Queue_Result, this.mLogger);
                    this.mResultsQueue.setReceiveTimeout(10000L);
                    this.mOutputQueue = new JmsTemplate(this.mQueueFactory);
                    JMSExecutionProvider.configureQueue(jmsContext, this.mOutputQueue, Queue_Output, this.mLogger);
                    this.mOutputQueue.setReceiveTimeout(10000L);
                    this.initJMSTopic(jmsContext);
                    break;
                }
                catch (NamingException e) {
                    if (++retryCount > attempts) {
                        throw new IllegalStateException("Failed to lookup required JMS objects in JNDI.", e);
                    }
                }
                catch (JMSException e) {
                    if (++retryCount > attempts) {
                        throw new IllegalStateException("Failed to initialize required JMS objects.", e);
                    }
                }
                catch (IllegalStateException e) {
                    if (++retryCount <= attempts) break block10;
                    throw e;
                }
            }
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (retryCount % 4 != 0) continue;
            this.mLogger.logMessage(Level.INFO, "Have received " + retryCount + " failures attempting to initialize required JMS objects for Distributed-IP scheduler.");
        }
        this.mLogger.logMessage(Level.INFO, "Successfully initialized required JMS objects for Distributed-IP scheduler.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initJMSTopic(InitialContext jmsContext) throws JMSException {
        Object object = JMSClusterSupport.GlobalJMSSyncObject;
        synchronized (object) {
            if (this.mTopicSession != null) {
                try {
                    MapMessage tempMessage = this.mTopicSession.createMapMessage();
                    return;
                }
                catch (Exception tempMessage) {
                    // empty catch block
                }
            }
            this.cleanupJMSTopic();
            this.mTopicConnection = (TopicConnection)this.mTopicFactory.createConnection();
            if (this.mTopicConnection == null) {
                throw new IllegalStateException("Failed to create JMS topic connection.");
            }
            this.mBroadcastTopic = new JmsTemplate(this.mTopicFactory);
            this.mTopicSession = this.mTopicConnection.createTopicSession(false, 1);
            if (this.mTopicSession == null) {
                throw new IllegalStateException("Failed to create JMS topic session.");
            }
            Topic broadcastTopic = JMSExecutionProvider.configureTopic(jmsContext, this.mBroadcastTopic, this.mTopicSession, Topic_Broadcast, this.mLogger);
            this.mTopicProducer = this.mTopicSession.createPublisher(broadcastTopic);
            if (this.mTopicProducer == null) {
                throw new IllegalStateException("Failed to create broadcast JMS topic publisher.");
            }
            this.mTopicProducer.setTimeToLive(600000L);
            this.mTopicProducer.setDeliveryMode(1);
            TopicSession consumerSession = this.mTopicConnection.createTopicSession(false, 1);
            if (consumerSession == null) {
                throw new IllegalStateException("Failed to create JMS topic session.");
            }
            Topic broadcastTopic2 = JMSExecutionProvider.configureTopic(jmsContext, this.mBroadcastTopic, consumerSession, Topic_Broadcast, this.mLogger);
            this.mTopicListener = new DefaultMessageListenerContainer();
            this.mTopicListener.setConnectionFactory(this.mTopicFactory);
            this.mTopicListener.setDestination((Destination)broadcastTopic2);
            this.mTopicListener.setMessageListener((Object)new MessageListener(){

                public void onMessage(Message msg) {
                    JMSExecutionProvider.this.processBroadcastMessage(msg);
                }
            });
            this.mTopicListener.afterPropertiesSet();
            this.mTopicListener.start();
            this.mTopicConnection.start();
        }
    }

    private InitialContext initJMSContext() throws NamingException {
        InitialContext jmsContext = JMSExecutionProvider.initializeJMSContext(this.mConfiguration);
        this.mQueueFactory = JMSExecutionProvider.getFactory(jmsContext, Queue_Factory, Queue_Factory_Simple);
        this.mTopicFactory = JMSExecutionProvider.getFactory(jmsContext, Topic_Factory, Topic_Factory_Simple);
        if (JMSExecutionProvider.areCredentialsProvided(this.mConfiguration)) {
            this.mQueueFactory = JMSExecutionProvider.configureSecurity(this.mQueueFactory, this.mConfiguration);
            this.mTopicFactory = JMSExecutionProvider.configureSecurity(this.mTopicFactory, this.mConfiguration);
        }
        return jmsContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void cleanupJMSTopic() {
        Object object = JMSClusterSupport.GlobalJMSSyncObject;
        synchronized (object) {
            try {
                if (this.mTopicConnection != null) {
                    this.mTopicConnection.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (this.mTopicSession != null) {
                    this.mTopicSession.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (this.mTopicProducer != null) {
                    this.mTopicProducer.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (this.mTopicListener != null) {
                    this.mTopicListener.stop();
                    this.mTopicListener.shutdown();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mBroadcastTopic = null;
            this.mTopicConnection = null;
            this.mTopicProducer = null;
            this.mTopicSession = null;
            this.mTopicListener = null;
        }
    }

    private synchronized void cleanupJMSObjects() {
        this.cleanupJMSTopic();
        this.mOutputQueue = null;
        this.mJobQueue = null;
        this.mResultsQueue = null;
        this.mQueueFactory = null;
        this.mTopicFactory = null;
    }

    private void initialize() {
        if (this.getClusteringServer() != null && !this.getClusteringServer().isEligibleMaster()) {
            return;
        }
        this.loadAppIDs();
        this.loadJobRoutingRules();
        final String messageSelector = "CallbackServer='" + this.mServerCallbackID + "'";
        this.initJMS(60);
        final JMSExecutionProvider savedInstance = this;
        this.mTimeoutTimer = new Timer("PIP-Job Timeout");
        this.mTimeoutTimer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    JMSExecutionProvider.this.cleanupRendererCache();
                    JMSExecutionProvider.this.cleanupApplicationIDCache();
                    Collection<JobRendererInfo> renderers = JMSExecutionProvider.this.getJobRendererSnapshots();
                    HashMap<String, Long> knownRendererTypes = new HashMap<String, Long>();
                    HashMap<String, Long> knownRenderers = new HashMap<String, Long>();
                    JMSExecutionProvider.findLatestHeartbeatTimes(renderers, knownRenderers, knownRendererTypes);
                    MapMessage bogusMessage = JMSExecutionProvider.this.safeCreateMapMessage();
                    ArrayList<CallbackWrapper> lostJobs = new ArrayList<CallbackWrapper>();
                    ArrayList copiedCallbacks = new ArrayList();
                    HashSet copiedRendevousIDs = new HashSet();
                    JMSExecutionProvider jMSExecutionProvider = JMSExecutionProvider.this;
                    synchronized (jMSExecutionProvider) {
                        copiedCallbacks.addAll(JMSExecutionProvider.this.mOutstandingJobs.values());
                        copiedRendevousIDs.addAll(JMSExecutionProvider.this.mOutstandingJobs.keySet());
                    }
                    final HashSet finalCopiedIDs = copiedRendevousIDs;
                    String serverMessageSelector = "CallbackServer='" + JMSExecutionProvider.this.mServerCallbackID + "'";
                    JMSExecutionProvider.this.mLogger.logMessage(Level.FINE, "Checking queue for unknown jobs related to this server.");
                    JMSExecutionProvider.this.mJobQueue.browseSelected(serverMessageSelector, (BrowserCallback)new BrowserCallback<Message>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public Message doInJms(Session arg0, QueueBrowser arg1) throws JMSException {
                            Message msg;
                            String rendevousID;
                            Object o;
                            Enumeration items = arg1.getEnumeration();
                            if (items.hasMoreElements() && (o = items.nextElement()) instanceof Message && (rendevousID = (msg = (Message)o).getStringProperty(JMSExecutionProvider.Tag_rendevousID)) != null && !finalCopiedIDs.contains(rendevousID)) {
                                boolean knownJob;
                                JMSExecutionProvider jMSExecutionProvider = JMSExecutionProvider.this;
                                synchronized (jMSExecutionProvider) {
                                    knownJob = JMSExecutionProvider.this.mOutstandingJobs.containsKey(rendevousID);
                                }
                                if (!knownJob) {
                                    JMSExecutionProvider.this.mLogger.logMessage(Level.FINE, "Attempting to remove unknown job from queue with rendevousID: " + rendevousID);
                                    JMSExecutionProvider.this.removeJobFromQueue(rendevousID);
                                }
                            }
                            return null;
                        }
                    });
                    long currentTime = System.currentTimeMillis();
                    for (CallbackWrapper wrapper : copiedCallbacks) {
                        if (!JMSExecutionProvider.this.mFlowManager.isJobLive(wrapper.getCallback().getRendevousID())) {
                            JMSExecutionProvider jMSExecutionProvider2 = JMSExecutionProvider.this;
                            synchronized (jMSExecutionProvider2) {
                                JMSExecutionProvider.this.mOutstandingJobs.remove(wrapper.getCallback().getRendevousID());
                            }
                            JMSExecutionProvider.this.removeJobFromQueue(wrapper);
                            continue;
                        }
                        if (JMSExecutionProvider.isJobRunnerMissing(wrapper, knownRendererTypes, currentTime, JMSExecutionProvider.this.mServerStartTime, JMSExecutionProvider.this.mMissingJobRunnerTimeout)) {
                            JMSExecutionProvider.this.mLogger.logMessage(Level.FINE, "There is no job runner of type: " + wrapper.getExecutionQueue() + "; canceling job after timeout: " + wrapper.getJob().getName() + JMSExecutionProvider.mFileSeparator + wrapper.getJob().getUniqueID());
                            JMSExecutionProvider.this.markJob(wrapper.getCallback().getRendevousID(), 128, 0);
                            JMSExecutionProvider.this.removeJobFromQueue(wrapper);
                            continue;
                        }
                        if (JMSExecutionProvider.isSpecificJobRunnerMissing(wrapper, knownRenderers, currentTime, JMSExecutionProvider.this.mServerStartTime, JMSExecutionProvider.this.mMissingJobRunnerTimeout)) {
                            JMSExecutionProvider.this.mLogger.logMessage(Level.FINE, "There is no job runner of type: " + wrapper.getExecutionQueue() + "; canceling job after timeout: " + wrapper.getJob().getName() + JMSExecutionProvider.mFileSeparator + wrapper.getJob().getUniqueID());
                            JMSExecutionProvider.this.markJob(wrapper.getCallback().getRendevousID(), 128, 0);
                            JMSExecutionProvider.this.removeJobFromQueue(wrapper);
                            continue;
                        }
                        if (currentTime - wrapper.getLastConfirmedTime() <= JMSExecutionProvider.this.mJobACKTimeout || currentTime - JMSExecutionProvider.this.mServerStartTime <= JMSExecutionProvider.this.mJobACKTimeout) continue;
                        lostJobs.add(wrapper);
                    }
                    for (CallbackWrapper wrapper : lostJobs) {
                        String messageSelector = "rendevousID='" + wrapper.getCallback().getRendevousID() + "'";
                        JMSExecutionProvider.this.mLogger.logMessage(Level.FINE, "Attempting to find lost job: " + wrapper.getCallback().getRendevousID());
                        Message selectedObject = (Message)JMSExecutionProvider.this.mJobQueue.browseSelected(messageSelector, (BrowserCallback)new BrowserCallback<Message>((Message)bogusMessage){
                            final /* synthetic */ Message val$bogusMessage;
                            {
                                this.val$bogusMessage = message;
                            }

                            public Message doInJms(Session arg0, QueueBrowser arg1) throws JMSException {
                                Object o;
                                Enumeration items = arg1.getEnumeration();
                                if (items.hasMoreElements() && (o = items.nextElement()) instanceof Message) {
                                    return (Message)o;
                                }
                                return this.val$bogusMessage;
                            }
                        });
                        if (selectedObject == null) {
                            JMSExecutionProvider.this.mLogger.logMessage(Level.FINE, "Job queue couldn't be read while attempting to find: " + wrapper.getCallback().getRendevousID());
                            break;
                        }
                        if (selectedObject != null && selectedObject != bogusMessage) {
                            JMSExecutionProvider.this.mLogger.logMessage(Level.FINE, "Job was still on queue, leaving: " + wrapper.getCallback().getRendevousID());
                            wrapper.updateLastConfirmedTime(System.currentTimeMillis());
                            continue;
                        }
                        wrapper.getJob().incrementPriority(1);
                        JMSExecutionProvider.this.mLogger.logMessage(Level.FINE, "Reposting lost job: " + wrapper.getCallback().getRendevousID());
                        savedInstance.postJobToQueue(wrapper);
                    }
                }
                catch (Exception e) {
                    JMSExecutionProvider.this.mLogger.logMessage(Level.WARNING, e);
                }
            }
        }, 0L, 180000L);
        this.mOutputSpooler = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean exceptionOccurred = false;
                block7: while (true) {
                    try {
                        while (true) {
                            JMSExecutionProvider jMSExecutionProvider = JMSExecutionProvider.this;
                            synchronized (jMSExecutionProvider) {
                                if (JMSExecutionProvider.this.mShuttingDown) {
                                    break block7;
                                }
                            }
                            if (!JMSExecutionProvider.this.isMaster()) {
                                Thread.sleep(10000L);
                                continue;
                            }
                            Message obj = JMSExecutionProvider.this.mOutputQueue.receiveSelected(messageSelector);
                            if (obj != null && obj instanceof ObjectMessage) {
                                Object[] dataArray;
                                ObjectMessage msg = (ObjectMessage)obj;
                                String messageType = msg.getStringProperty(JMSExecutionProvider.Tag_resultType);
                                String outputName = msg.getStringProperty(JMSExecutionProvider.Tag_outputSavePath);
                                int lastSlash = outputName.lastIndexOf(47);
                                int lastUnder = outputName.lastIndexOf(95);
                                String instanceID = "";
                                if (lastSlash >= 0 && lastSlash < lastUnder) {
                                    instanceID = outputName.substring(lastSlash + 1, lastUnder);
                                }
                                if (instanceID.length() == 0) continue;
                                Serializable data = msg.getObject();
                                if (messageType != null && outputName != null && data != null && data instanceof Object[] && (dataArray = (Object[])data).length > 0 && dataArray[0] instanceof byte[]) {
                                    byte[] byteData = (byte[])dataArray[0];
                                    JMSExecutionProvider.this.addOutputToFile(messageType, outputName, instanceID, byteData);
                                    JMSExecutionProvider.this.mLogger.logMessage(Level.FINEST, "Output captured on server: (" + messageType + "), " + outputName);
                                }
                                Thread.yield();
                            } else {
                                Thread.sleep(obj == null ? 5000L : 10L);
                            }
                            exceptionOccurred = false;
                        }
                    }
                    catch (Exception e) {
                        if (exceptionOccurred) {
                            JMSExecutionProvider.this.mLogger.logMessage(Level.FINE, "Error occurred while trying to retrieve potential job output from the Output queue.");
                            JMSExecutionProvider.this.mLogger.logMessage(Level.FINE, e);
                        } else {
                            JMSExecutionProvider.this.mLogger.logMessage(Level.WARNING, "Error occurred while trying to retrieve potential job output from the Output queue.");
                            JMSExecutionProvider.this.mLogger.logMessage(Level.WARNING, e);
                            exceptionOccurred = true;
                        }
                        try {
                            Thread.sleep(30000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    break;
                }
            }
        }, "DIP-Output Spooler");
        this.mOutputSpooler.start();
        this.mResultReader = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean exceptionOccurred = false;
                block12: while (true) {
                    JMSExecutionProvider msg2;
                    try {
                        while (true) {
                            JMSExecutionProvider jMSExecutionProvider = JMSExecutionProvider.this;
                            synchronized (jMSExecutionProvider) {
                                if (JMSExecutionProvider.this.mShuttingDown) {
                                    break block12;
                                }
                            }
                            FlowManager manager = JMSExecutionProvider.this.getFlowManager();
                            if (manager == null || !manager.isServerInitialized()) {
                                Thread.sleep(5000L);
                                continue;
                            }
                            if (!JMSExecutionProvider.this.isMaster()) {
                                Thread.sleep(10000L);
                                continue;
                            }
                            msg2 = JMSExecutionProvider.this.mResultsQueue.receiveSelected(messageSelector);
                            if (msg2 != null) {
                                String messageType = msg2.getStringProperty(JMSExecutionProvider.Tag_resultType);
                                if (messageType == null) continue;
                                String rendevousID = msg2.getStringProperty(JMSExecutionProvider.Tag_rendevousID);
                                if (rendevousID == null) {
                                    JMSExecutionProvider.this.mLogger.logMessage(Level.WARNING, "Message improperly formed: no rendevousID, ignoring");
                                    continue;
                                }
                                if (messageType.equals(JMSExecutionProvider.Const_Start)) {
                                    JMSExecutionProvider.this.mLogger.logMessage(Level.FINE, "job start event received: " + rendevousID);
                                    long newStartTime = msg2.getLongProperty(JMSExecutionProvider.Tag_timeStamp);
                                    String serverName = msg2.getStringProperty(JMSExecutionProvider.Tag_rendererID);
                                    if (serverName == null) continue;
                                    JMSExecutionProvider.this.mLogger.logMessage(Level.FINEST, "Difference between Job start and receipt of job start: " + (System.currentTimeMillis() - newStartTime) + "ms");
                                    JMSExecutionProvider.this.mLogger.logMessage(Level.FINER, "Job: " + rendevousID + " on server: " + serverName);
                                    savedInstance.updateJob(rendevousID, System.currentTimeMillis(), serverName, null);
                                } else if (messageType.equals(JMSExecutionProvider.Const_Finish)) {
                                    JMSExecutionProvider.this.mLogger.logMessage(Level.FINE, "job finish event received: " + rendevousID);
                                    int status = msg2.getIntProperty(JMSExecutionProvider.Tag_status);
                                    int exitCode = 0;
                                    if (msg2.propertyExists(JMSExecutionProvider.Tag_exitCode)) {
                                        exitCode = msg2.getIntProperty(JMSExecutionProvider.Tag_exitCode);
                                    }
                                    savedInstance.markJob(rendevousID, status, exitCode);
                                } else {
                                    JMSExecutionProvider.this.mLogger.logMessage(Level.WARNING, "Invalid/unknown header type on job results queue: " + messageType);
                                }
                            }
                            exceptionOccurred = false;
                        }
                    }
                    catch (Exception e) {
                        if (exceptionOccurred) {
                            JMSExecutionProvider.this.mLogger.logMessage(Level.FINE, "Error occurred while trying to retrieve potential job results from the Result queue.");
                            JMSExecutionProvider.this.mLogger.logMessage(Level.FINE, e);
                        } else {
                            JMSExecutionProvider.this.mLogger.logMessage(Level.WARNING, "Error occurred while trying to retrieve potential job results from the Result queue.");
                            JMSExecutionProvider.this.mLogger.logMessage(Level.WARNING, e);
                            exceptionOccurred = true;
                        }
                        try {
                            Thread.sleep(30000L);
                        }
                        catch (InterruptedException msg2) {
                            // empty catch block
                        }
                        if (!(e instanceof JMSException) && !(e instanceof JmsException)) continue;
                        try {
                            msg2 = JMSExecutionProvider.this;
                            synchronized (msg2) {
                                JMSExecutionProvider.this.initJMS(1);
                                continue;
                            }
                        }
                        catch (Exception e1) {
                            JMSExecutionProvider.this.mLogger.logMessage(Level.FINEST, e1);
                            continue;
                        }
                    }
                    break;
                }
            }
        }, "DIP-JobServer Responses");
        this.mResultReader.start();
    }

    public static boolean isJobRunnerMissing(CallbackWrapper wrapper, Map<String, Long> knownRendererTypes, long currentTime, long serverStartTime, long missingJobRunnerTimeout) {
        Long lastSeenTime;
        return !wrapper.isGrabbedByJobRunner() && currentTime - serverStartTime >= missingJobRunnerTimeout && ((lastSeenTime = knownRendererTypes.get(wrapper.getExecutionQueue())) == null || currentTime - lastSeenTime >= missingJobRunnerTimeout) && currentTime - wrapper.getCreateTime() >= missingJobRunnerTimeout;
    }

    public static boolean isSpecificJobRunnerMissing(CallbackWrapper wrapper, Map<String, Long> knownRenderers, long currentTime, long serverStartTime, long missingJobRunnerTimeout) {
        if (!wrapper.isGrabbedByJobRunner() && currentTime - serverStartTime >= missingJobRunnerTimeout && wrapper.getJob().getJobResourceRequirements().getJobRunnerIDs().size() > 0 && currentTime - wrapper.getCreateTime() >= missingJobRunnerTimeout) {
            for (String rendererID : knownRenderers.keySet()) {
                if (!wrapper.getJob().getJobResourceRequirements().matchesJobRunner(rendererID)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static void findLatestHeartbeatTimes(Collection<JobRendererInfo> renderers, Map<String, Long> knownRendererTypes, Map<String, Long> knownRenderers) {
        for (JobRendererInfo jobRendererInfo : renderers) {
            knownRenderers.put(jobRendererInfo.getRendererName(), jobRendererInfo.getLastHeartBeatTime());
            for (String appID : jobRendererInfo.getApplicationIDs()) {
                Long lastTime = knownRendererTypes.get(appID);
                if (lastTime != null && jobRendererInfo.getLastHeartBeatTime() <= lastTime) continue;
                knownRendererTypes.put(appID, jobRendererInfo.getLastHeartBeatTime());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupRendererCache() {
        Collection<JobRendererInfo> renderers = this.getJobRendererSnapshots();
        List<String> renderersToDelete = JMSExecutionProvider.checkRendererStaleness(System.currentTimeMillis(), renderers, this.mRendererCleanupTimeout, this.mServerStartTime);
        if (renderersToDelete.size() > 0) {
            JMSExecutionProvider jMSExecutionProvider = this;
            synchronized (jMSExecutionProvider) {
                for (String id : renderersToDelete) {
                    this.mRenderers.remove(id);
                }
            }
        }
    }

    public static List<String> checkRendererStaleness(long currentTime, Collection<JobRendererInfo> renderers, long cleanupTimeout, long serverStartTime) {
        ArrayList<String> renderersToDelete = new ArrayList<String>();
        for (JobRendererInfo jobRendererInfo : renderers) {
            if (currentTime - jobRendererInfo.getLastHeartBeatTime() < cleanupTimeout || currentTime - serverStartTime < cleanupTimeout) continue;
            renderersToDelete.add(jobRendererInfo.getRendererName());
        }
        return renderersToDelete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupApplicationIDCache() {
        HashMap<String, Long> appIDs = new HashMap<String, Long>();
        JMSExecutionProvider jMSExecutionProvider = this;
        synchronized (jMSExecutionProvider) {
            appIDs.putAll(this.mRecentApplicationIDs);
        }
        List<String> itemsToDelete = JMSExecutionProvider.checkAppIDStaleness(appIDs, System.currentTimeMillis(), this.mApplicationIDCleanupTimeout, this.mServerStartTime);
        if (itemsToDelete.size() > 0) {
            JMSExecutionProvider jMSExecutionProvider2 = this;
            synchronized (jMSExecutionProvider2) {
                for (String queue : itemsToDelete) {
                    this.mLogger.logMessage(Level.INFO, "Queue aged out; removing: " + queue);
                    this.mRecentApplicationIDs.remove(queue);
                }
            }
        }
    }

    public static List<String> checkAppIDStaleness(Map<String, Long> appIDs, long currentTime, long appIDTimeout, long serverStartTime) {
        ArrayList<String> itemsToDelete = new ArrayList<String>();
        for (Map.Entry<String, Long> idEntry : appIDs.entrySet()) {
            if (currentTime - idEntry.getValue() < appIDTimeout || currentTime - serverStartTime < appIDTimeout) continue;
            itemsToDelete.add(idEntry.getKey());
        }
        return itemsToDelete;
    }

    private boolean removeJobFromQueue(String rendevousID) {
        this.mLogger.logMessage(Level.FINE, "Attempting to remove message from job queue: " + rendevousID);
        String messageSelector = "rendevousID='" + rendevousID + "'";
        Message removedMessage = this.mJobQueue.receiveSelected(messageSelector);
        if (removedMessage != null) {
            this.mLogger.logMessage(Level.FINE, "Removed message from job queue, rendevousID=" + rendevousID);
            return true;
        }
        this.mLogger.logMessage(Level.INFO, "Failed to remove message from job queue, rendevousID=" + rendevousID);
        return false;
    }

    private void removeJobFromQueue(CallbackWrapper wrapper) {
        if (this.removeJobFromQueue(wrapper.getCallback().getRendevousID())) {
            this.mLogger.logMessage(Level.FINE, "Removed message from job queue, name=" + wrapper.getJob().getName() + " rendevousID=" + wrapper.getCallback().getRendevousID());
        } else {
            this.mLogger.logMessage(Level.INFO, "Failed to remove message from job queue, name=" + wrapper.getJob().getName() + " rendevousID=" + wrapper.getCallback().getRendevousID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadJobRoutingRules() {
        if (this.mPersistenceProvider == null) {
            return;
        }
        Reader r = this.mPersistenceProvider.getReader("", RoutingRulesFile);
        if (r != null) {
            StringBuffer buffer = new StringBuffer();
            BufferedReader br = new BufferedReader(r);
            try {
                Object line;
                while ((line = br.readLine()) != null) {
                    buffer.append((String)line);
                    buffer.append('\n');
                }
                line = this;
                synchronized (line) {
                    this.mJobRoutingRules = RendererRoutingRules.fromXML(buffer.toString());
                }
            }
            catch (Exception e) {
                this.mLogger.logMessage(Level.WARNING, e);
            }
            finally {
                try {
                    br.close();
                }
                catch (Exception e) {
                    this.mLogger.logMessage(Level.WARNING, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadAppIDs() {
        block21: {
            if (this.mPersistenceProvider == null) {
                return;
            }
            Reader r = this.mPersistenceProvider.getReader("", ApplicationIDsFile);
            if (r != null) {
                BufferedReader br = new BufferedReader(r);
                block16: while (true) {
                    try {
                        while (true) {
                            String appID;
                            String line;
                            if ((line = br.readLine()) == null) {
                                break block21;
                            }
                            String[] parts = line.split(MQItemSeparator);
                            if (parts.length < 2 || (appID = parts[0].trim()).length() <= 0) continue;
                            try {
                                long lastTime = Long.parseLong(parts[1]);
                                JMSExecutionProvider jMSExecutionProvider = this;
                                synchronized (jMSExecutionProvider) {
                                    this.mRecentApplicationIDs.put(appID, lastTime);
                                    continue block16;
                                }
                            }
                            catch (Exception e) {
                                this.mLogger.logMessage(Level.WARNING, e);
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        this.mLogger.logMessage(Level.WARNING, e);
                        break block21;
                    }
                }
                finally {
                    try {
                        br.close();
                    }
                    catch (Exception e) {
                        this.mLogger.logMessage(Level.WARNING, e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addOutputToFile(String messageType, String outputName, String instanceID, byte[] data) {
        if (this.mPersistenceProvider == null) {
            return;
        }
        Object o = SyncManager.getInstance().getSyncObject(instanceID);
        try {
            Object object = o;
            synchronized (object) {
                this.mPersistenceProvider.addData(messageType, outputName, data);
            }
        }
        finally {
            SyncManager.getInstance().releaseSyncObject(instanceID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processBroadcastMessage(Message msg) {
        block21: {
            try {
                FlowManager manager = this.getFlowManager();
                if (manager == null || !manager.isServerInitialized()) {
                    return;
                }
                if (!this.isMaster()) {
                    return;
                }
                String messageType = msg.getStringProperty(Tag_resultType);
                if (messageType == null) {
                    return;
                }
                if (!messageType.equals(Const_Heartbeat)) break block21;
                long messageTime = msg.getLongProperty(Tag_timeStamp);
                String renderer = msg.getStringProperty(Tag_rendererID);
                if (renderer != null) {
                    this.mLogger.logMessage(Level.FINEST, "job server heartbeat received: " + renderer);
                }
                String appIDsString = msg.getStringProperty(Tag_applicationIDList);
                String[] appIDs = null;
                if (appIDsString != null) {
                    appIDs = appIDsString.split(MQItemSeparator);
                }
                String rendevousIDsString = msg.getStringProperty(Tag_rendevousIDList);
                String[] rendevousIDs = null;
                if (rendevousIDsString != null) {
                    rendevousIDs = rendevousIDsString.split(MQItemSeparator);
                }
                long totalJobCount = msg.getLongProperty(Tag_totalJobs);
                long upTime = msg.getLongProperty(Tag_upTime);
                int activeJobCount = 0;
                if (rendevousIDs != null) {
                    JMSExecutionProvider jMSExecutionProvider = this;
                    synchronized (jMSExecutionProvider) {
                        for (String id : rendevousIDs) {
                            CallbackWrapper wrapper = this.mOutstandingJobs.get(id);
                            if (wrapper == null) continue;
                            wrapper.updateLastConfirmedTime(messageTime);
                            wrapper.updateGrabbedByJobRunner(true);
                            ++activeJobCount;
                        }
                    }
                }
                ArrayList<String> appIDList = new ArrayList<String>();
                if (appIDs != null) {
                    JMSExecutionProvider jMSExecutionProvider = this;
                    synchronized (jMSExecutionProvider) {
                        for (String appID : appIDs) {
                            if (appID.length() <= 0) continue;
                            this.mRecentApplicationIDs.put(appID, messageTime);
                            appIDList.add(appID);
                        }
                    }
                }
                if (renderer == null) break block21;
                JMSExecutionProvider jMSExecutionProvider = this;
                synchronized (jMSExecutionProvider) {
                    this.mRenderers.put(renderer, new JobRendererInfo(renderer, appIDList, messageTime, activeJobCount, totalJobCount, upTime));
                }
            }
            catch (Exception e) {
                this.mLogger.logMessage(Level.WARNING, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String adjustQueueIfNotAvailable(String queue, CallbackWrapper wrapper) {
        JMSExecutionProvider jMSExecutionProvider = this;
        synchronized (jMSExecutionProvider) {
            Long lastSeenTime = this.mRecentApplicationIDs.get(queue);
            boolean valid = true;
            if (lastSeenTime == null) {
                valid = false;
            }
            if (!valid) {
                this.mLogger.logMessage(Level.FINER, "No job runner appears to exist for application ID: " + queue + "; reassigning job (" + wrapper.getJob().getName() + mFileSeparator + wrapper.getJob().getUniqueID() + ") to the command-line job runner.");
                queue = "DIP.CommandLine";
            }
        }
        return queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean executeJob(Job j, final ExecutionCallback callback, UserInfo userInfo) {
        String applicationCode = j.getExecutionQueue();
        final CallbackWrapper wrapper = new CallbackWrapper(callback, j, userInfo, applicationCode);
        JMSExecutionProvider jMSExecutionProvider = this;
        synchronized (jMSExecutionProvider) {
            this.mOutstandingJobs.put(callback.getRendevousID(), wrapper);
        }
        this.getFlowManager().addActionToNoPersistenceAsyncQueue(new DeferredManagerAction(this.getFlowManager()){

            @Override
            public void execute() throws ShutdownException {
                JMSExecutionProvider.this.postJobToQueue(wrapper);
                JMSExecutionProvider.this.mLogger.logMessage(Level.FINE, "Posted Job:" + callback.getRendevousID() + " for queue: " + wrapper.getExecutionQueue());
            }
        });
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String applyJobRoutingRules(CallbackWrapper wrapper) {
        String queueID = wrapper.getExecutionQueue();
        ArrayList<JobRoutingExpression> routing = new ArrayList<JobRoutingExpression>();
        JMSExecutionProvider jMSExecutionProvider = this;
        synchronized (jMSExecutionProvider) {
            if (this.mJobRoutingRules != null) {
                for (JobRoutingExpression expression : this.mJobRoutingRules.getRules()) {
                    routing.add(expression);
                }
            }
        }
        for (JobRoutingExpression jobRoutingExpression : routing) {
            if (!jobRoutingExpression.evaluate(wrapper.getJob())) continue;
            return jobRoutingExpression.getOutputQueue();
        }
        return queueID;
    }

    private void postJobToQueue(final CallbackWrapper wrapper) {
        if (!this.mFlowManager.isJobLive(wrapper.getCallback().getRendevousID())) {
            return;
        }
        String changedQueue = this.applyJobRoutingRules(wrapper);
        changedQueue = this.adjustQueueIfNotAvailable(changedQueue, wrapper);
        wrapper.overrideExecutionQueue(changedQueue);
        wrapper.updateGrabbedByJobRunner(false);
        this.updateJob(wrapper.getCallback().getRendevousID(), System.currentTimeMillis(), "", wrapper.getExecutionQueue());
        this.mJobQueue.convertAndSend((Object)new Object[0], new MessagePostProcessor(){

            public Message postProcessMessage(Message message) throws JMSException {
                UserInfo user;
                message.setStringProperty(JMSExecutionProvider.Tag_rendevousID, wrapper.getCallback().getRendevousID());
                if (wrapper.getExecutionQueue() != null) {
                    message.setStringProperty(JMSExecutionProvider.Tag_applicationID, wrapper.getExecutionQueue());
                }
                if ((user = wrapper.getUserInfo()) != null) {
                    message.setStringProperty(JMSExecutionProvider.Tag_userID, user.getUserID());
                    message.setStringProperty(JMSExecutionProvider.Tag_password, user.getPassword());
                }
                message.setStringProperty(JMSExecutionProvider.Tag_jobXML, wrapper.getJob().toSerializedForm());
                message.setStringProperty(JMSExecutionProvider.Tag_jobResourceRequirementsString, wrapper.getJob().getJobResourceRequirements().toSerializedForm());
                message.setStringProperty(JMSExecutionProvider.Tag_outputSavePath, JMSExecutionProvider.this.getOutputSavePath(wrapper.getCallback().getFlowID(), wrapper.getJob(), wrapper.getCallback().getFlowInstanceID()));
                message.setIntProperty(JMSExecutionProvider.Tag_Priority, wrapper.getJob().getPriority());
                message.setStringProperty(JMSExecutionProvider.Tag_CallbackServer, JMSExecutionProvider.this.mServerCallbackID);
                message.setJMSPriority(JMSExecutionProvider.mapToJMSPriority(wrapper.getJob().getPriority()));
                return message;
            }
        });
    }

    public static int mapToJMSPriority(int jobPriority) {
        if (jobPriority >= 100) {
            return 9;
        }
        if (jobPriority >= 75) {
            return 7;
        }
        if (jobPriority >= 50) {
            return 4;
        }
        if (jobPriority >= 25) {
            return 2;
        }
        return 0;
    }

    private String getOutputSavePath(String flowID, Job j, String flowInstanceID) {
        return this.getOutputSavePath(flowID, j.getUniqueID(), flowInstanceID);
    }

    private String getOutputSavePath(String flowID, String jobID, String flowInstanceID) {
        return JMSExecutionProvider.escapeFileSegment(flowID) + mFileSeparator + this.getOutputDataFileName(flowInstanceID, jobID);
    }

    private String getOutputDataFileName(String flowInstanceID, String jobID) {
        return JMSExecutionProvider.escapeFileSegment(flowInstanceID) + "_" + jobID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void killJob(String rendevousID, boolean force) {
        block21: {
            try {
                CallbackWrapper callbackWrapper = null;
                JMSExecutionProvider jMSExecutionProvider = this;
                synchronized (jMSExecutionProvider) {
                    callbackWrapper = this.mOutstandingJobs.get(rendevousID);
                }
                CallbackWrapper wrapper = callbackWrapper;
                if (wrapper == null) break block21;
                Message msg = this.mJobQueue.receiveSelected("rendevousID='" + rendevousID + "'");
                if (msg != null) {
                    wrapper.getCallback().markKilled();
                    break block21;
                }
                try {
                    JMSExecutionProvider jMSExecutionProvider2 = this;
                    synchronized (jMSExecutionProvider2) {
                        MapMessage message = this.safeCreateMapMessage();
                        message.setStringProperty(Tag_applicationID, wrapper.getExecutionQueue());
                        message.setStringProperty(Tag_rendevousID, rendevousID);
                        message.setStringProperty(Tag_forceKill, Boolean.toString(force));
                        message.setStringProperty(Tag_resultType, Const_KillRequest);
                        message.setStringProperty(Tag_CallbackServer, this.mServerCallbackID);
                        this.mTopicProducer.send((Message)message);
                    }
                    this.mLogger.logMessage(Level.FINE, "Kill request sent for: " + rendevousID);
                }
                catch (Throwable e) {
                    this.mLogger.logMessage(Level.WARNING, e);
                }
            }
            finally {
                if (force) {
                    this.mLogger.logMessage(Level.FINE, "Job removed from system by engine: " + rendevousID);
                    JMSExecutionProvider jMSExecutionProvider = this;
                    synchronized (jMSExecutionProvider) {
                        this.mOutstandingJobs.remove(rendevousID);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateJob(String rendevousID, long startTime, String rendererName, String jobQueue) {
        CallbackWrapper callbackWrapper = null;
        JMSExecutionProvider jMSExecutionProvider = this;
        synchronized (jMSExecutionProvider) {
            callbackWrapper = this.mOutstandingJobs.get(rendevousID);
        }
        if (callbackWrapper == null) {
            this.getClientLog().logMessage(Level.WARNING, "unknown Job: " + rendevousID + "; maybe it was already completed.  ignoring");
            return;
        }
        callbackWrapper.updateLastConfirmedTime(startTime);
        callbackWrapper.getCallback().updateJobStartInfo(startTime, rendererName, jobQueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markJob(String rendevousID, int statusFlag, int returnCode) {
        CallbackWrapper callbackWrapper = null;
        JMSExecutionProvider jMSExecutionProvider = this;
        synchronized (jMSExecutionProvider) {
            callbackWrapper = this.mOutstandingJobs.remove(rendevousID);
        }
        if (callbackWrapper == null) {
            this.getClientLog().logMessage(Level.WARNING, "unknown Job: " + rendevousID + "; maybe it was already marked.  Ignoring");
            return;
        }
        ExecutionCallback callback = callbackWrapper.getCallback();
        if (statusFlag == 4) {
            if (returnCode == 0) {
                callback.markDone();
            } else {
                callback.markExited(returnCode);
            }
        } else if (statusFlag == 1) {
            callback.markKilled();
        } else {
            callback.markFailedToRun();
        }
    }

    @Override
    public String getWorkerNodePrintString() {
        return "";
    }

    @Override
    public int getMaxHistoriesPerFlow() {
        return this.mMaxHistoriesPerFlow;
    }

    @Override
    public int getMaxRunningFlowLimit() {
        return this.mMaxSimultaneousFlows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canAcceptJob(RunningJob rj) {
        JMSExecutionProvider jMSExecutionProvider = this;
        synchronized (jMSExecutionProvider) {
            if (this.mShuttingDown) {
                return false;
            }
        }
        if (this.mMaxSimultaneousJobs < 0) {
            return true;
        }
        jMSExecutionProvider = this;
        synchronized (jMSExecutionProvider) {
            if (this.mOutstandingJobs.size() >= this.mMaxSimultaneousJobs) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown(long timeout) {
        super.shutdown(timeout);
        JMSExecutionProvider jMSExecutionProvider = this;
        synchronized (jMSExecutionProvider) {
            this.mShuttingDown = true;
        }
        try {
            this.mLogger.logMessage(Level.INFO, "Shutting down scheduling server (JMS)");
            this.cleanupJMSObjects();
            if (this.mTimeoutTimer != null) {
                this.mTimeoutTimer.cancel();
                this.mResultReader.join(timeout / 2L);
                this.mOutputSpooler.join(timeout / 2L);
            }
            if (this.mClusterSupport != null) {
                this.mClusterSupport.cleanup();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TopLevelFlow> getPersistedFlows() {
        Writer journal;
        ArrayList<TopLevelFlow> results = new ArrayList<TopLevelFlow>();
        if (this.mPersistenceProvider == null) {
            return results;
        }
        this.mLogger.logMessage(Level.INFO, "Loading existing flows from persistence area: " + this.mPersistenceProvider.getPath());
        long startTime = System.currentTimeMillis();
        int changeCount = 0;
        boolean failedToReadBlob = true;
        Reader br = this.getAllFlowDefinitionsReader();
        if (br != null) {
            try {
                HashMap<String, TopLevelFlow> flowsRead = new HashMap<String, TopLevelFlow>();
                HashMap<String, String> bufferedFlows = new HashMap<String, String>();
                int bufferBoundary = 60000;
                block24: while (true) {
                    try {
                        String[] flowData;
                        while ((flowData = this.getNextFlowFromJournal((BufferedReader)br)) != null) {
                            if (flowData[1].length() == 0) {
                                TopLevelFlow deletedFlow = (TopLevelFlow)flowsRead.remove(flowData[0]);
                                boolean found = deletedFlow != null;
                                if (!(found |= bufferedFlows.remove(flowData[0]) != null)) {
                                    this.mLogger.logMessage(Level.FINE, "Possible inconsistency reading flow definitions at startup.  Flow not found: " + flowData[0]);
                                }
                                ++changeCount;
                                continue;
                            }
                            bufferedFlows.put(flowData[0], flowData[1]);
                            int parseSize = 0;
                            for (String data : bufferedFlows.values()) {
                                parseSize += data.length();
                            }
                            if (parseSize < bufferBoundary) continue;
                            try {
                                String stringToParse = this.generateFlowParseString(bufferedFlows);
                                bufferedFlows.clear();
                                if (stringToParse.length() == 0) continue;
                                List<TopLevelFlow> flows = TopLevelFlow.createMultipleFromXML(new BufferedReader(new StringReader(stringToParse)), this.mLogger);
                                Iterator<TopLevelFlow> iterator = flows.iterator();
                                while (true) {
                                    if (!iterator.hasNext()) continue block24;
                                    TopLevelFlow flow = iterator.next();
                                    flowsRead.put(flow.getID(), flow);
                                }
                            }
                            catch (SchedulerException e) {
                                this.mLogger.logMessage(Level.WARNING, e);
                            }
                        }
                    }
                    catch (Exception e) {
                        this.mLogger.logMessage(Level.WARNING, e);
                        continue;
                    }
                    break;
                }
                try {
                    String stringToParse = this.generateFlowParseString(bufferedFlows);
                    if (stringToParse.length() > 0) {
                        List<TopLevelFlow> flows = TopLevelFlow.createMultipleFromXML(new BufferedReader(new StringReader(stringToParse)), this.mLogger);
                        Iterator e = flows.iterator();
                        while (e.hasNext()) {
                            TopLevelFlow flow = (TopLevelFlow)e.next();
                            flowsRead.put(flow.getID(), flow);
                        }
                    }
                }
                catch (SchedulerException e) {
                    this.mLogger.logMessage(Level.WARNING, e);
                }
                results.addAll(flowsRead.values());
                failedToReadBlob = false;
            }
            finally {
                try {
                    br.close();
                }
                catch (IOException e) {
                    this.mLogger.logMessage(Level.WARNING, e);
                }
            }
        }
        long endTime = System.currentTimeMillis();
        this.mLogger.logMessage(Level.FINE, "Loading persisted flows (" + results.size() + ")completed in (ms): " + (endTime - startTime));
        if ((changeCount > 0 || failedToReadBlob) && (journal = this.getAllFlowDefinitionsWriter(false)) != null) {
            BufferedWriter writer = new BufferedWriter(journal);
            try {
                for (TopLevelFlow flow : results) {
                    this.journalFlow(writer, flow);
                }
            }
            catch (Exception e) {
                this.mLogger.logMessage(Level.WARNING, e);
            }
            finally {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    this.mLogger.logMessage(Level.WARNING, e);
                }
            }
        }
        return results;
    }

    private String generateFlowParseString(Map<String, String> bufferedFlows) {
        if (bufferedFlows.size() == 0) {
            return "";
        }
        int count = 0;
        StringBuffer buffer = new StringBuffer(70000);
        String startFlowFileTag = "<FlowFile>";
        String endFlowFileTag = "</FlowFile>";
        buffer.append(startFlowFileTag);
        for (String flowDef : bufferedFlows.values()) {
            int startTag = flowDef.indexOf(startFlowFileTag);
            int endTag = flowDef.lastIndexOf(endFlowFileTag);
            if (startTag < 0 || endTag < 0) continue;
            String trimmedString = flowDef.substring(startTag + startFlowFileTag.length(), endTag);
            buffer.append(trimmedString);
            ++count;
        }
        buffer.append(endFlowFileTag);
        if (count == 0) {
            return "";
        }
        return buffer.toString();
    }

    protected void addFlowLineToJournal(BufferedWriter writer, String flowID, int lineCount) throws IOException {
        writer.append(Tag_FlowID);
        writer.append(flowID);
        writer.append(RunHistory.HistorySeparator);
        writer.append(Tag_XMLLines);
        writer.append(Integer.toString(lineCount));
        writer.append(RunHistory.HistorySeparator);
        writer.newLine();
    }

    protected void journalFlow(BufferedWriter writer, TopLevelFlow flow) throws IOException {
        String serialized = flow.toSerializedForm().trim();
        this.addFlowLineToJournal(writer, flow.getID(), this.countNewLines(serialized));
        writer.append(serialized);
        writer.newLine();
    }

    protected int countNewLines(String source) {
        String[] lines = source.split(System.getProperty("line.separator"));
        return lines.length;
    }

    protected String[] getNextFlowFromJournal(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        if (line == null) {
            return null;
        }
        String id = RunHistory.GetParameterFromHistoryLine(line, Tag_FlowID);
        if (id == null) {
            return new String[]{"", ""};
        }
        String lineCount = RunHistory.GetParameterFromHistoryLine(line, Tag_XMLLines);
        if (lineCount == null) {
            return new String[]{"", ""};
        }
        lineCount = lineCount.trim();
        int lines = Integer.parseInt(lineCount);
        StringBuffer buffer = new StringBuffer(lines * 80);
        for (int i = 0; i < lines; ++i) {
            String data = reader.readLine();
            if (data == null) {
                return null;
            }
            buffer.append(data);
            buffer.append('\n');
        }
        return new String[]{id, buffer.toString()};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean saveFlowDefinition(TopLevelFlow flow) {
        block20: {
            boolean bl;
            if (this.mPersistenceProvider == null) {
                return true;
            }
            Object o = SyncManager.getInstance().getSyncObject(SyncKey_FlowDefsFile);
            try {
                Object object = o;
                // MONITORENTER : object
                if (this.mPersistenceProvider.isAppendSupported()) {
                    Writer journalWriter = this.getAllFlowDefinitionsWriter(true);
                    if (journalWriter == null) break block20;
                    try {
                        journalWriter = new BufferedWriter(journalWriter);
                        this.journalFlow((BufferedWriter)journalWriter, flow);
                        boolean bl2 = true;
                        // MONITOREXIT : object
                        SyncManager.getInstance().releaseSyncObject(SyncKey_FlowDefsFile);
                        return bl2;
                    }
                    catch (Exception e) {
                        this.mLogger.logMessage(Level.WARNING, e);
                        break block20;
                    }
                    finally {
                        try {
                            journalWriter.close();
                        }
                        catch (IOException e) {
                            this.mLogger.logMessage(Level.WARNING, e);
                        }
                    }
                }
                bl = true;
            }
            catch (Throwable throwable) {
                SyncManager.getInstance().releaseSyncObject(SyncKey_FlowDefsFile);
                throw throwable;
            }
            SyncManager.getInstance().releaseSyncObject(SyncKey_FlowDefsFile);
            return bl;
        }
        boolean bl = false;
        // MONITOREXIT : object
        SyncManager.getInstance().releaseSyncObject(SyncKey_FlowDefsFile);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveFlowInstance(FlowInstance instance) {
        if (this.mPersistenceProvider == null) {
            return;
        }
        Object o = SyncManager.getInstance().getSyncObject(instance.getFlowHistory().getID());
        try {
            Object object = o;
            synchronized (object) {
                Writer aWriter;
                block11: {
                    aWriter = this.getFlowInstanceWriter(instance);
                    if (aWriter != null) break block11;
                    return;
                }
                try {
                    aWriter = new BufferedWriter(aWriter);
                    aWriter.write(instance.toSerializedForm());
                    aWriter.close();
                }
                catch (Exception e) {
                    this.mLogger.logMessage(Level.WARNING, e);
                }
            }
        }
        finally {
            SyncManager.getInstance().releaseSyncObject(instance.getFlowHistory().getID());
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public FlowInstance getFlowInstance(String flowInstanceID) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 11[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected Reader getAllFlowDefinitionsReader() {
        if (this.mPersistenceProvider == null) {
            return null;
        }
        return this.mPersistenceProvider.getReader("", FlowDefinitionsFile);
    }

    protected Writer getAllFlowDefinitionsWriter(boolean append) {
        if (this.mPersistenceProvider == null || !this.mSaveFlows) {
            return null;
        }
        return this.mPersistenceProvider.getWriter("", FlowDefinitionsFile, append);
    }

    protected Reader getFlowInstanceReader(String instanceID) {
        if (this.mPersistenceProvider == null) {
            return null;
        }
        return this.mPersistenceProvider.getReader(FlowInstanceDir, JMSExecutionProvider.escapeFileSegment(instanceID));
    }

    protected Writer getFlowInstanceWriter(FlowInstance instance) {
        if (this.mPersistenceProvider == null || !this.mSaveInstances) {
            return null;
        }
        return this.mPersistenceProvider.getWriter(FlowInstanceDir, JMSExecutionProvider.escapeFileSegment(instance.getFlowHistory().getID()), false);
    }

    @Override
    public boolean isJobDirectClusteringServer() {
        return false;
    }

    @Override
    public boolean doJobsRunSeparately() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteFlow(TopLevelFlow flow) {
        Object object;
        Object o;
        if (this.mPersistenceProvider == null) {
            return super.deleteFlow(flow);
        }
        if (this.mPersistenceProvider.isAppendSupported()) {
            o = SyncManager.getInstance().getSyncObject(SyncKey_FlowDefsFile);
            try {
                object = o;
                synchronized (object) {
                    Writer journalWriter = this.getAllFlowDefinitionsWriter(true);
                    if (journalWriter != null) {
                        try {
                            journalWriter = new BufferedWriter(journalWriter);
                            this.addFlowLineToJournal((BufferedWriter)journalWriter, flow.getID(), 0);
                        }
                        catch (Exception e) {
                            this.mLogger.logMessage(Level.WARNING, e);
                        }
                        finally {
                            try {
                                journalWriter.close();
                            }
                            catch (IOException e) {
                                this.mLogger.logMessage(Level.WARNING, e);
                            }
                        }
                    }
                }
            }
            finally {
                SyncManager.getInstance().releaseSyncObject(SyncKey_FlowDefsFile);
            }
        }
        o = SyncManager.getInstance().getSyncObject(flow.getID());
        try {
            object = o;
            synchronized (object) {
                this.mPersistenceProvider.deleteDir(Const_STDOUT, JMSExecutionProvider.escapeFileSegment(flow.getID()));
                this.mPersistenceProvider.deleteDir(Const_STDERR, JMSExecutionProvider.escapeFileSegment(flow.getID()));
                boolean bl = super.deleteFlow(flow);
                return bl;
            }
        }
        finally {
            SyncManager.getInstance().releaseSyncObject(flow.getID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restoreRunningJobState(List<RunningFlow> runningFlows) {
        HashMap<String, CallbackWrapper> runningJobs = new HashMap<String, CallbackWrapper>();
        for (RunningFlow rf : runningFlows) {
            if (!(rf.getFlow() instanceof TopLevelFlow)) continue;
            this.getDispatchedJobs((TopLevelFlow)rf.getFlow(), rf.getID(), rf, runningJobs);
        }
        JMSExecutionProvider jMSExecutionProvider = this;
        synchronized (jMSExecutionProvider) {
            for (String rendevousID : runningJobs.keySet()) {
                CallbackWrapper wrapper = (CallbackWrapper)runningJobs.get(rendevousID);
                this.mOutstandingJobs.put(rendevousID, wrapper);
            }
        }
    }

    private void getDispatchedJobs(TopLevelFlow flow, String instanceID, RunningFlow rf, Map<String, CallbackWrapper> runningJobs) {
        List<RunningItem> items = rf.getSubItems();
        for (RunningItem item : items) {
            RunningJob job;
            if (item instanceof RunningFlow) {
                this.getDispatchedJobs(flow, instanceID, (RunningFlow)item, runningJobs);
                continue;
            }
            if (!(item instanceof RunningJob) || (job = (RunningJob)item).getCompletionCode() != 8 || job.getUniqueInstanceID() == null || job.getUniqueInstanceID().length() <= 0) continue;
            String applicationID = job.getJob().getExecutionQueue();
            String flowID = flow.getID();
            UserInfo userInfo = this.getUserInfoForID(job.getUserName());
            CallbackWrapper wrapper = new CallbackWrapper(new ExecutionCallback(this, flowID, instanceID, job.getUniqueInstanceID()), job.getJob(), userInfo, applicationID);
            runningJobs.put(wrapper.getCallback().getRendevousID(), wrapper);
            this.getFlowManager().restoreRunningJobToServer(job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removeOtherHistoryData(FlowHistory history) {
        Object object;
        Object o;
        if (this.mPersistenceProvider == null) {
            return;
        }
        long startTime = System.currentTimeMillis();
        final String prefix = JMSExecutionProvider.escapeFileSegment(history.getID());
        FilenameFilter nameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(prefix);
            }
        };
        String escapedFlowID = JMSExecutionProvider.escapeFileSegment(history.getFlowID());
        List<String> fileNames = this.mPersistenceProvider.listFiles(Const_STDOUT, escapedFlowID, nameFilter);
        for (String name : fileNames) {
            o = SyncManager.getInstance().getSyncObject(history.getID());
            try {
                object = o;
                synchronized (object) {
                    this.mPersistenceProvider.delete("STDOUT/" + escapedFlowID, name);
                }
            }
            finally {
                SyncManager.getInstance().releaseSyncObject(history.getID());
            }
        }
        fileNames = this.mPersistenceProvider.listFiles(Const_STDERR, escapedFlowID, nameFilter);
        for (String name : fileNames) {
            o = SyncManager.getInstance().getSyncObject(history.getID());
            try {
                object = o;
                synchronized (object) {
                    this.mPersistenceProvider.delete("STDERR/" + escapedFlowID, name);
                }
            }
            finally {
                SyncManager.getInstance().releaseSyncObject(history.getID());
            }
        }
        long endTime = System.currentTimeMillis();
        this.mLogger.logMessage(Level.FINER, "Removing extra history data (stdout/stderr): " + history.getID() + " (" + (endTime - startTime) + "ms)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getOutputStreamData(String flowID, String instanceID, String uniqueSubitemID, long startPos, int maxCharacters, StringBuffer buffer) {
        if (this.mPersistenceProvider == null) {
            return -1;
        }
        Object o = SyncManager.getInstance().getSyncObject(instanceID);
        try {
            Object object = o;
            synchronized (object) {
                int n = this.mPersistenceProvider.getData("STDOUT/" + JMSExecutionProvider.escapeFileSegment(flowID), this.getOutputDataFileName(instanceID, uniqueSubitemID), startPos, maxCharacters, buffer);
                return n;
            }
        }
        finally {
            SyncManager.getInstance().releaseSyncObject(instanceID);
        }
    }

    protected String getOutputSaveRelativePath(String flowID, String instanceID, String uniqueSubitemID) {
        return "STDOUT/" + this.getOutputSavePath(flowID, uniqueSubitemID, instanceID);
    }

    protected String getErrorSaveRelativePath(String flowID, String instanceID, String uniqueSubitemID) {
        return "STDERR/" + this.getOutputSavePath(flowID, uniqueSubitemID, instanceID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getErrorStreamData(String flowID, String instanceID, String uniqueSubitemID, long startPos, int maxCharacters, StringBuffer buffer) {
        if (this.mPersistenceProvider == null) {
            return -1;
        }
        Object o = SyncManager.getInstance().getSyncObject(instanceID);
        try {
            Object object = o;
            synchronized (object) {
                int n = this.mPersistenceProvider.getData("STDERR/" + JMSExecutionProvider.escapeFileSegment(flowID), this.getOutputDataFileName(instanceID, uniqueSubitemID), startPos, maxCharacters, buffer);
                return n;
            }
        }
        finally {
            SyncManager.getInstance().releaseSyncObject(instanceID);
        }
    }

    @Override
    public synchronized Collection<JobRendererInfo> getJobRendererSnapshots() {
        ArrayList<JobRendererInfo> list = new ArrayList<JobRendererInfo>();
        list.addAll(this.mRenderers.values());
        return list;
    }

    @Override
    public void addFlowHistoryItem(TopLevelFlow flow, FlowHistory history) {
        if (this.mPersistenceProvider == null) {
            return;
        }
        super.addFlowHistoryItem(flow, history);
    }

    @Override
    public List<FlowHistory> getFlowHistory(Map<TopLevelFlow, Integer> historyRequestMap, UserInfo userInfo) {
        if (this.mPersistenceProvider == null) {
            return new ArrayList<FlowHistory>();
        }
        return super.getFlowHistory(historyRequestMap, userInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePersistedFlowDefinitions(List<TopLevelFlow> allFlows) {
        if (this.mPersistenceProvider == null || !this.mSaveFlows) {
            return;
        }
        if (!this.isMaster()) {
            this.mLogger.logMessage(Level.FINE, "Non-master skipping saving of flow data");
            return;
        }
        Object o = SyncManager.getInstance().getSyncObject(SyncKey_FlowDefsFile);
        try {
            Object object = o;
            synchronized (object) {
                Writer writer;
                if (allFlows.size() == 0) {
                    this.mLogger.logMessage(Level.FINE, "Possible non-master attempted to save flow data (based on zero flow count)");
                }
                if ((writer = this.mPersistenceProvider.getWriter("", FlowDefinitionsFile, false)) != null) {
                    writer = new BufferedWriter(writer);
                    try {
                        for (TopLevelFlow flow : allFlows) {
                            this.journalFlow((BufferedWriter)writer, flow);
                        }
                        writer.close();
                    }
                    catch (Exception e) {
                        this.mLogger.logMessage(Level.WARNING, e);
                    }
                    finally {
                        try {
                            if (writer != null) {
                                writer.close();
                            }
                        }
                        catch (IOException e) {
                            this.mLogger.logMessage(Level.WARNING, e);
                        }
                    }
                }
            }
        }
        finally {
            SyncManager.getInstance().releaseSyncObject(SyncKey_FlowDefsFile);
        }
    }

    @Override
    public void setFlowManager(FlowManager manager) {
        super.setFlowManager(manager);
        manager.setServerConfig(this.mConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void miscellanousMaintenance() {
        block39: {
            Writer writer;
            block38: {
                super.miscellanousMaintenance();
                if (this.mPersistenceProvider == null) {
                    return;
                }
                if (!this.isMaster()) {
                    this.mLogger.logMessage(Level.FINE, "Non-master skipping caching of valid application IDs");
                    return;
                }
                try {
                    writer = this.mPersistenceProvider.getWriter("", ApplicationIDsFile, false);
                    if (writer == null) break block38;
                    writer = new BufferedWriter(writer);
                    try {
                        JMSExecutionProvider jMSExecutionProvider = this;
                        synchronized (jMSExecutionProvider) {
                            for (String appID : this.mRecentApplicationIDs.keySet()) {
                                writer.write(appID);
                                writer.write(MQItemSeparator);
                                writer.write(Long.toString(this.mRecentApplicationIDs.get(appID)));
                                ((BufferedWriter)writer).newLine();
                            }
                        }
                    }
                    catch (Exception e) {
                        this.mLogger.logMessage(Level.WARNING, e);
                    }
                    finally {
                        try {
                            if (writer != null) {
                                writer.close();
                            }
                        }
                        catch (IOException e) {
                            this.mLogger.logMessage(Level.WARNING, e);
                        }
                    }
                }
                catch (Exception e) {
                    this.mLogger.logMessage(Level.WARNING, e);
                }
            }
            try {
                writer = this.mPersistenceProvider.getWriter("", RoutingRulesFile, false);
                if (writer == null) break block39;
                writer = new BufferedWriter(writer);
                try {
                    JMSExecutionProvider e = this;
                    synchronized (e) {
                        if (this.mJobRoutingRules != null) {
                            writer.write(this.mJobRoutingRules.getXMLString());
                        }
                    }
                }
                catch (Exception e) {
                    this.mLogger.logMessage(Level.WARNING, e);
                }
                finally {
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                    }
                    catch (IOException e) {
                        this.mLogger.logMessage(Level.WARNING, e);
                    }
                }
            }
            catch (Exception e) {
                this.mLogger.logMessage(Level.WARNING, e);
            }
        }
    }

    public void handleSASEvent(String fileEventPath) {
        if (this.mFlowManager != null) {
            String filePath = fileEventPath;
            this.mFlowManager.triggerFileEvents(filePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getJobRoutingRulesXML() {
        JMSExecutionProvider jMSExecutionProvider = this;
        synchronized (jMSExecutionProvider) {
            if (this.mJobRoutingRules != null) {
                return this.mJobRoutingRules.getXMLString();
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setJobRoutingRulesXML(String xml) {
        if (xml == null) {
            return false;
        }
        try {
            RendererRoutingRules rules = RendererRoutingRules.fromXML(xml);
            JMSExecutionProvider jMSExecutionProvider = this;
            synchronized (jMSExecutionProvider) {
                this.mJobRoutingRules = rules;
            }
            return true;
        }
        catch (Exception e) {
            this.mLogger.logMessage(Level.WARNING, e);
            return false;
        }
    }

    public static class CallbackWrapper {
        private long mLastConfirmedTime;
        private Job mJob;
        private UserInfo mUserInfo;
        private long mCreateTime;
        private boolean mGrabbedByJobRunner;
        private ExecutionCallback mCallback;
        private String mExecutionQueue;

        public CallbackWrapper(ExecutionCallback callback, Job j, UserInfo userInfo, String appCode) {
            this.mCallback = callback;
            this.mExecutionQueue = appCode;
            this.mLastConfirmedTime = System.currentTimeMillis();
            this.mJob = j;
            this.mUserInfo = userInfo;
            this.mCreateTime = System.currentTimeMillis();
            this.mGrabbedByJobRunner = false;
        }

        public boolean isGrabbedByJobRunner() {
            return this.mGrabbedByJobRunner;
        }

        public void updateGrabbedByJobRunner(boolean grabbed) {
            this.mGrabbedByJobRunner = grabbed;
        }

        public void updateLastConfirmedTime(long newTime) {
            if (newTime > this.mLastConfirmedTime) {
                this.mLastConfirmedTime = newTime;
            }
        }

        public long getLastConfirmedTime() {
            return this.mLastConfirmedTime;
        }

        public Job getJob() {
            return this.mJob;
        }

        public UserInfo getUserInfo() {
            return this.mUserInfo;
        }

        public ExecutionCallback getCallback() {
            return this.mCallback;
        }

        public String getExecutionQueue() {
            return this.mExecutionQueue;
        }

        public void overrideExecutionQueue(String applicationCode) {
            this.mExecutionQueue = applicationCode;
        }

        public long getCreateTime() {
            return this.mCreateTime;
        }
    }
}

