/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip.engine;

import com.sas.scheduler.api.servers.ip.engine.DeferredManagerAction;
import com.sas.scheduler.api.servers.ip.engine.ExecutionContext;
import com.sas.scheduler.api.servers.ip.engine.ExecutionProvider;
import com.sas.scheduler.api.servers.ip.engine.FlowManager;
import com.sas.scheduler.api.servers.ip.engine.Job;
import com.sas.scheduler.api.servers.ip.engine.JobHistory;
import com.sas.scheduler.api.servers.ip.engine.RunningFlow;
import com.sas.scheduler.api.servers.ip.engine.RunningItem;
import com.sas.scheduler.api.servers.ip.engine.ShutdownException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimerTask;
import java.util.logging.Level;

public class RunningJob
extends RunningItem {
    protected static long mRunningJobUniqueCode = System.currentTimeMillis();
    protected Job mJob = null;
    protected int mReturnCode = 0;
    private boolean mConditionSatisfied;
    protected String mUniqueInstanceCode;
    private volatile boolean mDispatched;
    private String mRendererID;
    private String mRunQueue;
    protected transient ExecutionContext mExecutionContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RunningJob(FlowManager manager) {
        super(manager);
        this.mCompletionCode = 16;
        this.mConditionSatisfied = false;
        FlowManager flowManager = manager;
        synchronized (flowManager) {
            this.mUniqueInstanceCode = Long.toString(mRunningJobUniqueCode++);
        }
        this.mDispatched = false;
        this.mRendererID = "";
        this.mRunQueue = "";
    }

    public RunningJob(FlowManager manager, Job job) {
        this(manager);
        this.mJob = job.copy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean kill(final boolean force) {
        Object object = this.getFlowManager().getJobExecutionSyncObject();
        synchronized (object) {
            if (!this.mComplete) {
                if (this.mCompletionCode == 8) {
                    if (!this.mDispatched) {
                        this.markKilled();
                    } else {
                        this.getFlowManager().getLogger().logMessage(Level.FINER, FlowManager.generateLogString("Kill Job", "Job was in running state: " + this.getUniqueInstanceID()));
                        final ExecutionProvider provider = this.getFlowManager().getExecutionProvider();
                        this.getFlowManager().addActionToNoPersistenceAsyncQueue(new DeferredManagerAction(this.getFlowManager()){

                            @Override
                            public void execute() throws ShutdownException {
                                provider.clusterKillJob(RunningJob.this, force);
                            }
                        });
                        if (force) {
                            this.markKilled();
                        }
                    }
                } else if (this.mCompletionCode == 16) {
                    this.getFlowManager().getLogger().logMessage(Level.FINER, FlowManager.generateLogString("Kill Job", "Job was in wait state: " + this.getUniqueInstanceID()));
                    this.markKilled();
                } else {
                    this.getFlowManager().getLogger().logMessage(Level.WARNING, FlowManager.generateLogString("Kill Job", "Job " + this.getUniqueID() + " in unknown state: not complete but not waiting or running either"));
                }
            }
            return true;
        }
    }

    void markJobInRunningState() {
        if (this.mCompletionCode != 16) {
            this.getFlowManager().getLogger().logMessage(Level.WARNING, FlowManager.generateLogString("Mark Job Running", "Job not in waiting state: " + this.getUniqueInstanceID() + ", state=" + this.getCompletionCode()));
            return;
        }
        this.mCompletionCode = 8;
        this.mStartTime = new GregorianCalendar();
        if (this.getJob().getMaximumRunTime() > 0) {
            this.mDeadlineTime = (Calendar)this.mStartTime.clone();
            this.mDeadlineTime.add(12, this.getJob().getMaximumRunTime());
        }
        this.mConditionSatisfied = true;
        this.notifyTaskListeners(true);
    }

    public void markJobInInitialState() {
        this.mCompletionCode = 16;
        this.mReturnCode = 0;
        this.mStartTime = null;
        this.mFinishTime = null;
        this.mConditionSatisfied = false;
        this.mDispatched = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean execute(Calendar serverTime, String instanceID, Calendar outputNextCheckTime) {
        FlowManager flowManager = this.getFlowManager();
        synchronized (flowManager) {
            if (this.mComplete) {
                return false;
            }
            if (this.mHeld) {
                return false;
            }
            if (this.mStartTime != null) {
                if (this.mDeadlineTime != null) {
                    if (serverTime.getTimeInMillis() >= this.mDeadlineTime.getTimeInMillis()) {
                        this.getFlowManager().getLogger().logMessage(Level.FINE, FlowManager.generateLogString("Execution", "Job " + this.mJob.getName() + "(" + this.getUniqueID() + ") has run out of time; attempting to kill."));
                        this.kill(false);
                        this.getFlowManager().getUtilityTimer().schedule(new TimerTask(){

                            @Override
                            public void run() {
                                RunningJob.this.getFlowManager().addActionToNoPersistenceAsyncQueue(new DeferredManagerAction(RunningJob.this.getFlowManager()){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public void execute() throws ShutdownException {
                                        FlowManager flowManager = RunningJob.this.getFlowManager();
                                        synchronized (flowManager) {
                                            RunningJob.this.kill(true);
                                        }
                                    }
                                });
                            }
                        }, this.getFlowManager().getReluctantKillWait());
                    } else if (outputNextCheckTime.getTimeInMillis() == 0L || this.mDeadlineTime.getTimeInMillis() < outputNextCheckTime.getTimeInMillis()) {
                        outputNextCheckTime.setTimeInMillis(this.mDeadlineTime.getTimeInMillis());
                    }
                }
                return true;
            }
            return true;
        }
    }

    public void markKilled() {
        this.markCompleted(1, 0);
    }

    public void markDone() {
        this.markCompleted(4, 0);
    }

    public void markNotRun() {
        this.markCompleted(32, 0);
    }

    public void markExited(int exitCode) {
        this.markCompleted(2, exitCode);
    }

    public void markFailedToRun() {
        this.markCompleted(128, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markCompleted(int completionCode, int returnCode) {
        FlowManager flowManager = this.getFlowManager();
        synchronized (flowManager) {
            if (this.mCompletionCode != 8 && this.mCompletionCode != 16) {
                this.getFlowManager().getLogger().logMessage(Level.FINE, FlowManager.generateLogString("Mark Completed", "Job was already complete with status: " + this.getCompletionCode() + " JobID=" + this.getUniqueID() + " RendevousID=" + this.getUniqueInstanceID()));
            } else {
                this.mCompletionCode = completionCode;
                this.mReturnCode = returnCode;
                this.mComplete = true;
                if (this.mStartTime != null) {
                    this.mFinishTime = new GregorianCalendar();
                }
                this.notifyTaskListeners(false);
            }
        }
    }

    @Override
    public String getUserName() {
        return this.mJob.getUserName();
    }

    public int getReturnCode() {
        return this.mReturnCode;
    }

    void setReturnCode(int returnCode) {
        this.mReturnCode = returnCode;
    }

    @Override
    public int getExitCode() {
        return this.getReturnCode();
    }

    public Job getJob() {
        return this.mJob;
    }

    public void setConditionSatisifed(boolean satisfied) {
        this.mConditionSatisfied = satisfied;
    }

    public boolean getConditionSatisfied() {
        return this.mConditionSatisfied;
    }

    public String getUniqueInstanceID() {
        return this.mUniqueInstanceCode;
    }

    @Override
    public String getUniqueID() {
        return this.mJob.getUniqueID();
    }

    @Override
    public String getName() {
        return this.mJob.getName();
    }

    @Override
    public void markNotRunnable() {
        super.markNotRunnable();
        this.mReturnCode = 0;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("==========================================");
        buffer.append("Running Job for job: " + this.getName());
        buffer.append('\n');
        buffer.append("Condition satisfied: " + this.getConditionSatisfied());
        buffer.append('\n');
        buffer.append("Status code: " + this.getCompletionCode());
        buffer.append('\n');
        buffer.append("Return code: " + this.getReturnCode());
        buffer.append('\n');
        buffer.append("Creation time: " + this.getCreationTime().getTime());
        buffer.append('\n');
        if (this.getStartTime() != null) {
            buffer.append("Start time: " + this.getStartTime().getTime());
        } else {
            buffer.append("Start time: not started");
        }
        buffer.append('\n');
        if (this.getFinishTime() != null) {
            buffer.append("End time: " + this.getFinishTime().getTime());
        } else {
            buffer.append("Finish time: not finished");
        }
        buffer.append('\n');
        buffer.append("Deadling time: " + this.mDeadlineTime);
        buffer.append('\n');
        buffer.append("Job definition:");
        buffer.append(this.getJob().toString());
        buffer.append('\n');
        buffer.append("==========================================");
        return buffer.toString();
    }

    @Override
    protected RunningItem copy() {
        RunningJob newJob = new RunningJob(this.getFlowManager());
        newJob.copyFrom(this);
        return newJob;
    }

    @Override
    protected void copyFrom(RunningItem sourceItem) {
        super.copyFrom(sourceItem);
        if (sourceItem instanceof RunningJob) {
            RunningJob rJob = (RunningJob)sourceItem;
            this.mConditionSatisfied = rJob.mConditionSatisfied;
            this.mReturnCode = rJob.mReturnCode;
            this.mUniqueInstanceCode = rJob.mUniqueInstanceCode;
            this.mRendererID = rJob.mRendererID;
            this.mRunQueue = rJob.mRunQueue;
            this.mJob = rJob.getJob().copy();
        }
    }

    public boolean isDeleted() {
        RunningItem parent = this.getParent();
        while (parent.getParent() != null) {
            parent = parent.getParent();
        }
        if (parent instanceof RunningFlow) {
            return ((RunningFlow)parent).isDeleted();
        }
        return false;
    }

    public void setExecutionContext(ExecutionContext context) {
        this.mExecutionContext = context;
    }

    public ExecutionContext getExecutionContext() {
        return this.mExecutionContext;
    }

    public void markDispatched() {
        this.mDispatched = true;
    }

    public void initializeFromHistory(JobHistory history) {
        this.mComplete = true;
        this.mCompletionCode = history.getCompletionCode();
        this.mStartTime = history.getStartTime();
        this.mFinishTime = history.getFinishTime();
        this.mHeld = false;
        this.mReturnCode = history.getReturnCode();
        this.mRendererID = history.getJobServerID();
        this.mUniqueInstanceCode = history.getRendevousID();
        if (this.mCompletionCode == 16 || this.mCompletionCode == 8 && !this.getFlowManager().getExecutionProvider().doJobsRunSeparately()) {
            this.mCompletionCode = 16;
            this.mComplete = false;
            this.mConditionSatisfied = false;
            this.mStartTime = null;
            this.mDeadlineTime = null;
        } else if (this.mCompletionCode == 8) {
            this.mComplete = false;
            this.mConditionSatisfied = true;
            this.mDispatched = true;
            if (this.mStartTime == null) {
                this.mStartTime = Calendar.getInstance();
            }
            this.mDeadlineTime = null;
            if (this.getJob().getMaximumRunTime() > 0) {
                this.mDeadlineTime = (Calendar)this.mStartTime.clone();
                this.mDeadlineTime.add(12, this.getJob().getMaximumRunTime());
            }
        }
    }

    public void setRendererID(String rendererID) {
        if (rendererID != null) {
            this.mRendererID = rendererID;
        }
    }

    public String getRendererID() {
        return this.mRendererID;
    }

    public void setRunQueue(String queue) {
        if (queue != null) {
            this.mRunQueue = queue;
        }
    }

    public String getRunQueue() {
        return this.mRunQueue;
    }

    public void setUniqueInstanceID(String rendevousID) {
        if (rendevousID != null) {
            this.mUniqueInstanceCode = rendevousID;
        }
    }
}

