/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip.engine;

import com.sas.scheduler.api.servers.ip.engine.ClientLogger;
import com.sas.scheduler.api.servers.ip.engine.RunningItem;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.logging.Level;

public class RunHistory {
    public static final int COMPLETION_CODE_UNSET = 0;
    public static final int COMPLETION_CODE_KILLED = 1;
    public static final int COMPLETION_CODE_EXIT = 2;
    public static final int COMPLETION_CODE_DONE = 4;
    public static final int COMPLETION_CODE_RUNNING = 8;
    public static final int COMPLETION_CODE_WAITING = 16;
    public static final int COMPLETION_CODE_NOTRUN = 32;
    public static final int COMPLETION_CODE_HELD = 64;
    public static final int COMPLETION_CODE_FAILED_RUN = 128;
    protected static final String mVersion = "2";
    public static String EscapeSequence = "\\char";
    private Calendar mStartTime = null;
    private Calendar mFinishTime = null;
    private String mUserName = "";
    protected int mCompletionCode = 0;
    protected String mUniqueItemID = "";
    private String mItemName = "";
    protected ClientLogger mLogger;
    protected int mRetryAttempts;
    public static char HistorySeparator = (char)124;
    private static final String UserName_Tag = HistorySeparator + "UserName=";
    private static final String StartTime_Tag = HistorySeparator + "StartTime=";
    private static final String FinishTime_Tag = HistorySeparator + "FinishTime=";
    private static final String TimeZoneTag = HistorySeparator + "TimeZone=";
    private static final String FinishState_Tag = HistorySeparator + "FinishState=";
    private static final String UniqueID_Tag = HistorySeparator + "UniqueID=";
    private static final String ItemName_Tag = HistorySeparator + "ItemName=";
    private static final String Version_Tag = HistorySeparator + "Version=";
    private static final String RetryAttempts_Tag = HistorySeparator + "Retries=";

    public RunHistory(ClientLogger logger) {
        this.mLogger = logger;
        this.mRetryAttempts = 0;
    }

    public RunHistory(RunningItem completedItem, ClientLogger logger) {
        this(logger);
        this.mStartTime = completedItem.getStartTime() != null ? (Calendar)completedItem.getStartTime().clone() : null;
        this.mFinishTime = completedItem.getFinishTime() != null ? (Calendar)completedItem.getFinishTime().clone() : null;
        this.mUserName = completedItem.getUserName();
        this.mItemName = completedItem.getName();
        this.mCompletionCode = completedItem.getCompletionCode();
        this.mRetryAttempts = completedItem.getRetryAttempts();
    }

    public String toSerializedForm() {
        StringBuffer buffer = new StringBuffer();
        this.toSerializedForm(buffer);
        buffer.append("\n");
        buffer.append("#\n");
        return buffer.toString();
    }

    public String getItemName() {
        return this.mItemName;
    }

    public String getUniqueID() {
        return this.mUniqueItemID;
    }

    protected void toSerializedForm(StringBuffer buffer) {
        buffer.append(Version_Tag);
        buffer.append(mVersion);
        buffer.append(UserName_Tag);
        buffer.append(RunHistory.getEscapedString(this.mUserName));
        buffer.append(StartTime_Tag);
        this.calendarToBuffer(buffer, this.mStartTime);
        buffer.append(FinishTime_Tag);
        this.calendarToBuffer(buffer, this.mFinishTime);
        buffer.append(TimeZoneTag);
        if (this.mStartTime != null) {
            buffer.append(RunHistory.getEscapedString(this.mStartTime.getTimeZone().getID()));
        }
        buffer.append(FinishState_Tag);
        buffer.append(this.mCompletionCode);
        buffer.append(UniqueID_Tag);
        buffer.append(RunHistory.getEscapedString(this.mUniqueItemID));
        buffer.append(ItemName_Tag);
        buffer.append(RunHistory.getEscapedString(this.mItemName));
        buffer.append(RetryAttempts_Tag);
        buffer.append(Integer.toString(this.mRetryAttempts));
    }

    public static String getUnescapedString(String escapedName) {
        if (escapedName.indexOf(EscapeSequence) < 0) {
            return escapedName;
        }
        StringBuffer buffer = new StringBuffer(escapedName.length());
        int stringLength = escapedName.length();
        for (int i = 0; i < stringLength; ++i) {
            int nextSlash;
            char character = escapedName.charAt(i);
            boolean characterCodeProcessed = false;
            if (character == '\\' && escapedName.substring(i, i + EscapeSequence.length()).equals(EscapeSequence) && (nextSlash = escapedName.indexOf(92, i + EscapeSequence.length())) >= 0) {
                String characterCodeString = escapedName.substring(i + EscapeSequence.length(), nextSlash);
                int characterCode = Integer.parseInt(characterCodeString);
                characterCodeProcessed = true;
                i = nextSlash;
                buffer.append((char)characterCode);
            }
            if (characterCodeProcessed) continue;
            buffer.append(character);
        }
        return buffer.toString();
    }

    public static String getEscapedString(String name) {
        if (name.indexOf(HistorySeparator) < 0 && name.indexOf(13) < 0 && name.indexOf(10) < 0) {
            return name;
        }
        StringBuffer buffer = new StringBuffer(name.length() + 5);
        for (int i = 0; i < name.length(); ++i) {
            char character = name.charAt(i);
            if (character == '\r' || character == '\n' || character == HistorySeparator) {
                buffer.append(EscapeSequence + character + "\\");
                continue;
            }
            buffer.append(character);
        }
        return buffer.toString();
    }

    private void calendarToBuffer(StringBuffer buffer, Calendar time) {
        if (time != null) {
            buffer.append(Long.toString(time.getTimeInMillis()));
        }
    }

    protected int getFullSubItemCount() {
        return 0;
    }

    public static String GetParameterFromHistoryLine(String historyLine, String parmName) {
        int index = historyLine.indexOf(parmName);
        if (index < 0) {
            return "";
        }
        int separatorIndex = historyLine.indexOf(HistorySeparator, index + parmName.length());
        if (separatorIndex < 0) {
            separatorIndex = historyLine.length();
        }
        String dataString = historyLine.substring(index + parmName.length(), separatorIndex);
        return dataString;
    }

    protected void createFromData(String flowLine) {
        this.mUserName = RunHistory.getUnescapedString(RunHistory.GetParameterFromHistoryLine(flowLine, UserName_Tag));
        String startTime = RunHistory.GetParameterFromHistoryLine(flowLine, StartTime_Tag);
        String finishTime = RunHistory.GetParameterFromHistoryLine(flowLine, FinishTime_Tag);
        String timeZone = RunHistory.getUnescapedString(RunHistory.GetParameterFromHistoryLine(flowLine, TimeZoneTag));
        this.mStartTime = this.createCalendarFromString(startTime, timeZone);
        this.mFinishTime = this.createCalendarFromString(finishTime, timeZone);
        String completionCode = RunHistory.GetParameterFromHistoryLine(flowLine, FinishState_Tag);
        try {
            this.mCompletionCode = Integer.parseInt(completionCode);
        }
        catch (Exception e) {
            this.mCompletionCode = 0;
        }
        this.mItemName = RunHistory.getUnescapedString(RunHistory.GetParameterFromHistoryLine(flowLine, ItemName_Tag));
        this.mUniqueItemID = RunHistory.getUnescapedString(RunHistory.GetParameterFromHistoryLine(flowLine, UniqueID_Tag));
        String attemptsString = RunHistory.GetParameterFromHistoryLine(flowLine, RetryAttempts_Tag);
        if (!attemptsString.isEmpty()) {
            try {
                this.mRetryAttempts = Integer.parseInt(attemptsString);
            }
            catch (Exception e) {
                this.mLogger.logMessage(Level.WARNING, e);
            }
        }
    }

    private Calendar createCalendarFromString(String timeString, String timeZoneID) {
        if (timeString.length() == 0) {
            return null;
        }
        GregorianCalendar cal = new GregorianCalendar();
        long utcValue = 0L;
        try {
            utcValue = Long.parseLong(timeString);
        }
        catch (Exception e) {
            this.mLogger.logMessage(Level.WARNING, e);
        }
        cal.setTimeInMillis(utcValue);
        TimeZone timeZone = TimeZone.getTimeZone(timeZoneID);
        if (timeZone != null) {
            ((Calendar)cal).setTimeZone(timeZone);
        }
        return cal;
    }

    public Calendar getFinishTime() {
        return this.mFinishTime;
    }

    public Calendar getStartTime() {
        return this.mStartTime;
    }

    public String getUserName() {
        return this.mUserName;
    }

    public int getCompletionCode() {
        return this.mCompletionCode;
    }

    public String toString() {
        return this.toSerializedForm();
    }

    public ClientLogger getLogger() {
        return this.mLogger;
    }

    public int getRetryAttempts() {
        return this.mRetryAttempts;
    }

    public String getCompletionString() {
        return RunHistory.getCompletionAsString(this.getCompletionCode());
    }

    public static String getCompletionAsString(int code) {
        switch (code) {
            case 4: {
                return "Done";
            }
            case 2: {
                return "Exited";
            }
            case 128: {
                return "FailedToRun";
            }
            case 64: {
                return "Held";
            }
            case 1: {
                return "Killed";
            }
            case 32: {
                return "NotRun";
            }
            case 8: {
                return "Running";
            }
            case 16: {
                return "Waiting";
            }
        }
        return "Unknown";
    }
}

