/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip.engine;

import com.sas.scheduler.api.servers.ip.engine.ClientLogger;
import com.sas.scheduler.api.servers.ip.engine.FileStatusListener;
import com.sas.scheduler.api.servers.ip.engine.FlowManager;
import com.sas.scheduler.api.servers.ip.engine.RunCondition;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RunConditions
extends RunCondition {
    List<RunCondition> mSubConditions = new ArrayList<RunCondition>();
    boolean mAnded = true;
    public static final String XML_Combine_Tag = "CombineWithAnd";
    public static final String XML_RunConditions_Tag = "RunConditions";

    public RunConditions(ClientLogger logger) {
        super(logger);
    }

    public void setCombinationType(boolean useAnd) {
        this.mAnded = useAnd;
    }

    @Override
    boolean isTimeDominant() {
        if (this.mSubConditions.size() == 0) {
            return false;
        }
        boolean seenTimeDominantItems = false;
        boolean seenTimeNonDominantItems = false;
        for (RunCondition condition : this.mSubConditions) {
            boolean timeDominant = condition.isTimeDominant();
            if (timeDominant) {
                seenTimeDominantItems = true;
                continue;
            }
            seenTimeNonDominantItems = true;
        }
        if (this.mAnded) {
            if (seenTimeDominantItems) {
                return true;
            }
        } else {
            if (seenTimeNonDominantItems) {
                return false;
            }
            if (seenTimeDominantItems) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void triggerHasBeenUsed() {
        for (RunCondition condition : this.mSubConditions) {
            condition.triggerHasBeenUsed();
        }
    }

    @Override
    void findRequiredFileTimers(boolean timeIsDominant, List<FileStatusListener> results) {
        if (this.mSubConditions.size() == 0) {
            return;
        }
        boolean timeDominant = timeIsDominant;
        if (this.mAnded && !timeDominant) {
            for (RunCondition condition : this.mSubConditions) {
                boolean timeOnly = condition.isTimeDominant();
                if (!timeOnly) continue;
                timeDominant = true;
                break;
            }
        }
        for (RunCondition condition : this.mSubConditions) {
            condition.findRequiredFileTimers(timeDominant, results);
        }
    }

    public boolean addCondition(RunCondition condition) {
        if (condition != null) {
            this.mSubConditions.add(condition);
            return true;
        }
        return false;
    }

    public void clearConditions() {
        this.mSubConditions.clear();
    }

    @Override
    public boolean willNotRun(FlowManager manager, Calendar startTime, Calendar deadlineTime) {
        for (RunCondition condition : this.mSubConditions) {
            boolean willNotRun = condition.willNotRun(manager, startTime, deadlineTime);
            if (this.mAnded) {
                if (!willNotRun) continue;
                return true;
            }
            if (willNotRun) continue;
            return false;
        }
        return !this.mAnded;
    }

    @Override
    public int canExecute(FlowManager manager, Calendar currentTime, Map<String, Long> usedTimes, Map<String, Long> outputUsedTimes, Calendar outputNextTriggerTime, boolean defaultValue) {
        int canRun;
        int n = canRun = defaultValue ? 56 : 57;
        if (this.mSubConditions.size() == 0) {
            return canRun;
        }
        canRun = this.mAnded ? 56 : 57;
        boolean allNever = true;
        for (RunCondition condition : this.mSubConditions) {
            Calendar nextTriggerTime = (Calendar)outputNextTriggerTime.clone();
            int mightRun = condition.canExecute(manager, currentTime, usedTimes, outputUsedTimes, nextTriggerTime, defaultValue);
            if (nextTriggerTime.getTimeInMillis() > 0L && (nextTriggerTime.getTimeInMillis() < outputNextTriggerTime.getTimeInMillis() || outputNextTriggerTime.getTimeInMillis() == 0L)) {
                outputNextTriggerTime.setTimeInMillis(nextTriggerTime.getTimeInMillis());
            }
            if (mightRun == 56 && !this.mAnded) {
                canRun = 56;
            } else if ((mightRun == 57 || mightRun == 58) && this.mAnded) {
                canRun = 57;
            }
            if (mightRun == 58) continue;
            allNever = false;
        }
        if (allNever) {
            return 58;
        }
        return canRun;
    }

    public void copyFrom(RunConditions runConditions) {
        this.mAnded = runConditions.mAnded;
        for (RunCondition condition : runConditions.mSubConditions) {
            this.addCondition(condition.copy());
        }
        super.copyFrom(runConditions);
    }

    public boolean isEmpty() {
        return this.mSubConditions.size() == 0;
    }

    @Override
    protected void injectXML(Document doc, Element tag) {
        super.injectXML(doc, tag);
        tag.setAttribute(XML_Combine_Tag, Boolean.toString(this.mAnded));
        for (RunCondition condition : this.mSubConditions) {
            condition.serialize(doc, tag);
        }
    }

    @Override
    public void serialize(Document doc, Node parent) {
        Element tag = doc.createElement(XML_RunConditions_Tag);
        parent.appendChild(tag);
        this.injectXML(doc, tag);
    }

    @Override
    public RunCondition copy() {
        RunConditions conditions = new RunConditions(this.mLogger);
        conditions.copyFrom(this);
        return conditions;
    }

    public List<RunCondition> getSubConditions() {
        return this.mSubConditions;
    }

    public boolean isAnded() {
        return this.mAnded;
    }

    public static RunCondition processConditions(Node node, ClientLogger logger) {
        RunConditions conditions = new RunConditions(logger);
        conditions.processAttributes(node.getAttributes());
        Node combinationTag = node.getAttributes().getNamedItem(XML_Combine_Tag);
        if (combinationTag != null) {
            conditions.setCombinationType(Boolean.valueOf(combinationTag.getNodeValue()));
        }
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            RunCondition newCondition = RunCondition.processConditionDirectly(child, logger);
            if (newCondition == null) continue;
            conditions.addCondition(newCondition);
        }
        return conditions;
    }

    @Override
    public void recalculateID(String parentConditionID) {
        super.recalculateID(parentConditionID);
        int i = 0;
        for (RunCondition condition : this.mSubConditions) {
            condition.recalculateID(this.getID() + "." + Integer.toString(i));
            ++i;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof RunConditions)) {
            return false;
        }
        RunConditions other = (RunConditions)obj;
        if (other.mAnded != this.mAnded) {
            return false;
        }
        if (other.mSubConditions.size() != this.mSubConditions.size()) {
            return false;
        }
        for (int i = 0; i < this.mSubConditions.size(); ++i) {
            if (other.mSubConditions.get(i).equals(this.mSubConditions.get(i))) continue;
            return false;
        }
        return super.equals(obj);
    }
}

