/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip.engine;

import com.sas.scheduler.api.servers.ip.engine.ClientLogger;
import com.sas.scheduler.api.servers.ip.engine.RunHistory;
import com.sas.scheduler.api.servers.ip.engine.RunningJob;
import java.util.logging.Level;

public class JobHistory
extends RunHistory {
    private int mReturnCode;
    private static final String Type_Tag = HistorySeparator + "Type=";
    private static final String ReturnCode_Tag = HistorySeparator + "RC=";
    private static final String JobServer_Tag = HistorySeparator + "JobServer=";
    private static final String RendevousID_Tag = HistorySeparator + "RendevousID=";
    private static final String JobType_Tag = HistorySeparator + "JobType=";
    private String mJobServerID;
    private String mRendevousID;
    private String mJobType;

    public JobHistory(ClientLogger logger) {
        super(logger);
        this.mReturnCode = 0;
        this.mCompletionCode = 16;
        this.mJobServerID = "";
        this.mRendevousID = "";
        this.mJobType = "";
    }

    public JobHistory(RunningJob job, ClientLogger logger) {
        super(job, logger);
        String queue;
        this.mReturnCode = job.getReturnCode();
        this.mUniqueItemID = job.getJob().getUniqueID();
        this.mJobServerID = job.getRendererID();
        this.mRendevousID = job.getUniqueInstanceID();
        if (this.mJobServerID.length() == 0 && job.getExecutionContext() != null) {
            this.mJobServerID = job.getExecutionContext().getWorkerNodePrintString();
        }
        if ((queue = job.getRunQueue()).length() == 0) {
            queue = job.getJob().getExecutionQueue();
        }
        this.mJobType = queue;
    }

    @Override
    protected void toSerializedForm(StringBuffer buffer) {
        buffer.append(Type_Tag);
        buffer.append("Job");
        buffer.append(ReturnCode_Tag);
        buffer.append(this.mReturnCode);
        buffer.append(JobServer_Tag);
        buffer.append(this.mJobServerID);
        buffer.append(RendevousID_Tag);
        buffer.append(this.mRendevousID);
        buffer.append(JobType_Tag);
        buffer.append(this.mJobType);
        super.toSerializedForm(buffer);
        buffer.append(HistorySeparator);
    }

    @Override
    public void createFromData(String flowLine) {
        String returnCodeString = RunHistory.GetParameterFromHistoryLine(flowLine, ReturnCode_Tag);
        try {
            this.mReturnCode = Integer.parseInt(returnCodeString);
        }
        catch (NumberFormatException e) {
            this.mLogger.logMessage(Level.WARNING, e);
        }
        this.mJobServerID = RunHistory.GetParameterFromHistoryLine(flowLine, JobServer_Tag);
        this.mJobType = RunHistory.GetParameterFromHistoryLine(flowLine, JobType_Tag);
        this.mRendevousID = RunHistory.GetParameterFromHistoryLine(flowLine, RendevousID_Tag);
        super.createFromData(flowLine);
    }

    public int getReturnCode() {
        return this.mReturnCode;
    }

    void setReturnCode(int returnCode) {
        this.mReturnCode = returnCode;
    }

    public String getJobServerID() {
        return this.mJobServerID;
    }

    public void setJobServerID(String jobServerID) {
        this.mJobServerID = jobServerID;
    }

    public String getRendevousID() {
        return this.mRendevousID;
    }

    public String getJobType() {
        return this.mJobType;
    }
}

