/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip.engine;

import com.sas.scheduler.api.servers.ip.engine.ClientLogger;
import java.util.Properties;
import java.util.logging.Level;

public class IPUtilities {
    public static int getIntegerValue(Properties props, String key, int defaultValue, ClientLogger logger) {
        String numString = (String)props.get(key);
        if (numString != null) {
            try {
                int value = Integer.parseInt(numString);
                if (value >= 0) {
                    return value;
                }
            }
            catch (NumberFormatException e) {
                logger.logMessage(Level.WARNING, e);
            }
        }
        return defaultValue;
    }

    public static long getLongValue(Properties props, String key, long defaultValue, ClientLogger logger) {
        String numString = (String)props.get(key);
        if (numString != null) {
            try {
                long value = Long.parseLong(numString);
                if (value >= 0L) {
                    return value;
                }
            }
            catch (NumberFormatException e) {
                logger.logMessage(Level.WARNING, e);
            }
        }
        return defaultValue;
    }

    public static boolean getBooleanValue(Properties props, String key, boolean defaultValue, ClientLogger logger) {
        String boolString = (String)props.get(key);
        if (boolString != null) {
            try {
                boolean value = Boolean.parseBoolean(boolString);
                return value;
            }
            catch (NumberFormatException e) {
                logger.logMessage(Level.WARNING, e);
            }
        }
        return defaultValue;
    }
}

