/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip.engine;

import com.sas.scheduler.api.servers.ip.engine.ClientLogger;
import com.sas.scheduler.api.servers.ip.engine.FileStatusListener;
import com.sas.scheduler.api.servers.ip.engine.FlowManager;
import com.sas.scheduler.api.servers.ip.engine.RunCondition;
import com.sas.scheduler.api.servers.ip.engine.RunConditions;
import java.io.File;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class FileDependency
extends RunCondition
implements FileStatusListener {
    private String mFilePath;
    private boolean mTriggerValidOnlyWhenStateChanges;
    private transient boolean mCachedStatus;
    public static final int File_NoFile = -1;
    public static final int File_NotChecked = -2;
    protected static final String XML_FilePath_Tag = "FilePath";
    public static final String XML_TriggerRestriction_Tag = "RestrictTrigger";

    public FileDependency(String filePath, ClientLogger logger) {
        super(logger);
        this.mFilePath = filePath;
        this.mTriggerValidOnlyWhenStateChanges = false;
        this.mCachedStatus = false;
    }

    public FileDependency(ClientLogger logger) {
        super(logger);
        this.mFilePath = "";
        this.mTriggerValidOnlyWhenStateChanges = false;
        this.mCachedStatus = false;
    }

    public String getFilePath() {
        return this.mFilePath;
    }

    public void setFilePath(String filePath) {
        if (filePath != null) {
            this.mFilePath = filePath;
        }
    }

    protected boolean fileExists(File f) {
        if (f.exists()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    protected long fileLength(File f) {
        long size = f.length();
        return size;
    }

    protected long fileLastModified(File f) {
        long lastModified = f.lastModified();
        return lastModified;
    }

    public void manuallyMakeConditionValid(boolean isTrigger) {
    }

    public void setTriggerRestriction(boolean validOnlyWhenConditionBecomesSatisfied) {
        this.mTriggerValidOnlyWhenStateChanges = validOnlyWhenConditionBecomesSatisfied;
    }

    public boolean getTriggerRestriction() {
        return this.mTriggerValidOnlyWhenStateChanges;
    }

    protected abstract boolean isConditionSatisfied(boolean[] var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int canExecute(FlowManager manager, Calendar currentTime, Map<String, Long> usedTimes, Map<String, Long> outputUsedTimes, Calendar outputNextTriggerTime, boolean defaultValue) {
        Long lastTimeObject;
        if (outputNextTriggerTime != null) {
            outputNextTriggerTime.setTimeInMillis(currentTime.getTimeInMillis() + 21600000L);
            outputNextTriggerTime.set(13, 0);
            outputNextTriggerTime.set(14, 0);
            outputNextTriggerTime.setTimeInMillis(outputNextTriggerTime.getTimeInMillis());
        }
        if (usedTimes != null && (lastTimeObject = usedTimes.get(this.getID())) != null && lastTimeObject >= currentTime.getTimeInMillis()) {
            return 57;
        }
        FileDependency fileDependency = this;
        synchronized (fileDependency) {
            if (this.mCachedStatus && outputUsedTimes != null) {
                outputUsedTimes.put(this.getID(), currentTime.getTimeInMillis());
            }
            return this.mCachedStatus ? 56 : 57;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateStatus() {
        boolean[] outputDataChanged = new boolean[]{false};
        boolean currentState = this.isConditionSatisfied(outputDataChanged);
        FileDependency fileDependency = this;
        synchronized (fileDependency) {
            if (this.mTriggerValidOnlyWhenStateChanges) {
                if (currentState) {
                    if (outputDataChanged[0]) {
                        this.mLogger.logMessage(Level.FINEST, "File event state changed to true: " + this.toString());
                        this.mCachedStatus = true;
                    }
                } else {
                    this.mCachedStatus = false;
                    this.mLogger.logMessage(Level.FINEST, "File event state changed to false: " + this.toString());
                }
            } else {
                this.mCachedStatus = currentState;
            }
            return this.mCachedStatus;
        }
    }

    public static void findAllFileDependencies(RunCondition condition, List<FileDependency> results) {
        if (condition instanceof FileDependency) {
            results.add((FileDependency)condition);
        } else if (condition instanceof RunConditions) {
            for (RunCondition subCondition : ((RunConditions)condition).getSubConditions()) {
                FileDependency.findAllFileDependencies(subCondition, results);
            }
        }
    }

    @Override
    void findRequiredFileTimers(boolean timeIsDominant, List<FileStatusListener> results) {
        results.add(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void triggerHasBeenUsed() {
        if (this.getTriggerRestriction()) {
            FileDependency fileDependency = this;
            synchronized (fileDependency) {
                this.mCachedStatus = false;
            }
        }
    }

    @Override
    protected void injectXML(Document doc, Element tag) {
        super.injectXML(doc, tag);
        tag.setAttribute(XML_TriggerRestriction_Tag, Boolean.toString(this.getTriggerRestriction()));
        Element filePathTag = doc.createElement(XML_FilePath_Tag);
        tag.appendChild(filePathTag);
        CDATASection filePathSection = doc.createCDATASection(this.getFilePath());
        filePathTag.appendChild(filePathSection);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof FileDependency)) {
            return false;
        }
        FileDependency other = (FileDependency)obj;
        if (other.mTriggerValidOnlyWhenStateChanges != this.mTriggerValidOnlyWhenStateChanges) {
            return false;
        }
        if (!other.mFilePath.equals(this.mFilePath)) {
            return false;
        }
        return super.equals(obj);
    }
}

