/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip.engine;

import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.api.servers.ip.engine.AssociatedAction;
import com.sas.scheduler.api.servers.ip.engine.RunItemExitCodeDependency;
import com.sas.scheduler.api.servers.ip.engine.RunItemStatusDependency;
import com.sas.scheduler.api.servers.ip.engine.RunningFlow;
import com.sas.scheduler.api.servers.ip.engine.RunningItem;
import com.sas.svcs.mail.client.Mail;
import com.sas.svcs.mail.client.MailAddress;
import com.sas.svcs.mail.client.MailServiceInterface;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.logging.Level;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EmailItemStatusAction
extends AssociatedAction {
    public static final String XML_EmailStatus_Tag = "EmailStatusAction";
    public static final String XML_FromEmail_Tag = "FromEmail";
    public static final String XML_ToEmailRecipients_Tag = "ToEmailRecipients";
    public static final String XML_CCEmailRecipients_Tag = "CCEmailRecipients";
    public static final String XML_Locale_Tag = "Locale";
    public static final String XML_TimeZone_Tag = "TimeZoneID";
    protected List<String> mToAddresses = new ArrayList<String>();
    protected List<String> mCCAddresses = new ArrayList<String>();
    protected String mFromAddress = "";
    protected String mTimeZoneID = "";
    protected Locale mLocale = Locale.getDefault();
    protected transient String mEmailBody = "";
    protected transient String mEmailSubject = "";
    private static final String RecipientSeparator = ";";

    public EmailItemStatusAction(boolean onItemStart) {
        super(onItemStart);
    }

    public EmailItemStatusAction(RunItemExitCodeDependency dep) {
        super(dep);
    }

    public EmailItemStatusAction(RunItemStatusDependency dep) {
        super(dep);
    }

    @Override
    public AssociatedAction copy() {
        EmailItemStatusAction emailAction = new EmailItemStatusAction(this.mAtItemStart);
        emailAction.mEmailBody = this.mEmailBody;
        emailAction.mEmailSubject = this.mEmailSubject;
        emailAction.addToAddresses(this.mToAddresses);
        emailAction.addCCAddresses(this.mCCAddresses);
        emailAction.mFromAddress = this.mFromAddress;
        emailAction.mLocale = this.mLocale;
        emailAction.mTimeZoneID = this.mTimeZoneID;
        emailAction.copyFrom(this);
        return emailAction;
    }

    public void addCCAddresses(List<String> addresses) {
        this.mCCAddresses.addAll(addresses);
    }

    public void addToAddresses(List<String> addresses) {
        this.mToAddresses.addAll(addresses);
    }

    public void setFromAddress(String address) {
        if (address != null) {
            this.mFromAddress = address;
        }
    }

    public void setLocale(Locale locale) {
        if (locale != null) {
            this.mLocale = locale;
        }
    }

    public void setTimeZoneID(String id) {
        if (id != null) {
            this.mTimeZoneID = id;
        }
    }

    @Override
    public boolean willExecute(RunningItem item, boolean itemStarting) {
        this.mEmailBody = "";
        this.mEmailSubject = "";
        if (itemStarting != this.mAtItemStart) {
            return false;
        }
        if (this.mAtItemStart) {
            return true;
        }
        if (this.mCondition == null) {
            return true;
        }
        this.mCondition.setDependentItem(item);
        boolean sendEmail = this.mCondition.canExecute(item.getFlowManager(), Calendar.getInstance(), null, null, null, false) == 56;
        return sendEmail;
    }

    @Override
    public void execute(RunningItem item, boolean itemStarting) {
        MailServiceInterface msi = item.getFlowManager().getMailService();
        if (msi == null) {
            item.getFlowManager().getLogger().logMessage(Level.FINE, "Warning: MailService not configured. Notification email cannot be sent.");
            return;
        }
        DateFormat format = SimpleDateFormat.getDateTimeInstance(0, 0, this.mLocale);
        if (this.mTimeZoneID != null && this.mTimeZoneID.length() > 0) {
            format.setTimeZone(TimeZone.getTimeZone(this.mTimeZoneID));
        }
        RunningItem topParent = item;
        while (topParent.getParent() != null) {
            topParent = topParent.getParent();
        }
        String flowName = topParent.getName();
        String itemName = item.getName();
        if (itemName == null || itemName.length() == 0) {
            itemName = item.getUniqueID();
        }
        ResourceBundle mResourceBundle = MetaUtilities.getMyResourceBundle(EmailItemStatusAction.class, this.mLocale);
        if (itemStarting) {
            if (item instanceof RunningFlow) {
                this.mEmailSubject = mResourceBundle.getString("EmailItemStatusAction.flowStartEmailSubject.txt");
                this.mEmailBody = mResourceBundle.getString("EmailItemStatusAction.flowStartEmailBody.txt");
            } else {
                this.mEmailSubject = mResourceBundle.getString("EmailItemStatusAction.jobStartEmailSubject.txt");
                this.mEmailBody = mResourceBundle.getString("EmailItemStatusAction.jobStartEmailBody.txt");
            }
        } else if (item instanceof RunningFlow) {
            this.mEmailSubject = mResourceBundle.getString("EmailItemStatusAction.flowEndEmailSubject.txt");
            this.mEmailBody = mResourceBundle.getString("EmailItemStatusAction.flowEndEmailBody.txt");
        } else {
            this.mEmailSubject = mResourceBundle.getString("EmailItemStatusAction.jobEndEmailSubject.txt");
            this.mEmailBody = mResourceBundle.getString("EmailItemStatusAction.jobEndEmailBody.txt");
        }
        String startTime = format.format(item.getStartTime().getTime());
        String endTime = "";
        if (item.getFinishTime() != null) {
            endTime = format.format(item.getFinishTime().getTime());
        }
        String endStatus = this.getStatusCodeString(item.getCompletionCode());
        this.mEmailSubject = this.replaceTemplateItems(this.mEmailSubject, itemName, flowName, startTime, endTime, endStatus, item.getExitCode());
        this.mEmailBody = this.replaceTemplateItems(this.mEmailBody, itemName, flowName, startTime, endTime, endStatus, item.getExitCode());
        try {
            Mail mail = new Mail();
            ArrayList<MailAddress> toAddresses = new ArrayList<MailAddress>();
            for (String string : this.mToAddresses) {
                MailAddress iAddress = new MailAddress();
                iAddress.setAddress(string);
                toAddresses.add(iAddress);
            }
            mail.setToAddresses(toAddresses.toArray(new MailAddress[0]));
            ArrayList<MailAddress> ccAddresses = new ArrayList<MailAddress>();
            for (String address : this.mCCAddresses) {
                MailAddress iAddress = new MailAddress();
                iAddress.setAddress(address);
                ccAddresses.add(iAddress);
            }
            mail.setCcAddresses(ccAddresses.toArray(new MailAddress[0]));
            mail.setSubject(this.mEmailSubject);
            mail.setTextMessage(this.mEmailBody);
            String string = "<html><pre>" + this.mEmailBody + "</pre></html>";
            mail.setHtmlMessage(string);
            MailAddress fromAddress = new MailAddress();
            fromAddress.setAddress(this.mFromAddress);
            mail.setFromAddress(fromAddress);
            msi.send(mail);
        }
        catch (Exception e) {
            item.getFlowManager().getLogger().logMessage(Level.WARNING, e);
        }
    }

    private String replaceTemplateItems(String source, String itemName, String flowName, String startTime, String endTime, String endStatus, int exitCode) {
        source = source.replace("{ITEMNAME}", itemName);
        source = source.replace("{FLOWNAME}", flowName);
        source = source.replace("{STARTTIME}", startTime);
        source = source.replace("{ENDTIME}", endTime);
        source = source.replace("{ITEMSTATUS}", endStatus);
        source = source.replace("{ITEMEXITCODE}", Integer.toString(exitCode));
        return source;
    }

    private String getStatusCodeString(int statusCode) {
        switch (statusCode) {
            case 4: {
                return "Completed successfully";
            }
            case 2: {
                return "Completed with error code";
            }
            case 128: {
                return "Failed to execute";
            }
            case 1: {
                return "Killed";
            }
            case 32: {
                return "Did not attempt to run";
            }
        }
        return "Unknown";
    }

    @Override
    public void injectXML(Document doc, Element tag) {
        super.injectXML(doc, tag);
        String recipients = "";
        for (String address : this.mToAddresses) {
            recipients = recipients + address;
            recipients = recipients + RecipientSeparator;
        }
        tag.setAttribute(XML_ToEmailRecipients_Tag, recipients);
        recipients = "";
        for (String address : this.mCCAddresses) {
            recipients = recipients + address;
            recipients = recipients + RecipientSeparator;
        }
        tag.setAttribute(XML_CCEmailRecipients_Tag, recipients);
        tag.setAttribute(XML_FromEmail_Tag, this.mFromAddress);
        if (this.mTimeZoneID != null && this.mTimeZoneID.length() > 0) {
            tag.setAttribute(XML_TimeZone_Tag, this.mTimeZoneID);
        }
        if (this.mLocale != null) {
            tag.setAttribute(XML_Locale_Tag, this.mLocale.getLanguage() + RecipientSeparator + this.mLocale.getCountry() + RecipientSeparator + this.mLocale.getVariant());
        }
    }

    @Override
    public void serialize(Document doc, Node parent) {
        Element emailTag = doc.createElement(XML_EmailStatus_Tag);
        parent.appendChild(emailTag);
        this.injectXML(doc, emailTag);
    }

    @Override
    public boolean equals(Object obj) {
        String otherEmail;
        String thisEmail;
        int i;
        if (!(obj instanceof EmailItemStatusAction)) {
            return false;
        }
        EmailItemStatusAction other = (EmailItemStatusAction)obj;
        if (this.mToAddresses.size() != other.mToAddresses.size()) {
            return false;
        }
        for (i = 0; i < this.mToAddresses.size(); ++i) {
            thisEmail = this.mToAddresses.get(i);
            if (thisEmail.equals(otherEmail = other.mToAddresses.get(i))) continue;
            return false;
        }
        if (this.mCCAddresses.size() != other.mCCAddresses.size()) {
            return false;
        }
        for (i = 0; i < this.mCCAddresses.size(); ++i) {
            thisEmail = this.mCCAddresses.get(i);
            if (thisEmail.equals(otherEmail = other.mCCAddresses.get(i))) continue;
            return false;
        }
        if (!this.mFromAddress.equals(other.mFromAddress)) {
            return false;
        }
        if (!this.mTimeZoneID.equals(other.mTimeZoneID)) {
            return false;
        }
        if (!this.mLocale.equals(other.mLocale)) {
            return false;
        }
        return super.equals(other);
    }

    public static AssociatedAction processAction(Node node) {
        if (node instanceof Element) {
            String[] targetStrings;
            Element e = (Element)node;
            ArrayList<String> toRecipients = new ArrayList<String>();
            String targets = e.getAttribute(XML_ToEmailRecipients_Tag);
            for (String target : targetStrings = targets.split(RecipientSeparator)) {
                if (target.trim().length() <= 0) continue;
                toRecipients.add(target.trim());
            }
            ArrayList<String> ccRecipients = new ArrayList<String>();
            targets = e.getAttribute(XML_CCEmailRecipients_Tag);
            for (String target : targetStrings = targets.split(RecipientSeparator)) {
                if (target.trim().length() <= 0) continue;
                ccRecipients.add(target.trim());
            }
            EmailItemStatusAction action = new EmailItemStatusAction(false);
            action.addToAddresses(toRecipients);
            action.addCCAddresses(ccRecipients);
            action.setFromAddress(e.getAttribute(XML_FromEmail_Tag));
            action.setTimeZoneID(e.getAttribute(XML_TimeZone_Tag));
            String localeInfo = e.getAttribute(XML_Locale_Tag);
            String[] localeParts = localeInfo.split(RecipientSeparator, -1);
            if (localeParts.length >= 3) {
                Locale newLocale = new Locale(localeParts[0], localeParts[1], localeParts[2]);
                action.setLocale(newLocale);
            }
            AssociatedAction.processAction(action, e);
            return action;
        }
        return null;
    }
}

