/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip;

import com.sas.scheduler.api.servers.ip.engine.ClientLogger;
import com.sas.scheduler.api.servers.ip.engine.IPUtilities;
import com.sas.scheduler.api.servers.ip.engine.jgroups.JGroupsClusterSupport;
import com.sas.svcs.cluster.DefaultMulticastProperties;
import java.util.Properties;
import java.util.logging.Level;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelException;
import org.jgroups.JChannel;
import org.jgroups.JChannelFactory;
import org.w3c.dom.Element;

public class PIPClusterSupport
extends JGroupsClusterSupport {
    private JChannelFactory mFactory;

    public PIPClusterSupport(String jgroupName, String channelProperties, long timeout, boolean jobServersAreSeparate, Properties serverProperties, ClientLogger logger) throws ChannelException {
        super(jgroupName, channelProperties, timeout, jobServersAreSeparate, true, serverProperties, -1, -1, logger);
    }

    @Override
    protected void createHashChannel(String channelProperties) throws ChannelClosedException, ChannelException {
        if (channelProperties == null) {
            if (this.mFactory != null) {
                try {
                    this.mHashChannel = (JChannel)this.mFactory.createMultiplexerChannel("DIP-stack", "DIPHash");
                    return;
                }
                catch (Exception e) {
                    this.mLogger.logMessage(Level.WARNING, e);
                }
            }
            int port = IPUtilities.getIntegerValue(this.mServerProperties, "PIP.JGroupsPort_HashChannelPort", -1, this.mLogger);
            DefaultMulticastProperties props = new DefaultMulticastProperties();
            props.setPort(port);
            String address = this.mServerProperties.getProperty("PIP.JGroupsMulticastAddress", "228.10.10.10");
            props.setAddress(address);
            int newTTL = IPUtilities.getIntegerValue(this.mServerProperties, "PIP.JGroupsMulticastTTL", 2, this.mLogger);
            if (newTTL < 0 || newTTL > 255) {
                newTTL = 2;
            }
            props.setTtl(newTTL);
            Element properties = props.getPropertiesElement();
            this.mHashChannel = new JChannel(properties);
            return;
        }
        super.createHashChannel(channelProperties);
    }

    @Override
    protected void createMainChannel(String channelProperties) throws ChannelException {
        if (channelProperties == null) {
            boolean allowSingleChannelAttempt = !"false".equalsIgnoreCase(System.getProperty("DIP_DisallowSingleChannel"));
            int port = IPUtilities.getIntegerValue(this.mServerProperties, "PIP.JGroupsPort_MainChannelPort", -1, this.mLogger);
            DefaultMulticastProperties props = new DefaultMulticastProperties();
            props.setPort(port);
            String address = this.mServerProperties.getProperty("PIP.JGroupsMulticastAddress", "228.10.10.10");
            props.setAddress(address);
            int newTTL = IPUtilities.getIntegerValue(this.mServerProperties, "PIP.JGroupsMulticastTTL", 2, this.mLogger);
            if (newTTL < 0 || newTTL > 255) {
                newTTL = 2;
            }
            props.setTtl(newTTL);
            this.mLogger.logMessage(Level.INFO, "PIP main channel port= " + port);
            this.mLogger.logMessage(Level.INFO, "PIP main channel address= " + address);
            this.mLogger.logMessage(Level.INFO, "PIP multicast TTL= " + newTTL);
            Element properties = props.getPropertiesElement();
            if (allowSingleChannelAttempt) {
                try {
                    Element topElement = properties.getOwnerDocument().createElement("protocol_stacks");
                    Element stackElement = properties.getOwnerDocument().createElement("stack");
                    topElement.appendChild(stackElement);
                    stackElement.setAttribute("name", "DIP-stack");
                    stackElement.appendChild(properties);
                    this.mFactory = new JChannelFactory();
                    this.mFactory.setMultiplexerConfig(topElement);
                    this.mChannel = this.mFactory.createMultiplexerChannel("DIP-stack", "DIPmain");
                }
                catch (Exception e) {
                    throw new ChannelException("Failed to multiplex DIP scheduler communication channels", (Throwable)e);
                }
            }
            if (this.mChannel == null) {
                this.mChannel = new JChannel(properties);
            }
            return;
        }
        super.createMainChannel(channelProperties);
    }

    @Override
    public void cleanup() {
        super.cleanup();
        if (this.mFactory != null) {
            this.mFactory.stop();
            this.mFactory.destroy();
        }
    }

    public static int getIntegerValue(Properties props, String key, int defaultValue, ClientLogger logger) {
        return IPUtilities.getIntegerValue(props, key, defaultValue, logger);
    }

    public static long getLongValue(Properties props, String key, long defaultValue, ClientLogger logger) {
        return IPUtilities.getLongValue(props, key, defaultValue, logger);
    }

    public static boolean getBooleanValue(Properties props, String key, boolean defaultValue, ClientLogger logger) {
        return IPUtilities.getBooleanValue(props, key, defaultValue, logger);
    }
}

