/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.report;

import com.sas.iom.SAS.IBinaryStream;
import com.sas.iom.SAS.IFileService;
import com.sas.iom.SAS.IFileref;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SAS.StreamOpenMode;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.metadata.remote.MdException;
import com.sas.scheduler.api.oma.CommandUtilities;
import com.sas.scheduler.api.oma.DeployedFlow;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.api.report.ReportFlowInterface;
import com.sas.scheduler.api.servers.Scheduler;
import com.sas.scheduler.model.SchedulerException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.security.InvalidParameterException;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.omg.CORBA.StringHolder;

public class ReportFlowToXML
implements ReportFlowInterface {
    private Scheduler m_scheduler = null;
    private IWorkspace m_workspace = null;
    private DeployedFlow m_flow = null;
    private String m_outdir = null;
    private IBinaryStream m_outfile = null;
    private StringBuffer m_xmlbuffer = new StringBuffer();
    private String m_name = null;
    private String m_physicalName = null;

    public ReportFlowToXML(DeployedFlow flow, String name, String dirpath, IWorkspace workspace) throws RemoteException, MdException {
        this.m_scheduler = flow.getSchedulingServer();
        this.m_workspace = workspace;
        this.m_flow = flow;
        this.m_outdir = dirpath;
        if (name != null && name.length() > 0) {
            this.setName(name + ".xml");
        } else {
            try {
                String flowname = this.m_scheduler.genFlowName(this.m_flow.getInfo());
                this.setName(MetaUtilities.replaceInvalidCharactersInFileName(flowname) + ".xml");
            }
            catch (SchedulerException se) {
                this.setName(this.m_flow.getName() + ".xml");
            }
            catch (NullPointerException npe) {
                this.setName(this.m_flow.getName() + ".xml");
            }
        }
    }

    @Override
    public boolean hasOutputFile() {
        return this.m_physicalName != null;
    }

    @Override
    public String getOutputFile() {
        return this.m_physicalName;
    }

    @Override
    public String getData() {
        return this.m_xmlbuffer.toString();
    }

    @Override
    public boolean setOUTDir(String dir) {
        this.m_outdir = dir;
        return true;
    }

    @Override
    public String getOUTDir() {
        return this.m_outdir;
    }

    @Override
    public boolean setName(String name) {
        this.m_name = name;
        return true;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public boolean writeFlow() throws MdException, IOException, InvalidParameterException, SchedulerException {
        this.m_xmlbuffer.append("<xmlFlowDef Name=\"" + this.getName() + "\" Version=\"1.0\">\n");
        String control = "<!--These statements have been generated with SAS Scheduling API on \"{0}\". Modify at your own risk.  Changes may render the definition of \"{1}\" unusable.-->";
        GregorianCalendar date = new GregorianCalendar(Locale.US);
        ((Calendar)date).setTimeZone(TimeZone.getTimeZone("GMT"));
        Object[] args = new Object[]{date.getTime(), this.getName()};
        String keycomment = MessageFormat.format(control, args);
        this.m_xmlbuffer.append(keycomment + "\n");
        this.m_xmlbuffer.append(this.m_flow.getXML());
        this.m_xmlbuffer.append("</xmlFlowDef>\n");
        if (this.m_workspace != null) {
            IFileService rio = this.m_workspace.FileService();
            String fileref = "tempXML";
            this.m_physicalName = CommandUtilities.createFullPath(this.m_outdir, this.m_name, -1);
            String accessMethodOrDevice = "DISK";
            String hostOptions = "";
            StringHolder assignedName = new StringHolder(fileref);
            try {
                IFileref fileRef = rio.AssignFileref(fileref, accessMethodOrDevice, this.m_physicalName, hostOptions, assignedName);
                this.m_outfile = fileRef.OpenBinaryStream(StreamOpenMode.StreamOpenModeForWriting);
                this.m_outfile.Write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n".getBytes());
                this.m_outfile.Write(this.m_xmlbuffer.toString().getBytes("UTF8"));
                this.m_outfile.Close();
                rio.DeassignFileref(fileref);
                return true;
            }
            catch (GenericError ge) {
                this.m_physicalName = null;
                return false;
            }
        }
        return false;
    }
}

