/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.oma;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.Tree;
import com.sas.scheduler.api.oma.FolderNode;
import com.sas.scheduler.api.oma.MetaUtilities;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;

public class RepositoryNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = 1L;
    private boolean m_hasExpanded;
    private CMetadata m_repos;
    private MdObjectStore m_store;
    private SoftwareComponent m_bipService;

    public RepositoryNode(CMetadata repos, MdObjectStore store) {
        super(repos);
        this.m_repos = repos;
        this.m_store = store;
    }

    public CMetadata getRepository() {
        return this.m_repos;
    }

    public SoftwareComponent getSoftwareComponent() {
        return this.m_bipService;
    }

    public boolean hasExpanded() {
        return this.m_hasExpanded;
    }

    public void setHasExpanded(boolean expanded) {
        this.m_hasExpanded = expanded;
    }

    public void addChildren() throws MdException, RemoteException {
        if (this.hasExpanded()) {
            return;
        }
        if (this.m_repos != null && this.m_bipService == null) {
            this.m_bipService = MetaUtilities.locateSoftwareComponent(this.m_repos.getId(), this.m_store);
        }
        if (this.m_bipService == null) {
            return;
        }
        List<Object> trees = MetaUtilities.getRootFolders(this.m_store, this.m_bipService);
        for (int index = 0; index < trees.size(); ++index) {
            Tree tree = (Tree)trees.get(index);
            FolderNode nodeTree = new FolderNode(tree, this.m_store);
            this.add(nodeTree);
        }
        this.setHasExpanded(true);
    }
}

