/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.oma;

import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.meta.SASOMI.IOMI;
import com.sas.meta.SASOMI.ISecurity;
import com.sas.meta.SASOMI.ISecurityHelper;
import com.sas.meta.SASOMI.ISecurityPackage.InvalidCredHandle;
import com.sas.metadata.MetadataWorkspace;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AuthenticationDomain;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.Event;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.Identity;
import com.sas.metadata.remote.IdentityGroup;
import com.sas.metadata.remote.JFJob;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.Login;
import com.sas.metadata.remote.Machine;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryImpl;
import com.sas.metadata.remote.MdModelUtil;
import com.sas.metadata.remote.MdOMRConnection;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdRepositoryUtilImpl;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.MdUtil;
import com.sas.metadata.remote.Permission;
import com.sas.metadata.remote.Person;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.ResponsibleParty;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.StepPrecedence;
import com.sas.metadata.remote.SyncStep;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.metadata.remote.Text;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.TransformationActivity;
import com.sas.metadata.remote.TransformationStep;
import com.sas.metadata.remote.Tree;
import com.sas.net.crypto.SealedString;
import com.sas.scheduler.api.oma.CommandUtilities;
import com.sas.scheduler.api.oma.CompareDeployedFlowObjects;
import com.sas.scheduler.api.oma.CompareJOMAObjects;
import com.sas.scheduler.api.oma.DeployedFlow;
import com.sas.scheduler.api.oma.DeployedJob;
import com.sas.scheduler.api.oma.EventListItem;
import com.sas.scheduler.api.oma.FileEvent;
import com.sas.scheduler.api.oma.FilterRule;
import com.sas.scheduler.api.oma.FilterSelector;
import com.sas.scheduler.api.oma.FolderNode;
import com.sas.scheduler.api.oma.JobEvent;
import com.sas.scheduler.api.oma.MetaUtilitiesContext;
import com.sas.scheduler.api.oma.MetaUtilitiesContextHolder;
import com.sas.scheduler.api.oma.RepositoryNode;
import com.sas.scheduler.api.oma.SubmitFlow;
import com.sas.scheduler.api.oma.TimeEvent;
import com.sas.scheduler.api.servers.Scheduler;
import com.sas.scheduler.api.servers.SchedulerIMPL;
import com.sas.scheduler.api.servers.ip.DIPServiceProxy;
import com.sas.scheduler.api.servers.ip.IPScheduler;
import com.sas.scheduler.api.servers.ip.PIPScheduler;
import com.sas.scheduler.api.servers.lsf.LSFScheduler;
import com.sas.scheduler.api.servers.oozie.OozieScheduler;
import com.sas.scheduler.api.servers.os.OSScheduler;
import com.sas.scheduler.api.servers.sasjfs.SASJFSServiceProxy;
import com.sas.scheduler.api.servers.sasjfs.SASJFScheduler;
import com.sas.scheduler.model.BatchServerInfo;
import com.sas.scheduler.model.CompareDisplayInfoObjects;
import com.sas.scheduler.model.DirectoryInfo;
import com.sas.scheduler.model.DisplayInfo;
import com.sas.scheduler.model.FileEventInfo;
import com.sas.scheduler.model.FlowColumnSelectorModel;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.GeneralUtilities;
import com.sas.scheduler.model.GroupingEventInfo;
import com.sas.scheduler.model.IRecurrenceInfo;
import com.sas.scheduler.model.JobColumnSelectorModel;
import com.sas.scheduler.model.JobInfo;
import com.sas.scheduler.model.OpaqueRecurrence;
import com.sas.scheduler.model.SASAppServer;
import com.sas.scheduler.model.SASFolder;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.SchedulerServerInfo;
import com.sas.scheduler.model.TimeEventInfo;
import com.sas.scheduler.model.TriggerEventInfo;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIServer;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.IdentityInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserIdentityInterface;
import java.io.OutputStream;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.rmi.RemoteException;
import java.security.InvalidParameterException;
import java.security.acl.NotOwnerException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.omg.CORBA.Object;
import org.omg.CORBA.StringHolder;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.CosNaming.NamingContextPackage.NotFoundReason;
import org.omg.PortableServer.CurrentPackage.NoContext;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class MetaUtilities {
    private static final ResourceBundle m_bundle = MetaUtilities.getMyResourceBundle(MetaUtilities.class);
    private static final Logger LOGGER = LogManager.getLogger(MetaUtilities.class);
    public static final String OMR_DATEFORMAT = "ddMMMyyyy:HH:mm:ss";
    private static Hashtable<String, ImageIcon> m_ImageCache = new Hashtable();
    private static Map<String, Scheduler> m_schedulerCache = Collections.synchronizedMap(new HashMap());
    private static MdFactory m_defaultMdFactory;
    private static MdObjectStore m_defaultMdStore;
    private static SessionContextInterface m_sessionContextInterface;
    public static final String OMR_FOLDER_DEFAULT = "/Shared Data";
    private static String m_OMRDefaultFolder;
    private static boolean m_LSFAppServerResource;
    private static boolean m_portableTimeEvent;
    public static final int OMIFLAG_MULTI = 8584;
    public static final int OMIFLAG_MULTI_TEMPLATE = 8588;
    private static final String JobObjects_Template = "<Templates><Job><JFJobs/><Trees/></Job></Templates>";
    public static final int DefaultLineBufferSize = 1024;
    public static final int DefaultBlockBufferSize = Short.MAX_VALUE;
    public static final int SHORT_REPOSITORY_ID_SIZE = 8;
    public static final String TEMPLATE_FullFlowInfo = "<Templates><JFJob><JobActivities/><ComputeLocations/><Properties/><Trees/><Steps/></JFJob><TransformationActivity><Steps/></TransformationActivity><SyncStep><SuccessorDependencies/><PredecessorDependencies/><TriggeredEvents/><TriggeringEvents/></SyncStep><Event><Properties/></Event><TransformationStep><Properties/><SuccessorDependencies/><PredecessorDependencies/><Transformations/></TransformationStep></Templates>";
    public static final String TEMPLATE_LeanFlowJobInfo = "<Templates><JFJob><JobActivities/><Steps/></JFJob><TransformationActivity><Steps/></TransformationActivity><TransformationStep><Transformations/></TransformationStep></Templates>";
    public static final String TEMPLATE_BasicFlowJobInfo = "<Templates><JFJob><JobActivities/><TargetSpecifications/><Trees/><Steps/></JFJob><TransformationActivity><Steps/></TransformationActivity><TransformationStep><Transformations/></TransformationStep></Templates>";
    public static final String TEMPLATE_FullFlowJobInfo = "<Templates><JFJob><JobActivities/><ComputeLocations/><TargetSpecifications/><Properties/><Trees/><Steps/><AssociatedJob/><SourceCode/><SourceSpecifications/></JFJob><TransformationActivity><Steps/></TransformationActivity><SyncStep><SuccessorDependencies/><PredecessorDependencies/><TriggeredEvents/><TriggeringEvents/></SyncStep><Event><Properties/></Event><TransformationStep><Properties/><SuccessorDependencies/><PredecessorDependencies/><Transformations/></TransformationStep></Templates>";
    public static final String TEMPLATE_FlowsInRepository = "<Templates><JFJob><JobActivities/><ComputeLocations/><Properties/><Trees/><Steps/></JFJob><TransformationActivity><Steps/></TransformationActivity></Templates>";
    public static final String TEMPLATE_BasicFlowsInRepository = "<Templates><JFJob><ComputeLocations/><Properties/><Trees/><Steps/></JFJob></Templates>";
    public static final String TEMPLATE_JobsInFlow = "<Templates><JFJob><JobActivities/><ComputeLocations/><TargetSpecifications/><Properties/><Trees/><AssociatedJob/><SourceCode/><SourceSpecifications/></JFJob></Templates>";
    public static final String TEMPLATE_JobsInRepository = "<Templates><JFJob><ComputeLocations/><TargetSpecifications/><Properties/><Trees/><AssociatedJob/><SourceCode/><SourceSpecifications/></JFJob></Templates>";
    public static final String TEMPLATE_BasicJobsInRepository = "<Templates><JFJob><TargetSpecifications/><Properties/><Trees/></JFJob></Templates>";
    public static final String INVALIDCHARACTERS;
    public static final String INVALIDFILENAMECHARACTERS;
    public static final String INVALIDFLOWNAMECHARACTERS;
    public static final String INVALIDJOBNAMECHARACTERS;
    public static final char SUBCHAR;
    public static final String BATCHSERVER_DataStepServerID = "e20e54b3-e5f4-47ed-b21d-03109bf9a4b8";
    public static final String BATCHSERVER_JavaServerID = "0069e914-b58c-4094-a686-a87df433ec4b";
    public static final String BATCHSERVER_GenericServerID = "a1ff485f-9e44-4c82-90b5-062916cfa9b9";
    public static final String SCH_Platform_JobScheduler_ID = "d7111ce7-c910-4227-8b3d-af4533660891";
    public static final int ANY_BATCH_SERVER = -1;
    public static final int GENERIC_BATCH_SERVER = 0;
    public static final int DATA_STEP_BATCH_SERVER = 1;
    public static final int JAVA_BATCH_SERVER = 2;
    public static final int JAVA_BATCH_CampaignManager = 10;
    public static final int JAVA_BATCH_BusinessReportManager = 11;
    public static final int ANY_SCHEDULE_SERVER = 100;
    public static final int PLATFORM_SCHEDULE_SERVER = 101;
    public static final int PLATFORM_PM_SCHEDULE_SERVER = 102;
    public static final int PLATFORM_JS_SCHEDULE_SERVER = 103;
    public static final int OS_SCHEDULE_SERVER = 104;
    public static final String MASTER_FLOW_ROLE = "MasterFlow";
    public static final String FLOW_ROLE = "SCHEDULER_FLOW";
    public static final String FLOW_ROLE_MARK_DELETE = "SCHEDULER_FLOW_DELETE";
    public static final String JOB_ROLE = "SCHEDULER_JOB";
    public static final String BRIDGE_JOB_TRANSFORM_ROLE = "SCHEDULER_BRIDGE_JOB";
    public static final String TERMINAL_JOB_TRANSFORM_ROLE = "SCHEDULER_TERMINAL_JOB";
    public static final String MISCJOB_ROLE = "SCHEDULER_MISC_JOB";
    public static final String JOB_ROLE_MARK_DELETE = "SCHEDULER_JOB_DELETE";
    public static final String SCHEDULER_SERVER_ROLE = "Scheduler";
    public static final String SYSIN_FILE_ROLE = "SourceCode";
    public static final int FLOWBYGROUP_NAME = 0;
    public static final int FLOWBYGROUP_APPLICATION = 1;
    public static final int FLOWBYGROUP_SERVER = 2;
    public static final int FLOWBYGROUP_USER = 3;
    public static final int FLOWBYGROUP_JOBS = 4;
    public static final int FLOWBYGROUP_MAX = 5;
    public static final String PropertyTypeName = "Type";
    public static final String PropertyTypeEventDependency = "EventDependency";
    public static final String PropertyTypeJobDependency = "JobDependency";
    public static final String PropertyTypeJobDependencies = "JobDependencyGroup";
    public static final String PropertyJobEventName = "JobEvent";
    public static final String PropSubType = "SubType";
    public static final String PropLogOpt = "LogOpt";
    public static final String PropLogDir = "LogDir";
    public static final String PropLogExt = "LogExt";
    public static final String PropOutputOpt = "OutputOpt";
    public static final String PropOutputDir = "OutputDir";
    public static final String PropOutputExt = "OutputExt";
    public static final String PropFileOpt = "FileOpt";
    public static final String PropLogParams = "LogParams";
    public static final String PropHostType = "HostType";
    public static final String PropJCLDir = "JCLDir";
    public static final String PropCmdArgs = "CmdArgs";
    public static final String PropRunAs = "RunAs";
    public static final String PropResources = "Resources";
    public static final String PropPriority = "Priority";
    public static final String PropEncodedCmdArgs = "EncodedCmdArgs";
    public static final String PropLogging = "LogFlag";
    public static final String PropOuptut = "OutputFlag";
    public static final String PropSASSchedulingDetails = "SCHEDULINGDETAILS";
    public static final String PropCommonArgs = "CommonArgs";
    public static final String PropVMSCommonArgs = "VMSCommonArgs";
    public static final String PropCmdLine = "CmdLine";
    public static final String PropLSfqid = "LSfqid";
    private static final int RETURN_JFJOB = 0;
    private static final int RETURN_DEPLOYEDJOB = 1;
    private static final int RETURN_JOBINFO = 2;
    private static final int ASSOC_FLAGS = 264;
    private static final List<String> SOFTWARETREES_LIST;
    private static final List<String> SUBTREES_LIST;

    private MetaUtilities() {
    }

    public static void clearCaches() {
        m_ImageCache = new Hashtable();
        Set<String> keys = m_schedulerCache.keySet();
        for (String key : keys) {
            Scheduler sch = m_schedulerCache.get(key);
            sch.closeConnection();
        }
        m_schedulerCache = Collections.synchronizedMap(new HashMap());
    }

    public static Document parseXML(String strXML) throws SchedulerException {
        return GeneralUtilities.parseXML((String)strXML);
    }

    public static boolean isDependenciesEnabled(Scheduler scheduler, DeployedFlow flow) throws RemoteException, MdException {
        try {
            return scheduler != null ? scheduler.isDependenciesEnabled() : true;
        }
        catch (InvalidParameterException ex) {
            ServerComponent sc;
            String classid;
            if (flow != null && (classid = (sc = flow.getSchedulerComponent()).getClassIdentifier()).compareTo("b379c9c1-89e0-4e72-ba43-6a416899b5dd") == 0) {
                int major = sc.getMajor();
                int minor = sc.getMinor();
                if (major == 9 && minor == 1) {
                    return false;
                }
            }
            return true;
        }
    }

    public static boolean isValidFlowName(String name) {
        int namelen = name.length();
        if (namelen == 0) {
            return false;
        }
        OSScheduler ossch = new OSScheduler(new SchedulerServerInfo(null, "b379c9c1-89e0-4e72-ba43-6a416899b5dd"));
        SASJFScheduler jfsch = new SASJFScheduler(new SchedulerServerInfo(null, "8b4dc45a-f7c7-11e7-8c3f-9a214cf093ae"));
        IPScheduler ipsch = new IPScheduler(new SchedulerServerInfo(null, "c8b4baf0-5f9f-471e-ba76-1201e1e81aef"));
        return LSFScheduler.isValidFlowName2(name) && ossch.isValidFlowName(name) && jfsch.isValidFlowName(name) && ipsch.isValidFlowName(name);
    }

    public static boolean isValidFilename(String strName) {
        int slen = INVALIDFILENAMECHARACTERS.length();
        for (int i = 0; i < slen; ++i) {
            char c = INVALIDFILENAMECHARACTERS.charAt(i);
            if (strName.indexOf(c) == -1) continue;
            return false;
        }
        return true;
    }

    public static String makeValidFilename(String nameStr) {
        int slen = INVALIDFILENAMECHARACTERS.length();
        for (int i = 0; i < slen; ++i) {
            char c = INVALIDFILENAMECHARACTERS.charAt(i);
            if (nameStr.indexOf(c) == -1) continue;
            nameStr = nameStr.replace(c, SUBCHAR);
        }
        return nameStr;
    }

    public static String makeValidFilename(String nameStr, Scheduler scheduler) {
        char subchar = scheduler.getSubstitutionChar();
        String invalidCharacters = scheduler.getInvalidChars(true);
        int slen = invalidCharacters.length();
        for (int i = 0; i < slen; ++i) {
            char c = invalidCharacters.charAt(i);
            if (nameStr.indexOf(c) == -1) continue;
            nameStr = nameStr.replace(c, subchar);
        }
        return nameStr;
    }

    public static String makeValidJobName(String nameStr) {
        int slen = nameStr.length();
        for (int i = 0; i < slen; ++i) {
            char c = nameStr.charAt(i);
            if (INVALIDJOBNAMECHARACTERS.indexOf(c) == -1) continue;
            nameStr = nameStr.replace(c, SUBCHAR);
        }
        return nameStr;
    }

    public static String makeValidFlowName(String nameStr) {
        if (nameStr == null) {
            return null;
        }
        char firstChar = nameStr.charAt(0);
        if (!Character.isUnicodeIdentifierStart(firstChar) && firstChar != SUBCHAR) {
            nameStr = SUBCHAR + nameStr;
        }
        int slen = nameStr.length();
        for (int i = 0; i < slen; ++i) {
            char c = nameStr.charAt(i);
            if (INVALIDFLOWNAMECHARACTERS.indexOf(c) == -1) continue;
            nameStr = nameStr.replace(c, SUBCHAR);
        }
        return nameStr;
    }

    public static String makeValidBatchJobName(String nameStr) {
        nameStr = MetaUtilities.makeValidJobName(nameStr);
        return MetaUtilities.makeValidFlowName(nameStr);
    }

    public static String makeValidCalendarName(String nameStr, String invalidCharacters, char substituteCharacter) {
        int slen = invalidCharacters.length();
        if (!Character.isLetter(nameStr.charAt(0))) {
            String prefix = "SAS_";
            nameStr = prefix + nameStr;
        }
        for (int i = 0; i < slen; ++i) {
            char c = invalidCharacters.charAt(i);
            if (nameStr.indexOf(c) < 0) continue;
            nameStr = nameStr.replace(c, substituteCharacter);
        }
        StringBuffer buf = new StringBuffer(nameStr);
        slen = buf.length();
        for (int i = 0; i < slen; ++i) {
            char current = buf.charAt(i);
            if (current != substituteCharacter) continue;
            while (i + 1 < slen && buf.charAt(i) == buf.charAt(i + 1)) {
                buf.deleteCharAt(i + 1);
                slen = buf.length();
            }
        }
        if (buf.charAt(buf.length() - 1) == substituteCharacter) {
            buf.deleteCharAt(buf.length() - 1);
        }
        return buf.toString();
    }

    public static String normalize(String text) {
        return GeneralUtilities.normalize((String)text);
    }

    public static String replaceInvalidCharacters(String s) {
        return SchedulerIMPL.replaceInvalidCharacters(s);
    }

    public static String replaceInvalidCharactersInFileName(String s) {
        return SchedulerIMPL.replaceInvalidCharactersInFileName(s);
    }

    public static String replaceInvalidCharactersInFlowName(String s) {
        return SchedulerIMPL.replaceInvalidCharactersInFlowName(s);
    }

    public static String replaceInvalidCharactersInJobName(String s) {
        return SchedulerIMPL.replaceInvalidCharactersInJobName(s);
    }

    public static String replaceString(String s, String searchString, String replaceString) {
        return GeneralUtilities.replaceString((String)s, (String)searchString, (String)replaceString);
    }

    public static String replaceFirstString(String s, String searchString, String replaceString) {
        return GeneralUtilities.replaceFirstString((String)s, (String)searchString, (String)replaceString);
    }

    public static BatchServerInfo getBatchServer(ServerComponent server) throws RemoteException, MdException {
        if (server == null) {
            return null;
        }
        BatchServerInfo binfo = null;
        int operatingSystem = CommandUtilities.getTargetOSForBatchServer(server);
        if (server.getClassIdentifier().equalsIgnoreCase(BATCHSERVER_DataStepServerID)) {
            binfo = new BatchServerInfo(server.getName(), 1, 0, operatingSystem);
        } else if (server.getClassIdentifier().equalsIgnoreCase(BATCHSERVER_JavaServerID)) {
            AssociationList properties = server.getProperties();
            int propsize = properties.size();
            for (int j = 0; j < propsize; ++j) {
                Property property = (Property)properties.get(j);
                if (!property.getPropertyName().equalsIgnoreCase(PropSubType)) continue;
                if (property.getDefaultValue().equalsIgnoreCase("MarketingAutomation")) {
                    binfo = new BatchServerInfo(server.getName(), 2, 10, operatingSystem);
                    break;
                }
                if (property.getDefaultValue().equalsIgnoreCase("BusinessReportManager")) {
                    binfo = new BatchServerInfo(server.getName(), 2, 11, operatingSystem);
                    break;
                }
                if (property.getDefaultValue().equalsIgnoreCase("MarketingOptimization")) {
                    binfo = new BatchServerInfo(server.getName(), 2, 12, operatingSystem);
                    break;
                }
                if (property.getDefaultValue().equalsIgnoreCase("OpRisk")) {
                    binfo = new BatchServerInfo(server.getName(), 2, 21, operatingSystem);
                    break;
                }
                if (property.getDefaultValue().equalsIgnoreCase("JobExecutionService")) {
                    binfo = new BatchServerInfo(server.getName(), 2, 18, operatingSystem);
                    break;
                }
                if (property.getDefaultValue().equalsIgnoreCase("WorkflowService")) {
                    binfo = new BatchServerInfo(server.getName(), 2, 19, operatingSystem);
                    break;
                }
                if (property.getDefaultValue().equalsIgnoreCase("BILineage")) {
                    binfo = new BatchServerInfo(server.getName(), 2, 16, operatingSystem);
                    break;
                }
                if (property.getDefaultValue().equalsIgnoreCase("BILineageScraper")) {
                    binfo = new BatchServerInfo(server.getName(), 2, 20, operatingSystem);
                    break;
                }
                if (property.getDefaultValue().equalsIgnoreCase("EnergyDistribution")) {
                    binfo = new BatchServerInfo(server.getName(), 2, 22, operatingSystem);
                    break;
                }
                if (property.getDefaultValue().equalsIgnoreCase("MetadataInvestigator")) {
                    binfo = new BatchServerInfo(server.getName(), 2, 17, operatingSystem);
                    break;
                }
                if (property.getDefaultValue().equalsIgnoreCase("BusinessPlanning")) {
                    binfo = new BatchServerInfo(server.getName(), 2, 14, operatingSystem);
                    break;
                }
                if (property.getDefaultValue().equalsIgnoreCase("WarrantyAnalysis")) {
                    binfo = new BatchServerInfo(server.getName(), 2, 23, operatingSystem);
                    break;
                }
                if (property.getDefaultValue().equalsIgnoreCase("DigitalMarketing")) {
                    binfo = new BatchServerInfo(server.getName(), 2, 25, operatingSystem);
                    break;
                }
                if (property.getDefaultValue().equalsIgnoreCase("RelationshipLoader")) {
                    binfo = new BatchServerInfo(server.getName(), 2, 24, operatingSystem);
                    break;
                }
                if (property.getDefaultValue().equalsIgnoreCase("VADesigner")) {
                    binfo = new BatchServerInfo(server.getName(), 2, 26, operatingSystem);
                    break;
                }
                if (!property.getDefaultValue().equalsIgnoreCase("StoredProcess")) continue;
                binfo = new BatchServerInfo(server.getName(), 2, 15, operatingSystem);
                break;
            }
            if (binfo == null) {
                binfo = new BatchServerInfo(server.getName(), 2, 0, operatingSystem);
            }
        } else if (server.getClassIdentifier().equalsIgnoreCase("d6644527-7a09-4fe2-8bac-1caca2f6a46c")) {
            binfo = new BatchServerInfo(server.getName(), 3, 0, operatingSystem);
        } else if (server.getClassIdentifier().equalsIgnoreCase(BATCHSERVER_GenericServerID)) {
            binfo = new BatchServerInfo(server.getName(), 0, 0, operatingSystem);
        } else {
            return null;
        }
        binfo.setId(server.getFQID());
        Machine machine = server.getAssociatedMachine();
        if (machine != null) {
            String host = machine.getName();
            binfo.setHost(host);
        } else if (MetaUtilities.isDebug()) {
            System.err.println("MISSING Machine from ServerComponent (" + server.getName() + ")");
        }
        binfo.setJCLDirectory(MetaUtilities.getProperty((Root)server, PropJCLDir));
        return binfo;
    }

    public static BatchServerInfo setBatchServerProperties(BatchServerInfo batchserver, ServerComponent sc) throws RemoteException, MdException {
        batchserver.setId(sc.getId());
        batchserver.setSubType(MetaUtilities.getBatchServerSubType(sc));
        batchserver.setDescription(sc.getDesc());
        Machine machine = sc.getAssociatedMachine();
        if (machine != null) {
            String host = machine.getName();
            batchserver.setHost(host);
        } else if (MetaUtilities.isDebug()) {
            System.err.println("MISSING Machine from ServerComponent (" + sc.getName() + ")");
        }
        ServerComponent ws = CommandUtilities.getWorkspaceServerComponentFromBatchServer(sc);
        if (ws != null) {
            batchserver.setWorkspaceNameDataBinding(ws.getName());
        }
        batchserver.setJCLDirectory(MetaUtilities.getProperty((Root)sc, PropJCLDir));
        for (Directory directory : MetaUtilities.getDirectoriesFromBatchServer(sc)) {
            DirectoryInfo dinfo = new DirectoryInfo(directory.getName(), directory.getDirectoryName());
            dinfo.setId(directory.getFQID());
            batchserver.addDirectory(dinfo);
        }
        return batchserver;
    }

    public static int getBatchServerType(ServerComponent server) throws RemoteException, MdException {
        if (server.getClassIdentifier().equalsIgnoreCase(BATCHSERVER_DataStepServerID)) {
            return 1;
        }
        if (server.getClassIdentifier().equalsIgnoreCase(BATCHSERVER_JavaServerID)) {
            AssociationList properties = server.getProperties();
            int propsize = properties.size();
            for (int j = 0; j < propsize; ++j) {
                Property property = (Property)properties.get(j);
                if (!property.getPropertyName().equalsIgnoreCase(PropSubType)) continue;
                if (property.getDefaultValue().equalsIgnoreCase("MarketingAutomation")) {
                    return 10;
                }
                if (property.getDefaultValue().equalsIgnoreCase("BusinessReportManager")) {
                    return 11;
                }
                if (property.getDefaultValue().equalsIgnoreCase("MarketingOptimization")) {
                    return 12;
                }
                if (property.getDefaultValue().equalsIgnoreCase("OpRisk")) {
                    return 21;
                }
                if (property.getDefaultValue().equalsIgnoreCase("BILineage")) {
                    return 16;
                }
                if (property.getDefaultValue().equalsIgnoreCase("BILineageScraper")) {
                    return 20;
                }
                if (property.getDefaultValue().equalsIgnoreCase("MetadataInvestigator")) {
                    return 17;
                }
                if (property.getDefaultValue().equalsIgnoreCase("JobExecutionService")) {
                    return 18;
                }
                if (property.getDefaultValue().equalsIgnoreCase("WorkflowService")) {
                    return 19;
                }
                if (property.getDefaultValue().equalsIgnoreCase("EnergyDistribution")) {
                    return 22;
                }
                if (property.getDefaultValue().equalsIgnoreCase("BusinessPlanning")) {
                    return 14;
                }
                if (property.getDefaultValue().equalsIgnoreCase("WarrantyAnalysis")) {
                    return 23;
                }
                if (property.getDefaultValue().equalsIgnoreCase("DigitalMarketing")) {
                    return 25;
                }
                if (property.getDefaultValue().equalsIgnoreCase("RelationshipLoader")) {
                    return 24;
                }
                if (property.getDefaultValue().equalsIgnoreCase("VADesigner")) {
                    return 26;
                }
                if (!property.getDefaultValue().equalsIgnoreCase("StoredProcess")) continue;
                return 15;
            }
            return 2;
        }
        if (server.getClassIdentifier().equalsIgnoreCase("d6644527-7a09-4fe2-8bac-1caca2f6a46c")) {
            return 3;
        }
        if (server.getClassIdentifier().equalsIgnoreCase(BATCHSERVER_GenericServerID)) {
            return 0;
        }
        return -2;
    }

    public static ServerComponent getBatchServerComponent(BatchServerInfo info, MdStore store, String repos) throws RemoteException, MdException {
        String fqid = info.getId();
        return MetaUtilities.getBatchServerComponent(fqid, store, repos);
    }

    public static ServerComponent getBatchServerComponent(String fqid, MdStore store, String repos) throws RemoteException, MdException {
        if (fqid != null) {
            String strSelect = "<XMLSELECT search=\"*[@Id='" + fqid + "']\" />";
            MdFactory factory = store.getFactory();
            List list = factory.getOMIUtil().getMetadataObjectsSubset(store, repos, "ServerComponent", 8584, strSelect);
            if (list.size() == 1) {
                return (ServerComponent)list.get(0);
            }
        }
        return null;
    }

    public static List<ServerComponent> getBatchServers(int type, MdStore store, String repos) throws MdException, RemoteException {
        String strSelect;
        ArrayList<ServerComponent> returnList = new ArrayList<ServerComponent>();
        MdFactory factory = store.getFactory();
        switch (type) {
            case -1: {
                strSelect = "<XMLSELECT search=\"*[@ClassIdentifier='e20e54b3-e5f4-47ed-b21d-03109bf9a4b8' OR @ClassIdentifier='0069e914-b58c-4094-a686-a87df433ec4b' OR @ClassIdentifier='d6644527-7a09-4fe2-8bac-1caca2f6a46c' OR @ClassIdentifier='a1ff485f-9e44-4c82-90b5-062916cfa9b9']\" />";
                break;
            }
            case 1: {
                strSelect = "<XMLSELECT search=\"*[@ClassIdentifier='e20e54b3-e5f4-47ed-b21d-03109bf9a4b8']\" />";
                break;
            }
            case 2: {
                strSelect = "<XMLSELECT search=\"*[@ClassIdentifier='0069e914-b58c-4094-a686-a87df433ec4b']\" />";
                break;
            }
            case 3: {
                strSelect = "<XMLSELECT search=\"*[@ClassIdentifier='d6644527-7a09-4fe2-8bac-1caca2f6a46c']\" />";
                break;
            }
            case 0: {
                strSelect = "<XMLSELECT search=\"*[@ClassIdentifier='a1ff485f-9e44-4c82-90b5-062916cfa9b9']\" />";
                break;
            }
            default: {
                return null;
            }
        }
        List list = factory.getOMIUtil().getMetadataObjectsSubset(store, repos, "ServerComponent", 8588, strSelect);
        for (ServerComponent batchserver : list) {
            boolean addit = true;
            try {
                LogicalServer lc = (LogicalServer)batchserver.getUsedByComponents().get(0);
                lc.getUsedByComponents().get(0);
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                addit = false;
            }
            if (!addit) continue;
            returnList.add(batchserver);
        }
        return returnList;
    }

    public static List<ServerComponent> getBatchServers(int type, int subtype, MdStore store, String repos) throws MdException, RemoteException {
        String strSelect;
        ArrayList<ServerComponent> returnList = new ArrayList<ServerComponent>(0);
        MdFactory factory = store.getFactory();
        switch (type) {
            case -1: {
                strSelect = "<XMLSELECT search=\"*[@ClassIdentifier='e20e54b3-e5f4-47ed-b21d-03109bf9a4b8' OR @ClassIdentifier='0069e914-b58c-4094-a686-a87df433ec4b' OR @ClassIdentifier='d6644527-7a09-4fe2-8bac-1caca2f6a46c' OR @ClassIdentifier='a1ff485f-9e44-4c82-90b5-062916cfa9b9']\" />";
                break;
            }
            case 1: {
                strSelect = "<XMLSELECT search=\"*[@ClassIdentifier='e20e54b3-e5f4-47ed-b21d-03109bf9a4b8']\" />";
                break;
            }
            case 2: {
                strSelect = "<XMLSELECT search=\"*[@ClassIdentifier='0069e914-b58c-4094-a686-a87df433ec4b']\" />";
                break;
            }
            case 3: {
                strSelect = "<XMLSELECT search=\"*[@ClassIdentifier='d6644527-7a09-4fe2-8bac-1caca2f6a46c']\" />";
                break;
            }
            case 0: {
                strSelect = "<XMLSELECT search=\"*[@ClassIdentifier='a1ff485f-9e44-4c82-90b5-062916cfa9b9']\" />";
                break;
            }
            default: {
                throw new InvalidParameterException(m_bundle.getString("MetaUtilities.PropertyName.Type.Invalid.txt"));
            }
        }
        strSelect = strSelect + "<Templates><ServerComponent><Properties/></ServerComponent></Templates>";
        List list = factory.getOMIUtil().getMetadataObjectsSubset(store, repos, "ServerComponent", 8588, strSelect);
        for (ServerComponent sc : list) {
            AssociationList properties = sc.getProperties();
            int propsize = properties.size();
            block27: for (int j = 0; j < propsize; ++j) {
                Property property = (Property)properties.get(j);
                if (!property.getPropertyName().equalsIgnoreCase(PropSubType)) continue;
                switch (subtype) {
                    case 10: {
                        if (!property.getDefaultValue().equalsIgnoreCase("MarketingAutomation")) continue block27;
                        returnList.add(sc);
                        continue block27;
                    }
                    case 11: {
                        if (!property.getDefaultValue().equalsIgnoreCase("BusinessReportManager")) continue block27;
                        returnList.add(sc);
                        continue block27;
                    }
                    case 12: {
                        if (!property.getDefaultValue().equalsIgnoreCase("MarketingOptimization")) continue block27;
                        returnList.add(sc);
                        continue block27;
                    }
                    case 21: {
                        if (!property.getDefaultValue().equalsIgnoreCase("OpRisk")) continue block27;
                        returnList.add(sc);
                        continue block27;
                    }
                    case 16: {
                        if (!property.getDefaultValue().equalsIgnoreCase("BILineage")) continue block27;
                        returnList.add(sc);
                        continue block27;
                    }
                    case 20: {
                        if (!property.getDefaultValue().equalsIgnoreCase("BILineageScraper")) continue block27;
                        returnList.add(sc);
                        continue block27;
                    }
                    case 17: {
                        if (!property.getDefaultValue().equalsIgnoreCase("MetadataInvestigator")) continue block27;
                        returnList.add(sc);
                        continue block27;
                    }
                    case 18: {
                        if (!property.getDefaultValue().equalsIgnoreCase("JobExecutionService")) continue block27;
                        returnList.add(sc);
                        continue block27;
                    }
                    case 19: {
                        if (!property.getDefaultValue().equalsIgnoreCase("WorkflowService")) continue block27;
                        returnList.add(sc);
                        continue block27;
                    }
                    case 22: {
                        if (!property.getDefaultValue().equalsIgnoreCase("EnergyDistribution")) continue block27;
                        returnList.add(sc);
                        continue block27;
                    }
                    case 14: {
                        if (!property.getDefaultValue().equalsIgnoreCase("BusinessPlanning")) continue block27;
                        returnList.add(sc);
                        continue block27;
                    }
                    case 23: {
                        if (!property.getDefaultValue().equalsIgnoreCase("WarrantyAnalysis")) continue block27;
                        returnList.add(sc);
                        continue block27;
                    }
                    case 25: {
                        if (!property.getDefaultValue().equalsIgnoreCase("DigitalMarketing")) continue block27;
                        returnList.add(sc);
                        continue block27;
                    }
                    case 24: {
                        if (!property.getDefaultValue().equalsIgnoreCase("RelationshipLoader")) continue block27;
                        returnList.add(sc);
                        continue block27;
                    }
                    case 26: {
                        if (!property.getDefaultValue().equalsIgnoreCase("VADesigner")) continue block27;
                        returnList.add(sc);
                        continue block27;
                    }
                    case 15: {
                        if (!property.getDefaultValue().equalsIgnoreCase("StoredProcess")) continue block27;
                        returnList.add(sc);
                        continue block27;
                    }
                    case -1: 
                    case 0: {
                        returnList.add(sc);
                        continue block27;
                    }
                    default: {
                        throw new InvalidParameterException(m_bundle.getString("MetaUtilities.PropertyName.SubType.Invalid.txt"));
                    }
                }
            }
        }
        return returnList;
    }

    public static int getBatchServerSubType(ServerComponent sc) throws RemoteException, MdException {
        if (sc != null) {
            AssociationList properties = sc.getProperties();
            int propsize = properties.size();
            for (int j = 0; j < propsize; ++j) {
                Property property = (Property)properties.get(j);
                if (!property.getPropertyName().equalsIgnoreCase(PropSubType)) continue;
                String value = property.getDefaultValue();
                if (value.equalsIgnoreCase("MarketingAutomation")) {
                    return 10;
                }
                if (value.equalsIgnoreCase("BusinessReportManager")) {
                    return 11;
                }
                if (value.equalsIgnoreCase("MarketingOptimization")) {
                    return 12;
                }
                if (value.equalsIgnoreCase("OpRisk")) {
                    return 21;
                }
                if (value.equalsIgnoreCase("BILineage")) {
                    return 16;
                }
                if (value.equalsIgnoreCase("BILineageScraper")) {
                    return 20;
                }
                if (value.equalsIgnoreCase("MetadataInvestigator")) {
                    return 17;
                }
                if (value.equalsIgnoreCase("JobExecutionService")) {
                    return 18;
                }
                if (value.equalsIgnoreCase("WorkflowService")) {
                    return 19;
                }
                if (value.equalsIgnoreCase("EnergyDistribution")) {
                    return 22;
                }
                if (value.equalsIgnoreCase("BusinessPlanning")) {
                    return 14;
                }
                if (value.equalsIgnoreCase("WarrantyAnalysis")) {
                    return 23;
                }
                if (value.equalsIgnoreCase("DigitalMarketing")) {
                    return 25;
                }
                if (value.equalsIgnoreCase("RelationshipLoader")) {
                    return 24;
                }
                if (value.equalsIgnoreCase("VADesigner")) {
                    return 26;
                }
                if (!value.equalsIgnoreCase("StoredProcess")) break;
                return 15;
            }
        }
        return 0;
    }

    public static List getSchedulerServers(int type, MdStore store, String repos) throws MdException, RemoteException {
        MdFactory factory = store.getFactory();
        String strSelect = null;
        switch (type) {
            case 100: {
                strSelect = "<XMLSELECT search=\"*[@ClassIdentifier='a1661499-5d7d-4fcc-8fc3-c6509853e116' OR @ClassIdentifier='b379c9c1-89e0-4e72-ba43-6a416899b5dd' OR @ClassIdentifier='c8b4baf0-5f9f-488e-ba76-1201e1e81aef' OR @ClassIdentifier='8b4dc45a-f7c7-11e7-8c3f-9a214cf093ae' OR @ClassIdentifier='ff3aab60-8926-4e88-8af3-4287787d7d7' OR @ClassIdentifier='c8b4baf0-5f9f-471e-ba76-1201e1e81aef']\" />";
                return factory.getOMIUtil().getMetadataObjectsSubset(store, repos, "ServerComponent", 8584, strSelect);
            }
            case 101: 
            case 102: {
                strSelect = "<XMLSELECT search=\"*[@ClassIdentifier='a1661499-5d7d-4fcc-8fc3-c6509853e116']\" />";
                return factory.getOMIUtil().getMetadataObjectsSubset(store, repos, "ServerComponent", 8584, strSelect);
            }
            case 104: {
                strSelect = "<XMLSELECT search=\"*[@ClassIdentifier='b379c9c1-89e0-4e72-ba43-6a416899b5dd']\" />";
                return factory.getOMIUtil().getMetadataObjectsSubset(store, repos, "ServerComponent", 8584, strSelect);
            }
            case 106: {
                strSelect = "<XMLSELECT search=\"*[@ClassIdentifier='c8b4baf0-5f9f-488e-ba76-1201e1e81aef']\" />";
                return factory.getOMIUtil().getMetadataObjectsSubset(store, repos, "ServerComponent", 8584, strSelect);
            }
            case 108: {
                strSelect = "<XMLSELECT search=\"*[@ClassIdentifier='8b4dc45a-f7c7-11e7-8c3f-9a214cf093ae']\" />";
                return factory.getOMIUtil().getMetadataObjectsSubset(store, repos, "ServerComponent", 8584, strSelect);
            }
            case 107: {
                strSelect = "<XMLSELECT search=\"*[@ClassIdentifier='ff3aab60-8926-4e88-8af3-4287787d7d7']\" />";
                return factory.getOMIUtil().getMetadataObjectsSubset(store, repos, "ServerComponent", 8584, strSelect);
            }
            case 105: {
                strSelect = "<XMLSELECT search=\"*[@ClassIdentifier='c8b4baf0-5f9f-471e-ba76-1201e1e81aef']\" />";
                return factory.getOMIUtil().getMetadataObjectsSubset(store, repos, "ServerComponent", 8584, strSelect);
            }
        }
        return null;
    }

    public static List<ServerComponent> getSchedulerServers(String classid, MdStore store, String repos) throws MdException, RemoteException {
        String strSelect = "<XMLSELECT search=\"*[@ClassIdentifier='" + classid + "']\" />";
        MdFactory factory = store.getFactory();
        List list = factory.getOMIUtil().getMetadataObjectsSubset(store, repos, "ServerComponent", 8584, strSelect);
        return list;
    }

    public static ServerComponent getSchedulerServer(SchedulerServerInfo info) throws MdException, RemoteException {
        return MetaUtilities.getSchedulerServer(info, (MdStore)MetaUtilities.getDefaultStore(), "A0000001." + info.getId().substring(0, 8));
    }

    public static ServerComponent getSchedulerServer(SchedulerServerInfo info, MdObjectStore store) throws MdException, RemoteException {
        return MetaUtilities.getSchedulerServer(info, (MdStore)store, "A0000001." + info.getId().substring(0, 8));
    }

    public static ServerComponent getSchedulerServer(SchedulerServerInfo info, MdStore store, String repos) throws MdException, RemoteException {
        String strSelect = null;
        String id = info.getId();
        strSelect = id != null ? "<XMLSELECT search=\"*[@Id='" + id + "']\" />" : "<XMLSELECT search=\"*[@Name='" + info.getName() + "']\" />";
        MdFactory factory = store.getFactory();
        List list = factory.getOMIUtil().getMetadataObjectsSubset(store, repos, "ServerComponent", 8584, strSelect);
        if (list.size() == 1) {
            return (ServerComponent)list.get(0);
        }
        return null;
    }

    public static ServerComponent getSchedulerServer(String id, MdStore store, String repos) throws MdException, RemoteException {
        String strSelect = "<XMLSELECT search=\"*[@Id='" + id + "']\" />";
        MdFactory factory = store.getFactory();
        List list = factory.getOMIUtil().getMetadataObjectsSubset(store, repos, "ServerComponent", 8584, strSelect);
        if (list.size() == 1) {
            return (ServerComponent)list.get(0);
        }
        return null;
    }

    public static Scheduler getSchedulingServer(ServerComponent schedulerServer) throws RemoteException {
        return MetaUtilities.getSchedulingServer(schedulerServer, m_LSFAppServerResource);
    }

    public static Scheduler getSchedulingServer(ServerComponent schedulerServer, boolean setAppServer) throws RemoteException {
        if (schedulerServer == null) {
            return new LSFScheduler(null);
        }
        String key = MetaUtilities.getSchedulerServerHash(schedulerServer.getId(), schedulerServer.getObjectStore());
        Scheduler sch = m_schedulerCache.get(key);
        if (sch != null) {
            return sch;
        }
        String classid = schedulerServer.getClassIdentifier();
        SchedulerServerInfo ssi = new SchedulerServerInfo(schedulerServer.getName(), classid);
        ssi.setId(schedulerServer.getId());
        return MetaUtilities.getSchedulingServer(schedulerServer, ssi, setAppServer, true);
    }

    public static Scheduler getSchedulingServer(SchedulerServerInfo ssi) throws SchedulerException {
        return MetaUtilities.getSchedulingServer(ssi, MetaUtilities.getDefaultStore());
    }

    public static Scheduler getSchedulingServer(SchedulerServerInfo ssi, MdObjectStore store) throws SchedulerException {
        try {
            ServerComponent sc = null;
            if (ssi != null) {
                String key = MetaUtilities.getSchedulerServerHash(ssi.getId(), (MdStore)store);
                Scheduler sch = m_schedulerCache.get(key);
                if (sch != null) {
                    return sch;
                }
                if (ssi.getId() != null && ssi.getId().compareTo("null") != 0) {
                    sc = MetaUtilities.getSchedulerServer(ssi, store);
                    return MetaUtilities.getSchedulingServer(sc, ssi, m_LSFAppServerResource, true);
                }
                return null;
            }
            return MetaUtilities.getSchedulingServer(sc);
        }
        catch (RemoteException ex) {
            SchedulerException se = new SchedulerException(ex.toString());
            se.initCause((Throwable)ex);
            throw se;
        }
        catch (MdException ex) {
            SchedulerException se = new SchedulerException(ex.toString());
            se.initCause((Throwable)ex);
            throw se;
        }
    }

    public static Scheduler getSchedulingServer(ServerComponent schedulerServer, SchedulerServerInfo ssi) throws RemoteException {
        if (schedulerServer == null) {
            return new LSFScheduler(null);
        }
        String key = MetaUtilities.getSchedulerServerHash(schedulerServer.getId(), schedulerServer.getObjectStore());
        Scheduler sch = m_schedulerCache.get(key);
        if (sch != null) {
            return sch;
        }
        return MetaUtilities.getSchedulingServer(schedulerServer, ssi, m_LSFAppServerResource, true);
    }

    public static Scheduler getSchedulerFromName(String name, MdStore store, String repos) {
        block5: {
            try {
                String strSelect = "<XMLSELECT search=\"ServerComponent[@Name='" + name + "']\" />";
                MdFactory factory = store.getFactory();
                List list = factory.getOMIUtil().getMetadataObjectsSubset(store, repos, "ServerComponent", 8584, strSelect);
                if (list.size() > 0) {
                    ServerComponent sc = (ServerComponent)list.get(0);
                    SchedulerServerInfo ssi = new SchedulerServerInfo();
                    return MetaUtilities.getSchedulingServer(sc, ssi, false, false);
                }
            }
            catch (MdException e) {
                if (MetaUtilities.isDebug()) {
                    e.printStackTrace();
                }
            }
            catch (RemoteException e) {
                if (!MetaUtilities.isDebug()) break block5;
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private static Scheduler getSchedulingServer(ServerComponent schedulerServer, SchedulerServerInfo ssi, boolean setAppServer, boolean allowConnection) throws RemoteException {
        block108: {
            block113: {
                block111: {
                    scheduler = null;
                    ssi.setName(schedulerServer.getName());
                    classid = schedulerServer.getClassIdentifier();
                    ssi.setClassidDataBinding(classid);
                    ssi.setId(schedulerServer.getId());
                    ssi.setDescription(schedulerServer.getDesc());
                    if (classid.compareTo("a1661499-5d7d-4fcc-8fc3-c6509853e116") == 0) {
                        ssi.setTimezoneSupported(LSFScheduler.isTimezoneSupported(schedulerServer.getMajor(), schedulerServer.getMinor()));
                        scheduler = new LSFScheduler(ssi);
                        try {
                            host = "";
                            port = "";
                            connection = (TCPIPConnection)schedulerServer.getSourceConnections().get(0);
                            if (connection != null) {
                                host = connection.getHostName();
                                port = Integer.toString(connection.getPort());
                            } else {
                                MetaUtilities.LOGGER.debug("ERROR: Platform PM scheduler requires a connection.");
                            }
                            ssi.setHost(host);
                            ssi.setPort(port);
                        }
                        catch (MdException e) {
                            MetaUtilities.LOGGER.debug("ERROR: Platform PM scheduler metadata is not properly retrieved.");
                            if (MetaUtilities.isDebug()) {
                                e.printStackTrace();
                            }
                            break block108;
                        }
                        catch (RuntimeException e) {
                            MetaUtilities.LOGGER.debug("ERROR: Platform PM scheduler metadata is malformed.");
                            if (MetaUtilities.isDebug()) {
                                e.printStackTrace();
                            }
                            break block108;
                        }
                    }
                    if (classid.compareTo("8b4dc45a-f7c7-11e7-8c3f-9a214cf093ae") == 0) {
                        block109: {
                            try {
                                connection = (TCPIPConnection)schedulerServer.getSourceConnections().get(0);
                                host = "";
                                port = "";
                                protocol = "http";
                                if (connection != null) {
                                    host = connection.getHostName();
                                    port = Integer.toString(connection.getPort());
                                    protocol = connection.getCommunicationProtocol();
                                } else {
                                    MetaUtilities.LOGGER.debug("ERROR: SAS Job Flow scheduler requires a connection.");
                                }
                                ssi.setHost(host);
                                ssi.setPort(port);
                                ssi.setProtocol(protocol);
                            }
                            catch (MdException e) {
                                MetaUtilities.LOGGER.debug("ERROR: SAS Job Flow scheduler metadata is not properly retrieved.");
                                if (MetaUtilities.isDebug()) {
                                    e.printStackTrace();
                                }
                            }
                            catch (RuntimeException e) {
                                MetaUtilities.LOGGER.debug("ERROR: SAS Job Flow scheduler metadata is malformed.");
                                if (!MetaUtilities.isDebug()) break block109;
                                e.printStackTrace();
                            }
                        }
                        try {
                            block110: {
                                ssi.setJobExecutionProvider("operatingSystem");
                                properties = schedulerServer.getProperties();
                                propsize = properties.size();
                                for (i = 0; i < propsize; ++i) {
                                    property = (Property)properties.elementAt(i);
                                    if (property.getPropertyName().equalsIgnoreCase("ExecutionType")) {
                                        ssi.setJobExecutionProvider(property.getDefaultValue());
                                        continue;
                                    }
                                    if (property.getPropertyName().equalsIgnoreCase("ExecutionRESTAPI")) {
                                        ssi.setRestApiPath(property.getDefaultValue());
                                        continue;
                                    }
                                    if (property.getPropertyName().equalsIgnoreCase("FlowOrchHost")) {
                                        ssi.setFlowOrchestratorHost(property.getDefaultValue());
                                        continue;
                                    }
                                    if (property.getPropertyName().equalsIgnoreCase("FlowOrchPort")) {
                                        ssi.setFlowOrchestratorPort(property.getDefaultValue());
                                        continue;
                                    }
                                    if (property.getPropertyName().equalsIgnoreCase("FlowOrchCommand")) {
                                        command = property.getDefaultValue();
                                        if (CommandUtilities.needsQuoting(command)) {
                                            if (command.contains("-config")) {
                                                if (command.contains("-stdout") || command.contains("-stderr") || command.contains("-bufSize")) {
                                                    tokens = command.split(" -");
                                                    command = CommandUtilities.quoteCommand(tokens[0]);
                                                    for (j = 1; j < tokens.length; ++j) {
                                                        command = command + " -" + tokens[j];
                                                    }
                                                } else {
                                                    tokens = command.split("-config");
                                                    if (tokens.length == 2) {
                                                        path = tokens[1];
                                                        if (path.trim().indexOf(" ") > -1) {
                                                            path = CommandUtilities.quoteCommand(path.trim());
                                                        }
                                                        command = "\"" + tokens[0].trim() + "\" -config " + path;
                                                    } else {
                                                        command = CommandUtilities.quoteCommand(tokens[0]);
                                                        for (j = 1; j < tokens.length; ++j) {
                                                            command = command + " -config" + tokens[j];
                                                        }
                                                    }
                                                }
                                            } else if (command.contains("-stdout") || command.contains("-stderr") || command.contains("-bufSize")) {
                                                tokens = command.split(" -");
                                                command = CommandUtilities.quoteCommand(tokens[0]);
                                                for (j = 1; j < tokens.length; ++j) {
                                                    command = command + " -" + tokens[j];
                                                }
                                            } else {
                                                command = CommandUtilities.quoteCommand(command);
                                            }
                                        }
                                        ssi.setFlowOrchestrationCommand(command);
                                        continue;
                                    }
                                    if (property.getPropertyName().equalsIgnoreCase("OSTriggerCommand")) {
                                        ssi.setTriggerCommand(property.getDefaultValue());
                                        continue;
                                    }
                                    if (property.getPropertyName().equalsIgnoreCase("OSCommandPath")) {
                                        ssi.setOSCommandPath(property.getDefaultValue());
                                        continue;
                                    }
                                    if (property.getPropertyName().equalsIgnoreCase("AuthInfo")) {
                                        value = property.getDefaultValue();
                                        if (value.endsWith(".authinfo")) {
                                            ssi.setAuthInfo(value);
                                            continue;
                                        }
                                        ssi.setAuthInfo(CommandUtilities.createFullPath(value, ".authinfo", -1));
                                        continue;
                                    }
                                    if (property.getPropertyName().equalsIgnoreCase("BufferSize")) {
                                        ssi.setBufferSizeDataBinding(property.getDefaultValue());
                                        continue;
                                    }
                                    if (property.getPropertyName().equalsIgnoreCase("UseHA")) {
                                        if (property.getDefaultValue().equalsIgnoreCase("1") || property.getDefaultValue().equalsIgnoreCase("true")) {
                                            ssi.setUseHADataBinding(true);
                                            continue;
                                        }
                                        ssi.setUseHADataBinding(false);
                                        continue;
                                    }
                                    if (property.getPropertyName().equalsIgnoreCase("java.naming.provider.url")) {
                                        value = property.getDefaultValue().trim();
                                        ssi.setJavaNamingProviderUrlDataBinding(value);
                                        continue;
                                    }
                                    if (!property.getPropertyName().equalsIgnoreCase("java.naming.factory.initial")) continue;
                                    ssi.setJavaNamingFactoryDataBinding(property.getDefaultValue());
                                }
                                try {
                                    components = schedulerServer.getUsingComponents();
                                    for (ServerComponent sc : components) {
                                        if (!sc.getClassIdentifier().equals("3c2ac3d5-7094-4eac-911b-be34fc237044")) continue;
                                        connection = (TCPIPConnection)sc.getSourceConnections().get(0);
                                        host = "";
                                        port = "";
                                        protocol = "http";
                                        if (connection != null) {
                                            host = connection.getHostName();
                                            port = Integer.toString(connection.getPort());
                                            protocol = connection.getApplicationProtocol();
                                        } else {
                                            MetaUtilities.LOGGER.debug("ERROR: SAS Job Flow scheduler requires a connection to Launcher.");
                                        }
                                        ssi.setFlowOrchestratorHost(host);
                                        ssi.setFlowOrchestratorPort(port);
                                        ssi.setProtocol(protocol);
                                        break;
                                    }
                                }
                                catch (MdException e) {
                                    MetaUtilities.LOGGER.debug("ERROR: SAS Job Flow scheduler metadata is not properly retrieved.");
                                    if (MetaUtilities.isDebug()) {
                                        e.printStackTrace();
                                    }
                                }
                                catch (RuntimeException e) {
                                    MetaUtilities.LOGGER.debug("ERROR: SAS Job Flow scheduler metadata is malformed.");
                                    if (!MetaUtilities.isDebug()) break block110;
                                    e.printStackTrace();
                                }
                            }
                            if (ssi.getJobExecutionProvider().equals("REST")) {
                                if ((ssi.getRestAPIPath() == null || ssi.getRestAPIPath().isEmpty()) && (uri = MetaUtilities.getSASGridManagerRestURI(schedulerServer)) != null) {
                                    ssi.setRestApiPath(uri);
                                }
                                if (ssi.getRestAPIPath() == null || ssi.getRestAPIPath().isEmpty()) {
                                    ssi.setJobExecutionProvider("operatingSystem");
                                }
                            } else if (ssi.getJobExecutionProvider().equals("Launcher") && (ssi.getFlowOrchestratorHost() == null || ssi.getFlowOrchestratorPort() == null)) {
                                ssi.setJobExecutionProvider("operatingSystem");
                            }
                            if (ssi.getJavaNamingFactoryDataBinding() == null || ssi.getJavaNamingFactoryDataBinding().isEmpty()) {
                                ssi.setJavaNamingFactoryDataBinding("org.apache.activemq.jndi.ActiveMQInitialContextFactory");
                            }
                            if (useService = Boolean.parseBoolean(System.getProperty("SASJFS_RunningInsideScheduleManager", "false"))) {
                                scheduler = new SASJFSServiceProxy(ssi);
                                break block108;
                            }
                            scheduler = new SASJFScheduler(ssi);
                        }
                        catch (MdException e) {
                            MetaUtilities.LOGGER.debug("ERROR: SAS Job Flow scheduler metadata is not properly retrieved.");
                            if (MetaUtilities.isDebug()) {
                                e.printStackTrace();
                            }
                            break block108;
                        }
                    }
                    if (classid.compareTo("b379c9c1-89e0-4e72-ba43-6a416899b5dd") != 0) break block113;
                    scheduler = new OSScheduler(ssi);
                    try {
                        connection = (TCPIPConnection)schedulerServer.getSourceConnections().get(0);
                        host = "";
                        port = "";
                        if (connection != null) {
                            host = connection.getHostName();
                            port = Integer.toString(connection.getPort());
                        } else {
                            MetaUtilities.LOGGER.debug("ERROR: Operating System Services scheduler requires a connection.");
                        }
                        ssi.setHost(host);
                        ssi.setPort(port);
                    }
                    catch (MdException e) {
                        MetaUtilities.LOGGER.debug("ERROR: Operating System Services scheduler metadata is not properly retrieved.");
                        if (MetaUtilities.isDebug()) {
                            e.printStackTrace();
                        }
                    }
                    catch (RuntimeException e) {
                        MetaUtilities.LOGGER.debug("ERROR: Operating System Services scheduler metadata is malformed.");
                        if (!MetaUtilities.isDebug()) break block111;
                        e.printStackTrace();
                    }
                }
                try {
                    properties = schedulerServer.getProperties();
                    propsize = properties.size();
                    for (i = 0; i < propsize; ++i) {
                        property = (Property)properties.elementAt(i);
                        if (property.getPropertyName().equalsIgnoreCase("OutDir")) {
                            ssi.setOutDir(property.getDefaultValue());
                            continue;
                        }
                        if (!property.getPropertyName().equalsIgnoreCase("SubType")) continue;
                        ((SchedulerIMPL)scheduler).setSubtype(property.getDefaultValue());
                    }
                }
                catch (Exception e) {
                    MetaUtilities.LOGGER.debug("ERROR: Operating System Services scheduler metadata is not properly retrieved.");
                    if (!MetaUtilities.isDebug()) ** GOTO lbl377
                    e.printStackTrace();
                }
                break block108;
            }
            if (classid.compareTo("c8b4baf0-5f9f-488e-ba76-1201e1e81aef") != 0) ** GOTO lbl291
            useService = Boolean.parseBoolean(System.getProperty("DIP_RunningInsideScheduleManager", "false"));
            if (useService) {
                scheduler = new DIPServiceProxy(ssi);
            } else {
                props = new Properties();
                try {
                    properties = schedulerServer.getProperties();
                    for (i = 0; i < properties.size(); ++i) {
                        property = (Property)properties.elementAt(i);
                        props.setProperty(property.getPropertyName(), property.getDefaultValue());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                scheduler = new PIPScheduler(ssi, PIPScheduler.getLogger(), props);
                try {
                    connection = (TCPIPConnection)schedulerServer.getSourceConnections().get(0);
                    if (connection != null) {
                        host = connection.getHostName();
                        port = Integer.toString(connection.getPort());
                        ssi.setHost(host);
                        ssi.setPort(port);
                        break block108;
                    }
                    MetaUtilities.LOGGER.debug("ERROR: Distributed In-Process Services scheduler missing a connection.");
                }
                catch (MdException e) {
                    MetaUtilities.LOGGER.debug("ERROR: Distributed In-Process Services scheduler metadata is not properly retrieved.");
                    if (MetaUtilities.isDebug()) {
                        e.printStackTrace();
                    }
                    break block108;
                }
                catch (RuntimeException e) {
                    if (MetaUtilities.isDebug()) {
                        e.printStackTrace();
                    }
                    break block108;
                }
lbl291:
                // 1 sources

                if (classid.compareTo("ff3aab60-8926-4e88-8af3-4287787d7d7") == 0) {
                    block112: {
                        scheduler = new OozieScheduler(ssi);
                        try {
                            connection = (TCPIPConnection)schedulerServer.getSourceConnections().get(0);
                            host = "";
                            port = "";
                            protocol = "http";
                            if (connection != null) {
                                host = connection.getHostName();
                                port = Integer.toString(connection.getPort());
                                protocol = connection.getApplicationProtocol();
                            } else {
                                MetaUtilities.LOGGER.debug("ERROR: Oozie scheduler requires a connection.");
                            }
                            ssi.setHost(host);
                            ssi.setPort(port);
                            ssi.setRestApiPath(protocol + "://" + host + ":" + port);
                        }
                        catch (MdException e) {
                            MetaUtilities.LOGGER.debug("ERROR: Oozie scheduler metadata is not properly retrieved.");
                            if (MetaUtilities.isDebug()) {
                                e.printStackTrace();
                            }
                        }
                        catch (RuntimeException e) {
                            MetaUtilities.LOGGER.debug("ERROR: Oozie scheduler metadata is malformed.");
                            if (!MetaUtilities.isDebug()) break block112;
                            e.printStackTrace();
                        }
                    }
                    try {
                        properties = schedulerServer.getProperties();
                        propsize = properties.size();
                        jobtracker = null;
                        webnamenode = null;
                        namenode = null;
                        for (i = 0; i < propsize; ++i) {
                            property = (Property)properties.elementAt(i);
                            if (property.getPropertyName().equalsIgnoreCase("Coordinator")) {
                                ssi.setCoordinatorPath(property.getDefaultValue());
                                continue;
                            }
                            if (property.getPropertyName().equalsIgnoreCase("Workflow")) {
                                ssi.setWorkflowPath(property.getDefaultValue());
                                continue;
                            }
                            if (property.getPropertyName().equalsIgnoreCase("HadoopConfig")) {
                                OozieScheduler.parseConfig(ssi, property.getDefaultValue());
                                continue;
                            }
                            if (property.getPropertyName().equalsIgnoreCase("CommonProperties")) {
                                ssi.setConfigPropertiesDataBinding(property.getDefaultValue());
                                continue;
                            }
                            if (property.getPropertyName().equalsIgnoreCase("JobTracker")) {
                                jobtracker = property.getDefaultValue();
                                continue;
                            }
                            if (property.getPropertyName().equalsIgnoreCase("WebNameNode")) {
                                webnamenode = property.getDefaultValue();
                                continue;
                            }
                            if (!property.getPropertyName().equalsIgnoreCase("NameNode")) continue;
                            namenode = property.getDefaultValue();
                        }
                        if (jobtracker != null && !jobtracker.isEmpty()) {
                            ssi.setJobTracker(jobtracker);
                        }
                        if (webnamenode != null && !webnamenode.isEmpty()) {
                            ssi.setWebNameNode(webnamenode);
                        }
                        if (namenode != null && !namenode.isEmpty()) {
                            ssi.setNameNode(namenode);
                        }
                        break block108;
                    }
                    catch (MdException e) {
                        if (MetaUtilities.isDebug()) {
                            e.printStackTrace();
                        }
                        break block108;
                    }
                    catch (RuntimeException e) {
                        if (MetaUtilities.isDebug()) {
                            e.printStackTrace();
                        }
                        break block108;
                    }
                }
                if (classid.compareTo("c8b4baf0-5f9f-471e-ba76-1201e1e81aef") == 0) {
                    scheduler = new IPScheduler(ssi);
                } else {
                    return null;
                }
            }
        }
        if (scheduler != null) {
            ((SchedulerIMPL)scheduler).setAppServerResource(setAppServer);
            ((SchedulerIMPL)scheduler).setProductName(schedulerServer.getProductName());
            ((SchedulerIMPL)scheduler).setSoftwareVersion(schedulerServer.getSoftwareVersion());
            ((SchedulerIMPL)scheduler).setMajorVersion(schedulerServer.getMajor());
            ((SchedulerIMPL)scheduler).setMinorVersion(schedulerServer.getMinor());
            if (allowConnection) {
                try {
                    MetaUtilities.LOGGER.debug("Attempting to get the queues for the scheduler.");
                    queues = scheduler.getQueues();
                    MetaUtilities.LOGGER.debug("Setting the queues for the scheduler.");
                    ssi.setQueueListDataBinding(queues);
                }
                catch (Exception e) {
                    MetaUtilities.LOGGER.debug(e.getMessage());
                }
            }
            key = MetaUtilities.getSchedulerServerHash(scheduler.getServerComponent().getId(), schedulerServer.getObjectStore());
            MetaUtilities.m_schedulerCache.put(key, scheduler);
        }
        return scheduler;
    }

    public static Scheduler getSchedulerServerOnMachine(String type, Machine machine) throws MdException, RemoteException {
        SchedulerServerInfo ssi = new SchedulerServerInfo(type);
        String strSelect = "<XMLSELECT search=\"*[@ClassIdentifier='" + type + "']\" />";
        MdStore store = machine.getObjectStore();
        String repos = "A0000001." + machine.getRepositoryID();
        MdFactory factory = store.getFactory();
        List list = factory.getOMIUtil().getMetadataObjectsSubset(store, repos, "ServerComponent", 8584, strSelect);
        if (list.size() == 0) {
            return null;
        }
        if (list.size() == 1) {
            ServerComponent sc = (ServerComponent)list.get(0);
            return MetaUtilities.getSchedulingServer(sc, ssi);
        }
        if (machine != null) {
            for (ServerComponent sc : list) {
                if (sc.getAssociatedMachine().getId().compareTo(machine.getId()) != 0) continue;
                return MetaUtilities.getSchedulingServer(sc, ssi);
            }
        }
        if (list.size() > 0) {
            ServerComponent sc = (ServerComponent)list.get(0);
            return MetaUtilities.getSchedulingServer(sc, ssi);
        }
        return null;
    }

    public static void updateSASJFScheduler(String fqid, String name, String domain, String host, String port, String version, MdObjectStore store, String repos) throws RemoteException, MdException {
        TCPIPConnection connection;
        AssociationList connections;
        boolean update = false;
        ServerComponent server = MetaUtilities.getSchedulerServer(fqid, (MdStore)store, repos);
        if (server == null) {
            throw new RuntimeException("MetaUtilities.updateSASJFScheduler()");
        }
        if (name != null && name.trim().length() > 0) {
            server.setName(name);
            update = true;
        }
        if ((connections = server.getSourceConnections()) != null && connections.size() > 0 && (connection = (TCPIPConnection)connections.get(0)) != null) {
            int neoport;
            int old_port;
            String old_host = connection.getHostName();
            if (old_host.compareTo(host) != 0) {
                System.out.println("Info: fixing the host for TCPIP connection");
                connection.setHostName(host);
                update = true;
                String cname = connection.getName();
                if (cname.contains(old_host)) {
                    System.out.println("Info: fixing the name for TCPIP connection");
                    String newName = MetaUtilities.replaceString(cname, old_host, host);
                    connection.setName(newName);
                }
                name = server.getName();
                String short_old_host = old_host;
                if (old_host.indexOf(46) > 0) {
                    short_old_host = old_host.substring(0, old_host.indexOf(46));
                }
                String short_host = host;
                if (host.indexOf(46) > 0) {
                    short_host = host.substring(0, host.indexOf(46));
                }
                if (name.contains(old_host)) {
                    System.out.println("Info: fixing the name for ServerComponent");
                    String newName = MetaUtilities.replaceString(name, old_host, short_host);
                    server.setName(newName);
                } else if (name.contains(short_old_host)) {
                    System.out.println("Info: fixing the name for ServerComponent");
                    String newName = MetaUtilities.replaceString(name, short_old_host, short_host);
                    server.setName(newName);
                }
            }
            if ((old_port = connection.getPort()) != (neoport = Integer.valueOf(port).intValue())) {
                System.out.println("Info: fixing the port for TCPIP connection");
                connection.setPort(neoport);
                update = true;
            }
        }
        if (version != null && version.trim().length() > 0) {
            server.setSoftwareVersion(version);
            try {
                int index = version.indexOf(46);
                int major = Integer.valueOf(version.substring(0, index));
                int minor = Integer.valueOf(version.substring(index + 1));
                server.setMajor(major);
                server.setMinor(minor);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            update = true;
        }
        if (update) {
            server.updateMetadataAll();
        }
    }

    public static void updateDIPScheduler(String fqid, String name, String version, String clustername, String jmsproviderurl, String jmsfactory, String maxrunflows, String maxrunjobs, String maxhistory, String persistname, String filetrigger, String outputlimit, String jobpollfreq, String maxjobs, String jobcountwait, String maxwait, String basewait, MdObjectStore store, String repos) throws RemoteException, MdException {
        boolean update = false;
        ServerComponent server = MetaUtilities.getSchedulerServer(fqid, (MdStore)store, repos);
        if (server == null) {
            throw new RuntimeException("MetaUtilities.updateDIPScheduler()");
        }
        if (name != null && name.trim().length() > 0) {
            server.setName(name);
            update = true;
        }
        if (version != null && version.trim().length() > 0) {
            server.setSoftwareVersion(version);
            try {
                int index = version.indexOf(46);
                int major = Integer.valueOf(version.substring(0, index));
                int minor = Integer.valueOf(version.substring(index + 1));
                server.setMajor(major);
                server.setMinor(minor);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            update = true;
        }
        update |= MetaUtilities.updateServerComponentProperty(server, store, repos, "PIP.JGroupsClusterName", clustername, 12);
        update |= MetaUtilities.updateServerComponentProperty(server, store, repos, "java.naming.provider.url", jmsproviderurl, 12);
        update |= MetaUtilities.updateServerComponentProperty(server, store, repos, "java.naming.factory.initial", jmsfactory, 12);
        update |= MetaUtilities.updateServerComponentProperty(server, store, repos, "PIP.MaxFlowsRunningInSystem", maxrunflows, 12);
        update |= MetaUtilities.updateServerComponentProperty(server, store, repos, "PIP.MaxJobsRunningInSystem", maxrunjobs, 12);
        update |= MetaUtilities.updateServerComponentProperty(server, store, repos, "PIP.MaxHistoriesPerFlow", maxhistory, 12);
        update |= MetaUtilities.updateServerComponentProperty(server, store, repos, "PIP.PersistenceName", persistname, 12);
        update |= MetaUtilities.updateServerComponentProperty(server, store, repos, "PIP.FileTriggerCheckFrequencyMS", filetrigger, 12);
        update |= MetaUtilities.updateServerComponentProperty(server, store, repos, "PIP.OutputLimit", outputlimit, 12);
        update |= MetaUtilities.updateServerComponentProperty(server, store, repos, "PIP.JobPollFrequency", jobpollfreq, 12);
        update |= MetaUtilities.updateServerComponentProperty(server, store, repos, "MaxJobs", maxjobs, 12);
        update |= MetaUtilities.updateServerComponentProperty(server, store, repos, "JobCountBeforeWait", jobcountwait, 12);
        update |= MetaUtilities.updateServerComponentProperty(server, store, repos, "MaxWaitTimeMS", maxwait, 12);
        if (update |= MetaUtilities.updateServerComponentProperty(server, store, repos, "BaseWaitTimeMS", basewait, 12)) {
            server.updateMetadataAll();
        }
    }

    public static void updateDIPScheduler(String fqid, String name, String version, String address, String ipttl, String mainport, String hashport, String clustername, String jmsproviderurl, String jmsfactory, String maxrunflows, String maxrunjobs, String maxhistory, String persistname, String filetrigger, String outputlimit, String jobpollfreq, String maxjobs, String jobcountwait, String maxwait, String basewait, MdObjectStore store, String repos) throws RemoteException, MdException {
        boolean update = false;
        ServerComponent server = MetaUtilities.getSchedulerServer(fqid, (MdStore)store, repos);
        if (server == null) {
            throw new RuntimeException("MetaUtilities.updateDIPScheduler()");
        }
        if (name != null && name.trim().length() > 0) {
            server.setName(name);
            update = true;
        }
        if (version != null && version.trim().length() > 0) {
            server.setSoftwareVersion(version);
            try {
                int index = version.indexOf(46);
                int major = Integer.valueOf(version.substring(0, index));
                int minor = Integer.valueOf(version.substring(index + 1));
                server.setMajor(major);
                server.setMinor(minor);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            update = true;
        }
        update |= MetaUtilities.updateServerComponentProperty(server, store, repos, "PIP.JGroupsMulticastAddress", address, 12);
        update |= MetaUtilities.updateServerComponentProperty(server, store, repos, "PIP.JGroupsMulticastTTL", ipttl, 12);
        update |= MetaUtilities.updateServerComponentProperty(server, store, repos, "PIP.JGroupsPort_MainChannelPort", mainport, 12);
        update |= MetaUtilities.updateServerComponentProperty(server, store, repos, "PIP.JGroupsPort_HashChannelPort", hashport, 12);
        update |= MetaUtilities.updateServerComponentProperty(server, store, repos, "PIP.JGroupsClusterName", clustername, 12);
        update |= MetaUtilities.updateServerComponentProperty(server, store, repos, "java.naming.provider.url", jmsproviderurl, 12);
        update |= MetaUtilities.updateServerComponentProperty(server, store, repos, "java.naming.factory.initial", jmsfactory, 12);
        update |= MetaUtilities.updateServerComponentProperty(server, store, repos, "PIP.MaxFlowsRunningInSystem", maxrunflows, 12);
        update |= MetaUtilities.updateServerComponentProperty(server, store, repos, "PIP.MaxJobsRunningInSystem", maxrunjobs, 12);
        update |= MetaUtilities.updateServerComponentProperty(server, store, repos, "PIP.MaxHistoriesPerFlow", maxhistory, 12);
        update |= MetaUtilities.updateServerComponentProperty(server, store, repos, "PIP.PersistenceName", persistname, 12);
        update |= MetaUtilities.updateServerComponentProperty(server, store, repos, "PIP.FileTriggerCheckFrequencyMS", filetrigger, 12);
        update |= MetaUtilities.updateServerComponentProperty(server, store, repos, "PIP.OutputLimit", outputlimit, 12);
        update |= MetaUtilities.updateServerComponentProperty(server, store, repos, "PIP.JobPollFrequency", jobpollfreq, 12);
        update |= MetaUtilities.updateServerComponentProperty(server, store, repos, "MaxJobs", maxjobs, 12);
        update |= MetaUtilities.updateServerComponentProperty(server, store, repos, "JobCountBeforeWait", jobcountwait, 12);
        update |= MetaUtilities.updateServerComponentProperty(server, store, repos, "MaxWaitTimeMS", maxwait, 12);
        if (update |= MetaUtilities.updateServerComponentProperty(server, store, repos, "BaseWaitTimeMS", basewait, 12)) {
            server.updateMetadataAll();
        }
    }

    private static boolean updateServerComponentProperty(ServerComponent server, MdObjectStore store, String repos, String propName, String propValue, int propType) throws RemoteException, MdException {
        boolean update = false;
        if (propValue != null && propValue.trim().length() > 0) {
            boolean notFound = true;
            AssociationList properties = server.getProperties();
            int propsize = properties.size();
            for (int j = 0; j < propsize; ++j) {
                Property property = (Property)properties.get(j);
                if (!property.getPropertyName().equalsIgnoreCase(propName)) continue;
                notFound = false;
                property.setDefaultValue(propValue);
                update = true;
                break;
            }
            if (notFound) {
                MdFactory factory = store.getFactory();
                String reposId = repos.length() > 8 ? repos.substring(9) : repos;
                Property property = (Property)factory.createComplexMetadataObject(store, null, propName, "Property", reposId, null);
                property.setPropertyName(PropSubType);
                property.setDefaultValue(propValue);
                property.setSQLType(propType);
                server.getProperties().add((java.lang.Object)property);
                update = true;
            }
        }
        return update;
    }

    public static String getSASGridManagerRestURI(ServerComponent schedulerServer) throws MdException, RemoteException {
        DeployedComponent dc;
        TCPIPConnection connection;
        SoftwareComponent sc;
        AssociationList dlist;
        String classid = "sgmg";
        String strSelect = "<XMLSELECT search=\"*[@ClassIdentifier='" + classid + "']\" />";
        MdStore store = schedulerServer.getObjectStore();
        String repos = "A0000001." + schedulerServer.getId().substring(0, 8);
        MdFactory factory = store.getFactory();
        List list = factory.getOMIUtil().getMetadataObjectsSubset(store, repos, "SoftwareComponent", 8584, strSelect);
        if (list.size() > 0 && (dlist = (sc = (SoftwareComponent)list.get(0)).getDeployedComponents()).size() > 0 && (connection = (TCPIPConnection)(dc = (DeployedComponent)dlist.get(0)).getSourceConnections().get(0)) != null) {
            String host = connection.getHostName();
            String port = Integer.toString(connection.getPort());
            String protocol = connection.getCommunicationProtocol();
            return protocol + "://" + host + ":" + port;
        }
        return null;
    }

    public static CMetadata getRepository(MdFactory factory, String id) throws RemoteException, MdException {
        for (Root repository : factory.getOMIUtil().getRepositories()) {
            String reposId = id.length() == 8 ? repository.getId().substring(9) : repository.getId();
            if (reposId.compareTo(id) != 0) continue;
            return repository;
        }
        return null;
    }

    public static String getRepositoryID(String name) throws RemoteException, MdException {
        IOMI connection = MetaUtilities.getMdFactory(false).getConnection().getCMRHandle();
        if (connection == null) {
            return null;
        }
        return MetaUtilities.getRepositoryID(connection, name);
    }

    public static String getRepositoryID(String name, MdStore store) throws RemoteException {
        MdFactory factory = store.getFactory();
        String id = MetaUtilities.getRepositoryID(factory.getConnection().getCMRHandle(), name);
        return id;
    }

    public static String getRepositoryID(IOMI connectionHandle, String name) {
        try {
            return MetaUtilities.getRepositoryID(connectionHandle, name, MetaUtilities.getMdFactory(false));
        }
        catch (RemoteException e) {
            if (MetaUtilities.isDebug()) {
                e.printStackTrace();
            }
            return null;
        }
        catch (MdException e) {
            if (MetaUtilities.isDebug()) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public static String getRepositoryID(IOMI connectionHandle, String name, MdFactory factory) {
        try {
            MdRepositoryUtilImpl reposUtil = new MdRepositoryUtilImpl(factory);
            return reposUtil.getRepositoryIDFromName(name);
        }
        catch (MdException e) {
            return null;
        }
        catch (RemoteException e) {
            return null;
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public static String getRepositoryName(String repositoryID) throws MdException, RemoteException {
        try {
            return MetaUtilities.getRepositoryName(MetaUtilities.getMdFactory(false).getConnection().getCMRHandle(), repositoryID);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getRepositoryName(IOMI connectionHandle, String repositoryID) throws MdException, RemoteException {
        Document doc;
        StringBuffer inXML = new StringBuffer();
        inXML.append("<GetMetadata><Metadata>");
        StringBuffer getXML = new StringBuffer();
        getXML.append("<RepositoryBase Id=\"");
        getXML.append(repositoryID);
        getXML.append("\" Name=\"\"/>");
        inXML.append(getXML);
        inXML.append("</Metadata><Ns>REPOS</Ns><Flags>");
        inXML.append(1);
        inXML.append("</Flags><Options/></GetMetadata>");
        StringHolder outXML = new StringHolder();
        try {
            connectionHandle.GetMetadata(getXML.toString(), outXML, "REPOS", 0, "");
        }
        catch (GenericError e) {
            throw new MdException((Throwable)e);
        }
        catch (RuntimeException e) {
            throw new MdException((Throwable)e);
        }
        String outXMLString = outXML.value;
        String repositoryName = null;
        try {
            doc = GeneralUtilities.parseXML((String)outXMLString);
        }
        catch (SchedulerException e) {
            throw new MdException((Throwable)e);
        }
        if (doc != null) {
            Node firstNode = doc.getFirstChild();
            NamedNodeMap nodeMap = firstNode.getAttributes();
            repositoryName = MetaUtilities.getMdFactory(false).getOMIUtil().getAttribute("Name", nodeMap);
        }
        doc = null;
        return repositoryName;
    }

    public static List<?> getSASAppServersWithDeployedDirectories(MdStore store, String repos) throws MdException, RemoteException {
        String getTemplate = "<Template><ServerContext><DataPackages/></ServerContext></Template>";
        int flags = 8460;
        MdFactory factory = store.getFactory();
        return factory.getOMIUtil().getMetadataObjectsSubset(store, repos, "ServerContext", flags, getTemplate);
    }

    public static List<SASAppServer> getSASAppServers(MdStore store, String repos) throws RemoteException, MdException {
        ArrayList<SASAppServer> servers = new ArrayList<SASAppServer>();
        String getTemplate = "<Template><ServerContext><DataPackages/></ServerContext></Template>";
        int flags = 8460;
        MdFactory factory = store.getFactory();
        List lServerContexts = factory.getOMIUtil().getMetadataObjectsSubset(store, repos, "ServerContext", flags, getTemplate);
        for (ServerContext context : lServerContexts) {
            List<java.lang.Object> temp = MetaUtilities.getDirectoriesFromServer(context);
            ArrayList<DirectoryInfo> dirs = new ArrayList<DirectoryInfo>();
            for (Directory directory : temp) {
                DirectoryInfo dinfo = new DirectoryInfo(directory.getName(), directory.getDirectoryName());
                dinfo.setId(directory.getId());
                dirs.add(dinfo);
            }
            SASAppServer sASAppServer = new SASAppServer(context.getName(), context.getId(), dirs);
            servers.add(sASAppServer);
        }
        return servers;
    }

    public static ServerContext getSASAppServerContext(SASAppServer server, MdObjectStore store, String repos) throws RemoteException, MdException {
        ServerContext context = null;
        String strSelect = null;
        strSelect = server.getId() != null ? "<XMLSELECT search=\"ServerContext[@Id='" + server.getId() + "']\" />" : "<XMLSELECT search=\"ServerContext[@Name='" + server.getName() + "']\" />";
        MdFactory factory = store.getFactory();
        List lServerContexts = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, repos, "ServerContext", 8584, strSelect);
        if (lServerContexts.size() == 1) {
            context = (ServerContext)lServerContexts.get(0);
        }
        return context;
    }

    public static boolean updateSASAppServerDirectories(SASAppServer server, MdObjectStore store, String repos) throws RemoteException, MdException {
        ServerContext context = MetaUtilities.getSASAppServerContext(server, store, repos);
        boolean update = false;
        ArrayList<Directory> deleteList = new ArrayList<Directory>();
        if (context != null) {
            Directory dir;
            List dirs = server.getDirectories();
            ArrayList<DirectoryInfo> foundList = new ArrayList<DirectoryInfo>();
            AssociationList temp = context.getDataPackages(true);
            for (java.lang.Object obj : temp) {
                if (!(obj instanceof Directory)) continue;
                boolean found = false;
                dir = (Directory)obj;
                String dirId = dir.getId();
                for (int x = 0; x < dirs.size(); ++x) {
                    DirectoryInfo info = (DirectoryInfo)dirs.get(x);
                    String infoId = info.getId();
                    if (infoId == null || infoId.length() == 0) {
                        infoId = "NONSENSE";
                    }
                    if (infoId.compareTo(dirId) != 0) continue;
                    if (dir.getName().compareTo(info.getName()) != 0) {
                        dir.setName(info.getName());
                        update = true;
                    }
                    if (dir.getDirectoryName().compareTo(info.getPath()) != 0) {
                        dir.setDirectoryName(info.getPath());
                        update = true;
                    }
                    found = true;
                    foundList.add(info);
                    break;
                }
                if (found) continue;
                deleteList.add(dir);
            }
            for (int x = 0; x < dirs.size(); ++x) {
                DirectoryInfo info = (DirectoryInfo)dirs.get(x);
                if (foundList.contains(info)) continue;
                update = true;
                dir = MetaUtilities.createDirectoryObject(info.getName(), store, repos);
                dir.setDirectoryName(info.getPath());
                dir.setDesc(info.getDescription());
                temp.add((java.lang.Object)dir);
            }
            if (deleteList.size() > 0) {
                update = true;
                for (Directory dir2 : deleteList) {
                    dir2.delete();
                }
            }
            if (update) {
                context.updateMetadataAll();
            }
            return true;
        }
        return false;
    }

    public static List<JobInfo> getJFJobList(MdStore store, String repos) throws MdException, RemoteException {
        ArrayList<JobInfo> list = new ArrayList<JobInfo>();
        String selectXML = "<XMLSELECT search=\"*\"/>";
        String lightWeight = System.getProperty("schedulemgr.flowlist.light");
        selectXML = lightWeight != null ? selectXML + TEMPLATE_LeanFlowJobInfo : selectXML + TEMPLATE_BasicFlowJobInfo;
        int flags = 532876;
        MdFactory factory = store.getFactory();
        List jfjobList = factory.getOMIUtil().getMetadataObjectsSubset(store, repos, "JFJob", flags, selectXML);
        int listsize = jfjobList.size();
        for (int i = 0; i < listsize; ++i) {
            GregorianCalendar mcal;
            GregorianCalendar ccal;
            Date d;
            JFJob jfjob = (JFJob)jfjobList.get(i);
            String role = jfjob.getTransformRole();
            if (role.compareTo("") == 0) {
                role = jfjob.getJobActivities().size() > 0 ? FLOW_ROLE : JOB_ROLE;
                jfjob.setTransformRole(role);
            }
            Tree folder = null;
            AssociationList trees = jfjob.getTrees();
            if (trees.size() > 0) {
                folder = (Tree)trees.get(0);
            }
            if (FLOW_ROLE.equals(role)) {
                try {
                    JobInfo info = new JobInfo(jfjob.getName(), null, null);
                    info.setDescription(jfjob.getDesc());
                    info.setId(jfjob.getFQID());
                    ArrayList<String> jobids = new ArrayList<String>();
                    TransformationActivity ta = (TransformationActivity)jfjob.getJobActivities().get(0);
                    if (ta != null) {
                        if (lightWeight == null) {
                            d = DeployedFlow.getDateCreated(jfjob);
                            if (d != null) {
                                ccal = new GregorianCalendar();
                                ccal.setTime(d);
                                info.setCreationDateDataBinding((Calendar)ccal);
                            }
                            if ((d = DeployedFlow.getDateModified(jfjob, ta)) != null) {
                                mcal = new GregorianCalendar();
                                mcal.setTime(d);
                                info.setModifiedDateDataBinding((Calendar)mcal);
                            }
                        }
                        for (TransformationStep step : ta.getSteps()) {
                            if (step instanceof SyncStep) continue;
                            try {
                                JFJob jfjob2 = (JFJob)step.getTransformations().get(0);
                                if (jfjob2 == null) continue;
                                jobids.add(jfjob2.getId());
                            }
                            catch (ArrayIndexOutOfBoundsException ex) {}
                        }
                    }
                    info.setAsSubflow();
                    info.setSubflowJobIDs(jobids);
                    if (folder != null) {
                        info.setLocation(MetaUtilities.getFolderLocation(folder));
                        info.setLocationId(folder.getId());
                    }
                    info.setDisplayOnly(true);
                    info.setResponsiblePartyDataBinding(DeployedFlow.getResponsiblePartyForDeployment(jfjob));
                    list.add(info);
                }
                catch (Exception ex) {
                    if (!MetaUtilities.isDebug()) continue;
                    System.err.println("ERROR with " + jfjob.getName());
                    ex.printStackTrace();
                }
                continue;
            }
            if (!JOB_ROLE.equalsIgnoreCase(role)) continue;
            try {
                ServerComponent batchserver = CommandUtilities.getServerComponentForJob(jfjob);
                BatchServerInfo bsinfo = null;
                bsinfo = batchserver != null ? MetaUtilities.getBatchServer(batchserver) : new BatchServerInfo(null, -2, 0);
                JobInfo info = new JobInfo(jfjob.getName(), jfjob.getId(), bsinfo);
                if (lightWeight == null) {
                    d = DeployedJob.getDateCreated(jfjob);
                    if (d != null) {
                        ccal = new GregorianCalendar();
                        ccal.setTime(d);
                        info.setCreationDateDataBinding((Calendar)ccal);
                    }
                    if ((d = DeployedJob.getDateModified(jfjob)) != null) {
                        mcal = new GregorianCalendar();
                        mcal.setTime(d);
                        info.setModifiedDateDataBinding((Calendar)mcal);
                    }
                }
                info.setDescription(jfjob.getDesc());
                if (folder != null) {
                    info.setLocation(MetaUtilities.getFolderLocation(folder));
                    info.setLocationId(folder.getId());
                }
                info.setResponsiblePartyDataBinding(DeployedJob.getResponsiblePartyForDeployment(jfjob));
                info.setDisplayOnly(true);
                list.add(info);
                continue;
            }
            catch (Exception ex) {
                if (!MetaUtilities.isDebug()) continue;
                System.err.println("ERROR with " + jfjob.getName());
                ex.printStackTrace();
            }
        }
        if (lightWeight != null) {
            System.gc();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<JobInfo> getJFJobList(String role, MdFactory factory, String repos) throws RemoteException, MdException {
        ArrayList<JobInfo> returnList = new ArrayList<JobInfo>();
        String lightWeight = System.getProperty("schedulemgr.flowlist.light");
        boolean lean = lightWeight != null;
        MdObjectStore tempStore = null;
        try {
            int OMIFLAG_MULTI_TEMPLATE = 8580;
            tempStore = factory.createObjectStore(null, "getJFJobList");
            if (FLOW_ROLE.equals(role)) {
                String selectXML = "<XMLSELECT search=\"*[@TransformRole='" + role + "']\"/>";
                selectXML = lean ? selectXML + "<Templates><JFJob Name=\"\" TransformRole=\"\" Desc=\"\"><TargetSpecifications/></JFJob></Templates>" : selectXML + "<Templates><JFJob Name=\"\" TransformRole=\"\" Desc=\"\"><JobActivities/><TargetSpecifications/><Properties/><ComputeLocations/><Steps/><Trees/></JFJob><TransformationActivity><Steps/></TransformationActivity><TransformationStep><Transformations/></TransformationStep></Templates>";
                int flags = 532876;
                List list = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)tempStore, repos, "JFJob", flags, selectXML);
                int listsize = list.size();
                for (int i = 0; i < listsize; ++i) {
                    JFJob jfjob = (JFJob)list.get(i);
                    Tree folder = null;
                    AssociationList trees = jfjob.getTrees();
                    if (trees.size() > 0) {
                        folder = (Tree)trees.get(0);
                    }
                    try {
                        JobInfo info = new JobInfo(jfjob.getName(), null, null);
                        info.setDescription(jfjob.getDesc());
                        info.setId(jfjob.getFQID());
                        ArrayList<String> jobids = new ArrayList<String>();
                        TransformationActivity ta = null;
                        AssociationList tas = jfjob.getJobActivities(lean);
                        if (tas == null || tas.size() == 0) {
                            if (!MetaUtilities.isDebug()) continue;
                            System.out.println("DEPLOYEDFLOW MISSING TA: " + jfjob.getName());
                            continue;
                        }
                        ta = (TransformationActivity)tas.get(0);
                        if (!lean) {
                            Date d = DeployedFlow.getDateCreated(jfjob);
                            if (d != null) {
                                GregorianCalendar ccal = new GregorianCalendar();
                                ccal.setTime(d);
                                info.setCreationDateDataBinding((Calendar)ccal);
                            }
                            if ((d = DeployedFlow.getDateModified(jfjob, ta)) != null) {
                                GregorianCalendar mcal = new GregorianCalendar();
                                mcal.setTime(d);
                                info.setModifiedDateDataBinding((Calendar)mcal);
                            }
                        }
                        for (TransformationStep step : ta.getSteps(lean)) {
                            if (step instanceof SyncStep) continue;
                            try {
                                JFJob jfjob2 = (JFJob)step.getTransformations(lean).get(0);
                                if (jfjob2 == null) continue;
                                jobids.add(jfjob2.getId());
                            }
                            catch (ArrayIndexOutOfBoundsException ex) {}
                        }
                        info.setAsSubflow();
                        info.setSubflowJobIDs(jobids);
                        if (folder != null) {
                            info.setLocation(MetaUtilities.getFolderLocation(folder));
                            info.setLocationId(folder.getId());
                        } else if (MetaUtilities.isDebug()) {
                            System.out.println("DEPLOYEDFLOW MISSING FOLDER: " + jfjob.getName());
                        }
                        info.setDisplayOnly(true);
                        returnList.add(info);
                        continue;
                    }
                    catch (Exception ex) {
                        if (!MetaUtilities.isDebug()) continue;
                        ex.printStackTrace();
                    }
                }
            } else if (JOB_ROLE.equalsIgnoreCase(role)) {
                String selectXML = "<XMLSELECT search=\"*[@TransformRole='" + role + "']\"/>";
                selectXML = lean ? selectXML + "<Templates><JFJob Name=\"\" TransformRole=\"\" Desc=\"\"><TargetSpecifications/></JFJob></Templates>" : selectXML + "<Templates><JFJob Name=\"\" TransformRole=\"\" Desc=\"\"><TargetSpecifications/><ComputeLocations/><AssociatedJob/><SourceCode/><Trees/></JFJob></Templates>";
                int flags = 532876;
                List list = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)tempStore, repos, "JFJob", flags, selectXML);
                int listsize = list.size();
                for (int i = 0; i < listsize; ++i) {
                    JFJob jfjob = (JFJob)list.get(i);
                    Tree folder = null;
                    AssociationList trees = jfjob.getTrees();
                    if (trees.size() > 0) {
                        folder = (Tree)trees.get(0);
                    }
                    try {
                        ServerComponent batchserver = CommandUtilities.getServerComponentForJob(jfjob);
                        BatchServerInfo bsinfo = null;
                        bsinfo = batchserver != null ? MetaUtilities.getBatchServer(batchserver) : new BatchServerInfo(null, -2, 0);
                        JobInfo info = new JobInfo(jfjob.getName(), jfjob.getId(), bsinfo);
                        info.setDisplayOnly(true);
                        info.setDescription(jfjob.getDesc());
                        if (!lean) {
                            Date d = DeployedJob.getDateCreated(jfjob);
                            if (d != null) {
                                GregorianCalendar ccal = new GregorianCalendar();
                                ccal.setTime(d);
                                info.setCreationDateDataBinding((Calendar)ccal);
                            }
                            if ((d = DeployedJob.getDateModified(jfjob)) != null) {
                                GregorianCalendar mcal = new GregorianCalendar();
                                mcal.setTime(d);
                                info.setModifiedDateDataBinding((Calendar)mcal);
                            }
                        }
                        if (folder != null) {
                            info.setLocation(MetaUtilities.getFolderLocation(folder));
                            info.setLocationId(folder.getId());
                        } else if (MetaUtilities.isDebug()) {
                            System.out.println("DEPLOYEDJOB MISSING FOLDER: " + jfjob.getName());
                        }
                        returnList.add(info);
                        continue;
                    }
                    catch (Exception ex) {
                        if (!MetaUtilities.isDebug()) continue;
                        ex.printStackTrace();
                    }
                }
            }
        }
        finally {
            if (tempStore != null) {
                tempStore.dispose();
            }
            if (lean) {
                System.gc();
            }
        }
        return returnList;
    }

    public static List<JobInfo> getAvailJobListByFolder(String location, List<String> exclude, MdStore store, String repos) throws MdException, RemoteException {
        ArrayList<JobInfo> list = new ArrayList<JobInfo>();
        String treeName = location;
        int t = location.lastIndexOf(47);
        if (t >= 0) {
            treeName = location.substring(t + 1);
        }
        String selectXML = "<XMLSELECT search=\"JFJob[Trees/Tree[@Name='" + treeName + "']]\" />";
        String lightWeight = System.getProperty("schedulemgr.flowlist.light");
        selectXML = lightWeight != null ? selectXML + TEMPLATE_LeanFlowJobInfo : selectXML + TEMPLATE_BasicFlowJobInfo;
        int flags = 532876;
        MdFactory factory = store.getFactory();
        List jfjobList = factory.getOMIUtil().getMetadataObjectsSubset(store, repos, "JFJob", flags, selectXML);
        int listsize = jfjobList.size();
        for (int i = 0; i < listsize; ++i) {
            String folderLocation;
            GregorianCalendar mcal;
            GregorianCalendar ccal;
            Date d;
            JFJob jfjob = (JFJob)jfjobList.get(i);
            String role = jfjob.getTransformRole();
            String name = jfjob.getName();
            if (exclude.contains(name)) continue;
            Tree folder = null;
            AssociationList trees = jfjob.getTrees();
            if (trees.size() > 0) {
                folder = (Tree)trees.get(0);
            }
            if (FLOW_ROLE.equals(role)) {
                try {
                    JobInfo info = new JobInfo(jfjob.getName(), null, null);
                    info.setDescription(jfjob.getDesc());
                    info.setId(jfjob.getFQID());
                    ArrayList<String> jobids = new ArrayList<String>();
                    TransformationActivity ta = (TransformationActivity)jfjob.getJobActivities().get(0);
                    if (ta != null) {
                        if (lightWeight == null) {
                            d = DeployedFlow.getDateCreated(jfjob);
                            if (d != null) {
                                ccal = new GregorianCalendar();
                                ccal.setTime(d);
                                info.setCreationDateDataBinding((Calendar)ccal);
                            }
                            if ((d = DeployedFlow.getDateModified(jfjob, ta)) != null) {
                                mcal = new GregorianCalendar();
                                mcal.setTime(d);
                                info.setModifiedDateDataBinding((Calendar)mcal);
                            }
                        }
                        for (TransformationStep step : ta.getSteps()) {
                            if (step instanceof SyncStep) continue;
                            try {
                                JFJob jfjob2 = (JFJob)step.getTransformations().get(0);
                                if (jfjob2 == null) continue;
                                jobids.add(jfjob2.getId());
                            }
                            catch (ArrayIndexOutOfBoundsException ex) {}
                        }
                    }
                    info.setAsSubflow();
                    info.setSubflowJobIDs(jobids);
                    if (folder != null && location.equals(folderLocation = MetaUtilities.getFolderLocation(folder))) {
                        info.setLocation(folderLocation);
                        info.setLocationId(folder.getId());
                    }
                    info.setDisplayOnly(true);
                    info.setResponsiblePartyDataBinding(DeployedFlow.getResponsiblePartyForDeployment(jfjob));
                    list.add(info);
                }
                catch (Exception ex) {
                    if (!MetaUtilities.isDebug()) continue;
                    System.err.println("ERROR with " + jfjob.getName());
                    ex.printStackTrace();
                }
                continue;
            }
            if (!JOB_ROLE.equalsIgnoreCase(role)) continue;
            try {
                ServerComponent batchserver = CommandUtilities.getServerComponentForJob(jfjob);
                BatchServerInfo bsinfo = null;
                bsinfo = batchserver != null ? MetaUtilities.getBatchServer(batchserver) : new BatchServerInfo(null, -2, 0);
                JobInfo info = new JobInfo(jfjob.getName(), jfjob.getId(), bsinfo);
                if (lightWeight == null) {
                    d = DeployedJob.getDateCreated(jfjob);
                    if (d != null) {
                        ccal = new GregorianCalendar();
                        ccal.setTime(d);
                        info.setCreationDateDataBinding((Calendar)ccal);
                    }
                    if ((d = DeployedJob.getDateModified(jfjob)) != null) {
                        mcal = new GregorianCalendar();
                        mcal.setTime(d);
                        info.setModifiedDateDataBinding((Calendar)mcal);
                    }
                }
                info.setDescription(jfjob.getDesc());
                if (folder != null && location.equals(folderLocation = MetaUtilities.getFolderLocation(folder))) {
                    info.setLocation(folderLocation);
                    info.setLocationId(folder.getId());
                }
                info.setResponsiblePartyDataBinding(DeployedJob.getResponsiblePartyForDeployment(jfjob));
                info.setDisplayOnly(true);
                list.add(info);
                continue;
            }
            catch (Exception ex) {
                if (!MetaUtilities.isDebug()) continue;
                System.err.println("ERROR with " + jfjob.getName());
                ex.printStackTrace();
            }
        }
        if (lightWeight != null) {
            System.gc();
        }
        return list;
    }

    public static List<JFJob> getJFJobList(String role, MdObjectStore store, String repos) throws RemoteException, MdException {
        ArrayList<JFJob> returnList = new ArrayList<JFJob>();
        int OMIFLAG_MULTI_TEMPLATE = 8580;
        String selectXML = "<XMLSELECT search=\"*[@TransformRole='" + role + "']\"/><Templates><JFJob Name=\"\" TransformRole=\"\" Desc=\"\"><JobActivities/><TargetSpecifications/></JFJob><TransformationActivity><Steps/></TransformationActivity><TransformationStep><Transformations/></TransformationStep></Templates>";
        MdFactory factory = store.getFactory();
        List list = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, repos, "JFJob", OMIFLAG_MULTI_TEMPLATE, selectXML);
        int listsize = list.size();
        for (int i = 0; i < listsize; ++i) {
            JFJob jfjob = (JFJob)list.get(i);
            if (FLOW_ROLE.equals(jfjob.getTransformRole())) {
                returnList.add(jfjob);
                continue;
            }
            if (!JOB_ROLE.equalsIgnoreCase(jfjob.getTransformRole())) continue;
            returnList.add(jfjob);
        }
        return returnList;
    }

    public static List<FlowInfo> getFlowsFromRepository(MdObjectStore store, String repos, boolean displayOnly) throws MdException, RemoteException {
        String template = TEMPLATE_FullFlowInfo;
        String lightWeight = System.getProperty("schedulemgr.flowlist.light");
        if (lightWeight != null) {
            template = TEMPLATE_BasicFlowsInRepository;
        } else if (displayOnly) {
            template = TEMPLATE_FlowsInRepository;
        }
        String selectXML = "<XMLSELECT search=\"*[@TransformRole='SCHEDULER_FLOW']\"/>" + template;
        return MetaUtilities.getFlowsFromRepository(selectXML, store, repos, displayOnly);
    }

    public static List<JobInfo> getSubflowsFromRepository(MdStore store, String repos) throws MdException, RemoteException {
        String template = TEMPLATE_FlowsInRepository;
        String lightWeight = System.getProperty("schedulemgr.flowlist.light");
        if (lightWeight != null) {
            template = TEMPLATE_BasicFlowsInRepository;
        }
        String selectXML = "<XMLSELECT search=\"*[@TransformRole='SCHEDULER_FLOW']\"/>" + template;
        return MetaUtilities.getSubflowsFromRepository(selectXML, store, repos);
    }

    public static List<FlowInfo> getFlowsFromRepository(String selectXML, MdObjectStore store, String repos, boolean displayOnly) throws MdException, RemoteException {
        ArrayList<FlowInfo> flowlist = new ArrayList<FlowInfo>();
        int flags = 532876;
        MdFactory factory = store.getFactory();
        List jfjobList = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, repos, "JFJob", flags, selectXML);
        int listsize = jfjobList.size();
        for (int i = 0; i < listsize; ++i) {
            JFJob flow = (JFJob)jfjobList.get(i);
            String role = flow.getTransformRole();
            if (!FLOW_ROLE.equals(role)) continue;
            try {
                FlowInfo info = DeployedFlow.getInfo(flow, store, displayOnly);
                if (info == null) continue;
                flowlist.add(info);
                continue;
            }
            catch (RuntimeException ex) {
                if (!MetaUtilities.isDebug()) continue;
                ex.printStackTrace();
            }
        }
        String lightWeight = System.getProperty("schedulemgr.flowlist.light");
        if (lightWeight != null) {
            System.gc();
        }
        return flowlist;
    }

    public static List<JobInfo> getSubflowsFromRepository(String selectXML, MdStore store, String repos) throws MdException, RemoteException {
        ArrayList<JobInfo> flowlist = new ArrayList<JobInfo>();
        int flags = 532876;
        MdFactory factory = store.getFactory();
        List jfjobList = factory.getOMIUtil().getMetadataObjectsSubset(store, repos, "JFJob", flags, selectXML);
        int listsize = jfjobList.size();
        for (int i = 0; i < listsize; ++i) {
            JFJob flow = (JFJob)jfjobList.get(i);
            String role = flow.getTransformRole();
            if (!FLOW_ROLE.equals(role)) continue;
            try {
                Tree folder;
                JobInfo info = new JobInfo(flow.getName(), null, null);
                info.setDisplayOnly(true);
                info.setDescription(flow.getDesc());
                info.setId(flow.getFQID());
                info.setAsSubflow();
                Date d = DeployedFlow.getDateCreated(flow);
                if (d != null) {
                    GregorianCalendar ccal = new GregorianCalendar();
                    ccal.setTime(d);
                    info.setCreationDateDataBinding((Calendar)ccal);
                }
                if ((d = DeployedFlow.getDateModified(flow, (TransformationActivity)flow.getJobActivities().get(0))) != null) {
                    GregorianCalendar mcal = new GregorianCalendar();
                    mcal.setTime(d);
                    info.setModifiedDateDataBinding((Calendar)mcal);
                }
                if ((folder = DeployedFlow.getFolder(flow)) != null) {
                    info.setLocation(MetaUtilities.getFolderLocation(folder));
                    info.setLocationId(folder.getId());
                }
                flowlist.add(info);
                continue;
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        String lightWeight = System.getProperty("schedulemgr.flowlist.light");
        if (lightWeight != null) {
            System.gc();
        }
        return flowlist;
    }

    public static List<FlowInfo> getDeployedFlowsForServerComponent(SchedulerServerInfo ssi) throws SchedulerException {
        block10: {
            MdObjectStore store = MetaUtilities.getDefaultStore();
            if (store != null) {
                return MetaUtilities.getDeployedFlowsForServerComponent(ssi, store);
            }
            if (m_sessionContextInterface != null) {
                try {
                    UserContextInterface user = m_sessionContextInterface.getUserContext();
                    if (user == null) break block10;
                    OMIServer server = (OMIServer)user.getAuthServer();
                    MdFactory factory = server.getMdFactory();
                    if (factory.getInstance() == null) {
                        if (MetaUtilities.isDebug()) {
                            RuntimeException ex = new RuntimeException(m_bundle.getString("MetaUtilities.MdFactory.Disposed.txt"));
                            ex.printStackTrace();
                        }
                        break block10;
                    }
                    store = m_defaultMdFactory.createObjectStore(null, "getDeployedFlowsForServerComponent");
                    return MetaUtilities.getDeployedFlowsForServerComponent(ssi, store);
                }
                catch (Exception e) {
                    if (MetaUtilities.isDebug()) {
                        e.printStackTrace();
                    }
                    break block10;
                }
            }
            if (m_defaultMdFactory != null) {
                try {
                    store = m_defaultMdFactory.createObjectStore(null, "getDeployedFlowsForServerComponent");
                    return MetaUtilities.getDeployedFlowsForServerComponent(ssi, store);
                }
                catch (Exception e) {
                    if (!MetaUtilities.isDebug()) break block10;
                    e.printStackTrace();
                }
            }
        }
        return new ArrayList<FlowInfo>();
    }

    public static List<FlowInfo> getDeployedFlowsForServerComponent(SchedulerServerInfo ssi, MdObjectStore store) throws SchedulerException {
        ArrayList<FlowInfo> results = new ArrayList<FlowInfo>();
        String strSelect = "<XMLSELECT search=\"JFJob[ComputeLocations/ServerComponent[@Id='" + ssi.getId() + "']]\" />" + TEMPLATE_FullFlowInfo;
        try {
            MdFactory factory = store.getFactory();
            List allSchedules = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, "A0000001." + ssi.getId().substring(0, 8), "JFJob", 8588, strSelect);
            for (java.lang.Object loc : allSchedules) {
                if (!(loc instanceof JFJob)) continue;
                JFJob flow = (JFJob)loc;
                String role = flow.getTransformRole();
                if (role.compareTo("") == 0) {
                    role = flow.getJobActivities().size() > 0 ? FLOW_ROLE : JOB_ROLE;
                    flow.setTransformRole(role);
                }
                if (!FLOW_ROLE.equals(role)) continue;
                FlowInfo info = DeployedFlow.getInfo(flow, store, false);
                results.add(info);
            }
        }
        catch (MdException ex) {
            SchedulerException se = new SchedulerException(ex.toString());
            se.initCause((Throwable)ex);
            throw se;
        }
        catch (RemoteException ex) {
            SchedulerException se = new SchedulerException(ex.toString());
            se.initCause((Throwable)ex);
            throw se;
        }
        return results;
    }

    public static List<DeployedFlow> getDeployedFlowsForServerComponent(ServerComponent sc, MdObjectStore store) throws RemoteException, MdException {
        ArrayList<DeployedFlow> results = new ArrayList<DeployedFlow>();
        String strSelect = "<XMLSELECT search=\"JFJob[ComputeLocations/ServerComponent[@Id='" + sc.getId() + "']]\" />" + TEMPLATE_FullFlowInfo;
        MdFactory factory = store.getFactory();
        List allSchedules = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, "A0000001." + sc.getRepositoryID(), "JFJob", 8588, strSelect);
        for (java.lang.Object loc : allSchedules) {
            if (!(loc instanceof JFJob)) continue;
            JFJob flow = (JFJob)loc;
            String role = flow.getTransformRole();
            if (role.compareTo("") == 0) {
                role = flow.getJobActivities().size() > 0 ? FLOW_ROLE : JOB_ROLE;
                flow.setTransformRole(role);
            }
            if (!FLOW_ROLE.equals(role)) continue;
            DeployedFlow dFlow = new DeployedFlow(flow, store);
            results.add(dFlow);
        }
        return results;
    }

    public static FlowInfo getFlowFromRepository(String id, MdObjectStore store, String repos, boolean displayOnly) throws MdException, RemoteException {
        JFJob flow = null;
        try {
            flow = displayOnly ? MetaUtilities.getJFJob(id, (MdStore)store, repos) : MetaUtilities.getJFJob(id, (MdStore)store, repos, TEMPLATE_FullFlowInfo);
        }
        catch (SchedulerException se) {
            return null;
        }
        String role = flow.getTransformRole();
        if (!(role.equals(FLOW_ROLE_MARK_DELETE) || role.equals(JOB_ROLE) || role.equals(JOB_ROLE_MARK_DELETE))) {
            return DeployedFlow.getInfo(flow, store, displayOnly);
        }
        return null;
    }

    public static SortedSet<FlowInfo> getFlowsFromRepository(FilterSelector filter, MdObjectStore store, String repos, boolean displayOnly) throws MdException, RemoteException {
        JFJob flow;
        Date server;
        int x;
        TreeSet<FlowInfo> flowlist = new TreeSet<FlowInfo>((Comparator<FlowInfo>)new CompareDisplayInfoObjects());
        MdFactory factory = store.getFactory();
        int flags = 532876;
        String selectXML = null;
        List flows = null;
        FilterRule rule = filter.getRule(0);
        String column = rule.getColumnName();
        int columnID = FlowColumnSelectorModel.getColumnKeyFromName((String)column);
        switch (columnID) {
            case 0: {
                String role;
                JFJob obj;
                selectXML = "<XMLSELECT search=\"JFJob[" + MetaUtilities.getSelectXMLSub("@Name", rule.getCondition(), rule.getValue()) + "]\" />" + TEMPLATE_FlowsInRepository;
                flows = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, repos, "JFJob", flags, selectXML);
                for (x = flows.size() - 1; x >= 0; --x) {
                    obj = (JFJob)flows.get(x);
                    role = obj.getTransformRole();
                    if (role.compareTo("") == 0) {
                        role = obj.getJobActivities().size() > 0 ? FLOW_ROLE : JOB_ROLE;
                        obj.setTransformRole(role);
                    }
                    if (FLOW_ROLE.equalsIgnoreCase(role)) continue;
                    flows.remove(x);
                }
                break;
            }
            case 1: {
                JFJob flow2;
                String role;
                selectXML = "<XMLSELECT search=\"JFJob[JobActivities/*TransformationActivity]\"/><Templates><JFJob><JobActivities/><ComputeLocations/><Properties/><Trees/><Steps/></JFJob><TransformationActivity><Steps/></TransformationActivity></Templates>";
                flows = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, repos, "JFJob", flags, selectXML);
                for (x = flows.size() - 1; x >= 0; --x) {
                    flow2 = (JFJob)flows.get(x);
                    role = flow2.getTransformRole();
                    if (role.compareTo("") == 0) {
                        role = flow2.getJobActivities().size() > 0 ? FLOW_ROLE : JOB_ROLE;
                        flow2.setTransformRole(role);
                    }
                    if (!FLOW_ROLE.equalsIgnoreCase(role)) {
                        flows.remove(x);
                        continue;
                    }
                    if (MetaUtilities.matchJobCountCriteria(flow2, rule)) continue;
                    flows.remove(x);
                }
                break;
            }
            case 2: {
                String role;
                JFJob obj;
                selectXML = "<XMLSELECT search=\"JFJob[" + MetaUtilities.getSelectXMLSub("@MetadataCreated", rule.getCondition(), rule.getValue()) + "]\" />" + TEMPLATE_FlowsInRepository;
                flows = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, repos, "JFJob", flags, selectXML);
                for (x = flows.size() - 1; x >= 0; --x) {
                    obj = (JFJob)flows.get(x);
                    role = obj.getTransformRole();
                    if (role.compareTo("") == 0) {
                        role = obj.getJobActivities().size() > 0 ? FLOW_ROLE : JOB_ROLE;
                        obj.setTransformRole(role);
                    }
                    if (FLOW_ROLE.equalsIgnoreCase(role)) continue;
                    flows.remove(x);
                }
                break;
            }
            case 3: {
                JFJob flow2;
                String role;
                selectXML = "<XMLSELECT search=\"JFJob[JobActivities/*TransformationActivity]\"/><Templates><JFJob><JobActivities/><ComputeLocations/><Properties/><Trees/><Steps/></JFJob><TransformationActivity><Steps/></TransformationActivity></Templates>";
                flows = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, repos, "JFJob", flags, selectXML);
                for (x = flows.size() - 1; x >= 0; --x) {
                    flow2 = (JFJob)flows.get(x);
                    role = flow2.getTransformRole();
                    if (role.compareTo("") == 0) {
                        role = flow2.getJobActivities().size() > 0 ? FLOW_ROLE : JOB_ROLE;
                        flow2.setTransformRole(role);
                    }
                    if (!FLOW_ROLE.equalsIgnoreCase(role)) {
                        flows.remove(x);
                        continue;
                    }
                    TransformationActivity activity = (TransformationActivity)flow2.getJobActivities().get(0);
                    server = DeployedFlow.getDateModified(flow2, activity);
                    if (MetaUtilities.matchTimeCriteria(server, rule)) continue;
                    flows.remove(x);
                }
                break;
            }
            case 4: {
                String role;
                JFJob obj;
                selectXML = "<XMLSELECT search=\"JFJob[JobActivities/*TransformationActivity]\"/><Templates><JFJob><JobActivities/><ComputeLocations/><Properties/><Trees/><Steps/></JFJob><TransformationActivity><Steps/></TransformationActivity></Templates>";
                flows = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, repos, "JFJob", flags, selectXML);
                for (x = flows.size() - 1; x >= 0; --x) {
                    obj = (JFJob)flows.get(x);
                    role = obj.getTransformRole();
                    if (role.compareTo("") == 0) {
                        role = obj.getJobActivities().size() > 0 ? FLOW_ROLE : JOB_ROLE;
                        obj.setTransformRole(role);
                    }
                    if (!FLOW_ROLE.equalsIgnoreCase(role)) {
                        flows.remove(x);
                        continue;
                    }
                    flow = (JFJob)flows.get(x);
                    if (MetaUtilities.matchLastExecutionCriteria(flow, store, rule)) continue;
                    flows.remove(x);
                }
                break;
            }
            case 5: {
                String role;
                JFJob obj;
                selectXML = "<XMLSELECT search=\"JFJob[" + MetaUtilities.getSelectXMLSub("@Id", rule.getCondition(), rule.getValue()) + "]\" />" + TEMPLATE_FlowsInRepository;
                flows = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, repos, "JFJob", flags, selectXML);
                for (x = flows.size() - 1; x >= 0; --x) {
                    obj = (JFJob)flows.get(x);
                    role = obj.getTransformRole();
                    if (role.compareTo("") == 0) {
                        role = obj.getJobActivities().size() > 0 ? FLOW_ROLE : JOB_ROLE;
                        obj.setTransformRole(role);
                    }
                    if (FLOW_ROLE.equalsIgnoreCase(role)) continue;
                    flows.remove(x);
                }
                break;
            }
            case 6: {
                String role;
                JFJob obj;
                selectXML = "<XMLSELECT search=\"JFJob[ComputeLocations/ServerComponent[" + MetaUtilities.getSelectXMLSub("@Name", rule.getCondition(), rule.getValue()) + "]]\" />" + TEMPLATE_FlowsInRepository;
                flows = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, repos, "JFJob", flags, selectXML);
                for (x = flows.size() - 1; x >= 0; --x) {
                    obj = (JFJob)flows.get(x);
                    role = obj.getTransformRole();
                    if (FLOW_ROLE.equalsIgnoreCase(role)) continue;
                    flows.remove(x);
                }
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                String role;
                JFJob obj;
                selectXML = "<XMLSELECT search=\"JFJob[Properties/Property[@PropertyName='SCHEDULEID' and " + MetaUtilities.getSelectXMLSub("@DefaultValue", rule.getCondition(), rule.getValue()) + "]]\" />" + TEMPLATE_FlowsInRepository;
                flows = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, repos, "JFJob", flags, selectXML);
                for (x = flows.size() - 1; x >= 0; --x) {
                    obj = (JFJob)flows.get(x);
                    role = obj.getTransformRole();
                    if (role.compareTo("") == 0) {
                        role = obj.getJobActivities().size() > 0 ? FLOW_ROLE : JOB_ROLE;
                        obj.setTransformRole(role);
                    }
                    if (FLOW_ROLE.equalsIgnoreCase(role)) continue;
                    flows.remove(x);
                }
                break;
            }
        }
        if (flows != null) {
            int numRules = filter.getRuleCount();
            block58: for (int i = 1; i < numRules; ++i) {
                rule = filter.getRule(i);
                column = rule.getColumnName();
                columnID = FlowColumnSelectorModel.getColumnKeyFromName((String)column);
                switch (columnID) {
                    case 0: {
                        JFJob obj;
                        int x2;
                        block59: for (x2 = flows.size() - 1; x2 >= 0; --x2) {
                            obj = (JFJob)flows.get(x2);
                            switch (rule.getCondition()) {
                                case 0: {
                                    if (obj.getName().compareTo(rule.getValue()) == 0) continue block59;
                                    flows.remove(x2);
                                    continue block59;
                                }
                                case 3: {
                                    if (obj.getName().indexOf(rule.getValue()) >= 0) continue block59;
                                    flows.remove(x2);
                                    continue block59;
                                }
                                case 1: {
                                    if (obj.getName().startsWith(rule.getValue())) continue block59;
                                    flows.remove(x2);
                                    continue block59;
                                }
                                case 2: {
                                    if (obj.getName().endsWith(rule.getValue())) continue block59;
                                    flows.remove(x2);
                                }
                            }
                        }
                        continue block58;
                    }
                    case 1: {
                        int x2;
                        for (x2 = flows.size() - 1; x2 >= 0; --x2) {
                            flow = (JFJob)flows.get(x2);
                            if (MetaUtilities.matchJobCountCriteria(flow, rule)) continue;
                            flows.remove(x2);
                        }
                        continue block58;
                    }
                    case 2: {
                        int x2;
                        for (x2 = flows.size() - 1; x2 >= 0; --x2) {
                            flow = (JFJob)flows.get(x2);
                            server = DeployedFlow.getDateCreated(flow);
                            if (MetaUtilities.matchTimeCriteria(server, rule)) continue;
                            flows.remove(x2);
                        }
                        continue block58;
                    }
                    case 3: {
                        int x2;
                        for (x2 = flows.size() - 1; x2 >= 0; --x2) {
                            TransformationActivity activity;
                            flow = (JFJob)flows.get(x2);
                            Date server2 = DeployedFlow.getDateModified(flow, activity = (TransformationActivity)flow.getJobActivities().get(0));
                            if (MetaUtilities.matchTimeCriteria(server2, rule)) continue;
                            flows.remove(x2);
                        }
                        continue block58;
                    }
                    case 4: {
                        int x2;
                        for (x2 = flows.size() - 1; x2 >= 0; --x2) {
                            flow = (JFJob)flows.get(x2);
                            if (MetaUtilities.matchLastExecutionCriteria(flow, store, rule)) continue;
                            flows.remove(x2);
                        }
                        continue block58;
                    }
                    case 5: {
                        JFJob obj;
                        int x2;
                        block64: for (x2 = flows.size() - 1; x2 >= 0; --x2) {
                            obj = (JFJob)flows.get(x2);
                            switch (rule.getCondition()) {
                                case 0: {
                                    if (obj.getId().compareTo(rule.getValue()) == 0) continue block64;
                                    flows.remove(x2);
                                    continue block64;
                                }
                                case 3: {
                                    if (obj.getId().indexOf(rule.getValue()) >= 0) continue block64;
                                    flows.remove(x2);
                                    continue block64;
                                }
                                case 1: {
                                    if (obj.getId().startsWith(rule.getValue())) continue block64;
                                    flows.remove(x2);
                                    continue block64;
                                }
                                case 2: {
                                    if (obj.getId().endsWith(rule.getValue())) continue block64;
                                    flows.remove(x2);
                                }
                            }
                        }
                        continue block58;
                    }
                    case 6: {
                        JFJob obj;
                        int x2;
                        for (x2 = flows.size() - 1; x2 >= 0; --x2) {
                            obj = (JFJob)flows.get(x2);
                            try {
                                String schName = DeployedFlow.getSchedulerComponent(obj).getName();
                                switch (rule.getCondition()) {
                                    case 0: {
                                        if (schName.compareTo(rule.getValue()) == 0) break;
                                        flows.remove(x2);
                                        break;
                                    }
                                    case 3: {
                                        if (schName.indexOf(rule.getValue()) >= 0) break;
                                        flows.remove(x2);
                                        break;
                                    }
                                    case 1: {
                                        if (schName.startsWith(rule.getValue())) break;
                                        flows.remove(x2);
                                        break;
                                    }
                                    case 2: {
                                        if (schName.endsWith(rule.getValue())) break;
                                        flows.remove(x2);
                                    }
                                }
                                continue;
                            }
                            catch (RuntimeException ex) {
                                flows.remove(x2);
                            }
                        }
                        continue block58;
                    }
                    case 7: {
                        continue block58;
                    }
                    case 8: {
                        JFJob obj;
                        int x2;
                        for (x2 = flows.size() - 1; x2 >= 0; --x2) {
                            obj = (JFJob)flows.get(x2);
                            try {
                                String username = DeployedFlow.getScheduledUser(obj);
                                switch (rule.getCondition()) {
                                    case 0: {
                                        if (username.compareTo(rule.getValue()) == 0) break;
                                        flows.remove(x2);
                                        break;
                                    }
                                    case 3: {
                                        if (username.indexOf(rule.getValue()) >= 0) break;
                                        flows.remove(x2);
                                        break;
                                    }
                                    case 1: {
                                        if (username.startsWith(rule.getValue())) break;
                                        flows.remove(x2);
                                        break;
                                    }
                                    case 2: {
                                        if (username.endsWith(rule.getValue())) break;
                                        flows.remove(x2);
                                    }
                                }
                                continue;
                            }
                            catch (RuntimeException ex) {
                                flows.remove(x2);
                            }
                        }
                        continue block58;
                    }
                }
            }
        }
        if (flows != null) {
            for (x = 0; x < flows.size(); ++x) {
                JFJob flow3 = (JFJob)flows.get(x);
                FlowInfo info = DeployedFlow.getInfo(flow3, store, displayOnly);
                flowlist.add(info);
            }
        }
        return flowlist;
    }

    private static boolean matchJobCountCriteria(JFJob flow, FilterRule rule) throws MdException, RemoteException {
        TransformationActivity activity = (TransformationActivity)flow.getJobActivities().get(0);
        if (activity == null) {
            return false;
        }
        Iterator i = activity.getSteps().iterator();
        int count = 0;
        while (i.hasNext()) {
            block17: {
                TransformationStep step = (TransformationStep)i.next();
                if (step instanceof SyncStep) continue;
                JFJob jfjob = null;
                try {
                    String role;
                    jfjob = (JFJob)step.getTransformations().get(0);
                    if (jfjob == null || (role = jfjob.getTransformRole()).compareTo(FLOW_ROLE_MARK_DELETE) == 0) continue;
                    if (role.compareTo(JOB_ROLE_MARK_DELETE) == 0) {
                    }
                    break block17;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    MdFactory factory = step.getObjectStore().getFactory();
                    int c = factory.getSecurityUtil().getAssociationCountForObject((CMetadata)jfjob, "AssociatedJob");
                    if (c != 0) break block17;
                }
                continue;
            }
            ++count;
        }
        try {
            int value = Integer.parseInt(rule.getValue());
            switch (rule.getCondition()) {
                case 4: {
                    if (count <= value) {
                        return false;
                    }
                    break;
                }
                case 5: {
                    if (count >= value) {
                        return false;
                    }
                    break;
                }
                case 6: {
                    if (count != value) {
                        return false;
                    }
                    break;
                }
                case 7: {
                    if (count == value) {
                        return false;
                    }
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return true;
    }

    private static boolean matchLastExecutionCriteria(JFJob flow, MdObjectStore store, FilterRule rule) throws MdException, RemoteException {
        DeployedFlow dflow = new DeployedFlow(flow, store);
        SubmitFlow submitter = new SubmitFlow(dflow);
        boolean scheduled = dflow.isFlowSubmitted();
        if (scheduled) {
            String user = null;
            SealedString pass = null;
            PasswordAuthentication l = MetaUtilities.getLoginInformation(dflow.getSchedulerComponent());
            if (l == null) {
                return false;
            }
            user = l.getUserName();
            pass = l.getPassword() != null ? new SealedString(l.getPassword()) : null;
            try {
                Date timestamp = submitter.getFinishTime(user, pass);
                if (!MetaUtilities.matchTimeCriteria(timestamp, rule)) {
                    return false;
                }
            }
            catch (SchedulerException ex) {
                return false;
            }
            catch (NotOwnerException ex) {
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean matchTimeCriteria(Date sdate, FilterRule rule) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(OMR_DATEFORMAT, Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        try {
            Date udate = dateFormat.parse(rule.getValue());
            switch (rule.getCondition()) {
                case 4: {
                    if (!udate.after(sdate)) break;
                    return false;
                }
                case 5: {
                    if (!udate.before(sdate)) break;
                    return false;
                }
            }
        }
        catch (ParseException ex) {
            return false;
        }
        return true;
    }

    private static String getSelectXMLSub(String name, int condition, String value) {
        String str = "";
        switch (condition) {
            case 0: {
                str = name + "='" + value + "'";
                break;
            }
            case 3: {
                str = name + "?'" + value + "'";
                break;
            }
            case 1: {
                if (value.compareTo("") == 0) {
                    str = name + " NE '_RSW123_SOME_STRING_THAT_DOES_NOT_MATCH_ANYTHING'";
                    break;
                }
                str = name + "=:'" + value + "'";
                break;
            }
            case 2: {
                str = name + "='*" + value + "'";
                break;
            }
            case 4: {
                str = name + " GT '" + value + "'";
                break;
            }
            case 5: {
                str = name + " LT '" + value + "'";
                break;
            }
            case 6: {
                str = name + " EQ '" + value + "'";
                break;
            }
            case 7: {
                str = name + " NE '" + value + "'";
            }
        }
        return str;
    }

    public static SortedSet<FlowInfo> getFlowsFromRepository(int category, MdObjectStore store, String repos, boolean displayOnly) throws MdException, RemoteException {
        TreeSet<FlowInfo> flowlist = new TreeSet<FlowInfo>((Comparator<FlowInfo>)new CompareDisplayInfoObjects());
        switch (category) {
            case 0: {
                List<FlowInfo> list = MetaUtilities.getFlowsFromRepository(store, repos, displayOnly);
                flowlist.addAll(list);
                break;
            }
            case 1: {
                break;
            }
            case 4: {
                break;
            }
            case 2: {
                break;
            }
        }
        return flowlist;
    }

    public static SortedSet<DisplayInfo> getJobsFromRepository(FilterSelector filter, String flowId, MdStore store, String repos, boolean displayOnly) throws MdException, RemoteException {
        TreeSet<DisplayInfo> joblist = new TreeSet<DisplayInfo>((Comparator<DisplayInfo>)new CompareDisplayInfoObjects());
        ArrayList<JFJob> jobs = new ArrayList<JFJob>();
        try {
            JFJob flow = null;
            String strSelect = "<XMLSELECT search=\"*[@Id='" + flowId + "']\" />" + TEMPLATE_JobsInFlow;
            MdFactory factory = store.getFactory();
            List list = factory.getOMIUtil().getMetadataObjectsSubset(store, repos, "JFJob", 8588, strSelect);
            if (list.size() > 0) {
                flow = (JFJob)list.get(0);
                TransformationActivity activity = (TransformationActivity)flow.getJobActivities().get(0);
                for (TransformationStep step : activity.getSteps()) {
                    if (step instanceof SyncStep) continue;
                    try {
                        JFJob jfjob = (JFJob)step.getTransformations().get(0);
                        String role = jfjob.getTransformRole();
                        if (role.compareTo(FLOW_ROLE_MARK_DELETE) == 0 || role.compareTo(JOB_ROLE_MARK_DELETE) == 0) continue;
                        step.setName(JobEvent.getName(jfjob));
                        jobs.add(jfjob);
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {}
                }
                int numRules = filter.getRuleCount();
                block63: for (int n = 0; n < numRules; ++n) {
                    FilterRule rule = filter.getRule(n);
                    String column = rule.getColumnName();
                    int columnID = JobColumnSelectorModel.getColumnKeyFromName((String)column);
                    switch (columnID) {
                        case 0: {
                            JFJob job;
                            int x;
                            block64: for (x = jobs.size() - 1; x >= 0; --x) {
                                job = (JFJob)jobs.get(x);
                                switch (rule.getCondition()) {
                                    case 0: {
                                        if (job.getName().compareTo(rule.getValue()) == 0) continue block64;
                                        jobs.remove(x);
                                        continue block64;
                                    }
                                    case 3: {
                                        if (job.getName().indexOf(rule.getValue()) >= 0) continue block64;
                                        jobs.remove(x);
                                        continue block64;
                                    }
                                    case 1: {
                                        if (job.getName().startsWith(rule.getValue())) continue block64;
                                        jobs.remove(x);
                                        continue block64;
                                    }
                                    case 2: {
                                        if (job.getName().endsWith(rule.getValue())) continue block64;
                                        jobs.remove(x);
                                    }
                                }
                            }
                            continue block63;
                        }
                        case 2: {
                            Date server;
                            JFJob job;
                            int x;
                            for (x = jobs.size() - 1; x >= 0; --x) {
                                job = (JFJob)jobs.get(x);
                                server = DeployedJob.getDateCreated(job);
                                if (MetaUtilities.matchTimeCriteria(server, rule)) continue;
                                jobs.remove(x);
                            }
                            continue block63;
                        }
                        case 3: {
                            Date server;
                            JFJob job;
                            int x;
                            for (x = jobs.size() - 1; x >= 0; --x) {
                                job = (JFJob)jobs.get(x);
                                server = DeployedJob.getDateModified(job);
                                if (MetaUtilities.matchTimeCriteria(server, rule)) continue;
                                jobs.remove(x);
                            }
                            continue block63;
                        }
                        case 8: {
                            JFJob job;
                            int x;
                            block67: for (x = jobs.size() - 1; x >= 0; --x) {
                                job = (JFJob)jobs.get(x);
                                switch (rule.getCondition()) {
                                    case 0: {
                                        if (job.getId().compareTo(rule.getValue()) == 0) continue block67;
                                        jobs.remove(x);
                                        continue block67;
                                    }
                                    case 3: {
                                        if (job.getId().indexOf(rule.getValue()) >= 0) continue block67;
                                        jobs.remove(x);
                                        continue block67;
                                    }
                                    case 1: {
                                        if (job.getId().startsWith(rule.getValue())) continue block67;
                                        jobs.remove(x);
                                        continue block67;
                                    }
                                    case 2: {
                                        if (job.getId().endsWith(rule.getValue())) continue block67;
                                        jobs.remove(x);
                                    }
                                }
                            }
                            continue block63;
                        }
                        case 7: {
                            int x;
                            for (x = jobs.size() - 1; x >= 0; --x) {
                            }
                            continue block63;
                        }
                        case 1: {
                            JFJob job;
                            int x;
                            block69: for (x = jobs.size() - 1; x >= 0; --x) {
                                job = (JFJob)jobs.get(x);
                                switch (rule.getCondition()) {
                                    case 0: {
                                        if (job.getId().compareTo(rule.getValue()) == 0) continue block69;
                                        jobs.remove(x);
                                        continue block69;
                                    }
                                    case 3: {
                                        if (job.getId().indexOf(rule.getValue()) >= 0) continue block69;
                                        jobs.remove(x);
                                        continue block69;
                                    }
                                    case 1: {
                                        if (job.getId().startsWith(rule.getValue())) continue block69;
                                        jobs.remove(x);
                                        continue block69;
                                    }
                                    case 2: {
                                        if (job.getId().endsWith(rule.getValue())) continue block69;
                                        jobs.remove(x);
                                    }
                                }
                            }
                            continue block63;
                        }
                        case 4: {
                            JFJob job;
                            int x;
                            for (x = jobs.size() - 1; x >= 0; --x) {
                                job = (JFJob)jobs.get(x);
                                try {
                                    String bserverName = DeployedJob.getBatchServer(job).getName();
                                    switch (rule.getCondition()) {
                                        case 0: {
                                            if (bserverName.compareTo(rule.getValue()) == 0) break;
                                            jobs.remove(x);
                                            break;
                                        }
                                        case 3: {
                                            if (bserverName.indexOf(rule.getValue()) >= 0) break;
                                            jobs.remove(x);
                                            break;
                                        }
                                        case 1: {
                                            if (bserverName.startsWith(rule.getValue())) break;
                                            jobs.remove(x);
                                            break;
                                        }
                                        case 2: {
                                            if (bserverName.endsWith(rule.getValue())) break;
                                            jobs.remove(x);
                                        }
                                    }
                                    continue;
                                }
                                catch (RuntimeException ex) {
                                    jobs.remove(x);
                                }
                            }
                            continue block63;
                        }
                        case 5: {
                            continue block63;
                        }
                        case 6: {
                            String username;
                            JFJob job;
                            int x;
                            for (x = jobs.size() - 1; x >= 0; --x) {
                                job = (JFJob)jobs.get(x);
                                try {
                                    username = DeployedJob.getRunAs((Root)job);
                                    switch (rule.getCondition()) {
                                        case 0: {
                                            if (username.compareTo(rule.getValue()) == 0) break;
                                            jobs.remove(x);
                                            break;
                                        }
                                        case 3: {
                                            if (username.indexOf(rule.getValue()) >= 0) break;
                                            jobs.remove(x);
                                            break;
                                        }
                                        case 1: {
                                            if (username.startsWith(rule.getValue())) break;
                                            jobs.remove(x);
                                            break;
                                        }
                                        case 2: {
                                            if (username.endsWith(rule.getValue())) break;
                                            jobs.remove(x);
                                        }
                                    }
                                    continue;
                                }
                                catch (RuntimeException ex) {
                                    jobs.remove(x);
                                }
                            }
                            continue block63;
                        }
                        case 9: {
                            String username;
                            JFJob job;
                            int x;
                            for (x = jobs.size() - 1; x >= 0; --x) {
                                job = (JFJob)jobs.get(x);
                                try {
                                    username = DeployedJob.getResponsiblePartyForDeployment(job);
                                    switch (rule.getCondition()) {
                                        case 0: {
                                            if (username.compareTo(rule.getValue()) == 0) break;
                                            jobs.remove(x);
                                            break;
                                        }
                                        case 3: {
                                            if (username.indexOf(rule.getValue()) >= 0) break;
                                            jobs.remove(x);
                                            break;
                                        }
                                        case 1: {
                                            if (username.startsWith(rule.getValue())) break;
                                            jobs.remove(x);
                                            break;
                                        }
                                        case 2: {
                                            if (username.endsWith(rule.getValue())) break;
                                            jobs.remove(x);
                                        }
                                    }
                                    continue;
                                }
                                catch (RuntimeException ex) {
                                    jobs.remove(x);
                                }
                            }
                            continue block63;
                        }
                    }
                }
            }
        }
        catch (MdException mde) {
            jobs = new ArrayList();
        }
        for (int x = 0; x < jobs.size(); ++x) {
            JobInfo info;
            block77: {
                JFJob job = (JFJob)jobs.get(x);
                if (job.getTransformRole().equalsIgnoreCase(FLOW_ROLE)) {
                    FlowInfo info2;
                    block76: {
                        DeployedFlow sflow = new DeployedFlow(job, (MdObjectStore)store);
                        info2 = null;
                        try {
                            info2 = sflow.getInfo();
                        }
                        catch (SchedulerException ex) {
                            info2 = new FlowInfo(job.getName(), null, null);
                            info2.setDescription(job.getDesc());
                            info2.setId(job.getFQID());
                            Tree folder = DeployedJob.getFolder(job);
                            if (folder == null) break block76;
                            info2.setLocation(MetaUtilities.getFolderLocation(folder));
                            info2.setLocationId(folder.getId());
                        }
                    }
                    joblist.add((DisplayInfo)info2);
                    continue;
                }
                if (!job.getTransformRole().equalsIgnoreCase(JOB_ROLE)) continue;
                info = null;
                try {
                    DeployedJob djob = new DeployedJob(job);
                    djob.checkJCLGeneration();
                    info = djob.getInfo();
                }
                catch (Exception ex) {
                    ServerComponent batchserver = CommandUtilities.getServerComponentForJob(job);
                    BatchServerInfo bsinfo = MetaUtilities.getBatchServer(batchserver);
                    info = new JobInfo(job.getName(), job.getId(), bsinfo);
                    info.setDisplayOnly(true);
                    info.setDescription(job.getDesc());
                    info.setId(job.getFQID());
                    Tree folder = DeployedJob.getFolder(job);
                    if (folder == null) break block77;
                    info.setLocation(MetaUtilities.getFolderLocation(folder));
                    info.setLocationId(folder.getId());
                }
            }
            joblist.add((DisplayInfo)info);
        }
        return joblist;
    }

    public static SortedSet<DisplayInfo> getNonAssociatedJobsFromRepository(MdStore store, String repos) throws MdException, RemoteException {
        TreeSet<DisplayInfo> joblist = new TreeSet<DisplayInfo>((Comparator<DisplayInfo>)new CompareDisplayInfoObjects());
        int flags = 532876;
        MdFactory factory = store.getFactory();
        String selectXML = "<XMLSELECT search=\"*\"/><Templates><Job><JFJobs/><Trees/></Job></Templates>";
        List jobList = factory.getOMIUtil().getMetadataObjectsSubset(store, repos, "Job", flags, selectXML);
        for (Job job : jobList) {
            if (job.getJFJobs().size() != 0) continue;
            DisplayInfo info = new DisplayInfo(job.getName(), job.getDesc(), null);
            info.setId(job.getId());
            joblist.add(info);
        }
        return joblist;
    }

    public static SortedSet<DisplayInfo> getJobObjectsFromRepository(MdStore store, String repos) throws MdException, RemoteException {
        TreeSet<DisplayInfo> joblist = new TreeSet<DisplayInfo>((Comparator<DisplayInfo>)new CompareDisplayInfoObjects());
        int flags = 532876;
        MdFactory factory = store.getFactory();
        String selectXML = "<XMLSELECT search=\"*\"/><Templates><Job><JFJobs/><Trees/></Job></Templates>";
        List jobList = factory.getOMIUtil().getMetadataObjectsSubset(store, repos, "Job", flags, selectXML);
        for (Job job : jobList) {
            DisplayInfo info = new DisplayInfo(job.getName(), job.getDesc(), null);
            info.setId(job.getId());
            joblist.add(info);
        }
        return joblist;
    }

    public static SortedSet<DisplayInfo> getJobsFromRepository(int category, String flowId, MdStore store, String repos, boolean displayOnly) throws MdException, RemoteException {
        TreeSet<DisplayInfo> joblist = new TreeSet<DisplayInfo>((Comparator<DisplayInfo>)new CompareDisplayInfoObjects());
        switch (category) {
            case 0: {
                joblist.addAll(MetaUtilities.getJobsFromRepository(flowId, store, repos, displayOnly));
                break;
            }
            case 1: {
                break;
            }
            case 4: {
                break;
            }
            case 2: {
                break;
            }
        }
        return joblist;
    }

    public static List<DisplayInfo> getJobsFromRepository(String flowId, MdStore store, String repos, boolean displayOnly) throws MdException, RemoteException {
        ArrayList<DisplayInfo> jobs = new ArrayList<DisplayInfo>();
        ArrayList<TransformationStep> deletelist = new ArrayList<TransformationStep>();
        JFJob flow = null;
        String strSelect = "<XMLSELECT search=\"*[@Id='" + flowId + "']\" />" + TEMPLATE_JobsInFlow;
        MdFactory factory = store.getFactory();
        List list = factory.getOMIUtil().getMetadataObjectsSubset(store, repos, "JFJob", 8588, strSelect);
        if (list.size() > 0) {
            flow = (JFJob)list.get(0);
        }
        if (flow == null) {
            return null;
        }
        TransformationActivity activity = (TransformationActivity)flow.getJobActivities().get(0);
        Iterator i = null;
        if (activity != null) {
            i = activity.getSteps().iterator();
        }
        while (i != null && i.hasNext()) {
            TransformationStep step = (TransformationStep)i.next();
            if (step instanceof SyncStep) {
                if (step.getSuccessorDependencies().size() != 0 || step.getPredecessorDependencies().size() != 0) continue;
                try {
                    Event event = (Event)step.getTriggeringEvents().get(0);
                    int numProperties = event.getProperties().size();
                    if (numProperties != 0) continue;
                    deletelist.add(step);
                }
                catch (RuntimeException e) {
                    deletelist.add(step);
                }
                continue;
            }
            JFJob jfjob = null;
            try {
                JobInfo info;
                block26: {
                    Tree folder;
                    GregorianCalendar mcal;
                    GregorianCalendar ccal;
                    Date d;
                    BatchServerInfo bsinfo;
                    ServerComponent batchserver;
                    DeployedJob djob;
                    jfjob = (JFJob)step.getTransformations().get(0);
                    String role = jfjob.getTransformRole();
                    if (role.compareTo(FLOW_ROLE_MARK_DELETE) == 0 || role.compareTo(JOB_ROLE_MARK_DELETE) == 0) {
                        deletelist.add(step);
                        continue;
                    }
                    step.setName(JobEvent.getName(jfjob));
                    if (step.getTransformRole().equalsIgnoreCase("JOB")) {
                        block24: {
                            info = null;
                            try {
                                djob = new DeployedJob(jfjob);
                                djob.checkJCLGeneration();
                                info = djob.getInfo();
                            }
                            catch (Exception ex) {
                                batchserver = CommandUtilities.getServerComponentForJob(jfjob);
                                bsinfo = MetaUtilities.getBatchServer(batchserver);
                                bsinfo.setId(batchserver.getId());
                                info = new JobInfo(jfjob.getName(), jfjob.getId(), bsinfo);
                                info.setDisplayOnly(true);
                                info.setDescription(jfjob.getDesc());
                                info.setId(jfjob.getFQID());
                                d = DeployedJob.getDateCreated(jfjob);
                                if (d != null) {
                                    ccal = new GregorianCalendar();
                                    ccal.setTime(d);
                                    info.setCreationDateDataBinding((Calendar)ccal);
                                }
                                if ((d = DeployedJob.getDateModified(jfjob)) != null) {
                                    mcal = new GregorianCalendar();
                                    mcal.setTime(d);
                                    info.setModifiedDateDataBinding((Calendar)mcal);
                                }
                                if ((folder = DeployedJob.getFolder(jfjob)) == null) break block24;
                                info.setLocation(MetaUtilities.getFolderLocation(folder));
                                info.setLocationId(folder.getId());
                            }
                        }
                        jobs.add((DisplayInfo)info);
                        continue;
                    }
                    if (step.getTransformRole().equalsIgnoreCase("FLOW")) {
                        FlowInfo info2;
                        block25: {
                            DeployedFlow sflow = new DeployedFlow(jfjob, (MdObjectStore)store);
                            info2 = null;
                            try {
                                info2 = sflow.getInfo();
                            }
                            catch (SchedulerException ex) {
                                info2 = new FlowInfo(jfjob.getName(), null, null);
                                info2.setDescription(jfjob.getDesc());
                                info2.setId(jfjob.getFQID());
                                Tree folder2 = DeployedJob.getFolder(jfjob);
                                if (folder2 == null) break block25;
                                info2.setLocation(MetaUtilities.getFolderLocation(folder2));
                                info2.setLocationId(folder2.getId());
                            }
                        }
                        jobs.add((DisplayInfo)info2);
                        continue;
                    }
                    info = null;
                    try {
                        djob = new DeployedJob(jfjob);
                        djob.checkJCLGeneration();
                        info = djob.getInfo();
                    }
                    catch (Exception ex) {
                        batchserver = CommandUtilities.getServerComponentForJob(jfjob);
                        bsinfo = MetaUtilities.getBatchServer(batchserver);
                        bsinfo.setId(batchserver.getId());
                        info = new JobInfo(jfjob.getName(), jfjob.getId(), bsinfo);
                        info.setDescription(jfjob.getDesc());
                        info.setId(jfjob.getFQID());
                        info.setDisplayOnly(true);
                        d = DeployedJob.getDateCreated(jfjob);
                        if (d != null) {
                            ccal = new GregorianCalendar();
                            ccal.setTime(d);
                            info.setCreationDateDataBinding((Calendar)ccal);
                        }
                        if ((d = DeployedJob.getDateModified(jfjob)) != null) {
                            mcal = new GregorianCalendar();
                            mcal.setTime(d);
                            info.setModifiedDateDataBinding((Calendar)mcal);
                        }
                        if ((folder = DeployedJob.getFolder(jfjob)) == null) break block26;
                        info.setLocation(MetaUtilities.getFolderLocation(folder));
                        info.setLocationId(folder.getId());
                    }
                }
                jobs.add((DisplayInfo)info);
            }
            catch (InvalidParameterException ex) {
            }
            catch (ArrayIndexOutOfBoundsException ex) {}
        }
        if (deletelist.size() > 0) {
            store.getFactory().deleteMetadataObjects(deletelist);
        }
        return jobs;
    }

    public static List<DeployedFlow> getFlowsInRepository(MdObjectStore store, String repos) throws MdException, RemoteException {
        ArrayList<DeployedFlow> flowlist = new ArrayList<DeployedFlow>();
        String selectXML = "<XMLSELECT search=\"*[@TransformRole='SCHEDULER_FLOW']\"/><Templates><JFJob><JobActivities/><ComputeLocations/><Properties/><Trees/><Steps/></JFJob><TransformationActivity><Steps/></TransformationActivity></Templates>";
        int flags = 532876;
        MdFactory factory = store.getFactory();
        List jfjobList = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, repos, "JFJob", flags, selectXML);
        int listsize = jfjobList.size();
        for (int i = 0; i < listsize; ++i) {
            JFJob flow = (JFJob)jfjobList.get(i);
            try {
                flowlist.add(new DeployedFlow(flow, store));
                continue;
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return flowlist;
    }

    public static SortedSet<DeployedFlow> getFlowsInRepository(int category, MdObjectStore store, String repos) throws MdException, RemoteException {
        TreeSet<java.lang.Object> flowlist = new TreeSet<java.lang.Object>(new CompareDeployedFlowObjects());
        switch (category) {
            case 0: {
                flowlist.addAll(MetaUtilities.getFlowsInRepository(store, repos));
                break;
            }
            case 1: {
                break;
            }
            case 4: {
                break;
            }
            case 2: {
                break;
            }
        }
        return flowlist;
    }

    public static Event getEvent(String id, MdStore store, String repos) throws MdException, RemoteException {
        Event event = null;
        String strSelect = "<XMLSELECT search=\"*[@Id='" + id + "']\" />";
        MdFactory factory = store.getFactory();
        List list = factory.getOMIUtil().getMetadataObjectsSubset(store, repos, "Event", 8584, strSelect);
        if (list.size() > 0) {
            event = (Event)list.get(0);
        }
        return event;
    }

    public static Event getTriggerEvent(TriggerEventInfo info, MdObjectStore store, String repos) throws MdException, RemoteException, SchedulerException {
        Scheduler scheduler = MetaUtilities.getSchedulingServer(info.getScheduler(), store);
        return MetaUtilities.getTriggerEvent(info, scheduler, store, repos);
    }

    public static SyncStep getTrigger(TriggerEventInfo info, Scheduler scheduler, MdObjectStore store, String repos) throws MdException, RemoteException, SchedulerException {
        SyncStep step = null;
        if (info.getEvent() instanceof GroupingEventInfo) {
            GroupingEventInfo gei = (GroupingEventInfo)info.getEvent();
            MdFactory factory = store.getFactory();
            if (info.getId() != null) {
                String strSelect = "<XMLSELECT search=\"*[@Id='" + info.getId() + "']\" />";
                List list = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, repos, "SyncStep", 8584, strSelect);
                step = list.size() > 0 ? (SyncStep)list.get(0) : (SyncStep)store.getObject(info.getId());
            }
        } else {
            Event event = MetaUtilities.getTriggerEvent(info, scheduler, store, repos);
            AssociationList steps = event.getTriggeringTransforms();
            if (steps.size() > 0) {
                step = (SyncStep)event.getTriggeringTransforms().get(0);
            }
        }
        return step;
    }

    public static SyncStep createTriggerStep(int condition, MdObjectStore store, String repos) throws RemoteException {
        MdFactory factory = store.getFactory();
        SyncStep step = (SyncStep)factory.createComplexMetadataObject(store, null, m_bundle.getString("MetaUtilities.TriggerSyncStepName.txt"), "SyncStep", repos, null);
        switch (condition) {
            case 31: {
                step.setTransformRole("AND");
                break;
            }
            default: {
                step.setTransformRole("OR");
            }
        }
        return step;
    }

    public static Event getTriggerEvent(TriggerEventInfo info, Scheduler scheduler, MdObjectStore store, String repos) throws MdException, RemoteException, SchedulerException {
        Event event = null;
        MdFactory factory = store.getFactory();
        if (info.getId() != null) {
            String strSelect = "<XMLSELECT search=\"*[@Id='" + info.getId() + "']\" />";
            List list = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, repos, "Event", 8584, strSelect);
            if (list.size() > 0) {
                event = (Event)list.get(0);
            }
        }
        if (event == null) {
            String reposId = repos.length() > 8 ? repos.substring(9) : repos;
            event = MetaUtilities.createTriggerEventObject((DisplayInfo)info.getEvent(), scheduler, store, reposId);
            info.setId(event.getId());
        }
        return event;
    }

    public static Event getTriggerEvent(DisplayInfo info, Scheduler scheduler, MdObjectStore store, String repos) throws MdException, RemoteException, SchedulerException {
        Event event = null;
        MdFactory factory = store.getFactory();
        if (info.getId() != null) {
            String strSelect = "<XMLSELECT search=\"*[@Id='" + info.getId() + "']\" />";
            List list = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, repos, "Event", 8584, strSelect);
            if (list.size() > 0) {
                event = (Event)list.get(0);
            }
        }
        if (event == null) {
            String reposId = repos.length() > 8 ? repos.substring(9) : repos;
            event = MetaUtilities.createTriggerEventObject(info, scheduler, store, reposId);
            info.setId(event.getId());
        }
        return event;
    }

    public static Event createTriggerEventObject(DisplayInfo info, Scheduler scheduler, MdObjectStore store, String repos) throws RemoteException, MdException, SchedulerException {
        if (info instanceof GroupingEventInfo) {
            return null;
        }
        MdFactory factory = store.getFactory();
        String strRole = "TriggerEvent";
        String strCondition = "";
        String strDefinition = "";
        String strDescription = "";
        String strCalDef = null;
        Event event = (Event)factory.createComplexMetadataObject(store, null, strRole, "Event", repos, null);
        if (info instanceof TimeEventInfo) {
            strRole = "TimeEvent";
            TimeEventInfo tei = (TimeEventInfo)info;
            strCondition = scheduler.createConditionString(scheduler.getCalendar(tei.getRecurrence()).getName(), tei.getUser(), tei.getHours(), tei.getMinutes(), String.valueOf(tei.getDuration()));
            TimeEvent te = new TimeEvent(tei, scheduler);
            strDefinition = te.generateDefinition();
            strDescription = te.getDescription();
            MetaUtilities.setStringProperty((Root)event, "Definition", factory, store, strDefinition);
            IRecurrenceInfo ir = tei.getRecurrence();
            if (ir instanceof OpaqueRecurrence) {
                String expression;
                strCalDef = ((OpaqueRecurrence)ir).getData();
                if (strCalDef != null && strCalDef.length() > 0) {
                    MetaUtilities.setStringProperty((Root)event, "CalendarDefinition", factory, store, strCalDef);
                    strDefinition = strCalDef;
                }
                if ((expression = ((OpaqueRecurrence)ir).getExpression()) != null && expression.length() > 0) {
                    MetaUtilities.setStringProperty((Root)event, "CalendarExpression", factory, store, expression);
                    Property prop = MetaUtilities.getPropertyObject((Root)event, "CalendarExpression");
                    prop.setDesc(strCalDef);
                }
            }
        } else if (info instanceof FileEventInfo) {
            strRole = "FileEvent";
            FileEventInfo fei = (FileEventInfo)info;
            strCondition = scheduler.createFileConditionString(fei.getFileName(), fei.getEventType(), fei.getOperator(), fei.getValue());
            FileEvent fe = new FileEvent(fei);
            strDefinition = fe.generateDefinition();
            strDescription = fei.getDescription();
            MetaUtilities.setStringProperty((Root)event, "Definition", factory, store, strDefinition);
        }
        event.setName(strRole);
        event.setEventRole(strRole);
        event.setCondition(strCondition);
        event.setDesc(strDescription);
        return event;
    }

    public static JFJob getJFJobByNameLocationRole(String name, String location, String role, String template, MdStore store, String repos) throws MdException, RemoteException {
        MdFactory factory = store.getFactory();
        int flags = 8588;
        String temp = template;
        if (template == null) {
            flags = 8584;
            temp = "";
        }
        String selectXML = "<XMLSELECT search=\"*[@Name='" + name + "']\"/>" + temp;
        List list = factory.getOMIUtil().getMetadataObjectsSubset(store, repos, "JFJob", flags, selectXML);
        for (JFJob job : list) {
            String jrole = job.getTransformRole();
            if (jrole.compareTo(role) != 0) continue;
            if (location == null) {
                return job;
            }
            String jloc = DeployedJob.getFolder(job).getName();
            if (jloc == null || jloc.compareTo(location) != 0) continue;
            return job;
        }
        return null;
    }

    public static TransformationStep getStep(String stepid, MdStore store) throws RemoteException, MdException, SchedulerException {
        TransformationStep step = null;
        String repos = "A0000001." + stepid.substring(0, 8);
        int flags = 8600;
        String strSelect = "<XMLSELECT search=\"*[@Id='" + stepid + "']\" />";
        MdFactory factory = store.getFactory();
        List list = factory.getOMIUtil().getMetadataObjectsSubset(store, repos, "TransformationStep", flags, strSelect);
        if (list.size() > 0) {
            step = (TransformationStep)list.get(0);
            return step;
        }
        return null;
    }

    public static JFJob getJFJob(String id, String template, MdStore store, String repos) throws MdException, RemoteException, SchedulerException {
        JFJob job = null;
        int flags = 8588;
        String temp = template;
        if (template == null) {
            flags = 8584;
            temp = "";
        }
        String strSelect = "<XMLSELECT search=\"*[@Id='" + id + "']\" />" + temp;
        MdFactory factory = store.getFactory();
        List list = factory.getOMIUtil().getMetadataObjectsSubset(store, repos, "JFJob", flags, strSelect);
        for (JFJob jfjob : list) {
            String role = jfjob.getTransformRole();
            if (role.compareTo(FLOW_ROLE_MARK_DELETE) == 0) {
                DeployedFlow.delete(jfjob, factory);
                continue;
            }
            if (role.compareTo(JOB_ROLE_MARK_DELETE) == 0) {
                DeployedJob.delete(jfjob, factory);
                continue;
            }
            job = jfjob;
            break;
        }
        if (job != null) {
            return job;
        }
        SchedulerException se = new SchedulerException(MetaUtilities.messageString(m_bundle.getString("MetaUtilities.InvalidJFJobID.fmt"), id));
        throw se;
    }

    public static JobInfo getJobInfo(JFJob jfjob) throws MdException, RemoteException, SchedulerException {
        Job job = jfjob.getAssociatedJob();
        String flowname = null;
        ServerComponent batchserver = CommandUtilities.getServerComponentForJob(jfjob);
        File source = DeployedJob.getSourceCode(jfjob);
        File jcl = DeployedJob.getJCL(jfjob);
        return DeployedJob.getInfo(jfjob, job, flowname, batchserver, source, jcl);
    }

    public static JobInfo getJobInfo(String id, MdStore store, String repos) throws MdException, RemoteException, SchedulerException {
        JFJob jfjob = MetaUtilities.getJFJob(id, store, repos);
        return MetaUtilities.getJobInfo(jfjob);
    }

    public static JFJob getJFJob(String id) throws MdException, RemoteException, SchedulerException {
        return MetaUtilities.getJFJob(id, null, (MdStore)MetaUtilities.getDefaultStore(), "A0000001." + id.substring(0, 8));
    }

    public static JFJob getJFJob(String id, MdObjectStore store) throws MdException, RemoteException, SchedulerException {
        return MetaUtilities.getJFJob(id, null, (MdStore)store, "A0000001." + id.substring(0, 8));
    }

    public static JFJob getJFJob(String id, MdStore store, String repos) throws MdException, RemoteException, SchedulerException {
        return MetaUtilities.getJFJob(id, null, store, repos);
    }

    public static JFJob getJFJob(String id, MdStore store, String repos, String template) throws MdException, RemoteException, SchedulerException {
        return MetaUtilities.getJFJob(id, template, store, repos);
    }

    public static Job getSASJob(String id, MdStore store, String repos) throws MdException, RemoteException {
        Job job = null;
        String strSelect = "<XMLSELECT search=\"*[@Id='" + id + "']\" />";
        MdFactory factory = store.getFactory();
        List list = factory.getOMIUtil().getMetadataObjectsSubset(store, repos, "Job", 8584, strSelect);
        for (Job sasjob : list) {
            String role = sasjob.getTransformRole();
            if (role.compareTo(JOB_ROLE_MARK_DELETE) == 0) continue;
            job = sasjob;
            break;
        }
        return job;
    }

    public static boolean doesFlowExist(String id, MdStore store) throws MdException, RemoteException {
        ArrayList<JFJob> returnList = new ArrayList<JFJob>();
        MdFactory factory = store.getFactory();
        String selectXML = "<XMLSELECT search=\"*[@Id='" + id + "'][JobActivities/*TransformationActivity]\"/>";
        String repos = id.substring(0, 8);
        List list = factory.getOMIUtil().getMetadataObjectsSubset(store, repos, "JFJob", 8584, selectXML);
        for (JFJob obj : list) {
            String role = obj.getTransformRole();
            if (role.compareTo("") == 0) {
                role = obj.getJobActivities().size() > 0 ? FLOW_ROLE : JOB_ROLE;
                obj.setTransformRole(role);
            }
            if (!FLOW_ROLE.equalsIgnoreCase(role)) continue;
            returnList.add(obj);
        }
        return returnList.size() > 0;
    }

    public static boolean doesFlowExist(String name, MdStore store, String repos) throws MdException, RemoteException {
        ArrayList<JFJob> returnList = new ArrayList<JFJob>();
        MdFactory factory = store.getFactory();
        String selectXML = "<XMLSELECT search=\"*[@Name='" + name + "'][JobActivities/*TransformationActivity]\"/>";
        List list = factory.getOMIUtil().getMetadataObjectsSubset(store, repos, "JFJob", 8584, selectXML);
        for (JFJob obj : list) {
            String role = obj.getTransformRole();
            if (role.compareTo("") == 0) {
                role = obj.getJobActivities().size() > 0 ? FLOW_ROLE : JOB_ROLE;
                obj.setTransformRole(role);
            }
            if (!FLOW_ROLE.equalsIgnoreCase(role)) continue;
            returnList.add(obj);
        }
        return returnList.size() > 0;
    }

    public static boolean doesFlowExist(String name, Tree folder, MdStore store, String repos) throws MdException, RemoteException {
        ArrayList<JFJob> returnList = new ArrayList<JFJob>();
        MdFactory factory = store.getFactory();
        String selectXML = "<XMLSELECT search=\"*[@Name='" + name + "']\" />";
        List list = factory.getOMIUtil().getMetadataObjectsSubset(store, repos, "JFJob", 8584, selectXML);
        Iterator i = list.iterator();
        String path = MetaUtilities.getFolderLocation(folder);
        while (i.hasNext()) {
            JFJob obj = (JFJob)i.next();
            String role = obj.getTransformRole();
            if (role.compareTo("") == 0) {
                role = obj.getJobActivities().size() > 0 ? FLOW_ROLE : JOB_ROLE;
                obj.setTransformRole(role);
            }
            if (!FLOW_ROLE.equalsIgnoreCase(role)) continue;
            for (java.lang.Object o : obj.getTrees()) {
                Tree tree;
                String temp;
                if (!(o instanceof Tree) || (temp = MetaUtilities.getFolderLocation(tree = (Tree)o)).compareTo(path) != 0) continue;
                returnList.add(obj);
            }
        }
        return returnList.size() > 0;
    }

    public static boolean doesJobExist(String id, MdStore store) throws MdException, RemoteException {
        ArrayList<JFJob> returnList = new ArrayList<JFJob>();
        MdFactory factory = store.getFactory();
        String selectXML = "<XMLSELECT search=\"*[@Id='" + id + "']\" />";
        String repos = id.substring(0, 8);
        List list = factory.getOMIUtil().getMetadataObjectsSubset(store, repos, "JFJob", 8584, selectXML);
        for (JFJob obj : list) {
            String role = obj.getTransformRole();
            if (!JOB_ROLE.equalsIgnoreCase(role)) continue;
            returnList.add(obj);
        }
        return returnList.size() > 0;
    }

    public static boolean doesJobExist(String name, MdStore store, String repos) throws MdException, RemoteException {
        ArrayList<JFJob> returnList = new ArrayList<JFJob>();
        MdFactory factory = store.getFactory();
        String selectXML = "<XMLSELECT search=\"*[@Name='" + name + "']\" />";
        List list = factory.getOMIUtil().getMetadataObjectsSubset(store, repos, "JFJob", 8584, selectXML);
        for (JFJob obj : list) {
            String role = obj.getTransformRole();
            if (!JOB_ROLE.equalsIgnoreCase(role)) continue;
            returnList.add(obj);
        }
        return returnList.size() > 0;
    }

    public static boolean doesJobExist(String name, Tree folder, MdStore store, String repos) throws MdException, RemoteException {
        ArrayList<JFJob> returnList = new ArrayList<JFJob>();
        MdFactory factory = store.getFactory();
        String selectXML = "<XMLSELECT search=\"*[@Name='" + name + "']\" />";
        List list = factory.getOMIUtil().getMetadataObjectsSubset(store, repos, "JFJob", 8584, selectXML);
        Iterator i = list.iterator();
        String path = MetaUtilities.getFolderLocation(folder);
        while (i.hasNext()) {
            JFJob obj = (JFJob)i.next();
            String role = obj.getTransformRole();
            if (role.compareTo("") == 0) {
                role = obj.getJobActivities().size() > 0 ? FLOW_ROLE : JOB_ROLE;
                obj.setTransformRole(role);
            }
            if (!JOB_ROLE.equalsIgnoreCase(role)) continue;
            for (java.lang.Object o : obj.getTrees()) {
                Tree tree;
                String temp;
                if (!(o instanceof Tree) || (temp = MetaUtilities.getFolderLocation(tree = (Tree)o)).compareTo(path) != 0) continue;
                returnList.add(obj);
            }
        }
        return returnList.size() > 0;
    }

    public static List<JFJob> getJFJobList(String name, boolean flow, MdStore store, String repos) throws MdException, RemoteException {
        ArrayList<JFJob> returnList = new ArrayList<JFJob>();
        MdFactory factory = store.getFactory();
        String selectXML = null;
        selectXML = flow ? "<XMLSELECT search=\"*[@Name='" + name + "'][JobActivities/*TransformationActivity]\"/><Templates><JFJob><JobActivities/><Trees/></JFJob></Templates>" : "<XMLSELECT search=\"*[@Name='" + name + "']\" /><Templates><JFJob><JobActivities/><Trees/></JFJob></Templates>";
        List list = factory.getOMIUtil().getMetadataObjectsSubset(store, repos, "JFJob", 8588, selectXML);
        Iterator i = list.iterator();
        if (flow) {
            while (i.hasNext()) {
                JFJob obj = (JFJob)i.next();
                String role = obj.getTransformRole();
                if (role.compareTo("") == 0) {
                    role = obj.getJobActivities().size() > 0 ? FLOW_ROLE : JOB_ROLE;
                    obj.setTransformRole(role);
                }
                if (!FLOW_ROLE.equalsIgnoreCase(role)) continue;
                returnList.add(obj);
            }
        } else {
            while (i.hasNext()) {
                JFJob obj = (JFJob)i.next();
                String role = obj.getTransformRole();
                if (!JOB_ROLE.equalsIgnoreCase(role) && (obj.getJobActivities().size() != 0 || !JOB_ROLE_MARK_DELETE.equalsIgnoreCase(role))) continue;
                returnList.add(obj);
            }
        }
        return returnList;
    }

    public static void DestroyJFJobsMarkedForDeletion(MdObjectStore store, String repos) throws SchedulerException, MdException, RemoteException {
        SchedulerException neo;
        JFJob obj;
        int i;
        SchedulerException se = null;
        MdFactory factory = store.getFactory();
        String selectXML = "<XMLSELECT search=\"*[@TransformRole='SCHEDULER_FLOW_DELETE']\" />";
        List list = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, repos, "JFJob", 8584, selectXML);
        java.lang.Object[] alist = list.toArray();
        for (i = 0; i < alist.length; ++i) {
            obj = (JFJob)alist[i];
            try {
                DeployedFlow.delete(obj, factory);
                continue;
            }
            catch (MdException mde) {
                if (se == null) {
                    se = new SchedulerException(obj.getName());
                    se.initCause((Throwable)mde);
                    continue;
                }
                neo = new SchedulerException(obj.getName());
                neo.initCause((Throwable)se);
                se = neo;
            }
        }
        selectXML = "<XMLSELECT search=\"*[@TransformRole='SCHEDULER_JOB_DELETE']\" />";
        list = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, repos, "JFJob", 8584, selectXML);
        alist = list.toArray();
        for (i = 0; i < alist.length; ++i) {
            obj = (JFJob)alist[i];
            try {
                DeployedJob.delete(obj, factory);
                continue;
            }
            catch (MdException mde) {
                if (se == null) {
                    se = new SchedulerException(obj.getName());
                    se.initCause((Throwable)mde);
                    continue;
                }
                neo = new SchedulerException(obj.getName());
                neo.initCause((Throwable)se);
                se = neo;
            }
        }
        if (se != null) {
            throw se;
        }
    }

    public static void DestroyJFJobsMarkedForDeletion(ServerComponent scomponent, String username, String password, MdObjectStore store, String repos) throws MdException, RemoteException, SchedulerException {
        if (scomponent != null) {
            Scheduler scheduler = MetaUtilities.getSchedulingServer(scomponent);
            SchedulerServerInfo info = scheduler.getServerComponent();
            MetaUtilities.DestroyJFJobsMarkedForDeletion(info, username, password, store, repos);
        } else {
            MetaUtilities.DestroyJFJobsMarkedForDeletion((SchedulerServerInfo)null, username, password, store, repos);
        }
    }

    public static void DestroyJFJobsMarkedForDeletion(SchedulerServerInfo info, String username, String password, MdObjectStore store, String repos) throws MdException, RemoteException, SchedulerException {
        SchedulerException neo;
        SchedulerException se = null;
        MdFactory factory = store.getFactory();
        String selectXML = "<XMLSELECT search=\"*[@TransformRole='SCHEDULER_FLOW_DELETE']\" /><Templates><JFJob><ComputeLocations/></JFJob></Templates>";
        List list = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, repos, "JFJob", 8588, selectXML);
        for (JFJob obj : list) {
            try {
                if (DeployedFlow.isFlowSubmitted(obj)) {
                    try {
                        ServerComponent sc = (ServerComponent)obj.getComputeLocations().get(0);
                        if (info != null && sc.getId().compareTo(info.getId()) != 0) continue;
                        Scheduler scheduler = MetaUtilities.getSchedulingServer(info, store);
                        scheduler.makeConnection(username, password != null ? new SealedString(password) : null);
                        DeployedFlow.delete(obj, factory, scheduler);
                        scheduler.closeConnection();
                    }
                    catch (ArrayIndexOutOfBoundsException aioobe) {
                        DeployedFlow.delete(obj, factory);
                    }
                    continue;
                }
                DeployedFlow.delete(obj, factory);
            }
            catch (NullPointerException ex) {
                try {
                    DeployedFlow.delete(obj, factory);
                }
                catch (MdException mde) {
                    if (se == null) {
                        se = new SchedulerException(obj.getName());
                        se.initCause((Throwable)mde);
                        continue;
                    }
                    SchedulerException neo2 = new SchedulerException(obj.getName());
                    neo2.initCause((Throwable)se);
                    se = neo2;
                }
            }
            catch (MdException mde) {
                if (se == null) {
                    se = new SchedulerException(obj.getName());
                    se.initCause((Throwable)mde);
                    continue;
                }
                neo = new SchedulerException();
                neo.initCause((Throwable)se);
                se = neo;
            }
        }
        selectXML = "<XMLSELECT search=\"*[@TransformRole='SCHEDULER_JOB_DELETE']\" />";
        list = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, repos, "JFJob", 8584, selectXML);
        for (JFJob obj : list) {
            try {
                DeployedJob.delete(obj, factory);
            }
            catch (MdException mde) {
                if (se == null) {
                    se = new SchedulerException(obj.getName());
                    se.initCause((Throwable)mde);
                    continue;
                }
                neo = new SchedulerException(obj.getName());
                neo.initCause((Throwable)se);
                se = neo;
            }
        }
        if (se != null) {
            throw se;
        }
    }

    public static List<?> getJobNAssociates(String jobId, MdStore store, String repos) throws MdException, RemoteException {
        MdFactory factory = store.getFactory();
        String selectXML = "<XMLSELECT search=\"*[@Id='" + jobId + "']\" /><Templates><JFJob><Steps/></JFJob><TransformationStep><PredecessorDependencies/><Activities/></TransformationStep><SyncStep><PredecessorDependencies/><SuccessorDependencies/><TriggeringEvents/><Transformations/></SyncStep><TransformationActivity><Jobs/></TransformationActivity><StepPrecedence><Properties/><Successors/></StepPrecedence></Templates>";
        int flags = 532876;
        return factory.getOMIUtil().getMetadataObjectsSubset(store, repos, "JFJob", flags, selectXML);
    }

    public static Job getAssociatedJob(String jobId, MdStore store, String repos) throws MdException, RemoteException {
        MdFactory factory = store.getFactory();
        String selectXML = "<XMLSELECT search=\"*[@Id='" + jobId + "']\" />";
        int flags = 268444032;
        List list = factory.getOMIUtil().getMetadataObjectsSubset(store, repos, "Job", flags, selectXML);
        if (list.size() > 0) {
            return (Job)list.get(0);
        }
        return null;
    }

    public static Transformation getTransformation(String id, MdStore store, String repos) throws MdException, RemoteException {
        MdFactory factory = store.getFactory();
        String selectXML = "<XMLSELECT search=\"*[@Id='" + id + "']\" />";
        int flags = 268444032;
        List list = factory.getOMIUtil().getMetadataObjectsSubset(store, repos, "Transformation", flags, selectXML);
        if (list.size() > 0) {
            return (Transformation)list.get(0);
        }
        return null;
    }

    public static List<FlowInfo> getSubmittedFlowInfos(MdObjectStore store, String repos) throws MdException, RemoteException, SchedulerException {
        return MetaUtilities.getSubmittedFlowInfos(null, store, repos);
    }

    public static List<FlowInfo> getSubmittedFlowInfos(List<FlowInfo> notscheduled, MdObjectStore store, String repos) throws MdException, RemoteException, SchedulerException {
        ArrayList<FlowInfo> flows = new ArrayList<FlowInfo>();
        ArrayList<DeployedFlow> dflows = new ArrayList<DeployedFlow>();
        String selectXML = "<XMLSELECT search=\"*[@TransformRole='SCHEDULER_FLOW']\"/><Templates><JFJob><JobActivities/><ComputeLocations/><TargetSpecifications/><Properties/><Trees/><Steps/><AssociatedJob/><SourceCode/><SourceSpecifications/></JFJob><TransformationActivity><Steps/></TransformationActivity><SyncStep><SuccessorDependencies/><PredecessorDependencies/><TriggeredEvents/><TriggeringEvents/></SyncStep><Event><Properties/></Event><TransformationStep><Properties/><SuccessorDependencies/><PredecessorDependencies/><Transformations/></TransformationStep></Templates>";
        int flags = 532876;
        MdFactory factory = store.getFactory();
        List jfjobList = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, repos, "JFJob", flags, selectXML);
        int listsize = jfjobList.size();
        for (int i = 0; i < listsize; ++i) {
            JFJob jFJob = (JFJob)jfjobList.get(i);
            try {
                dflows.add(new DeployedFlow(jFJob, store));
                continue;
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        for (DeployedFlow deployedFlow : dflows) {
            if (deployedFlow.isFlowSubmitted()) {
                flows.add(deployedFlow.getInfo());
                continue;
            }
            if (notscheduled == null) continue;
            notscheduled.add(deployedFlow.getInfo());
        }
        return flows;
    }

    public static List<DeployedFlow> getSubmittedFlows(MdObjectStore store, String repos) throws MdException, RemoteException {
        ArrayList<DeployedFlow> flows = new ArrayList<DeployedFlow>();
        List<DeployedFlow> jfjobs = MetaUtilities.getFlowsInRepository(store, repos);
        for (DeployedFlow flow : jfjobs) {
            if (!flow.isFlowSubmitted()) continue;
            flows.add(flow);
        }
        return flows;
    }

    public static List<DeployedFlow> getSubmittedFlows(List<DeployedFlow> notscheduled, MdObjectStore store, String repos) throws MdException, RemoteException {
        ArrayList<DeployedFlow> flows = new ArrayList<DeployedFlow>();
        List<DeployedFlow> jfjobs = MetaUtilities.getFlowsInRepository(store, repos);
        for (DeployedFlow flow : jfjobs) {
            if (flow.isFlowSubmitted()) {
                flows.add(flow);
                continue;
            }
            if (notscheduled == null) continue;
            notscheduled.add(flow);
        }
        return flows;
    }

    public static List<java.lang.Object> getDeployedJobObjects(MdObjectStore store, String repos) throws MdException, RemoteException {
        return MetaUtilities.__getDeployedJobs(0, store, repos, false);
    }

    public static List<java.lang.Object> getDeployedJobs(MdObjectStore store, String repos, boolean displayOnly) throws MdException, RemoteException {
        return MetaUtilities.__getDeployedJobs(2, store, repos, displayOnly);
    }

    public static List<JobInfo> getDeployedJobs(List listofJobInfoObjects) throws MdException, RemoteException {
        ArrayList<JobInfo> returnList = new ArrayList<JobInfo>();
        int listsize = listofJobInfoObjects.size();
        for (int i = 0; i < listsize; ++i) {
            JobInfo job = (JobInfo)listofJobInfoObjects.get(i);
            if (job.isSubflow()) continue;
            returnList.add(job);
        }
        return returnList;
    }

    public static List<java.lang.Object> getDeployedJobs(MdObjectStore store, String repos) throws MdException, RemoteException {
        return MetaUtilities.__getDeployedJobs(1, store, repos, false);
    }

    private static List<java.lang.Object> __getDeployedJobs(int returnType, MdObjectStore store, String repos, boolean displayOnly) throws MdException, RemoteException {
        MdFactory factory = store.getFactory();
        String selectXML = displayOnly ? TEMPLATE_BasicJobsInRepository : TEMPLATE_JobsInRepository;
        List list = null;
        try {
            list = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, repos, "JFJob", 8588, selectXML);
        }
        catch (OutOfMemoryError error) {
            selectXML = "";
            list = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, repos, "JFJob", 8584, selectXML);
        }
        return MetaUtilities.__getDeployedJobs(returnType, list, displayOnly);
    }

    private static List<java.lang.Object> __getDeployedJobs(int returnType, List<?> list, boolean displayOnly) throws MdException, RemoteException {
        ArrayList<java.lang.Object> returnList = new ArrayList<java.lang.Object>();
        int listsize = list.size();
        block9: for (int i = 0; i < listsize; ++i) {
            JFJob jfjob = (JFJob)list.get(i);
            String role = jfjob.getTransformRole();
            if (!JOB_ROLE.equalsIgnoreCase(role)) continue;
            switch (returnType) {
                case 0: {
                    returnList.add(jfjob);
                    continue block9;
                }
                case 2: {
                    try {
                        Tree folder;
                        ServerComponent batchserver = CommandUtilities.getServerComponentForJob(jfjob);
                        BatchServerInfo bsinfo = null;
                        bsinfo = batchserver != null ? MetaUtilities.getBatchServer(batchserver) : new BatchServerInfo(null, -2, 0);
                        JobInfo info = new JobInfo(jfjob.getName(), jfjob.getId(), bsinfo);
                        info.setDisplayOnly(true);
                        Date d = DeployedJob.getDateCreated(jfjob);
                        if (d != null) {
                            GregorianCalendar ccal = new GregorianCalendar();
                            ccal.setTime(d);
                            info.setCreationDateDataBinding((Calendar)ccal);
                        }
                        if ((d = DeployedJob.getDateModified(jfjob)) != null) {
                            GregorianCalendar mcal = new GregorianCalendar();
                            mcal.setTime(d);
                            info.setModifiedDateDataBinding((Calendar)mcal);
                        }
                        if ((folder = DeployedJob.getFolder(jfjob)) != null) {
                            info.setLocation(MetaUtilities.getFolderLocation(folder));
                            info.setLocationId(folder.getId());
                        }
                        info.setResponsiblePartyDataBinding(DeployedJob.getResponsiblePartyForDeployment(jfjob));
                        returnList.add(info);
                    }
                    catch (InvalidParameterException ex) {}
                    continue block9;
                }
                case 1: {
                    try {
                        returnList.add(new DeployedJob(jfjob));
                    }
                    catch (InvalidParameterException ex) {}
                    continue block9;
                }
            }
        }
        return returnList;
    }

    private static String getSchedulerServerHash(String serverID, MdStore store) {
        return serverID + store.hashCode();
    }

    public static boolean fixOldJobObject(Job job) throws RemoteException, MdException {
        boolean update = false;
        if (job != null && (job.getTransformRole().compareTo(JOB_ROLE) == 0 || job.getTransformRole().compareTo("") == 0 && job.getJobActivities().size() == 0)) {
            if (job.getTransformRole().compareTo("") == 0) {
                job.setTransformRole(JOB_ROLE);
                update = true;
            }
            if (job.getIsUserDefined() != 1 && job.getJobActivities().size() == 0) {
                job.setIsUserDefined(1);
                update = true;
            }
            if (job.getUsageVersion() < 1.0) {
                job.setUsageVersion("1000000.0");
                update = true;
            }
        }
        return update;
    }

    public static List<java.lang.Object> getDirectoriesFromBatchServer(ServerComponent batchserver) throws MdException, RemoteException {
        try {
            LogicalServer ls = (LogicalServer)batchserver.getUsedByComponents().get(0);
            if (ls == null) {
                return new ArrayList<java.lang.Object>();
            }
            ServerContext sc = (ServerContext)ls.getUsedByComponents().get(0);
            if (sc == null) {
                return new ArrayList<java.lang.Object>();
            }
            return MetaUtilities.getDirectories(sc);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return new ArrayList<java.lang.Object>();
        }
    }

    public static List<java.lang.Object> getDirectories(ServerContext appserver) throws MdException, RemoteException {
        ArrayList<java.lang.Object> list = new ArrayList<java.lang.Object>();
        AssociationList temp = appserver.getDataPackages();
        int listsize = temp.size();
        for (int i = 0; i < listsize; ++i) {
            if (!(temp.get(i) instanceof Directory)) continue;
            list.add(temp.get(i));
        }
        return list;
    }

    public static List<java.lang.Object> getDirectoriesFromServer(ServerComponent batchserver) throws MdException, RemoteException {
        try {
            LogicalServer ls = (LogicalServer)batchserver.getUsedByComponents().get(0);
            if (ls == null) {
                return new ArrayList<java.lang.Object>();
            }
            ServerContext sc = (ServerContext)ls.getUsedByComponents().get(0);
            if (sc == null) {
                return new ArrayList<java.lang.Object>();
            }
            return MetaUtilities.getDirectoriesFromServer(sc);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return new ArrayList<java.lang.Object>();
        }
    }

    public static List<java.lang.Object> getDirectoriesFromServer(ServerContext appserver) throws MdException, RemoteException {
        ArrayList<java.lang.Object> list = new ArrayList<java.lang.Object>();
        AssociationList temp = appserver.getDataPackages(true);
        int listsize = temp.size();
        for (int i = 0; i < listsize; ++i) {
            if (!(temp.get(i) instanceof Directory)) continue;
            list.add(temp.get(i));
        }
        return list;
    }

    public static List<?> getDirectoryList(String name, MdStore store, String repos) throws MdException, RemoteException {
        MdFactory factory = store.getFactory();
        String selectXML = "<XMLSELECT search=\"*[@Name='" + name + "']\" />";
        List list = factory.getOMIUtil().getMetadataObjectsSubset(store, repos, "Directory", 8584, selectXML);
        return list;
    }

    public static List<DirectoryInfo> getDirectoryPaths(ServerComponent batchserver) throws MdException, RemoteException {
        ArrayList<DirectoryInfo> list = new ArrayList<DirectoryInfo>();
        List<java.lang.Object> temp = MetaUtilities.getDirectoriesFromBatchServer(batchserver);
        int listsize = temp.size();
        for (int i = 0; i < listsize; ++i) {
            Directory dir = (Directory)temp.get(i);
            DirectoryInfo info = new DirectoryInfo(dir.getName(), dir.getDirectoryName());
            list.add(info);
        }
        return list;
    }

    public static List<DirectoryInfo> getDirectoryPathsFromServer(ServerComponent batchserver) throws MdException, RemoteException {
        ArrayList<DirectoryInfo> list = new ArrayList<DirectoryInfo>();
        List<java.lang.Object> temp = MetaUtilities.getDirectoriesFromServer(batchserver);
        int listsize = temp.size();
        for (int i = 0; i < listsize; ++i) {
            Directory dir = (Directory)temp.get(i);
            DirectoryInfo info = new DirectoryInfo(dir.getName(), dir.getDirectoryName());
            list.add(info);
        }
        return list;
    }

    public static Directory getDirectoryFromPath(String dirpath, MdStore store, String repos) throws MdException, RemoteException {
        String normDirpath = CommandUtilities.normalizePath(dirpath, -1);
        String strSelect = "<XMLSELECT search=\"Directory[@DirectoryName='" + normDirpath + "']\" />";
        MdFactory factory = store.getFactory();
        List list = factory.getOMIUtil().getMetadataObjectsSubset(store, repos, "Directory", 8584, strSelect);
        if (list.size() > 0) {
            return (Directory)list.get(0);
        }
        strSelect = "<XMLSELECT search=\"Directory[@DirectoryName='" + dirpath + "']\" />";
        list = factory.getOMIUtil().getMetadataObjectsSubset(store, repos, "Directory", 8584, strSelect);
        if (list.size() > 0) {
            return (Directory)list.get(0);
        }
        return null;
    }

    public static Directory getDirectoryFromName(String dirname, MdStore store, String repos) throws MdException, RemoteException {
        String strSelect = "<XMLSELECT search=\"Directory[@Name='" + dirname + "']\" />";
        MdFactory factory = store.getFactory();
        List list = factory.getOMIUtil().getMetadataObjectsSubset(store, repos, "Directory", 8584, strSelect);
        if (list.size() > 0) {
            return (Directory)list.get(0);
        }
        return null;
    }

    public static Directory getDirectory(String dirname, MdStore store, String repos) throws MdException, RemoteException {
        String normDirpath = CommandUtilities.normalizePath(dirname, -1);
        String strSelect = "<XMLSELECT search=\"*[@DirectoryName='" + normDirpath + "']\" />";
        MdFactory factory = store.getFactory();
        List list = factory.getOMIUtil().getMetadataObjectsSubset(store, repos, "Directory", 8584, strSelect);
        if (list.size() > 0) {
            return (Directory)list.get(0);
        }
        return null;
    }

    public static Directory getDirectory(DirectoryInfo dinfo, MdStore store, String repos) throws MdException, RemoteException {
        String strSelect = "<XMLSELECT search=\"Directory[@Name='" + dinfo.getName() + "']\" />";
        MdFactory factory = store.getFactory();
        for (Directory dir : factory.getOMIUtil().getMetadataObjectsSubset(store, repos, "Directory", 8584, strSelect)) {
            String temp;
            String path = CommandUtilities.normalizePath(dir.getDirectoryName(), -1);
            if (path.compareTo(temp = CommandUtilities.normalizePath(dinfo.getPath(), -1)) != 0) continue;
            return dir;
        }
        return null;
    }

    public static Directory getDirectory(BatchServerInfo bsinfo, String dirpath, MdStore store, String repos) throws MdException, RemoteException {
        ServerComponent batchserver = null;
        String strSelect = "<XMLSELECT search=\"*[@Id='" + bsinfo.getId() + "']\" /><Templates><ServerComponent><UsedByComponents/></ServerComponent><LogicalServer><UsedByComponents/></LogicalServer><ServerContext><DataPackages/></ServerContext></Templates>";
        MdFactory factory = store.getFactory();
        List list = factory.getOMIUtil().getMetadataObjectsSubset(store, repos, "ServerComponent", 8588, strSelect);
        if (list.size() > 0) {
            batchserver = (ServerComponent)list.get(0);
            if (batchserver == null) {
                return null;
            }
            LogicalServer ls = (LogicalServer)batchserver.getUsedByComponents().get(0);
            if (ls == null) {
                return null;
            }
            ServerContext sc = (ServerContext)ls.getUsedByComponents().get(0);
            if (sc == null) {
                return null;
            }
            AssociationList temp = sc.getDataPackages();
            String normDirpath = CommandUtilities.normalizePath(dirpath, bsinfo.getOperatingSystem());
            int listsize = temp.size();
            for (int i = 0; i < listsize; ++i) {
                Directory dir;
                String dirname;
                if (!(temp.get(i) instanceof Directory) || (dirname = CommandUtilities.normalizePath((dir = (Directory)temp.get(i)).getDirectoryName(), bsinfo.getOperatingSystem())).compareTo(normDirpath) != 0) continue;
                return dir;
            }
        }
        return null;
    }

    public static Directory getDirectory(BatchServerInfo bsinfo, DirectoryInfo dinfo, MdStore store, String repos) throws MdException, RemoteException {
        ServerComponent batchserver = null;
        String strSelect = "<XMLSELECT search=\"*[@Id='" + bsinfo.getId() + "']\" /><Templates><ServerComponent><UsedByComponents/></ServerComponent><LogicalServer><UsedByComponents/></LogicalServer><ServerContext><DataPackages/></ServerContext></Templates>";
        MdFactory factory = store.getFactory();
        List list = factory.getOMIUtil().getMetadataObjectsSubset(store, repos, "ServerComponent", 8588, strSelect);
        if (list.size() > 0) {
            batchserver = (ServerComponent)list.get(0);
            if (batchserver == null) {
                return null;
            }
            LogicalServer ls = (LogicalServer)batchserver.getUsedByComponents().get(0);
            if (ls == null) {
                return null;
            }
            ServerContext sc = (ServerContext)ls.getUsedByComponents().get(0);
            if (sc == null) {
                return null;
            }
            AssociationList temp = sc.getDataPackages();
            String normDirpath = CommandUtilities.normalizePath(dinfo.getPath(), bsinfo.getOperatingSystem());
            int listsize = temp.size();
            for (int i = 0; i < listsize; ++i) {
                String dirpath;
                Directory dir;
                if (!(temp.get(i) instanceof Directory) || (dir = (Directory)temp.get(i)).getName().compareTo(dinfo.getName()) != 0 || (dirpath = CommandUtilities.normalizePath(dir.getDirectoryName(), bsinfo.getOperatingSystem())) == null || dirpath.compareTo(normDirpath) != 0) continue;
                return dir;
            }
        }
        Directory dir = (Directory)store.getObject(dinfo.getId());
        return dir;
    }

    public static boolean addDirectory(Directory directory, ServerComponent batchserver) throws MdException, RemoteException {
        try {
            LogicalServer ls = (LogicalServer)batchserver.getUsedByComponents().get(0);
            if (ls == null) {
                return false;
            }
            ServerContext sc = (ServerContext)ls.getUsedByComponents().get(0);
            if (sc == null) {
                return false;
            }
            boolean rc = directory.getDeployedComponents().add((java.lang.Object)sc);
            directory.updateMetadataAll();
            return rc;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
    }

    public static boolean okayToDelete(Directory directory) {
        String strTemplate = "<TEMPLATES><Directory><UsedByPackages/><Files/></Directory></TEMPLATES>";
        int flags = 8589;
        boolean debugOn = false;
        try {
            MdFactory factory = MetaUtilities.getMdFactory(false);
            if (factory == null) {
                factory = directory.getObjectStore().getFactory();
            }
            MdUtil util = factory.getUtil();
            debugOn = factory.getDebug();
            directory = (Directory)factory.getOMIUtil().getMetadataAllDepths((CMetadata)directory, new Vector(), new Vector(), strTemplate, flags);
            if (directory.getUsedByPackages(true).size() > 0 || directory.getFiles(true).size() > 0) {
                if (util != null) {
                    util.printOutputln("okayToDelete()");
                    util.printOutputln("  directory.getUsedByPackages:" + directory.getUsedByPackages(true).toString());
                    util.printOutputln("  directory.getFiles:" + directory.getFiles(true).toString());
                } else if (debugOn) {
                    System.err.println("okayToDelete()");
                    System.err.println("  directory.getUsedByPackages:" + directory.getUsedByPackages(true).toString());
                    System.err.println("  directory.getFiles:" + directory.getFiles(true).toString());
                }
                return false;
            }
        }
        catch (NullPointerException ex) {
            if (debugOn) {
                System.err.println("okayToDelete():" + ex.getMessage());
            }
            return false;
        }
        catch (MdException ex) {
            if (debugOn) {
                System.err.println("okayToDelete():" + ex.getMessage());
            }
            return false;
        }
        catch (RemoteException ex) {
            if (debugOn) {
                System.err.println("okayToDelete():" + ex.toString());
            }
            return false;
        }
        return true;
    }

    public static List getAssociatedObjects(Directory directory) {
        String strTemplate = "<TEMPLATES><Directory><UsedByPackages/><Files/></Directory></TEMPLATES>";
        int flags = 8589;
        boolean debugOn = false;
        try {
            MdFactory factory = MetaUtilities.getMdFactory(false);
            if (factory == null) {
                factory = directory.getObjectStore().getFactory();
            }
            debugOn = factory.getDebug();
            directory = (Directory)factory.getOMIUtil().getMetadataAllDepths((CMetadata)directory, new Vector(), new Vector(), strTemplate, flags);
            ArrayList list = new ArrayList();
            list.addAll(directory.getUsedByPackages(true));
            list.addAll(directory.getFiles(true));
            return list;
        }
        catch (NullPointerException ex) {
            if (debugOn) {
                System.err.println("getAssociatedObjects():" + ex.getMessage());
            }
            return null;
        }
        catch (MdException ex) {
            if (debugOn) {
                System.err.println("getAssociatedObjects():" + ex.getMessage());
            }
            return null;
        }
        catch (RemoteException ex) {
            if (debugOn) {
                System.err.println("getAssociatedObjects():" + ex.getMessage());
            }
            return null;
        }
    }

    public static String getServerContextID(ServerComponent batchserver) throws MdException, RemoteException {
        try {
            LogicalServer ls = (LogicalServer)batchserver.getUsedByComponents().get(0);
            if (ls == null) {
                return null;
            }
            ServerContext sc = (ServerContext)ls.getUsedByComponents().get(0);
            if (sc == null) {
                return null;
            }
            return sc.getId();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public static boolean setMdFactory(MdFactory factory) {
        m_defaultMdFactory = factory;
        return true;
    }

    public static MdFactory getMdFactory() {
        MdFactory factory;
        MetaUtilitiesContext context = MetaUtilitiesContextHolder.getMetaUtilitiesContext();
        if (context != null && (factory = context.getDefaultMdFactory()) != null) {
            return factory;
        }
        return m_defaultMdFactory;
    }

    public static MdFactory getMdFactory(boolean debug) throws RemoteException, MdException {
        MdFactory factory;
        MetaUtilitiesContext context = MetaUtilitiesContextHolder.getMetaUtilitiesContext();
        if (context != null && (factory = context.getDefaultMdFactory()) != null) {
            return factory;
        }
        if (m_defaultMdFactory == null) {
            if (m_sessionContextInterface != null) {
                try {
                    OMIServer server;
                    UserContextInterface user = m_sessionContextInterface.getUserContext();
                    if (user != null && (m_defaultMdFactory = (server = (OMIServer)user.getAuthServer()).getMdFactory()).getInstance() == null) {
                        if (debug) {
                            RuntimeException ex = new RuntimeException(m_bundle.getString("MetaUtilities.MdFactory.Disposed.txt"));
                            ex.printStackTrace();
                        }
                        m_defaultMdFactory = null;
                    }
                }
                catch (Exception e) {
                    if (debug) {
                        e.printStackTrace();
                    }
                    m_defaultMdFactory = null;
                }
            } else {
                IOMI iomi = MetadataWorkspace.getWorkspace().getCMRHandle();
                if (iomi != null) {
                    m_defaultMdFactory = new MdFactoryImpl();
                    m_defaultMdFactory.getConnection().setCMRHandle(iomi);
                    if (debug) {
                        m_defaultMdFactory.setDebug(true);
                        m_defaultMdFactory.setLoggingEnabled(true);
                        m_defaultMdFactory.getUtil().setOutputStream((OutputStream)System.out);
                        m_defaultMdFactory.getUtil().setLogStream((OutputStream)System.out);
                    } else {
                        m_defaultMdFactory.setDebug(false);
                        m_defaultMdFactory.setLoggingEnabled(false);
                    }
                }
            }
        } else if (m_defaultMdFactory.getInstance() == null) {
            if (debug) {
                RuntimeException ex = new RuntimeException(m_bundle.getString("MetaUtilities.MdFactory.Disposed.txt"));
                ex.printStackTrace();
            }
            m_defaultMdFactory = null;
        }
        return m_defaultMdFactory;
    }

    public static MdFactory getMdFactory(SessionContextInterface session) throws RemoteException, MdException {
        if (session != null) {
            try {
                OMIServer server;
                UserContextInterface user = session.getUserContext();
                if (user != null && (server = (OMIServer)user.getAuthServer()) != null) {
                    MdFactory factory = server.getMdFactory();
                    if (factory.getInstance() == null) {
                        if (MetaUtilities.isDebug()) {
                            RuntimeException ex = new RuntimeException(m_bundle.getString("MetaUtilities.MdFactory.Disposed.txt"));
                            ex.printStackTrace();
                        }
                        return null;
                    }
                    return factory;
                }
            }
            catch (Exception e) {
                if (MetaUtilities.isDebug()) {
                    e.printStackTrace();
                }
                return null;
            }
        }
        return null;
    }

    public static MdFactory createNewFactory(boolean debug) throws RemoteException, MdException {
        return MetaUtilities.getMdFactory(debug);
    }

    public static MdObjectStore getDefaultStore() {
        MdObjectStore store;
        MetaUtilitiesContext context = MetaUtilitiesContextHolder.getMetaUtilitiesContext();
        if (context != null && (store = context.getDefaultMdObjectStore()) != null) {
            return store;
        }
        try {
            if (m_defaultMdStore == null) {
                MdFactory factory = MetaUtilities.getMdFactory(MetaUtilities.isDebug());
                if (factory != null) {
                    m_defaultMdStore = factory.createObjectStore(null, "METAUTILITIES");
                } else {
                    if (LOGGER.isDebugEnabled() || MetaUtilities.isDebug()) {
                        String s = "METAUTILITIES: UNINITIALIZED WORKSPACE WARNING";
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug(s);
                        } else {
                            System.out.println(s);
                        }
                    }
                    m_defaultMdStore = null;
                }
            }
            return m_defaultMdStore;
        }
        catch (MdException ex) {
            return null;
        }
        catch (RemoteException ex) {
            return null;
        }
    }

    public static Root createNewEditableObject(Root root) throws MdException, RemoteException {
        MdFactory factory = root.getObjectStore().getFactory();
        MdObjectStore store = factory.createObjectStore(null, "createNewEditableObject");
        return MetaUtilities.createNewEditableObject(root, store);
    }

    public static Root createNewEditableObject(Root root, MdObjectStore store) throws MdException, RemoteException {
        MdFactory factory = store.getFactory();
        Root editableObject = (Root)factory.createComplexMetadataObject(store, null, root.getName(), root.getCMetadataType(), root.getId(), null);
        Vector<String> attribs = new Vector<String>();
        Map metaAttrs = editableObject.getAttrs();
        Set attrSet = metaAttrs.keySet();
        for (String strNext : attrSet) {
            if (strNext.equalsIgnoreCase("ID")) continue;
            attribs.add(strNext);
        }
        editableObject = (Root)factory.getOMIUtil().getMetadataAllDepths((CMetadata)editableObject, attribs, null, "", 8);
        return editableObject;
    }

    public static Root createDupRemoteObject(Root root, MdFactory factory, MdObjectStore store) throws MdException, RemoteException {
        Root dupObject = (Root)factory.createComplexMetadataObject(store, null, root.getName(), root.getCMetadataType(), root.getId(), null);
        Vector<String> attribs = new Vector<String>();
        Map metaAttrs = dupObject.getAttrs();
        Set attrSet = metaAttrs.keySet();
        for (String strNext : attrSet) {
            if (strNext.equalsIgnoreCase("ID")) continue;
            attribs.add(strNext);
        }
        dupObject = (Root)factory.getOMIUtil().getMetadataAllDepths((CMetadata)dupObject, attribs, null, "", 8);
        return dupObject;
    }

    public static Job createJobObject(String name, String commonoptions, String jobargs, MdObjectStore store, String reposID) throws MdException, RemoteException {
        Property property;
        if (!DeployedJob.isValidName(name)) {
            return null;
        }
        MdFactory factory = store.getFactory();
        String repos = reposID.length() > 8 ? reposID.substring(9) : reposID;
        Job job = (Job)factory.createComplexMetadataObject(store, null, name, "Job", repos, null);
        job.setTransformRole(MISCJOB_ROLE);
        boolean commonArgsNotFound = true;
        boolean jobArgsNotFound = true;
        AssociationList properties = job.getProperties();
        int numprops = properties.size();
        for (int i = 0; i < numprops; ++i) {
            property = (Property)properties.get(i);
            if (property.getPropertyName().equalsIgnoreCase(PropCommonArgs)) {
                property.setDefaultValue(commonoptions);
                commonArgsNotFound = false;
                continue;
            }
            if (!property.getPropertyName().equalsIgnoreCase(PropCmdArgs)) continue;
            property.setDefaultValue(jobargs);
            jobArgsNotFound = false;
        }
        if (commonArgsNotFound) {
            property = (Property)factory.createComplexMetadataObject(store, null, PropCommonArgs, "Property", repos, null);
            property.setPropertyName(PropCommonArgs);
            property.setDefaultValue(commonoptions);
            property.setSQLType(12);
            properties.add((java.lang.Object)property);
        }
        if (jobArgsNotFound) {
            property = (Property)factory.createComplexMetadataObject(store, null, PropCmdArgs, "Property", repos, null);
            property.setPropertyName(PropCmdArgs);
            property.setDefaultValue(jobargs);
            property.setSQLType(12);
            properties.add((java.lang.Object)property);
        }
        return job;
    }

    public static Job createJobObject(String name, String commonoptions, MdObjectStore store, String reposID) throws MdException, RemoteException {
        Property property;
        if (!DeployedJob.isValidName(name)) {
            return null;
        }
        MdFactory factory = store.getFactory();
        String repos = reposID.length() > 8 ? reposID.substring(9) : reposID;
        Job job = (Job)factory.createComplexMetadataObject(store, null, name, "Job", repos, null);
        job.setTransformRole(MISCJOB_ROLE);
        AssociationList properties = job.getProperties();
        int numprops = properties.size();
        for (int i = 0; i < numprops; ++i) {
            property = (Property)properties.get(i);
            if (!property.getPropertyName().equalsIgnoreCase(PropCommonArgs)) continue;
            property.setDefaultValue(commonoptions);
            return job;
        }
        property = (Property)factory.createComplexMetadataObject(store, null, PropCmdArgs, "Property", repos, null);
        property.setPropertyName(PropCommonArgs);
        property.setDefaultValue(commonoptions);
        property.setSQLType(12);
        properties.add((java.lang.Object)property);
        return job;
    }

    public static Job createJobObject(String name, MdObjectStore store, String reposID, String description) throws RemoteException {
        if (!DeployedJob.isValidName(name)) {
            return null;
        }
        MdFactory factory = store.getFactory();
        String repos = reposID.length() > 8 ? reposID.substring(9) : reposID;
        Job job = (Job)factory.createComplexMetadataObject(store, null, name, "Job", repos, null);
        job.setTransformRole(MISCJOB_ROLE);
        job.setDesc(description);
        return job;
    }

    public static Job createJobObject(String name, MdObjectStore store, String reposID) throws RemoteException {
        if (!DeployedJob.isValidName(name)) {
            return null;
        }
        MdFactory factory = store.getFactory();
        String repos = reposID.length() > 8 ? reposID.substring(9) : reposID;
        Job job = (Job)factory.createComplexMetadataObject(store, null, name, "Job", repos, null);
        job.setTransformRole(MISCJOB_ROLE);
        return job;
    }

    public static Job createUserWrittenJobObject(String name, File sourcefile, MdObjectStore store, String reposID) throws RemoteException {
        return MetaUtilities.createUserWrittenJobObject(name, sourcefile, null, store, reposID);
    }

    public static Job createUserWrittenJobObject(String name, File sourcefile, ServerComponent server, MdObjectStore store, String reposID) throws RemoteException {
        if (!DeployedJob.isValidName(name)) {
            return null;
        }
        MdFactory factory = store.getFactory();
        String repos = reposID.length() > 8 ? reposID.substring(9) : reposID;
        Job job = (Job)factory.createComplexMetadataObject(store, null, name, "Job", repos, null);
        job.setIsUserDefined(1);
        job.setTransformRole(MISCJOB_ROLE);
        if (sourcefile != null) {
            job.setSourceCode((Text)sourcefile);
        }
        job.setPublicType("Job");
        job.setUsageVersion("1000000.0");
        return job;
    }

    public static Job createTerminalJobObject(String name, MdObjectStore store, String reposID) throws RemoteException {
        if (!DeployedJob.isValidName(name)) {
            return null;
        }
        MdFactory factory = store.getFactory();
        String repos = reposID.length() > 8 ? reposID.substring(9) : reposID;
        Job job = (Job)factory.createComplexMetadataObject(store, null, name, "Job", repos, null);
        job.setTransformRole(TERMINAL_JOB_TRANSFORM_ROLE);
        return job;
    }

    public static boolean isUserWritten(Job job) throws RemoteException {
        if (job == null) {
            return false;
        }
        int value = job.getIsUserDefined();
        return value == 1;
    }

    public static boolean isRedeployable(Job job, boolean codegen) throws RemoteException, MdException {
        if (job == null) {
            return false;
        }
        if (codegen) {
            return true;
        }
        String role = job.getTransformRole();
        if (role.compareTo(JOB_ROLE) == 0 && job.getIsUserDefined() != 0) {
            return job.getSourceCodes().size() > 0;
        }
        if (role.compareTo(TERMINAL_JOB_TRANSFORM_ROLE) == 0) {
            return true;
        }
        if (role.compareTo(MISCJOB_ROLE) == 0) {
            return false;
        }
        if (role.compareTo(JOB_ROLE_MARK_DELETE) == 0) {
            return false;
        }
        return false;
    }

    public static String NotRedeployableReason(Job job, boolean codegen) throws RemoteException, MdException {
        if (job == null) {
            return m_bundle.getString("MetaUtilities.Error.Redeploy.MissingAssociatedJob.txt");
        }
        String role = job.getTransformRole();
        if (role.compareTo(JOB_ROLE) == 0) {
            if (job.getSourceCodes().size() == 0) {
                if (job.getJobActivities().size() == 0) {
                    return m_bundle.getString("MetaUtilities.Error.Redeploy.Not92Compatible.txt");
                }
                return m_bundle.getString("MetaUtilities.Error.Redeploy.NotUserWrittenJob.txt");
            }
            return null;
        }
        if (role.compareTo(TERMINAL_JOB_TRANSFORM_ROLE) == 0) {
            return null;
        }
        if (!codegen) {
            return m_bundle.getString("MetaUtilities.Error.Redeploy.UnknownType.txt");
        }
        return null;
    }

    public static Job setSourceForUserWrittenJob(Job job, File sourcefile, String role, MdObjectStore store, String repos) throws RemoteException, MdException {
        return MetaUtilities.setSourceForUserWrittenJob(job, sourcefile, null, role);
    }

    public static Job setSourceForUserWrittenJob(Job job, File sourcefile, ServerComponent server, String role) throws RemoteException, MdException {
        job.setIsUserDefined(1);
        job.setTransformRole(role);
        if (sourcefile != null) {
            job.setSourceCode((Text)sourcefile);
        }
        return job;
    }

    public static Job setSourceForUserWrittenJob(Job job, File sourcefile, ServerComponent server, String role, MdObjectStore store, String repos) throws RemoteException, MdException {
        job.setIsUserDefined(1);
        job.setTransformRole(role);
        if (sourcefile != null) {
            job.setSourceCode((Text)sourcefile);
        }
        return job;
    }

    public static boolean setFileSource(File fileObj, String filename, String filepath, MdObjectStore store, String reposId) throws RemoteException, MdException {
        if (filename != null) {
            Directory dir = null;
            if (filepath != null && (dir = MetaUtilities.getDirectoryFromPath(filepath, (MdStore)store, reposId)) == null) {
                String dirname = filepath.substring(filepath.lastIndexOf("/") + 1);
                String repos = reposId.length() > 8 ? reposId.substring(9) : reposId;
                dir = MetaUtilities.createDirectoryObject(dirname, store, repos);
                dir.setDirectoryName(filepath);
            }
            if (filename.indexOf(".") >= 0) {
                fileObj.setFileName(filename.substring(0, filename.lastIndexOf(46)));
                fileObj.setFileExtension(filename.substring(filename.lastIndexOf(46) + 1));
            } else {
                fileObj.setFileName(filename);
            }
            fileObj.getDirectories().clear();
            fileObj.getDirectories().add((java.lang.Object)dir);
        }
        return true;
    }

    public static Directory createDirectoryObject(String dirname, MdObjectStore store, String reposID) throws RemoteException {
        MdFactory factory = store.getFactory();
        String repos = reposID.length() > 8 ? reposID.substring(9) : reposID;
        return (Directory)factory.createComplexMetadataObject(store, null, dirname, "Directory", repos, null);
    }

    public static File createFileObject(String strFilename, Directory directory, MdObjectStore store, String reposID) throws RemoteException, MdException {
        MdFactory factory = store.getFactory();
        String repos = reposID.length() > 8 ? reposID.substring(9) : reposID;
        File sourceFile = (File)factory.createComplexMetadataObject(store, null, strFilename, "File", repos, null);
        sourceFile.setFileName(strFilename);
        if (directory != null) {
            sourceFile.getDirectories().add((java.lang.Object)directory);
        }
        return sourceFile;
    }

    public static File createSourceCodeObject(String strFilename, Directory directory, MdObjectStore store, String reposID) throws RemoteException, MdException {
        MdFactory factory = store.getFactory();
        String repos = reposID.length() > 8 ? reposID.substring(9) : reposID;
        File source = (File)factory.createComplexMetadataObject(store, null, strFilename, "File", repos, null);
        source.setFileName(strFilename);
        source.setIsARelativeName(1);
        source.setTextRole(SYSIN_FILE_ROLE);
        source.getDirectories().add((java.lang.Object)directory);
        return source;
    }

    public static File createSourceCodeObject(String strFilename, MdObjectStore store, String reposID) throws RemoteException {
        File source;
        block7: {
            MdFactory factory = store.getFactory();
            String repos = reposID.length() > 8 ? reposID.substring(9) : reposID;
            source = null;
            String dirpath = CommandUtilities.getDirnameForBatchServer(strFilename, null);
            if (dirpath != null) {
                try {
                    Directory dir = MetaUtilities.getDirectory(dirpath, (MdStore)store, reposID);
                    if (dir != null) {
                        String basename = CommandUtilities.getBasenameForBatchServer(strFilename, null);
                        source = (File)factory.createComplexMetadataObject(store, null, basename, "File", repos, null);
                        source.getDirectories().add((java.lang.Object)dir);
                        break block7;
                    }
                    if (MetaUtilities.isDebug()) {
                        RuntimeException re = new RuntimeException("No Deployment Directory found for file: " + strFilename);
                        re.printStackTrace();
                    }
                    source = (File)factory.createComplexMetadataObject(store, null, strFilename, "File", repos, null);
                }
                catch (MdException e) {
                    if (MetaUtilities.isDebug()) {
                        e.printStackTrace();
                    }
                    break block7;
                }
            }
            source = (File)factory.createComplexMetadataObject(store, null, strFilename, "File", repos, null);
        }
        if (source != null) {
            source.setFileName(strFilename);
            source.setIsARelativeName(1);
            source.setTextRole(SYSIN_FILE_ROLE);
        }
        return source;
    }

    public static String getDateCreated(CMetadata metaObj, boolean localformat) throws RemoteException {
        if (localformat) {
            return MetaUtilities.getDateCreated(metaObj, Locale.getDefault());
        }
        return metaObj.getMetadataCreated();
    }

    public static Date getDateCreated(CMetadata metaObj) throws RemoteException, ParseException {
        String gmt = metaObj.getMetadataCreated();
        SimpleDateFormat metaDate = new SimpleDateFormat(OMR_DATEFORMAT, Locale.US);
        metaDate.setTimeZone(TimeZone.getTimeZone("GMT"));
        Date jdate = metaDate.parse(gmt);
        return jdate;
    }

    public static String getDateCreated(CMetadata metaObj, Locale locale) throws RemoteException {
        try {
            Date jdate = MetaUtilities.getDateCreated(metaObj);
            DateFormat dateTime = DateFormat.getDateTimeInstance(3, 3, locale);
            String localetime = dateTime.format(jdate);
            SimpleDateFormat javadate = new SimpleDateFormat();
            javadate.applyPattern("Z");
            return MetaUtilities.messageString(m_bundle.getString("MetaUtilities.LocalTimeFormatWithGMTOffset.fmt"), localetime, javadate.format(jdate));
        }
        catch (ParseException ex) {
            return metaObj.getMetadataCreated();
        }
        catch (RuntimeException ex) {
            return metaObj.getMetadataCreated();
        }
    }

    public static String getDateModified(CMetadata metaObj, boolean localformat) throws RemoteException {
        if (localformat) {
            return MetaUtilities.getDateModified(metaObj, Locale.getDefault());
        }
        return metaObj.getMetadataCreated();
    }

    public static Date getDateModified(CMetadata metaObj) throws RemoteException, ParseException {
        String gmt = metaObj.getMetadataUpdated();
        SimpleDateFormat metaDate = new SimpleDateFormat(OMR_DATEFORMAT, Locale.US);
        metaDate.setTimeZone(TimeZone.getTimeZone("GMT"));
        Date jdate = metaDate.parse(gmt);
        return jdate;
    }

    public static String getDateModified(CMetadata metaObj, Locale locale) throws RemoteException {
        try {
            Date jdate = MetaUtilities.getDateCreated(metaObj);
            DateFormat dateTime = DateFormat.getDateTimeInstance(3, 3, locale);
            String localetime = dateTime.format(jdate);
            SimpleDateFormat javadate = new SimpleDateFormat();
            javadate.applyPattern("Z");
            return MetaUtilities.messageString(m_bundle.getString("MetaUtilities.LocalTimeFormatWithGMTOffset.fmt"), localetime, javadate.format(jdate));
        }
        catch (ParseException ex) {
            return metaObj.getMetadataUpdated();
        }
        catch (RuntimeException ex) {
            return metaObj.getMetadataUpdated();
        }
    }

    public static String getDateModified(List metaObjs, boolean localformat) throws RemoteException {
        if (localformat) {
            return MetaUtilities.getDateModified(metaObjs, Locale.getDefault());
        }
        return MetaUtilities.getDateModified(metaObjs, null);
    }

    public static Date getDateModified(List metaObjs) throws RemoteException {
        SimpleDateFormat metaDate = new SimpleDateFormat(OMR_DATEFORMAT, Locale.US);
        Date jdate = null;
        for (int x = metaObjs.size() - 1; x >= 0; --x) {
            CMetadata metaObj = (CMetadata)metaObjs.get(x);
            if (metaObj == null) continue;
            String gmt = metaObj.getMetadataUpdated();
            metaDate.setTimeZone(TimeZone.getTimeZone("GMT"));
            try {
                Date tdate = metaDate.parse(gmt);
                if (jdate != null && !tdate.after(jdate)) continue;
                jdate = tdate;
                continue;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return jdate;
    }

    public static String getDateModified(List metaObjs, Locale locale) throws RemoteException {
        SimpleDateFormat metaDate = new SimpleDateFormat(OMR_DATEFORMAT, Locale.US);
        Date jdate = MetaUtilities.getDateModified(metaObjs);
        if (locale != null) {
            try {
                DateFormat dateTime = DateFormat.getDateTimeInstance(3, 3, locale);
                String localetime = dateTime.format(jdate);
                SimpleDateFormat javadate = new SimpleDateFormat();
                javadate.applyPattern("Z");
                return MetaUtilities.messageString(m_bundle.getString("MetaUtilities.LocalTimeFormatWithGMTOffset.fmt"), localetime, javadate.format(jdate));
            }
            catch (RuntimeException ex) {
                return metaDate.format(jdate);
            }
        }
        return metaDate.format(jdate);
    }

    public static ResourceBundle getMyResourceBundle(Class source) {
        Locale locale = Locale.getDefault();
        return MetaUtilities.getMyResourceBundle(source, locale);
    }

    public static ResourceBundle getMyResourceBundle(Class source, Locale locale) {
        String strClassName = source.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        try {
            return ResourceBundle.getBundle(strBundlePath, locale);
        }
        catch (Throwable e) {
            try {
                return PropertyResourceBundle.getBundle(strBundlePath, locale);
            }
            catch (Throwable e2) {
                return null;
            }
        }
    }

    public static ImageIcon getImageIcon(ResourceBundle bundle, String skey) {
        String sImagePath = bundle.getString("ImageLocation.notrans") + bundle.getString(skey);
        ImageIcon image = m_ImageCache.get(sImagePath);
        if (image != null) {
            return image;
        }
        try {
            URL url = ClassLoader.getSystemClassLoader().getResource(sImagePath);
            image = new ImageIcon(url);
        }
        catch (Exception e) {
            String sDefaultPath = "com/sas/workspace/res/DefaultImage.gif";
            try {
                URL urlDefault = ClassLoader.getSystemClassLoader().getResource(sDefaultPath);
                image = new ImageIcon(urlDefault);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (image != null) {
            m_ImageCache.put(sImagePath, image);
        }
        return image;
    }

    public static String messageString(String pattern, java.lang.Object parm1) {
        return MessageUtil.messageString((String)pattern, (java.lang.Object)parm1);
    }

    public static String messageString(String pattern, java.lang.Object parm1, java.lang.Object parm2) {
        return MessageUtil.messageString((String)pattern, (java.lang.Object)parm1, (java.lang.Object)parm2);
    }

    public static String messageString(String pattern, java.lang.Object parm1, java.lang.Object parm2, java.lang.Object parm3) {
        return MessageUtil.messageString((String)pattern, (java.lang.Object)parm1, (java.lang.Object)parm2, (java.lang.Object)parm3);
    }

    public static String messageString(String pattern, java.lang.Object parm1, java.lang.Object parm2, java.lang.Object parm3, java.lang.Object parm4) {
        return MessageUtil.messageString((String)pattern, (java.lang.Object)parm1, (java.lang.Object)parm2, (java.lang.Object)parm3, (java.lang.Object)parm4);
    }

    public static String messageString(String pattern, java.lang.Object parm1, java.lang.Object parm2, java.lang.Object parm3, java.lang.Object parm4, java.lang.Object parm5) {
        return MessageUtil.messageString((String)pattern, (java.lang.Object)parm1, (java.lang.Object)parm2, (java.lang.Object)parm3, (java.lang.Object)parm4, (java.lang.Object)parm5);
    }

    public static String messageString(String pattern, java.lang.Object parm1, java.lang.Object parm2, java.lang.Object parm3, java.lang.Object parm4, java.lang.Object parm5, java.lang.Object parm6) {
        return MessageUtil.messageString((String)pattern, (java.lang.Object)parm1, (java.lang.Object)parm2, (java.lang.Object)parm3, (java.lang.Object)parm4, (java.lang.Object)parm5, (java.lang.Object)parm6);
    }

    public static void checkCircularDependencies(FlowInfo flow, String id) throws InvalidParameterException, SchedulerException {
        try {
            MetaUtilities.checkCircularDependencies(flow, id, MetaUtilities.getMdFactory(false));
        }
        catch (RemoteException ex) {
            SchedulerException se = new SchedulerException(ex.getLocalizedMessage());
            se.initCause((Throwable)ex);
            throw se;
        }
        catch (MdException ex) {
            SchedulerException se = new SchedulerException(ex.getLocalizedMessage());
            se.initCause((Throwable)ex);
            throw se;
        }
    }

    public static void checkCircularDependencies(FlowInfo flow, String id, MdFactory factory) throws InvalidParameterException, SchedulerException {
        try {
            MdObjectStore tempstore = factory.createObjectStore(null, "checkCircularLogic");
            String repos = "A0000001." + flow.getId().substring(0, 8);
            String path = DeployedFlow.hasCircularLogic(flow.getId(), id, tempstore, repos);
            tempstore.dispose();
            if (path != null) {
                throw new InvalidParameterException(path);
            }
        }
        catch (MdException ex) {
            SchedulerException se = new SchedulerException(ex.getLocalizedMessage());
            se.initCause((Throwable)ex);
            throw se;
        }
        catch (RemoteException ex) {
            SchedulerException se = new SchedulerException(ex.getLocalizedMessage());
            se.initCause((Throwable)ex);
            throw se;
        }
    }

    public static EventListItem processWaitEvent(SyncStep step) throws MdException, RemoteException {
        AssociationList events = step.getTriggeringEvents();
        if (events.size() < 1) {
            return null;
        }
        Event event = (Event)events.get(0);
        if (event == null) {
            return null;
        }
        EventListItem entry = new EventListItem(event.getCondition());
        entry.addMetadataObject((CMetadata)step);
        entry.addMetadataObject((CMetadata)event);
        AssociationList list = step.getSuccessorDependencies();
        if (list.size() > 0) {
            entry.addMetadataObject((CMetadata)((StepPrecedence)step.getSuccessorDependencies().get(0)));
        }
        entry.putProperty(PropertyTypeName, PropertyTypeEventDependency);
        return entry;
    }

    public static EventListItem processJobEvent(StepPrecedence steppred, TransformationStep step) throws MdException, RemoteException {
        AssociationList dependentTransformations = step.getTransformations();
        DeployedJob dependentJob = null;
        try {
            dependentJob = new DeployedJob((JFJob)dependentTransformations.get(0));
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return null;
        }
        JobEvent jobEvent = new JobEvent(dependentJob, steppred);
        String sDisplayDefinition = jobEvent.getDisplayDefinition();
        jobEvent.setDescription(steppred.getDesc());
        EventListItem entry = new EventListItem(sDisplayDefinition);
        entry.putProperty(PropertyJobEventName, jobEvent);
        entry.putProperty(PropertyTypeName, PropertyTypeJobDependency);
        entry.addMetadataObject((CMetadata)steppred);
        entry.addMetadataObject((CMetadata)step);
        return entry;
    }

    public static Property setStringProperty(Root metadata, String propName, MdFactory factory, MdObjectStore store, String value) throws MdException, RemoteException {
        Property prop = MetaUtilities.setProperty(metadata, propName, factory, store, value);
        if (prop != null) {
            prop.setSQLType(12);
        }
        return prop;
    }

    public static Property setProperty(Root metadata, String propName, MdFactory factory, MdObjectStore store, String value) throws MdException, RemoteException {
        Property property;
        AssociationList properties = metadata.getProperties();
        int propsize = properties.size();
        for (int i = 0; i < propsize; ++i) {
            property = (Property)properties.elementAt(i);
            if (!property.getPropertyName().equalsIgnoreCase(propName)) continue;
            property.setDefaultValue(value);
            return property;
        }
        String repos = metadata.getRepositoryID();
        if (repos.length() > 8) {
            repos = repos.substring(9);
        }
        property = (Property)factory.createComplexMetadataObject(store, null, propName, "Property", repos, null);
        property.setPropertyName(propName);
        property.setDefaultValue(value);
        properties.add((java.lang.Object)property);
        return property;
    }

    public static String getProperty(Root metadata, String propName) throws MdException, RemoteException {
        if (metadata == null) {
            return null;
        }
        AssociationList properties = metadata.getProperties();
        int propsize = properties.size();
        for (int i = 0; i < propsize; ++i) {
            Property property = (Property)properties.elementAt(i);
            if (!property.getPropertyName().equalsIgnoreCase(propName)) continue;
            return property.getDefaultValue();
        }
        return null;
    }

    public static Property getPropertyObject(Root metadata, String propName) throws RemoteException, MdException {
        AssociationList properties = metadata.getProperties();
        int propsize = properties.size();
        for (int i = 0; i < propsize; ++i) {
            Property property = (Property)properties.elementAt(i);
            if (!property.getPropertyName().equalsIgnoreCase(propName)) continue;
            return property;
        }
        return null;
    }

    public static String getDomain(SchedulerServerInfo server) throws MdException, RemoteException {
        ServerComponent sc = MetaUtilities.getSchedulerServer(server);
        return MetaUtilities.getDomain(sc);
    }

    public static String getDomain(ServerComponent server) throws MdException, RemoteException {
        AssociationList connections = server.getSourceConnections();
        if (connections.size() < 1) {
            return null;
        }
        TCPIPConnection connection = (TCPIPConnection)connections.get(0);
        AuthenticationDomain domain = connection.getDomain();
        if (domain != null) {
            return domain.getName();
        }
        return null;
    }

    public static PasswordAuthentication getLoginIdentity(SchedulerServerInfo server) throws SchedulerException {
        try {
            MdFactory factory = MetaUtilities.getMdFactory();
            if (factory != null) {
                MdObjectStore store = factory.createObjectStore(null, "getLoginIdentity");
                String repos = factory.getOMIUtil().getFoundationReposID();
                ServerComponent sc = MetaUtilities.getSchedulerServer(server, (MdStore)store, repos);
                return MetaUtilities.getLoginIdentity(sc);
            }
            return null;
        }
        catch (MdException ex) {
            return null;
        }
        catch (RemoteException ex) {
            return null;
        }
    }

    public static PasswordAuthentication getLoginIdentity(ServerComponent server) throws SchedulerException {
        if (server == null) {
            return null;
        }
        String MISSING_DOMAIN = "###MISSING_METADATA###";
        try {
            SchedulerServerInfo sinfo;
            String key;
            Scheduler sch;
            MdFactory cfactory;
            PasswordAuthentication pa;
            TCPIPConnection connection;
            AuthenticationDomain authdomain;
            String domain = null;
            AssociationList connections = server.getSourceConnections();
            domain = connections.size() < 1 ? MISSING_DOMAIN : ((authdomain = (connection = (TCPIPConnection)connections.get(0)).getDomain()) != null ? authdomain.getName() : MISSING_DOMAIN);
            SessionContextInterface sessionContext = MetaUtilities.getSessionContext();
            if (sessionContext != null) {
                UserContextInterface userContext = sessionContext.getUserContext();
                if (userContext != null) {
                    if (domain.compareTo(MISSING_DOMAIN) == 0) {
                        List identities = userContext.getIdentities();
                        for (UserIdentityInterface uI : identities) {
                            if (!uI.isPrimary()) continue;
                            return new PasswordAuthentication(uI.getPrincipal().toString(), uI.getCredential().toString().toCharArray());
                        }
                    } else {
                        UserIdentityInterface uI = userContext.getIdentityByDomain(domain != null ? domain : "");
                        if (uI != null) {
                            return new PasswordAuthentication(uI.getPrincipal().toString(), uI.getCredential().toString().toCharArray());
                        }
                    }
                }
            } else if (domain != null && (pa = MdModelUtil.getCredential((MdFactory)(cfactory = server.getObjectStore().getFactory()), (String)domain, (String)MdModelUtil.getReposID((String)server.getId()))) != null) {
                return pa;
            }
            if ((sch = m_schedulerCache.get(key = MetaUtilities.getSchedulerServerHash(server.getId(), server.getObjectStore()))) != null && (sinfo = sch.getServerComponent()).getUsername() != null && sinfo.getPassword() != null) {
                return new PasswordAuthentication(sinfo.getUsername(), sinfo.getPassword().toCharArray());
            }
            MdFactory cfactory2 = server.getObjectStore().getFactory();
            MdOMRConnection connection2 = cfactory2.getConnection();
            Map credMap = connection2.getCredentialMap();
            if (credMap != null) {
                String userid = (String)credMap.get("Username");
                SealedString password = (String)credMap.get("Password") != null ? new SealedString((String)credMap.get("Password")) : null;
                return new PasswordAuthentication(userid, password != null ? password.getCharacters() : null);
            }
        }
        catch (MdException ex) {
            SchedulerException se = new SchedulerException(ex.toString());
            se.initCause((Throwable)ex);
            throw se;
        }
        catch (RemoteException ex) {
            SchedulerException se = new SchedulerException(ex.toString());
            se.initCause((Throwable)ex);
            throw se;
        }
        return null;
    }

    public static PasswordAuthentication getLoginIdentityForGrid(SchedulerServerInfo ssi, String username, MdStore store, String repos) throws SchedulerException {
        try {
            ServerComponent server = MetaUtilities.getSchedulerServer(ssi, store, repos);
            AssociationList connections = server.getSourceConnections();
            if (connections.size() < 1) {
                return null;
            }
            TCPIPConnection connection = (TCPIPConnection)connections.get(0);
            AuthenticationDomain domain = connection.getDomain();
            Login l2 = null;
            if (domain != null) {
                AssociationList logins = domain.getLogins();
                for (Login l2 : logins) {
                    if (l2.getUserID().compareTo(username) != 0) continue;
                    if (l2.getPassword().equals("********")) {
                        return null;
                    }
                    return new PasswordAuthentication(username, l2.getPassword().toCharArray());
                }
            }
        }
        catch (MdException ex) {
            SchedulerException se = new SchedulerException(ex.toString());
            se.initCause((Throwable)ex);
            throw se;
        }
        catch (RemoteException ex) {
            SchedulerException se = new SchedulerException(ex.toString());
            se.initCause((Throwable)ex);
            throw se;
        }
        return null;
    }

    public static PasswordAuthentication getLoginIdentity(ServerComponent server, String username) throws MdException, RemoteException {
        block6: {
            block5: {
                SessionContextInterface sessionContext = MetaUtilities.getSessionContext();
                if (sessionContext == null) break block5;
                String domain = MetaUtilities.getDomain(server);
                UserContextInterface userContext = sessionContext.getUserContext();
                if (userContext == null) break block6;
                List identities = userContext.getIdentities();
                for (UserIdentityInterface uI : identities) {
                    if (!uI.getDomain().equals(domain) || !uI.getPrincipal().equals(username) && !uI.getResolvedUserName().equals(username)) continue;
                    return new PasswordAuthentication(username, uI.getCredential().toString().toCharArray());
                }
                break block6;
            }
            AssociationList connections = server.getSourceConnections();
            if (connections.size() < 1) {
                return null;
            }
            TCPIPConnection connection = (TCPIPConnection)connections.get(0);
            AuthenticationDomain domain = connection.getDomain();
            Login l2 = null;
            if (domain != null) {
                AssociationList logins = domain.getLogins();
                for (Login l2 : logins) {
                    if (l2.getUserID().compareTo(username) != 0) continue;
                    if (l2.getPassword().equals("********")) {
                        return null;
                    }
                    return new PasswordAuthentication(username, l2.getPassword().toCharArray());
                }
            }
        }
        return null;
    }

    public static PasswordAuthentication getLoginInformation(ServerComponent server) throws MdException, RemoteException {
        MdFactory cfactory = server.getObjectStore().getFactory();
        String sDomain = MetaUtilities.getDomain(server);
        if (sDomain != null) {
            PasswordAuthentication pw = MdModelUtil.getCredential((MdFactory)cfactory, (String)sDomain, (String)MdModelUtil.getReposID((String)server.getId()));
            return pw;
        }
        return null;
    }

    public static Login getLoginInfo(ServerComponent server, String username) throws MdException, RemoteException {
        AssociationList connections = server.getSourceConnections();
        if (connections.size() < 1) {
            return null;
        }
        TCPIPConnection connection = (TCPIPConnection)connections.get(0);
        AuthenticationDomain domain = connection.getDomain();
        Login l = null;
        if (domain != null) {
            AssociationList logins = domain.getLogins();
            boolean notFound = true;
            Iterator i = logins.iterator();
            while (notFound && i.hasNext()) {
                l = (Login)i.next();
                if (l.getUserID().compareTo(username) == 0) {
                    notFound = false;
                }
                if (!l.getPassword().equals("********")) continue;
                l = null;
            }
        }
        return l;
    }

    public static Login getLoginInfo(ServerComponent server) throws MdException, RemoteException {
        MdFactoryImpl cfactory = new MdFactoryImpl();
        IOMI iOMI = cfactory.getConnection().getCMRHandle();
        AssociationList connections = server.getSourceConnections();
        if (connections.size() < 1) {
            return null;
        }
        TCPIPConnection connection = (TCPIPConnection)connections.get(0);
        AuthenticationDomain domain = connection.getDomain();
        Login l = null;
        if (domain != null) {
            ArrayList<Login> logins = new ArrayList<Login>();
            AssociationList lLoginsFromDomain = domain.getLogins();
            if (lLoginsFromDomain.size() <= 1) {
                logins.addAll((Collection<Login>)lLoginsFromDomain);
            }
            if (logins.size() == 0) {
                ISecurity iSec = null;
                if (iOMI != null) {
                    try {
                        Object obj = iOMI._duplicate();
                        ISecurity iSecurity = ISecurityHelper.narrow((Object)obj);
                        if (iSecurity == null) {
                            throw new MdException(MetaUtilities.messageString(m_bundle.getString("MetaUtilities.UnableToConnectToServer.msg.fmt"), connection.getHostName()));
                        }
                        iSec = iSecurity;
                    }
                    catch (RuntimeException e) {
                        throw new MdException((Throwable)e);
                    }
                }
                StringHolder returnStrHolder = new StringHolder();
                if (iSec != null) {
                    try {
                        iSec.GetIdentity("", returnStrHolder);
                    }
                    catch (InvalidCredHandle e) {
                        throw new MdException((Throwable)e);
                    }
                    catch (GenericError e) {
                        throw new MdException((Throwable)e);
                    }
                    catch (RuntimeException e) {
                        throw new MdException((Throwable)e);
                    }
                }
                Person iPerson = null;
                String retValue = returnStrHolder.value;
                if (retValue != null && !retValue.startsWith("UNKNOWN:") && retValue.startsWith("OMSOBJ:")) {
                    String objid = returnStrHolder.value.substring(returnStrHolder.value.lastIndexOf(47) + 1);
                    MdObjectStore store = (MdObjectStore)server.getObjectStore();
                    MdFactory factory = store.getFactory();
                    String name = "TEMPPERSON";
                    iPerson = (Person)factory.createComplexMetadataObject(store, null, name, "Person", objid, null);
                }
                if (iPerson != null) {
                    AssociationList lLoginsFromPerson = iPerson.getLogins();
                    for (int i = 0; i < lLoginsFromDomain.size(); ++i) {
                        Login iLD = (Login)lLoginsFromDomain.get(i);
                        for (int j = 0; j < lLoginsFromPerson.size(); ++j) {
                            Login iLP = (Login)lLoginsFromPerson.get(j);
                            if (!iLD.getId().equals(iLP.getId())) continue;
                            logins.add(iLP);
                        }
                    }
                } else {
                    logins.addAll((Collection<Login>)lLoginsFromDomain);
                }
            }
            if (logins.size() == 1 && (l = (Login)logins.get(0)).getPassword().equals("********")) {
                l = null;
            }
        }
        return l;
    }

    public static void setSessionContext(SessionContextInterface sessionContext) {
        m_sessionContextInterface = sessionContext;
        try {
            UserContextInterface userContext = sessionContext.getUserContext();
            if (userContext != null) {
                OMIServer server = (OMIServer)userContext.getAuthServer();
                MetaUtilities.setMdFactory(server.getMdFactory());
            } else {
                MetaUtilities.setMdFactory(null);
            }
        }
        catch (IllegalStateException e) {
            MetaUtilities.setMdFactory(null);
        }
        catch (RemoteException e) {
            MetaUtilities.setMdFactory(null);
        }
        catch (ServiceException e) {
            MetaUtilities.setMdFactory(null);
        }
    }

    public static SessionContextInterface getSessionContext() {
        SessionContextInterface sessionContext;
        MetaUtilitiesContext context = MetaUtilitiesContextHolder.getMetaUtilitiesContext();
        if (context != null && (sessionContext = context.getDefaultSessionContext()) != null) {
            return sessionContext;
        }
        return m_sessionContextInterface;
    }

    public static UserContextInterface getUserContext() {
        try {
            SessionContextInterface sessionContext;
            MetaUtilitiesContext context = MetaUtilitiesContextHolder.getMetaUtilitiesContext();
            if (context != null && (sessionContext = context.getDefaultSessionContext()) != null) {
                return sessionContext.getUserContext();
            }
            if (m_sessionContextInterface != null) {
                return m_sessionContextInterface.getUserContext();
            }
            return null;
        }
        catch (IllegalStateException ex) {
            return null;
        }
        catch (RemoteException ex) {
            return null;
        }
    }

    public static String getUserNameFromUCI(UserContextInterface uci) throws RemoteException, MdException {
        if (uci == null) {
            return null;
        }
        IdentityInterface identity = uci.getPerson();
        if (identity == null) {
            return null;
        }
        java.lang.Object obj = identity.getRepositoryEntity();
        Identity person = null;
        if (!(obj instanceof Identity)) {
            return null;
        }
        person = (Identity)obj;
        AssociationList l = person.getLogins();
        if (l.size() > 0) {
            Login login = (Login)l.get(0);
            String userID = login.getUserID();
            return userID;
        }
        return null;
    }

    public static ResponsibleParty getResposibleParty(Person person, String role) throws RemoteException, MdException {
        AssociationList logins;
        AssociationList parties = person.getResponsibilities();
        for (java.lang.Object element : parties) {
            ResponsibleParty party;
            if (!(element instanceof ResponsibleParty) || !(party = (ResponsibleParty)element).getRole().equals(role) || !party.getPersons().contains((java.lang.Object)person)) continue;
            return party;
        }
        String rpName = person.getName();
        if (rpName.length() == 0 && (logins = person.getLogins()).size() > 0) {
            Login login = (Login)logins.get(0);
            rpName = login.getUserID();
        }
        MdObjectStore store = (MdObjectStore)person.getObjectStore();
        MdFactory factory = store.getFactory();
        ResponsibleParty schedulerParty = (ResponsibleParty)factory.createComplexMetadataObject(store, null, rpName, "ResponsibleParty", person.getRepositoryID());
        schedulerParty.setRole(role);
        AssociationList persons = schedulerParty.getPersons();
        persons.add((java.lang.Object)person);
        schedulerParty.setPersons(persons);
        return schedulerParty;
    }

    public static Person createPerson(String name, MdObjectStore store, String repos) throws RemoteException {
        Person person = null;
        MdFactory factory = store.getFactory();
        int flags = 8584;
        String selectXML = "<XMLSELECT search=\"*[@Name='" + name + "']\"/>";
        try {
            List list = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, repos, "Person", flags, selectXML);
            if (list.size() == 0) {
                person = (Person)factory.createComplexMetadataObject(store, null, name, "Person", repos, null);
            } else if (list.size() > 0) {
                person = (Person)list.get(0);
            }
        }
        catch (MdException e) {
            person = null;
        }
        return person;
    }

    public static IdentityGroup getPublicGroup(MdStore store, String strReposId) throws MdException, RemoteException {
        return MetaUtilities.getIdentityGroup("PUBLIC", store, strReposId);
    }

    public static IdentityGroup getIdentityGroup(String name, MdStore store, String strReposId) throws MdException, RemoteException {
        MdFactory factory = store.getFactory();
        String publicIdentityOptions = "<XMLSELECT search=\"@Name = '" + name + "'\"/>";
        int flags = 268444032;
        List identityGroups = factory.getOMIUtil().getMetadataObjectsSubset(store, strReposId, "IdentityGroup", flags, publicIdentityOptions, false);
        if (identityGroups.size() > 0) {
            return (IdentityGroup)identityGroups.get(0);
        }
        return null;
    }

    public static Permission getPermission(MdStore store, String strReposId, String name, String type) throws MdException, RemoteException {
        MdFactory factory = store.getFactory();
        String permissionOptions = "<XMLSELECT search=\"@Name = '" + name + "' AND @Type ='" + type + "'\"/>";
        int flags = 268444032;
        List permissions = factory.getOMIUtil().getMetadataObjectsSubset(store, strReposId, "Permission", flags, permissionOptions, false);
        if (permissions.size() > 0) {
            return (Permission)permissions.get(0);
        }
        return null;
    }

    public static Identity getIdentity(MdStore store, String strReposId, String identity) throws MdException, RemoteException {
        MdFactory factory = store.getFactory();
        String permissionOptions = "<XMLSELECT search=\"@Id = '" + identity + "'\"/>";
        int flags = 268444048;
        List persons = factory.getOMIUtil().getMetadataObjectsSubset(store, strReposId, "Identity", flags, permissionOptions, false);
        if (persons.size() > 0) {
            return (Identity)persons.get(0);
        }
        return null;
    }

    public static FolderNode findNode(DefaultMutableTreeNode node, Tree folder) {
        if (node instanceof FolderNode) {
            FolderNode fnode = (FolderNode)node;
            Tree tfolder = (Tree)fnode.getUserObject();
            try {
                if (folder.getId().compareTo(tfolder.getId()) == 0) {
                    return fnode;
                }
                for (int x = 0; x < fnode.getChildCount(); ++x) {
                    DefaultMutableTreeNode cnode = (DefaultMutableTreeNode)fnode.getChildAt(x);
                    FolderNode tnode = MetaUtilities.findNode(cnode, folder);
                    if (tnode == null) continue;
                    return tnode;
                }
                return null;
            }
            catch (RemoteException re) {
                return null;
            }
        }
        if (node instanceof RepositoryNode) {
            RepositoryNode rnode = (RepositoryNode)node;
            for (int x = 0; x < rnode.getChildCount(); ++x) {
                DefaultMutableTreeNode cnode = (DefaultMutableTreeNode)rnode.getChildAt(x);
                FolderNode tnode = MetaUtilities.findNode(cnode, folder);
                if (tnode == null) continue;
                return tnode;
            }
            return null;
        }
        for (int x = 0; x < node.getChildCount(); ++x) {
            DefaultMutableTreeNode cnode = (DefaultMutableTreeNode)node.getChildAt(x);
            FolderNode tnode = MetaUtilities.findNode(cnode, folder);
            if (tnode == null) continue;
            return tnode;
        }
        return null;
    }

    public static List<java.lang.Object> getRootFolders(MdObjectStore store, SoftwareComponent sc) throws MdException, RemoteException {
        MdFactory factory = store.getFactory();
        SoftwareComponent comp = (SoftwareComponent)factory.getOMIUtil().getMetadataAllDepths((MdStore)store, "SoftwareComponent", sc.getId(), null, SOFTWARETREES_LIST, "", 264, false);
        TreeSet<java.lang.Object> treeset = new TreeSet<java.lang.Object>(new CompareJOMAObjects());
        treeset.addAll((Collection<java.lang.Object>)comp.getSoftwareTrees());
        java.lang.Object[] alist = treeset.toArray();
        Vector<java.lang.Object> list = new Vector<java.lang.Object>();
        for (int i = 0; i < alist.length; ++i) {
            list.add(alist[i]);
        }
        return list;
    }

    public static List<java.lang.Object> getSubFolders(MdObjectStore store, Tree tree) throws MdException, RemoteException {
        MdFactory factory = store.getFactory();
        Tree t = (Tree)factory.getOMIUtil().getMetadataAllDepths((MdStore)store, "Tree", tree.getId(), null, SUBTREES_LIST, "", 264, false);
        TreeSet<java.lang.Object> treeset = new TreeSet<java.lang.Object>(new CompareJOMAObjects());
        treeset.addAll((Collection<java.lang.Object>)t.getSubTrees());
        java.lang.Object[] alist = treeset.toArray();
        Vector<java.lang.Object> list = new Vector<java.lang.Object>();
        for (int i = 0; i < alist.length; ++i) {
            list.add(alist[i]);
        }
        return list;
    }

    public static void setOMRDefaultFolder(String folder) {
        m_OMRDefaultFolder = folder;
    }

    public static String getOMRDefaultFolder() {
        return m_OMRDefaultFolder;
    }

    public static boolean isDebug() {
        String debug = System.getProperty("Debug");
        return debug != null;
    }

    public static boolean isAllowPasswordCache() {
        try {
            int flags = 392;
            MdObjectStore objectStore = MetaUtilities.getDefaultStore();
            MdFactory factory = objectStore.getFactory();
            MdRepositoryUtilImpl reposUtil = new MdRepositoryUtilImpl(factory);
            String repositoryFQID = reposUtil.getRepositoryIDFromName("foundation");
            String xmlSelect = "<XMLSELECT search=\"@Name = 'SAS Application Infrastructure'\"/>";
            List softwareComponents = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)objectStore, repositoryFQID, "SoftwareComponent", flags, xmlSelect, false);
            int count = softwareComponents.size();
            if (count == 1) {
                SoftwareComponent sc = (SoftwareComponent)softwareComponents.get(0);
                AssociationList list = sc.getPropertySets();
                for (java.lang.Object obj : list) {
                    PropertySet ps;
                    if (!(obj instanceof PropertySet) || !(ps = (PropertySet)obj).getName().equals("Application Configuration")) continue;
                    AssociationList plist = ps.getSetProperties();
                    for (java.lang.Object o : plist) {
                        Property p;
                        if (!(o instanceof Property) || !(p = (Property)o).getName().equals("Policy.AllowClientPasswordStorage")) continue;
                        String v = p.getDefaultValue().toUpperCase();
                        return v.equals("TRUE");
                    }
                }
            }
        }
        catch (RemoteException e) {
            return true;
        }
        catch (MdException e) {
            return true;
        }
        return true;
    }

    public static void setAppServerResource(boolean flag) {
        block6: {
            if (flag) {
                String GRIDSERVER = "D7E796B4-654C-4ab3-B690-657EE79309FB";
                try {
                    String repos = m_defaultMdFactory.getOMIUtil().getFoundationReposID();
                    String strSelect = "<XMLSELECT search=\"*[@ClassIdentifier='D7E796B4-654C-4ab3-B690-657EE79309FB']\" />";
                    List list = m_defaultMdFactory.getOMIUtil().getMetadataObjectsSubset((MdStore)m_defaultMdStore, repos, "ServerComponent", 8584, strSelect);
                    if (list.size() > 0) {
                        m_LSFAppServerResource = true;
                        break block6;
                    }
                    m_LSFAppServerResource = false;
                }
                catch (MdException ex) {
                    m_LSFAppServerResource = false;
                }
                catch (RemoteException ex) {
                    m_LSFAppServerResource = false;
                }
            } else {
                m_LSFAppServerResource = false;
            }
        }
    }

    public static boolean isAppServerResource() {
        return m_LSFAppServerResource;
    }

    public static boolean isAppServerResource(MdStore store, String repos) {
        String GRIDSERVER = "D7E796B4-654C-4ab3-B690-657EE79309FB";
        try {
            MdFactory factory = store.getFactory();
            String strSelect = "<XMLSELECT search=\"*[@ClassIdentifier='D7E796B4-654C-4ab3-B690-657EE79309FB']\" />";
            List list = factory.getOMIUtil().getMetadataObjectsSubset(store, repos, "ServerComponent", 8584, strSelect);
            if (list.size() > 0) {
                return m_LSFAppServerResource;
            }
            return false;
        }
        catch (MdException ex) {
            return m_LSFAppServerResource;
        }
        catch (RemoteException ex) {
            return m_LSFAppServerResource;
        }
    }

    public static void setPortableTimeEvent(boolean flag) {
        m_portableTimeEvent = flag;
    }

    public static boolean usePortableTimeEvent() {
        return m_portableTimeEvent;
    }

    public static Tree getDefaultFolder(MdObjectStore store, String repos) throws MdException, RemoteException, NotFound, NoContext {
        return MetaUtilities.getFolder(m_OMRDefaultFolder, store, repos);
    }

    public static Tree getFolder(String name, MdObjectStore store, String repos) throws MdException, RemoteException, NotFound, NoContext {
        if (name == null) {
            return null;
        }
        String folder = name;
        String path = "/";
        int lastslash = name.lastIndexOf("/");
        if (lastslash > -1) {
            folder = name.substring(lastslash + 1);
            path = name.substring(0, lastslash);
        }
        SASFolder sasfolder = new SASFolder(folder, path);
        return MetaUtilities.getFolder(sasfolder, store, repos);
    }

    public static Tree getFolder(SASFolder sasfolder, MdObjectStore store, String repos) throws MdException, RemoteException, NotFound, NoContext {
        int flags = 392;
        MdFactory factory = store.getFactory();
        Tree tree = null;
        if (sasfolder.getLocation().compareTo(m_bundle.getString("MetaUtilities.MyFolder.Name.txt")) == 0 || sasfolder.getLocation().compareTo("/My Folder") == 0) {
            String template = null;
            String user = null;
            MdOMRConnection connection = factory.getConnection();
            Identity identity = connection.getIdentityOfUserConnected((MdStore)store, repos);
            if (identity != null) {
                user = identity.getName();
            }
            tree = factory.getOMIUtil().getUserHomeFolder(store, user, "My Folder", template, flags);
            sasfolder.setLocation(MetaUtilities.getFolderLocation(tree));
        } else {
            String name = sasfolder.getName();
            String folder = name.substring(name.lastIndexOf("/") + 1);
            String xmlSelect = "<XMLSELECT search=\"@Name = '" + folder + "'\"/>";
            ArrayList trees = new ArrayList();
            Iterator iter = factory.getOMIUtil().getRepositories().iterator();
            while (iter.hasNext()) {
                String repository = ((CMetadata)iter.next()).getId();
                trees.addAll(factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, repository, "Tree", flags, xmlSelect, false));
            }
            int count = trees.size();
            for (int i = 0; i < count; ++i) {
                Tree nexttree = (Tree)trees.get(i);
                String folderLocation = MetaUtilities.getFolderLocation(nexttree);
                if (folderLocation == null || folderLocation.compareTo(sasfolder.toString()) != 0) continue;
                tree = nexttree;
                break;
            }
            if (tree == null) {
                if (count > 1) {
                    String repname = MetaUtilities.getRepositoryName(repos);
                    if (repname == null || repname.length() == 0) {
                        repname = repos;
                    }
                    java.lang.Object[] parms = new java.lang.Object[]{repname, sasfolder.toString()};
                    String msg = MessageFormat.format(m_bundle.getString("MetaUtilities.Error.MultipleFolders.fmt"), parms);
                    throw new NoContext(msg);
                }
                NameComponent[] nameComponent = new NameComponent[]{new NameComponent(sasfolder.toString(), "Tree")};
                NotFound ex = new NotFound(NotFoundReason.missing_node, nameComponent);
                String repname = MetaUtilities.getRepositoryName(repos);
                if (repname == null || repname.length() == 0) {
                    repname = repos;
                }
                java.lang.Object[] parms = new java.lang.Object[]{repname, sasfolder.toString()};
                String msg = MessageFormat.format(m_bundle.getString("MetaUtilities.Error.MissingFolder.fmt"), parms);
                NoContext nce = new NoContext(msg);
                nce.initCause((Throwable)ex);
                throw nce;
            }
        }
        return tree;
    }

    public static Tree createFolder(SoftwareComponent sc, String folder, MdObjectStore objectStore) throws RemoteException, MdException {
        String BIP_FOLDER = "BIP Folder";
        MdFactory factory = objectStore.getFactory();
        Tree tree = (Tree)factory.createComplexMetadataObject(objectStore, null, folder, "Tree", sc.getRepositoryID());
        tree.setTreeType(BIP_FOLDER);
        tree.getSoftwareComponents().add((java.lang.Object)sc);
        return tree;
    }

    public static boolean createDefaultFolder() throws RemoteException, MdException {
        if (OMR_FOLDER_DEFAULT.lastIndexOf("/") > 0) {
            return false;
        }
        String folder = OMR_FOLDER_DEFAULT.substring(OMR_FOLDER_DEFAULT.lastIndexOf("/") + 1);
        boolean created = false;
        boolean debug = MetaUtilities.isDebug();
        if (m_sessionContextInterface != null) {
            try {
                UserContextInterface user = m_sessionContextInterface.getUserContext();
                if (user != null) {
                    OMIServer server = (OMIServer)user.getAuthServer();
                    FolderInterface newfolder = server.getRootFolder().makeSubfolder(folder);
                    if (newfolder != null) {
                        newfolder.update();
                        created = true;
                    } else if (debug) {
                        RuntimeException e = new RuntimeException("NO FOLDER");
                        e.printStackTrace();
                    }
                } else if (debug) {
                    RuntimeException e = new RuntimeException("NO USERCONTEXT");
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                if (debug) {
                    e.printStackTrace();
                }
                created = false;
            }
        }
        return created;
    }

    public static SoftwareComponent locateSoftwareComponent(String repositoryFQID, MdObjectStore objectStore) throws MdException, RemoteException {
        int flags = 392;
        MdFactory factory = objectStore.getFactory();
        String OMR_NAME_BIP_SERVICE = "BIP Service";
        String BIP_SERVICE_CLASSID = "E5F27790-2149-11D6-8828-AA0004006D06";
        String xmlSelect = "<XMLSELECT search=\"@ClassIdentifier = '" + BIP_SERVICE_CLASSID + "' and @Name = '" + OMR_NAME_BIP_SERVICE + "'\"/>";
        List softwareComponents = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)objectStore, repositoryFQID, "SoftwareComponent", flags, xmlSelect, false);
        int count = softwareComponents.size();
        if (count == 1) {
            return (SoftwareComponent)softwareComponents.get(0);
        }
        String name = MetaUtilities.getRepositoryName(repositoryFQID);
        if (name == null || name.length() == 0) {
            name = repositoryFQID;
        }
        java.lang.Object[] parms = new java.lang.Object[]{name};
        if (count == 0) {
            String msg = MessageFormat.format(m_bundle.getString("MetaUtilities.Error.MultipleBIP.fmt"), parms);
            throw new MdException(msg);
        }
        String msg = MessageFormat.format(m_bundle.getString("MetaUtilities.Error.MissingBIP.fmt"), parms);
        throw new MdException(msg);
    }

    public static String getFolderLocation(SASFolder finfo, MdObjectStore store, String repos) throws RemoteException, MdException {
        try {
            Tree folder = MetaUtilities.getFolder(finfo.getName(), store, repos);
            return MetaUtilities.getFolderLocation(folder);
        }
        catch (NotFound e) {
            e.printStackTrace();
        }
        catch (NoContext e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getFolderLocation(Tree folder) throws RemoteException, MdException {
        ArrayList<String> folders = new ArrayList<String>();
        folders.add(0, folder.getName());
        for (Tree node = folder.getParentTree(); node != null; node = node.getParentTree()) {
            folders.add(0, node.getName());
        }
        StringBuffer path = new StringBuffer();
        int numPaths = folders.size();
        for (int x = 0; x < numPaths; ++x) {
            path.append("/");
            path.append((String)folders.get(x));
        }
        return path.toString();
    }

    static {
        m_OMRDefaultFolder = OMR_FOLDER_DEFAULT;
        m_LSFAppServerResource = false;
        m_portableTimeEvent = false;
        INVALIDCHARACTERS = SchedulerIMPL.INVALIDCHARACTERS;
        INVALIDFILENAMECHARACTERS = SchedulerIMPL.INVALIDFILENAMECHARACTERS;
        INVALIDFLOWNAMECHARACTERS = SchedulerIMPL.INVALIDFLOWNAMECHARACTERS;
        INVALIDJOBNAMECHARACTERS = SchedulerIMPL.INVALIDJOBNAMECHARACTERS;
        SUBCHAR = SchedulerIMPL.SUBCHAR;
        SOFTWARETREES_LIST = new ArrayList<String>(1);
        SOFTWARETREES_LIST.add("SoftwareTrees");
        SUBTREES_LIST = new ArrayList<String>(1);
        SUBTREES_LIST.add("SubTrees");
    }
}

