/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.oma;

import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.api.servers.Scheduler;
import com.sas.scheduler.model.AbstractEventInterface;
import com.sas.scheduler.model.FileEventInfo;
import com.sas.scheduler.model.GeneralUtilities;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.SchedulerServerInfo;
import java.security.InvalidParameterException;
import java.util.Locale;
import java.util.ResourceBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class FileEvent
implements AbstractEventInterface {
    private static final ResourceBundle m_bundle = MetaUtilities.getMyResourceBundle(FileEvent.class);
    private Scheduler m_scheduler = null;
    private String m_schedulerID = null;
    private String m_filename = null;
    private int m_type = -1;
    private int m_operator = -1;
    private long m_value = 0L;
    private String m_description;

    public FileEvent() {
    }

    public FileEvent(Scheduler scheduler, String definition) {
        this.initFromDefinition(scheduler, definition);
    }

    public FileEvent(FileEventInfo info) {
        this(FileEvent.getSchedulerID(info), info.getFileName(), info.getEventType(), info.getOperator(), info.getValue());
    }

    private static String getSchedulerID(FileEventInfo info) {
        SchedulerServerInfo sch = info.getScheduler();
        String classid = null;
        if (sch != null) {
            classid = sch.getClassId();
        }
        if (classid != null && classid.length() > 0) {
            return classid;
        }
        return "8b4dc45a-f7c7-11e7-8c3f-9a214cf093ae";
    }

    public FileEvent(String schedulerID, String fileName, int type, int operator, long value) {
        this.m_schedulerID = schedulerID;
        this._initialize(fileName, type, operator, value);
    }

    private void _initialize(String fileName, int type, int operator, long value) {
        int max = 1;
        SchedulerServerInfo sch = new SchedulerServerInfo(null, this.m_schedulerID);
        if (sch.isEnterpriseLevelSupportOfFileEvents()) {
            max = 3;
        }
        if (type < 0) {
            String message = MetaUtilities.messageString(m_bundle.getString("FileEvent.InvalidType.fmt"), FileEventInfo.getTypeString((int)type, (long)value));
            InvalidParameterException ex = new InvalidParameterException(message);
            throw ex;
        }
        if (type > max) {
            String message = MetaUtilities.messageString(m_bundle.getString("FileEvent.UnsupportedType.fmt"), FileEventInfo.getTypeString((int)type, (long)value));
            InvalidParameterException ex = new InvalidParameterException(message);
            throw ex;
        }
        if (!(type != 1 && type != 3 || operator >= 21 && operator <= 27)) {
            InvalidParameterException ex = new InvalidParameterException(MetaUtilities.messageString(m_bundle.getString("FileEvent.InvalidOperator.fmt"), String.valueOf(operator)));
            throw ex;
        }
        this.m_filename = fileName;
        this.m_type = type;
        this.m_operator = operator;
        this.m_value = value;
    }

    public FileEventInfo getInfo() {
        SchedulerServerInfo sinfo = null;
        try {
            if (this.m_scheduler != null) {
                sinfo = new SchedulerServerInfo(this.m_scheduler.getName(), this.m_scheduler.getClassId());
            } else if (this.m_schedulerID != null) {
                sinfo = new SchedulerServerInfo(this.m_schedulerID);
            }
        }
        catch (NullPointerException se) {
            sinfo = null;
        }
        catch (SchedulerException se) {
            // empty catch block
        }
        FileEventInfo info = new FileEventInfo(sinfo, this.m_filename, this.m_type, this.m_operator, this.m_value);
        info.setDescription(this.m_description);
        return info;
    }

    public FileEventInfo getInfo(SchedulerServerInfo sinfo) {
        FileEventInfo info = new FileEventInfo(sinfo, this.m_filename, this.m_type, this.m_operator, this.m_value);
        return info;
    }

    public String toString() {
        return FileEventInfo.toString((String)this.m_filename, (int)this.m_type, (int)this.m_operator, (long)this.m_value, (Locale)Locale.getDefault());
    }

    public String toString(Locale locale) {
        return FileEventInfo.toString((String)this.m_filename, (int)this.m_type, (int)this.m_operator, (long)this.m_value, (Locale)locale);
    }

    public boolean initFromDefinition(Scheduler scheduler, String content) {
        FileEventInfo fei = new FileEventInfo();
        if (fei.initFromDefinition(content)) {
            this.m_scheduler = scheduler;
            this.m_filename = fei.getFileName();
            this.m_type = fei.getEventType();
            this.m_operator = fei.getOperator();
            this.m_value = fei.getValue();
            return true;
        }
        return false;
    }

    public boolean initFromCondition(Scheduler scheduler, String conditionString) {
        String filename = null;
        int type = -1;
        int operator = -1;
        long value = 0L;
        if (scheduler != null) {
            filename = scheduler.getFileNameFromConditionString(conditionString);
            type = scheduler.getFileTypeFromConditionString(conditionString);
            operator = scheduler.getFileOperatorFromConditionString(conditionString);
            value = scheduler.getFileValueFromConditionString(conditionString);
        } else {
            FileEventInfo fei = new FileEventInfo();
            if (fei.initFromDefinition(conditionString)) {
                filename = fei.getFileName();
                type = fei.getEventType();
                operator = fei.getOperator();
                value = fei.getValue();
            }
        }
        if (type == -1) {
            type = FileEventInfo.getFileTypeFromConditionString((String)conditionString);
            operator = FileEventInfo.getFileOperatorFromConditionString((String)conditionString);
            value = FileEventInfo.getFileValueFromConditionString((String)conditionString);
        }
        if (filename == null || type == -1) {
            return false;
        }
        this.m_scheduler = scheduler;
        this.m_filename = filename;
        this.m_type = type;
        this.m_operator = operator;
        this.m_value = value;
        this.m_description = conditionString;
        return true;
    }

    public String getFileName() {
        return this.m_filename;
    }

    public int getEventType() {
        return this.m_type;
    }

    public int getOperator() {
        return this.m_operator;
    }

    public String getOperatorString() {
        return GeneralUtilities.getOperatorString((int)this.m_operator);
    }

    public long getValue() {
        return this.m_value;
    }

    public String generateDefinition() {
        if (this.m_filename == null) {
            return "";
        }
        if (this.m_type == -1) {
            return "";
        }
        FileEventInfo fei = new FileEventInfo(this.m_filename, this.m_type, this.m_operator, this.m_value);
        return fei.generateDefinition();
    }

    public void initFromXML(String xml) throws SchedulerException {
        Document doc = GeneralUtilities.parseXML((String)xml);
        Node node = doc.getElementsByTagName("Event").item(0);
        FileEventInfo fei = new FileEventInfo();
        fei.initFromNode(node);
        this._initialize(fei.getFileName(), fei.getEventType(), fei.getOperator(), fei.getValue());
    }

    public String generateXML() {
        FileEventInfo fei = new FileEventInfo(this.m_filename, this.m_type, this.m_operator, this.m_value);
        return fei.generateXML();
    }

    public String generateXML(boolean exportFormat) {
        return this.generateXML();
    }

    public boolean setDescription(String sDescription) {
        this.m_description = sDescription;
        return true;
    }

    public String getDescription() {
        return this.m_description;
    }
}

