/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.oma;

import com.sas.iom.SAS.IFileService;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.meta.SASOMI.ISecurityPackage.InvalidCredHandle;
import com.sas.meta.SASOMI.ISecurity_1_1;
import com.sas.metadata.remote.AccessControlEntry;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.Event;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.Identity;
import com.sas.metadata.remote.IdentityGroup;
import com.sas.metadata.remote.JFJob;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.Login;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryImpl;
import com.sas.metadata.remote.MdOMRConnection;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Permission;
import com.sas.metadata.remote.Person;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.ResponsibleParty;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.StepPrecedence;
import com.sas.metadata.remote.SyncStep;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.metadata.remote.Text;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.TransformationActivity;
import com.sas.metadata.remote.TransformationStep;
import com.sas.metadata.remote.Tree;
import com.sas.scheduler.api.oma.CommandUtilities;
import com.sas.scheduler.api.oma.DeployedFlow;
import com.sas.scheduler.api.oma.ExportJobDefinition;
import com.sas.scheduler.api.oma.JobEvent;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.api.servers.IWorkspaceServer;
import com.sas.scheduler.api.servers.sasprocs.submitSAS;
import com.sas.scheduler.model.BatchServerInfo;
import com.sas.scheduler.model.DirectoryInfo;
import com.sas.scheduler.model.DisplayInfo;
import com.sas.scheduler.model.FileInfo;
import com.sas.scheduler.model.JobInfo;
import com.sas.scheduler.model.SchedulerException;
import com.sas.services.ServiceException;
import com.sas.services.connection.FatalConnectionFactoryException;
import com.sas.services.connection.InvalidCredentialsException;
import com.sas.services.information.metadata.IdentityInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.CallbackCancelledException;
import com.sas.services.user.UserContextInterface;
import java.rmi.RemoteException;
import java.security.InvalidParameterException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.omg.CORBA.StringHolder;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.PortableServer.CurrentPackage.NoContext;

public class DeployedJob {
    private static final ResourceBundle m_bundle = MetaUtilities.getMyResourceBundle(DeployedJob.class);
    private static final Logger LOGGER = LogManager.getLogger(DeployedJob.class);
    private Job m_job;
    private JFJob m_jfjob;
    private TransformationStep m_step;
    private MdFactory m_factory;
    private MdObjectStore m_store;
    private String m_reposID = null;
    private ServerComponent m_batchserver;
    private UserContextInterface m_userContext = null;
    private File m_source = null;
    private File m_jcl = null;
    private String m_deployDir = null;
    private List<String> m_matchLogList = null;
    public static final String JCL_EXTENSION = ".jcl";
    public static final String CMD_EXTENSION = ".in";
    private static final int Validation_Normal = 0;
    private static final int Validation_RequiresSourceFile = 1;
    private static final int Validation_RequiresSource_N_JCL = 2;
    private static final int Validation_RequiresJCL = 3;
    private int m_val_level = 0;
    private int m_errorFlag = 0;
    public static final int MISSING_TRANSFORMATION = 1;
    private static final int CLEAR_MISSING_TRANSFORMATION_ERROR = 0x11111110;
    public static final int MISSING_BATCH_SERVER = 16;
    private static final int CLEAR_MISSING_BATCH_SERVER_ERROR = 0x11111101;
    public static final int INVALID_SOURCE_FILE = 256;
    private static final int CLEAR_INVALID_SOURCE_FILE_ERROR = 0x11111011;
    public static final int INVALID_JCL_FILE = 4096;
    private static final int CLEAR_INVALID_JCL_FILE_ERROR = 0x11110111;
    public static final int INVALID_BATCH_SERVER = 65536;
    private static final int CLEAR_INVALID_BATCH_SERVER_ERROR = 0x11101111;
    public static final String ResponsiblePartyRole = "Reporting_Scheduler_Job_Owner";
    public static final String ResponsiblePartyModifiedRole = "Modified By";

    public DeployedJob(JFJob djob) throws MdException, RemoteException {
        this.m_step = null;
        this.m_jfjob = djob;
        this._initialize();
        this._setJobAndBatch(false);
        this.validateData();
    }

    public DeployedJob(JobInfo jobinfo, MdObjectStore store, String repos) throws MdException, RemoteException {
        this(jobinfo, null, store, repos);
    }

    public String replaceCommandLineArgs(String args) throws RemoteException {
        if (args == null) {
            return null;
        }
        if (!this.m_jfjob.isNewObject()) {
            args = args.replace("%%JFJobID%%", this.m_jfjob.getFQID());
        }
        return args;
    }

    public DeployedJob(JobInfo jobinfo, String flowname, MdObjectStore store, String repos) throws MdException, RemoteException {
        this.m_step = null;
        String reposID = "A0000001." + (repos.length() > 8 ? repos.substring(9) : repos);
        String fqid = jobinfo.getId();
        if (fqid == null || fqid.trim().length() == 0) {
            if (jobinfo.getSourceFile() != null) {
                Directory dir = MetaUtilities.getDirectory(jobinfo.getBatchServer(), jobinfo.getSourceDir().getPath(), (MdStore)store, reposID);
                ServerComponent batchserver = MetaUtilities.getBatchServerComponent(jobinfo.getBatchServer(), (MdStore)store, reposID);
                if (jobinfo.getOriginalSourceFileDataBinding() != null) {
                    int targetOS = CommandUtilities.getTargetOSForBatchServer(batchserver);
                    String originalFile = CommandUtilities.createFullPath(jobinfo.getOriginalSourceFileDataBinding().getPath(), jobinfo.getOriginalSourceFileDataBinding().getName(), targetOS);
                    File origSource = MetaUtilities.createFileObject(originalFile, dir, store, repos);
                    ServerComponent sc = CommandUtilities.getWorkspaceServerComponentFromBatchServer(batchserver);
                    this.m_job = MetaUtilities.createUserWrittenJobObject(jobinfo.getName(), origSource, sc, store, repos);
                } else {
                    this.m_job = MetaUtilities.createJobObject(jobinfo.getName(), store, repos);
                }
                this.m_source = MetaUtilities.createFileObject(jobinfo.getSourceFile(), dir, store, repos);
            } else {
                this.m_job = MetaUtilities.createJobObject(jobinfo.getName(), store, repos);
            }
            List<ServerComponent> batchservers = null;
            int batch_subtype = jobinfo.getBatchServerSubtype();
            batchservers = batch_subtype > 0 ? MetaUtilities.getBatchServers(jobinfo.getBatchServerType(), batch_subtype, (MdStore)store, reposID) : MetaUtilities.getBatchServers(jobinfo.getBatchServerType(), (MdStore)store, reposID);
            this.m_batchserver = batchservers.size() > 0 ? batchservers.get(0) : null;
            this._initialize();
            SessionContextInterface session = MetaUtilities.getSessionContext();
            if (session != null) {
                this.m_userContext = session.getUserContext();
            }
            this.createJFJobObject();
            jobinfo.setId(this.m_jfjob.getId());
            try {
                Tree folder = MetaUtilities.getFolder(jobinfo.getLocation(), store, reposID);
                this.setFolder(folder);
            }
            catch (NotFound nf) {
                this.m_factory.getUtil().printOutputln(nf.getLocalizedMessage());
            }
            catch (NoContext e) {
                this.m_factory.getUtil().printOutputln(e.getLocalizedMessage());
            }
        } else {
            RuntimeException e;
            block116: {
                if (ExportJobDefinition.isIdBlanked(fqid)) {
                    try {
                        String tmp = ExportJobDefinition.getFlowIdFromBlankedJobId(fqid);
                        JFJob flow = MetaUtilities.getJFJob(tmp, "<Templates><JFJob><JobActivities/><ComputeLocations/><TargetSpecifications/><Properties/><Trees/><Steps/><AssociatedJob/><SourceCode/><SourceSpecifications/></JFJob><TransformationActivity><Steps/></TransformationActivity><SyncStep><SuccessorDependencies/><PredecessorDependencies/><TriggeredEvents/><TriggeringEvents/></SyncStep><Event><Properties/></Event><TransformationStep><Properties/><SuccessorDependencies/><PredecessorDependencies/><Transformations/></TransformationStep></Templates>", (MdStore)store, reposID);
                        if (flow != null) {
                            HashMap<String, String> jobs = DeployedFlow.getJobNamesList(flow);
                            if (jobs.containsKey(jobinfo.getName())) {
                                fqid = jobs.get(jobinfo.getName());
                                this.m_jfjob = MetaUtilities.getJFJob(fqid, "<Templates><JFJob><ComputeLocations/><TargetSpecifications/><Properties/><Trees/><AssociatedJob/><SourceCode/><SourceSpecifications/></JFJob></Templates>", (MdStore)store, reposID);
                                jobinfo.setId(fqid);
                            } else {
                                this.m_jfjob = MetaUtilities.getJFJobByNameLocationRole(jobinfo.getName(), jobinfo.getLocation(), "SCHEDULER_JOB", "<Templates><JFJob><ComputeLocations/><TargetSpecifications/><Properties/><Trees/><AssociatedJob/><SourceCode/><SourceSpecifications/></JFJob></Templates>", (MdStore)store, reposID);
                                if (this.m_jfjob != null) {
                                    jobinfo.setId(this.m_jfjob.getId());
                                }
                            }
                        } else {
                            this.m_jfjob = MetaUtilities.getJFJobByNameLocationRole(jobinfo.getName(), jobinfo.getLocation(), "SCHEDULER_JOB", "<Templates><JFJob><ComputeLocations/><TargetSpecifications/><Properties/><Trees/><AssociatedJob/><SourceCode/><SourceSpecifications/></JFJob></Templates>", (MdStore)store, reposID);
                            if (this.m_jfjob != null) {
                                jobinfo.setId(this.m_jfjob.getId());
                            }
                        }
                    }
                    catch (SchedulerException ex) {
                        this.m_jfjob = MetaUtilities.getJFJobByNameLocationRole(jobinfo.getName(), jobinfo.getLocation(), "SCHEDULER_JOB", "<Templates><JFJob><ComputeLocations/><TargetSpecifications/><Properties/><Trees/><AssociatedJob/><SourceCode/><SourceSpecifications/></JFJob></Templates>", (MdStore)store, reposID);
                        if (this.m_jfjob != null) {
                            jobinfo.setId(this.m_jfjob.getId());
                            break block116;
                        }
                        RuntimeException e2 = new RuntimeException("Internal Error: " + fqid);
                        e2.printStackTrace();
                    }
                } else if (fqid.indexOf("$") > 0) {
                    Exception ex = new Exception();
                    this.m_factory.getUtil().printOutputln("Second initialization of " + jobinfo + ex.getStackTrace()[0].toString() + "\n" + ex.getStackTrace()[1].toString() + "\n" + ex.getStackTrace()[2].toString());
                } else if (!this.isInvalid(fqid)) {
                    this.m_jfjob = MetaUtilities.getJFJobByNameLocationRole(jobinfo.getName(), jobinfo.getLocation(), "SCHEDULER_JOB", "<Templates><JFJob><ComputeLocations/><TargetSpecifications/><Properties/><Trees/><AssociatedJob/><SourceCode/><SourceSpecifications/></JFJob></Templates>", (MdStore)store, reposID);
                    if (this.m_jfjob != null) {
                        jobinfo.setId(this.m_jfjob.getId());
                    } else {
                        e = new RuntimeException("Internal Error: " + fqid);
                        this.m_factory.getUtil().printOutputln(e.getStackTrace()[0].toString() + "\n" + e.getStackTrace()[1].toString() + "\n" + e.getStackTrace()[2].toString());
                    }
                } else {
                    try {
                        this.m_jfjob = MetaUtilities.getJFJob(fqid, "<Templates><JFJob><ComputeLocations/><TargetSpecifications/><Properties/><Trees/><AssociatedJob/><SourceCode/><SourceSpecifications/></JFJob></Templates>", (MdStore)store, reposID);
                    }
                    catch (SchedulerException e3) {
                        RuntimeException ex = new RuntimeException("Internal Error: " + fqid);
                        ex.initCause(e3);
                        ex.printStackTrace();
                        this.m_jfjob = null;
                    }
                }
            }
            this._initialize();
            try {
                this.m_job = (Job)this.m_jfjob.getAssociatedJobs().get(0);
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                DisplayInfo j = jobinfo.getJob();
                if (j != null) {
                    this.m_job = MetaUtilities.getAssociatedJob(j.getId(), (MdStore)store, reposID);
                    if (this.m_job != null) {
                        this.m_jfjob.setAssociatedJob(this.m_job);
                    } else {
                        this.m_job = null;
                    }
                } else {
                    this.m_job = null;
                }
            }
            catch (NullPointerException ex) {
                this.m_job = null;
            }
            if (this.m_jfjob != null) {
                if (jobinfo.getName() != null && jobinfo.getName().length() > 0 && !jobinfo.getName().equals(this.m_jfjob.getName())) {
                    this.m_jfjob.setName(jobinfo.getName());
                }
                if (jobinfo.getDescription() != null && jobinfo.getDescription().length() > 0 && !jobinfo.getDescription().equals(this.m_jfjob.getDesc())) {
                    this.m_jfjob.setDesc(jobinfo.getDescription());
                }
            } else if (MetaUtilities.isDebug()) {
                e = new RuntimeException("Internal Error: " + jobinfo.toString());
                this.m_factory.getUtil().printOutputln(e.getStackTrace()[0].toString() + "\n" + e.getStackTrace()[1].toString() + "\n" + e.getStackTrace()[2].toString());
            }
            if (!jobinfo.isSubflow()) {
                String curparty;
                String path;
                Directory dir;
                String newEncodedArgs;
                String encodedArgs;
                String newJobArgs;
                ServerComponent batchserver = CommandUtilities.getServerComponentForJob(this.m_jfjob);
                BatchServerInfo bsinfo = null;
                bsinfo = batchserver != null ? MetaUtilities.getBatchServer(batchserver) : new BatchServerInfo(null, -2, 0);
                if (jobinfo.getBatchServerType() == -1) {
                    this.m_batchserver = batchserver;
                    jobinfo.setBatchServer(bsinfo);
                } else if (jobinfo.getBatchServer() != null && jobinfo.getBatchServer().getId() != null) {
                    if (jobinfo.getBatchServer().getType() != bsinfo.getType() || jobinfo.getBatchServerSubtype() != bsinfo.getSubType()) {
                        List<ServerComponent> batchservers = null;
                        int batch_subtype = jobinfo.getBatchServerSubtype();
                        batchservers = batch_subtype > 0 ? MetaUtilities.getBatchServers(jobinfo.getBatchServerType(), batch_subtype, (MdStore)store, reposID) : MetaUtilities.getBatchServers(jobinfo.getBatchServerType(), (MdStore)store, reposID);
                        if (batchservers.size() > 0) {
                            this.setBatchServer(batchservers.get(0));
                        } else {
                            this.m_batchserver = null;
                        }
                    } else if (jobinfo.getBatchServer().getId().compareTo(bsinfo.getId()) != 0) {
                        batchserver = MetaUtilities.getBatchServerComponent(jobinfo.getBatchServer(), (MdStore)store, reposID);
                        this.setBatchServer(batchserver);
                    } else {
                        this.m_batchserver = batchserver;
                    }
                }
                String jobArgs = this.getJobArgs();
                if (jobArgs == null) {
                    jobArgs = "";
                }
                if ((newJobArgs = jobinfo.getJobArgs()) == null) {
                    newJobArgs = jobinfo.isDisplayOnly() ? jobArgs : "";
                }
                if (!jobArgs.equals(newJobArgs)) {
                    this.setJobArgs(jobinfo.getJobArgs());
                }
                if ((encodedArgs = this.getEncodedJobArgsProperty()) == null) {
                    encodedArgs = "";
                }
                if ((newEncodedArgs = jobinfo.getEncodedArgs()) == null) {
                    newEncodedArgs = jobinfo.isDisplayOnly() ? encodedArgs : "";
                }
                if (!encodedArgs.equals(newEncodedArgs)) {
                    this.setEncodedJobArgsProperty(jobinfo.getEncodedArgs());
                }
                String jobcmd = jobinfo.getCommandLine();
                jobcmd = this.replaceCommandLineArgs(jobcmd);
                String cmdline = CommandUtilities.getCommandLine(this.m_jfjob, flowname);
                if (flowname != null && flowname.length() > 0) {
                    TransformationStep jobStep = null;
                    AssociationList steps = this.m_jfjob.getSteps();
                    int num = steps.size();
                    for (int j = 0; j < num; ++j) {
                        TransformationStep step = (TransformationStep)steps.get(j);
                        TransformationActivity ta = null;
                        try {
                            JFJob flow;
                            ta = (TransformationActivity)step.getActivities().get(0);
                            AssociationList list = ta.getJobs();
                            if (list.size() <= 0 || (flow = (JFJob)list.get(0)) == null || flowname == null || flow.getName().compareTo(flowname) != 0) continue;
                            jobStep = step;
                            break;
                        }
                        catch (Exception e4) {
                            // empty catch block
                        }
                    }
                    if (jobStep != null) {
                        int priority = jobinfo.getJobPriority();
                        if (priority != -1) {
                            DeployedJob.setPriority(jobStep, priority);
                        } else if (!jobinfo.isDisplayOnly()) {
                            DeployedJob.clearPriority(jobStep);
                        }
                        String runas = jobinfo.getUserId();
                        if (runas != null) {
                            DeployedJob.setRunAs(jobStep, runas);
                        } else if (!jobinfo.isDisplayOnly()) {
                            DeployedJob.clearRunAs(jobStep);
                        }
                        String details = jobinfo.getSchedulerProperties();
                        if (details != null) {
                            DeployedJob.setSchedulingDetails(jobStep, details);
                        } else if (!jobinfo.isDisplayOnly()) {
                            DeployedJob.clearSchedulingDetails(jobStep);
                        }
                        String resource = jobinfo.getSchedulerResources();
                        if (resource != null) {
                            DeployedJob.setResources(jobStep, resource);
                        } else if (!jobinfo.isDisplayOnly()) {
                            DeployedJob.clearResources((Root)jobStep);
                        }
                        if (jobcmd != null && jobcmd.length() != 0 && jobcmd.compareTo(cmdline) != 0) {
                            DeployedJob.setCmdLineProperty((Root)jobStep, jobcmd);
                        }
                    }
                } else {
                    int priority = jobinfo.getJobPriority();
                    if (priority != -1) {
                        DeployedJob.setPriority((Root)this.m_jfjob, priority);
                    } else if (!jobinfo.isDisplayOnly()) {
                        DeployedJob.clearPriority((Root)this.m_jfjob);
                    }
                    String runas = jobinfo.getUserId();
                    if (runas != null) {
                        DeployedJob.setRunAs((Root)this.m_jfjob, runas);
                    } else if (!jobinfo.isDisplayOnly()) {
                        DeployedJob.clearRunAs((Root)this.m_jfjob);
                    }
                    String resource = jobinfo.getSchedulerResources();
                    if (resource != null) {
                        DeployedJob.setResources((Root)this.m_jfjob, resource);
                    } else if (!jobinfo.isDisplayOnly()) {
                        DeployedJob.clearResources((Root)this.m_jfjob);
                    }
                    if (jobcmd != null && jobcmd.length() != 0 && jobcmd.compareTo(cmdline) != 0) {
                        String cmdline2 = CommandUtilities.getCommandLine(this.m_jfjob, null);
                        if (jobcmd != null && jobcmd.compareTo(cmdline2) != 0) {
                            if (DeployedJob.getCmdLineProperty((Root)this.m_jfjob) != null) {
                                DeployedJob.setCmdLineProperty((Root)this.m_jfjob, jobcmd);
                            } else {
                                if (MetaUtilities.isDebug()) {
                                    System.err.println("No flow context, command-line does not match derived command-line, and job was not deployed with a property.");
                                    System.err.println("Redeploy will be necessary to change the command-line in the future.");
                                }
                                DeployedJob.setCmdLineProperty((Root)this.m_jfjob, jobcmd);
                            }
                        }
                    }
                }
                this.m_source = this.getSourceCode();
                if (jobinfo.getSourceFile() == null) {
                    this.m_source = null;
                } else {
                    block117: {
                        if (this.m_source == null || jobinfo.getSourceFile().compareTo(this.m_source.getFileName()) != 0) {
                            Directory dir2 = MetaUtilities.getDirectory(jobinfo.getBatchServer(), jobinfo.getSourceDir().getPath(), (MdStore)store, reposID);
                            this.setSourceCode(MetaUtilities.createFileObject(jobinfo.getSourceFile(), dir2, store, repos));
                        } else {
                            DirectoryInfo dinfo = jobinfo.getSourceDir();
                            Directory dir1 = MetaUtilities.getDirectory(jobinfo.getBatchServer(), dinfo != null ? dinfo.getPath() : "", (MdStore)store, reposID);
                            if (dir1 == null) {
                                if (MetaUtilities.isDebug()) {
                                    RuntimeException rte = new RuntimeException(MetaUtilities.messageString(m_bundle.getString("DeployedJob.InvalidRequiredObject.SourceDir.fmt"), this.m_jfjob.getName()));
                                    System.out.println(rte.toString() + "\n" + rte.getStackTrace()[0].toString() + "\n" + rte.getStackTrace()[1].toString() + "\n" + rte.getStackTrace()[2].toString());
                                }
                                this.m_errorFlag |= 0x100;
                                jobinfo.setError();
                            } else {
                                try {
                                    Directory dir2 = (Directory)this.m_source.getDirectories().get(0);
                                    if (dir1.getId().compareTo(dir2.getId()) != 0) {
                                        AssociationList list = this.m_source.getDirectories();
                                        list.clear();
                                        list.add(dir1);
                                    }
                                }
                                catch (ArrayIndexOutOfBoundsException ex) {
                                    AssociationList list = this.m_source.getDirectories();
                                    list.clear();
                                    if (dir1 == null) break block117;
                                    list.add(dir1);
                                }
                            }
                        }
                    }
                    if (jobinfo.getOriginalSourceFileDataBinding() != null) {
                        Boolean pathChanged;
                        Boolean nameChanged;
                        FileInfo newfile;
                        FileInfo original;
                        block118: {
                            original = DeployedJob.getSourceCodes(jobinfo.getJob(), store, reposID);
                            newfile = jobinfo.getOriginalSourceFileDataBinding();
                            nameChanged = false;
                            pathChanged = false;
                            try {
                                pathChanged = newfile.getPath().compareTo(original.getPath()) != 0;
                                nameChanged = newfile.getName().compareTo(original.getName()) != 0;
                            }
                            catch (NullPointerException npe) {
                                pathChanged = false;
                                nameChanged = false;
                                if (!MetaUtilities.isDebug()) break block118;
                                this.m_jfjob.getObjectStore().getFactory().getUtil().printOutputln("DeployedJob: SOURCEFILE NOT SET");
                            }
                        }
                        if (original == null || pathChanged.booleanValue() || nameChanged.booleanValue()) {
                            dir = MetaUtilities.getDirectory(jobinfo.getBatchServer(), newfile.getPath(), (MdStore)store, reposID);
                            File neoOrig = MetaUtilities.createFileObject(newfile.getName(), dir, store, repos);
                            DeployedJob.setSourceCodes(jobinfo.getJob(), neoOrig, store, reposID);
                        }
                    }
                }
                this.m_jcl = this.getJCL();
                if (jobinfo.getJCL() == null) {
                    this.m_jcl = null;
                } else if (this.m_source == null || jobinfo.getJCL().compareTo(this.m_jcl.getFileName()) != 0) {
                    BatchServerInfo batch = jobinfo.getBatchServer();
                    path = "";
                    String file = CommandUtilities.normalizePath(jobinfo.getJCL(), batch.getOperatingSystem());
                    int index = file.lastIndexOf("/");
                    if (index > 0) {
                        path = file.substring(0, index);
                        file = file.substring(index + 1);
                    }
                    dir = MetaUtilities.getDirectory(batch, path, (MdStore)store, reposID);
                    this.m_jcl = MetaUtilities.createFileObject(file, dir, store, repos);
                } else {
                    AssociationList list;
                    BatchServerInfo batch = jobinfo.getBatchServer();
                    path = CommandUtilities.normalizePath(jobinfo.getJCL(), batch.getOperatingSystem());
                    int index = path.lastIndexOf("/");
                    if (index > 0) {
                        path = path.substring(0, index);
                    }
                    Directory dir1 = MetaUtilities.getDirectory(batch, path, (MdStore)store, reposID);
                    try {
                        Directory dir2 = (Directory)this.m_jcl.getDirectories().get(0);
                        if (dir1.getId().compareTo(dir2.getId()) != 0) {
                            list = this.m_jcl.getDirectories();
                            list.clear();
                            list.add(dir1);
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        list = this.m_jcl.getDirectories();
                        list.clear();
                        list.add(dir1);
                    }
                }
                String party = jobinfo.getResponsiblePartyDataBinding();
                if (party != null && ((curparty = this.getResponsiblePartyForDeployment()) == null || curparty.compareTo(party) != 0)) {
                    AssociationList list = this.getResponsibleParties();
                    for (int x = list.size() - 1; x >= 0; --x) {
                        ResponsibleParty rp = (ResponsibleParty)list.get(x);
                        if (rp.getRole().compareTo(ResponsiblePartyRole) != 0) continue;
                        list.remove(x);
                    }
                    Person person = MetaUtilities.createPerson(party, store, repos);
                    if (person != null) {
                        ResponsibleParty rparty = MetaUtilities.getResposibleParty(person, ResponsiblePartyRole);
                        list.add((Object)rparty);
                        this.setResponsibleParties(list);
                    }
                }
            }
        }
        this.validateData();
    }

    public DeployedJob(Job job, ServerComponent batchserver) throws MdException, RemoteException {
        this(job, batchserver, (UserContextInterface)null);
    }

    public DeployedJob(Job job, ServerComponent batchserver, UserContextInterface user) throws MdException, RemoteException {
        this.m_step = null;
        this.m_job = job;
        this.m_batchserver = batchserver;
        this.m_userContext = user;
        this._initialize();
        this.createJFJobObject();
        this.validateData();
    }

    public DeployedJob(Job job, ServerComponent batchserver, String jobargs) throws MdException, RemoteException {
        this(job, batchserver, null, jobargs);
    }

    public DeployedJob(Job job, ServerComponent batchserver, UserContextInterface user, String jobargs) throws MdException, RemoteException {
        this(job, batchserver, user, jobargs, null);
    }

    public DeployedJob(Job job, ServerComponent batchserver, UserContextInterface user, String jobargs, String deploymentDir) throws MdException, RemoteException {
        this.m_step = null;
        this.m_job = job;
        this.m_batchserver = batchserver;
        this.m_userContext = user;
        this.m_deployDir = deploymentDir;
        this._initialize();
        this.createJFJobObject();
        this.setJobArgs(jobargs);
        this.validateData();
    }

    public DeployedJob(Job job, ServerComponent batchserver, File source) throws MdException, RemoteException {
        this(job, batchserver, null, source);
    }

    public DeployedJob(Job job, ServerComponent batchserver, UserContextInterface user, File source) throws MdException, RemoteException {
        this.m_step = null;
        this.m_job = job;
        this.m_batchserver = batchserver;
        this.m_userContext = user;
        this.m_source = source;
        this.m_val_level = CommandUtilities.getTargetOSForBatchServer(batchserver) == 2 ? 2 : 1;
        this._initialize();
        this.createJFJobObject();
        this.validateData();
    }

    public DeployedJob(Job job, ServerComponent batchserver, UserContextInterface user, File source, String repos) throws MdException, RemoteException {
        this.m_step = null;
        this.m_job = job;
        this.m_batchserver = batchserver;
        this.m_userContext = user;
        this.m_source = source;
        this.m_val_level = CommandUtilities.getTargetOSForBatchServer(batchserver) == 2 ? 2 : 1;
        String string = this.m_reposID = repos.length() > 8 ? repos.substring(9) : repos;
        if (this.m_job.getObjectStore() != null) {
            this.m_store = (MdObjectStore)this.m_job.getObjectStore();
            this.m_factory = this.m_store.getFactory();
        } else {
            this.m_factory = new MdFactoryImpl();
            this.m_store = this.m_factory.createObjectStore(null, "DeployedJob");
        }
        this.createJFJobObject();
        this.validateData();
    }

    public DeployedJob(TransformationStep step, JFJob flow) throws MdException, RemoteException {
        this.m_job = null;
        this.m_step = step;
        this.m_batchserver = null;
        this.m_jfjob = flow;
        this._initialize();
        this.validateData();
    }

    private boolean isInvalid(String fqid) {
        if (fqid == null) {
            return false;
        }
        return fqid.length() == 8 || fqid.length() == 17 && fqid.charAt(8) == '.';
    }

    public void refresh() throws MdException, RemoteException {
        if (this.m_store == null) {
            this.m_store = this.m_factory.createObjectStore(null, "DeployedJob");
        }
        if (this.m_jfjob != null) {
            this.m_store.refreshObjectFromServer((CMetadata)this.m_jfjob, false, true);
            for (TransformationStep step : this.m_jfjob.getSteps(true)) {
                this.m_store.refreshObjectFromServer((CMetadata)step, false, true);
            }
        } else if (this.m_step != null) {
            this.m_store.refreshObjectFromServer((CMetadata)this.m_step, false, true);
        }
        this._setJobAndBatch(true);
    }

    public JobInfo getInfo() throws RemoteException, MdException {
        return this.getInfo(null);
    }

    public JobInfo getInfo(String flowname) throws RemoteException, MdException {
        JobInfo info = null;
        if (this.m_jfjob.getTransformRole().compareTo("SCHEDULER_FLOW") == 0) {
            info = DeployedJob.getInfo(this.m_jfjob, null, flowname, null, null, null);
        } else {
            this.getBatchServer();
            info = DeployedJob.getInfo(this.m_jfjob, this.m_job, flowname, this.m_batchserver, this.m_source, this.m_jcl);
            if (this.m_batchserver == null) {
                this.m_errorFlag |= 0x10;
            } else if (info.hasErrors() && info.getBatchServerType() == -1) {
                this.m_errorFlag |= 0x10;
            }
        }
        if (this.m_errorFlag != 0) {
            info.setError();
        }
        return info;
    }

    public static JobInfo getInfo(JFJob jfjob, Job job, String flowname, ServerComponent batchserver, File source, File jcl) throws RemoteException, MdException {
        Tree folder;
        String runas;
        Job jobObj;
        JobInfo info = null;
        if (batchserver == null) {
            info = new JobInfo(DeployedJob.getName(jfjob), jfjob.getId(), -2);
            info.setDisplayOnly(true);
        } else {
            BatchServerInfo bsinfo = MetaUtilities.getBatchServer(batchserver);
            MetaUtilities.setBatchServerProperties(bsinfo, batchserver);
            info = new JobInfo(DeployedJob.getName(jfjob), jfjob.getId(), bsinfo);
            info.setDisplayOnly(false);
        }
        if (jfjob.getTransformRole().compareTo("SCHEDULER_FLOW") == 0) {
            info.setAsSubflow();
        }
        if ((jobObj = jfjob.getAssociatedJob()) != null) {
            DisplayInfo ji = new DisplayInfo(jobObj.getName(), null, null);
            ji.setId(jobObj.getId());
            info.setJob(ji);
            MdObjectStore store = (MdObjectStore)jobObj.getObjectStore();
            String repos = "A0000001." + jobObj.getId().substring(0, 8);
            info.setOriginalSourceFileDataBinding(DeployedJob.getSourceCodes(ji, store, repos));
        }
        if (source != null) {
            String filename = source.getFileName();
            String fileext = source.getFileExtension();
            if (fileext != null && fileext.length() > 0) {
                filename = filename + "." + fileext;
            }
            info.setSourceFile(filename);
            AssociationList dirs = source.getDirectories();
            if (dirs.size() != 0) {
                Directory dir = (Directory)dirs.get(0);
                info.setSourceDir(new DirectoryInfo(dir.getName(), dir.getDirectoryName()));
            } else {
                info.setError();
                if (MetaUtilities.isDebug()) {
                    RuntimeException rte = new RuntimeException("Source file is not properly formatted in metadata");
                    System.out.println(rte.toString() + "\n" + rte.getStackTrace()[0].toString() + "\n" + rte.getStackTrace()[1].toString() + "\n" + rte.getStackTrace()[2].toString());
                }
            }
        }
        if (jcl != null) {
            info.setRawCommandLine(CommandUtilities.getActualCommandLine(jfjob, flowname));
            String jclname = jcl.getFileName();
            String jclext = jcl.getFileExtension();
            if (jclext != null && jclext.length() > 0) {
                jclname = jclname + "." + jclext;
            }
            String filepath = "";
            AssociationList dirs = jcl.getDirectories();
            if (dirs.size() != 0) {
                Directory dir = (Directory)dirs.get(0);
                filepath = dir.getDirectoryName();
            }
            info.setJCL(CommandUtilities.createFullPath(filepath, jclname, CommandUtilities.getTargetOSForBatchServer(batchserver)));
        }
        info.setResponsiblePartyDataBinding(DeployedJob.getResponsiblePartyForDeployment(jfjob));
        TransformationStep jobStep = null;
        AssociationList steps = jfjob.getSteps();
        int num = steps.size();
        for (int j = 0; j < num; ++j) {
            TransformationStep step = (TransformationStep)steps.get(j);
            TransformationActivity ta = null;
            try {
                JFJob flow;
                ta = (TransformationActivity)step.getActivities().get(0);
                AssociationList list = ta.getJobs();
                if (list.size() <= 0 || (flow = (JFJob)list.get(0)) == null || flowname == null || flow.getName().compareTo(flowname) != 0) continue;
                jobStep = step;
                break;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (jobStep != null) {
            int priority;
            runas = DeployedJob.getRunAs(jobStep);
            if (runas != null) {
                info.setUserId(runas);
            } else {
                runas = DeployedJob.getRunAs((Root)jfjob);
                if (runas != null) {
                    info.setUserId(runas);
                }
            }
            String details = DeployedJob.getSchedulingDetails(jobStep);
            if (details != null) {
                info.setSchedulerProperties(details);
            }
            if ((priority = DeployedJob.getPriority(jobStep)) != -1) {
                info.setJobPriority(priority);
            } else {
                priority = DeployedJob.getPriority((Root)jfjob);
                if (priority != -1) {
                    info.setJobPriority(priority);
                }
            }
            String resource = DeployedJob.getResources(jobStep);
            if (resource != null) {
                info.setSchedulerResources(resource);
            } else {
                resource = DeployedJob.getResources((Root)jfjob);
                if (resource != null) {
                    info.setSchedulerResources(resource);
                }
            }
            String cmdOverride = DeployedJob.getCmdLineProperty((Root)jobStep);
            if (cmdOverride != null) {
                info.setCommandLine(cmdOverride, false);
            } else {
                cmdOverride = DeployedJob.getCmdLineProperty((Root)jfjob);
                if (cmdOverride != null) {
                    info.setCommandLine(cmdOverride, false);
                } else {
                    info.setCommandLine(CommandUtilities.getCommandLine(jfjob, flowname), true);
                }
            }
        } else {
            String cmdOverride;
            String resource;
            int priority;
            runas = DeployedJob.getRunAs((Root)jfjob);
            if (runas != null) {
                info.setUserId(runas);
            }
            if ((priority = DeployedJob.getPriority((Root)jfjob)) != -1) {
                info.setJobPriority(priority);
            }
            if ((resource = DeployedJob.getResources((Root)jfjob)) != null) {
                info.setSchedulerResources(resource);
            }
            if ((cmdOverride = DeployedJob.getCmdLineProperty((Root)jfjob)) != null && cmdOverride.length() > 0) {
                info.setCommandLine(cmdOverride, false);
            } else {
                info.setCommandLine(CommandUtilities.getCommandLine(jfjob, flowname), true);
            }
        }
        info.setDescription(DeployedJob.getDescription(jfjob));
        info.setJobArgs(DeployedJob.getJobArgs(jfjob));
        info.setEncodedArgs(DeployedJob.getEncodedJobArgsProperty(jfjob));
        Date d = DeployedJob.getDateCreated(jfjob);
        if (d != null) {
            GregorianCalendar ccal = new GregorianCalendar();
            ccal.setTime(d);
            info.setCreationDateDataBinding((Calendar)ccal);
        }
        if ((d = DeployedJob.getDateModified(jfjob)) != null) {
            GregorianCalendar mcal = new GregorianCalendar();
            mcal.setTime(d);
            info.setModifiedDateDataBinding((Calendar)mcal);
        }
        if ((folder = DeployedJob.getFolder(jfjob)) != null) {
            info.setLocation(MetaUtilities.getFolderLocation(folder));
            info.setLocationId(folder.getId());
        }
        return info;
    }

    public String getId() throws RemoteException {
        return this.m_jfjob != null ? this.m_jfjob.getId() : null;
    }

    public int compareTo(DeployedJob other) throws RemoteException {
        return this.getDeployedJobObject().getId().compareTo(other.getDeployedJobObject().getId());
    }

    public static FileInfo getSourceCodes(DisplayInfo job, MdObjectStore store, String repos) {
        boolean notFound = true;
        if (job != null) {
            try {
                Job jobObject = MetaUtilities.getAssociatedJob(job.getId(), (MdStore)store, repos);
                if (jobObject != null) {
                    Iterator srcs = jobObject.getSourceCodes().iterator();
                    while (notFound && srcs.hasNext()) {
                        Object obj = srcs.next();
                        if (obj instanceof File) {
                            notFound = false;
                            File srcfile = (File)obj;
                            String name = srcfile.getFileName();
                            String ext = srcfile.getFileExtension();
                            if (ext != null && ext.length() > 0) {
                                name = name + "." + ext;
                            }
                            String path = null;
                            AssociationList dirs = srcfile.getDirectories(true);
                            if (dirs.size() > 0) {
                                Directory dir = (Directory)dirs.get(0);
                                path = dir != null ? dir.getDirectoryName() : null;
                            }
                            FileInfo info = new FileInfo(name, ext, path);
                            return info;
                        }
                        if (!(obj instanceof TextStore)) continue;
                        FileInfo info = new FileInfo(null, null, null);
                        info.setDescription(((TextStore)obj).getStoredText());
                        return info;
                    }
                }
                return new FileInfo(null, null, null);
            }
            catch (MdException ex) {
                return null;
            }
            catch (RemoteException ex) {
                return null;
            }
        }
        return null;
    }

    public static boolean setSourceCodes(DisplayInfo job, File src, MdObjectStore store, String repos) {
        boolean notFound = true;
        if (job != null) {
            try {
                Job jobObject = MetaUtilities.getAssociatedJob(job.getId(), (MdStore)store, repos);
                AssociationList srcs = jobObject.getSourceCodes();
                for (int i = srcs.size() - 1; i > -1; --i) {
                    Object obj = srcs.get(i);
                    if (!(obj instanceof File)) continue;
                    srcs.remove(i);
                }
                srcs.add(src);
                return true;
            }
            catch (MdException ex) {
                return false;
            }
            catch (RemoteException ex) {
                return false;
            }
        }
        return false;
    }

    public String getJobArgs() throws MdException, RemoteException {
        return DeployedJob._getProperty((Root)this.m_jfjob, "CmdArgs");
    }

    public static String getJobArgs(JFJob jfjob) throws MdException, RemoteException {
        return DeployedJob._getProperty((Root)jfjob, "CmdArgs");
    }

    public boolean setJobArgs(String cmdargs) throws MdException, RemoteException {
        Property property = DeployedJob._setProperty((Root)this.m_jfjob, "CmdArgs", this.m_factory, this.m_store, cmdargs);
        return property != null;
    }

    public String getEncodedJobArgsProperty() throws MdException, RemoteException {
        return this.m_factory.getUtil().decrypt(DeployedJob._getLastProperty((Root)this.m_jfjob, "EncodedCmdArgs"));
    }

    public static String getEncodedJobArgsProperty(JFJob jfjob) throws MdException, RemoteException {
        MdFactory factory = jfjob.getObjectStore().getFactory();
        return factory.getUtil().decrypt(DeployedJob._getLastProperty((Root)jfjob, "EncodedCmdArgs"));
    }

    public boolean setEncodedJobArgsProperty(String value) throws MdException, RemoteException {
        Property property;
        if (value == null) {
            value = "";
        }
        if ((property = DeployedJob._setProperty((Root)this.m_jfjob, "EncodedCmdArgs", this.m_factory, this.m_store, this.m_factory.getUtil().encrypt(value))) != null) {
            property.setDesc(Long.toString(System.currentTimeMillis()));
            return true;
        }
        return false;
    }

    public boolean setEncodedJobArgsProperty(String value, IdentityGroup group) throws MdException, RemoteException {
        Property property;
        if (value == null) {
            value = "";
        }
        if ((property = DeployedJob._setProperty((Root)this.m_jfjob, "EncodedCmdArgs", this.m_factory, this.m_store, this.m_factory.getUtil().encrypt(value))) != null) {
            property.setDesc(Long.toString(System.currentTimeMillis()));
            MdOMRConnection mdomr = this.m_factory.getConnection();
            ISecurity_1_1 isec = mdomr.MakeISecurityConnection(mdomr.getCMRHandle());
            StringHolder identity = new StringHolder();
            try {
                isec.GetIdentity("", identity);
            }
            catch (InvalidCredHandle ic) {
                return false;
            }
            catch (GenericError ge) {
                return false;
            }
            String repos = "A0000001." + this.m_reposID;
            Identity currentuser = MetaUtilities.getIdentity((MdStore)this.m_store, repos, identity.value.substring(identity.value.lastIndexOf(47) + 1));
            IdentityGroup publicgroup = MetaUtilities.getPublicGroup((MdStore)this.m_store, repos);
            Permission grantread = MetaUtilities.getPermission((MdStore)this.m_store, repos, "ReadMetadata", "GRANT");
            Permission grantwrite = MetaUtilities.getPermission((MdStore)this.m_store, repos, "WriteMetadata", "GRANT");
            Permission denyread = MetaUtilities.getPermission((MdStore)this.m_store, repos, "ReadMetadata", "DENY");
            Permission denywrite = MetaUtilities.getPermission((MdStore)this.m_store, repos, "WriteMetadata", "DENY");
            if (publicgroup == null || grantread == null || grantwrite == null || denyread == null || denywrite == null) {
                return false;
            }
            try {
                AssociationList list = property.getAccessControls();
                this.m_factory.deleteMetadataObjects((List)list);
            }
            catch (RuntimeException list) {
                // empty catch block
            }
            AccessControlEntry grantace = (AccessControlEntry)this.m_factory.createComplexMetadataObject(this.m_store, null, "EncodedCmdArgs", "AccessControlEntry", this.m_reposID, null);
            grantace.getPermissions().add((Object)grantread);
            grantace.getPermissions().add((Object)grantwrite);
            grantace.getIdentities().add((Object)group);
            grantace.getIdentities().add((Object)currentuser);
            property.getAccessControls().add((Object)grantace);
            AccessControlEntry denyace = (AccessControlEntry)this.m_factory.createComplexMetadataObject(this.m_store, null, "EncodedCmdArgs", "AccessControlEntry", this.m_reposID, null);
            denyace.getPermissions().add((Object)denyread);
            denyace.getPermissions().add((Object)denywrite);
            denyace.getIdentities().add((Object)publicgroup);
            property.getAccessControls().add((Object)denyace);
            property.setSQLType(12);
            return true;
        }
        return false;
    }

    public String getCmdLineProperty() throws MdException, RemoteException {
        return DeployedJob._getProperty((Root)this.m_jfjob, "CmdLine");
    }

    public static String getCmdLineProperty(Root metadata) throws MdException, RemoteException {
        return DeployedJob._getProperty(metadata, "CmdLine");
    }

    public boolean setCmdLineProperty(String cmdLine) throws MdException, RemoteException {
        Property property = DeployedJob._setProperty((Root)this.m_jfjob, "CmdLine", this.m_factory, this.m_store, cmdLine);
        return property != null;
    }

    public static boolean setCmdLineProperty(Root metadata, String cmdLine) throws MdException, RemoteException {
        MdObjectStore store = (MdObjectStore)metadata.getObjectStore();
        MdFactory factory = store.getFactory();
        Property property = DeployedJob._setProperty(metadata, "CmdLine", factory, store, cmdLine);
        return property != null;
    }

    public boolean removeCmdLineProperty() throws MdException, RemoteException {
        return DeployedJob._removeProperty((Root)this.m_jfjob, "CmdLine");
    }

    public static boolean removeCmdLineProperty(Root metadata) throws MdException, RemoteException {
        return DeployedJob._removeProperty(metadata, "CmdLine");
    }

    public String getRunAs() throws MdException, RemoteException {
        return DeployedJob._getProperty((Root)this.m_jfjob, "RunAs");
    }

    public static String getRunAs(Root metadata) throws MdException, RemoteException {
        String runas = DeployedJob._getProperty(metadata, "RunAs");
        if (runas == null && metadata instanceof TransformationStep) {
            try {
                JFJob jfjob = (JFJob)((TransformationStep)metadata).getTransformations().get(0);
                runas = DeployedJob._getProperty((Root)jfjob, "RunAs");
            }
            catch (ArrayIndexOutOfBoundsException e) {
                String message = MetaUtilities.messageString(m_bundle.getString("DeployedJob.MissingRequiredObject.JFJob.fmt"), metadata.getName());
                metadata.getObjectStore().getFactory().getUtil().printOutputln(message);
            }
        }
        return runas;
    }

    public boolean setRunAs(String userid) throws MdException, RemoteException {
        Property property = DeployedJob._setProperty((Root)this.m_jfjob, "RunAs", this.m_factory, this.m_store, userid);
        return property != null;
    }

    public static boolean setRunAs(Root metadata, String userid) throws MdException, RemoteException {
        MdObjectStore store = (MdObjectStore)metadata.getObjectStore();
        MdFactory factory = store.getFactory();
        Property property = DeployedJob._setProperty(metadata, "RunAs", factory, store, userid);
        return property != null;
    }

    public boolean clearRunAs() throws MdException, RemoteException {
        return DeployedJob._removeProperty((Root)this.m_jfjob, "RunAs");
    }

    public static boolean clearRunAs(Root metadata) throws MdException, RemoteException {
        return DeployedJob._removeProperty(metadata, "RunAs");
    }

    public Tree getFolder() throws RemoteException, MdException {
        return DeployedJob.getFolder(this.m_jfjob);
    }

    public static Tree getFolder(JFJob jfjob) throws RemoteException, MdException {
        AssociationList trees = jfjob.getTrees();
        if (trees.size() > 0) {
            return (Tree)trees.get(0);
        }
        return null;
    }

    public boolean setFolder(Tree folder) throws RemoteException, MdException {
        AssociationList trees = this.m_jfjob.getTrees();
        trees.clear();
        return trees.add(folder);
    }

    public String getResources() throws MdException, RemoteException {
        return DeployedJob._getProperty((Root)this.m_jfjob, "Resources");
    }

    public static String getResources(Root metadata) throws MdException, RemoteException {
        String resources = DeployedJob._getProperty(metadata, "Resources");
        if (resources == null && metadata instanceof TransformationStep) {
            try {
                JFJob jfjob = (JFJob)((TransformationStep)metadata).getTransformations().get(0);
                resources = DeployedJob._getProperty((Root)jfjob, "Resources");
            }
            catch (ArrayIndexOutOfBoundsException e) {
                String message = MetaUtilities.messageString(m_bundle.getString("DeployedJob.MissingRequiredObject.JFJob.fmt"), metadata.getName());
                metadata.getObjectStore().getFactory().getUtil().printOutputln(message);
            }
        }
        return resources;
    }

    public boolean setResources(String expression) throws MdException, RemoteException {
        Property property = DeployedJob._setProperty((Root)this.m_jfjob, "Resources", this.m_factory, this.m_store, expression);
        return property != null;
    }

    public static boolean setResources(Root metadata, String expression) throws MdException, RemoteException {
        MdObjectStore store = (MdObjectStore)metadata.getObjectStore();
        MdFactory factory = store.getFactory();
        Property property = DeployedJob._setProperty(metadata, "Resources", factory, store, expression);
        return property != null;
    }

    public boolean clearResources() throws MdException, RemoteException {
        return DeployedJob._removeProperty((Root)this.m_jfjob, "Resources");
    }

    public static boolean clearResources(Root metadata) throws MdException, RemoteException {
        return DeployedJob._removeProperty(metadata, "Resources");
    }

    public static String getSchedulingDetails(TransformationStep metadata) throws MdException, RemoteException {
        return DeployedJob._getProperty((Root)metadata, "SCHEDULINGDETAILS");
    }

    public static boolean setSchedulingDetails(TransformationStep metadata, String details) throws MdException, RemoteException {
        MdObjectStore store = (MdObjectStore)metadata.getObjectStore();
        MdFactory factory = store.getFactory();
        Property property = DeployedJob._setProperty((Root)metadata, "SCHEDULINGDETAILS", factory, store, details);
        return property != null;
    }

    public static boolean clearSchedulingDetails(TransformationStep metadata) throws MdException, RemoteException {
        return DeployedJob._removeProperty((Root)metadata, "SCHEDULINGDETAILS");
    }

    public int getPriority() throws MdException, RemoteException {
        return DeployedJob.getPriority((Root)this.m_jfjob);
    }

    public static int getPriority(Root metadata) throws MdException, RemoteException {
        String priority = DeployedJob._getProperty(metadata, "Priority");
        if (priority == null && metadata instanceof TransformationStep) {
            try {
                JFJob jfjob = (JFJob)((TransformationStep)metadata).getTransformations().get(0);
                priority = DeployedJob._getProperty((Root)jfjob, "Priority");
            }
            catch (ArrayIndexOutOfBoundsException e) {
                String message = MetaUtilities.messageString(m_bundle.getString("DeployedJob.MissingRequiredObject.JFJob.fmt"), metadata.getName());
                metadata.getObjectStore().getFactory().getUtil().printOutputln(message);
            }
        }
        if (priority == null || priority.length() == 0) {
            return -1;
        }
        return Integer.valueOf(priority);
    }

    public boolean setPriority(int value) throws MdException, RemoteException {
        Property property = DeployedJob._setProperty((Root)this.m_jfjob, "Resources", this.m_factory, this.m_store, String.valueOf(value));
        return property != null;
    }

    public static boolean setPriority(Root metadata, int value) throws MdException, RemoteException {
        MdObjectStore store = (MdObjectStore)metadata.getObjectStore();
        MdFactory factory = store.getFactory();
        Property property = DeployedJob._setProperty(metadata, "Priority", factory, store, String.valueOf(value));
        return property != null;
    }

    public boolean clearPriority() throws MdException, RemoteException {
        return DeployedJob._removeProperty((Root)this.m_jfjob, "Priority");
    }

    public static boolean clearPriority(Root metadata) throws MdException, RemoteException {
        return DeployedJob._removeProperty(metadata, "Priority");
    }

    public boolean setLogging(boolean flag) throws MdException, RemoteException {
        Property property;
        String value = "false";
        if (flag) {
            value = "true";
        }
        return (property = DeployedJob._setProperty((Root)this.m_jfjob, "LogFlag", this.m_factory, this.m_store, value)) != null;
    }

    public boolean isLogging() throws MdException, RemoteException {
        String value = DeployedJob._getProperty((Root)this.m_jfjob, "LogFlag");
        return value.equalsIgnoreCase("true");
    }

    public boolean setSourceCode(File source) throws RemoteException, MdException {
        if (source != null) {
            this.m_source = source;
            this.m_jfjob.getSourceCodes().clear();
            this.m_jfjob.setSourceCode((Text)this.m_source);
            this.m_val_level = CommandUtilities.getTargetOSForBatchServer(this.m_batchserver) == 2 ? 2 : 1;
            return true;
        }
        return false;
    }

    public File getSourceCode() throws MdException, RemoteException {
        return DeployedJob.getSourceCode(this.m_jfjob);
    }

    public static File getSourceCode(JFJob jfjob) throws MdException, RemoteException {
        if (jfjob == null) {
            return null;
        }
        return (File)jfjob.getSourceCode();
    }

    public boolean setSourceSpecifications(File source) throws RemoteException, MdException {
        return this.setJCL(source);
    }

    public boolean setJCL(File source) throws RemoteException, MdException {
        if (source != null) {
            this.m_jcl = source;
            AssociationList list = this.m_jfjob.getSourceSpecifications();
            list.clear();
            list.add((Object)this.m_jcl);
            this.m_val_level = BatchServerInfo.requiresSourceFile((String)this.m_batchserver.getClassIdentifier()) ? 2 : 3;
            return true;
        }
        return false;
    }

    public File getSourceSpecifications() throws MdException, RemoteException {
        return this.getJCL();
    }

    public File getJCL() throws MdException, RemoteException {
        return DeployedJob.getJCL(this.m_jfjob);
    }

    public static File getJCL(JFJob jfjob) throws MdException, RemoteException {
        try {
            return (File)jfjob.getSourceSpecifications().get(0);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return null;
        }
    }

    public List<Directory> getDeploymentDirectories() throws MdException, RemoteException {
        ArrayList<Directory> listOfDirectories = new ArrayList<Directory>();
        AssociationList dataPackages = null;
        AssociationList cl = this.m_jfjob.getComputeLocations();
        ServerContext sc = null;
        if (cl.size() > 0) {
            sc = (ServerContext)cl.get(0);
        }
        if (sc != null) {
            dataPackages = sc.getDataPackages();
            int datapackagesize = dataPackages.size();
            for (int i = 0; i < datapackagesize; ++i) {
                if (!(dataPackages.get(i) instanceof Directory)) continue;
                Directory directory = (Directory)dataPackages.get(i);
                listOfDirectories.add(directory);
            }
            return listOfDirectories;
        }
        return null;
    }

    public void updateChanges() throws MdException, RemoteException {
        this.m_jfjob.updateMetadataAll();
    }

    public boolean commitChanges() throws MdException, RemoteException {
        if (this.validateData()) {
            return this.commitChangesWithNoValidation();
        }
        return false;
    }

    public boolean commitChangesWithNoValidation() {
        try {
            if (this.m_jfjob != null) {
                this.m_jfjob.updateMetadataAll();
                return true;
            }
            return false;
        }
        catch (MdException ex) {
            if (MetaUtilities.isDebug()) {
                ex.printStackTrace();
            }
            return false;
        }
        catch (RemoteException ex) {
            if (MetaUtilities.isDebug()) {
                ex.printStackTrace();
            }
            return false;
        }
        catch (Exception ex) {
            StackTraceElement[] st = ex.getStackTrace();
            for (int i = 0; i < st.length; ++i) {
                if (!st[i].getMethodName().contains("MdFactoryImpl.fireMdObject")) continue;
                ex.printStackTrace();
                return true;
            }
            if (MetaUtilities.isDebug()) {
                ex.printStackTrace();
            }
            return false;
        }
    }

    public JFJob getDeployedJobObject() {
        return this.m_jfjob;
    }

    public String getDateCreated(boolean localformat) {
        return DeployedJob.getDateCreated(this.m_jfjob, localformat);
    }

    public static String getDateCreated(JFJob jfjob, boolean localformat) {
        if (jfjob != null) {
            try {
                return MetaUtilities.getDateCreated((CMetadata)jfjob, localformat);
            }
            catch (RemoteException ex) {
                return "";
            }
        }
        return "";
    }

    public Date getDateCreated() {
        return DeployedJob.getDateCreated(this.m_jfjob);
    }

    public static Date getDateCreated(JFJob jfjob) {
        if (jfjob != null) {
            try {
                return MetaUtilities.getDateCreated((CMetadata)jfjob);
            }
            catch (RemoteException ex) {
                return null;
            }
            catch (ParseException ex) {
                return null;
            }
        }
        return null;
    }

    public String getDateModified(boolean localformat) {
        return DeployedJob.getDateModified(this.m_jfjob, localformat);
    }

    public static String getDateModified(JFJob jfjob, boolean localformat) {
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            list.add(jfjob);
            list.add(jfjob.getAssociatedJob());
            list.addAll((Collection<Object>)jfjob.getComputeLocations());
            list.addAll((Collection<Object>)jfjob.getSourceCodes());
            return MetaUtilities.getDateModified(list, localformat);
        }
        catch (MdException ex) {
            try {
                return MetaUtilities.getDateModified((CMetadata)jfjob, localformat);
            }
            catch (RemoteException re) {
                return "";
            }
        }
        catch (NullPointerException ex) {
            return "";
        }
        catch (RemoteException ex) {
            return "";
        }
    }

    public Date getDateModified() {
        return DeployedJob.getDateModified(this.m_jfjob);
    }

    public static Date getDateModified(JFJob jfjob) {
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            list.add(jfjob);
            list.add(jfjob.getAssociatedJob());
            list.addAll((Collection<Object>)jfjob.getComputeLocations());
            list.addAll((Collection<Object>)jfjob.getSourceCodes());
            return MetaUtilities.getDateModified(list);
        }
        catch (MdException ex) {
            try {
                return MetaUtilities.getDateModified((CMetadata)jfjob);
            }
            catch (ParseException re) {
                return null;
            }
            catch (RemoteException re) {
                return null;
            }
        }
        catch (NullPointerException ex) {
            return null;
        }
        catch (RemoteException ex) {
            return null;
        }
    }

    public JFJob getMetadataObject() {
        return this.m_jfjob;
    }

    public Job getJobObject() {
        return this.m_job;
    }

    public static Job getJobObject(JFJob jfjob) {
        try {
            return (Job)jfjob.getAssociatedJobs().get(0);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
        catch (RemoteException e) {
            return null;
        }
        catch (MdException e) {
            return null;
        }
    }

    public boolean setBatchServer(ServerComponent batchserver) {
        try {
            this.m_batchserver = batchserver;
            CommandUtilities.setServerComponentForJob(this.m_jfjob, this.m_batchserver);
            boolean requiresJCL = BatchServerInfo.requiresJCLFile((String)this.m_batchserver.getClassIdentifier(), (int)CommandUtilities.getTargetOSForBatchServer(this.m_batchserver));
            if (BatchServerInfo.requiresSourceFile((String)this.m_batchserver.getClassIdentifier())) {
                this.m_val_level = requiresJCL ? 2 : 1;
            } else if (requiresJCL) {
                this.m_val_level = 3;
            }
            return true;
        }
        catch (MdException ex) {
            this.m_batchserver = null;
            return false;
        }
        catch (RemoteException ex) {
            this.m_batchserver = null;
            return false;
        }
        catch (InvalidParameterException ex) {
            this.m_batchserver = null;
            return false;
        }
        catch (RuntimeException ex) {
            this.m_batchserver = null;
            return false;
        }
    }

    public ServerComponent getBatchServer() {
        if (this.m_batchserver == null) {
            this.m_batchserver = DeployedJob.getBatchServer(this.m_jfjob);
            try {
                if (this.m_batchserver == null) {
                    this.m_val_level = 0;
                } else if (BatchServerInfo.requiresSourceFile((String)this.m_batchserver.getClassIdentifier())) {
                    this.m_val_level = BatchServerInfo.requiresJCLFile((String)this.m_batchserver.getClassIdentifier(), (int)CommandUtilities.getTargetOSForBatchServer(this.m_batchserver)) ? 2 : 1;
                } else if (BatchServerInfo.requiresJCLFile((String)this.m_batchserver.getClassIdentifier(), (int)CommandUtilities.getTargetOSForBatchServer(this.m_batchserver))) {
                    this.m_val_level = 3;
                }
            }
            catch (MdException re) {
                this.m_val_level = 1;
            }
            catch (RemoteException re) {
                this.m_val_level = 0;
            }
            catch (InvalidParameterException re) {
                this.m_val_level = 0;
            }
        }
        return this.m_batchserver;
    }

    public static ServerComponent getBatchServer(JFJob jfjob) {
        try {
            return CommandUtilities.getServerComponentForJob(jfjob);
        }
        catch (MdException ex) {
            return null;
        }
        catch (RemoteException ex) {
            return null;
        }
    }

    public String getName() throws RemoteException {
        if (this.m_step != null) {
            return this.m_step.getName();
        }
        if (this.m_jfjob != null) {
            return this.m_jfjob.getName();
        }
        return null;
    }

    public static String getName(JFJob jfjob) throws RemoteException {
        if (jfjob == null) {
            return null;
        }
        return jfjob.getName();
    }

    public void setName(String name) throws RemoteException, MdException {
        if (this.m_job != null) {
            if (this.m_job.getJFJobs().size() == 1) {
                this.m_job.setName(name);
            }
        } else if (this.m_step != null) {
            this.m_step.setName(name);
        }
        this.m_jfjob.setName(name);
    }

    public void setName(String name, DeployedFlow flow) throws RemoteException, MdException {
        this.setName(name);
        TransformationStep step = this.getLogicalJob(flow.getTA());
        step.setName(JobEvent.getName(this.m_jfjob));
    }

    public static void setName(TransformationStep step, String name) throws RemoteException, MdException {
        try {
            JFJob jfjob = (JFJob)step.getTransformations().get(0);
            jfjob.setName(name);
            step.setName(JobEvent.getName(jfjob));
            Job job = jfjob.getAssociatedJob();
            if (job.getJFJobs().size() == 1) {
                job.setName(name);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            step.setName(name);
        }
    }

    public static String getDescription(JFJob jfjob) {
        try {
            Job job = (Job)jfjob.getAssociatedJobs().get(0);
            String desc = job.getDesc();
            if (desc == null || desc.length() == 0) {
                desc = jfjob.getDesc();
            }
            return desc;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return "";
        }
        catch (Exception ex) {
            try {
                return jfjob.getDesc();
            }
            catch (RemoteException e) {
                return "";
            }
            catch (RuntimeException e) {
                return "";
            }
        }
    }

    public String getDescription() throws RemoteException {
        if (this.m_job != null) {
            return this.m_job.getDesc();
        }
        if (this.m_jfjob.getDesc() != null && this.m_jfjob.getDesc().length() > 0) {
            return this.m_jfjob.getDesc();
        }
        if (this.hasErrors()) {
            return this.errorConditions();
        }
        return "";
    }

    public void setDescription(String text) throws RemoteException {
        if (this.m_job != null) {
            this.m_job.setDesc(text);
        } else {
            this.m_jfjob.setDesc(text);
        }
    }

    public int getRole() throws RemoteException {
        String text = null;
        if (this.m_step != null) {
            text = this.m_step.getTransformRole();
        } else if (this.m_job != null) {
            text = this.m_job.getTransformRole();
        }
        if (text == null) {
            return -1;
        }
        if (text.equalsIgnoreCase("AND")) {
            return 31;
        }
        return 32;
    }

    public void setRole(int role) throws RemoteException {
        if (this.m_step == null) {
            return;
        }
        switch (role) {
            case 31: {
                this.m_step.setTransformRole("AND");
                break;
            }
            default: {
                this.m_step.setTransformRole("OR");
            }
        }
    }

    public TransformationStep getLogicalJob(TransformationActivity flowTA) throws MdException, RemoteException, InvalidParameterException {
        if (this.m_step != null) {
            return this.m_step;
        }
        String jobID = this.m_jfjob.getId();
        ArrayList<TransformationStep> deleteList = new ArrayList<TransformationStep>();
        AssociationList flist = flowTA.getSteps();
        for (TransformationStep ts : flist) {
            if (ts instanceof SyncStep) continue;
            try {
                String jobID2 = ((JFJob)ts.getTransformations().get(0)).getFQID();
                if (!jobID.equalsIgnoreCase(jobID2)) continue;
                return ts;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                int count = this.m_factory.getSecurityUtil().getAssociationCountForObject((CMetadata)this.m_jfjob, "AssociatedJob");
                if (count != 0) continue;
                String message = MetaUtilities.messageString(m_bundle.getString("DeployedJob.MissingRequiredObject.JFJob2.fmt"), ts.getName());
                this.m_factory.getUtil().printOutputln(message);
                deleteList.add(ts);
            }
            catch (NullPointerException e) {
                System.out.println("TransformationStep missing while searching TransformationActivity(" + flowTA.getName() + ")");
                if (!MetaUtilities.isDebug()) continue;
                e.printStackTrace();
            }
        }
        if (deleteList.size() > 0) {
            this.m_factory.deleteMetadataObjects(deleteList);
        }
        InvalidParameterException ex = new InvalidParameterException(MetaUtilities.messageString(m_bundle.getString("DeployedJob.MissingRequiredObject.TA.fmt"), this.m_jfjob.getName()));
        throw ex;
    }

    public void setLogicalJob(TransformationStep step) {
        this.m_step = step;
    }

    public MdStore getStore() {
        return this.m_store;
    }

    public static List<JFJob> getListofFlows(JFJob jfjob) throws MdException, RemoteException {
        ArrayList<JFJob> flownames = new ArrayList<JFJob>();
        ArrayList<Object> deletelist = new ArrayList<Object>();
        AssociationList steps = jfjob.getSteps();
        int num = steps.size();
        for (int j = 0; j < num; ++j) {
            TransformationStep step = (TransformationStep)steps.get(j);
            TransformationActivity ta = null;
            try {
                ta = (TransformationActivity)step.getActivities().get(0);
            }
            catch (ArrayIndexOutOfBoundsException ab) {
                deletelist.add(step);
                continue;
            }
            AssociationList list = ta.getJobs();
            if (list.size() > 0) {
                JFJob flow = (JFJob)list.get(0);
                flownames.add(flow);
                continue;
            }
            deletelist.add(ta);
        }
        if (deletelist.size() > 0) {
            MdFactory factory = jfjob.getObjectStore().getFactory();
            factory.deleteMetadataObjects(deletelist);
        }
        return flownames;
    }

    public List<JFJob> getListofFlows() throws MdException, RemoteException {
        return DeployedJob.getListofFlows(this.m_jfjob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete() throws MdException, RemoteException {
        boolean rc = true;
        if (this.m_jfjob != null) {
            IWorkspaceServer server = null;
            try {
                if (this.m_jfjob.getSourceCodes().size() > 0 || this.m_jfjob.getSourceSpecifications().size() > 0) {
                    ServerComponent sc;
                    TCPIPConnection tcpip;
                    SessionContextInterface session;
                    UserContextInterface user = this.m_userContext;
                    if (user == null && (session = MetaUtilities.getSessionContext()) != null) {
                        try {
                            user = session.getUserContext();
                        }
                        catch (IllegalStateException illegalStateException) {
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                    if ((tcpip = IWorkspaceServer.getTCPIPConnection(sc = CommandUtilities.getServerComponentForJob(this.m_jfjob), "440196D4-90F0-11D0-9F41-00A024BB830C")) != null) {
                        String host = tcpip.getHostName();
                        int port = tcpip.getPort();
                        ServerContext appServer = null;
                        try {
                            LogicalServer lc = (LogicalServer)sc.getUsedByComponents().get(0);
                            appServer = (ServerContext)lc.getUsedByComponents().get(0);
                            server = new IWorkspaceServer(appServer, "440196D4-90F0-11D0-9F41-00A024BB830C", host, port);
                            if (!server.makeConnection(user)) {
                                server = null;
                            }
                        }
                        catch (ArrayIndexOutOfBoundsException ex) {
                            server = null;
                        }
                        catch (InvalidCredentialsException e) {
                            server = null;
                        }
                        catch (FatalConnectionFactoryException e) {
                            server = null;
                        }
                        catch (ServiceException e) {
                            server = null;
                        }
                    }
                }
                if (MetaUtilities.isDebug()) {
                    System.out.println("workspace server is: " + server);
                }
                rc = DeployedJob.delete(this.m_jfjob, this.m_factory, server);
                this.m_jfjob = null;
                this.m_job = null;
            }
            finally {
                if (server != null) {
                    try {
                        server.closeConnection();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        if (this.m_step != null) {
            this.m_factory.deleteMetadataObject((CMetadata)this.m_step);
            this.m_step = null;
        }
        return rc;
    }

    public static boolean delete(JFJob jfjob, MdFactory factory) throws MdException, RemoteException {
        return DeployedJob.delete(jfjob, factory, null);
    }

    private static boolean delete(JFJob jfjob, MdFactory factory, IWorkspaceServer server) throws MdException, RemoteException {
        boolean rc = true;
        AssociationList list = null;
        if (jfjob != null) {
            File jclfile;
            File file;
            block50: {
                Job job;
                jfjob.setTransformRole("SCHEDULER_JOB_DELETE");
                jfjob.setPublicType("");
                jfjob.getTrees().clear();
                jfjob.updateMetadataAll();
                list = jfjob.getProperties();
                for (Property property : list) {
                    AssociationList acelist = property.getAccessControls();
                    if (acelist.size() <= 0) continue;
                    factory.deleteMetadataObjects((List)acelist);
                }
                factory.deleteMetadataObjects((List)list);
                list = jfjob.getSteps();
                if (list.size() > 0) {
                    DeployedJob.deleteEvents(list);
                    factory.deleteMetadataObjects((List)list);
                }
                if ((job = jfjob.getAssociatedJob()) != null && (job.getTransformRole().compareTo("SCHEDULER_BRIDGE_JOB") == 0 || job.getTransformRole().compareTo("SCHEDULER_TERMINAL_JOB") == 0) && job.getJFJobs().size() == 1) {
                    job.setPublicType("");
                    job.updateMetadataAll();
                    factory.deleteMetadataObject((CMetadata)job);
                    job = null;
                }
                file = DeployedJob.getSourceCode(jfjob);
                jclfile = DeployedJob.getJCL(jfjob);
                try {
                    String s;
                    String filename;
                    String strDirectory;
                    String strFileName;
                    String fileExt;
                    String fileName;
                    int host;
                    block51: {
                        if (server == null) break block50;
                        host = CommandUtilities.getTargetOSForBatchServer(server.getServerComponent());
                        String strSourceFile = null;
                        if (job != null) {
                            if (job.getIsUserDefined() == 1) {
                                File jobfile = (File)job.getSourceCode();
                                if (jobfile != null) {
                                    String fileName2 = jobfile.getFileName();
                                    String fileExt2 = jobfile.getFileExtension();
                                    String strFileName2 = null;
                                    if (fileExt2.length() > 0) {
                                        if (fileExt2.startsWith(".")) {
                                            jobfile.setFileExtension(fileExt2.substring(1));
                                            strFileName2 = fileName2 + fileExt2;
                                        } else {
                                            strFileName2 = fileName2 + "." + fileExt2;
                                        }
                                    } else {
                                        strFileName2 = fileName2;
                                    }
                                    String strDirectory2 = "";
                                    if (jobfile.getDirectories().size() != 0) {
                                        strDirectory2 = ((Directory)file.getDirectories().get(0)).getDirectoryName();
                                    }
                                    strSourceFile = CommandUtilities.createFullPath(strDirectory2, strFileName2, host);
                                }
                            } else {
                                strSourceFile = "";
                            }
                        }
                        if (file != null && strSourceFile != null) {
                            fileName = file.getFileName();
                            fileExt = file.getFileExtension();
                            strFileName = null;
                            if (fileExt.length() > 0) {
                                if (fileExt.startsWith(".")) {
                                    file.setFileExtension(fileExt.substring(1));
                                    strFileName = fileName + fileExt;
                                } else {
                                    strFileName = fileName + "." + fileExt;
                                }
                            } else {
                                strFileName = fileName;
                            }
                            strDirectory = "";
                            if (file.getDirectories().size() != 0) {
                                strDirectory = ((Directory)file.getDirectories().get(0)).getDirectoryName();
                            }
                            if ((filename = CommandUtilities.createFullPath(strDirectory, strFileName, host)).compareTo(strSourceFile) != 0) {
                                try {
                                    DeployedJob.deletePhysicalFile(server.getWorkspace(), filename);
                                }
                                catch (SchedulerException e) {
                                    if (!LOGGER.isDebugEnabled() && !MetaUtilities.isDebug()) break block51;
                                    s = e.getStackTrace().toString();
                                    if (LOGGER.isDebugEnabled()) {
                                        LOGGER.debug(s);
                                    }
                                    System.err.println(s);
                                }
                            }
                        }
                    }
                    if (jclfile == null) break block50;
                    fileName = jclfile.getFileName();
                    fileExt = jclfile.getFileExtension();
                    strFileName = null;
                    if (fileExt.length() > 0) {
                        if (fileExt.startsWith(".")) {
                            jclfile.setFileExtension(fileExt.substring(1));
                            strFileName = fileName + fileExt;
                        } else {
                            strFileName = fileName + "." + fileExt;
                        }
                    } else {
                        strFileName = fileName;
                    }
                    strDirectory = "";
                    if (jclfile.getDirectories().size() != 0) {
                        strDirectory = ((Directory)jclfile.getDirectories().get(0)).getDirectoryName();
                    }
                    filename = CommandUtilities.createFullPath(strDirectory, strFileName, host);
                    try {
                        DeployedJob.deletePhysicalFile(server.getWorkspace(), filename);
                        try {
                            String cmdFile = filename.substring(0, filename.lastIndexOf(JCL_EXTENSION)) + CMD_EXTENSION;
                            DeployedJob.deletePhysicalFile(server.getWorkspace(), cmdFile);
                        }
                        catch (Exception ex) {
                            if (!LOGGER.isDebugEnabled() && !MetaUtilities.isDebug()) break block50;
                            s = ex.getStackTrace().toString();
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.trace(s);
                                break block50;
                            }
                            System.out.println(s);
                        }
                    }
                    catch (SchedulerException e) {
                        if (LOGGER.isDebugEnabled() || MetaUtilities.isDebug()) {
                            s = e.getStackTrace().toString();
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug(s);
                            } else {
                                System.err.println(s);
                            }
                        }
                        rc = false;
                    }
                }
                catch (Exception ex) {
                    if (!LOGGER.isDebugEnabled() && !MetaUtilities.isDebug()) break block50;
                    String s = ex.getStackTrace().toString();
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(s);
                    }
                    System.err.println(s);
                }
            }
            if (file != null && "SourceCode".compareTo(file.getTextRole()) == 0) {
                factory.deleteMetadataObject((CMetadata)file);
            }
            if (jclfile != null && "SourceCode".compareTo(jclfile.getTextRole()) == 0) {
                factory.deleteMetadataObject((CMetadata)jclfile);
            }
            try {
                factory.deleteMetadataObject((CMetadata)jfjob);
            }
            catch (MdException ex) {
                AssociationList templist = jfjob.getAssociatedJobs();
                if (templist != null) {
                    templist.removeAllElements();
                }
                if ((templist = jfjob.getTargetSpecifications()) != null) {
                    templist.removeAllElements();
                }
                if ((templist = jfjob.getComputeLocations()) != null) {
                    templist.removeAllElements();
                }
                if ((templist = jfjob.getResponsibleParties()) != null) {
                    templist.removeAllElements();
                }
                if ((templist = jfjob.getSourceCodes()) != null) {
                    templist.removeAllElements();
                }
                if ((templist = jfjob.getSourceSpecifications()) != null) {
                    templist.removeAllElements();
                }
                if ((templist = jfjob.getSteps()) != null) {
                    templist.removeAllElements();
                }
                jfjob.updateMetadataAll();
            }
            jfjob = null;
        }
        return rc;
    }

    public static void deletePhysicalFile(IWorkspace server, String filename) throws SchedulerException {
        if (server == null) {
            return;
        }
        submitSAS submitter = new submitSAS(server);
        StringBuffer code = new StringBuffer();
        code.append("data _null_;\n");
        code.append("  length fref $8;\n");
        code.append("  fref = \"\";\n");
        code.append("  rc = filename(fref,'");
        code.append(filename);
        code.append("');\n");
        code.append("  if (rc=0) and (fexist(fref)) then\n");
        code.append("    rc = fdelete(fref);\n");
        code.append("  rc = filename(fref, '');\n");
        code.append("run;\n");
        submitter.submitStatements(code);
    }

    private static void deleteEvents(AssociationList list) {
        Object[] mylist = list.toArray();
        int numObjs = list.size();
        for (int i = 0; i < numObjs; ++i) {
            TransformationStep step = (TransformationStep)mylist[i];
            DeployedJob.deleteEvents(step);
        }
    }

    public static boolean deleteEvents(TransformationStep step) {
        try {
            ArrayList<StepPrecedence> deletesp = new ArrayList<StepPrecedence>();
            ArrayList<TransformationStep> deletets = new ArrayList<TransformationStep>();
            ArrayList<Event> deleteev = new ArrayList<Event>();
            ArrayList deletepr = new ArrayList();
            AssociationList sps = step.getPredecessorDependencies();
            for (StepPrecedence sp : sps) {
                AssociationList tss = sp.getSuccessors();
                for (TransformationStep ts : tss) {
                    if (ts instanceof SyncStep) {
                        if (ts.getTransformRole().equalsIgnoreCase("AND") || ts.getTransformRole().equalsIgnoreCase("OR")) {
                            deletets.add(ts);
                            continue;
                        }
                        for (Event event : step.getTriggeringEvents()) {
                            Iterator properties = event.getProperties().iterator();
                            while (properties.hasNext()) {
                                deletepr.add(properties.next());
                            }
                            deleteev.add(event);
                        }
                        deletets.add(ts);
                        continue;
                    }
                    Iterator properties = step.getProperties().iterator();
                    while (properties.hasNext()) {
                        deletepr.add(properties.next());
                    }
                }
                deletesp.add(sp);
            }
            if (deletets.size() > 0) {
                for (int x = deletets.size() - 1; x >= 0; --x) {
                    ((TransformationStep)deletets.get(x)).delete();
                }
            }
            if (deletesp.size() > 0) {
                for (int x = deletesp.size() - 1; x >= 0; --x) {
                    ((StepPrecedence)deletesp.get(x)).delete();
                }
            }
            if (deleteev.size() > 0) {
                for (int x = deleteev.size() - 1; x >= 0; --x) {
                    ((Event)deleteev.get(x)).delete();
                }
            }
            if (deletepr.size() > 0) {
                for (int x = deletepr.size() - 1; x >= 0; --x) {
                    ((Property)deletepr.get(x)).delete();
                }
            }
        }
        catch (MdException ex) {
            return false;
        }
        catch (RemoteException ex) {
            return false;
        }
        return true;
    }

    public boolean remove(DeployedFlow dflow) throws MdException, RemoteException {
        JFJob flow = dflow.getMetadataObject();
        if (flow != null) {
            AssociationList steps = this.m_jfjob.getSteps();
            int numsteps = steps.size();
            for (int i = 0; i < numsteps; ++i) {
                AssociationList transformations;
                TransformationStep step;
                if (!(steps.get(i) instanceof TransformationStep) || (step = (TransformationStep)steps.get(i)).getActivities() == null || step.getActivities().size() <= 0) continue;
                TransformationActivity activity = (TransformationActivity)step.getActivities().get(0);
                JFJob currentFlow = null;
                AssociationList associationList = transformations = activity != null ? activity.getJobs() : null;
                if (transformations != null && transformations.size() > 0) {
                    currentFlow = (JFJob)transformations.get(0);
                }
                if (currentFlow == null || !flow.getFQID().equalsIgnoreCase(currentFlow.getFQID())) continue;
                DeployedJob.deleteEvents(step);
                step.delete();
                step.updateMetadataAll();
                dflow.removeJob(this);
                dflow.refresh();
                break;
            }
        }
        return true;
    }

    public void removeAll() throws MdException, RemoteException {
        ArrayList<TransformationStep> deleteList = new ArrayList<TransformationStep>();
        Object[] steps = this.m_jfjob.getSteps().toArray();
        int stlen = steps.length;
        for (int j = stlen - 1; j >= 0; --j) {
            if (!(steps[j] instanceof TransformationStep)) continue;
            TransformationStep step = (TransformationStep)steps[j];
            DeployedJob.deleteEvents(step);
            deleteList.add(step);
        }
        if (deleteList.size() > 0) {
            this.m_factory.deleteMetadataObjects(deleteList);
        }
    }

    public static String getInvalidChars() {
        return MetaUtilities.INVALIDJOBNAMECHARACTERS;
    }

    public static boolean isValidName(String name) {
        int namelen = name.length();
        if (namelen == 0) {
            return false;
        }
        for (int i = 0; i < namelen; ++i) {
            if (MetaUtilities.INVALIDJOBNAMECHARACTERS.indexOf(name.substring(i, i + 1)) == -1) continue;
            return false;
        }
        return true;
    }

    public UserContextInterface getUserContext() {
        return this.m_userContext;
    }

    public boolean setUserContext(UserContextInterface user) {
        this.m_userContext = user;
        return true;
    }

    public AssociationList getResponsibleParties() throws RemoteException, MdException {
        if (this.m_jfjob != null) {
            return this.m_jfjob.getResponsibleParties();
        }
        return null;
    }

    public String getResponsiblePartyForDeployment() throws RemoteException, MdException {
        return DeployedJob.getResponsibleUser(this.m_jfjob);
    }

    public static String getResponsiblePartyForDeployment(JFJob job) throws RemoteException, MdException {
        return DeployedJob.getResponsibleUser(job);
    }

    public boolean addResponsibleParty(UserContextInterface userContext) throws RemoteException, MdException {
        if (userContext == null) {
            InvalidParameterException ex = new InvalidParameterException(MetaUtilities.messageString(m_bundle.getString("DeployedJob.MissingRequiredObject.UserContext.fmt"), this.m_jfjob.getName()));
            throw ex;
        }
        List<ResponsibleParty> parties = DeployedJob.getResponsibleParties(userContext, this.m_factory, this.m_store);
        int num = parties != null ? parties.size() : 0;
        for (int j = 0; j < num; ++j) {
            ResponsibleParty party = parties.get(j);
            for (ResponsibleParty x : this.getResponsibleParties()) {
                if (x.getId().compareTo(party.getId()) != 0) continue;
            }
            this.addResponsibleParty(party);
        }
        return true;
    }

    private static String getResponsibleUser(JFJob job) throws RemoteException, MdException {
        String person = null;
        AssociationList list = job.getResponsibleParties();
        for (Object element : list) {
            AssociationList persons;
            if (!(element instanceof ResponsibleParty)) continue;
            ResponsibleParty party = (ResponsibleParty)element;
            if (party.getRole().equals(ResponsiblePartyRole)) {
                persons = ((ResponsibleParty)element).getPersons();
                if (persons.size() <= 0) continue;
                return ((Identity)persons.get(0)).getName();
            }
            if (!party.getRole().equals(ResponsiblePartyModifiedRole) || (persons = ((ResponsibleParty)element).getPersons()).size() <= 0) continue;
            person = ((Identity)persons.get(0)).getName();
        }
        return person;
    }

    public static ResponsibleParty getResponsibleParty(UserContextInterface user, MdFactory factory, MdObjectStore store) throws RemoteException, MdException {
        AssociationList logins;
        IdentityInterface identity = user.getPerson();
        if (identity == null) {
            return null;
        }
        Object obj = identity.getRepositoryEntity();
        Identity person = null;
        if (!(obj instanceof Identity)) {
            return null;
        }
        person = (Identity)obj;
        AssociationList parties = person.getResponsibilities();
        for (Object element : parties) {
            ResponsibleParty party;
            if (!(element instanceof ResponsibleParty) || !(party = (ResponsibleParty)element).getRole().equals(ResponsiblePartyRole)) continue;
            return party;
        }
        String rpName = person.getName();
        if (rpName.length() == 0 && (logins = person.getLogins()).size() > 0) {
            Login login = (Login)logins.get(0);
            rpName = login.getUserID();
        }
        ResponsibleParty schedulerParty = (ResponsibleParty)factory.createComplexMetadataObject(store, null, rpName, "ResponsibleParty", person.getRepositoryID());
        schedulerParty.setRole(ResponsiblePartyRole);
        AssociationList persons = schedulerParty.getPersons();
        persons.add((Object)person);
        schedulerParty.setPersons(persons);
        return schedulerParty;
    }

    public static List<ResponsibleParty> getResponsibleParties(UserContextInterface user, MdFactory factory, MdObjectStore store) throws RemoteException, MdException {
        AssociationList logins;
        ResponsibleParty party;
        ArrayList<ResponsibleParty> list = new ArrayList<ResponsibleParty>();
        boolean addScheduleParty = true;
        boolean addModifyParty = true;
        IdentityInterface identity = user.getPerson();
        if (identity == null) {
            return null;
        }
        Object obj = identity.getRepositoryEntity();
        Identity person = null;
        if (!(obj instanceof Identity)) {
            return null;
        }
        person = (Identity)obj;
        AssociationList parties = person.getResponsibilities();
        for (Object element : parties) {
            if (!(element instanceof ResponsibleParty) || !(party = (ResponsibleParty)element).getRole().equals(ResponsiblePartyRole)) continue;
            list.add(party);
            addScheduleParty = false;
        }
        parties = person.getResponsibilities();
        for (Object element : parties) {
            if (!(element instanceof ResponsibleParty) || !(party = (ResponsibleParty)element).getRole().equals(ResponsiblePartyModifiedRole)) continue;
            list.add(party);
            addModifyParty = false;
        }
        if (!addScheduleParty && !addModifyParty) {
            return list;
        }
        String rpName = person.getName();
        if (rpName.length() == 0 && (logins = person.getLogins()).size() > 0) {
            Login login = (Login)logins.get(0);
            rpName = login.getUserID();
        }
        if (addScheduleParty) {
            ResponsibleParty schedulerParty = (ResponsibleParty)factory.createComplexMetadataObject(store, null, rpName, "ResponsibleParty", person.getRepositoryID());
            schedulerParty.setRole(ResponsiblePartyRole);
            AssociationList persons = schedulerParty.getPersons();
            persons.add((Object)person);
            schedulerParty.setPersons(persons);
            list.add(schedulerParty);
        }
        if (addModifyParty) {
            ResponsibleParty modifyParty = (ResponsibleParty)factory.createComplexMetadataObject(store, null, rpName, "ResponsibleParty", person.getRepositoryID());
            modifyParty.setRole(ResponsiblePartyModifiedRole);
            AssociationList people = modifyParty.getPersons();
            people.add((Object)person);
            modifyParty.setPersons(people);
            list.add(modifyParty);
        }
        return list;
    }

    public boolean addResponsibleParty(ResponsibleParty party) throws RemoteException, MdException {
        if (party != null && this.m_jfjob != null) {
            return this.m_jfjob.getResponsibleParties().add((Object)party);
        }
        return false;
    }

    public boolean setResponsibleParties(AssociationList parties) throws RemoteException {
        if (parties == null || this.m_jfjob == null) {
            return false;
        }
        this.m_jfjob.setResponsibleParties(parties);
        return true;
    }

    public boolean setResponsibleParty(ResponsibleParty party) throws RemoteException, MdException {
        if (this.m_jfjob != null) {
            this.m_jfjob.getResponsibleParties().clear();
            this.m_jfjob.getResponsibleParties().add((Object)party);
            return true;
        }
        return false;
    }

    public boolean setResponsibleParties(UserContextInterface userContext, MdFactory factory, MdObjectStore store) throws RemoteException, MdException {
        List<ResponsibleParty> parties = DeployedJob.getResponsibleParties(userContext, factory, store);
        if (parties != null && parties.size() > 0) {
            this.m_jfjob.getResponsibleParties().clear();
            this.m_jfjob.getResponsibleParties().addAll(parties);
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof DeployedJob) {
            try {
                if (super.equals(obj)) {
                    return true;
                }
                return this.m_jfjob != null && this.m_jfjob.getId().equalsIgnoreCase(((DeployedJob)obj).m_jfjob.getId());
            }
            catch (RemoteException ex) {
                return false;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.m_jfjob != null) {
            try {
                int value = 0;
                String id = this.m_jfjob.getId();
                for (int x = 0; x < id.length(); ++x) {
                    char c = id.charAt(x);
                    value *= 10;
                    value += c;
                }
                return value;
            }
            catch (RemoteException ex) {
                return super.hashCode();
            }
        }
        return super.hashCode();
    }

    public String toString() {
        String str;
        try {
            str = this.getName();
        }
        catch (RemoteException ex) {
            str = "";
        }
        return str;
    }

    public boolean hasErrors() {
        return this.m_errorFlag != 0;
    }

    public int getErrorFlag() {
        return this.m_errorFlag;
    }

    public String errorConditions() throws RemoteException {
        String errmessage = "";
        String jobname = "";
        try {
            jobname = this.m_jfjob.getName();
        }
        catch (NullPointerException npe) {
            jobname = MetaUtilities.replaceInvalidCharactersInJobName(this.m_job.getName());
        }
        if ((this.m_errorFlag & 1) != 0) {
            errmessage = errmessage + MetaUtilities.messageString(m_bundle.getString("DeployedJob.MissingRequiredObject.Job.fmt"), jobname) + "\n";
        }
        if ((this.m_errorFlag & 0x10) != 0) {
            errmessage = errmessage + MetaUtilities.messageString(m_bundle.getString("DeployedJob.MissingRequiredObject.BatchServer.fmt"), jobname) + "\n";
        }
        if ((this.m_errorFlag & 0x100) != 0) {
            errmessage = errmessage + MetaUtilities.messageString(m_bundle.getString("DeployedJob.InvalidRequiredObject.SourceFile.fmt"), jobname) + "\n";
        }
        if ((this.m_errorFlag & 0x1000) != 0) {
            errmessage = errmessage + MetaUtilities.messageString(m_bundle.getString("DeployedJob.InvalidRequiredObject.JCL.fmt"), jobname) + "\n";
        }
        if ((this.m_errorFlag & 0x10000) != 0) {
            errmessage = errmessage + MetaUtilities.messageString(m_bundle.getString("DeployedJob.InvalidRequiredObject.BatchServer.fmt"), jobname) + "\n";
        }
        return errmessage;
    }

    public void reevaluateErrors() {
        if ((this.m_errorFlag & 1) != 0) {
            try {
                this.m_job = (Job)this.m_jfjob.getAssociatedJobs().get(0);
            }
            catch (MdException ex) {
                this.m_job = null;
                return;
            }
            catch (RemoteException ex) {
                this.m_job = null;
                return;
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                this.m_job = null;
                try {
                    int count = this.m_factory.getSecurityUtil().getAssociationCountForObject((CMetadata)this.m_jfjob, "AssociatedJob");
                    if (count > 0) {
                        this.m_errorFlag &= 0x11111110;
                        return;
                    }
                    return;
                }
                catch (MdException e) {
                    return;
                }
                catch (RemoteException e) {
                    return;
                }
            }
            catch (RuntimeException ex) {
                this.m_job = null;
                return;
            }
            this.m_errorFlag &= 0x11111110;
        }
        if ((this.m_errorFlag & 0x10) != 0) {
            try {
                this.getBatchServer();
                if (this.m_batchserver == null) {
                    return;
                }
            }
            catch (RuntimeException ex) {
                this.m_batchserver = null;
                return;
            }
            this.m_errorFlag &= 0x11111101;
        }
        if ((this.m_errorFlag & 0x10000) != 0) {
            try {
                int subtype;
                BatchServerInfo bsinfo;
                this.getBatchServer();
                if (this.m_batchserver == null && (bsinfo = MetaUtilities.getBatchServer(this.m_batchserver)).getType() == 2 && ((subtype = bsinfo.getSubType()) < 10 || subtype > 26)) {
                    return;
                }
            }
            catch (Exception ex) {
                return;
            }
            this.m_errorFlag &= 0x11101111;
        }
        if ((this.m_val_level == 1 || this.m_val_level == 2) && (this.m_errorFlag & 0x100) != 0) {
            try {
                if (this.getSourceCode() == null) {
                    return;
                }
            }
            catch (MdException ex) {
                return;
            }
            catch (RemoteException ex) {
                return;
            }
            catch (RuntimeException ex) {
                return;
            }
            this.m_errorFlag &= 0x11111011;
        }
        if ((this.m_val_level == 2 || this.m_val_level == 3) && (this.m_errorFlag & 0x1000) != 0) {
            try {
                this.m_jcl = this.getJCL();
                if (this.m_jcl == null) {
                    return;
                }
            }
            catch (MdException ex) {
                return;
            }
            catch (RemoteException ex) {
                return;
            }
            catch (RuntimeException ex) {
                return;
            }
            this.m_errorFlag &= 0x11110111;
        }
    }

    public void checkErrors() {
        block25: {
            try {
                this.m_job = (Job)this.m_jfjob.getAssociatedJobs().get(0);
                this.m_errorFlag &= 0x11111110;
            }
            catch (MdException ex) {
                this.m_errorFlag |= 1;
            }
            catch (RemoteException ex) {
                this.m_errorFlag |= 1;
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                try {
                    int count = this.m_factory.getSecurityUtil().getAssociationCountForObject((CMetadata)this.m_jfjob, "AssociatedJob");
                    if (count > 0) {
                        this.m_errorFlag &= 0x11111110;
                    }
                    this.m_errorFlag |= 1;
                }
                catch (MdException e) {
                    this.m_errorFlag |= 1;
                }
                catch (RemoteException e) {
                    this.m_errorFlag |= 1;
                }
            }
            catch (RuntimeException ex) {
                this.m_errorFlag |= 1;
            }
            try {
                this.getBatchServer();
                if (this.m_batchserver != null) {
                    try {
                        BatchServerInfo bsinfo = MetaUtilities.getBatchServer(this.m_batchserver);
                        if (bsinfo.getType() == 2) {
                            int subtype = bsinfo.getSubType();
                            this.m_errorFlag = subtype < 10 || subtype > 26 ? (this.m_errorFlag |= 0x10000) : (this.m_errorFlag &= 0x11101111);
                        }
                    }
                    catch (Exception bsinfo) {
                        // empty catch block
                    }
                    this.m_errorFlag &= 0x11111101;
                    break block25;
                }
                this.m_errorFlag |= 0x10;
            }
            catch (RuntimeException ex) {
                this.m_errorFlag |= 0x10;
            }
        }
        if (this.m_val_level == 1) {
            try {
                File src = this.getSourceCode();
                this.m_errorFlag = src != null ? (src.getDirectories().size() > 0 ? (this.m_errorFlag &= 0x11111011) : (src.getName().indexOf(47) == -1 && src.getName().indexOf(92) == -1 ? (this.m_errorFlag |= 0x100) : (this.m_errorFlag &= 0x11111011))) : (this.m_errorFlag |= 0x100);
            }
            catch (MdException ex) {
                this.m_errorFlag |= 0x100;
            }
            catch (RemoteException ex) {
                this.m_errorFlag |= 0x100;
            }
            catch (RuntimeException ex) {
                this.m_errorFlag |= 0x100;
            }
        }
        if (this.m_val_level == 2) {
            try {
                this.m_jcl = this.getJCL();
                this.m_errorFlag = this.m_jcl != null ? (this.m_errorFlag &= 0x11110111) : (this.m_errorFlag |= 0x1000);
            }
            catch (MdException ex) {
                this.m_errorFlag |= 0x1000;
            }
            catch (RemoteException ex) {
                this.m_errorFlag |= 0x1000;
            }
            catch (RuntimeException ex) {
                this.m_errorFlag |= 0x1000;
            }
        }
    }

    public String getLogFile(TransformationStep step, IWorkspace workspace) throws MdException, RemoteException {
        String logFile;
        block9: {
            this.m_matchLogList = new ArrayList<String>();
            String fileName = null;
            String logoptions = CommandUtilities.normalizePath(CommandUtilities.getLogParm(step), -1);
            int pos = logoptions.lastIndexOf(CommandUtilities.getPathSeparator(-1));
            String dir = null;
            dir = pos > 0 ? logoptions.substring(0, pos) : logoptions;
            fileName = CommandUtilities.getBaseLogName(step);
            logFile = null;
            if (fileName != null && fileName.length() > 0) {
                try {
                    int i;
                    List<String> filelist = IWorkspaceServer.listFiles(dir, workspace);
                    int total = filelist.size();
                    for (i = 0; i < total; ++i) {
                        if (!filelist.get(i).toString().startsWith(fileName)) continue;
                        this.m_matchLogList.add(filelist.get(i).toString());
                    }
                    if (this.m_matchLogList.size() > 0) {
                        logFile = dir + "/" + this.m_matchLogList.get(this.m_matchLogList.size() - 1).toString();
                    }
                    if (logFile == null) {
                        fileName = CommandUtilities.getBaseLogNameNoFlowPrefix(step);
                        total = filelist.size();
                        for (i = 0; i < total; ++i) {
                            if (!filelist.get(i).toString().startsWith(fileName)) continue;
                            this.m_matchLogList.add(filelist.get(i).toString());
                        }
                        if (this.m_matchLogList.size() > 0) {
                            logFile = dir + "/" + this.m_matchLogList.get(this.m_matchLogList.size() - 1).toString();
                        }
                    }
                }
                catch (GenericError ex) {
                    if (!LOGGER.isDebugEnabled() && !MetaUtilities.isDebug()) break block9;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(ex.getStackTrace().toString());
                    }
                    ex.printStackTrace();
                }
            }
        }
        return logFile;
    }

    public List<String> getLogFileList() {
        return this.m_matchLogList;
    }

    private void _setJobAndBatch(boolean readFromServer) throws RemoteException, MdException {
        if (this.m_jfjob.getTransformRole().compareTo("SCHEDULER_FLOW") == 0) {
            this.m_job = null;
            this.m_batchserver = null;
        } else {
            block20: {
                try {
                    this.m_job = (Job)this.m_jfjob.getAssociatedJobs(readFromServer).get(0);
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    int count = this.m_factory.getSecurityUtil().getAssociationCountForObject((CMetadata)this.m_jfjob, "AssociatedJob");
                    if (count > 0) break block20;
                    this.m_errorFlag |= 1;
                }
            }
            if (this.m_job != null && this.m_job.getTransformRole().compareTo("SCHEDULER_BRIDGE_JOB") == 0 && this.m_job.getTransformationSources(readFromServer).size() == 0) {
                if (readFromServer) {
                    this.m_errorFlag |= 1;
                } else {
                    int count = this.m_factory.getSecurityUtil().getAssociationCountForObject((CMetadata)this.m_job, "TransformationSources");
                    if (count <= 0) {
                        this.m_errorFlag |= 1;
                    }
                }
            }
            if (readFromServer) {
                this.m_jfjob.getProperties(true);
                this.m_jfjob.getTargetSpecifications(true);
            }
            this.m_batchserver = CommandUtilities.getServerComponentForJob(this.m_jfjob);
            if (this.m_batchserver == null) {
                this.m_errorFlag |= 0x10;
            } else {
                try {
                    boolean requiresJCL = BatchServerInfo.requiresJCLFile((String)this.m_batchserver.getClassIdentifier(), (int)CommandUtilities.getTargetOSForBatchServer(this.m_batchserver));
                    if (BatchServerInfo.requiresSourceFile((String)this.m_batchserver.getClassIdentifier())) {
                        this.m_val_level = 1;
                        this.m_source = this.getSourceCode();
                        if (readFromServer) {
                            this.m_store.refreshObjectFromServer((CMetadata)this.m_source, false, true);
                            this.m_source.getDirectories(true);
                        }
                        if (requiresJCL) {
                            this.m_jcl = this.getJCL();
                            if (readFromServer) {
                                this.m_store.refreshObjectFromServer((CMetadata)this.m_jcl, false, true);
                                this.m_jcl.getDirectories(true);
                            }
                            this.m_val_level = 2;
                        }
                    } else if (requiresJCL) {
                        this.m_jcl = this.getJCL();
                        if (readFromServer) {
                            this.m_store.refreshObjectFromServer((CMetadata)this.m_jcl, false, true);
                            this.m_jcl.getDirectories(true);
                        }
                        this.m_val_level = 3;
                    }
                }
                catch (InvalidParameterException ex) {
                    this.m_errorFlag |= 0x10;
                }
            }
        }
    }

    private void _initialize() throws MdException, RemoteException {
        if (this.m_jfjob != null) {
            this.m_reposID = this.m_jfjob.getId().substring(0, 8);
            if (this.m_jfjob.getObjectStore() != null) {
                this.m_store = (MdObjectStore)this.m_jfjob.getObjectStore();
                this.m_factory = this.m_store.getFactory();
            } else {
                this.m_factory = new MdFactoryImpl();
                this.m_store = this.m_factory.createObjectStore(null, "DeployedJob");
            }
        } else if (this.m_job != null) {
            this.m_reposID = this.m_job.getId().substring(0, 8);
            if (this.m_job.getObjectStore() != null) {
                this.m_store = (MdObjectStore)this.m_job.getObjectStore();
                this.m_factory = this.m_store.getFactory();
            } else {
                this.m_factory = new MdFactoryImpl();
                this.m_store = this.m_factory.createObjectStore(null, "DeployedJob");
            }
        } else if (this.m_step != null) {
            this.m_reposID = this.m_step.getId().substring(0, 8);
            if (this.m_step.getObjectStore() != null) {
                this.m_store = (MdObjectStore)this.m_step.getObjectStore();
                this.m_factory = this.m_store.getFactory();
            } else {
                this.m_factory = new MdFactoryImpl();
                this.m_store = this.m_factory.createObjectStore(null, "DeployedJob");
            }
        } else {
            this.m_factory = new MdFactoryImpl();
            this.m_store = this.m_factory.createObjectStore(null, "DeployedJob");
        }
    }

    private void createJFJobObject() throws MdException, RemoteException {
        String strJobName = MetaUtilities.replaceInvalidCharactersInJobName(this.m_job.getName());
        if (this.m_jfjob == null) {
            this.m_jfjob = (JFJob)this.m_factory.createComplexMetadataObject(this.m_store, null, strJobName, "JFJob", this.m_reposID, null);
            this.m_jfjob.setTransformRole("SCHEDULER_JOB");
            this.m_jfjob.setUsageVersion("2000000.0");
            this.m_jfjob.setPublicType("DeployedJob");
            CommandUtilities.setServerComponentForJob(this.m_jfjob, this.m_batchserver);
            Property property = (Property)this.m_factory.createComplexMetadataObject(this.m_store, null, "LogFlag", "Property", this.m_reposID, null);
            property.setPropertyName("LogFlag");
            if (this.m_batchserver.getClassIdentifier().equalsIgnoreCase("e20e54b3-e5f4-47ed-b21d-03109bf9a4b8") || this.m_batchserver.getClassIdentifier().equalsIgnoreCase("d6644527-7a09-4fe2-8bac-1caca2f6a46c")) {
                property.setDefaultValue("true");
            } else {
                property.setDefaultValue("false");
            }
            property.setSQLType(12);
            this.m_jfjob.getProperties().add((Object)property);
        }
        if (this.m_userContext != null) {
            this.addResponsibleParty(this.m_userContext);
        }
        AssociationList properties = this.m_job.getProperties();
        int numprops = properties.size();
        for (int i = 0; i < numprops; ++i) {
            Property property;
            Property sprop = (Property)properties.get(i);
            if (sprop.getPropertyName().equalsIgnoreCase("CommonArgs")) {
                property = (Property)this.m_factory.createComplexMetadataObject(this.m_store, null, "CommonArgs", "Property", this.m_reposID, null);
                property.setPropertyName("CommonArgs");
                property.setDefaultValue(sprop.getDefaultValue());
                property.setSQLType(12);
                this.m_jfjob.getProperties().add((Object)property);
                continue;
            }
            if (!sprop.getPropertyName().equalsIgnoreCase("CmdArgs")) continue;
            property = (Property)this.m_factory.createComplexMetadataObject(this.m_store, null, "CmdArgs", "Property", this.m_reposID, null);
            property.setPropertyName("CmdArgs");
            property.setDefaultValue(sprop.getDefaultValue());
            property.setSQLType(12);
            this.m_jfjob.getProperties().add((Object)property);
        }
        this.m_jfjob.setDesc(this.m_job.getDesc());
        this.m_jfjob.setAssociatedJob(this.m_job);
        if (this.m_source != null) {
            this.m_jfjob.setSourceCode((Text)this.m_source);
        }
    }

    public String getDeploymentDirectory() {
        return this.m_deployDir;
    }

    public void setDeploymentDirectory(String dir) {
        this.m_deployDir = dir;
    }

    public void checkJCLGeneration() throws SchedulerException {
        block28: {
            try {
                String dirname;
                if (CommandUtilities.getTargetOSForBatchServer(this.m_batchserver) != 2 || DeployedJob.getJCL(this.m_jfjob) != null) break block28;
                String basename = this.m_jfjob.getName();
                String jclext = JCL_EXTENSION.substring(1);
                String repos = "A0000001." + this.m_reposID;
                Directory dir = MetaUtilities.getDirectoryFromPath(this.m_deployDir, (MdStore)this.m_store, repos);
                if (dir == null && (dir = MetaUtilities.createDirectoryObject(dirname = this.m_batchserver.getName(), this.m_store, repos)) != null) {
                    dir.setDirectoryName(this.m_deployDir);
                }
                File jclObj = MetaUtilities.createSourceCodeObject(basename, dir, this.m_store, this.m_reposID);
                jclObj.setFileName(basename);
                jclObj.setFileExtension(jclext);
                this.setJCL(jclObj);
                try {
                    String jclName = basename + JCL_EXTENSION;
                    String strFullName = CommandUtilities.createFullPath(this.m_deployDir, jclName, 2);
                    String runas = this.getRunAs();
                    IFileService rio = this.getFileService(this.m_batchserver);
                    if (rio != null) {
                        String s;
                        String jcl;
                        String cmd = CommandUtilities.getCommandLineFromBatchServer(this.m_batchserver);
                        String commonArgs = MetaUtilities.getProperty((Root)this.m_jfjob, "CommonArgs");
                        if (commonArgs == null || commonArgs.trim().length() <= 0) {
                            commonArgs = MetaUtilities.getProperty((Root)this.m_batchserver, "CommonArgs");
                        }
                        String jobcmdargs = MetaUtilities.getProperty((Root)this.m_jfjob, "CmdArgs");
                        if (LOGGER.isDebugEnabled() || MetaUtilities.isDebug()) {
                            String s1 = "command is: " + cmd;
                            String s2 = "common arguments are: " + commonArgs;
                            String s3 = "job arguments are: " + jobcmdargs;
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug(s1);
                                LOGGER.debug(s2);
                                LOGGER.debug(s3);
                            } else {
                                System.out.println(s1);
                                System.out.println(s2);
                                System.out.println(s3);
                            }
                        }
                        if ((jcl = DeployedJob.generateJCLFromTemplate(rio, cmd, commonArgs, jobcmdargs, runas, strFullName)) != null) {
                            if (CommandUtilities.saveToRemoteFile(rio, strFullName, 2, jcl)) {
                                this.m_errorFlag &= 0x11110111;
                            } else {
                                if (LOGGER.isDebugEnabled() || MetaUtilities.isDebug()) {
                                    s = "Unable to save the JCL file to server.";
                                    if (LOGGER.isDebugEnabled()) {
                                        LOGGER.debug(s);
                                    } else {
                                        System.out.println(s);
                                    }
                                }
                                this.m_errorFlag |= 0x1000;
                            }
                        } else {
                            if (LOGGER.isDebugEnabled() || MetaUtilities.isDebug()) {
                                s = "Failed to generate the JCL file from the template.";
                                if (LOGGER.isDebugEnabled()) {
                                    LOGGER.debug(s);
                                } else {
                                    System.out.println(s);
                                }
                            }
                            this.m_errorFlag |= 0x1000;
                        }
                        break block28;
                    }
                    if (LOGGER.isDebugEnabled() || MetaUtilities.isDebug()) {
                        String s = "Unable to obtain the FileService.";
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug(s);
                        } else {
                            System.out.println(s);
                        }
                    }
                    this.m_errorFlag |= 0x1000;
                }
                catch (GenericError ge) {
                    if (MetaUtilities.isDebug()) {
                        ge.printStackTrace();
                    }
                    this.m_errorFlag |= 0x1000;
                }
            }
            catch (Exception ex) {
                if (MetaUtilities.isDebug()) {
                    ex.printStackTrace();
                }
                this.m_errorFlag |= 0x1000;
            }
        }
        if ((this.m_errorFlag & 0x1000) != 0) {
            String jobname = "";
            try {
                jobname = this.m_jfjob.getName();
            }
            catch (Exception jclext) {
                // empty catch block
            }
            SchedulerException se = new SchedulerException(MetaUtilities.messageString(m_bundle.getString("DeployedJob.InvalidRequiredObject.JCL.fmt"), jobname));
            throw se;
        }
    }

    public static String generateJCLFromTemplate(IFileService rio, String command, String commonArgs, String jobcmdargs, String runas, String jclFile) throws GenericError {
        String template;
        boolean overEighty = false;
        StringBuffer cmd = new StringBuffer(command);
        if (cmd.length() > 80) {
            overEighty = true;
        }
        if ((template = cmd.toString()).startsWith("\"") || template.startsWith("'")) {
            int index;
            String stripName = template.substring(1, template.length() - 1);
            template = !stripName.endsWith(JCL_EXTENSION) ? ((index = stripName.lastIndexOf(".")) > 0 ? stripName.substring(0, index) + JCL_EXTENSION : stripName + JCL_EXTENSION) : ((index = template.lastIndexOf(".")) > 0 ? template.substring(0, index) + JCL_EXTENSION : template + JCL_EXTENSION);
        } else if (!template.endsWith(JCL_EXTENSION)) {
            template = template.substring(0, template.lastIndexOf(".")) + JCL_EXTENSION;
        }
        if (LOGGER.isDebugEnabled() || MetaUtilities.isDebug()) {
            String s = "JCL Template file is: " + template;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(s);
            } else {
                System.out.println(s);
            }
        }
        StringBuffer contents = CommandUtilities.readFromRemoteFile(rio, template, "", "open_ed-1047", 2);
        String jcl = contents.toString();
        String CMDPLACEHOLDER = "$CMDLINE$";
        String[] args = commonArgs != null ? commonArgs.split(" ") : null;
        int numTokens = args != null ? args.length : 0;
        for (int i = 0; i < numTokens; ++i) {
            cmd.append("\n");
            String token = args[i];
            if (token.length() > 80) {
                overEighty = true;
            }
            cmd.append(token);
        }
        String[] jobargs = jobcmdargs != null ? jobcmdargs.split(" ") : null;
        numTokens = jobargs != null ? jobargs.length : 0;
        for (int i = 0; i < numTokens; ++i) {
            cmd.append("\n");
            String token = jobargs[i];
            if (token.length() > 80) {
                overEighty = true;
            }
            cmd.append(token);
        }
        if (LOGGER.isDebugEnabled() || MetaUtilities.isDebug()) {
            String s = "Command inside JCL is: " + cmd.toString();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(s);
            } else {
                System.out.println(s);
            }
        }
        if (overEighty) {
            block39: {
                String cmd2 = MetaUtilities.replaceString(cmd.toString(), "\n", " ");
                if (LOGGER.isDebugEnabled() || MetaUtilities.isDebug()) {
                    String s = "Command contains a token over 80 characters";
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(s);
                    } else {
                        System.out.println(s);
                    }
                }
                try {
                    String cmdFile = jclFile.substring(0, jclFile.lastIndexOf(JCL_EXTENSION)) + CMD_EXTENSION;
                    if (LOGGER.isDebugEnabled() || MetaUtilities.isDebug()) {
                        String s1 = "CommandFile is: " + cmdFile;
                        String s2 = "Contents of CommandFile is: " + cmd2.toString();
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug(s1);
                            LOGGER.debug(s2);
                        } else {
                            System.out.println(s1);
                            System.out.println(s2);
                        }
                    }
                    if (CommandUtilities.saveToRemoteFile(rio, cmdFile, 2, cmd2)) {
                        String DDstr = "//STDPARM DD *";
                        jcl = MetaUtilities.replaceString(jcl, DDstr, "//STDIN DD PATHOPTS=(ORDONLY),");
                        String SHstr = "SH $CMDLINE$";
                        String PATH = "// PATH='" + cmdFile + "'";
                        int pathLength = PATH.length();
                        if (pathLength > 72) {
                            StringBuffer neoPath = new StringBuffer(PATH.substring(0, 71) + "+\n");
                            int index = 71;
                            while (index + 56 <= pathLength) {
                                neoPath.append("//             " + PATH.substring(index, index + 56) + "+\n");
                                index += 56;
                            }
                            neoPath.append("//             " + PATH.substring(index));
                            jcl = MetaUtilities.replaceString(jcl, SHstr, neoPath.toString());
                            if (LOGGER.isDebugEnabled() || MetaUtilities.isDebug()) {
                                String s = "Patching the JCL from: '" + SHstr + "' to '" + neoPath.toString() + "'";
                                if (LOGGER.isDebugEnabled()) {
                                    LOGGER.debug(s);
                                } else {
                                    System.out.println(s);
                                }
                            }
                        } else {
                            jcl = MetaUtilities.replaceString(jcl, SHstr, PATH);
                            if (LOGGER.isDebugEnabled() || MetaUtilities.isDebug()) {
                                String s = "Patching the JCL from: '" + SHstr + "' to '" + PATH + "'";
                                if (LOGGER.isDebugEnabled()) {
                                    LOGGER.debug(s);
                                } else {
                                    System.out.println(s);
                                }
                            }
                        }
                        break block39;
                    }
                    if (LOGGER.isDebugEnabled() || MetaUtilities.isDebug()) {
                        String s = "Unable to save the CMDSTEP for JCL file to server.";
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug(s);
                        } else {
                            System.out.println(s);
                        }
                    }
                    return null;
                }
                catch (GenericError ge) {
                    if (MetaUtilities.isDebug()) {
                        ge.printStackTrace();
                    }
                    return null;
                }
            }
            jcl = MetaUtilities.replaceString(jcl, CMDPLACEHOLDER, cmd.toString());
        } else {
            jcl = MetaUtilities.replaceString(jcl, CMDPLACEHOLDER, cmd.toString());
        }
        String RUNASPLACEHOLDER = "$USER$";
        if (runas != null && runas.length() > 0) {
            jcl = MetaUtilities.replaceString(jcl, RUNASPLACEHOLDER, runas);
        }
        return jcl;
    }

    private IFileService getFileService(ServerComponent mdSC) throws RemoteException, MdException, InvalidParameterException, CallbackCancelledException, SchedulerException {
        IWorkspace ws;
        SessionContextInterface session;
        UserContextInterface user = this.m_userContext;
        if (user == null && (session = MetaUtilities.getSessionContext()) != null) {
            user = session.getUserContext();
        }
        if ((ws = IWorkspaceServer.checkConnectionToServer(user, mdSC, "440196D4-90F0-11D0-9F41-00A024BB830C")) != null) {
            return ws.FileService();
        }
        return null;
    }

    private static String _getProperty(Root metadata, String propName) throws MdException, RemoteException {
        try {
            AssociationList properties = metadata.getProperties();
            int propsize = properties.size();
            for (int i = 0; i < propsize; ++i) {
                Property property = (Property)properties.elementAt(i);
                if (!property.getPropertyName().equalsIgnoreCase(propName)) continue;
                return property.getDefaultValue();
            }
        }
        catch (NullPointerException npe) {
            return null;
        }
        return null;
    }

    private static String _getLastProperty(Root metadata, String propName) throws MdException, RemoteException {
        Property returnProperty = null;
        long returnPropertyTimestamp = 0L;
        AssociationList properties = metadata.getProperties();
        int propsize = properties.size();
        for (int i = 0; i < propsize; ++i) {
            Property property = (Property)properties.elementAt(i);
            if (!property.getPropertyName().equalsIgnoreCase(propName)) continue;
            String lastMod = property.getDesc();
            try {
                long lastModNum = Long.parseLong(lastMod);
                if (lastModNum <= returnPropertyTimestamp) continue;
                returnPropertyTimestamp = lastModNum;
                returnProperty = property;
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (returnProperty == null) {
            return null;
        }
        return returnProperty.getDefaultValue();
    }

    private static Property _setProperty(Root metadata, String propName, MdFactory factory, MdObjectStore store, String value) throws MdException, RemoteException {
        Property property;
        AssociationList properties = metadata.getProperties();
        int propsize = properties.size();
        for (int i = 0; i < propsize; ++i) {
            property = (Property)properties.elementAt(i);
            if (property == null || !property.getPropertyName().equalsIgnoreCase(propName)) continue;
            property.setDefaultValue(value);
            return property;
        }
        String repos = metadata.getRepositoryID();
        property = (Property)factory.createComplexMetadataObject(store, null, propName, "Property", repos, null);
        property.setPropertyName(propName);
        property.setDefaultValue(value);
        property.setSQLType(12);
        properties.add((Object)property);
        return property;
    }

    private static boolean _removeProperty(Root metadata, String propName) throws MdException, RemoteException {
        AssociationList properties = metadata.getProperties();
        int propsize = properties.size();
        for (int i = 0; i < propsize; ++i) {
            Property property = (Property)properties.elementAt(i);
            if (!property.getPropertyName().equalsIgnoreCase(propName)) continue;
            return properties.remove((Object)property);
        }
        return true;
    }

    private boolean validateData() throws MdException, RemoteException {
        int count;
        boolean rc = true;
        if (this.m_job == null && this.m_jfjob.getTransformRole().compareTo("SCHEDULER_FLOW") != 0 && (count = this.m_factory.getSecurityUtil().getAssociationCountForObject((CMetadata)this.m_jfjob, "AssociatedJob")) <= 0) {
            this.m_errorFlag |= 1;
        }
        try {
            if (this.m_batchserver == null) {
                this.m_errorFlag |= 0x10;
                rc = false;
            } else if (BatchServerInfo.requiresSourceFile((String)this.m_batchserver.getClassIdentifier())) {
                this.m_val_level = BatchServerInfo.requiresJCLFile((String)this.m_batchserver.getClassIdentifier(), (int)CommandUtilities.getTargetOSForBatchServer(this.m_batchserver)) ? 2 : 1;
            } else if (BatchServerInfo.requiresJCLFile((String)this.m_batchserver.getClassIdentifier(), (int)CommandUtilities.getTargetOSForBatchServer(this.m_batchserver))) {
                this.m_val_level = 3;
            }
        }
        catch (InvalidParameterException ex) {
            this.m_errorFlag |= 0x10;
            rc = false;
        }
        switch (this.m_val_level) {
            case 3: {
                String jname;
                if (this.m_jcl == null) {
                    try {
                        this.m_jcl = this.getJCL();
                    }
                    catch (NullPointerException npe) {
                        this.m_jcl = null;
                    }
                    catch (MdException md) {
                        this.m_jcl = null;
                    }
                    if (this.m_jcl == null) {
                        this.m_errorFlag |= 0x1000;
                        rc = false;
                    }
                }
                if (this.m_jcl == null || (jname = this.m_jcl.getFileName()).length() > 0 && MetaUtilities.isValidFilename(jname)) break;
                this.m_errorFlag |= 0x1000;
                rc = false;
                break;
            }
            case 2: {
                String jname;
                if (this.m_jcl == null) {
                    try {
                        this.m_jcl = this.getJCL();
                    }
                    catch (NullPointerException npe) {
                        this.m_jcl = null;
                    }
                    catch (MdException md) {
                        this.m_jcl = null;
                    }
                    if (this.m_jcl == null) {
                        this.m_errorFlag |= 0x1000;
                        rc = false;
                    }
                }
                if (!(this.m_jcl == null || (jname = this.m_jcl.getFileName()).length() > 0 && MetaUtilities.isValidFilename(jname))) {
                    this.m_errorFlag |= 0x1000;
                    rc = false;
                }
            }
            case 1: {
                String fname;
                if (this.m_source == null) {
                    try {
                        this.m_source = this.getSourceCode();
                    }
                    catch (NullPointerException npe) {
                        this.m_source = null;
                    }
                    catch (MdException md) {
                        this.m_source = null;
                    }
                    if (this.m_source == null) {
                        this.m_errorFlag |= 0x100;
                        rc = false;
                    }
                }
                if (this.m_source == null || (fname = this.m_source.getFileName()).length() > 0 && MetaUtilities.isValidFilename(fname)) break;
                this.m_errorFlag |= 0x100;
                rc = false;
            }
        }
        return rc;
    }
}

