/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.deployjob;

import com.sas.iom.SAS.IFileService;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.JFJob;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.ServerComponent;
import com.sas.scheduler.api.oma.CommandUtilities;
import com.sas.scheduler.api.oma.DeployedFlow;
import com.sas.scheduler.api.oma.DeployedJob;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.model.SchedulerException;
import com.sas.services.user.UserContextInterface;
import java.rmi.RemoteException;
import java.util.ResourceBundle;

public class DataStepProgramDeployer {
    private static final ResourceBundle m_bundle = MetaUtilities.getMyResourceBundle(DataStepProgramDeployer.class);
    private static final String FILEPLACEHOLDER = "$INPUT$";
    private static final String RUNASPLACEHOLDER = "$USER$";

    private static DeployedJob BuildMetaObjects(String name, String filepath, boolean jcl, Directory dir, ServerComponent server, UserContextInterface userContext, MdFactory factory, MdObjectStore store, String repos) throws SchedulerException {
        String filename = null;
        String basename = null;
        try {
            String file = CommandUtilities.normalizePath(filepath, CommandUtilities.getTargetOSForBatchServer(server));
            filename = CommandUtilities.getFilenameForBatchServer(file, server);
            basename = CommandUtilities.getBasenameForBatchServer(file, server);
        }
        catch (Exception ex) {
            String file;
            filename = file = CommandUtilities.normalizePath(filepath, -1);
            basename = file;
        }
        return DataStepProgramDeployer.BuildMetaObjects(name, filename, basename, jcl ? "jcl" : null, dir, server, userContext, factory, store, repos);
    }

    public static DeployedJob BuildMetaObjects(String name, String filename, String basename, String jclext, Directory dir, ServerComponent server, UserContextInterface userContext, MdFactory factory, MdObjectStore store, String repos) throws SchedulerException {
        try {
            if (!DeployedJob.isValidName(name)) {
                throw new SchedulerException(MetaUtilities.messageString(m_bundle.getString("DataStepProgramDeployer.ErrorMsg.InvalidJobName.fmt"), DeployedFlow.getInvalidChars()), DataStepProgramDeployer.class, "DataStepProgramDeployer.ErrorMsg.InvalidJobName.fmt", new Object[]{DeployedFlow.getInvalidChars()});
            }
            Job job = MetaUtilities.createUserWrittenJobObject(name, null, null, store, repos);
            job.setTransformRole("SCHEDULER_JOB");
            File targetfile = MetaUtilities.createSourceCodeObject(basename, dir, store, repos);
            targetfile.setFileName(filename);
            return DataStepProgramDeployer.BuildMetaObjects(job, targetfile, basename, jclext, dir, server, userContext, factory, store, repos);
        }
        catch (MdException e) {
            String message = e.getLocalizedMessage();
            if (message == null || message.length() == 0) {
                message = e.toString();
            }
            throw new SchedulerException(message != null ? message : m_bundle.getString("DataStepProgramDeployer.UnknownException.txt"), DataStepProgramDeployer.class, "DataStepProgramDeployer.UnknownException.txt", null);
        }
        catch (RemoteException e) {
            String message = e.getLocalizedMessage();
            if (message == null || message.length() == 0) {
                message = e.toString();
            }
            throw new SchedulerException(message != null ? message : m_bundle.getString("DataStepProgramDeployer.UnknownException.txt"), DataStepProgramDeployer.class, "DataStepProgramDeployer.UnknownException.txt", null);
        }
        catch (RuntimeException e) {
            String message = e.getLocalizedMessage();
            if (message == null || message.length() == 0) {
                message = e.toString();
            }
            throw new SchedulerException(message != null ? message : m_bundle.getString("DataStepProgramDeployer.UnknownException.txt"), DataStepProgramDeployer.class, "DataStepProgramDeployer.UnknownException.txt", null);
        }
    }

    public static DeployedJob BuildMetaObjects(String name, Job job, ServerComponent server, UserContextInterface userContext, MdFactory factory, MdObjectStore store, String repos) throws SchedulerException {
        try {
            if (!DeployedFlow.isValidName(name)) {
                throw new SchedulerException(MetaUtilities.messageString(m_bundle.getString("DataStepProgramDeployer.ErrorMsg.InvalidJobName.fmt"), DeployedFlow.getInvalidChars()), DataStepProgramDeployer.class, "DataStepProgramDeployer.ErrorMsg.InvalidJobName.fmt", new Object[]{DeployedFlow.getInvalidChars()});
            }
            if (job == null) {
                job = MetaUtilities.createTerminalJobObject(name, store, repos);
            }
            DeployedJob djob = new DeployedJob(job, server, userContext, (File)null, repos);
            return djob;
        }
        catch (MdException e) {
            String message = e.getLocalizedMessage();
            if (message == null || message.length() == 0) {
                message = e.toString();
            }
            throw new SchedulerException(message != null ? message : m_bundle.getString("DataStepProgramDeployer.UnknownException.txt"), DataStepProgramDeployer.class, "DataStepProgramDeployer.UnknownException.txt", null);
        }
        catch (RemoteException e) {
            String message = e.getLocalizedMessage();
            if (message == null || message.length() == 0) {
                message = e.toString();
            }
            throw new SchedulerException(message != null ? message : m_bundle.getString("DataStepProgramDeployer.UnknownException.txt"), DataStepProgramDeployer.class, "DataStepProgramDeployer.UnknownException.txt", null);
        }
        catch (RuntimeException e) {
            String message = e.getLocalizedMessage();
            if (message == null || message.length() == 0) {
                message = e.toString();
            }
            throw new SchedulerException(message != null ? message : m_bundle.getString("DataStepProgramDeployer.UnknownException.txt"), DataStepProgramDeployer.class, "DataStepProgramDeployer.UnknownException.txt", null);
        }
    }

    public static DeployedJob BuildMetaObjects(Job job, File fileObj, String basename, String jclext, Directory dir, ServerComponent server, UserContextInterface userContext, MdFactory factory, MdObjectStore store, String repos) throws SchedulerException {
        try {
            DeployedJob djob = null;
            if (jclext != null) {
                djob = new DeployedJob(job, server, userContext, fileObj, repos);
                File jclObj = MetaUtilities.createSourceCodeObject(basename, dir, store, repos);
                jclObj.setFileName(basename);
                jclObj.setFileExtension(jclext);
                djob.setJCL(jclObj);
            } else {
                djob = new DeployedJob(job, server, userContext, fileObj, repos);
            }
            return djob;
        }
        catch (MdException e) {
            String message = e.getLocalizedMessage();
            if (message == null || message.length() == 0) {
                message = e.toString();
            }
            throw new SchedulerException(message != null ? message : m_bundle.getString("DataStepProgramDeployer.UnknownException.txt"), DataStepProgramDeployer.class, "DataStepProgramDeployer.UnknownException.txt", null);
        }
        catch (RemoteException e) {
            String message = e.getLocalizedMessage();
            if (message == null || message.length() == 0) {
                message = e.toString();
            }
            throw new SchedulerException(message != null ? message : m_bundle.getString("DataStepProgramDeployer.UnknownException.txt"), DataStepProgramDeployer.class, "DataStepProgramDeployer.UnknownException.txt", null);
        }
        catch (RuntimeException e) {
            String message = e.getLocalizedMessage();
            if (message == null || message.length() == 0) {
                message = e.toString();
            }
            throw new SchedulerException(message != null ? message : m_bundle.getString("DataStepProgramDeployer.UnknownException.txt"), DataStepProgramDeployer.class, "DataStepProgramDeployer.UnknownException.txt", null);
        }
    }

    public static DeployedJob BuildMetaObjects(String name, String filepath, Directory dir, ServerComponent server, UserContextInterface userContext, MdFactory factory, MdObjectStore store, String repos) throws SchedulerException {
        return DataStepProgramDeployer.BuildMetaObjects(name, filepath, false, dir, server, userContext, factory, store, repos);
    }

    public static DeployedJob UpdateMetaObjects(Job job, JFJob jfjob, File fileObj, File jclObj, Directory dir, ServerComponent server, UserContextInterface userContext, MdFactory factory, MdObjectStore store, String repos) throws SchedulerException {
        try {
            DeployedJob djob = new DeployedJob(jfjob);
            if (djob.getBatchServer().getId().compareTo(server.getId()) != 0) {
                djob.setBatchServer(server);
            }
            if (djob.getSourceCode().getId().compareTo(fileObj.getId()) != 0) {
                djob.setSourceCode(fileObj);
            }
            if (userContext != null) {
                djob.setResponsibleParties(userContext, factory, store);
            }
            if (jclObj != null && djob.getJCL().getId().compareTo(jclObj.getId()) != 0) {
                djob.setJCL(jclObj);
            }
            return djob;
        }
        catch (MdException e) {
            String message = e.getLocalizedMessage();
            if (message == null || message.length() == 0) {
                message = e.toString();
            }
            throw new SchedulerException(message != null ? message : m_bundle.getString("DataStepProgramDeployer.UnknownException.txt"), DataStepProgramDeployer.class, "DataStepProgramDeployer.UnknownException.txt", null);
        }
        catch (RemoteException e) {
            String message = e.getLocalizedMessage();
            if (message == null || message.length() == 0) {
                message = e.toString();
            }
            throw new SchedulerException(message != null ? message : m_bundle.getString("DataStepProgramDeployer.UnknownException.txt"), DataStepProgramDeployer.class, "DataStepProgramDeployer.UnknownException.txt", null);
        }
        catch (RuntimeException e) {
            String message = e.getLocalizedMessage();
            if (message == null || message.length() == 0) {
                message = e.toString();
            }
            throw new SchedulerException(message != null ? message : m_bundle.getString("DataStepProgramDeployer.UnknownException.txt"), DataStepProgramDeployer.class, "DataStepProgramDeployer.UnknownException.txt", null);
        }
    }

    public static DeployedJob UpdateMetaObjects(Job job, JFJob jfjob, ServerComponent server, UserContextInterface userContext, MdFactory factory, MdObjectStore store, String repos) throws SchedulerException {
        try {
            DeployedJob djob = new DeployedJob(jfjob);
            if (djob.getBatchServer().getId().compareTo(server.getId()) != 0) {
                djob.setBatchServer(server);
            }
            if (userContext != null) {
                djob.setResponsibleParties(userContext, factory, store);
            }
            return djob;
        }
        catch (MdException e) {
            String message = e.getLocalizedMessage();
            if (message == null || message.length() == 0) {
                message = e.toString();
            }
            throw new SchedulerException(message != null ? message : m_bundle.getString("DataStepProgramDeployer.UnknownException.txt"), DataStepProgramDeployer.class, "DataStepProgramDeployer.UnknownException.txt", null);
        }
        catch (RemoteException e) {
            String message = e.getLocalizedMessage();
            if (message == null || message.length() == 0) {
                message = e.toString();
            }
            throw new SchedulerException(message != null ? message : m_bundle.getString("DataStepProgramDeployer.UnknownException.txt"), DataStepProgramDeployer.class, "DataStepProgramDeployer.UnknownException.txt", null);
        }
        catch (RuntimeException e) {
            String message = e.getLocalizedMessage();
            if (message == null || message.length() == 0) {
                message = e.toString();
            }
            throw new SchedulerException(message != null ? message : m_bundle.getString("DataStepProgramDeployer.UnknownException.txt"), DataStepProgramDeployer.class, "DataStepProgramDeployer.UnknownException.txt", null);
        }
    }

    public static String GenerateJCLFromBatchServer(String filepath, String template, IWorkspace iworkspace) throws RemoteException, GenericError {
        IFileService rio = iworkspace.FileService();
        try {
            StringBuffer contents = CommandUtilities.readFromRemoteFile(rio, template, "", "open_ed-1047", 2);
            return DataStepProgramDeployer.GenerateJCLFromTemplate(filepath, contents.toString());
        }
        catch (GenericError ge) {
            GenericError neoGe = new GenericError(MetaUtilities.messageString(m_bundle.getString("DataStepProgramDeployer.JCLTemplateException.fmt"), ge.getLocalizedMessage()));
            neoGe.initCause((Throwable)ge);
            throw neoGe;
        }
    }

    public static String GenerateJCLFromBatchServer(String filename, String runas, String template, IWorkspace iworkspace) throws RemoteException, GenericError {
        IFileService rio = iworkspace.FileService();
        StringBuffer contents = CommandUtilities.readFromRemoteFile(rio, template, "", "open_ed-1047", 2);
        template = DataStepProgramDeployer.GenerateJCLFromTemplate(filename, contents.toString());
        return DataStepProgramDeployer.GenerateJCLFromTemplate(filename, runas, template);
    }

    public static String GenerateJCLFromTemplate(String filepath, String template) {
        String jcl = template;
        if (filepath.indexOf("/") < 0) {
            jcl = MetaUtilities.replaceString(jcl, "//*SYSIN   DD DISP=SHR", "//SYSIN    DD DISP=SHR");
            jcl = MetaUtilities.replaceString(jcl, "//*           DSN=", "//            DSN=");
            jcl = MetaUtilities.replaceString(jcl, "//SYSIN    DD PATHOPTS", "//*SYSIN   DD PATHOPTS");
            jcl = MetaUtilities.replaceString(jcl, "//            PATH=", "//*           PATH=");
        } else {
            jcl = MetaUtilities.replaceString(jcl, "//SYSIN    DD DISP=SHR", "//*SYSIN   DD DISP=SHR");
            jcl = MetaUtilities.replaceString(jcl, "//            DSN=", "//*           DSN=");
            jcl = MetaUtilities.replaceString(jcl, "//*SYSIN   DD PATHOPTS", "//SYSIN    DD PATHOPTS");
            jcl = MetaUtilities.replaceString(jcl, "//*           PATH=", "//            PATH=");
        }
        return jcl;
    }

    public static String GenerateJCLFromTemplate(String filename, String runas, String template) {
        String jcl = template;
        if (filename.length() > 0) {
            StringBuffer neoFilename = new StringBuffer();
            int pathLength = filename.length();
            int index = 0;
            int start = 20;
            if (filename.indexOf("/") < 0) {
                jcl = MetaUtilities.replaceString(jcl, FILEPLACEHOLDER, filename);
            } else {
                if (pathLength > 71 - start) {
                    neoFilename.append(filename.substring(0, 71 - start) + "+\n");
                    index = 71 - start;
                    pathLength -= index;
                    while (index + 56 <= pathLength) {
                        neoFilename.append("//             " + filename.substring(index, index + 56) + "+\n");
                        index += 56;
                    }
                    neoFilename.append("//             " + filename.substring(index));
                } else {
                    neoFilename.append(filename);
                }
                String uss = "PATH='$INPUT$";
                jcl = MetaUtilities.replaceString(jcl, uss, "PATH='" + neoFilename.toString());
            }
        }
        if (runas != null && runas.length() > 0) {
            jcl = MetaUtilities.replaceString(jcl, RUNASPLACEHOLDER, runas);
        }
        return jcl;
    }
}

