/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.build;

import com.sas.iom.SAS.IBinaryStream;
import com.sas.iom.SAS.IFileService;
import com.sas.iom.SAS.IFileref;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SAS.StreamOpenMode;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.OctetSeqHolder;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.net.crypto.SealedString;
import com.sas.scheduler.api.build.ImportFlowInterface;
import com.sas.scheduler.api.oma.DeployedFlow;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.SchedulerException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidParameterException;
import java.util.List;
import java.util.Vector;
import org.omg.CORBA.StringHolder;

public class ImportFlowFromXML
implements ImportFlowInterface {
    private String m_infile = null;
    private IWorkspace m_workspace = null;
    private FlowInfo m_flow = null;
    private MdObjectStore m_store = null;
    private String m_repos = null;
    private Vector<?> m_flows = new Vector();
    private String m_schUser = null;
    private SealedString m_schPass = null;

    @Deprecated
    public ImportFlowFromXML(String infile, IWorkspace workspace, MdObjectStore store, String repos, String schUser, String schPass) {
        this.m_infile = infile;
        this.m_workspace = workspace;
        this.m_store = store;
        this.m_repos = repos;
        this.m_schUser = schUser;
        this.m_schPass = schPass != null ? new SealedString(schPass) : null;
    }

    public ImportFlowFromXML(String infile, IWorkspace workspace, MdObjectStore store, String repos, String schUser, SealedString schPass) {
        this.m_infile = infile;
        this.m_workspace = workspace;
        this.m_store = store;
        this.m_repos = repos;
        this.m_schUser = schUser;
        this.m_schPass = schPass;
    }

    @Override
    public FlowInfo getFlowInfo() {
        return this.m_flow;
    }

    public List<?> getListofFlowInfo() {
        return this.m_flows;
    }

    public String getData() {
        return this.m_infile;
    }

    @Override
    public boolean setName(String name) {
        if (this.m_flow != null) {
            this.m_flow.setName(name);
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return this.m_flow != null ? this.m_flow.getName() : null;
    }

    @Override
    public boolean parse(int maxPredecessors) throws InvalidParameterException, SchedulerException {
        if (this.m_workspace != null) {
            IFileService rio = this.m_workspace.FileService();
            String fileref = "tempXML";
            String accessMethodOrDevice = "DISK";
            String hostOptions = "";
            StringHolder assignedName = new StringHolder(fileref);
            IBinaryStream file = null;
            try {
                IFileref fileRef = rio.AssignFileref(fileref, accessMethodOrDevice, this.m_infile, hostOptions, assignedName);
                StringBuffer xml = new StringBuffer();
                byte[] buffer = new byte[1024];
                OctetSeqHolder holder = new OctetSeqHolder(buffer);
                file = fileRef.OpenBinaryStream(StreamOpenMode.StreamOpenModeForReading);
                boolean eof = false;
                while (!eof) {
                    file.Read(1024, holder);
                    xml.append(new String(holder.value, "UTF8"));
                    if (holder.value.length != 0) continue;
                    eof = true;
                }
                this.m_flows = DeployedFlow.generateFlowsFromXML(xml.toString(), this.m_store, this.m_repos, this.m_schUser, this.m_schPass);
                if (this.m_flows.size() > 0) {
                    this.m_flow = (FlowInfo)this.m_flows.get(this.m_flows.size() - 1);
                }
                file.Close();
                rio.DeassignFileref(fileref);
                return true;
            }
            catch (UnsupportedEncodingException uee) {
                SchedulerException se = new SchedulerException();
                se.initCause((Throwable)uee);
                throw se;
            }
            catch (GenericError ge) {
                if (file != null) {
                    try {
                        file.Close();
                    }
                    catch (GenericError se) {
                        // empty catch block
                    }
                    file = null;
                }
                SchedulerException se = new SchedulerException();
                se.initCause((Throwable)ge);
                throw se;
            }
        }
        return false;
    }
}

