/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals.pfd;

import com.sas.graphics.components.pfd.PFDDrawablePrimitive;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.visuals.pfd.WsPFDIconNode;
import java.awt.Color;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class WsPFDTableIconNode
extends WsPFDIconNode {
    private static final long serialVersionUID = 1L;
    private static final String VIEW_TYPE = "View";
    private static final Icon PHYSICALTABLEICON = WAdminResource.getTypeIcon("PhysicalTable", true);
    private static final Icon PHYSICALTABLEVIEWICON = WAdminResource.getTypeIcon("PhysicalTableView", true);
    private static final Icon EXTERNALTABLEICON = WAdminResource.getTypeIcon("ExternalTable", true);
    private static final Icon WORKTABLEICON = WAdminResource.getTypeIcon("WorkTable", true);
    private static final Icon WORKTABLEVIEWICON = WAdminResource.getTypeIcon("WorkTableView", true);
    private static final Color BORDERCOLOR = new Color(252, 181, 38);
    private static final Color FILLCOLOR = new Color(254, 222, 158);
    private static final Color WORKTABLE_BORDERCOLOR = new Color(20, 161, 20);
    private static final Color WORKTABLE_FILLCOLOR = new Color(191, 232, 191);
    private String m_sType;
    private String m_sName;
    private String m_sFQID;
    private boolean m_bView;

    protected static Icon getIcon(String sType, boolean isView) {
        if (sType.equals("PhysicalTable")) {
            if (!isView) {
                return PHYSICALTABLEICON;
            }
            return PHYSICALTABLEVIEWICON;
        }
        if (sType.equals("ExternalTable")) {
            return EXTERNALTABLEICON;
        }
        if (sType.equals("WorkTable")) {
            if (!isView) {
                return WORKTABLEICON;
            }
            return WORKTABLEVIEWICON;
        }
        return null;
    }

    public WsPFDTableIconNode() {
        this("", "PhysicalTable", "");
    }

    public WsPFDTableIconNode(String sName, String sType, String sFQID) {
        this(sName, sType, sFQID, false);
    }

    public WsPFDTableIconNode(String sName, String sType, String sFQID, boolean isView) {
        super(DEFAULT_LOCATION, DEFAULT_SIZE, 5, WsPFDTableIconNode.getIcon(sType, isView), sName);
        this.m_sName = sName;
        this.m_sType = sType;
        this.m_sFQID = sFQID;
        this.m_bView = isView;
        this.updateColors();
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.getDrawable().getPen().setLineWidth(3.0f);
    }

    protected void updateColors() {
        PFDDrawablePrimitive draw = this.getDrawable();
        if (this.m_sType.equals("WorkTable")) {
            draw.getPen().setColor(WORKTABLE_BORDERCOLOR);
            draw.getBrush().setColor(WORKTABLE_FILLCOLOR);
        } else {
            draw.getPen().setColor(BORDERCOLOR);
            draw.getBrush().setColor(FILLCOLOR);
        }
    }

    public void setName(String sName) {
        if (this.m_sName.equals(sName)) {
            return;
        }
        this.m_sName = sName;
        this.getLabel().setText(this.m_sName);
    }

    public String getName() {
        return this.m_sName;
    }

    public void setType(String sType) {
        if (this.m_sType.equals(sType)) {
            return;
        }
        this.m_sType = sType;
        this.setIconImage((ImageIcon)WsPFDTableIconNode.getIcon(this.m_sType, this.m_bView));
    }

    public String getType() {
        return this.m_sType;
    }

    public void setView(boolean bView) {
        if (this.m_bView == bView) {
            return;
        }
        this.m_bView = bView;
        this.setIconImage((ImageIcon)WsPFDTableIconNode.getIcon(this.m_sType, this.m_bView));
    }

    public boolean isView() {
        return this.m_bView;
    }

    public void setFQID(String sFQID) {
        if (this.m_sFQID.equals(sFQID)) {
            return;
        }
        this.m_sFQID = sFQID;
    }

    public String getFQID() {
        return this.m_sFQID;
    }
}

