/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals.pfd;

import com.sas.graphics.components.pfd.PFDAbstractNode;
import com.sas.graphics.components.pfd.PFDDirectionalNodeInterface;
import com.sas.graphics.components.pfd.PFDLink;
import com.sas.graphics.components.pfd.PFDModel;
import com.sas.graphics.components.pfd.PFDPort;
import com.sas.graphics.components.pfd.PFDPrimitive;
import com.sas.workspace.visuals.pfd.WsPFDPrimitive;
import java.awt.Dimension;
import java.awt.Point;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WsPFDModel
extends PFDModel {
    private static final long serialVersionUID = 1L;
    public static final int MODEL_CHANGED = 1000;
    private Map m_mapNodes = this.createNodeMap();
    private boolean m_bEditable;

    public WsPFDModel() {
        this.setEditable(true);
    }

    public Dimension getReferenceNodeSize() {
        return new Dimension(105, 105);
    }

    public void setEditable(boolean bEditable) {
        if (this.m_bEditable == bEditable) {
            return;
        }
        this.m_bEditable = bEditable;
        for (int iPrimitive = 0; iPrimitive < this.getNumPrimitives(); ++iPrimitive) {
            PFDPrimitive primitive = this.getPrimitive(iPrimitive);
            if (!(primitive instanceof WsPFDPrimitive)) continue;
            ((WsPFDPrimitive)primitive).setEditable(bEditable);
        }
    }

    public boolean isEditable() {
        return this.m_bEditable;
    }

    public void removeAllPrimitives() {
        while (this.getNumPrimitives() > 0) {
            this.removePrimitive(0);
        }
        this.m_mapNodes.clear();
    }

    public void clearKeyedNodes() {
        this.m_mapNodes.clear();
    }

    public boolean addPrimitive(PFDPrimitive prim) {
        if (prim instanceof PFDDirectionalNodeInterface) {
            ((PFDDirectionalNodeInterface)prim).setFlowDirection(this.getFlowDirection());
        }
        return super.addPrimitive(prim);
    }

    public void addKeyedNode(Object key, PFDAbstractNode node) {
        this.addNode(node);
        this.m_mapNodes.put(key, node);
    }

    public PFDAbstractNode getKeyedNode(Object key) {
        return (PFDAbstractNode)this.m_mapNodes.get(key);
    }

    public void removeKeyedNode(Object key) {
        PFDAbstractNode node = this.getKeyedNode(key);
        if (node != null) {
            this.removePrimitive((PFDPrimitive)node);
        }
        this.m_mapNodes.remove(key);
    }

    public void addNode(PFDAbstractNode node) {
        this.addPrimitive((PFDPrimitive)node);
    }

    public void removeNode(PFDAbstractNode node) {
        this.removePrimitive((PFDPrimitive)node);
    }

    public void addLink(PFDAbstractNode nodeSource, PFDLink link, PFDAbstractNode nodeTarget) {
        PFDPort portSource = nodeSource != null ? nodeSource.getOutputPort() : null;
        PFDPort portTarget = nodeTarget != null ? nodeTarget.getInputPort() : null;
        link.setFromPort(portSource);
        link.setToPort(portTarget);
        this.addPrimitive((PFDPrimitive)link);
    }

    public void addLink(PFDLink link) {
        this.addPrimitive((PFDPrimitive)link);
    }

    public void removeLink(PFDLink link) {
        this.removePrimitive((PFDPrimitive)link);
    }

    public void clear() {
        this.removeAllPrimitives();
    }

    public boolean isDropValid(Point ptEvent, List lObjects) {
        return false;
    }

    public void dispose() {
    }

    public boolean drop(Point ptEvent, List lObjects) {
        return false;
    }

    protected Map createNodeMap() {
        return new HashMap();
    }
}

