/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals.objectselector;

import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.swing.visuals.dualselector.DualSelectorInterface;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractIconFactory;
import com.sas.workspace.models.IPublicTypeFilter;
import com.sas.workspace.models.ISimpleObjectFilter;
import com.sas.workspace.models.ISimpleObjectHierarchyModel;
import com.sas.workspace.models.SimpleBrowseObject;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.models.impl.SimpleBrowseObjectImpl;
import com.sas.workspace.models.impl.SimpleObjectHierarchyModel;
import com.sas.workspace.models.tree.inventory.ColumnElement;
import com.sas.workspace.models.tree.inventory.LibraryElement;
import com.sas.workspace.models.tree.inventory.TableElement;
import com.sas.workspace.visuals.dualselector.PanelListSelector;
import com.sas.workspace.visuals.objectselector.ISelectorComplexFilter;
import com.sas.workspace.visuals.objectselector.ISelectorFeedbackFilter;
import com.sas.workspace.visuals.objectselector.ObjectSelectorFilterFactory;
import com.sas.workspace.visuals.objectselector.TabbedTreePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.ListModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ObjectsSelectorPanel
extends WAPropertyTab {
    private static final WAdminResource bundle = WAdminResource.getBundle(ObjectsSelectorPanel.class);
    public static final int CUSTOM = -1;
    public static final int FOLDER = 0;
    public static final int JOB = 1;
    public static final int LIBRARY = 2;
    public static final int TABLE = 3;
    public static final int COLUMN = 4;
    public static final int NOTE = 5;
    public static final int DOCUMENT = 6;
    public static final int COLUMN_PHYSICAL_TABLES_ONLY = 7;
    private UserContextInterface m_userContext;
    private TabbedTreePanel m_treePanel;
    private PanelListSelector m_selectorPanel;
    private int m_iSelectionType;
    private int m_iMinSelectionCount;
    private String m_sDescription;
    private SimpleObject[] m_aSelectedObjects;
    private boolean m_bUpdateDataChanged;
    private ISimpleObjectFilter m_selectableObjectsFilter;
    private Comparator m_defaultComparator;
    private Map m_mapComparators;
    private boolean m_bDoDataExchanged;

    public ObjectsSelectorPanel(UserContextInterface userContext, int iSelectionType) {
        this(userContext, iSelectionType, null);
    }

    public ObjectsSelectorPanel(UserContextInterface userContext, int iSelectionType, String sDescription) {
        this.m_userContext = userContext;
        this.m_iSelectionType = iSelectionType;
        this.m_sDescription = sDescription;
        this.initialize();
    }

    @Override
    protected void initialize() {
        this.m_defaultComparator = new IDComparator();
        this.m_mapComparators = new HashMap();
        JPanel pnlDescription = null;
        if (this.m_sDescription != null) {
            WATextArea txtDescription = new WATextArea(this.m_sDescription);
            txtDescription.setColumns(30);
            txtDescription.setBehavior(1);
            txtDescription.setAutosize(true);
            txtDescription.setBorder(new EmptyBorder(0, 0, 5, 0));
            pnlDescription = new JPanel(new BorderLayout());
            pnlDescription.setBorder(new EmptyBorder(0, 0, 10, 0));
            pnlDescription.add((Component)txtDescription, "Center");
            pnlDescription.add((Component)new JSeparator(), "South");
        }
        this.m_treePanel = new TabbedTreePanel(this.m_userContext, this.m_iSelectionType == 4 || this.m_iSelectionType == 7, true);
        this.m_selectorPanel = new cPanelListSelector(this.m_treePanel);
        this.m_selectorPanel.setTargetCellRenderer(new cListCellRenderer());
        this.m_selectorPanel.getTargetModel().addListDataListener(new cTargetListListener());
        this.m_selectorPanel.setCopyModeEnabled(true);
        this.m_selectorPanel.setCopyModeDuplicatesAllowed(false);
        this.m_selectorPanel.setDragAndDropEnabled(false);
        this.m_selectorPanel.setTransferAllControlsVisible(false);
        this.m_treePanel.setDefaultAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectsSelectorPanel.this.m_selectorPanel.transferSourceItems();
            }
        });
        this.setMaxSelectionCount(Integer.MAX_VALUE);
        this.setMinSelectionCount(0);
        this.configureSelectionType();
        this.setPreferredSize(new Dimension(450, 300));
        this.setLayout(new BorderLayout());
        if (pnlDescription != null) {
            this.add((Component)pnlDescription, "North");
        }
        this.add((Component)((Object)this.m_selectorPanel), "Center");
    }

    private void configureSelectionType() {
        switch (this.m_iSelectionType) {
            case 0: {
                String[] aSelectableTypes = new String[]{"Folder"};
                this.setSelectableTypes(aSelectableTypes);
                this.setVisibleTypes(aSelectableTypes);
                this.setInventoryTypes(aSelectableTypes);
                break;
            }
            case 1: {
                String[] aSelectableTypes = new String[]{"Job"};
                this.setSelectableTypes(aSelectableTypes);
                this.setVisibleTypes(aSelectableTypes);
                this.setInventoryTypes(aSelectableTypes);
                break;
            }
            case 2: {
                String[] aSelectableTypes = new String[]{"Library"};
                this.setSelectableTypes(aSelectableTypes);
                this.setVisibleTypes(aSelectableTypes);
                this.setInventoryTypes(aSelectableTypes);
                this.setAdditionalHierarchyModel(null);
                break;
            }
            case 3: {
                String[] aSelectableTypes = new String[]{"Table"};
                String[] aVisibleTypes = new String[]{"Table", "Library"};
                this.setSelectableTypes(aSelectableTypes);
                this.setVisibleTypes(aVisibleTypes);
                this.setInventoryTypes(aVisibleTypes);
                try {
                    SimpleObjectHierarchyModel hierarchyModel = new SimpleObjectHierarchyModel(this.m_userContext.getAuthServer());
                    hierarchyModel.addElement(new LibraryElement(), "Library");
                    hierarchyModel.addElement(new TableElement(false), "Table");
                    this.setAdditionalHierarchyModel(hierarchyModel);
                }
                catch (RemoteException ex) {
                    Workspace.handleRemoteException(ex);
                }
                catch (ServiceException ex) {
                    MessageUtil.displayServiceExceptionMessage(ex);
                }
                break;
            }
            case 4: {
                String[] aSelectableTypes = new String[]{"Column"};
                String[] aSelectableParentTypes = new String[]{"Table", "ExternalFile"};
                String[] aVisibleTypes = new String[]{"Column", "Table", "ExternalFile", "Library"};
                String[] aInventoryTypes = new String[]{"Table", "ExternalFile", "Library"};
                this.setSelectableTypes(aSelectableTypes);
                this.setSelectableParentTypes(aSelectableParentTypes);
                this.setVisibleTypes(aVisibleTypes);
                this.setInventoryTypes(aInventoryTypes);
                try {
                    SimpleObjectHierarchyModel hierarchyModel = new SimpleObjectHierarchyModel(this.m_userContext.getAuthServer());
                    hierarchyModel.addElement(new LibraryElement(), "Library");
                    TableElement tableElement = new TableElement(true);
                    hierarchyModel.addElement(tableElement, "Table");
                    hierarchyModel.addElement(tableElement, "ExternalFile");
                    hierarchyModel.addElement(new ColumnElement(), "Column");
                    this.setAdditionalHierarchyModel(hierarchyModel);
                }
                catch (RemoteException ex) {
                    Workspace.handleRemoteException(ex);
                }
                catch (ServiceException ex) {
                    MessageUtil.displayServiceExceptionMessage(ex);
                }
                this.addDuplicateComparatorForType(new ColumnComparator(this.m_userContext), "Column");
                this.setReorderControlsVisible(true);
                break;
            }
            case 7: {
                String[] aSelectableTypes = new String[]{"Column"};
                String[] aSelectableParentTypes = new String[]{"Table"};
                String[] aVisibleTypes = new String[]{"Column", "Table", "Library"};
                String[] aInventoryTypes = new String[]{"Table", "Library"};
                this.setSelectableTypes(aSelectableTypes);
                this.setSelectableParentTypes(aSelectableParentTypes);
                this.setVisibleTypes(aVisibleTypes);
                this.setInventoryTypes(aInventoryTypes);
                try {
                    SimpleObjectHierarchyModel hierarchyModel = new SimpleObjectHierarchyModel(this.m_userContext.getAuthServer());
                    hierarchyModel.addElement(new LibraryElement(), "Library");
                    TableElement tableElement = new TableElement(true);
                    hierarchyModel.addElement(tableElement, "Table");
                    hierarchyModel.addElement(new ColumnElement(), "Column");
                    this.setAdditionalHierarchyModel(hierarchyModel);
                }
                catch (RemoteException ex) {
                    Workspace.handleRemoteException(ex);
                }
                catch (ServiceException ex) {
                    MessageUtil.displayServiceExceptionMessage(ex);
                }
                this.addDuplicateComparatorForType(new ColumnComparator(this.m_userContext), "Column");
                this.setReorderControlsVisible(true);
                break;
            }
            case 5: {
                String[] aSelectableTypes = new String[]{"Note"};
                this.setSelectableTypes(aSelectableTypes);
                this.setVisibleTypes(aSelectableTypes);
                this.setInventoryTypes(aSelectableTypes);
                break;
            }
            case 6: {
                String[] aSelectableTypes = new String[]{"Document"};
                this.setSelectableTypes(aSelectableTypes);
                this.setVisibleTypes(aSelectableTypes);
                this.setInventoryTypes(aSelectableTypes);
                break;
            }
            default: {
                this.setAdditionalHierarchyModel(null);
            }
        }
    }

    public void setSelectableTypes(String[] aSelectableTypes) {
        this.setSelectableObjectsFilter(ObjectSelectorFilterFactory.createObjectFilter(aSelectableTypes));
    }

    public void setSelectableParentTypes(String[] aSelectableParentTypes) {
        this.m_treePanel.setSelectableParentTypes(aSelectableParentTypes);
    }

    public void setSelectableObjectsFilter(ISimpleObjectFilter filter) {
        this.m_selectableObjectsFilter = filter;
    }

    public void setVisibleTypes(String[] aPublicTypes) {
        this.setVisibleObjectsFilter(ObjectSelectorFilterFactory.createObjectFilter(aPublicTypes));
    }

    public void setVisibleObjectsFilter(ISimpleObjectFilter filter) {
        this.m_treePanel.setNodeFilter(filter);
        if (this.m_bHasBeenShown) {
            this.m_treePanel.refreshTrees();
        }
    }

    public void setInventoryTypes(String[] aVisibleTypes) {
        this.setInventoryTypesFilter(ObjectSelectorFilterFactory.createTypeFilter(aVisibleTypes));
    }

    public void setInventoryTypesFilter(IPublicTypeFilter filter) {
        this.m_treePanel.setInventoryTypesFilter(filter);
        if (this.m_bHasBeenShown) {
            this.m_treePanel.refreshTrees();
        }
    }

    public void setAdditionalHierarchyModel(ISimpleObjectHierarchyModel model) {
        this.m_treePanel.setAdditionalHierarchyModel(model);
        if (this.m_bHasBeenShown) {
            this.m_treePanel.refreshTrees();
        }
    }

    public void setDefaultDuplicateComparator(Comparator cmp) {
        this.m_defaultComparator = cmp;
    }

    public void addDuplicateComparatorForType(Comparator cmp, String sPublicType) {
        this.m_mapComparators.put(sPublicType, cmp);
    }

    public void setSelectedObjects(SimpleObject[] aSelectedObjects) {
        this.m_aSelectedObjects = aSelectedObjects;
    }

    public SimpleObject[] getSelectedObjects() {
        return this.m_aSelectedObjects;
    }

    public void setTreeModelComparator(Comparator cmp) {
        this.m_treePanel.setTreeModelComparator(cmp);
        if (this.m_bHasBeenShown) {
            this.m_treePanel.refreshTrees();
        }
    }

    public void setSourceLabel(String sLabel, char cMnem) {
        JLabel lbl = (JLabel)this.m_selectorPanel.getSourceLabelComponent();
        lbl.setText(sLabel);
        lbl.setDisplayedMnemonic(cMnem);
    }

    public void setTargetLabel(String sLabel, char cMnem) {
        JLabel lbl = (JLabel)this.m_selectorPanel.getTargetLabelComponent();
        lbl.setText(sLabel);
        lbl.setDisplayedMnemonic(cMnem);
    }

    public void setReorderControlsVisible(boolean bVisible) {
        this.m_selectorPanel.setTargetControlsVisible(bVisible);
    }

    public boolean isReorderControlsVisible() {
        return this.m_selectorPanel.isTargetControlsVisible();
    }

    public void setMaxSelectionCount(int maxSelectionCount) {
        this.m_selectorPanel.setTargetMaximumCount(maxSelectionCount);
        if (maxSelectionCount == 1) {
            this.m_selectorPanel.setTargetControlsVisible(false);
        }
    }

    public int getMaxSelectionCount() {
        return this.m_selectorPanel.getTargetMaximumCount();
    }

    public void setMinSelectionCount(int iMinSelectionCount) {
        if (iMinSelectionCount > this.getMaxSelectionCount()) {
            throw new IllegalArgumentException("Minimum selection count is greater than maximum selection count.");
        }
        this.m_iMinSelectionCount = iMinSelectionCount;
    }

    public int getMinSelectionCount() {
        return this.m_iMinSelectionCount;
    }

    public void setUpdateDataChanged(boolean bUpdateDataChanged) {
        this.m_bUpdateDataChanged = bUpdateDataChanged;
    }

    public boolean isUpdatingDataChanged() {
        return this.m_bUpdateDataChanged;
    }

    @Override
    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_selectorPanel.setEnabled(bEditable);
    }

    @Override
    public boolean validateData() {
        ListModel mdlTarget = this.m_selectorPanel.getTargetModel();
        if (mdlTarget.getSize() < this.m_iMinSelectionCount) {
            String sMessage = this.m_iMinSelectionCount == 1 ? bundle.getString("ObjectsSelectorPanel.NotEnoughSingular.txt") : bundle.formatString("ObjectsSelectorPanel.NotEnoughPlural.fmt.txt", new Integer(this.m_iMinSelectionCount));
            MessageUtil.displayMessage(sMessage, 0);
            return false;
        }
        return true;
    }

    @Override
    public void populateStore() throws MdException, RemoteException {
        if (this.isStorePopulated()) {
            return;
        }
        this.setStorePopulated(true);
    }

    @Override
    public void moveDataToView() throws MdException, RemoteException {
        this.m_treePanel.refreshTrees();
        if (this.m_aSelectedObjects != null) {
            this.setListeningForChanges(false);
            try {
                this.m_treePanel.setSelectedObjects(this.m_aSelectedObjects);
                for (int i = 0; i < this.m_aSelectedObjects.length; ++i) {
                    DefaultListModel model = (DefaultListModel)this.m_selectorPanel.getTargetModel();
                    model.addElement(this.m_aSelectedObjects[i]);
                }
            }
            finally {
                this.setListeningForChanges(true);
            }
        }
    }

    @Override
    public void moveDataToStore() throws MdException, RemoteException {
        DefaultListModel model = (DefaultListModel)this.m_selectorPanel.getTargetModel();
        Object[] aSelectedObjects = model.toArray();
        this.m_aSelectedObjects = new SimpleObject[aSelectedObjects.length];
        System.arraycopy(aSelectedObjects, 0, this.m_aSelectedObjects, 0, aSelectedObjects.length);
        this.setDataChanged(false);
    }

    @Override
    public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
        if (!bSaveToModel) {
            if (!this.m_bDoDataExchanged) {
                this.m_bDoDataExchanged = true;
                this.moveDataToView();
                this.populateStore();
            }
        } else {
            this.moveDataToStore();
        }
        return true;
    }

    @Override
    public void updateWorkspaceUIComponents(boolean bActive) {
    }

    @Override
    public void onNext() {
        try {
            this.moveDataToStore();
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage(e, "Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException(re);
        }
    }

    @Override
    public void saveSettingsAndCleanUp() {
        this.m_treePanel.dispose();
    }

    public static class ColumnComparator
    implements Comparator {
        UserContextInterface m_userContext;

        public ColumnComparator(UserContextInterface userContext) {
            this.m_userContext = userContext;
        }

        public int compare(Object o1, Object o2) {
            SimpleBrowseObject c1 = o1 instanceof SimpleBrowseObject ? (SimpleBrowseObject)o1 : this.getSimpleBrowseObject((SimpleObject)o1);
            SimpleBrowseObject c2 = o2 instanceof SimpleBrowseObject ? (SimpleBrowseObject)o2 : this.getSimpleBrowseObject((SimpleObject)o2);
            String c1Name = (String)c1.getBrowseObject().get("SASColumnName");
            String c2Name = (String)c2.getBrowseObject().get("SASColumnName");
            return c1Name.compareToIgnoreCase(c2Name);
        }

        private SimpleBrowseObject getSimpleBrowseObject(SimpleObject simpleObject) {
            try {
                Filter filter = new Filter();
                filter.setOMRTemplate("<Templates><Column SASColumnName=\"\"/></Templates>");
                filter.setOMRFlags(-2147483644);
                String sKey = simpleObject.getID() + "/" + simpleObject.getMetadataType();
                BrowseMetadataInterface browseObject = this.m_userContext.getAuthServer().browseFetch(sKey, (FilterInterface)filter);
                if (browseObject != null) {
                    return new SimpleBrowseObjectImpl(browseObject);
                }
            }
            catch (ServiceException ex) {
                MessageUtil.displayServiceExceptionMessage(ex);
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException(ex);
            }
            return null;
        }
    }

    public static class IDComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            SimpleObject s1 = (SimpleObject)o1;
            SimpleObject s2 = (SimpleObject)o2;
            return s1.getID().compareTo(s2.getID());
        }
    }

    protected class cTargetListListener
    implements ListDataListener {
        protected cTargetListListener() {
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            if (ObjectsSelectorPanel.this.isListeningForChanges()) {
                ObjectsSelectorPanel.this.setDataChanged(true);
            }
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            if (ObjectsSelectorPanel.this.isListeningForChanges()) {
                ObjectsSelectorPanel.this.setDataChanged(true);
            }
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            if (ObjectsSelectorPanel.this.isListeningForChanges()) {
                ObjectsSelectorPanel.this.setDataChanged(true);
            }
        }
    }

    public class cListCellRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int iRow, boolean bSelected, boolean bHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, iRow, bSelected, bHasFocus);
            if (value instanceof SimpleObject) {
                SimpleObject simpleObj = (SimpleObject)value;
                this.setIcon(WsAbstractIconFactory.getInstance().getDecoratedIconForSimpleObject(simpleObj));
                this.setText(simpleObj.getName());
            }
            return this;
        }
    }

    protected class cPanelListSelector
    extends PanelListSelector {
        public cPanelListSelector(JPanel panel) {
            super(panel);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected synchronized void transferItems(DualSelectorInterface fromAdapter, DualSelectorInterface toAdapter, List lItems) {
            if (lItems == null) {
                lItems = fromAdapter.getSelectedItems();
            }
            if (lItems.size() > 0) {
                DualSelectorInterface dualSelectorInterface = fromAdapter;
                synchronized (dualSelectorInterface) {
                    DualSelectorInterface dualSelectorInterface2 = toAdapter;
                    synchronized (dualSelectorInterface2) {
                        if (fromAdapter == this.sourceAdapter) {
                            List lTargets = toAdapter.getAllItems();
                            this.filterObjects(lItems, lTargets);
                            if (lItems.isEmpty()) {
                                return;
                            }
                            this.filterDuplicates(lItems, lTargets);
                            if (lItems.size() + lTargets.size() > ObjectsSelectorPanel.this.m_selectorPanel.getTargetMaximumCount()) {
                                String sMessage = bundle.getString("ObjectsSelectorPanel.TooManySelected.txt");
                                MessageUtil.displayMessage(sMessage, 0);
                                lItems.clear();
                            }
                            if (lItems.size() > 0) {
                                if (!this.copyModeEnabled) {
                                    fromAdapter.removeItems(lItems);
                                }
                                toAdapter.addItems(lItems);
                            }
                        } else {
                            fromAdapter.removeItems(lItems);
                            if (!this.copyModeEnabled) {
                                toAdapter.addItems(lItems);
                            }
                        }
                        this.ensureButtonsEnabled();
                        this.firePropertyChange("sourceItems", null, null);
                        this.firePropertyChange("targetItems", null, null);
                        this.selectedItems = null;
                    }
                }
            }
        }

        protected void filterObjects(List lSources, List lTargets) {
            ISelectorComplexFilter complexFilter;
            for (int iSource = 0; iSource < lSources.size(); ++iSource) {
                String sReason;
                if (!(lSources.get(iSource) instanceof SimpleObject)) {
                    lSources.clear();
                    return;
                }
                SimpleObject simpleObj = (SimpleObject)lSources.get(iSource);
                if (ObjectsSelectorPanel.this.m_selectableObjectsFilter.accept(simpleObj)) continue;
                lSources.clear();
                String sMessage = null;
                if (ObjectsSelectorPanel.this.m_selectableObjectsFilter instanceof ISelectorFeedbackFilter && (sReason = ((ISelectorFeedbackFilter)ObjectsSelectorPanel.this.m_selectableObjectsFilter).getReasonForRejection(simpleObj)) != null && sReason.length() > 0) {
                    sMessage = bundle.formatString("ObjectsSelectorPanel.Rejected.fmt.txt", simpleObj.getName(), sReason);
                }
                if (sMessage == null) {
                    sMessage = bundle.formatString("ObjectsSelectorPanel.IncorrectType.fmt.txt", simpleObj.getName());
                }
                MessageUtil.displayMessage(sMessage, 0);
                return;
            }
            if (ObjectsSelectorPanel.this.m_selectableObjectsFilter instanceof ISelectorComplexFilter && !(complexFilter = (ISelectorComplexFilter)ObjectsSelectorPanel.this.m_selectableObjectsFilter).accept(lSources, lTargets)) {
                String sMessage = complexFilter.getReasonForRejection(lSources, lTargets);
                MessageUtil.displayMessage(sMessage, 0);
                lSources.clear();
            }
        }

        protected void filterDuplicates(List lSources, List lTargets) {
            SimpleObject oSource;
            ArrayList<String> lDuplicates = new ArrayList<String>();
            block0: for (int iSource = 0; iSource < lSources.size(); ++iSource) {
                oSource = (SimpleObject)lSources.get(iSource);
                for (int iOtherSource = 0; iOtherSource < lSources.size(); ++iOtherSource) {
                    SimpleObject oOtherSource;
                    if (iSource == iOtherSource || !this.objectsAreDuplicates(oSource, oOtherSource = (SimpleObject)lSources.get(iOtherSource))) continue;
                    lDuplicates.add(oSource.getName());
                    lSources.remove(iSource++);
                    continue block0;
                }
            }
            Iterator iterSources = lSources.iterator();
            block2: while (iterSources.hasNext()) {
                oSource = (SimpleObject)iterSources.next();
                for (int iTarget = 0; iTarget < lTargets.size(); ++iTarget) {
                    SimpleObject oTarget = (SimpleObject)lTargets.get(iTarget);
                    if (!this.objectsAreDuplicates(oSource, oTarget)) continue;
                    lDuplicates.add(oSource.getName());
                    iterSources.remove();
                    continue block2;
                }
            }
            if (lDuplicates.size() > 0) {
                MessageUtil.displayListMessage(bundle.getString("ObjectsSelectorPanel.DuplicatesError.txt"), lDuplicates, 0);
            }
        }

        private boolean objectsAreDuplicates(SimpleObject oSource, SimpleObject oTarget) {
            String sSourceType = oSource.getPublicType();
            if (sSourceType != null && sSourceType.equals(oTarget.getPublicType())) {
                Comparator cmp = (Comparator)ObjectsSelectorPanel.this.m_mapComparators.get(sSourceType);
                if (cmp == null) {
                    cmp = ObjectsSelectorPanel.this.m_defaultComparator;
                }
                return cmp.compare(oSource, oTarget) == 0;
            }
            return false;
        }
    }
}

