/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals.objectselector;

import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.services.user.UserContextInterface;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsSelectionChangedEvent;
import com.sas.workspace.WsSelectionChangedListener;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.models.IPublicTypeFilter;
import com.sas.workspace.models.ISimpleObjectFilter;
import com.sas.workspace.models.ISimpleObjectHierarchyModel;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.models.impl.SimpleObjectHierarchyModel;
import com.sas.workspace.models.tree.inventory.ColumnElement;
import com.sas.workspace.models.tree.inventory.LibraryElement;
import com.sas.workspace.models.tree.inventory.TableElement;
import com.sas.workspace.visuals.objectselector.ObjectSelectorFilterFactory;
import com.sas.workspace.visuals.objectselector.TabbedTreePanel;
import com.sas.workspace.visuals.tree.IBaseTree;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.Comparator;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class ObjectSelectorPanel
extends WAPropertyTab {
    private static final WAdminResource bundle = WAdminResource.getBundle(ObjectSelectorPanel.class);
    public static final int CUSTOM = -1;
    public static final int FOLDER = 0;
    public static final int JOB = 1;
    public static final int LIBRARY = 2;
    public static final int TABLE = 3;
    public static final int COLUMN = 4;
    public static final int NOTE = 5;
    public static final int DOCUMENT = 6;
    public static final int COLUMN_PHYSICAL_TABLES_ONLY = 7;
    private UserContextInterface m_userContext;
    private TabbedTreePanel m_treePanel;
    private WATextField m_txtSelection;
    private int m_iSelectionType;
    private String m_sDescription;
    private String m_sSelectionType;
    private SimpleObject m_selectedObject;
    private boolean m_bShowClear;
    private boolean m_bOptional;
    private boolean m_bUpdateDataChanged;
    private String m_invalidObjectSelectedErrorMessage;
    private ISimpleObjectFilter m_selectableObjectsFilter;
    private boolean m_bDoDataExchanged;

    public ObjectSelectorPanel(UserContextInterface userContext, int iSelectionType) {
        this(userContext, iSelectionType, null);
    }

    public ObjectSelectorPanel(UserContextInterface userContext, int iSelectionType, String sDescription) {
        this(userContext, iSelectionType, sDescription, true);
    }

    public ObjectSelectorPanel(UserContextInterface userContext, int iSelectionType, String sDescription, boolean bShowClear) {
        this.m_userContext = userContext;
        this.m_iSelectionType = iSelectionType;
        this.m_sDescription = sDescription;
        this.m_bShowClear = bShowClear;
        this.initialize();
    }

    @Override
    protected void initialize() {
        JPanel pnlDescription = null;
        if (this.m_sDescription != null) {
            WATextArea txtDescription = new WATextArea(this.m_sDescription);
            txtDescription.setColumns(30);
            txtDescription.setBehavior(1);
            txtDescription.setAutosize(true);
            txtDescription.setBorder(new EmptyBorder(0, 0, 5, 0));
            pnlDescription = new JPanel(new BorderLayout());
            pnlDescription.setBorder(new EmptyBorder(0, 0, 10, 0));
            pnlDescription.add((Component)txtDescription, "Center");
            pnlDescription.add((Component)new JSeparator(), "South");
        }
        this.m_treePanel = new TabbedTreePanel(this.m_userContext, this.m_iSelectionType == 4 || this.m_iSelectionType == 7, false);
        this.m_treePanel.addSelectionChangedListener(new cTreeSelectionListener());
        this.m_treePanel.setDefaultAction(this.getDefaultAction());
        this.configureSelectionType();
        this.m_txtSelection = new WATextField();
        this.m_txtSelection.setBehavior(2);
        this.m_txtSelection.setBorder(new CompoundBorder(new EmptyBorder(0, 5, 0, 5), this.m_txtSelection.getBorder()));
        String sLabelKey = "ObjectSelectorPanel.Label.Selected" + this.m_sSelectionType;
        JLabel lblSelection = WsUIUtilities.createLabelAndToolTipForComponent(this.m_txtSelection, bundle, sLabelKey);
        JPanel pnlSelection = new JPanel(new BorderLayout());
        pnlSelection.setBorder(new EmptyBorder(10, 0, 0, 0));
        pnlSelection.add((Component)lblSelection, "West");
        pnlSelection.add((Component)this.m_txtSelection, "Center");
        if (this.m_bShowClear) {
            JButton btnClear = new JButton(new cClearAction());
            pnlSelection.add((Component)btnClear, "East");
        }
        this.setPreferredSize(new Dimension(450, 300));
        this.setLayout(new BorderLayout());
        if (pnlDescription != null) {
            this.add((Component)pnlDescription, "North");
        }
        this.add((Component)this.m_treePanel, "Center");
        this.add((Component)pnlSelection, "South");
    }

    private void configureSelectionType() {
        switch (this.m_iSelectionType) {
            case 0: {
                this.m_sSelectionType = "Folder";
                String[] aSelectableTypes = new String[]{"Folder"};
                this.setSelectableTypes(aSelectableTypes);
                this.setVisibleTypes(aSelectableTypes);
                this.setInventoryTypes(aSelectableTypes);
                break;
            }
            case 1: {
                this.m_sSelectionType = "Job";
                String[] aSelectableTypes = new String[]{"Job"};
                this.setSelectableTypes(aSelectableTypes);
                this.setVisibleTypes(aSelectableTypes);
                this.setInventoryTypes(aSelectableTypes);
                break;
            }
            case 2: {
                this.m_sSelectionType = "Library";
                String[] aSelectableTypes = new String[]{"Library"};
                this.setSelectableTypes(aSelectableTypes);
                this.setVisibleTypes(aSelectableTypes);
                this.setInventoryTypes(aSelectableTypes);
                this.setAdditionalHierarchyModel(null);
                break;
            }
            case 3: {
                this.m_sSelectionType = "Table";
                String[] aSelectableTypes = new String[]{"Table"};
                String[] aVisibleTypes = new String[]{"Table", "Library"};
                this.setSelectableTypes(aSelectableTypes);
                this.setVisibleTypes(aVisibleTypes);
                this.setInventoryTypes(aVisibleTypes);
                try {
                    SimpleObjectHierarchyModel hierarchyModel = new SimpleObjectHierarchyModel(this.m_userContext.getAuthServer());
                    hierarchyModel.addElement(new LibraryElement(), "Library");
                    hierarchyModel.addElement(new TableElement(false), "Table");
                    this.setAdditionalHierarchyModel(hierarchyModel);
                }
                catch (RemoteException ex) {
                    Workspace.handleRemoteException(ex);
                }
                catch (ServiceException ex) {
                    MessageUtil.displayServiceExceptionMessage(ex);
                }
                break;
            }
            case 4: {
                this.m_sSelectionType = "Column";
                String[] aSelectableTypes = new String[]{"Column"};
                String[] aVisibleTypes = new String[]{"Column", "Table", "ExternalFile", "Library"};
                String[] aInventoryTypes = new String[]{"Table", "ExternalFile", "Library"};
                this.setSelectableTypes(aSelectableTypes);
                this.setVisibleTypes(aVisibleTypes);
                this.setInventoryTypes(aInventoryTypes);
                try {
                    SimpleObjectHierarchyModel hierarchyModel = new SimpleObjectHierarchyModel(this.m_userContext.getAuthServer());
                    hierarchyModel.addElement(new LibraryElement(), "Library");
                    TableElement tableElement = new TableElement(true);
                    hierarchyModel.addElement(tableElement, "Table");
                    hierarchyModel.addElement(tableElement, "ExternalFile");
                    hierarchyModel.addElement(new ColumnElement(), "Column");
                    this.setAdditionalHierarchyModel(hierarchyModel);
                }
                catch (RemoteException ex) {
                    Workspace.handleRemoteException(ex);
                }
                catch (ServiceException ex) {
                    MessageUtil.displayServiceExceptionMessage(ex);
                }
                break;
            }
            case 7: {
                this.m_sSelectionType = "Column";
                String[] aSelectableTypes = new String[]{"Column"};
                String[] aVisibleTypes = new String[]{"Column", "Table", "Library"};
                String[] aInventoryTypes = new String[]{"Table", "Library"};
                this.setSelectableTypes(aSelectableTypes);
                this.setVisibleTypes(aVisibleTypes);
                this.setInventoryTypes(aInventoryTypes);
                try {
                    SimpleObjectHierarchyModel hierarchyModel = new SimpleObjectHierarchyModel(this.m_userContext.getAuthServer());
                    hierarchyModel.addElement(new LibraryElement(), "Library");
                    TableElement tableElement = new TableElement(true);
                    hierarchyModel.addElement(tableElement, "Table");
                    hierarchyModel.addElement(new ColumnElement(), "Column");
                    this.setAdditionalHierarchyModel(hierarchyModel);
                }
                catch (RemoteException ex) {
                    Workspace.handleRemoteException(ex);
                }
                catch (ServiceException ex) {
                    MessageUtil.displayServiceExceptionMessage(ex);
                }
                break;
            }
            case 5: {
                this.m_sSelectionType = "Note";
                String[] aSelectableTypes = new String[]{"Note"};
                this.setSelectableTypes(aSelectableTypes);
                this.setVisibleTypes(aSelectableTypes);
                this.setInventoryTypes(aSelectableTypes);
                break;
            }
            case 6: {
                this.m_sSelectionType = "Document";
                String[] aSelectableTypes = new String[]{"Document"};
                this.setSelectableTypes(aSelectableTypes);
                this.setVisibleTypes(aSelectableTypes);
                this.setInventoryTypes(aSelectableTypes);
                break;
            }
            default: {
                this.m_sSelectionType = "Custom";
                this.setAdditionalHierarchyModel(null);
            }
        }
    }

    public void setSelectableTypes(String[] aSelectableTypes) {
        this.m_selectableObjectsFilter = ObjectSelectorFilterFactory.createObjectFilter(aSelectableTypes);
    }

    public void setInvalidObjectSelectedErrorMessage(String aInvalidObjectSelectedErrorMessage) {
        this.m_invalidObjectSelectedErrorMessage = aInvalidObjectSelectedErrorMessage;
    }

    public void setSelectableObjectsFilter(ISimpleObjectFilter filter) {
        this.m_selectableObjectsFilter = filter;
    }

    public void setVisibleTypes(String[] aPublicTypes) {
        this.setVisibleObjectsFilter(ObjectSelectorFilterFactory.createObjectFilter(aPublicTypes));
    }

    public void setVisibleObjectsFilter(ISimpleObjectFilter filter) {
        this.m_treePanel.setNodeFilter(filter);
        if (this.m_bHasBeenShown) {
            this.m_treePanel.refreshTrees();
        }
    }

    public void setInventoryTypes(String[] aVisibleTypes) {
        this.setInventoryTypesFilter(ObjectSelectorFilterFactory.createTypeFilter(aVisibleTypes));
    }

    public void setInventoryTypesFilter(IPublicTypeFilter filter) {
        this.m_treePanel.setInventoryTypesFilter(filter);
        if (this.m_bHasBeenShown) {
            this.m_treePanel.refreshTrees();
        }
    }

    public void setAdditionalHierarchyModel(ISimpleObjectHierarchyModel model) {
        this.m_treePanel.setAdditionalHierarchyModel(model);
        if (this.m_bHasBeenShown) {
            this.m_treePanel.refreshTrees();
        }
    }

    public void setSelectedObject(SimpleObject selectedObject) {
        this.m_selectedObject = selectedObject;
    }

    public SimpleObject getSelectedObject() {
        Object[] aSelectedObjects = this.m_treePanel.getSelectedObjects();
        if (aSelectedObjects.length > 0 && aSelectedObjects[0] instanceof SimpleObject) {
            return (SimpleObject)aSelectedObjects[0];
        }
        return null;
    }

    public void setTreeModelComparator(Comparator cmp) {
        this.m_treePanel.setTreeModelComparator(cmp);
        if (this.m_bHasBeenShown) {
            this.m_treePanel.refreshTrees();
        }
    }

    public void setSelectionOptional(boolean bOptional) {
        this.m_bOptional = bOptional;
    }

    public boolean isSelectionOptional() {
        return this.m_bOptional;
    }

    public void setUpdateDataChanged(boolean bUpdateDataChanged) {
        this.m_bUpdateDataChanged = bUpdateDataChanged;
    }

    public boolean isUpdatingDataChanged() {
        return this.m_bUpdateDataChanged;
    }

    @Override
    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_treePanel.setEditable(bEditable);
    }

    @Override
    public void setDefaultAction(Action actDefault) {
        super.setDefaultAction(actDefault);
        this.m_treePanel.setDefaultAction(actDefault);
    }

    @Override
    public boolean validateData() {
        String errorMessage;
        SimpleObject simpleObj;
        Object[] aSelectedObjects = this.m_treePanel.getSelectedObjects();
        if (aSelectedObjects.length == 0) {
            String errorMessage2;
            if (this.m_bOptional) {
                return true;
            }
            if (this.m_invalidObjectSelectedErrorMessage != null) {
                errorMessage2 = this.m_invalidObjectSelectedErrorMessage;
            } else {
                String sMessageKey = "ObjectSelectorPanel.Error." + this.m_sSelectionType + "SelectionRequired.txt";
                errorMessage2 = bundle.getString(sMessageKey);
            }
            MessageUtil.displayMessage(errorMessage2, 0);
            return false;
        }
        if (aSelectedObjects[0] instanceof SimpleObject && this.m_selectableObjectsFilter.accept(simpleObj = (SimpleObject)aSelectedObjects[0])) {
            return true;
        }
        if (this.m_invalidObjectSelectedErrorMessage != null) {
            errorMessage = this.m_invalidObjectSelectedErrorMessage;
        } else {
            String sMessageKey = "ObjectSelectorPanel.Error." + this.m_sSelectionType + "SelectionRequired.txt";
            errorMessage = bundle.getString(sMessageKey);
        }
        MessageUtil.displayMessage(errorMessage, 0);
        return false;
    }

    @Override
    public void populateStore() throws MdException, RemoteException {
        if (this.isStorePopulated()) {
            return;
        }
        this.setStorePopulated(true);
    }

    @Override
    public void moveDataToView() throws MdException, RemoteException {
        this.m_treePanel.refreshTrees();
        if (this.m_selectedObject != null) {
            this.setListeningForChanges(false);
            try {
                this.selectObjectInTrees(this.m_selectedObject);
                this.m_txtSelection.setText(this.m_selectedObject.getName());
            }
            finally {
                this.setListeningForChanges(true);
            }
        }
    }

    @Override
    public void moveDataToStore() throws MdException, RemoteException {
        Object[] aSelectedObjects = this.m_treePanel.getSelectedObjects();
        this.m_selectedObject = aSelectedObjects.length == 0 ? null : (SimpleObject)aSelectedObjects[0];
        this.setDataChanged(false);
    }

    @Override
    public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
        if (!bSaveToModel) {
            if (!this.m_bDoDataExchanged) {
                this.m_bDoDataExchanged = true;
                this.moveDataToView();
                this.populateStore();
            }
        } else {
            this.moveDataToStore();
        }
        return true;
    }

    @Override
    public void updateWorkspaceUIComponents(boolean bActive) {
    }

    @Override
    public void onNext() {
        try {
            this.moveDataToStore();
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage(e, "Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException(re);
        }
    }

    @Override
    public void saveSettingsAndCleanUp() {
        this.m_treePanel.dispose();
    }

    private void selectObjectInTrees(SimpleObject selectedObject) {
        SimpleObject[] aSelectedObjects = selectedObject != null ? new SimpleObject[]{selectedObject} : new SimpleObject[]{};
        this.m_treePanel.setSelectedObjects(aSelectedObjects);
    }

    class cTreeSelectionListener
    implements WsSelectionChangedListener {
        cTreeSelectionListener() {
        }

        @Override
        public void selectionChanged(WsSelectionChangedEvent ev) {
            if (!ObjectSelectorPanel.this.isListeningForChanges()) {
                return;
            }
            if (ObjectSelectorPanel.this.m_bUpdateDataChanged) {
                ObjectSelectorPanel.this.setDataChanged(true);
            }
            ObjectSelectorPanel.this.m_txtSelection.setText("");
            IBaseTree sourceTree = (IBaseTree)ev.getSource();
            Object[] aObjects = sourceTree.getSelectedObjects();
            if (aObjects.length == 1 && aObjects[0] instanceof SimpleObject) {
                SimpleObject selectedObject = (SimpleObject)aObjects[0];
                if (ObjectSelectorPanel.this.m_selectableObjectsFilter.accept(selectedObject)) {
                    ObjectSelectorPanel.this.m_txtSelection.setText(selectedObject.getName());
                    ObjectSelectorPanel.this.m_selectedObject = selectedObject;
                }
            }
        }
    }

    protected class cClearAction
    extends WsAbstractAction {
        public cClearAction() {
            super(bundle, "ObjectSelectorPanel.Action.Clear", 0);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ObjectSelectorPanel.this.m_selectedObject = null;
            ObjectSelectorPanel.this.m_txtSelection.setText("");
            ObjectSelectorPanel.this.selectObjectInTrees(null);
        }
    }
}

