/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals.expression;

import com.sas.workspace.visuals.expression.AbstractFunctionsModel;
import com.sas.workspace.visuals.expression.BaseFunction;
import com.sas.workspace.visuals.expression.Category;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLFunctionsModel
extends AbstractFunctionsModel {
    private static final String FUNCTION_RECORD = "FunctionRecord";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String sFileName) throws FileNotFoundException, IOException {
        try (FileInputStream strm = new FileInputStream(sFileName);){
            Document doc = this.loadXMLFile(strm);
            NodeList lNodes = doc.getFirstChild().getChildNodes();
            for (int iNode = 0; iNode < lNodes.getLength(); ++iNode) {
                Node node = lNodes.item(iNode);
                if (!FUNCTION_RECORD.equals(node.getNodeName())) continue;
                Element ele = (Element)node;
                Element eleName = this.getElementByTagName(ele, "Name");
                Element eleCategory = this.getElementByTagName(ele, "Category");
                Element eleFunction = this.getElementByTagName(ele, "Function");
                String sName = eleName != null ? eleName.getTextContent() : "";
                String sCategory = eleCategory != null ? eleCategory.getTextContent() : "";
                String sDisplayName = eleFunction != null ? eleFunction.getTextContent() : "";
                Category category = this.acquireCategory(sCategory, sCategory);
                BaseFunction function = new BaseFunction(category, sName, sDisplayName);
                category.addFunction(function);
            }
        }
    }

    private Document loadXMLFile(InputStream strmXML) throws IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(strmXML);
        }
        catch (ParserConfigurationException ex) {
            IOException exception = new IOException(ex.getLocalizedMessage());
            exception.initCause(ex);
            throw exception;
        }
        catch (SAXException ex) {
            IOException exception = new IOException(ex.getLocalizedMessage());
            exception.initCause(ex);
            throw exception;
        }
    }

    private Element getElementByTagName(Element node, String sTagName) {
        NodeList lNodes = node.getElementsByTagName(sTagName);
        if (lNodes != null && lNodes.getLength() > 0) {
            return (Element)lNodes.item(0);
        }
        return null;
    }
}

