/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals.expression;

import com.sas.workspace.Workspace;
import com.sas.workspace.visuals.expression.BaseCategory;
import com.sas.workspace.visuals.expression.BaseFunction;
import com.sas.workspace.visuals.expression.Category;
import com.sas.workspace.visuals.expression.Function;
import com.sas.workspace.visuals.expression.FunctionsModel;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class AbstractFunctionsModel
implements FunctionsModel {
    private Set m_setCategories = new TreeSet();
    private Category[] m_aCategories;
    private static final String CATEGORIES = "Categories";
    private static final String CATEGORY = "Category";
    private static final String NAME = "Name";
    private static final String DISPLAYNAME = "DisplayName";

    @Override
    public Category[] getCategories() {
        if (this.m_aCategories == null) {
            this.m_aCategories = this.m_setCategories.toArray(new Category[this.m_setCategories.size()]);
        }
        return this.m_aCategories;
    }

    @Override
    public Function[] getFunctions(Category category) {
        return category.getFunctions();
    }

    @Override
    public Function[] getAllFunctions() {
        ArrayList<Function> all = new ArrayList<Function>();
        Category[] aCategories = this.getCategories();
        for (int iCategory = 0; iCategory < aCategories.length; ++iCategory) {
            Function[] aFunctions = aCategories[iCategory].getFunctions();
            for (int iFunction = 0; iFunction < aFunctions.length; ++iFunction) {
                if (all.contains(aFunctions[iFunction])) {
                    Workspace.getDefaultLogger().debug("Duplicate removed from all: " + aFunctions[iFunction].getDisplayName());
                    continue;
                }
                all.add(aFunctions[iFunction]);
            }
        }
        Object[] aAll = all.toArray(new Function[all.size()]);
        Arrays.sort(aAll);
        return aAll;
    }

    protected Category acquireCategory(String sName, String sDisplayName) {
        Category category = this.findCategory(sName);
        if (category == null) {
            category = new BaseCategory(sName, sDisplayName);
            this.addCategory(category);
        }
        return category;
    }

    protected void addCategory(Category category) {
        this.m_setCategories.add(category);
        this.m_aCategories = null;
    }

    public Category findCategory(String sName) {
        for (Category category : this.m_setCategories) {
            if (!category.getName().equalsIgnoreCase(sName)) continue;
            return category;
        }
        return null;
    }

    public void clear() {
        this.m_setCategories.clear();
        this.m_aCategories = null;
    }

    public void saveXML(OutputStream strm) throws IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.newDocument();
            Element eleCategories = doc.createElement(CATEGORIES);
            doc.appendChild(eleCategories);
            Category[] aCategories = this.getCategories();
            for (int iCategory = 0; iCategory < aCategories.length; ++iCategory) {
                Category category = aCategories[iCategory];
                Element eleCategory = doc.createElement(CATEGORY);
                eleCategory.setAttribute(NAME, category.getName());
                eleCategory.setAttribute(DISPLAYNAME, category.getDisplayName());
                Function[] aFunctions = category.getFunctions();
                for (int iFunction = 0; iFunction < aFunctions.length; ++iFunction) {
                    eleCategory.appendChild(aFunctions[iFunction].saveToXML(doc));
                }
                eleCategories.appendChild(eleCategory);
            }
            this.saveDocument(doc, strm);
        }
        catch (ParserConfigurationException ex) {
            Workspace.getDefaultLogger().error((Object)"", ex);
        }
    }

    private void saveDocument(Document document, OutputStream strm) throws IOException {
        DOMSource domSource = new DOMSource(document);
        BufferedWriter fw = new BufferedWriter(new OutputStreamWriter(strm, "UTF-8"));
        StreamResult streamResult = new StreamResult(fw);
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.transform(domSource, streamResult);
            ((Writer)fw).flush();
            ((Writer)fw).close();
        }
        catch (TransformerConfigurationException ex) {
            IOException ioex = new IOException(ex.getLocalizedMessage());
            ioex.initCause(ex);
            throw ioex;
        }
        catch (TransformerFactoryConfigurationError ex) {
            IOException ioex = new IOException(ex.getLocalizedMessage());
            ioex.initCause(ex);
            throw ioex;
        }
        catch (TransformerException ex) {
            IOException ioex = new IOException(ex.getLocalizedMessage());
            ioex.initCause(ex);
            throw ioex;
        }
    }

    public void loadXML(InputStream strm) throws IOException {
        Document doc = this.loadDocument(strm);
        Element eleCategories = doc.getDocumentElement();
        if (!CATEGORIES.equalsIgnoreCase(eleCategories.getNodeName())) {
            return;
        }
        NodeList lCategories = eleCategories.getElementsByTagName(CATEGORY);
        for (int iCategory = 0; iCategory < lCategories.getLength(); ++iCategory) {
            Element eleCategory = (Element)lCategories.item(iCategory);
            String sCategoryName = eleCategory.getAttribute(NAME);
            String sCategoryDisplayName = eleCategory.getAttribute(DISPLAYNAME);
            if (sCategoryDisplayName.length() == 0) {
                sCategoryDisplayName = sCategoryName;
            }
            Category category = this.acquireCategory(sCategoryName, sCategoryDisplayName);
            NodeList lFunctions = eleCategory.getElementsByTagName("Function");
            for (int iFunction = 0; iFunction < lFunctions.getLength(); ++iFunction) {
                BaseFunction function = new BaseFunction();
                function.loadFromXML((Element)lFunctions.item(iFunction));
                function.setCategory(category);
                category.addFunction(function);
            }
        }
    }

    private Document loadDocument(InputStream strmXML) throws IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(strmXML);
        }
        catch (ParserConfigurationException ex) {
            IOException exception = new IOException(ex.getLocalizedMessage());
            exception.initCause(ex);
            throw exception;
        }
        catch (SAXException ex) {
            IOException exception = new IOException(ex.getLocalizedMessage());
            exception.initCause(ex);
            throw exception;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof FunctionsModel) {
            Category[] aCategories2;
            FunctionsModel mdl = (FunctionsModel)object;
            Category[] aCategories1 = this.getCategories();
            if (aCategories1.length != (aCategories2 = mdl.getCategories()).length) {
                return false;
            }
            for (int iCategory = 0; iCategory < aCategories1.length; ++iCategory) {
                if (aCategories1[iCategory].equals(aCategories2[iCategory])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashcode() {
        return super.hashCode();
    }
}

