/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals.dualselector;

import com.sas.swing.visuals.dualselector.BaseDualSelector;
import com.sas.swing.visuals.dualselector.DualSelectorInterface;
import com.sas.swing.visuals.dualselector.DualSelectorUpDownInterface;
import com.sas.util.JavaCollectionPermuter;
import com.sas.workspace.visuals.dualselector.SelectorTable;
import com.sas.workspace.visuals.dualselector.SelectorTableModel;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class JTableDualSelectorAdapter
implements DualSelectorInterface,
DualSelectorUpDownInterface,
DropTargetListener,
DragSourceListener,
DragGestureListener {
    private SelectorTableModel tableModel;
    protected JTable component;
    protected SelectorTable selector;
    protected JScrollPane containerComponent;
    protected JComponent parentSelector;
    public DropTarget dropTarget = null;
    public DragSource dragSource = null;

    public JTableDualSelectorAdapter(JTable table, JComponent parent) {
        if (!(table instanceof SelectorTable)) {
            throw new IllegalArgumentException("JTable must be an instance of SelectorTable");
        }
        this.component = table;
        this.selector = (SelectorTable)((Object)table);
        this.parentSelector = parent;
        this.containerComponent = new JScrollPane(table);
        this.tableModel = (SelectorTableModel)((Object)this.component.getModel());
        ((BaseDualSelector)this.parentSelector).setDragAndDropEnabled(false);
    }

    public void clearSelections() {
        this.component.clearSelection();
    }

    public int getCount() {
        return this.component.getModel().getRowCount();
    }

    public int getSelectedCount() {
        List list = this.getSelectedItems();
        return list.size();
    }

    public int getLastSelectedIndex() {
        int[] iaRows = this.selector.getSelectedRows();
        if (iaRows.length == 0) {
            return -1;
        }
        return iaRows[iaRows.length - 1];
    }

    public void setSelectedIndex(int index) {
        this.selector.setSelectedRow(index);
    }

    public void setSelectedIndices(int[] indices) {
        this.selector.setSelectedRows(indices);
    }

    public JComponent getComponent() {
        return this.component;
    }

    public JComponent getContainerComponent() {
        return this.containerComponent;
    }

    public List getSelectedItems() {
        this.tableModel = (SelectorTableModel)((Object)this.component.getModel());
        ArrayList<Object> selectedItems = new ArrayList<Object>();
        if (this.tableModel != null && this.tableModel.getRowCount() > 0) {
            int[] selectedIndexes = this.selector.getSelectedRows();
            int cnt = selectedIndexes.length;
            for (int i = 0; i < cnt; ++i) {
                try {
                    selectedItems.add(this.tableModel.getRow(selectedIndexes[i]));
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
        return selectedItems;
    }

    public List getAllItems() {
        this.tableModel = (SelectorTableModel)((Object)this.component.getModel());
        ArrayList<Object> allItems = new ArrayList<Object>();
        for (int i = 0; i < this.getCount(); ++i) {
            allItems.add(this.tableModel.getRow(i));
        }
        return allItems;
    }

    public List getAllMoveableItems() {
        return this.getAllItems();
    }

    public void addItems(List newItems) {
        this.tableModel = (SelectorTableModel)((Object)this.component.getModel());
        for (int i = 0; i < newItems.size(); ++i) {
            this.tableModel.addRow(newItems.get(i));
        }
    }

    public void removeItems(List removeItems) {
        this.tableModel = (SelectorTableModel)((Object)this.component.getModel());
        int size = removeItems.size();
        if (size == this.tableModel.getRowCount()) {
            this.tableModel.clear();
        } else {
            for (int i = 0; i < removeItems.size(); ++i) {
                this.tableModel.deleteRow(this.tableModel.indexOf(removeItems.get(i)));
            }
        }
    }

    public boolean isInAdapter(Object item) {
        this.tableModel = (SelectorTableModel)((Object)this.component.getModel());
        return this.tableModel.indexOf(item) != -1;
    }

    public int[] getSelectedIndices() {
        return this.selector.getSelectedRows();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveItems(int[] selectedIndices, int offset) {
        int i;
        ArrayList<Object> dataToMove = new ArrayList<Object>();
        this.tableModel = (SelectorTableModel)((Object)this.component.getModel());
        try {
            for (int iRow = 0; iRow < this.tableModel.getRowCount(); ++iRow) {
                dataToMove.add(this.tableModel.getRow(iRow));
            }
            if (selectedIndices.length == 1) {
                JavaCollectionPermuter.move(dataToMove, (int)selectedIndices[0], (int)offset);
            } else {
                JavaCollectionPermuter.move(dataToMove, (int[])selectedIndices, (int)offset);
            }
            i = 0;
            while (i < selectedIndices.length) {
                int n = i++;
                selectedIndices[n] = selectedIndices[n] + offset;
            }
            this.selector.setSelectedRows(selectedIndices);
        }
        catch (IllegalArgumentException i2) {
            for (int i3 = 0; i3 < dataToMove.size(); ++i3) {
                this.tableModel.setRow(dataToMove.get(i3), i3);
            }
        }
        finally {
            for (i = 0; i < dataToMove.size(); ++i) {
                this.tableModel.setRow(dataToMove.get(i), i);
            }
        }
    }

    public boolean isSelectedIndex(int index) {
        return this.component.isRowSelected(index);
    }

    public boolean canMove(int[] indices, int offset) {
        boolean returnValue = false;
        if (offset == -1 && !this.isSelectedIndex(0)) {
            returnValue = true;
        }
        if (offset == 1 && !this.isSelectedIndex(this.getCount() - 1)) {
            returnValue = true;
        }
        return returnValue;
    }

    @Override
    public void dragEnter(DropTargetDragEvent event) {
        if (((BaseDualSelector)this.parentSelector).isDragAndDropEnabled()) {
            event.acceptDrag(2);
        }
    }

    @Override
    public void dragExit(DropTargetEvent event) {
    }

    @Override
    public void dragOver(DropTargetDragEvent event) {
    }

    @Override
    public void drop(DropTargetDropEvent event) {
        if (((BaseDualSelector)this.parentSelector).isDragAndDropEnabled()) {
            // empty if block
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent event) {
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent event) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent event) {
        if (event.getDropSuccess()) {
            // empty if block
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent event) {
    }

    @Override
    public void dragExit(DragSourceEvent event) {
    }

    @Override
    public void dragOver(DragSourceDragEvent event) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent event) {
    }
}

