/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals;

import com.sas.editor.CodeEditor;
import com.sas.editor.LogListDocument;
import com.sas.editor.LogListHolder;
import com.sas.editor.LogListViewer;
import com.sas.editor.LogStorageConfigDataInterface;
import com.sas.editor.LogTemporaryRollingFileStorageConfigData;
import com.sas.iom.SAS.ILanguageServicePackage.CarriageControl;
import com.sas.iom.SAS.ILanguageServicePackage.CarriageControlSeqHolder;
import com.sas.iom.SAS.ILanguageServicePackage.LineType;
import com.sas.iom.SAS.ILanguageServicePackage.LineTypeSeqHolder;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsExternalDataPropertyTabInterface;
import com.sas.workspace.visuals.WsAbstractEditorPropertyTab;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.Action;

public class WsLogPropertyTab
extends WsAbstractEditorPropertyTab
implements WsExternalDataPropertyTabInterface {
    private static final long serialVersionUID = 1L;
    protected LogListViewer m_cmpLog;

    public WsLogPropertyTab(int eType) {
        super(eType);
    }

    @Override
    public void updateWorkspaceUIComponents(boolean bActive) {
        super.updateWorkspaceUIComponents(bActive);
        this.m_actSave.setActive(bActive);
        this.m_actSaveAs.setActive(bActive);
        this.m_actPrint.setActive(bActive);
        this.m_actPageSetup.setActive(bActive);
        this.m_actCopy.setActive(bActive);
        this.m_actSelectAll.setActive(bActive);
        this.m_actClear.setActive(bActive);
        this.m_actFindReplace.setActive(bActive);
    }

    @Override
    public void saveSettingsAndCleanUp() {
        super.removeActionsFromKeymap();
        if (this.m_cmpLog != null) {
            this.m_cmpLog.cleanup();
            this.m_cmpLog = null;
        }
        this.m_cmpEditor = null;
    }

    @Override
    public boolean getSaveContentsDefault() {
        return false;
    }

    public void appendText(LogListHolder hldrText) {
        this.m_cmpLog.append(hldrText);
    }

    @Override
    protected CodeEditor createEditor() {
        Workspace frmMain = Workspace.getWorkspace();
        LogListHolder hldrLog = new LogListHolder(new StringSeqHolder(new String[0]), new CarriageControlSeqHolder(new CarriageControl[0]), new LineTypeSeqHolder(new LineType[0]));
        this.m_cmpLog = new LogListViewer(this.m_eType, hldrLog, frmMain.getCodeEditorDefaults());
        try {
            LogTemporaryRollingFileStorageConfigData data = new LogTemporaryRollingFileStorageConfigData(60000, 10);
            ((LogListDocument)this.m_cmpLog.getEditorPane().getCodeEditorDocument()).setStorageParameters((LogStorageConfigDataInterface)data);
        }
        catch (IOException ex) {
            MessageUtil.displayMessage(ex.getLocalizedMessage(), 0);
        }
        this.m_cmpLog.enableHelp(false);
        this.setHelpTopic(this.m_cmpLog.getHelpTopic());
        this.setHelpProduct(this.m_cmpLog.getHelpProduct());
        return this.m_cmpLog;
    }

    @Override
    protected void createActions() {
        this.m_actSave = this.createSaveAction();
        this.m_actSaveAs = this.createSaveAsAction();
        this.m_actPrint = this.createPrintAction();
        this.m_actPageSetup = this.createPageSetupAction();
        this.m_actCopy = this.createCopyAction();
        this.m_actSelectAll = this.createSelectAllAction();
        this.m_actClear = this.createClearAction();
        this.m_actFindReplace = this.createFindReplaceAction();
        this.m_actPopupMenu = this.createPopupMenuAction();
    }

    @Override
    protected void updateActions() {
        this.m_actCopy.setEnabled(this.m_cmpEditor.canCopy());
        this.m_actSelectAll.setEnabled(this.m_cmpEditor.canSelectAll());
        this.m_actClear.setEnabled(this.m_cmpEditor.canClearAll());
    }

    @Override
    public boolean noSaveSaysDontWrite() {
        return false;
    }

    protected class cClearAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;
        Action m_actEditorClear;

        public cClearAction() {
            this.setHidable(true);
            this.setMenuSupportId("clear");
            this.m_actEditorClear = WsLogPropertyTab.this.m_cmpLog.getActionMap().get("clear-all");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.m_actEditorClear.actionPerformed(e);
        }
    }
}

